/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.exceptions.InvalidExpressionException;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.exceptions.UnsupportedTypeException;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class RecordRemoveFieldsTypeComputer
implements IResultTypeComputer {
    public static final RecordRemoveFieldsTypeComputer INSTANCE = new RecordRemoveFieldsTypeComputer();

    private RecordRemoveFieldsTypeComputer() {
    }

    private static void getPathFromConstantExpression(FunctionIdentifier funcId, ILogicalExpression fieldNameExpression, Set<String> fieldNameSet, List<List<String>> pathList, SourceLocation sourceLoc) throws AlgebricksException {
        ConstantExpression ce = (ConstantExpression)fieldNameExpression;
        if (!(ce.getValue() instanceof AsterixConstantValue)) {
            throw new InvalidExpressionException(sourceLoc, funcId, 1, (ILogicalExpression)ce, LogicalExpressionTag.CONSTANT);
        }
        IAObject fieldName = ((AsterixConstantValue)ce.getValue()).getObject();
        RecordRemoveFieldsTypeComputer.getPathOfFieldName(funcId, fieldName, fieldNameSet, pathList, sourceLoc);
    }

    private static void getPathOfFieldName(FunctionIdentifier funcId, IAObject fieldName, Set<String> fieldNameSet, List<List<String>> pathList, SourceLocation sourceLoc) throws UnsupportedTypeException {
        ATypeTag type = fieldName.getType().getTypeTag();
        switch (type) {
            case STRING: {
                String fn = ((AString)fieldName).getStringValue();
                fieldNameSet.add(fn);
                pathList.add(List.of(fn));
                break;
            }
            case ARRAY: {
                AOrderedList pathOrdereList = (AOrderedList)fieldName;
                fieldNameSet.add(((AString)pathOrdereList.getItem(0)).getStringValue());
                ArrayList<String> path = new ArrayList<String>();
                for (int i = 0; i < pathOrdereList.size(); ++i) {
                    path.add(((AString)pathOrdereList.getItem(i)).getStringValue());
                }
                pathList.add(path);
                break;
            }
            default: {
                throw new UnsupportedTypeException(sourceLoc, funcId, type);
            }
        }
    }

    private static List<String> getListFromExpression(FunctionIdentifier funcId, ILogicalExpression expression, SourceLocation sourceLoc) throws AlgebricksException {
        AbstractFunctionCallExpression funcExp = (AbstractFunctionCallExpression)expression;
        List args = funcExp.getArguments();
        ArrayList<String> list = new ArrayList<String>();
        for (Mutable arg : args) {
            ConstantExpression ce = (ConstantExpression)arg.getValue();
            if (!(ce.getValue() instanceof AsterixConstantValue)) {
                throw new InvalidExpressionException(sourceLoc, funcId, 1, (ILogicalExpression)ce, LogicalExpressionTag.CONSTANT);
            }
            IAObject item = ((AsterixConstantValue)ce.getValue()).getObject();
            ATypeTag type = item.getType().getTypeTag();
            if (type == ATypeTag.STRING) {
                list.add(((AString)item).getStringValue());
                continue;
            }
            throw new UnsupportedTypeException(sourceLoc, funcId, type);
        }
        return list;
    }

    private static void getPathFromFunctionExpression(FunctionIdentifier funcId, ILogicalExpression expression, Set<String> fieldNameSet, List<List<String>> pathList, SourceLocation sourceLoc) throws AlgebricksException {
        List<String> path = RecordRemoveFieldsTypeComputer.getListFromExpression(funcId, expression, sourceLoc);
        fieldNameSet.add(path.get(0));
        pathList.add(path);
    }

    private static void computeTypeFromExpression(FunctionIdentifier funcId, ILogicalExpression e, Set<String> fieldNameSet, List<List<String>> pathList) throws AlgebricksException {
        SourceLocation sourceLocation = e.getSourceLocation();
        if (e.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            AOrderedList list = (AOrderedList)((AsterixConstantValue)((ConstantExpression)e).getValue()).getObject();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                RecordRemoveFieldsTypeComputer.getPathOfFieldName(funcId, list.getItem(i), fieldNameSet, pathList, sourceLocation);
            }
        } else {
            AbstractFunctionCallExpression funcExp = (AbstractFunctionCallExpression)e;
            List args = funcExp.getArguments();
            block5: for (Mutable arg : args) {
                ILogicalExpression le = (ILogicalExpression)arg.getValue();
                switch (le.getExpressionTag()) {
                    case CONSTANT: {
                        RecordRemoveFieldsTypeComputer.getPathFromConstantExpression(funcId, le, fieldNameSet, pathList, sourceLocation);
                        continue block5;
                    }
                    case FUNCTION_CALL: {
                        RecordRemoveFieldsTypeComputer.getPathFromFunctionExpression(funcId, le, fieldNameSet, pathList, sourceLocation);
                        continue block5;
                    }
                }
                throw new InvalidExpressionException(sourceLocation, funcId, 1, le, LogicalExpressionTag.CONSTANT, LogicalExpressionTag.FUNCTION_CALL);
            }
        }
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        FunctionIdentifier funcId = funcExpr.getFunctionIdentifier();
        IAType type0 = (IAType)env.getType((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue());
        ArrayList<List<String>> pathList = new ArrayList<List<String>>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        ArrayDeque<String> fieldPathStack = new ArrayDeque<String>();
        ARecordType inputRecordType = RecordRemoveFieldsTypeComputer.getRecordTypeFromType(funcId, type0, funcExpr.getSourceLocation());
        if (inputRecordType == null) {
            return BuiltinType.ANY;
        }
        AbstractLogicalExpression arg1 = (AbstractLogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        IAType inputListType = (IAType)env.getType((ILogicalExpression)arg1);
        AOrderedListType inputOrderedListType = TypeComputeUtils.extractOrderedListType(inputListType);
        if (inputOrderedListType == null) {
            throw new TypeMismatchException(funcExpr.getSourceLocation(), funcId, 1, inputListType.getTypeTag(), ATypeTag.ARRAY);
        }
        ATypeTag tt = inputOrderedListType.getItemType().getTypeTag();
        if (tt == ATypeTag.STRING) {
            if (RecordRemoveFieldsTypeComputer.setFieldNameSet((ILogicalExpression)arg1, fieldNameSet)) {
                return RecordRemoveFieldsTypeComputer.buildOutputType(fieldPathStack, inputRecordType, fieldNameSet, pathList);
            }
            return DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
        }
        RecordRemoveFieldsTypeComputer.computeTypeFromExpression(funcId, (ILogicalExpression)arg1, fieldNameSet, pathList);
        return RecordRemoveFieldsTypeComputer.buildOutputType(fieldPathStack, inputRecordType, fieldNameSet, pathList);
    }

    private static boolean setFieldNameSet(ILogicalExpression expr, Set<String> fieldNameSet) {
        if (expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            AOrderedList orderedList = (AOrderedList)((AsterixConstantValue)((ConstantExpression)expr).getValue()).getObject();
            for (int i = 0; i < orderedList.size(); ++i) {
                AString as = (AString)orderedList.getItem(i);
                fieldNameSet.add(as.getStringValue());
            }
            return true;
        }
        return false;
    }

    private static void addField(ARecordType inputRecordType, String fieldName, List<String> resultFieldNames, List<IAType> resultFieldTypes) {
        resultFieldNames.add(fieldName);
        if (inputRecordType.getFieldType(fieldName).getTypeTag() == ATypeTag.OBJECT) {
            ARecordType nestedType = (ARecordType)inputRecordType.getFieldType(fieldName);
            resultFieldTypes.add(nestedType.deepCopy(nestedType));
        } else {
            resultFieldTypes.add(inputRecordType.getFieldType(fieldName));
        }
    }

    private static IAType buildOutputType(Deque<String> fieldPathStack, ARecordType inputRecordType, Set<String> fieldNameSet, List<List<String>> pathList) {
        ArrayList<String> resultFieldNames = new ArrayList<String>();
        ArrayList<IAType> resultFieldTypes = new ArrayList<IAType>();
        String[] fieldNames = inputRecordType.getFieldNames();
        IAType[] fieldTypes = inputRecordType.getFieldTypes();
        for (int i = 0; i < fieldNames.length; ++i) {
            IAType originalType = fieldTypes[i];
            IAType actualType = TypeComputeUtils.getActualType(originalType);
            if (!fieldNameSet.contains(fieldNames[i])) {
                RecordRemoveFieldsTypeComputer.addField(inputRecordType, fieldNames[i], resultFieldNames, resultFieldTypes);
                continue;
            }
            if (pathList.isEmpty() || actualType.getTypeTag() != ATypeTag.OBJECT) continue;
            ARecordType subRecord = (ARecordType)actualType;
            fieldPathStack.push(fieldNames[i]);
            subRecord = RecordRemoveFieldsTypeComputer.deepCheckAndCopy(fieldPathStack, subRecord, pathList, subRecord.isOpen());
            fieldPathStack.pop();
            if (subRecord == null) continue;
            resultFieldNames.add(fieldNames[i]);
            resultFieldTypes.add(RecordRemoveFieldsTypeComputer.wrapWithOriginalType(subRecord, originalType));
        }
        int n = resultFieldNames.size();
        String resultTypeName = "result-record(" + inputRecordType.getTypeName() + ")";
        return new ARecordType(resultTypeName, resultFieldNames.toArray(new String[n]), resultFieldTypes.toArray(new IAType[n]), true);
    }

    private static IAType wrapWithOriginalType(IAType typeToModify, IAType originalType) {
        if (TypeHelper.canBeMissing(originalType) && !TypeHelper.canBeNull(originalType)) {
            return AUnionType.createMissableType(typeToModify);
        }
        if (!TypeHelper.canBeMissing(originalType) && TypeHelper.canBeNull(originalType)) {
            return AUnionType.createNullableType(typeToModify);
        }
        if (TypeHelper.canBeUnknown(originalType)) {
            return AUnionType.createUnknownableType(typeToModify);
        }
        return typeToModify;
    }

    private static <E> boolean isEqualPaths(List<E> l1, Deque<E> l2) {
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<E> it2 = l2.iterator();
        int len = l1.size();
        for (int i = len - 1; i >= 0; --i) {
            E o2;
            E o1 = l1.get(i);
            if (o1.equals(o2 = it2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isRemovePath(Deque<String> fieldPath, List<List<String>> pathList) {
        for (List<String> removePath : pathList) {
            if (!RecordRemoveFieldsTypeComputer.isEqualPaths(removePath, fieldPath)) continue;
            return true;
        }
        return false;
    }

    private static ARecordType deepCheckAndCopy(Deque<String> fieldPath, ARecordType srcRecType, List<List<String>> pathList, boolean isOpen) {
        if (RecordRemoveFieldsTypeComputer.isRemovePath(fieldPath, pathList)) {
            return null;
        }
        String[] srcFieldNames = srcRecType.getFieldNames();
        IAType[] srcFieldTypes = srcRecType.getFieldTypes();
        ArrayList<IAType> destFieldTypes = new ArrayList<IAType>();
        ArrayList<String> destFieldNames = new ArrayList<String>();
        for (int i = 0; i < srcFieldNames.length; ++i) {
            fieldPath.push(srcFieldNames[i]);
            if (!RecordRemoveFieldsTypeComputer.isRemovePath(fieldPath, pathList)) {
                IAType originalType = srcFieldTypes[i];
                IAType actualType = TypeComputeUtils.getActualType(originalType);
                if (actualType.getTypeTag() == ATypeTag.OBJECT) {
                    ARecordType subRecord = (ARecordType)actualType;
                    if ((subRecord = RecordRemoveFieldsTypeComputer.deepCheckAndCopy(fieldPath, subRecord, pathList, isOpen)) != null) {
                        destFieldNames.add(srcFieldNames[i]);
                        destFieldTypes.add(RecordRemoveFieldsTypeComputer.wrapWithOriginalType(subRecord, originalType));
                    }
                } else {
                    destFieldNames.add(srcFieldNames[i]);
                    destFieldTypes.add(srcFieldTypes[i]);
                }
            }
            fieldPath.pop();
        }
        int n = destFieldNames.size();
        if (n == 0) {
            return null;
        }
        return new ARecordType(srcRecType.getTypeName(), destFieldNames.toArray(new String[n]), destFieldTypes.toArray(new IAType[n]), isOpen);
    }

    private static ARecordType getRecordTypeFromType(FunctionIdentifier funcId, IAType type0, SourceLocation sourceLoc) throws AlgebricksException {
        switch (type0.getTypeTag()) {
            case OBJECT: {
                return (ARecordType)type0;
            }
            case ANY: {
                return DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
            case UNION: {
                IAType t1 = ((AUnionType)type0).getActualType();
                if (t1.getTypeTag() == ATypeTag.OBJECT) {
                    return (ARecordType)t1;
                }
                if (t1.getTypeTag() != ATypeTag.ANY) break;
                return DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
        }
        throw new TypeMismatchException(sourceLoc, funcId, 0, type0.getTypeTag(), ATypeTag.OBJECT);
    }
}

