/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public abstract class AbstractRecordFunctionTypeComputer
implements IResultTypeComputer {
    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression functionCallExpression = (AbstractFunctionCallExpression)expression;
        ILogicalExpression arg0 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(0)).getValue();
        IAType type0 = (IAType)env.getType(arg0);
        IAType actualType0 = TypeComputeUtils.getActualType(type0);
        ATypeTag tag0 = actualType0.getTypeTag();
        if (tag0 == ATypeTag.ANY) {
            return AbstractRecordFunctionTypeComputer.wrapTypeWithUnknown(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, true, true);
        }
        if (tag0 == ATypeTag.MISSING) {
            return BuiltinType.AMISSING;
        }
        if (tag0 != ATypeTag.OBJECT) {
            return BuiltinType.ANULL;
        }
        boolean isOutputMissable = TypeHelper.canBeMissing(type0);
        boolean isOutputNullable = TypeHelper.canBeNull(type0);
        ARecordType inputRecordType = TypeComputeUtils.extractRecordType(actualType0);
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(1)).getValue();
        IAType type1 = (IAType)env.getType(arg1);
        IAType actualType1 = TypeComputeUtils.getActualType(type1);
        ATypeTag tag1 = actualType1.getTypeTag();
        if (tag1 == ATypeTag.ANY) {
            return AbstractRecordFunctionTypeComputer.wrapTypeWithUnknown(type0, true, true);
        }
        if (tag1 == ATypeTag.MISSING) {
            return BuiltinType.AMISSING;
        }
        if (tag1 != ATypeTag.STRING) {
            return BuiltinType.ANULL;
        }
        return this.computeTypeImpl(functionCallExpression, env, inputRecordType, isOutputMissable |= TypeHelper.canBeMissing(type1), isOutputNullable |= TypeHelper.canBeNull(type1));
    }

    protected abstract IAType computeTypeImpl(AbstractFunctionCallExpression var1, IVariableTypeEnvironment var2, ARecordType var3, boolean var4, boolean var5) throws AlgebricksException;

    protected static IAType wrapTypeWithUnknown(IAType originalType, boolean isMissable, boolean isNullable) {
        if (isNullable && isMissable) {
            return AUnionType.createUnknownableType(originalType);
        }
        if (isNullable) {
            return AUnionType.createNullableType(originalType);
        }
        if (isMissable) {
            return AUnionType.createMissableType(originalType);
        }
        return originalType;
    }
}

