/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.nio.ByteBuffer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.runtime.operators.LSMPrimaryUpsertOperatorNodePushable;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspector;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;

public class LSMSecondaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    protected static final int UPSERT_NEW = LSMPrimaryUpsertOperatorNodePushable.UPSERT_NEW.getByteValue();
    protected static final int UPSERT_EXISTING = LSMPrimaryUpsertOperatorNodePushable.UPSERT_EXISTING.getByteValue();
    protected static final int DELETE_EXISTING = LSMPrimaryUpsertOperatorNodePushable.DELETE_EXISTING.getByteValue();
    private final PermutingFrameTupleReference prevTuple = new PermutingFrameTupleReference();
    private final int numberOfFields;
    private final ITupleFilterFactory prevTupleFilterFactory;
    private ITupleFilter prevTupleFilter;
    protected final int operationFieldIndex;
    protected final IBinaryIntegerInspector operationInspector;
    protected AbstractIndexModificationOperationCallback abstractModCallback;

    public LSMSecondaryUpsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, ITupleFilterFactory tupleFilterFactory, ITupleFilterFactory prevTupleFilterFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, int operationFieldIndex, IBinaryIntegerInspectorFactory operationInspectorFactory, int[] prevTuplePermutation) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, tupleFilterFactory);
        this.prevTuple.setFieldPermutation(prevTuplePermutation);
        this.operationFieldIndex = operationFieldIndex;
        this.operationInspector = operationInspectorFactory.createBinaryIntegerInspector(ctx);
        this.numberOfFields = fieldPermutation.length;
        this.prevTupleFilterFactory = prevTupleFilterFactory;
    }

    public void open() throws HyracksDataException {
        super.open();
        this.frameTuple = new FrameTupleReference();
        this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
        if (this.prevTupleFilterFactory != null) {
            this.prevTupleFilter = this.prevTupleFilterFactory.createTupleFilter(this.ctx);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        int tupleCount = this.accessor.getTupleCount();
        boolean tupleFilterIsNull = this.tupleFilter == null;
        boolean prevTupleFilterIsNull = this.prevTupleFilter == null;
        for (int i = 0; i < tupleCount; ++i) {
            try {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                int operation = this.operationInspector.getIntegerValue(this.frameTuple.getFieldData(this.operationFieldIndex), this.frameTuple.getFieldStart(this.operationFieldIndex), this.frameTuple.getFieldLength(this.operationFieldIndex));
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                this.prevTuple.reset((IFrameTupleAccessor)this.accessor, i);
                if (operation == UPSERT_NEW) {
                    if (!tupleFilterIsNull && !this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                    this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.INSERT);
                    lsmAccessor.forceInsert((ITupleReference)this.tuple);
                    continue;
                }
                if (operation == UPSERT_EXISTING) {
                    if (TupleUtils.equalTuples((ITupleReference)this.tuple, (ITupleReference)this.prevTuple, (int)this.numberOfFields)) continue;
                    if (prevTupleFilterIsNull || this.prevTupleFilter.accept((IFrameTupleReference)this.frameTuple)) {
                        this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                        lsmAccessor.forceDelete((ITupleReference)this.prevTuple);
                    }
                    if (!tupleFilterIsNull && !this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                    this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.INSERT);
                    lsmAccessor.forceInsert((ITupleReference)this.tuple);
                    continue;
                }
                if (operation != DELETE_EXISTING || !prevTupleFilterIsNull && !this.prevTupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                lsmAccessor.forceDelete((ITupleReference)this.prevTuple);
                continue;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    private static boolean isNullOrMissing(FrameTupleReference tuple, int fieldIdx) {
        return TypeTagUtil.isType((ITupleReference)tuple, (int)fieldIdx, (byte)ATypeTag.SERIALIZED_NULL_TYPE_TAG) || TypeTagUtil.isType((ITupleReference)tuple, (int)fieldIdx, (byte)ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
    }

    protected static boolean hasNullOrMissing(FrameTupleReference tuple) {
        int fieldCount = tuple.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (!LSMSecondaryUpsertOperatorNodePushable.isNullOrMissing(tuple, i)) continue;
            return true;
        }
        return false;
    }

    public void flush() throws HyracksDataException {
    }
}

