/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.adapter.factory.GenericAdapterFactory;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.parser.factory.ADMDataParserFactory;
import org.apache.asterix.metadata.api.IDatasourceFunction;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.FunctionDataSourceFactory;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public abstract class FunctionDataSource
extends DataSource {
    protected final FunctionIdentifier functionId;

    public FunctionDataSource(DataSourceId id, FunctionIdentifier functionId, INodeDomain domain, IAType itemType) throws AlgebricksException {
        super(id, itemType, null, (byte)4, domain);
        this.functionId = functionId;
        this.initSchemaType(itemType);
    }

    public FunctionDataSource(DataSourceId id, FunctionIdentifier functionId, INodeDomain domain) throws AlgebricksException {
        this(id, functionId, domain, (IAType)RecordUtil.FULLY_OPEN_RECORD_TYPE);
    }

    protected void initSchemaType(IAType itemType) {
        this.schemaTypes = new IAType[]{itemType};
    }

    public FunctionIdentifier getFunctionId() {
        return this.functionId;
    }

    public boolean isScanAccessPathALeaf() {
        return true;
    }

    @Override
    public IDataSourcePropertiesProvider getPropertiesProvider() {
        return scanVariables -> new StructuralPropertiesVector((IPartitioningProperty)new RandomPartitioningProperty(this.domain), Collections.emptyList());
    }

    @Override
    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionInfo<?> projectionInfo) throws AlgebricksException {
        GenericAdapterFactory adapterFactory = new GenericAdapterFactory();
        adapterFactory.setOutputType(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        IClusterStateManager csm = metadataProvider.getApplicationContext().getClusterStateManager();
        FunctionDataSourceFactory factory = new FunctionDataSourceFactory(this.createFunction(metadataProvider, this.getLocations(csm)));
        IDataParserFactory dataParserFactory = this.createDataParserFactory();
        dataParserFactory.setRecordType(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        dataParserFactory.configure(Collections.emptyMap());
        adapterFactory.configure((IExternalDataSourceFactory)factory, dataParserFactory);
        return metadataProvider.buildExternalDatasetDataScannerRuntime(jobSpec, this.itemType, (ITypedAdapterFactory)adapterFactory, tupleFilterFactory, outputLimit);
    }

    public boolean skipJobCapacityAssignment() {
        return false;
    }

    protected abstract IDatasourceFunction createFunction(MetadataProvider var1, AlgebricksAbsolutePartitionConstraint var2);

    protected AlgebricksAbsolutePartitionConstraint getLocations(IClusterStateManager csm) {
        String[] sortedLocations = csm.getSortedClusterLocations().getLocations();
        return new AlgebricksAbsolutePartitionConstraint((String[])Arrays.stream(sortedLocations).distinct().toArray(String[]::new));
    }

    protected IDataParserFactory createDataParserFactory() {
        return new ADMDataParserFactory();
    }

    protected static DataSourceId createDataSourceId(FunctionIdentifier fid, String ... parameters) {
        return new DataSourceId(FunctionSignature.getDataverseName((FunctionIdentifier)fid), fid.getName(), parameters);
    }
}

