/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.cost;

import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.ICostMethods;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;

public class CostMethods
implements ICostMethods {
    protected IOptimizationContext optCtx;
    protected PhysicalOptimizationConfig physOptConfig;
    protected long blockSize;
    protected long DOP;
    protected double maxMemorySize;

    public CostMethods(IOptimizationContext context) {
        this.optCtx = context;
        this.physOptConfig = context.getPhysicalOptimizationConfig();
        this.blockSize = this.getBufferCachePageSize();
        this.DOP = this.getDOP();
        this.maxMemorySize = this.getMaxMemorySize();
    }

    public long getBufferCacheSize() {
        MetadataProvider metadataProvider = (MetadataProvider)this.optCtx.getMetadataProvider();
        return metadataProvider.getStorageProperties().getBufferCacheSize();
    }

    public long getBufferCachePageSize() {
        MetadataProvider metadataProvider = (MetadataProvider)this.optCtx.getMetadataProvider();
        return metadataProvider.getStorageProperties().getBufferCachePageSize();
    }

    public long getDOP() {
        return this.optCtx.getComputationNodeDomain().cardinality().intValue();
    }

    public double getMaxMemorySize() {
        return this.physOptConfig.getMaxFramesForJoin() * this.physOptConfig.getFrameSize();
    }

    @Override
    public Cost costFullScan(JoinNode jn) {
        return new Cost(jn.computeJoinCardinality());
    }

    @Override
    public Cost costIndexScan(JoinNode jn) {
        return new Cost(jn.computeJoinCardinality());
    }

    @Override
    public Cost costHashJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.computeJoinCardinality() + rightJn.computeJoinCardinality());
    }

    public Cost computeHJProbeExchangeCost(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        return new Cost(leftJn.computeJoinCardinality());
    }

    public Cost computeHJBuildExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost(rightJn.computeJoinCardinality());
    }

    @Override
    public Cost costBroadcastHashJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.computeJoinCardinality() + (double)this.DOP * rightJn.computeJoinCardinality());
    }

    public Cost computeBHJBuildExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost((double)this.DOP * rightJn.computeJoinCardinality());
    }

    @Override
    public Cost costIndexNLJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.computeJoinCardinality());
    }

    public Cost computeNLJOuterExchangeCost(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        return new Cost((double)this.DOP * leftJn.computeJoinCardinality());
    }

    @Override
    public Cost costCartesianProductJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.computeJoinCardinality() * rightJn.computeJoinCardinality());
    }

    public Cost computeCPRightExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost((double)this.DOP * rightJn.computeJoinCardinality());
    }
}

