/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractUnaryNumericFunctionEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;

@MissingNullInOutFunction
public class NumericSignDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = NumericSignDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_SIGN;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new NumericSignEvaluator(ctx, args[0]);
            }
        };
    }

    private class NumericSignEvaluator
    extends AbstractUnaryNumericFunctionEval {
        NumericSignEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory argEvalFactory) throws HyracksDataException {
            super(context, argEvalFactory, NumericSignDescriptor.this.getIdentifier(), NumericSignDescriptor.this.sourceLoc);
        }

        @Override
        protected void processInt8(byte arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0 ? (byte)(arg > 0 ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processInt16(short arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0 ? (byte)(arg > 0 ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processInt32(int arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0 ? (byte)(arg > 0 ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processInt64(long arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0L ? (byte)(arg > 0L ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processFloat(float arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0.0f ? (byte)(arg > 0.0f ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processDouble(double arg, IPointable resultPointable) throws HyracksDataException {
            this.aInt8.setValue(arg >= 0.0 ? (byte)(arg > 0.0 ? 1 : 0) : (byte)-1);
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }
    }
}

