/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class GetTypeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = GetTypeDescriptor::new;
    private static final long serialVersionUID = 1L;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput dataOutput = this.resultStorage.getDataOutput();
                    private IScalarEvaluator inputEval;
                    private final IPointable inputArg;
                    private final UTF8StringWriter writer;
                    {
                        this.inputEval = args[0].createScalarEvaluator(ctx);
                        this.inputArg = new VoidPointable();
                        this.writer = new UTF8StringWriter();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.inputEval.evaluate(tuple, this.inputArg);
                        try {
                            byte[] bytes = this.inputArg.getByteArray();
                            int offset = this.inputArg.getStartOffset();
                            this.dataOutput.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.writer.writeUTF8((CharSequence)ATypeTag.VALUE_TYPE_MAPPING[bytes[offset]].toString(), this.dataOutput);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.GET_TYPE;
    }
}

