/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.ATime;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractTimeConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableTime aTime = new AMutableTime(0);
    private final ISerializerDeserializer<ATime> timeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();
    private final GregorianCalendarSystem cal = GregorianCalendarSystem.getInstance();

    protected AbstractTimeConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case TIME: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case DATETIME: {
                long chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                int chrononTime = this.cal.getTimeChronon(chronon);
                this.aTime.setValue(chrononTime);
                this.resultStorage.reset();
                this.timeSerde.serialize((Object)this.aTime, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (this.parseTime(this.utf8Ptr, this.aTime)) {
                    this.resultStorage.reset();
                    this.timeSerde.serialize((Object)this.aTime, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    protected boolean parseTime(UTF8StringPointable textPtr, AMutableTime result) {
        int stringLength = textPtr.getUTF8Length();
        if (stringLength < 6) {
            return false;
        }
        try {
            int chronon = ATimeParserFactory.parseTimePart((byte[])textPtr.getByteArray(), (int)textPtr.getCharStartOffset(), (int)stringLength);
            if (chronon < 0) {
                chronon = (int)((long)chronon + 86400000L);
            }
            result.setValue(chronon);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.ATIME;
    }
}

