/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.optimizer.rules.am.array.IIntroduceAccessMethodRuleLocalRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;

public class MergedSelectRewrite
implements IIntroduceAccessMethodRuleLocalRewrite<SelectOperator> {
    private final Set<Mutable<ILogicalExpression>> selectConjuncts = new LinkedHashSet<Mutable<ILogicalExpression>>();
    private final Deque<SelectOperator> selectRootStack = new ArrayDeque<SelectOperator>();
    private Mutable<ILogicalOperator> originalDataSourceRef;

    @Override
    public SelectOperator createOperator(SelectOperator originalOperator, IOptimizationContext context) throws AlgebricksException {
        this.selectConjuncts.clear();
        ArrayList<Mutable> thisSelectConjuncts = new ArrayList<Mutable>();
        if (!((ILogicalExpression)originalOperator.getCondition().getValue()).splitIntoConjuncts(thisSelectConjuncts)) {
            thisSelectConjuncts.add(originalOperator.getCondition());
        }
        this.selectConjuncts.addAll(thisSelectConjuncts);
        this.selectRootStack.push(originalOperator);
        if (!this.collectSelectConjuncts((Mutable<ILogicalOperator>)((Mutable)originalOperator.getInputs().get(0)))) {
            return null;
        }
        if (thisSelectConjuncts.size() == this.selectConjuncts.size()) {
            return null;
        }
        ScalarFunctionCallExpression andCond = new ScalarFunctionCallExpression(context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND));
        andCond.setSourceLocation(originalOperator.getSourceLocation());
        for (Mutable<ILogicalExpression> conjunct : this.selectConjuncts) {
            andCond.getArguments().add(conjunct);
        }
        SelectOperator newSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)andCond), originalOperator.getRetainMissingAsValue(), originalOperator.getMissingPlaceholderVariable());
        newSelectOperator.setSourceLocation(originalOperator.getSourceLocation());
        ILogicalPlan newSelectInputPlan = OperatorManipulationUtil.deepCopy((ILogicalPlan)new ALogicalPlanImpl((Mutable)originalOperator.getInputs().get(0)), (IOptimizationContext)context);
        newSelectOperator.getInputs().add((Mutable)newSelectInputPlan.getRoots().get(0));
        this.removeSelectsFromPlan((ILogicalOperator)newSelectOperator, (Mutable<ILogicalOperator>)((Mutable)newSelectInputPlan.getRoots().get(0)));
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)newSelectOperator, (ITypingContext)context);
        return newSelectOperator;
    }

    @Override
    public SelectOperator restoreBeforeRewrite(List<Mutable<ILogicalOperator>> afterOperatorRefs, IOptimizationContext context) throws AlgebricksException {
        return this.selectRootStack.pop();
    }

    private boolean collectSelectConjuncts(Mutable<ILogicalOperator> workingOp) {
        switch (((ILogicalOperator)workingOp.getValue()).getOperatorTag()) {
            case DATASOURCESCAN: 
            case EMPTYTUPLESOURCE: 
            case UNNEST_MAP: {
                this.originalDataSourceRef = workingOp;
                break;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                return false;
            }
            case SELECT: {
                SelectOperator selectOperator = (SelectOperator)workingOp.getValue();
                ArrayList<Mutable> thisSelectConjuncts = new ArrayList<Mutable>();
                if (!((ILogicalExpression)selectOperator.getCondition().getValue()).splitIntoConjuncts(thisSelectConjuncts)) {
                    thisSelectConjuncts.add(selectOperator.getCondition());
                }
                this.selectConjuncts.addAll(thisSelectConjuncts);
            }
            default: {
                for (Mutable input : ((ILogicalOperator)workingOp.getValue()).getInputs()) {
                    if (this.collectSelectConjuncts((Mutable<ILogicalOperator>)input)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void removeSelectsFromPlan(ILogicalOperator parentOp, Mutable<ILogicalOperator> workingOp) {
        Mutable workingOpInParent = (Mutable)parentOp.getInputs().stream().filter(i -> i.equals(workingOp)).collect(Collectors.toList()).get(0);
        int indexOfWorkingOpInParent = parentOp.getInputs().indexOf(workingOpInParent);
        switch (((ILogicalOperator)workingOp.getValue()).getOperatorTag()) {
            case DATASOURCESCAN: 
            case EMPTYTUPLESOURCE: 
            case UNNEST_MAP: {
                parentOp.getInputs().set(indexOfWorkingOpInParent, this.originalDataSourceRef);
                break;
            }
            case SELECT: {
                parentOp.getInputs().set(indexOfWorkingOpInParent, (Mutable)((ILogicalOperator)workingOp.getValue()).getInputs().get(0));
            }
            default: {
                for (Mutable input : ((ILogicalOperator)workingOp.getValue()).getInputs()) {
                    this.removeSelectsFromPlan((ILogicalOperator)workingOp.getValue(), (Mutable<ILogicalOperator>)input);
                }
            }
        }
    }
}

