/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.common.storage.ICompressionManager;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.external.adapter.factory.ExternalAdapterFactory;
import org.apache.asterix.external.adapter.factory.LookupAdapterFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalBTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalLookupOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalRTreeSearchOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.LinearizeComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.ICCExtensionManager;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.FileSplitDataSink;
import org.apache.asterix.metadata.declared.FileSplitSinkId;
import org.apache.asterix.metadata.declared.MetadataManagerUtil;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.FullTextUtil;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.metadata.utils.SplitsAndConstraintsUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionExtensionManager;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.operators.LSMIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMPrimaryInsertOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertWithNestedPlanOperatorDescriptor;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntimeFactory;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeBatchPointSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.common.IStorageManager;

public class MetadataProvider
implements IMetadataProvider<DataSourceId, String> {
    private final ICcApplicationContext appCtx;
    private final IStorageComponentProvider storageComponentProvider;
    private final StorageProperties storageProperties;
    private final IFunctionManager functionManager;
    private final LockList locks;
    private final Map<String, Object> config;
    private Dataverse defaultDataverse;
    private MetadataTransactionContext mdTxnCtx;
    private boolean isWriteTransaction;
    private IAWriterFactory writerFactory;
    private FileSplit outputFile;
    private boolean asyncResults;
    private long maxResultReads;
    private ResultSetId resultSetId;
    private IResultSerializerFactoryProvider resultSerializerFactoryProvider;
    private TxnId txnId;
    private Map<String, Integer> externalDataLocks;
    private boolean blockingOperatorDisabled = false;

    public static MetadataProvider create(ICcApplicationContext appCtx, Dataverse defaultDataverse) {
        java.util.function.Function<ICcApplicationContext, IMetadataProvider<?, ?>> factory = ((ICCExtensionManager)appCtx.getExtensionManager()).getMetadataProviderFactory();
        MetadataProvider mp = factory != null ? (MetadataProvider)factory.apply(appCtx) : new MetadataProvider(appCtx);
        mp.setDefaultDataverse(defaultDataverse);
        return mp;
    }

    protected MetadataProvider(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.storageComponentProvider = appCtx.getStorageComponentProvider();
        this.storageProperties = appCtx.getStorageProperties();
        this.functionManager = ((IFunctionExtensionManager)appCtx.getExtensionManager()).getFunctionManager();
        this.locks = new LockList();
        this.config = new HashMap<String, Object>();
    }

    public <T> T getProperty(String name) {
        return (T)this.config.get(name);
    }

    public void setProperty(String name, Object value) {
        this.config.put(name, value);
    }

    public <T> T removeProperty(String name) {
        return (T)this.config.remove(name);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object v = this.config.get(name);
        return v != null ? Boolean.parseBoolean(String.valueOf(v)) : defaultValue;
    }

    public void disableBlockingOperator() {
        this.blockingOperatorDisabled = true;
    }

    public boolean isBlockingOperatorDisabled() {
        return this.blockingOperatorDisabled;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setTxnId(TxnId txnId) {
        this.txnId = txnId;
    }

    public void setDefaultDataverse(Dataverse defaultDataverse) {
        this.defaultDataverse = defaultDataverse == null ? MetadataBuiltinEntities.DEFAULT_DATAVERSE : defaultDataverse;
    }

    public Dataverse getDefaultDataverse() {
        return this.defaultDataverse;
    }

    public DataverseName getDefaultDataverseName() {
        return this.defaultDataverse.getDataverseName();
    }

    public void setWriteTransaction(boolean writeTransaction) {
        this.isWriteTransaction = writeTransaction;
    }

    public void setWriterFactory(IAWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void setMetadataTxnContext(MetadataTransactionContext mdTxnCtx) {
        this.mdTxnCtx = mdTxnCtx;
    }

    public MetadataTransactionContext getMetadataTxnContext() {
        return this.mdTxnCtx;
    }

    public IAWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getResultAsyncMode() {
        return this.asyncResults;
    }

    public void setResultAsyncMode(boolean asyncResults) {
        this.asyncResults = asyncResults;
    }

    public void setMaxResultReads(long maxResultReads) {
        this.maxResultReads = maxResultReads;
    }

    public long getMaxResultReads() {
        return this.maxResultReads;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(ResultSetId resultSetId) {
        this.resultSetId = resultSetId;
    }

    public void setResultSerializerFactoryProvider(IResultSerializerFactoryProvider rafp) {
        this.resultSerializerFactoryProvider = rafp;
    }

    public IResultSerializerFactoryProvider getResultSerializerFactoryProvider() {
        return this.resultSerializerFactoryProvider;
    }

    public boolean isWriteTransaction() {
        return this.isWriteTransaction;
    }

    public IFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public IDataFormat getDataFormat() {
        return FormatUtils.getDefaultFormat();
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public Map<String, Integer> getExternalDataLocks() {
        return this.externalDataLocks;
    }

    public void setExternalDataLocks(Map<String, Integer> locks) {
        this.externalDataLocks = locks;
    }

    private DataverseName getActiveDataverseName(DataverseName dataverseName) {
        return dataverseName != null ? dataverseName : (this.defaultDataverse != null ? this.defaultDataverse.getDataverseName() : null);
    }

    public ARecordType findOutputRecordType() throws AlgebricksException {
        return MetadataManagerUtil.findOutputRecordType(this.mdTxnCtx, this.getDefaultDataverseName(), (String)this.getProperty("output-record-type"));
    }

    public Dataset findDataset(DataverseName dataverseName, String datasetName) throws AlgebricksException {
        DataverseName dvName = this.getActiveDataverseName(dataverseName);
        if (dvName == null) {
            return null;
        }
        this.appCtx.getMetadataLockManager().acquireDataverseReadLock(this.locks, dvName);
        this.appCtx.getMetadataLockManager().acquireDatasetReadLock(this.locks, dvName, datasetName);
        return MetadataManagerUtil.findDataset(this.mdTxnCtx, dvName, datasetName);
    }

    public INodeDomain findNodeDomain(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodeDomain(this.appCtx.getClusterStateManager(), this.mdTxnCtx, nodeGroupName);
    }

    public List<String> findNodes(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodes(this.mdTxnCtx, nodeGroupName);
    }

    public Datatype findTypeEntity(DataverseName dataverseName, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findTypeEntity(this.mdTxnCtx, dataverseName, typeName);
    }

    public IAType findType(DataverseName dataverseName, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findType(this.mdTxnCtx, dataverseName, typeName);
    }

    public IAType findType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
    }

    public IAType findMetaType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
    }

    public Feed findFeed(DataverseName dataverseName, String feedName) throws AlgebricksException {
        return MetadataManagerUtil.findFeed(this.mdTxnCtx, dataverseName, feedName);
    }

    public FeedConnection findFeedConnection(DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedConnection(this.mdTxnCtx, dataverseName, feedName, datasetName);
    }

    public FeedPolicyEntity findFeedPolicy(DataverseName dataverseName, String policyName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedPolicy(this.mdTxnCtx, dataverseName, policyName);
    }

    public DataSource findDataSource(DataSourceId id) throws AlgebricksException {
        return MetadataManagerUtil.findDataSource(this.appCtx.getClusterStateManager(), this.mdTxnCtx, id);
    }

    public DataSource lookupSourceInMetadata(DataSourceId aqlId) throws AlgebricksException {
        return MetadataManagerUtil.lookupSourceInMetadata(this.appCtx.getClusterStateManager(), this.mdTxnCtx, aqlId);
    }

    public IDataSourceIndex<String, DataSourceId> findDataSourceIndex(String indexId, DataSourceId dataSourceId) throws AlgebricksException {
        DataSource source = this.findDataSource(dataSourceId);
        Dataset dataset = ((DatasetDataSource)source).getDataset();
        Index secondaryIndex = this.getIndex(dataset.getDataverseName(), dataset.getDatasetName(), indexId);
        return secondaryIndex != null ? new DataSourceIndex(secondaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this) : null;
    }

    public Index getIndex(DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataverseName, datasetName, indexName);
    }

    public List<Index> getDatasetIndexes(DataverseName dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.getDatasetIndexes(this.mdTxnCtx, dataverseName, datasetName);
    }

    public Triple<DataverseName, String, Boolean> resolveDatasetNameUsingSynonyms(DataverseName dataverseName, String datasetName) throws AlgebricksException {
        DataverseName dvName = this.getActiveDataverseName(dataverseName);
        if (dvName == null) {
            return null;
        }
        Synonym synonym = null;
        while (MetadataManagerUtil.findDataset(this.mdTxnCtx, dvName, datasetName) == null) {
            synonym = this.findSynonym(dvName, datasetName);
            if (synonym == null) {
                return null;
            }
            dvName = synonym.getObjectDataverseName();
            datasetName = synonym.getObjectName();
        }
        return new Triple((Object)dvName, (Object)datasetName, (Object)(synonym != null ? 1 : 0));
    }

    public Synonym findSynonym(DataverseName dataverseName, String synonymName) throws AlgebricksException {
        return MetadataManagerUtil.findSynonym(this.mdTxnCtx, dataverseName, synonymName);
    }

    public FullTextConfigMetadataEntity findFullTextConfig(DataverseName dataverseName, String ftConfigName) throws AlgebricksException {
        return MetadataManagerUtil.findFullTextConfigDescriptor(this.mdTxnCtx, dataverseName, ftConfigName);
    }

    public FullTextFilterMetadataEntity findFullTextFilter(DataverseName dataverseName, String ftFilterName) throws AlgebricksException {
        return MetadataManagerUtil.findFullTextFilterDescriptor(this.mdTxnCtx, dataverseName, ftFilterName);
    }

    public IFunctionInfo lookupFunction(FunctionIdentifier fid) {
        return BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fid);
    }

    public Function lookupUserDefinedFunction(FunctionSignature signature) throws AlgebricksException {
        if (signature.getDataverseName() == null) {
            return null;
        }
        return MetadataManager.INSTANCE.getFunction(this.mdTxnCtx, signature);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionInfo<?> projectionInfo) throws AlgebricksException {
        return ((DataSource)dataSource).buildDatasourceScanRuntime(this, dataSource, scanVariables, projectVariables, projectPushed, minFilterVars, maxFilterVars, tupleFilterFactory, outputLimit, opSchema, typeEnv, context, jobSpec, implConfig, projectionInfo);
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildLoadableDatasetScan(JobSpecification jobSpec, ITypedAdapterFactory adapterFactory, RecordDescriptor rDesc) throws AlgebricksException {
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, rDesc, adapterFactory);
        try {
            return new Pair((Object)dataScanner, (Object)adapterFactory.getPartitionConstraint());
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Dataverse findDataverse(DataverseName dataverseName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, dataverseName);
    }

    public Triple<IOperatorDescriptor, AlgebricksPartitionConstraint, ITypedAdapterFactory> buildFeedIntakeRuntime(JobSpecification jobSpec, Feed feed, FeedPolicyAccessor policyAccessor) throws Exception {
        Triple<ITypedAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> factoryOutput = FeedMetadataUtil.getFeedFactoryAndOutput(feed, policyAccessor, this.mdTxnCtx, this.getApplicationContext());
        ARecordType recordType = FeedMetadataUtil.getOutputType(feed, feed.getConfiguration().get("type-name"));
        ITypedAdapterFactory adapterFactory = (ITypedAdapterFactory)factoryOutput.first;
        FeedIntakeOperatorDescriptor feedIngestor = null;
        switch ((IDataSourceAdapter.AdapterType)factoryOutput.third) {
            case INTERNAL: {
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, adapterFactory, recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
            case EXTERNAL: {
                ExternalAdapterFactory extAdapterFactory = (ExternalAdapterFactory)adapterFactory;
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, extAdapterFactory.getLibraryDataverse(), extAdapterFactory.getLibraryName(), extAdapterFactory.getClassName(), recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
        }
        AlgebricksAbsolutePartitionConstraint partitionConstraint = adapterFactory.getPartitionConstraint();
        return new Triple(feedIngestor, (Object)partitionConstraint, (Object)adapterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildBtreeRuntime(JobSpecification jobSpec, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, boolean propagateFilter, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, ITupleFilterFactory tupleFilterFactory, long outputLimit, boolean isIndexOnlyPlan, boolean isPrimaryIndexPointSearch) throws AlgebricksException {
        boolean proceedIndexOnlyPlan;
        int numSecondaryKeys;
        boolean isSecondary = true;
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        if (primaryIndex != null && dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
            isSecondary = !indexName.equals(primaryIndex.getIndexName());
        }
        Index theIndex = isSecondary ? MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName) : primaryIndex;
        switch (theIndex.getIndexType()) {
            case ARRAY: {
                numSecondaryKeys = ((Index.ArrayIndexDetails)theIndex.getIndexDetails()).getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum);
                break;
            }
            case BTREE: {
                numSecondaryKeys = ((Index.ValueIndexDetails)theIndex.getIndexDetails()).getKeyFieldNames().size();
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{theIndex.getIndexType().toString()});
            }
        }
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.getSplitProviderAndConstraints(dataset, theIndex.getIndexName());
        int[] primaryKeyFields = new int[numPrimaryKeys];
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        int[] primaryKeyFieldsInSecondaryIndex = null;
        byte[] successValueForIndexOnlyPlan = null;
        byte[] failValueForIndexOnlyPlan = null;
        boolean bl = proceedIndexOnlyPlan = isIndexOnlyPlan && isSecondary;
        if (proceedIndexOnlyPlan) {
            primaryKeyFieldsInSecondaryIndex = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFieldsInSecondaryIndex[i] = i + numSecondaryKeys;
            }
            failValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)0);
            successValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)1);
        }
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, theIndex, IndexOperation.SEARCH, primaryKeyFields, primaryKeyFieldsInSecondaryIndex, proceedIndexOnlyPlan);
        IStorageManager storageManager = this.getStorageComponentProvider().getStorageManager();
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(storageManager, (IFileSplitProvider)spPc.first);
        Object btreeSearchOp = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? (!isSecondary && isPrimaryIndexPointSearch ? new LSMBTreeBatchPointSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, tupleFilterFactory, outputLimit) : new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter, tupleFilterFactory, outputLimit, proceedIndexOnlyPlan, failValueForIndexOnlyPlan, successValueForIndexOnlyPlan)) : new ExternalBTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
        return new Pair(btreeSearchOp, (Object)((AlgebricksPartitionConstraint)spPc.second));
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildRtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, Dataset dataset, String indexName, int[] keyFields, boolean propagateFilter, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, boolean isIndexOnlyPlan) throws AlgebricksException {
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        if (secondaryIndex == null) {
            throw new AlgebricksException("Code generation error: no index " + indexName + " for " + IdentifierUtil.dataset() + " " + dataset.getDatasetName());
        }
        Index.ValueIndexDetails secondaryIndexDetails = (Index.ValueIndexDetails)secondaryIndex.getIndexDetails();
        RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
        int[] primaryKeyFields = new int[numPrimaryKeys];
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        int[] primaryKeyFieldsInSecondaryIndex = null;
        byte[] successValueForIndexOnlyPlan = null;
        byte[] failValueForIndexOnlyPlan = null;
        if (isIndexOnlyPlan) {
            ARecordType recType = (ARecordType)this.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
            List<List<String>> secondaryKeyFields = secondaryIndexDetails.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndexDetails.getKeyFieldTypes();
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyFields.get(0), recType);
            IAType keyType = (IAType)keyTypePair.first;
            int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag());
            int numNestedSecondaryKeyFields = numDimensions * 2;
            primaryKeyFieldsInSecondaryIndex = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFieldsInSecondaryIndex[i] = i + numNestedSecondaryKeyFields;
            }
            failValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)0);
            successValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)1);
        }
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, secondaryIndex, IndexOperation.SEARCH, primaryKeyFields, primaryKeyFieldsInSecondaryIndex, isIndexOnlyPlan);
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)spPc.first);
        Object rtreeSearchOp = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? new RTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, keyFields, true, true, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter, isIndexOnlyPlan, failValueForIndexOnlyPlan, successValueForIndexOnlyPlan) : new ExternalRTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, keyFields, true, true, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, context.getMissingWriterFactory(), searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
        return new Pair(rtreeSearchOp, (Object)((AlgebricksPartitionConstraint)spPc.second));
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc) {
        FileSplitDataSink fsds = (FileSplitDataSink)sink;
        FileSplitSinkId fssi = fsds.getId();
        FileSplit fs = fssi.getFileSplit();
        File outFile = new File(fs.getPath());
        String nodeId = fs.getNodeName();
        SinkWriterRuntimeFactory runtime = new SinkWriterRuntimeFactory(printColumns, printerFactories, outFile, this.getWriterFactory(), inputDesc);
        AlgebricksAbsolutePartitionConstraint apc = new AlgebricksAbsolutePartitionConstraint(new String[]{nodeId});
        return new Pair((Object)runtime, (Object)apc);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc, IResultMetadata metadata, JobSpecification spec) throws AlgebricksException {
        ResultSetDataSink rsds = (ResultSetDataSink)sink;
        ResultSetSinkId rssId = rsds.getId();
        ResultSetId rsId = rssId.getResultSetId();
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = this.resultSerializerFactoryProvider.getAqlResultSerializerFactoryProvider(printColumns, printerFactories, this.getWriterFactory());
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rsId, metadata, this.getResultAsyncMode(), resultSerializedAppenderFactory, this.getMaxResultReads());
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getWriteResultRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        DataverseName dataverseName = ((DataSourceId)dataSource.getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numKeys = keys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        fieldPermutation[numKeys] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numKeys + 1] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset);
        long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        LSMIndexBulkLoadOperatorDescriptor btreeBulkLoad = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, null, fieldPermutation, 1.0f, false, numElementsHint, true, (IIndexDataflowHelperFactory)indexHelperFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), null);
        return new Pair((Object)btreeBulkLoad, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.INSERT, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, bulkload, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.DELETE, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, false, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.INSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, bulkload, null, null, null, secondaryKeysPipelines, pipelineTopSchema);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.DELETE, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, false, null, null, null, secondaryKeysPipelines, pipelineTopSchema);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexUpsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalFilteringKeys, ILogicalExpression filterExpr, LogicalVariable upsertIndicatorVar, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, List<List<AlgebricksPipeline>> secondaryKeysPipelines) throws AlgebricksException {
        return this.getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation.UPSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalFilteringKeys, filterExpr, recordDesc, context, spec, false, upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKey, secondaryKeysPipelines, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getTokenizerRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        String indexName = (String)dataSourceIndex.getId();
        DataverseName dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        if (inputSchemas.length <= 0) {
            throw new AlgebricksException("TokenizeOperator can not operate without any input variable.");
        }
        IOperatorSchema inputSchema = inputSchemas[0];
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        switch (secondaryIndex.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getBinaryTokenizerRuntime(dataverseName, datasetName, indexName, inputSchema, propagatedSchema, primaryKeys, secondaryKeys, recordDesc, spec, secondaryIndex.getIndexType());
            }
        }
        throw new AlgebricksException("Currently, we do not support TokenizeOperator for the index type: " + secondaryIndex.getIndexType());
    }

    public long getCardinalityPerPartitionHint(Dataset dataset) throws AlgebricksException {
        String numElementsHintString = dataset.getHints().get("CARDINALITY");
        long numElementsHint = numElementsHintString == null ? 1000000L : Long.parseLong(numElementsHintString);
        int numPartitions = 0;
        List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(this.mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        for (String nd : nodeGroup) {
            numPartitions += csm.getNodePartitionsCount(nd);
        }
        return numElementsHint / (long)numPartitions;
    }

    protected ITypedAdapterFactory getConfiguredAdapterFactory(Dataset dataset, String adapterName, Map<String, String> configuration, ARecordType itemType, ARecordType metaType, IWarningCollector warningCollector) throws AlgebricksException {
        try {
            configuration.put("dataset-dataverse", dataset.getDataverseName().getCanonicalForm());
            ITypedAdapterFactory adapterFactory = AdapterFactoryProvider.getAdapterFactory((ICCServiceContext)this.getApplicationContext().getServiceContext(), (String)adapterName, configuration, (ARecordType)itemType, (ARecordType)metaType, (IWarningCollector)warningCollector);
            Index filesIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName().concat("FilesIndex"));
            if (filesIndex != null && filesIndex.getPendingOp() == 0) {
                List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(this.mdTxnCtx, dataset);
                Iterator<ExternalFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                    iterator.remove();
                }
            }
            return adapterFactory;
        }
        catch (Exception e) {
            throw new AlgebricksException("Unable to create adapter", (Throwable)e);
        }
    }

    public TxnId getTxnId() {
        return this.txnId;
    }

    public static ILinearizeComparatorFactory proposeLinearizer(ATypeTag keyType, int numKeyFields) throws AlgebricksException {
        return LinearizeComparatorFactoryProvider.INSTANCE.getLinearizeComparatorFactory((Object)keyType, true, numKeyFields / 2);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitAndConstraints(DataverseName dataverseName) {
        return SplitsAndConstraintsUtil.getDataverseSplitProviderAndConstraints(this.appCtx.getClusterStateManager(), dataverseName);
    }

    public FileSplit[] splitsForIndex(MetadataTransactionContext mdTxnCtx, Dataset dataset, String indexName) throws AlgebricksException {
        return SplitsAndConstraintsUtil.getIndexSplits(dataset, indexName, mdTxnCtx, this.appCtx.getClusterStateManager());
    }

    public DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
        }
        return adapter;
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        return this.appCtx.getClusterStateManager().getClusterLocations();
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDataLookupRuntime(JobSpecification jobSpec, Dataset dataset, int[] ridIndexes, boolean retainInput, IVariableTypeEnvironment typeEnv, IOperatorSchema opSchema, JobGenContext context, MetadataProvider metadataProvider, boolean retainMissing) throws AlgebricksException {
        try {
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), dataset.getDataverseName(), dataset.getItemTypeName()).getDatatype();
            ExternalDatasetDetails datasetDetails = (ExternalDatasetDetails)dataset.getDatasetDetails();
            LookupAdapterFactory adapterFactory = AdapterFactoryProvider.getLookupAdapterFactory((ICCServiceContext)this.getApplicationContext().getServiceContext(), datasetDetails.getProperties(), (ARecordType)itemType, (int[])ridIndexes, (boolean)retainInput, (boolean)retainMissing, (IMissingWriterFactory)context.getMissingWriterFactory(), (IWarningCollector)context.getWarningCollector());
            String fileIndexName = IndexingConstants.getFilesIndexName((String)dataset.getDatasetName());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = metadataProvider.getSplitProviderAndConstraints(dataset, fileIndexName);
            Index fileIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), fileIndexName);
            IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)spPc.first);
            RecordDescriptor outRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            ISearchOperationCallbackFactory searchOpCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, fileIndex, IndexOperation.SEARCH, null);
            ExternalLookupOperatorDescriptor op = new ExternalLookupOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, adapterFactory, outRecDesc, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, searchOpCallbackFactory, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this));
            return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)spPc.second));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getUpsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema inputSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, LogicalVariable payload, List<LogicalVariable> filterKeys, List<LogicalVariable> additionalNonFilterFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = this.findDataset(((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown " + IdentifierUtil.dataset() + " " + datasetName + " in " + IdentifierUtil.dataverse() + " " + ((DataSourceId)dataSource.getId()).getDataverseName());
        }
        int numKeys = primaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int numOfAdditionalFields = additionalNonFilterFields == null ? 0 : additionalNonFilterFields.size();
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + numOfAdditionalFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = inputSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = inputSchema.findVariable(payload);
        if (additionalNonFilterFields != null) {
            for (LogicalVariable var : additionalNonFilterFields) {
                idx = inputSchema.findVariable(var);
                fieldPermutation[i++] = idx;
            }
        }
        if (numFilterFields > 0) {
            int idx2 = inputSchema.findVariable(filterKeys.get(0));
            fieldPermutation[i++] = idx2;
        }
        return this.createPrimaryIndexUpsertOp(spec, this, dataset, recordDesc, fieldPermutation, context.getMissingWriterFactory());
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IMissingWriterFactory missingWriterFactory) throws AlgebricksException {
        return DatasetUtil.createPrimaryIndexUpsertOp(spec, this, dataset, inputRecordDesc, fieldPermutation, missingWriterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDatasetDataScannerRuntime(JobSpecification jobSpec, IAType itemType, ITypedAdapterFactory adapterFactory, ITupleFilterFactory tupleFilterFactory, long outputLimit) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Can only scan " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + "of records.");
        }
        ISerializerDeserializer payloadSerde = this.getDataFormat().getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, scannerDesc, adapterFactory, tupleFilterFactory, outputLimit);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    private Pair<IBinaryComparatorFactory[], ITypeTraits[]> getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(List<List<String>> sidxKeyFieldNames, List<IAType> sidxKeyFieldTypes, List<List<String>> pidxKeyFieldNames, ARecordType recType, DatasetConfig.DatasetType dsType, boolean hasMeta, List<Integer> primaryIndexKeyIndicators, List<Integer> secondaryIndexIndicators, ARecordType metaType) throws AlgebricksException {
        IAType keyType;
        int i;
        int sidxKeyFieldCount = sidxKeyFieldNames.size();
        int pidxKeyFieldCount = pidxKeyFieldNames.size();
        ITypeTraits[] typeTraits = new ITypeTraits[sidxKeyFieldCount + pidxKeyFieldCount];
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[sidxKeyFieldCount + pidxKeyFieldCount];
        for (i = 0; i < sidxKeyFieldCount; ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(sidxKeyFieldTypes.get(i), sidxKeyFieldNames.get(i), hasMeta && secondaryIndexIndicators.get(i) == 1 ? metaType : recType);
            keyType = (IAType)keyPairType.first;
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
        }
        int j = 0;
        while (j < pidxKeyFieldCount) {
            keyType = null;
            try {
                switch (dsType) {
                    case INTERNAL: {
                        keyType = hasMeta && primaryIndexKeyIndicators.get(j) == 1 ? metaType.getSubFieldType(pidxKeyFieldNames.get(j)) : recType.getSubFieldType(pidxKeyFieldNames.get(j));
                        break;
                    }
                    case EXTERNAL: {
                        keyType = IndexingConstants.getFieldType((int)j);
                        break;
                    }
                    default: {
                        throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_DATASET_TYPE, new Serializable[]{dsType.toString()});
                    }
                }
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
            comparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            ++j;
            ++i;
        }
        return new Pair((Object)comparatorFactories, (Object)typeTraits);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertOrDeleteRuntime(IndexOperation indexOp, IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> additionalNonFilteringFields) throws AlgebricksException {
        LSMTreeInsertDeleteOperatorDescriptor op;
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, ((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        int numKeys = keys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + (additionalNonFilteringFields == null ? 0 : additionalNonFilteringFields.size())];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = propagatedSchema.findVariable(payload);
        if (additionalNonFilteringFields != null) {
            for (LogicalVariable variable : additionalNonFilteringFields) {
                idx = propagatedSchema.findVariable(variable);
                fieldPermutation[i++] = idx;
            }
        }
        int[] filterFields = new int[numFilterFields];
        if (numFilterFields > 0) {
            int idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            fieldPermutation[i++] = idx2;
            filterFields[0] = idx2;
        }
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset);
        int[] primaryKeyFields = new int[numKeys];
        for (i = 0; i < numKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, primaryIndex, indexOp, primaryKeyFields);
        IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
        if (bulkload) {
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, true, numElementsHint, true, (IIndexDataflowHelperFactory)idfh, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), null);
        } else if (indexOp == IndexOperation.INSERT) {
            ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, primaryIndex, indexOp, primaryKeyFields);
            Optional<Index> primaryKeyIndex = MetadataManager.INSTANCE.getDatasetIndexes(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName()).stream().filter(index -> index.isPrimaryKeyIndex()).findFirst();
            IndexDataflowHelperFactory pkidfh = null;
            if (primaryKeyIndex.isPresent()) {
                Pair<IFileSplitProvider, AlgebricksPartitionConstraint> primaryKeySplitsAndConstraint = this.getSplitProviderAndConstraints(dataset, primaryKeyIndex.get().getIndexName());
                pkidfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)primaryKeySplitsAndConstraint.first);
            }
            op = this.createLSMPrimaryInsertOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (IIndexDataflowHelperFactory)pkidfh, modificationCallbackFactory, searchCallbackFactory, numKeys, filterFields);
        } else {
            op = this.createLSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, null, true, modificationCallbackFactory);
        }
        return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
    }

    protected LSMPrimaryInsertOperatorDescriptor createLSMPrimaryInsertOperatorDescriptor(JobSpecification spec, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IIndexDataflowHelperFactory idfh, IIndexDataflowHelperFactory pkidfh, IModificationOperationCallbackFactory modificationCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numKeys, int[] filterFields) {
        return new LSMPrimaryInsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, idfh, pkidfh, modificationCallbackFactory, searchCallbackFactory, numKeys, filterFields);
    }

    protected LSMTreeInsertDeleteOperatorDescriptor createLSMTreeInsertDeleteOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor outRecDesc, int[] fieldPermutation, IndexOperation op, IIndexDataflowHelperFactory indexHelperFactory, ITupleFilterFactory tupleFilterFactory, boolean isPrimary, IModificationOperationCallbackFactory modCallbackFactory) {
        return new LSMTreeInsertDeleteOperatorDescriptor(spec, outRecDesc, fieldPermutation, op, indexHelperFactory, tupleFilterFactory, isPrimary, modCallbackFactory);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertOrDeleteOrUpsertRuntime(IndexOperation indexOp, IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, LogicalVariable upsertIndicatorVar, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        AsterixTupleFilterFactory filterFactory;
        String indexName = (String)dataSourceIndex.getId();
        DataverseName dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        ArrayList<LogicalVariable> prevAdditionalFilteringKeys = null;
        if (indexOp == IndexOperation.UPSERT && prevAdditionalFilteringKey != null) {
            prevAdditionalFilteringKeys = new ArrayList<LogicalVariable>();
            prevAdditionalFilteringKeys.add(prevAdditionalFilteringKey);
        }
        if (pipelineTopSchema != null) {
            IOperatorSchema[] schemasForFilterFactory = new IOperatorSchema[inputSchemas.length + 1];
            System.arraycopy(inputSchemas, 0, schemasForFilterFactory, 0, inputSchemas.length);
            schemasForFilterFactory[inputSchemas.length] = pipelineTopSchema;
            filterFactory = this.createTupleFilterFactory(schemasForFilterFactory, typeEnv, filterExpr, context);
        } else {
            filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
        }
        switch (secondaryIndex.getIndexType()) {
            case BTREE: {
                return this.getBTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, bulkload, upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case ARRAY: {
                if (bulkload) {
                    return this.getBTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, bulkload, upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
                }
                return this.getArrayIndexRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, additionalNonKeyFields, inputRecordDesc, spec, indexOp, upsertIndicatorVar, secondaryKeysPipelines);
            }
            case RTREE: {
                return this.getRTreeRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, bulkload, upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getInvertedIndexRuntime(dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, inputRecordDesc, context, spec, indexOp, secondaryIndex.getIndexType(), bulkload, upsertIndicatorVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
        }
        throw new AlgebricksException(indexOp.name() + " not implemented for index type: " + secondaryIndex.getIndexType());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBTreeRuntime(DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, LogicalVariable upsertIndicatorVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            int idx3;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            int k = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            for (LogicalVariable varKey : primaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            if (numFilterFields > 0) {
                int idx4;
                prevFieldPermutation[numKeys] = idx4 = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory);
            } else if (indexOp == IndexOperation.UPSERT) {
                int upsertIndicatorFieldIndex = propagatedSchema.findVariable(upsertIndicatorVar);
                op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, upsertIndicatorFieldIndex, BinaryBooleanInspector.FACTORY, prevFieldPermutation);
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
            }
            return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getArrayIndexRuntime(DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobSpecification spec, IndexOperation indexOp, LogicalVariable upsertIndicatorVar, List<List<AlgebricksPipeline>> secondaryKeysPipelines) throws AlgebricksException {
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numPrimaryKeys = primaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numPrimaryKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numPrimaryKeys] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor op;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (indexOp == IndexOperation.UPSERT) {
                int upsertIndicatorFieldIndex = propagatedSchema.findVariable(upsertIndicatorVar);
                op = new LSMSecondaryUpsertWithNestedPlanOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, modificationCallbackFactory, upsertIndicatorFieldIndex, BinaryBooleanInspector.FACTORY, secondaryKeysPipelines.get(0), secondaryKeysPipelines.get(1));
            } else {
                op = new LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, modificationCallbackFactory, secondaryKeysPipelines.get(0));
            }
            return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRTreeRuntime(DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, LogicalVariable upsertIndicatorVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        LSMTreeInsertDeleteOperatorDescriptor op;
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
        this.validateRecordType(itemType);
        ARecordType recType = (ARecordType)itemType;
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        Index.ValueIndexDetails secondaryIndexDetails = (Index.ValueIndexDetails)secondaryIndex.getIndexDetails();
        List<List<String>> secondaryKeyExprs = secondaryIndexDetails.getKeyFieldNames();
        List<IAType> secondaryKeyTypes = secondaryIndexDetails.getKeyFieldTypes();
        Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
        IAType spatialType = (IAType)keyPairType.first;
        int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numSecondaryKeys = dimension * 2;
        int numPrimaryKeys = primaryKeys.size();
        int numKeys = numSecondaryKeys + numPrimaryKeys;
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var37_44;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl = false;
            while (var37_44 < numPrimaryKeys) {
                prevFieldPermutation[var37_44 + i] = fieldPermutation[var37_44 + i];
                ++i;
                ++var37_44;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> pair = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)pair.first);
        if (bulkload) {
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory);
        } else if (indexOp == IndexOperation.UPSERT) {
            int upsertIndicatorFieldIndex = propagatedSchema.findVariable(upsertIndicatorVar);
            op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, upsertIndicatorFieldIndex, BinaryBooleanInspector.FACTORY, prevFieldPermutation);
        } else {
            op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
        }
        return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)pair.second));
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInvertedIndexRuntime(DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload, LogicalVariable upsertIndicatorVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot create inverted index on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + "with composite primary key.");
        }
        if (secondaryKeys.size() > 1 && !isPartitioned || secondaryKeys.size() > 2 && isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var27_34;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl = false;
            while (var27_34 < primaryKeys.size()) {
                prevFieldPermutation[var27_34 + i] = fieldPermutation[var27_34 + i];
                ++i;
                ++var27_34;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index index = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, index.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, index, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory indexDataFlowFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), (IFileSplitProvider)splitsAndConstraint.first);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataFlowFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory);
            } else if (indexOp == IndexOperation.UPSERT) {
                int upsertIndicatorFieldIndex = propagatedSchema.findVariable(upsertIndicatorVar);
                op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, upsertIndicatorFieldIndex, BinaryBooleanInspector.FACTORY, prevFieldPermutation);
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory);
            }
            return new Pair((Object)op, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        }
        catch (Exception exception) {
            throw new AlgebricksException((Throwable)exception);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBinaryTokenizerRuntime(DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema inputSchema, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, RecordDescriptor recordDesc, JobSpecification spec, DatasetConfig.IndexType indexType) throws AlgebricksException {
        int idx;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite primary key.");
        }
        if (secondaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite secondary key fields.");
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numKeys = inputSchema.getSize();
        ArrayList<LogicalVariable> otherKeys = new ArrayList<LogicalVariable>();
        if (inputSchema.getSize() > 0) {
            for (int k = 0; k < inputSchema.getSize(); ++k) {
                boolean found = false;
                for (LogicalVariable varKey : primaryKeys) {
                    if (varKey.equals((Object)inputSchema.getVariable(k))) {
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    for (LogicalVariable varKey : secondaryKeys) {
                        if (varKey.equals((Object)inputSchema.getVariable(k))) {
                            found = true;
                            break;
                        }
                        found = false;
                    }
                }
                if (found) continue;
                otherKeys.add(inputSchema.getVariable(k));
            }
        }
        int numTokenKeyPairFields = !isPartitioned ? 1 + numKeys : 2 + numKeys;
        int[] fieldPermutation = new int[numKeys];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        for (LogicalVariable varKey : otherKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        try {
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                throw new AlgebricksException("Only record types can be tokenized.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Index.TextIndexDetails secondaryIndexDetails = (Index.TextIndexDetails)secondaryIndex.getIndexDetails();
            List<List<String>> secondaryKeyExprs = secondaryIndexDetails.getKeyFieldNames();
            List<IAType> secondaryKeyTypeEntries = secondaryIndexDetails.getKeyFieldTypes();
            int numTokenFields = !isPartitioned ? secondaryKeys.size() : secondaryKeys.size() + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypeEntries.get(0), secondaryKeyExprs.get(0), recType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndexDetails.getGramLength());
            IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory = FullTextUtil.fetchFilterAndCreateConfigEvaluator(this, secondaryIndex.getDataverseName(), secondaryIndexDetails.getFullTextConfigName());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.getSplitProviderAndConstraints(dataset, secondaryIndex.getIndexName());
            ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[numTokenKeyPairFields];
            ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[numTokenKeyPairFields];
            ISerializerDeserializerProvider serdeProvider = this.getDataFormat().getSerdeProvider();
            for (int k = 0; k < recordDesc.getFieldCount(); ++k) {
                tokenKeyPairFields[k] = recordDesc.getFields()[k];
                tokenKeyPairTypeTraits[k] = recordDesc.getTypeTraits()[k];
            }
            int tokenOffset = recordDesc.getFieldCount();
            tokenKeyPairFields[tokenOffset] = serdeProvider.getSerializerDeserializer((Object)secondaryKeyType);
            tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[0];
            ++tokenOffset;
            if (isPartitioned) {
                tokenKeyPairFields[tokenOffset] = ShortSerializerDeserializer.INSTANCE;
                tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[1];
            }
            RecordDescriptor tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
            int docField = fieldPermutation[fieldPermutation.length - 1];
            int[] keyFields = new int[numKeys];
            for (int k = 0; k < keyFields.length; ++k) {
                keyFields[k] = k;
            }
            BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, tokenKeyPairRecDesc, tokenizerFactory, fullTextConfigEvaluatorFactory, docField, keyFields, isPartitioned, true, false, (IMissingWriterFactory)MissingWriterFactory.INSTANCE);
            return new Pair((Object)tokenizerOp, (Object)((AlgebricksPartitionConstraint)splitsAndConstraint.second));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public AsterixTupleFilterFactory createTupleFilterFactory(IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, ILogicalExpression filterExpr, JobGenContext context) throws AlgebricksException {
        if (filterExpr == null) {
            return null;
        }
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory filterEvalFactory = expressionRuntimeProvider.createEvaluatorFactory(filterExpr, typeEnv, inputSchemas, context);
        return new AsterixTupleFilterFactory(filterEvalFactory, context.getBinaryBooleanInspectorFactory());
    }

    private void validateRecordType(IAType itemType) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Only record types can be indexed.");
        }
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.storageComponentProvider;
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getSplitProviderAndConstraints(Dataset ds) throws AlgebricksException {
        return this.getSplitProviderAndConstraints(ds, ds.getDatasetName());
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getSplitProviderAndConstraints(Dataset ds, String indexName) throws AlgebricksException {
        FileSplit[] splits = this.splitsForIndex(this.mdTxnCtx, ds, indexName);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    public LockList getLocks() {
        return this.locks;
    }

    public ICcApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public ITxnIdFactory getTxnIdFactory() {
        return this.appCtx.getTxnIdFactory();
    }

    public ICompressionManager getCompressionManager() {
        return this.appCtx.getCompressionManager();
    }

    public void validateDataverseName(DataverseName dataverseName, SourceLocation sourceLoc) throws AlgebricksException {
        int totalLengthUTF8 = 0;
        for (String dvNamePart : dataverseName.getParts()) {
            this.validateDatabaseObjectNameImpl(dvNamePart, sourceLoc);
            if (totalLengthUTF8 == 0 && 94 == dvNamePart.codePointAt(0)) {
                throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{dvNamePart});
            }
            totalLengthUTF8 += dvNamePart.getBytes(StandardCharsets.UTF_8).length;
        }
        if (totalLengthUTF8 > 1004) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{dataverseName.toString()});
        }
    }

    public void validateDatabaseObjectName(DataverseName dataverseName, String objectName, SourceLocation sourceLoc) throws AlgebricksException {
        if (dataverseName != null) {
            this.validateDataverseName(dataverseName, sourceLoc);
        }
        this.validateDatabaseObjectNameImpl(objectName, sourceLoc);
    }

    private void validateDatabaseObjectNameImpl(String name, SourceLocation sourceLoc) throws AlgebricksException {
        if (name == null || name.isEmpty()) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{""});
        }
        if (Character.isWhitespace(name.codePointAt(0)) || MetadataConstants.METADATA_OBJECT_NAME_INVALID_CHARS.matcher(name).find()) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{name});
        }
        int lengthUTF8 = name.getBytes(StandardCharsets.UTF_8).length;
        if (lengthUTF8 > 251) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{name});
        }
    }
}

