/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.ArrayBTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeAccessMethod;
import org.apache.asterix.optimizer.rules.util.FullTextUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public abstract class AbstractIntroduceAccessMethodRule
implements IAlgebraicRewriteRule {
    protected MetadataProvider metadataProvider;

    public abstract Map<FunctionIdentifier, List<IAccessMethod>> getAccessMethods();

    protected static void registerAccessMethod(IAccessMethod accessMethod, Map<FunctionIdentifier, List<IAccessMethod>> accessMethods) {
        List<Pair<FunctionIdentifier, Boolean>> funcs = accessMethod.getOptimizableFunctions();
        for (Pair<FunctionIdentifier, Boolean> funcIdent : funcs) {
            List<IAccessMethod> l = accessMethods.get(funcIdent.first);
            if (l == null) {
                l = new ArrayList<IAccessMethod>();
                accessMethods.put((FunctionIdentifier)funcIdent.first, l);
            }
            l.add(accessMethod);
        }
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    protected void setMetadataDeclarations(IOptimizationContext context) {
        this.metadataProvider = (MetadataProvider)context.getMetadataProvider();
    }

    protected void fillSubTreeIndexExprs(OptimizableOperatorSubTree subTree, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context) throws AlgebricksException {
        this.fillSubTreeIndexExprs(subTree, analyzedAMs, context, false);
    }

    protected void fillSubTreeIndexExprs(OptimizableOperatorSubTree subTree, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, boolean isArbitraryFormOfSubtree) throws AlgebricksException {
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> entry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext amCtx = entry.getValue();
            if (!isArbitraryFormOfSubtree) {
                this.fillAllIndexExprs(subTree, amCtx, context);
                continue;
            }
            this.fillVarFieldTypeForOptFuncExprs(subTree, amCtx, (ITypingContext)context);
        }
    }

    protected void fillVarFieldTypeForOptFuncExprs(OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, ITypingContext context) throws AlgebricksException {
        ILogicalOperator rootOp = subTree.getRoot();
        IVariableTypeEnvironment envSubtree = context.getOutputTypeEnvironment(rootOp);
        HashSet liveVarsAtRootOp = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)rootOp, liveVarsAtRootOp);
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            for (LogicalVariable var : liveVarsAtRootOp) {
                int optVarIndex = optFuncExpr.findLogicalVar(var);
                if (optVarIndex < 0) continue;
                optFuncExpr.setOptimizableSubTree(optVarIndex, subTree);
                IAType fieldType = (IAType)envSubtree.getVarType(var);
                optFuncExpr.setFieldType(optVarIndex, fieldType);
            }
        }
    }

    protected void pruneIndexCandidates(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        Iterator<Map.Entry<IAccessMethod, AccessMethodAnalysisContext>> amIt = analyzedAMs.entrySet().iterator();
        while (amIt.hasNext()) {
            Map.Entry<IAccessMethod, AccessMethodAnalysisContext> entry = amIt.next();
            AccessMethodAnalysisContext amCtx = entry.getValue();
            this.pruneIndexCandidates(entry.getKey(), amCtx, context, typeEnvironment);
            if (!amCtx.isIndexExprsAndVarsEmpty()) continue;
            amIt.remove();
        }
    }

    protected Pair<IAccessMethod, Index> chooseBestIndex(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) {
        List<Pair<IAccessMethod, Index>> list = this.chooseAllIndexes(analyzedAMs);
        return list.isEmpty() ? null : list.get(0);
    }

    protected List<Pair<IAccessMethod, Index>> chooseAllIndexes(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) {
        ArrayList<Pair<IAccessMethod, Index>> result = new ArrayList<Pair<IAccessMethod, Index>>();
        HashMap resultVarsToIndexTypesMap = new HashMap();
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> amEntry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext analysisCtx = amEntry.getValue();
            Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexIt = analysisCtx.getIteratorForIndexExprsAndVars();
            while (indexIt.hasNext()) {
                boolean isNgramIndexChosen;
                Map.Entry<Index, List<Pair<Integer, Integer>>> indexEntry = indexIt.next();
                IAccessMethod chosenAccessMethod = amEntry.getKey();
                Index chosenIndex = indexEntry.getKey();
                DatasetConfig.IndexType indexType = chosenIndex.getIndexType();
                boolean isKeywordIndexChosen = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
                boolean bl = isNgramIndexChosen = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX || indexType == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX;
                if (!(chosenAccessMethod == BTreeAccessMethod.INSTANCE && indexType == DatasetConfig.IndexType.BTREE || chosenAccessMethod == ArrayBTreeAccessMethod.INSTANCE && indexType == DatasetConfig.IndexType.ARRAY || chosenAccessMethod == RTreeAccessMethod.INSTANCE && indexType == DatasetConfig.IndexType.RTREE || chosenAccessMethod == InvertedIndexAccessMethod.INSTANCE && isNgramIndexChosen) && (chosenAccessMethod != InvertedIndexAccessMethod.INSTANCE || !isKeywordIndexChosen || !this.isSameFullTextConfigInIndexAndQuery(analysisCtx, chosenIndex.getIndexDetails()))) continue;
                if (resultVarsToIndexTypesMap.containsKey(indexEntry.getValue())) {
                    List appliedIndexTypes = (List)resultVarsToIndexTypesMap.get(indexEntry.getValue());
                    if (appliedIndexTypes.contains(indexType)) continue;
                    appliedIndexTypes.add(indexType);
                    result.add((Pair<IAccessMethod, Index>)new Pair((Object)chosenAccessMethod, (Object)chosenIndex));
                    continue;
                }
                ArrayList<DatasetConfig.IndexType> addedIndexTypes = new ArrayList<DatasetConfig.IndexType>();
                addedIndexTypes.add(indexType);
                resultVarsToIndexTypesMap.put(indexEntry.getValue(), addedIndexTypes);
                result.add((Pair<IAccessMethod, Index>)new Pair((Object)chosenAccessMethod, (Object)chosenIndex));
            }
        }
        return result;
    }

    private boolean isSameFullTextConfigInIndexAndQuery(AccessMethodAnalysisContext analysisCtx, Index.IIndexDetails indexDetails) {
        String indexFullTextConfig = ((Index.TextIndexDetails)indexDetails).getFullTextConfigName();
        IOptimizableFuncExpr expr = analysisCtx.getMatchedFuncExpr(0);
        if (FullTextUtil.isFullTextContainsFunctionExpr(expr)) {
            String expectedConfig = FullTextUtil.getFullTextConfigNameFromExpr(expr);
            if (Strings.isNullOrEmpty((String)expectedConfig)) {
                return Strings.isNullOrEmpty((String)indexFullTextConfig);
            }
            if (expectedConfig.equals(indexFullTextConfig)) {
                return true;
            }
        } else if (Strings.isNullOrEmpty((String)indexFullTextConfig)) {
            return true;
        }
        return false;
    }

    public void pruneIndexCandidates(IAccessMethod accessMethod, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        Set<Index> preferredSecondaryIndexes;
        Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexExprAndVarIt = analysisCtx.getIteratorForIndexExprsAndVars();
        boolean hasIndexPreferences = false;
        ArrayList<Integer> matchedExpressions = new ArrayList<Integer>();
        while (indexExprAndVarIt.hasNext()) {
            int i;
            ArrayList<IAType> keyFieldTypes;
            ArrayList<List> keyFieldNames;
            Map.Entry<Index, List<Pair<Integer, Integer>>> indexExprAndVarEntry = indexExprAndVarIt.next();
            Index index = indexExprAndVarEntry.getKey();
            DatasetConfig.IndexType indexType = index.getIndexType();
            if (!accessMethod.matchIndexType(indexType)) {
                indexExprAndVarIt.remove();
                continue;
            }
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)indexType)) {
                case ARRAY: {
                    Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
                    keyFieldNames = new ArrayList<List>();
                    keyFieldTypes = new ArrayList<IAType>();
                    for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
                        for (i = 0; i < e.getProjectList().size(); ++i) {
                            List project = (List)e.getProjectList().get(i);
                            keyFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)project));
                            keyFieldTypes.add((IAType)e.getTypeList().get(i));
                        }
                    }
                    break;
                }
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                    keyFieldNames = valueIndexDetails.getKeyFieldNames();
                    keyFieldTypes = valueIndexDetails.getKeyFieldTypes();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                    keyFieldNames = textIndexDetails.getKeyFieldNames();
                    keyFieldTypes = textIndexDetails.getKeyFieldTypes();
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(indexType)});
                }
            }
            boolean allUsed = true;
            int lastFieldMatched = -1;
            matchedExpressions.clear();
            int numMatchedKeys = 0;
            for (i = 0; i < keyFieldNames.size(); ++i) {
                List keyField = (List)keyFieldNames.get(i);
                final IAType keyType = (IAType)keyFieldTypes.get(i);
                boolean foundKeyField = false;
                Iterator<Pair<Integer, Integer>> exprsAndVarIter = indexExprAndVarEntry.getValue().iterator();
                while (exprsAndVarIter.hasNext()) {
                    int j;
                    final Pair<Integer, Integer> exprAndVarIdx = exprsAndVarIter.next();
                    final IOptimizableFuncExpr optFuncExpr = analysisCtx.getMatchedFuncExpr((Integer)exprAndVarIdx.first);
                    if (!accessMethod.exprIsOptimizable(index, optFuncExpr)) {
                        exprsAndVarIter.remove();
                        continue;
                    }
                    boolean typeMatch = true;
                    ArrayList<IAType> matchedTypes = new ArrayList<IAType>();
                    for (int j2 = 0; j2 < optFuncExpr.getNumLogicalVars(); ++j2) {
                        if (j2 == (Integer)exprAndVarIdx.second) continue;
                        matchedTypes.add(optFuncExpr.getFieldType(j2));
                    }
                    if (matchedTypes.size() < 2 && optFuncExpr.getNumLogicalVars() == 1) {
                        matchedTypes.add((IAType)ExpressionTypeComputer.INSTANCE.getType(optFuncExpr.getConstantExpr(0), context.getMetadataProvider(), typeEnvironment));
                    }
                    matchedTypes.add((IAType)ExpressionTypeComputer.INSTANCE.getType(optFuncExpr.getLogicalExpr((Integer)exprAndVarIdx.second), null, new IVariableTypeEnvironment(){

                        public Object getVarType(LogicalVariable var) throws AlgebricksException {
                            if (var.equals((Object)optFuncExpr.getSourceVar((Integer)exprAndVarIdx.second))) {
                                return keyType;
                            }
                            throw new IllegalArgumentException();
                        }

                        public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariables, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
                            if (var.equals((Object)optFuncExpr.getSourceVar((Integer)exprAndVarIdx.second))) {
                                return keyType;
                            }
                            throw new IllegalArgumentException();
                        }

                        public void setVarType(LogicalVariable var, Object type) {
                            throw new IllegalArgumentException();
                        }

                        public Object getType(ILogicalExpression expr) throws AlgebricksException {
                            return ExpressionTypeComputer.INSTANCE.getType(expr, null, (IVariableTypeEnvironment)this);
                        }

                        public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
                            throw new IllegalArgumentException();
                        }
                    }));
                    boolean jaccardSimilarity = optFuncExpr.getFuncExpr().getFunctionIdentifier().getName().startsWith("similarity-jaccard-check");
                    ArrayList<IAType> elementTypes = matchedTypes;
                    if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                        for (j = 0; j < matchedTypes.size(); ++j) {
                            if (((IAType)matchedTypes.get(j)).getTypeTag() != ATypeTag.ARRAY && ((IAType)matchedTypes.get(j)).getTypeTag() != ATypeTag.MULTISET) continue;
                            elementTypes.set(j, ((AbstractCollectionType)matchedTypes.get(j)).getItemType());
                        }
                    }
                    for (j = 0; j < matchedTypes.size(); ++j) {
                        for (int k = j + 1; k < matchedTypes.size(); ++k) {
                            typeMatch &= this.isMatched((IAType)elementTypes.get(j), (IAType)elementTypes.get(k), jaccardSimilarity);
                        }
                    }
                    if (!typeMatch || optFuncExpr.findFieldName(keyField) == -1 || !optFuncExpr.getOperatorSubTree((Integer)exprAndVarIdx.second).hasDataSourceScan()) continue;
                    foundKeyField = true;
                    matchedExpressions.add((Integer)exprAndVarIdx.first);
                    hasIndexPreferences = hasIndexPreferences || accessMethod.getSecondaryIndexPreferences(optFuncExpr) != null;
                }
                if (foundKeyField) {
                    ++numMatchedKeys;
                    if (lastFieldMatched != i - 1) continue;
                    lastFieldMatched = i;
                    continue;
                }
                allUsed = false;
                if (lastFieldMatched < 0) break;
                exprsAndVarIter = indexExprAndVarEntry.getValue().iterator();
                while (exprsAndVarIter.hasNext()) {
                    if (matchedExpressions.contains(exprsAndVarIter.next().first)) continue;
                    exprsAndVarIter.remove();
                }
                break;
            }
            if (!allUsed && accessMethod.matchAllIndexExprs(index)) {
                indexExprAndVarIt.remove();
                continue;
            }
            if (accessMethod.matchPrefixIndexExprs(index) && lastFieldMatched < 0) {
                indexExprAndVarIt.remove();
                continue;
            }
            analysisCtx.putNumberOfMatchedKeys(index, numMatchedKeys);
        }
        if (hasIndexPreferences && (preferredSecondaryIndexes = this.fetchSecondaryIndexPreferences(accessMethod, analysisCtx)) != null) {
            this.removeNonPreferredSecondaryIndexes(analysisCtx, preferredSecondaryIndexes);
        }
    }

    private boolean isMatched(IAType type1, IAType type2, boolean useListDomain) throws AlgebricksException {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (ATypeHierarchy.isSameTypeDomain((ATypeTag)((IAType)Index.getNonNullableType((IAType)type1).first).getTypeTag(), (ATypeTag)((IAType)Index.getNonNullableType((IAType)type2).first).getTypeTag(), (boolean)useListDomain)) {
            return true;
        }
        return ATypeHierarchy.canPromote((ATypeTag)((IAType)Index.getNonNullableType((IAType)type1).first).getTypeTag(), (ATypeTag)((IAType)Index.getNonNullableType((IAType)type2).first).getTypeTag());
    }

    private Set<Index> fetchSecondaryIndexPreferences(IAccessMethod accessMethod, AccessMethodAnalysisContext analysisCtx) {
        HashSet<Index> preferredSecondaryIndexes = null;
        Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexExprAndVarIt = analysisCtx.getIteratorForIndexExprsAndVars();
        block0: while (indexExprAndVarIt.hasNext()) {
            Map.Entry<Index, List<Pair<Integer, Integer>>> indexExprAndVarEntry = indexExprAndVarIt.next();
            Index index = indexExprAndVarEntry.getKey();
            if (!index.isSecondaryIndex()) continue;
            for (Pair<Integer, Integer> exprVarPair : indexExprAndVarEntry.getValue()) {
                IOptimizableFuncExpr optFuncExpr = analysisCtx.getMatchedFuncExpr((Integer)exprVarPair.first);
                Collection<String> preferredIndexNames = accessMethod.getSecondaryIndexPreferences(optFuncExpr);
                if (preferredIndexNames == null || !preferredIndexNames.contains(index.getIndexName())) continue;
                if (preferredSecondaryIndexes == null) {
                    preferredSecondaryIndexes = new HashSet<Index>();
                }
                preferredSecondaryIndexes.add(index);
                continue block0;
            }
        }
        return preferredSecondaryIndexes;
    }

    private void removeNonPreferredSecondaryIndexes(AccessMethodAnalysisContext analysisCtx, Collection<Index> preferredIndexes) {
        Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexExprAndVarIt = analysisCtx.getIteratorForIndexExprsAndVars();
        while (indexExprAndVarIt.hasNext()) {
            Map.Entry<Index, List<Pair<Integer, Integer>>> indexExprAndVarEntry = indexExprAndVarIt.next();
            Index index = indexExprAndVarEntry.getKey();
            if (!index.isSecondaryIndex() || preferredIndexes.contains(index)) continue;
            indexExprAndVarIt.remove();
        }
    }

    protected boolean analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM(ILogicalExpression cond, List<AbstractLogicalOperator> assignsAndUnnests, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)cond;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.OR) {
            return false;
        }
        if (funcIdent == AlgebricksBuiltinFunctions.AND) {
            boolean found = false;
            for (Mutable arg : funcExpr.getArguments()) {
                ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
                if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
                boolean matchFound = this.analyzeFunctionExprAndUpdateAnalyzedAM(argFuncExpr, assignsAndUnnests, analyzedAMs, context, typeEnvironment);
                found = found || matchFound;
            }
            return found;
        }
        return this.analyzeFunctionExprAndUpdateAnalyzedAM(funcExpr, assignsAndUnnests, analyzedAMs, context, typeEnvironment);
    }

    protected boolean analyzeFunctionExprAndUpdateAnalyzedAM(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.AND) {
            return false;
        }
        List<IAccessMethod> relevantAMs = this.getAccessMethods().get(funcIdent);
        if (relevantAMs == null) {
            return false;
        }
        boolean atLeastOneMatchFound = false;
        AccessMethodAnalysisContext newAnalysisCtx = new AccessMethodAnalysisContext();
        for (IAccessMethod accessMethod : relevantAMs) {
            boolean matchFound;
            AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(accessMethod);
            if (analysisCtx == null) {
                analysisCtx = newAnalysisCtx;
            }
            if (!(matchFound = accessMethod.analyzeFuncExprArgsAndUpdateAnalysisCtx(funcExpr, assignsAndUnnests, analysisCtx, context, typeEnvironment))) continue;
            if (analysisCtx == newAnalysisCtx) {
                analyzedAMs.put(accessMethod, analysisCtx);
                newAnalysisCtx = new AccessMethodAnalysisContext();
            }
            atLeastOneMatchFound = true;
        }
        return atLeastOneMatchFound;
    }

    protected boolean fillIndexExprs(List<Index> datasetIndexes, List<String> fieldName, IAType fieldType, IOptimizableFuncExpr optFuncExpr, int matchedFuncExprIndex, int varIdx, OptimizableOperatorSubTree matchedSubTree, AccessMethodAnalysisContext analysisCtx, int fieldSource) throws AlgebricksException {
        ArrayList<Index> indexCandidates = new ArrayList<Index>();
        for (Index index : datasetIndexes) {
            boolean isFieldTypeUnknown;
            int keyIdx;
            boolean isOverridingKeyFieldTypes;
            ArrayList<Integer> keySources;
            ArrayList<IAType> keyFieldTypes;
            ArrayList<List> keyFieldNames;
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)index.getIndexType())) {
                case ARRAY: {
                    Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
                    keyFieldNames = new ArrayList<List>();
                    keyFieldTypes = new ArrayList<IAType>();
                    keySources = new ArrayList<Integer>();
                    for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
                        for (int i = 0; i < e.getProjectList().size(); ++i) {
                            List project = (List)e.getProjectList().get(i);
                            keyFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)project));
                            keyFieldTypes.add(((IAType)e.getTypeList().get(i)).getType());
                            keySources.add(e.getSourceIndicator());
                        }
                    }
                    isOverridingKeyFieldTypes = arrayIndexDetails.isOverridingKeyFieldTypes();
                    break;
                }
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                    keyFieldNames = valueIndexDetails.getKeyFieldNames();
                    keyFieldTypes = valueIndexDetails.getKeyFieldTypes();
                    keySources = valueIndexDetails.getKeyFieldSourceIndicators();
                    isOverridingKeyFieldTypes = valueIndexDetails.isOverridingKeyFieldTypes();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                    keyFieldNames = textIndexDetails.getKeyFieldNames();
                    keyFieldTypes = textIndexDetails.getKeyFieldTypes();
                    keySources = textIndexDetails.getKeyFieldSourceIndicators();
                    isOverridingKeyFieldTypes = textIndexDetails.isOverridingKeyFieldTypes();
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
                }
            }
            if ((keyIdx = keyFieldNames.indexOf(fieldName)) < 0 || !AbstractIntroduceAccessMethodRule.keySourceMatches(keySources, keyIdx, fieldSource) || index.getPendingOp() != 0) continue;
            indexCandidates.add(index);
            boolean bl = isFieldTypeUnknown = fieldType == BuiltinType.AMISSING || fieldType == BuiltinType.ANY;
            if (isFieldTypeUnknown && (!isOverridingKeyFieldTypes || index.isEnforced())) {
                IAType indexedType = (IAType)keyFieldTypes.get(keyIdx);
                optFuncExpr.setFieldType(varIdx, indexedType);
            }
            analysisCtx.addIndexExpr(matchedSubTree.getDataset(), index, matchedFuncExprIndex, varIdx);
        }
        return !indexCandidates.isEmpty();
    }

    private static boolean keySourceMatches(List<Integer> keySources, int keyIdx, int fieldSource) {
        return keySources == null ? fieldSource == 0 : keySources.get(keyIdx) == fieldSource;
    }

    protected void fillAllIndexExprs(OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context) throws AlgebricksException {
        int optFuncExprIndex = 0;
        ArrayList<Index> datasetIndexes = new ArrayList();
        LogicalVariable datasetMetaVar = null;
        if (subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN && subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP) {
            datasetIndexes = this.metadataProvider.getDatasetIndexes(subTree.getDataset().getDataverseName(), subTree.getDataset().getDatasetName());
            List<LogicalVariable> datasetVars = subTree.getDataSourceVariables();
            if (subTree.getDataset().hasMetaPart()) {
                datasetMetaVar = datasetVars.get(datasetVars.size() - 1);
            }
        }
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            for (int assignOrUnnestIndex = 0; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
                AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
                if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    this.analyzeAssignOp((AssignOperator)op, optFuncExpr, subTree, assignOrUnnestIndex, datasetMetaVar, context, datasetIndexes, optFuncExprIndex, analysisCtx);
                    continue;
                }
                this.analyzeUnnestOp((UnnestOperator)op, optFuncExpr, subTree, assignOrUnnestIndex, datasetMetaVar, context, datasetIndexes, optFuncExprIndex, analysisCtx);
            }
            List<LogicalVariable> dsVarList = subTree.getDataSourceVariables();
            this.matchVarsFromOptFuncExprToDataSourceScan(optFuncExpr, optFuncExprIndex, datasetIndexes, dsVarList, subTree, analysisCtx, context, false);
            ArrayList<LogicalVariable> additionalDsVarList = null;
            if (subTree.hasIxJoinOuterAdditionalDataSource()) {
                additionalDsVarList = new ArrayList<LogicalVariable>();
                for (int i = 0; i < subTree.getIxJoinOuterAdditionalDataSourceRefs().size(); ++i) {
                    additionalDsVarList.addAll(subTree.getIxJoinOuterAdditionalDataSourceVariables(i));
                }
                this.matchVarsFromOptFuncExprToDataSourceScan(optFuncExpr, optFuncExprIndex, datasetIndexes, additionalDsVarList, subTree, analysisCtx, context, true);
            }
            ++optFuncExprIndex;
        }
    }

    private void analyzeUnnestOp(UnnestOperator unnestOp, IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int assignOrUnnestIndex, LogicalVariable datasetMetaVar, IOptimizationContext context, List<Index> datasetIndexes, int optFuncExprIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        LogicalVariable var = unnestOp.getVariable();
        int funcVarIndex = optFuncExpr.findLogicalVar(var);
        if (funcVarIndex == -1) {
            return;
        }
        optFuncExpr.setOptimizableSubTree(funcVarIndex, subTree);
        List<String> fieldName = null;
        MutableInt fieldSource = new MutableInt(0);
        if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN) {
            VariableReferenceExpression varRef = new VariableReferenceExpression(var);
            varRef.setSourceLocation(unnestOp.getSourceLocation());
            optFuncExpr.setLogicalExpr(funcVarIndex, (ILogicalExpression)varRef);
        } else {
            if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.DATASOURCE_SCAN) {
                subTree.setLastMatchedDataSourceVars(0, funcVarIndex);
            }
            if ((fieldName = AccessMethodUtils.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, 0, subTree.getRecordType(), funcVarIndex, (ILogicalExpression)((Mutable)optFuncExpr.getFuncExpr().getArguments().get(funcVarIndex)).getValue(), subTree.getMetaRecordType(), datasetMetaVar, fieldSource, false)).isEmpty()) {
                return;
            }
        }
        IAType fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)unnestOp).getType(optFuncExpr.getLogicalExpr(funcVarIndex));
        optFuncExpr.setFieldName(funcVarIndex, fieldName, fieldSource.intValue());
        optFuncExpr.setFieldType(funcVarIndex, fieldType);
        this.setTypeTag(context, subTree, optFuncExpr, funcVarIndex);
        if (subTree.hasDataSource()) {
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, funcVarIndex, subTree, analysisCtx, fieldSource.intValue());
        }
    }

    private void analyzeAssignOp(AssignOperator assignOp, IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int assignOrUnnestIndex, LogicalVariable datasetMetaVar, IOptimizationContext context, List<Index> datasetIndexes, int optFuncExprIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        boolean doesArrayIndexQualify = context.getPhysicalOptimizationConfig().isArrayIndexEnabled() && datasetIndexes.stream().anyMatch(i -> i.getIndexType() == DatasetConfig.IndexType.ARRAY) && assignOrUnnestIndex == subTree.getAssignsAndUnnests().size() - 1;
        List varList = assignOp.getVariables();
        MutableInt fieldSource = new MutableInt(0);
        for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
            LogicalVariable var = (LogicalVariable)varList.get(varIndex);
            int optVarIndex = optFuncExpr.findLogicalVar(var);
            if (optVarIndex == -1) {
                Triple<Integer, List<String>, IAType> fieldTriplet;
                if (!doesArrayIndexQualify || subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.DATASOURCE_SCAN || (fieldTriplet = AccessMethodUtils.analyzeVarForArrayIndexes(assignOp, optFuncExpr, subTree, datasetMetaVar, context, datasetIndexes, analysisCtx.getMatchedFuncExprs(), varIndex)) == null || !subTree.hasDataSource()) continue;
                this.fillIndexExprs(datasetIndexes, (List)fieldTriplet.second, (IAType)fieldTriplet.third, optFuncExpr, optFuncExprIndex, (Integer)fieldTriplet.first, subTree, analysisCtx, fieldSource.intValue());
                continue;
            }
            optFuncExpr.setOptimizableSubTree(optVarIndex, subTree);
            if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.DATASOURCE_SCAN) {
                subTree.setLastMatchedDataSourceVars(varIndex, optVarIndex);
            }
            fieldSource.setValue(0);
            List<String> fieldName = AccessMethodUtils.getFieldNameFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), optVarIndex, (ILogicalExpression)((Mutable)optFuncExpr.getFuncExpr().getArguments().get(optVarIndex)).getValue(), subTree.getMetaRecordType(), datasetMetaVar, fieldSource, false);
            IAType fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)assignOp).getVarType(var);
            optFuncExpr.setFieldName(optVarIndex, fieldName, fieldSource.intValue());
            optFuncExpr.setFieldType(optVarIndex, fieldType);
            this.setTypeTag(context, subTree, optFuncExpr, optVarIndex);
            if (!subTree.hasDataSource()) continue;
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, optVarIndex, subTree, analysisCtx, fieldSource.intValue());
        }
    }

    private void matchVarsFromOptFuncExprToDataSourceScan(IOptimizableFuncExpr optFuncExpr, int optFuncExprIndex, List<Index> datasetIndexes, List<LogicalVariable> dsVarList, OptimizableOperatorSubTree subTree, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean fromAdditionalDataSource) throws AlgebricksException {
        MutableInt mutableFieldSource = new MutableInt(0);
        for (int varIndex = 0; varIndex < dsVarList.size(); ++varIndex) {
            IAType fieldType;
            List fieldName;
            int funcVarIndex;
            LogicalVariable var;
            block4: {
                List subTreePKs;
                block3: {
                    var = dsVarList.get(varIndex);
                    funcVarIndex = optFuncExpr.findLogicalVar(var);
                    if (funcVarIndex == -1) continue;
                    fieldName = null;
                    fieldType = null;
                    subTreePKs = null;
                    mutableFieldSource.setValue(0);
                    if (fromAdditionalDataSource) break block3;
                    Dataset dataset = subTree.getDataset();
                    subTreePKs = dataset.getPrimaryKeys();
                    if (varIndex > subTreePKs.size() - 1) break block4;
                    fieldName = (List)subTreePKs.get(varIndex);
                    fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)subTree.getDataSourceRef().getValue()).getVarType(var);
                    List keySourceIndicators = DatasetUtil.getKeySourceIndicators((Dataset)dataset);
                    if (keySourceIndicators != null) {
                        mutableFieldSource.setValue((Number)keySourceIndicators.get(varIndex));
                    }
                    break block4;
                }
                for (int i = 0; i < subTree.getIxJoinOuterAdditionalDatasets().size(); ++i) {
                    Dataset dataset = subTree.getIxJoinOuterAdditionalDatasets().get(i);
                    if (dataset == null || !(subTreePKs = dataset.getPrimaryKeys()).contains(var) || varIndex > subTreePKs.size() - 1) continue;
                    fieldName = (List)subTreePKs.get(varIndex);
                    fieldType = (IAType)context.getOutputTypeEnvironment((ILogicalOperator)subTree.getIxJoinOuterAdditionalDataSourceRefs().get(i).getValue()).getVarType(var);
                    List keySourceIndicators = DatasetUtil.getKeySourceIndicators((Dataset)dataset);
                    if (keySourceIndicators == null) break;
                    mutableFieldSource.setValue((Number)keySourceIndicators.get(varIndex));
                    break;
                }
            }
            int fieldSource = mutableFieldSource.intValue();
            optFuncExpr.setFieldName(funcVarIndex, fieldName, fieldSource);
            optFuncExpr.setOptimizableSubTree(funcVarIndex, subTree);
            optFuncExpr.setSourceVar(funcVarIndex, var);
            VariableReferenceExpression varRef = new VariableReferenceExpression(var);
            varRef.setSourceLocation(((ILogicalOperator)subTree.getDataSourceRef().getValue()).getSourceLocation());
            optFuncExpr.setLogicalExpr(funcVarIndex, (ILogicalExpression)varRef);
            this.setTypeTag(context, subTree, optFuncExpr, funcVarIndex);
            if (!subTree.hasDataSourceScan()) continue;
            this.fillIndexExprs(datasetIndexes, fieldName, fieldType, optFuncExpr, optFuncExprIndex, funcVarIndex, subTree, analysisCtx, fieldSource);
        }
    }

    private void setTypeTag(IOptimizationContext context, OptimizableOperatorSubTree subTree, IOptimizableFuncExpr optFuncExpr, int funcVarIndex) throws AlgebricksException {
        IAType type = (IAType)context.getOutputTypeEnvironment(subTree.getRoot()).getVarType(optFuncExpr.getLogicalVar(funcVarIndex));
        optFuncExpr.setFieldType(funcVarIndex, type);
    }

    protected void fillFieldNamesInTheSubTree(OptimizableOperatorSubTree subTree) throws AlgebricksException {
        LogicalVariable datasetMetaVar = null;
        if (subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN && subTree.getDataSourceType() != OptimizableOperatorSubTree.DataSourceType.INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP) {
            List<LogicalVariable> datasetVars = subTree.getDataSourceVariables();
            if (subTree.getDataset().hasMetaPart()) {
                datasetMetaVar = datasetVars.get(datasetVars.size() - 1);
            }
        }
        MutableInt fieldSource = new MutableInt(0);
        for (int assignOrUnnestIndex = 0; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
            AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
            if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)op;
                List varList = assignOp.getVariables();
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    fieldSource.setValue(0);
                    List<String> fieldName = AccessMethodUtils.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar, fieldSource, false);
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    subTree.getVarsToFieldNameMap().put(var, fieldName);
                }
                continue;
            }
            if (op.getOperatorTag() == LogicalOperatorTag.UNNEST) {
                UnnestOperator unnestOp = (UnnestOperator)op;
                LogicalVariable var = unnestOp.getVariable();
                List<String> fieldName = null;
                if (subTree.getDataSourceType() == OptimizableOperatorSubTree.DataSourceType.COLLECTION_SCAN) continue;
                fieldSource.setValue(0);
                fieldName = AccessMethodUtils.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, 0, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar, fieldSource, false);
                if (fieldName == null || fieldName.isEmpty()) continue;
                subTree.getVarsToFieldNameMap().put(var, fieldName);
                continue;
            }
            LeftOuterUnnestMapOperator leftOuterUnnestMapOp = null;
            UnnestMapOperator unnestMapOp = null;
            List varList = null;
            if (op.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
                unnestMapOp = (UnnestMapOperator)op;
                varList = unnestMapOp.getVariables();
            } else {
                if (op.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) continue;
                leftOuterUnnestMapOp = (LeftOuterUnnestMapOperator)op;
                varList = leftOuterUnnestMapOp.getVariables();
            }
            for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                fieldSource.setValue(0);
                List<String> fieldName = AccessMethodUtils.getFieldNameFromSubTree(null, subTree, assignOrUnnestIndex, varIndex, subTree.getRecordType(), -1, null, subTree.getMetaRecordType(), datasetMetaVar, fieldSource, false);
                if (fieldName == null || fieldName.isEmpty()) continue;
                subTree.getVarsToFieldNameMap().put(var, fieldName);
            }
        }
        if (subTree.hasDataSourceScan()) {
            ArrayList<LogicalVariable> primaryKeyVarList = new ArrayList<LogicalVariable>();
            if (subTree.getDataset().getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                subTree.getPrimaryKeyVars(null, primaryKeyVarList);
                Index primaryIndex = this.getPrimaryIndexFromDataSourceScanOp((ILogicalOperator)subTree.getDataSourceRef().getValue());
                List keyFieldNames = ((Index.ValueIndexDetails)primaryIndex.getIndexDetails()).getKeyFieldNames();
                for (int i = 0; i < primaryKeyVarList.size(); ++i) {
                    subTree.getVarsToFieldNameMap().put((LogicalVariable)primaryKeyVarList.get(i), (List)keyFieldNames.get(i));
                }
            }
        }
    }

    protected Index getPrimaryIndexFromDataSourceScanOp(ILogicalOperator dataSourceScanOp) throws AlgebricksException {
        if (dataSourceScanOp.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return null;
        }
        Pair<DataverseName, String> datasetInfo = AnalysisUtil.getDatasetInfo((AbstractDataSourceOperator)((DataSourceScanOperator)dataSourceScanOp));
        return this.metadataProvider.getIndex((DataverseName)datasetInfo.first, (String)datasetInfo.second, (String)datasetInfo.second);
    }
}

