/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import reactor.core.publisher.Mono;

final class HttpResponseHeaderDecoder {
    HttpResponseHeaderDecoder() {
    }

    static Mono<Object> decode(HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        Type headerType = decodeData.getHeadersType();
        if (headerType == null) {
            return Mono.empty();
        }
        return Mono.fromCallable(() -> serializer.deserialize(httpResponse.getHeaders(), decodeData.getHeadersType())).onErrorResume(IOException.class, e -> Mono.error((Throwable)new HttpResponseException("HTTP response has malformed headers", httpResponse, (Throwable)e)));
    }
}

