/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import reactor.core.publisher.Mono;

public class HttpPipelineNextPolicy {
    private final HttpPipeline pipeline;
    private final HttpPipelineCallContext context;
    private int currentPolicyIndex;

    HttpPipelineNextPolicy(HttpPipeline pipeline, HttpPipelineCallContext context) {
        this.pipeline = pipeline;
        this.context = context;
        this.currentPolicyIndex = -1;
    }

    public Mono<HttpResponse> process() {
        int size = this.pipeline.getPolicyCount();
        if (this.currentPolicyIndex > size) {
            return Mono.error((Throwable)new IllegalStateException("There is no more policies to execute."));
        }
        ++this.currentPolicyIndex;
        if (this.currentPolicyIndex == size) {
            return this.pipeline.getHttpClient().send(this.context.getHttpRequest());
        }
        return this.pipeline.getPolicy(this.currentPolicyIndex).process(this.context, this);
    }

    public HttpPipelineNextPolicy clone() {
        HttpPipelineNextPolicy cloned = new HttpPipelineNextPolicy(this.pipeline, this.context);
        cloned.currentPolicyIndex = this.currentPolicyIndex;
        return cloned;
    }
}

