/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractForwardOperatorDescriptor;

public abstract class AbstractForwardPOperator
extends AbstractPhysicalOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.FORWARD;
    }

    public abstract AbstractForwardOperatorDescriptor getOperatorDescriptor(IHyracksJobBuilder var1, ForwardOperator var2, RecordDescriptor var3);

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector requiredByParent, IOptimizationContext context) {
        INodeDomain targetDomain = context.getComputationNodeDomain();
        ArrayList<ILocalStructuralProperty> noProp = new ArrayList<ILocalStructuralProperty>();
        IPhysicalPropertiesVector[] requiredAtInputs = new StructuralPropertiesVector[]{StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR, new StructuralPropertiesVector(new BroadcastPartitioningProperty(targetDomain), noProp)};
        return new PhysicalRequirements(requiredAtInputs, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator dataSourceOperator = (ILogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = dataSourceOperator.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        ForwardOperator forwardOp = (ForwardOperator)op;
        RecordDescriptor dataInputDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment((ILogicalOperator)forwardOp.getInputs().get(0).getValue()), inputSchemas[0], context);
        AbstractForwardOperatorDescriptor forwardDescriptor = this.getOperatorDescriptor(builder, forwardOp, dataInputDescriptor);
        builder.contributeHyracksOperator(forwardOp, (IOperatorDescriptor)forwardDescriptor);
        ILogicalOperator dataSource = (ILogicalOperator)forwardOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(dataSource, 0, forwardOp, 0);
        ILogicalOperator sideDataSource = (ILogicalOperator)forwardOp.getInputs().get(1).getValue();
        builder.contributeGraphEdge(sideDataSource, 0, forwardOp, 1);
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] outputDependencyLabels = new int[]{1};
        int[] inputDependencyLabels = new int[]{1, 0};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

