/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.compression.file;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.PageWriteFailureCallback;
import org.apache.hyracks.storage.common.compression.file.CompressedFileManager;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

class LAFWriter
implements ICompressedPageWriter {
    private final CompressedFileManager compressedFileManager;
    private final IBufferCache bufferCache;
    private final IFIFOPageWriter pageWriter;
    private final Map<Integer, LAFFrame> cachedFrames;
    private final Queue<LAFFrame> recycledFrames;
    private final int fileId;
    private final int maxNumOfEntries;
    private final PageWriteFailureCallback failureCallback;
    private LAFFrame currentFrame;
    private int currentPageId;
    private int maxPageId;
    private long lastOffset;
    private int totalNumOfPages;

    public LAFWriter(CompressedFileManager compressedFileManager, IBufferCache bufferCache) {
        this.compressedFileManager = compressedFileManager;
        this.bufferCache = bufferCache;
        this.cachedFrames = new HashMap<Integer, LAFFrame>();
        this.recycledFrames = new ArrayDeque<LAFFrame>();
        this.fileId = compressedFileManager.getFileId();
        this.failureCallback = new PageWriteFailureCallback();
        this.pageWriter = bufferCache.createFIFOWriter(NoOpPageWriteCallback.INSTANCE, this.failureCallback);
        this.maxNumOfEntries = bufferCache.getPageSize() / 16;
        this.lastOffset = 0L;
        this.totalNumOfPages = 0;
        this.maxPageId = -1;
        this.currentPageId = -1;
    }

    @Override
    public void prepareWrite(ICachedPage cPage) throws HyracksDataException {
        ICachedPageInternal internalPage = (ICachedPageInternal)cPage;
        int entryPageId = this.getLAFEntryPageId(BufferedFileHandle.getPageId(internalPage.getDiskPageId()));
        try {
            this.prepareFrames(entryPageId, internalPage);
        }
        catch (HyracksDataException e) {
            this.abort();
            throw e;
        }
    }

    private void prepareFrames(int entryPageId, ICachedPageInternal cPage) throws HyracksDataException {
        if (!this.cachedFrames.containsKey(entryPageId)) {
            this.confiscatePage(entryPageId);
        }
        for (int i = 0; i < cPage.getFrameSizeMultiplier() - 1; ++i) {
            int extraEntryPageId = this.getLAFEntryPageId(cPage.getExtraBlockPageId() + i);
            if (this.cachedFrames.containsKey(extraEntryPageId)) continue;
            this.confiscatePage(extraEntryPageId);
        }
    }

    private void confiscatePage(int pageId) throws HyracksDataException {
        ICachedPage newPage = this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId(this.fileId, pageId));
        this.cachedFrames.put(pageId, this.getLAFFrame(newPage));
        this.maxPageId = Math.max(this.maxPageId, pageId);
    }

    private LAFFrame getLAFFrame(ICachedPage cPage) {
        LAFFrame lafFrame = this.recycledFrames.poll();
        if (lafFrame == null) {
            lafFrame = new LAFFrame();
        }
        lafFrame.setCachedPage(cPage);
        return lafFrame;
    }

    @Override
    public void endWriting() throws HyracksDataException {
        if (this.failureCallback.hasFailed()) {
            this.abort();
            throw HyracksDataException.create((Throwable)this.failureCallback.getFailure());
        }
        LAFFrame lastPage = this.cachedFrames.get(this.maxPageId);
        if (lastPage != null && !lastPage.isFull()) {
            lastPage.setEOF();
        }
        for (Map.Entry<Integer, LAFFrame> entry : this.cachedFrames.entrySet()) {
            this.pageWriter.write(entry.getValue().cPage);
        }
        this.compressedFileManager.endWriting(this.totalNumOfPages);
    }

    @Override
    public void abort() {
        for (Map.Entry<Integer, LAFFrame> frame : this.cachedFrames.entrySet()) {
            this.bufferCache.returnPage(frame.getValue().cPage);
        }
    }

    public long writePageInfo(int pageId, long size) throws HyracksDataException {
        LAFFrame frame = this.getPageBuffer(pageId);
        long pageOffset = this.lastOffset;
        frame.writePageInfo(pageId, pageOffset, size);
        this.lastOffset += size;
        ++this.totalNumOfPages;
        this.writeFullPage();
        return pageOffset;
    }

    private LAFFrame getPageBuffer(int compressedPageId) {
        int pageId = this.getLAFEntryPageId(compressedPageId);
        if (this.currentPageId == pageId) {
            return this.currentFrame;
        }
        LAFFrame frame = this.cachedFrames.get(pageId);
        if (frame == null) {
            this.abort();
            throw new IllegalStateException("Unprepared compressed-write for page ID: " + pageId);
        }
        this.currentFrame = frame;
        this.currentPageId = pageId;
        return frame;
    }

    private void writeFullPage() throws HyracksDataException {
        if (this.currentFrame.isFull()) {
            this.pageWriter.write(this.currentFrame.cPage);
            LAFFrame frame = this.cachedFrames.remove(this.currentPageId);
            frame.setCachedPage(null);
            this.recycledFrames.add(frame);
            this.currentFrame = null;
            this.currentPageId = -1;
        }
    }

    private int getLAFEntryPageId(int compressedPageId) {
        return compressedPageId * 16 / this.bufferCache.getPageSize();
    }

    private class LAFFrame {
        private ICachedPage cPage;
        private int numOfEntries;
        private int maxEntryOffset;

        private LAFFrame() {
        }

        public void setCachedPage(ICachedPage cPage) {
            this.cPage = cPage;
            this.numOfEntries = 0;
            this.maxEntryOffset = -1;
        }

        public void writePageInfo(int compressedPageId, long offset, long size) {
            int entryOffset = compressedPageId * 16 % LAFWriter.this.bufferCache.getPageSize();
            this.cPage.getBuffer().putLong(entryOffset, offset);
            this.cPage.getBuffer().putLong(entryOffset + 8, size);
            this.maxEntryOffset = Math.max(this.maxEntryOffset, entryOffset);
            ++this.numOfEntries;
        }

        public void setEOF() {
            this.cPage.getBuffer().putLong(this.maxEntryOffset + 16, -1L);
        }

        public boolean isFull() {
            return this.numOfEntries == LAFWriter.this.maxNumOfEntries;
        }
    }
}

