/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.replication;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.replication.AllDatasetsReplicationStrategy;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.MetadataOnlyReplicationStrategy;
import org.apache.asterix.common.replication.NoReplicationStrategy;

public class ReplicationStrategyFactory {
    private static final Map<String, Class<? extends IReplicationStrategy>> BUILT_IN_REPLICATION_STRATEGY = new HashMap<String, Class<? extends IReplicationStrategy>>();

    private ReplicationStrategyFactory() {
        throw new AssertionError();
    }

    public static IReplicationStrategy create(String name) {
        String strategyName = name.toLowerCase();
        if (!BUILT_IN_REPLICATION_STRATEGY.containsKey(strategyName)) {
            throw new IllegalStateException("Couldn't find strategy with name: " + name);
        }
        Class<? extends IReplicationStrategy> clazz = BUILT_IN_REPLICATION_STRATEGY.get(strategyName);
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Couldn't instantiated replication strategy: " + name, e);
        }
    }

    static {
        BUILT_IN_REPLICATION_STRATEGY.put("none", NoReplicationStrategy.class);
        BUILT_IN_REPLICATION_STRATEGY.put("all", AllDatasetsReplicationStrategy.class);
        BUILT_IN_REPLICATION_STRATEGY.put("metadata", MetadataOnlyReplicationStrategy.class);
    }
}

