/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class DeepCopyVisitor
extends AbstractSqlppQueryExpressionVisitor<ILangExpression, Void> {
    @Override
    public FromClause visit(FromClause fromClause, Void arg) throws CompilationException {
        ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            fromTerms.add((FromTerm)fromTerm.accept(this, arg));
        }
        FromClause copy = new FromClause(fromTerms);
        copy.setSourceLocation(fromClause.getSourceLocation());
        return copy;
    }

    @Override
    public FromTerm visit(FromTerm fromTerm, Void arg) throws CompilationException {
        Expression fromExpr = (Expression)fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr fromVar = (VariableExpr)fromTerm.getLeftVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr positionVar = fromTerm.getPositionalVariable() == null ? null : (VariableExpr)fromTerm.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        ArrayList<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            correlateClauses.add((AbstractBinaryCorrelateClause)((Object)correlateClause.accept(this, arg)));
        }
        FromTerm copy = new FromTerm(fromExpr, fromVar, positionVar, correlateClauses);
        copy.setSourceLocation(fromTerm.getSourceLocation());
        return copy;
    }

    @Override
    public JoinClause visit(JoinClause joinClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)joinClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)joinClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = joinClause.getPositionalVariable() == null ? null : (VariableExpr)joinClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        Expression conditionExpresion = (Expression)joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
        JoinClause copy = new JoinClause(joinClause.getJoinType(), rightExpression, rightVar, rightPositionVar, conditionExpresion);
        copy.setSourceLocation(joinClause.getSourceLocation());
        return copy;
    }

    @Override
    public NestClause visit(NestClause nestClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)nestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)nestClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = nestClause.getPositionalVariable() == null ? null : (VariableExpr)nestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        Expression conditionExpresion = (Expression)nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
        NestClause copy = new NestClause(nestClause.getNestType(), rightExpression, rightVar, rightPositionVar, conditionExpresion);
        copy.setSourceLocation(nestClause.getSourceLocation());
        return copy;
    }

    @Override
    public UnnestClause visit(UnnestClause unnestClause, Void arg) throws CompilationException {
        Expression rightExpression = (Expression)unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightVar = (VariableExpr)unnestClause.getRightVariable().accept((ILangVisitor)this, (Object)arg);
        VariableExpr rightPositionVar = unnestClause.getPositionalVariable() == null ? null : (VariableExpr)unnestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)arg);
        UnnestClause copy = new UnnestClause(unnestClause.getUnnestType(), rightExpression, rightVar, rightPositionVar);
        copy.setSourceLocation(unnestClause.getSourceLocation());
        return copy;
    }

    @Override
    public Projection visit(Projection projection, Void arg) throws CompilationException {
        Projection copy = new Projection(projection.star() ? null : (Expression)projection.getExpression().accept((ILangVisitor)this, (Object)arg), projection.getName(), projection.star(), projection.varStar());
        copy.setSourceLocation(projection.getSourceLocation());
        return copy;
    }

    @Override
    public SelectBlock visit(SelectBlock selectBlock, Void arg) throws CompilationException {
        FromClause fromClause = null;
        ArrayList<AbstractClause> letWhereClauses = new ArrayList<AbstractClause>();
        GroupbyClause gbyClause = null;
        ArrayList<AbstractClause> gbyLetHavingClauses = new ArrayList<AbstractClause>();
        if (selectBlock.hasFromClause()) {
            fromClause = (FromClause)selectBlock.getFromClause().accept(this, arg);
        }
        if (selectBlock.hasLetWhereClauses()) {
            List<AbstractClause> letWhereList = selectBlock.getLetWhereList();
            for (AbstractClause letWhereClause : letWhereList) {
                letWhereClauses.add((AbstractClause)letWhereClause.accept((ILangVisitor)this, (Object)arg));
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            gbyClause = (GroupbyClause)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            List<AbstractClause> letHavingListAfterGby = selectBlock.getLetHavingListAfterGroupby();
            for (AbstractClause letHavingClauseAfterGby : letHavingListAfterGby) {
                gbyLetHavingClauses.add((AbstractClause)letHavingClauseAfterGby.accept((ILangVisitor)this, (Object)arg));
            }
        }
        SelectClause selectClause = (SelectClause)selectBlock.getSelectClause().accept(this, arg);
        SelectBlock copy = new SelectBlock(selectClause, fromClause, letWhereClauses, gbyClause, gbyLetHavingClauses);
        copy.setSourceLocation(selectBlock.getSourceLocation());
        return copy;
    }

    @Override
    public SelectClause visit(SelectClause selectClause, Void arg) throws CompilationException {
        SelectElement selectElement = null;
        SelectRegular selectRegular = null;
        if (selectClause.selectElement()) {
            selectElement = (SelectElement)selectClause.getSelectElement().accept(this, arg);
        }
        if (selectClause.selectRegular()) {
            selectRegular = (SelectRegular)selectClause.getSelectRegular().accept(this, arg);
        }
        SelectClause copy = new SelectClause(selectElement, selectRegular, selectClause.distinct());
        copy.setSourceLocation(selectClause.getSourceLocation());
        return copy;
    }

    @Override
    public SelectElement visit(SelectElement selectElement, Void arg) throws CompilationException {
        SelectElement copy = new SelectElement((Expression)selectElement.getExpression().accept((ILangVisitor)this, (Object)arg));
        copy.setSourceLocation(selectElement.getSourceLocation());
        return copy;
    }

    @Override
    public SelectRegular visit(SelectRegular selectRegular, Void arg) throws CompilationException {
        ArrayList<Projection> projections = new ArrayList<Projection>();
        for (Projection projection : selectRegular.getProjections()) {
            projections.add((Projection)projection.accept(this, arg));
        }
        SelectRegular copy = new SelectRegular(projections);
        copy.setSourceLocation(selectRegular.getSourceLocation());
        return copy;
    }

    @Override
    public SelectSetOperation visit(SelectSetOperation selectSetOperation, Void arg) throws CompilationException {
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        SetOperationInput newLeftInput = leftInput.selectBlock() ? new SetOperationInput((SelectBlock)leftInput.accept(this, arg), null) : new SetOperationInput(null, (SelectExpression)leftInput.accept(this, arg));
        ArrayList<SetOperationRight> rightInputs = new ArrayList<SetOperationRight>();
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            SetOperationInput setOpRightInput = right.getSetOperationRightInput();
            SetOperationInput newRightInput = setOpRightInput.selectBlock() ? new SetOperationInput((SelectBlock)setOpRightInput.accept(this, arg), null) : new SetOperationInput(null, (SelectExpression)setOpRightInput.accept(this, arg));
            rightInputs.add(new SetOperationRight(right.getSetOpType(), right.isSetSemantics(), newRightInput));
        }
        SelectSetOperation copy = new SelectSetOperation(newLeftInput, rightInputs);
        copy.setSourceLocation(selectSetOperation.getSourceLocation());
        return copy;
    }

    @Override
    public HavingClause visit(HavingClause havingClause, Void arg) throws CompilationException {
        HavingClause copy = new HavingClause((Expression)havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)arg));
        copy.setSourceLocation(havingClause.getSourceLocation());
        return copy;
    }

    public Query visit(Query q, Void arg) throws CompilationException {
        Query copy = new Query(q.isExplain(), q.isTopLevel(), (Expression)q.getBody().accept((ILangVisitor)this, (Object)arg), q.getVarCounter());
        copy.setSourceLocation(q.getSourceLocation());
        return copy;
    }

    public FunctionDecl visit(FunctionDecl fd, Void arg) throws CompilationException {
        FunctionDecl copy = new FunctionDecl(fd.getSignature(), fd.getParamList(), (Expression)fd.getFuncBody().accept((ILangVisitor)this, (Object)arg), fd.isStored());
        copy.setSourceLocation(fd.getSourceLocation());
        return copy;
    }

    public WhereClause visit(WhereClause whereClause, Void arg) throws CompilationException {
        WhereClause copy = new WhereClause((Expression)whereClause.getWhereExpr().accept((ILangVisitor)this, (Object)arg));
        copy.setSourceLocation(whereClause.getSourceLocation());
        return copy;
    }

    public OrderbyClause visit(OrderbyClause oc, Void arg) throws CompilationException {
        ArrayList<Expression> newOrderbyList = new ArrayList<Expression>();
        for (Expression orderExpr : oc.getOrderbyList()) {
            newOrderbyList.add((Expression)orderExpr.accept((ILangVisitor)this, (Object)arg));
        }
        OrderbyClause copy = new OrderbyClause(newOrderbyList, new ArrayList(oc.getModifierList()));
        copy.setSourceLocation(oc.getSourceLocation());
        return copy;
    }

    public GroupbyClause visit(GroupbyClause gc, Void arg) throws CompilationException {
        List gbyList = gc.getGbyPairList();
        ArrayList newGbyList = new ArrayList(gbyList.size());
        for (Object gbyPairList : gbyList) {
            ArrayList<GbyVariableExpressionPair> newGbyPairList = new ArrayList<GbyVariableExpressionPair>(gbyPairList.size());
            Iterator iterator = gbyPairList.iterator();
            while (iterator.hasNext()) {
                GbyVariableExpressionPair gbyVarExpr = (GbyVariableExpressionPair)iterator.next();
                VariableExpr var = gbyVarExpr.getVar();
                newGbyPairList.add(new GbyVariableExpressionPair(var == null ? null : (VariableExpr)var.accept((ILangVisitor)this, (Object)arg), (Expression)gbyVarExpr.getExpr().accept((ILangVisitor)this, (Object)arg)));
            }
            newGbyList.add(newGbyPairList);
        }
        ArrayList<GbyVariableExpressionPair> decorPairList = new ArrayList<GbyVariableExpressionPair>();
        if (gc.hasDecorList()) {
            for (Object gbyVarExpr : gc.getDecorPairList()) {
                VariableExpr variableExpr = gbyVarExpr.getVar();
                decorPairList.add(new GbyVariableExpressionPair(variableExpr == null ? null : (VariableExpr)variableExpr.accept((ILangVisitor)this, (Object)arg), (Expression)gbyVarExpr.getExpr().accept((ILangVisitor)this, (Object)arg)));
            }
        }
        HashMap<Expression, VariableExpr> withVarMap = new HashMap<Expression, VariableExpr>();
        if (gc.hasWithMap()) {
            for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
                withVarMap.put((Expression)((Expression)entry.getKey()).accept((ILangVisitor)this, (Object)arg), (VariableExpr)((VariableExpr)entry.getValue()).accept((ILangVisitor)this, (Object)arg));
            }
        }
        VariableExpr groupVarExpr = null;
        if (gc.hasGroupVar()) {
            groupVarExpr = (VariableExpr)gc.getGroupVar().accept((ILangVisitor)this, (Object)arg);
        }
        List<Pair<Expression, Identifier>> list = this.copyFieldList(gc.getGroupFieldList(), arg);
        GroupbyClause copy = new GroupbyClause(newGbyList, decorPairList, withVarMap, groupVarExpr, list, gc.hasHashGroupByHint(), gc.isGroupAll());
        copy.setSourceLocation(gc.getSourceLocation());
        return copy;
    }

    public LimitClause visit(LimitClause limitClause, Void arg) throws CompilationException {
        Expression limitExpr = limitClause.hasLimitExpr() ? (Expression)limitClause.getLimitExpr().accept((ILangVisitor)this, (Object)arg) : null;
        Expression offsetExpr = limitClause.hasOffset() ? (Expression)limitClause.getOffset().accept((ILangVisitor)this, (Object)arg) : null;
        LimitClause copy = new LimitClause(limitExpr, offsetExpr);
        copy.setSourceLocation(limitClause.getSourceLocation());
        return copy;
    }

    public LetClause visit(LetClause letClause, Void arg) throws CompilationException {
        LetClause copy = new LetClause((VariableExpr)letClause.getVarExpr().accept((ILangVisitor)this, (Object)arg), (Expression)letClause.getBindingExpr().accept((ILangVisitor)this, (Object)arg));
        copy.setSourceLocation(letClause.getSourceLocation());
        return copy;
    }

    @Override
    public SelectExpression visit(SelectExpression selectExpression, Void arg) throws CompilationException {
        ArrayList<LetClause> lets = new ArrayList<LetClause>();
        OrderbyClause orderby = null;
        LimitClause limit = null;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                lets.add((LetClause)letClause.accept((ILangVisitor)this, (Object)arg));
            }
        }
        SelectSetOperation select = (SelectSetOperation)selectExpression.getSelectSetOperation().accept(this, arg);
        if (selectExpression.hasOrderby()) {
            orderby = (OrderbyClause)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectExpression.hasLimit()) {
            limit = (LimitClause)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)arg);
        }
        SelectExpression copy = new SelectExpression(lets, select, orderby, limit, selectExpression.isSubquery());
        copy.setSourceLocation(select.getSourceLocation());
        copy.addHints(selectExpression.getHints());
        return copy;
    }

    public LiteralExpr visit(LiteralExpr l, Void arg) throws CompilationException {
        return l;
    }

    public ListConstructor visit(ListConstructor lc, Void arg) throws CompilationException {
        ListConstructor copy = new ListConstructor(lc.getType(), this.copyExprList(lc.getExprList(), arg));
        copy.setSourceLocation(lc.getSourceLocation());
        copy.addHints(lc.getHints());
        return copy;
    }

    public RecordConstructor visit(RecordConstructor rc, Void arg) throws CompilationException {
        ArrayList<FieldBinding> bindings = new ArrayList<FieldBinding>();
        for (FieldBinding binding : rc.getFbList()) {
            FieldBinding fb = new FieldBinding((Expression)binding.getLeftExpr().accept((ILangVisitor)this, (Object)arg), (Expression)binding.getRightExpr().accept((ILangVisitor)this, (Object)arg));
            bindings.add(fb);
        }
        RecordConstructor copy = new RecordConstructor(bindings);
        copy.setSourceLocation(rc.getSourceLocation());
        copy.addHints(rc.getHints());
        return copy;
    }

    public OperatorExpr visit(OperatorExpr operatorExpr, Void arg) throws CompilationException {
        OperatorExpr copy = new OperatorExpr(this.copyExprList(operatorExpr.getExprList(), arg), operatorExpr.getOpList(), operatorExpr.isCurrentop());
        copy.setSourceLocation(operatorExpr.getSourceLocation());
        copy.addHints(operatorExpr.getHints());
        return copy;
    }

    public IfExpr visit(IfExpr ifExpr, Void arg) throws CompilationException {
        Expression conditionExpr = (Expression)ifExpr.getCondExpr().accept((ILangVisitor)this, (Object)arg);
        Expression thenExpr = (Expression)ifExpr.getThenExpr().accept((ILangVisitor)this, (Object)arg);
        Expression elseExpr = (Expression)ifExpr.getElseExpr().accept((ILangVisitor)this, (Object)arg);
        IfExpr copy = new IfExpr(conditionExpr, thenExpr, elseExpr);
        copy.setSourceLocation(ifExpr.getSourceLocation());
        copy.addHints(ifExpr.getHints());
        return copy;
    }

    public QuantifiedExpression visit(QuantifiedExpression qe, Void arg) throws CompilationException {
        ArrayList<QuantifiedPair> quantifiedPairs = new ArrayList<QuantifiedPair>();
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            Expression expr = (Expression)pair.getExpr().accept((ILangVisitor)this, (Object)arg);
            VariableExpr var = (VariableExpr)pair.getVarExpr().accept((ILangVisitor)this, (Object)arg);
            quantifiedPairs.add(new QuantifiedPair(var, expr));
        }
        Expression condition = (Expression)qe.getSatisfiesExpr().accept((ILangVisitor)this, (Object)arg);
        QuantifiedExpression copy = new QuantifiedExpression(qe.getQuantifier(), quantifiedPairs, condition);
        copy.setSourceLocation(qe.getSourceLocation());
        copy.addHints(qe.getHints());
        return copy;
    }

    public CallExpr visit(CallExpr callExpr, Void arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : callExpr.getExprList()) {
            newExprList.add((Expression)expr.accept((ILangVisitor)this, (Object)arg));
        }
        Expression newFilterExpr = callExpr.hasAggregateFilterExpr() ? (Expression)callExpr.getAggregateFilterExpr().accept((ILangVisitor)this, (Object)arg) : null;
        CallExpr copy = new CallExpr(callExpr.getFunctionSignature(), newExprList, newFilterExpr);
        copy.setSourceLocation(callExpr.getSourceLocation());
        copy.addHints(callExpr.getHints());
        return copy;
    }

    public VariableExpr visit(VariableExpr varExpr, Void arg) throws CompilationException {
        VariableExpr clonedVar = new VariableExpr(new VarIdentifier(varExpr.getVar()));
        clonedVar.setSourceLocation(varExpr.getSourceLocation());
        clonedVar.setIsNewVar(varExpr.getIsNewVar());
        clonedVar.addHints(varExpr.getHints());
        return clonedVar;
    }

    public UnaryExpr visit(UnaryExpr u, Void arg) throws CompilationException {
        UnaryExpr copy = new UnaryExpr(u.getExprType(), (Expression)u.getExpr().accept((ILangVisitor)this, (Object)arg));
        copy.setSourceLocation(u.getSourceLocation());
        copy.addHints(u.getHints());
        return copy;
    }

    public FieldAccessor visit(FieldAccessor fa, Void arg) throws CompilationException {
        FieldAccessor copy = new FieldAccessor((Expression)fa.getExpr().accept((ILangVisitor)this, (Object)arg), fa.getIdent());
        copy.setSourceLocation(fa.getSourceLocation());
        copy.addHints(fa.getHints());
        return copy;
    }

    public Expression visit(IndexAccessor ia, Void arg) throws CompilationException {
        Expression expr = (Expression)ia.getExpr().accept((ILangVisitor)this, (Object)arg);
        Expression indexExpr = null;
        if (ia.getIndexExpr() != null) {
            indexExpr = (Expression)ia.getIndexExpr().accept((ILangVisitor)this, (Object)arg);
        }
        IndexAccessor copy = new IndexAccessor(expr, ia.getIndexKind(), indexExpr);
        copy.setSourceLocation(ia.getSourceLocation());
        copy.addHints(ia.getHints());
        return copy;
    }

    public Expression visit(ListSliceExpression expression, Void arg) throws CompilationException {
        Expression expr = (Expression)expression.getExpr().accept((ILangVisitor)this, (Object)arg);
        Expression startIndexExpression = (Expression)expression.getStartIndexExpression().accept((ILangVisitor)this, (Object)arg);
        Expression endIndexExpression = null;
        if (expression.hasEndExpression()) {
            endIndexExpression = (Expression)expression.getEndIndexExpression().accept((ILangVisitor)this, (Object)arg);
        }
        ListSliceExpression copy = new ListSliceExpression(expr, startIndexExpression, endIndexExpression);
        copy.setSourceLocation(expression.getSourceLocation());
        copy.addHints(expression.getHints());
        return copy;
    }

    @Override
    public ILangExpression visit(CaseExpression caseExpr, Void arg) throws CompilationException {
        Expression conditionExpr = (Expression)caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)arg);
        List<Expression> whenExprList = this.copyExprList(caseExpr.getWhenExprs(), arg);
        List<Expression> thenExprList = this.copyExprList(caseExpr.getThenExprs(), arg);
        Expression elseExpr = (Expression)caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)arg);
        CaseExpression copy = new CaseExpression(conditionExpr, whenExprList, thenExprList, elseExpr);
        copy.setSourceLocation(caseExpr.getSourceLocation());
        copy.addHints(caseExpr.getHints());
        return copy;
    }

    @Override
    public ILangExpression visit(WindowExpression winExpr, Void arg) throws CompilationException {
        List<Expression> newExprList = this.copyExprList(winExpr.getExprList(), arg);
        Expression newAggFilterExpr = winExpr.hasAggregateFilterExpr() ? (Expression)winExpr.getAggregateFilterExpr().accept((ILangVisitor)this, (Object)arg) : null;
        List<Expression> newPartitionList = winExpr.hasPartitionList() ? this.copyExprList(winExpr.getPartitionList(), arg) : null;
        List<Expression> newOrderbyList = winExpr.hasOrderByList() ? this.copyExprList(winExpr.getOrderbyList(), arg) : null;
        ArrayList<OrderbyClause.OrderModifier> newOrderbyModifierList = winExpr.hasOrderByList() ? new ArrayList<OrderbyClause.OrderModifier>(winExpr.getOrderbyModifierList()) : null;
        Expression newFrameStartExpr = winExpr.hasFrameStartExpr() ? (Expression)winExpr.getFrameStartExpr().accept((ILangVisitor)this, (Object)arg) : null;
        Expression newFrameEndExpr = winExpr.hasFrameEndExpr() ? (Expression)winExpr.getFrameEndExpr().accept((ILangVisitor)this, (Object)arg) : null;
        VariableExpr newWindowVar = winExpr.hasWindowVar() ? (VariableExpr)winExpr.getWindowVar().accept((ILangVisitor)this, (Object)arg) : null;
        List<Pair<Expression, Identifier>> newWindowFieldList = winExpr.hasWindowFieldList() ? this.copyFieldList(winExpr.getWindowFieldList(), arg) : null;
        WindowExpression copy = new WindowExpression(winExpr.getFunctionSignature(), newExprList, newAggFilterExpr, newPartitionList, newOrderbyList, newOrderbyModifierList, winExpr.getFrameMode(), winExpr.getFrameStartKind(), newFrameStartExpr, winExpr.getFrameEndKind(), newFrameEndExpr, winExpr.getFrameExclusionKind(), newWindowVar, newWindowFieldList, winExpr.getIgnoreNulls(), winExpr.getFromLast());
        copy.setSourceLocation(winExpr.getSourceLocation());
        copy.addHints(winExpr.getHints());
        return copy;
    }

    private List<Expression> copyExprList(List<Expression> exprs, Void arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : exprs) {
            newExprList.add((Expression)expr.accept((ILangVisitor)this, (Object)arg));
        }
        return newExprList;
    }

    private List<Pair<Expression, Identifier>> copyFieldList(List<Pair<Expression, Identifier>> fieldList, Void arg) throws CompilationException {
        ArrayList<Pair<Expression, Identifier>> newFieldList = new ArrayList<Pair<Expression, Identifier>>(fieldList.size());
        for (Pair<Expression, Identifier> field : fieldList) {
            newFieldList.add((Pair<Expression, Identifier>)new Pair((Object)((Expression)((Expression)field.first).accept((ILangVisitor)this, (Object)arg)), (Object)((Identifier)field.second)));
        }
        return newFieldList;
    }
}

