/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import java.util.Locale;

public final class AccountSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean listPermission;
    private boolean updatePermission;
    private boolean processMessagesPermission;

    public static AccountSasPermission parse(String permString) {
        AccountSasPermission permissions = new AccountSasPermission();
        block10: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block10;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block10;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block10;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block10;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block10;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block10;
                }
                case 'u': {
                    permissions.updatePermission = true;
                    continue block10;
                }
                case 'p': {
                    permissions.processMessagesPermission = true;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public AccountSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public AccountSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public AccountSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public AccountSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public AccountSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public AccountSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public boolean hasUpdatePermission() {
        return this.updatePermission;
    }

    public AccountSasPermission setUpdatePermission(boolean hasUpdatePermission) {
        this.updatePermission = hasUpdatePermission;
        return this;
    }

    public boolean hasProcessMessages() {
        return this.processMessagesPermission;
    }

    public AccountSasPermission setProcessMessages(boolean hasProcessMessagesPermission) {
        this.processMessagesPermission = hasProcessMessagesPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.updatePermission) {
            builder.append('u');
        }
        if (this.processMessagesPermission) {
            builder.append('p');
        }
        return builder.toString();
    }
}

