/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.ParallelTransferOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UploadUtils {
    public static <T> Mono<Response<T>> uploadFullOrChunked(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, Function<Flux<ByteBuffer>, Mono<Response<T>>> uploadInChunks, BiFunction<Flux<ByteBuffer>, Long, Mono<Response<T>>> uploadFull) {
        long[] bufferedDataSize = new long[]{0L};
        LinkedList cachedBuffers = new LinkedList();
        return data.filter(Buffer::hasRemaining).windowUntil(buffer -> {
            if (bufferedDataSize[0] > (long)parallelTransferOptions.getMaxSingleUploadSize().intValue()) {
                return false;
            }
            bufferedDataSize[0] = bufferedDataSize[0] + (long)buffer.remaining();
            if (bufferedDataSize[0] > (long)parallelTransferOptions.getMaxSingleUploadSize().intValue()) {
                return true;
            }
            ByteBuffer cachedBuffer = ByteBuffer.allocate(buffer.remaining()).put((ByteBuffer)buffer);
            cachedBuffer.flip();
            cachedBuffers.add(cachedBuffer);
            return false;
        }, true, Integer.MAX_VALUE).buffer(2).next().flatMap(fluxes -> {
            if (fluxes.size() == 1) {
                return (Mono)uploadFull.apply(Flux.fromIterable((Iterable)cachedBuffers), bufferedDataSize[0]);
            }
            return (Mono)uploadInChunks.apply(UploadUtils.dequeuingFlux(cachedBuffers).concatWith((Publisher)fluxes.get(1)));
        }).switchIfEmpty(uploadFull.apply((Flux<ByteBuffer>)Flux.empty(), 0L));
    }

    private static Flux<ByteBuffer> dequeuingFlux(Queue<ByteBuffer> queue) {
        return Flux.generate(sink -> {
            ByteBuffer buffer = (ByteBuffer)queue.poll();
            if (buffer != null) {
                sink.next((Object)buffer);
            } else {
                sink.complete();
            }
        });
    }

    public static Flux<ByteBuffer> chunkSource(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        return data.flatMapSequential(buffer -> {
            if (buffer.remaining() <= parallelTransferOptions.getBlockSize()) {
                return Flux.just((Object)buffer);
            }
            int numSplits = (int)Math.ceil((double)buffer.remaining() / (double)parallelTransferOptions.getBlockSize().intValue());
            return Flux.range((int)0, (int)numSplits).map(i -> {
                ByteBuffer duplicate = buffer.duplicate().asReadOnlyBuffer();
                duplicate.position(i * parallelTransferOptions.getBlockSize());
                duplicate.limit(Math.min(duplicate.limit(), (i + 1) * parallelTransferOptions.getBlockSize()));
                return duplicate;
            });
        });
    }

    public static boolean shouldUploadInChunks(String filePath, Integer maxSingleUploadSize, ClientLogger logger) {
        boolean retVal;
        AsynchronousFileChannel channel = UploadUtils.uploadFileResourceSupplier(filePath, logger);
        try {
            retVal = channel.size() > (long)maxSingleUploadSize.intValue();
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        finally {
            UploadUtils.uploadFileCleanup(channel, logger);
        }
        return retVal;
    }

    public static AsynchronousFileChannel uploadFileResourceSupplier(String filePath, ClientLogger logger) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public static void uploadFileCleanup(AsynchronousFileChannel channel, ClientLogger logger) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }
}

