/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.JobArenaManager;
import org.apache.asterix.transaction.management.service.locking.RequestArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceGroupTable;
import org.apache.asterix.transaction.management.service.locking.TablePrinter;
import org.apache.asterix.transaction.management.service.transaction.TransactionManagementConstants;

public class ResourceTablePrinter
implements TablePrinter {
    private ResourceGroupTable table;
    private ResourceArenaManager resArenaMgr;
    private RequestArenaManager reqArenaMgr;
    private JobArenaManager jobArenaMgr;

    ResourceTablePrinter(ResourceGroupTable table, ResourceArenaManager resArenaMgr, RequestArenaManager reqArenaMgr, JobArenaManager jobArenaMgr) {
        this.table = table;
        this.resArenaMgr = resArenaMgr;
        this.reqArenaMgr = reqArenaMgr;
        this.jobArenaMgr = jobArenaMgr;
    }

    @Override
    public StringBuilder append(StringBuilder sb) {
        this.table.getAllLatches();
        sb.append("[\n");
        int i = 0;
        long res = -1L;
        while (res == -1L && i < this.table.size) {
            res = this.table.get((int)i++).firstResourceIndex;
        }
        while (i < this.table.size) {
            sb = this.appendResource(sb, res);
            res = this.resArenaMgr.getNext(res);
            while (res == -1L && i < this.table.size) {
                res = this.table.get((int)i++).firstResourceIndex;
            }
            if (res == -1L) {
                sb.append("\n");
                break;
            }
            sb.append(",\n");
        }
        this.table.releaseAllLatches();
        return sb.append("]");
    }

    StringBuilder appendResource(StringBuilder sb, long res) {
        long firstWaiter;
        long firstUpgrader;
        sb.append("{ \"dataset\": ").append(this.resArenaMgr.getDatasetId(res));
        sb.append(", \"hash\": ").append(this.resArenaMgr.getPkHashVal(res));
        sb.append(", \"max mode\": ").append(ResourceTablePrinter.string(this.resArenaMgr.getMaxMode(res)));
        long lastHolder = this.resArenaMgr.getLastHolder(res);
        if (lastHolder != -1L) {
            sb = this.appendRequests(sb.append(", \"holders\": "), lastHolder);
        }
        if ((firstUpgrader = this.resArenaMgr.getFirstUpgrader(res)) != -1L) {
            sb = this.appendRequests(sb.append(", \"upgraders\": "), firstUpgrader);
        }
        if ((firstWaiter = this.resArenaMgr.getFirstWaiter(res)) != -1L) {
            sb = this.appendRequests(sb.append(", \"waiters\": "), firstWaiter);
        }
        return sb.append(" }");
    }

    StringBuilder appendRequests(StringBuilder sb, long req) {
        sb.append("[ ");
        while (req != -1L) {
            this.appendRequest(sb, req);
            req = this.reqArenaMgr.getNextRequest(req);
            sb.append(req == -1L ? " ]" : ", ");
        }
        return sb;
    }

    StringBuilder appendRequest(StringBuilder sb, long req) {
        long job = this.reqArenaMgr.getJobSlot(req);
        sb.append("{ \"job\": ").append(this.jobArenaMgr.getTxnId(job));
        sb.append(", \"mode\": \"").append(ResourceTablePrinter.string(this.reqArenaMgr.getLockMode(req)));
        return sb.append("\" }");
    }

    private static final String string(int lockMode) {
        return TransactionManagementConstants.LockManagerConstants.LockMode.toString((byte)lockMode);
    }
}

