/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import org.apache.asterix.common.api.IIdentifierMapper;

public class IdentifierMappingUtil {
    private static final String SINGULAR_DATASET = "a dataset";
    private static final String PLURAL_DATASET = "datasets";
    private static final String SINGULAR_DATAVERSE = "a dataverse";
    private static final String PLURAL_DATAVERSE = "dataverses";
    private static final IIdentifierMapper DEFAULT_MAPPER;
    private static IIdentifierMapper mapper;

    private IdentifierMappingUtil() {
    }

    public static void setMapper(IIdentifierMapper mapper) {
        IdentifierMappingUtil.mapper = mapper;
    }

    public static String map(String key, IIdentifierMapper.Modifier modifier) {
        return mapper.map(key, modifier);
    }

    static {
        mapper = DEFAULT_MAPPER = (identifier, modifier) -> {
            switch (identifier) {
                case "dataset": {
                    switch (modifier) {
                        case NONE: {
                            return "dataset";
                        }
                        case SINGULAR: {
                            return SINGULAR_DATASET;
                        }
                        case PLURAL: {
                            return PLURAL_DATASET;
                        }
                    }
                    throw new IllegalArgumentException("unknown modifier " + modifier);
                }
                case "dataverse": {
                    switch (modifier) {
                        case NONE: {
                            return "dataverse";
                        }
                        case SINGULAR: {
                            return SINGULAR_DATAVERSE;
                        }
                        case PLURAL: {
                            return PLURAL_DATAVERSE;
                        }
                    }
                    throw new IllegalArgumentException("unknown modifier " + modifier);
                }
            }
            throw new IllegalArgumentException("unmapped identifier: " + identifier);
        };
    }
}

