/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.accessors;

public class MurmurHash3BinaryHash {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int C3 = 5;
    private static final int C4 = -430675100;
    private static final int C5 = -2048144789;
    private static final int C6 = -1028477387;

    private MurmurHash3BinaryHash() {
    }

    public static int hash(byte[] bytes, int offset, int length, int seed) {
        int k;
        int remain;
        int h = seed;
        int p = offset;
        for (remain = length; remain >= 4; remain -= 4) {
            k = bytes[p] & 0xFF | (bytes[p + 1] & 0xFF) << 8 | (bytes[p + 2] & 0xFF) << 16 | (bytes[p + 3] & 0xFF) << 24;
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            h ^= (k *= 461845907);
            h = Integer.rotateLeft(h, 13);
            h = h * 5 + -430675100;
            p += 4;
        }
        if (remain > 0) {
            k = 0;
            int i = 0;
            while (remain > 0) {
                k ^= (bytes[p++] & 0xFF) << i;
                --remain;
                i += 8;
            }
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            h ^= (k *= 461845907);
        }
        h ^= length;
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }
}

