/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.AbstractAccessor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class IndexAccessor
extends AbstractAccessor {
    private IndexKind indexKind;
    private Expression indexExpr;

    public IndexAccessor(Expression expr, IndexKind indexKind, Expression indexExpr) {
        super(expr);
        if (indexKind != IndexKind.ELEMENT && indexExpr != null) {
            throw new IllegalArgumentException(indexExpr.toString());
        }
        this.indexKind = Objects.requireNonNull(indexKind);
        this.indexExpr = indexExpr;
    }

    public IndexKind getIndexKind() {
        return this.indexKind;
    }

    public void setIndexKind(IndexKind indexKind) {
        this.indexKind = indexKind;
    }

    public Expression getIndexExpr() {
        return this.indexExpr;
    }

    public void setIndexExpr(Expression indexExpr) {
        this.indexExpr = indexExpr;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.INDEX_ACCESSOR_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.indexKind, this.indexExpr});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexAccessor)) {
            return false;
        }
        IndexAccessor target = (IndexAccessor)object;
        return super.equals(target) && this.indexKind == target.indexKind && Objects.equals(this.indexExpr, target.indexExpr);
    }

    public String toString() {
        return this.expr + "[" + this.indexKind + "(" + this.indexExpr + ")]";
    }

    public static enum IndexKind {
        ELEMENT,
        ANY,
        STAR;

    }
}

