/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public final class SourceLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int line;
    private final int column;

    public SourceLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public int getColumn() {
        return this.column;
    }

    public static void writeFields(SourceLocation sourceLocation, DataOutput output) throws IOException {
        if (sourceLocation == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(sourceLocation.getLine());
            output.writeInt(sourceLocation.getColumn());
        }
    }

    public static SourceLocation create(DataInput dataInput) throws IOException {
        int row = dataInput.readInt();
        if (row == -1) {
            return null;
        }
        return new SourceLocation(row, dataInput.readInt());
    }
}

