/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CollectionMemberResultType
extends AbstractResultTypeComputer {
    public static final CollectionMemberResultType INSTANCE = new CollectionMemberResultType(false, false);
    public static final CollectionMemberResultType INSTANCE_NULLABLE = new CollectionMemberResultType(true, false);
    public static final CollectionMemberResultType INSTANCE_MISSABLE = new CollectionMemberResultType(false, true);
    private final boolean nullable;
    private final boolean missable;

    private CollectionMemberResultType(boolean nullable, boolean missable) {
        this.missable = missable;
        this.nullable = nullable;
    }

    @Override
    protected void checkArgType(FunctionIdentifier funcId, int argIndex, IAType type, SourceLocation sourceLoc) throws AlgebricksException {
        if (argIndex == 0) {
            ATypeTag actualTypeTag = type.getTypeTag();
            if (!type.getTypeTag().isListType()) {
                throw new TypeMismatchException(sourceLoc, actualTypeTag, ATypeTag.MULTISET, ATypeTag.ARRAY);
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType type = strippedInputTypes[0];
        if (!type.getTypeTag().isListType()) {
            return BuiltinType.ANY;
        }
        IAType itemType = ((AbstractCollectionType)type).getItemType();
        if (this.nullable) {
            itemType = AUnionType.createNullableType(itemType);
        }
        if (this.missable) {
            itemType = AUnionType.createMissableType(itemType);
        }
        return itemType;
    }
}

