/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class BitMultipleValuesTypeComputer
extends AbstractResultTypeComputer {
    public static final BitMultipleValuesTypeComputer INSTANCE_INT32 = new BitMultipleValuesTypeComputer(1, BuiltinType.AINT32);
    public static final BitMultipleValuesTypeComputer INSTANCE_INT64 = new BitMultipleValuesTypeComputer(1, BuiltinType.AINT64);
    private final int minArgs;
    private final IAType returnType;

    private BitMultipleValuesTypeComputer(int minArgs, IAType returnType) {
        this.minArgs = minArgs;
        this.returnType = returnType;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        if (strippedInputTypes.length < this.minArgs) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(ErrorCode.COMPILATION_INVALID_NUM_OF_ARGS, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        boolean isReturnNullable = false;
        block4: for (IAType type : strippedInputTypes) {
            switch (type.getTypeTag()) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case ANY: {
                    continue block4;
                }
                case FLOAT: 
                case DOUBLE: {
                    isReturnNullable = true;
                    continue block4;
                }
                default: {
                    return BuiltinType.ANULL;
                }
            }
        }
        return isReturnNullable ? AUnionType.createNullableType(this.returnType) : this.returnType;
    }
}

