/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.ComponentReplacementContext;
import org.apache.hyracks.storage.am.lsm.common.impls.EmptyComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.NoOpIoOperation;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMHarness
implements ILSMHarness {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ILSMIndex lsmIndex;
    protected final ILSMIOOperationScheduler ioScheduler;
    protected final ComponentReplacementContext componentReplacementCtx;
    protected final ILSMMergePolicy mergePolicy;
    protected final ILSMOperationTracker opTracker;
    protected final AtomicBoolean fullMergeIsRequested;
    protected final boolean replicationEnabled;
    protected List<ILSMDiskComponent> componentsToBeReplicated;
    protected ITracer tracer;
    protected long traceCategory;

    public LSMHarness(ILSMIndex lsmIndex, ILSMIOOperationScheduler ioScheduler, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, boolean replicationEnabled, ITracer tracer) {
        this.lsmIndex = lsmIndex;
        this.ioScheduler = ioScheduler;
        this.opTracker = opTracker;
        this.mergePolicy = mergePolicy;
        this.tracer = tracer;
        this.traceCategory = tracer.getRegistry().get("release-memory-component");
        this.fullMergeIsRequested = new AtomicBoolean();
        boolean bl = this.replicationEnabled = replicationEnabled && lsmIndex.isDurable();
        if (replicationEnabled) {
            this.componentsToBeReplicated = new ArrayList<ILSMDiskComponent>();
        }
        this.componentReplacementCtx = new ComponentReplacementContext(lsmIndex);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean getAndEnterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean isTryOperation) throws HyracksDataException {
        before = 0L;
        if (ctx.isTracingEnabled()) {
            before = System.nanoTime();
        }
        try {
            this.validateOperationEnterComponentsState(ctx);
            var6_5 = this.opTracker;
            // MONITORENTER : var6_5
            while (true) lbl-1000:
            // 2 sources

            {
                this.lsmIndex.getOperationalComponents(ctx);
                if (this.enterComponents(ctx, opType)) {
                    var7_6 = true;
                    // MONITOREXIT : var6_5
                    if (ctx.isTracingEnabled() == false) return var7_6;
                    ctx.incrementEnterExitTime(System.nanoTime() - before);
                    return var7_6;
                }
                if (!isTryOperation) break block12;
                var7_7 = false;
                break;
            }
        }
        catch (Throwable var9_9) {
            if (ctx.isTracingEnabled() == false) throw var9_9;
            ctx.incrementEnterExitTime(System.nanoTime() - before);
            throw var9_9;
        }
        {
            block12: {
                // MONITOREXIT : var6_5
                if (ctx.isTracingEnabled() == false) return var7_7;
                ctx.incrementEnterExitTime(System.nanoTime() - before);
                return var7_7;
            }
            try {
                this.opTracker.wait(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
            ** while (true)
        }
    }

    protected boolean enterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType) throws HyracksDataException {
        boolean entranceSuccessful;
        block10: {
            boolean isMutableComponent;
            ILSMComponent component;
            int i;
            int componentsCount;
            this.validateOperationEnterComponentsState(ctx);
            List<ILSMComponent> components = ctx.getComponentHolder();
            int numEntered = 0;
            entranceSuccessful = false;
            try {
                componentsCount = components.size();
                for (i = 0; i < componentsCount; ++i) {
                    component = components.get(i);
                    boolean bl = isMutableComponent = numEntered == 0 && component.getType() == ILSMComponent.LSMComponentType.MEMORY;
                    if (!component.threadEnter(opType, isMutableComponent)) break;
                    ++numEntered;
                }
                boolean bl = entranceSuccessful = numEntered == components.size();
                if (entranceSuccessful) break block10;
                componentsCount = components.size();
            }
            catch (Throwable e) {
                try {
                    LOGGER.warn("{} failed to enter components on {}", (Object)opType.name(), (Object)this.lsmIndex, (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!entranceSuccessful) {
                        int componentsCount2 = components.size();
                        for (int i2 = 0; i2 < componentsCount2; ++i2) {
                            ILSMComponent component2 = components.get(i2);
                            if (numEntered == 0) break;
                            boolean isMutableComponent2 = i2 == 0 && component2.getType() == ILSMComponent.LSMComponentType.MEMORY;
                            component2.threadExit(opType, true, isMutableComponent2);
                            --numEntered;
                        }
                    }
                    throw throwable;
                }
            }
            for (i = 0; i < componentsCount; ++i) {
                component = components.get(i);
                if (numEntered != 0) {
                    isMutableComponent = i == 0 && component.getType() == ILSMComponent.LSMComponentType.MEMORY;
                    component.threadExit(opType, true, isMutableComponent);
                    --numEntered;
                    continue;
                }
                break;
            }
        }
        if (!entranceSuccessful) {
            return false;
        }
        ctx.setAccessingComponents(true);
        this.opTracker.beforeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doExitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        List<ILSMMemoryComponent> inactiveMemoryComponents;
        Object iLSMOperationTracker;
        ArrayList<ILSMMemoryComponent> inactiveMemoryComponentsToBeCleanedUp;
        List inactiveDiskComponentsToBeDeleted;
        block40: {
            List<ILSMDiskComponent> list;
            if (!ctx.isAccessingComponents() && opType != LSMOperationType.FLUSH && opType != LSMOperationType.MERGE) {
                return;
            }
            inactiveDiskComponentsToBeDeleted = null;
            inactiveMemoryComponentsToBeCleanedUp = null;
            try {
                block42: {
                    block39: {
                        ILSMOperationTracker iLSMOperationTracker2 = this.opTracker;
                        // MONITORENTER : iLSMOperationTracker2
                        try {
                            if (opType == LSMOperationType.FLUSH) {
                                this.opTracker.notifyAll();
                                if (!failedOperation) {
                                    this.waitForLaggingMerge();
                                }
                            } else if (opType == LSMOperationType.MERGE) {
                                this.opTracker.notifyAll();
                            }
                            this.exitOperationalComponents(ctx, opType, failedOperation);
                            ctx.setAccessingComponents(false);
                            this.exitOperation(ctx, opType, newComponent, failedOperation);
                            if (!failedOperation || opType != LSMOperationType.MODIFICATION && opType != LSMOperationType.FORCE_MODIFICATION) break block39;
                        }
                        catch (Throwable throwable) {
                            try {
                                LOGGER.warn("Failure exiting components", throwable);
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                List<ILSMMemoryComponent> inactiveMemoryComponents2;
                                if (failedOperation && (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION)) {
                                    this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                                } else {
                                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                                }
                                List<ILSMDiskComponent> inactiveDiskComponents = this.lsmIndex.getInactiveDiskComponents();
                                if (!inactiveDiskComponents.isEmpty()) {
                                    for (ILSMDiskComponent inactiveComp : inactiveDiskComponents) {
                                        if (inactiveComp.getFileReferenceCount() != 1) continue;
                                        inactiveDiskComponentsToBeDeleted = inactiveDiskComponentsToBeDeleted == null ? new ArrayList() : inactiveDiskComponentsToBeDeleted;
                                        inactiveDiskComponentsToBeDeleted.add(inactiveComp);
                                    }
                                    if (inactiveDiskComponentsToBeDeleted != null) {
                                        inactiveDiskComponents.removeAll(inactiveDiskComponentsToBeDeleted);
                                    }
                                }
                                if ((inactiveMemoryComponents2 = this.lsmIndex.getInactiveMemoryComponents()).isEmpty()) throw throwable2;
                                inactiveMemoryComponentsToBeCleanedUp = new ArrayList<ILSMMemoryComponent>(inactiveMemoryComponents2);
                                inactiveMemoryComponents2.clear();
                                throw throwable2;
                            }
                        }
                        this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                        break block42;
                    }
                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                }
                list = this.lsmIndex.getInactiveDiskComponents();
                if (list.isEmpty()) break block40;
                iLSMOperationTracker = list.iterator();
            }
            catch (Throwable throwable) {
                if (inactiveDiskComponentsToBeDeleted != null) {
                    try {
                        if (this.replicationEnabled) {
                            this.lsmIndex.scheduleReplication(null, inactiveDiskComponentsToBeDeleted, IReplicationJob.ReplicationOperation.DELETE, opType);
                        }
                        for (ILSMComponent c : inactiveDiskComponentsToBeDeleted) {
                            c.deactivateAndDestroy();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isWarnEnabled()) throw e;
                        LOGGER.log(Level.WARN, "Failure scheduling replication or destroying merged component", e);
                        throw e;
                    }
                }
                if (inactiveMemoryComponentsToBeCleanedUp != null) {
                    for (ILSMComponent c : inactiveMemoryComponentsToBeCleanedUp) {
                        this.tracer.instant(c.toString(), this.traceCategory, ITracer.Scope.p, this.lsmIndex.toString());
                        c.cleanup();
                        ILSMOperationTracker iLSMOperationTracker3 = this.opTracker;
                        // MONITORENTER : iLSMOperationTracker3
                        c.reset();
                        this.opTracker.notifyAll();
                        // MONITOREXIT : iLSMOperationTracker3
                    }
                }
                if (opType != LSMOperationType.FLUSH) throw throwable;
                ILSMMemoryComponent flushingComponent2 = (ILSMMemoryComponent)ctx.getComponentHolder().get(0);
                flushingComponent2.flushed();
                throw throwable;
            }
            while (iLSMOperationTracker.hasNext()) {
                ILSMDiskComponent inactiveComp = iLSMOperationTracker.next();
                if (inactiveComp.getFileReferenceCount() != 1) continue;
                inactiveDiskComponentsToBeDeleted = inactiveDiskComponentsToBeDeleted == null ? new ArrayList() : inactiveDiskComponentsToBeDeleted;
                inactiveDiskComponentsToBeDeleted.add(inactiveComp);
            }
            if (inactiveDiskComponentsToBeDeleted != null) {
                list.removeAll(inactiveDiskComponentsToBeDeleted);
            }
        }
        if (!(inactiveMemoryComponents = this.lsmIndex.getInactiveMemoryComponents()).isEmpty()) {
            inactiveMemoryComponentsToBeCleanedUp = new ArrayList<ILSMMemoryComponent>(inactiveMemoryComponents);
            inactiveMemoryComponents.clear();
        }
        // MONITOREXIT : iLSMOperationTracker2
        if (inactiveDiskComponentsToBeDeleted != null) {
            try {
                if (this.replicationEnabled) {
                    this.lsmIndex.scheduleReplication(null, inactiveDiskComponentsToBeDeleted, IReplicationJob.ReplicationOperation.DELETE, opType);
                }
                for (ILSMDiskComponent iLSMDiskComponent : inactiveDiskComponentsToBeDeleted) {
                    iLSMDiskComponent.deactivateAndDestroy();
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isWarnEnabled()) throw e;
                LOGGER.log(Level.WARN, "Failure scheduling replication or destroying merged component", e);
                throw e;
            }
        }
        if (inactiveMemoryComponentsToBeCleanedUp != null) {
            for (ILSMMemoryComponent iLSMMemoryComponent : inactiveMemoryComponentsToBeCleanedUp) {
                this.tracer.instant(iLSMMemoryComponent.toString(), this.traceCategory, ITracer.Scope.p, this.lsmIndex.toString());
                iLSMMemoryComponent.cleanup();
                iLSMOperationTracker = this.opTracker;
                // MONITORENTER : iLSMOperationTracker
                iLSMMemoryComponent.reset();
                this.opTracker.notifyAll();
                // MONITOREXIT : iLSMOperationTracker
            }
        }
        if (opType != LSMOperationType.FLUSH) return;
        ILSMMemoryComponent flushingComponent = (ILSMMemoryComponent)ctx.getComponentHolder().get(0);
        flushingComponent.flushed();
    }

    private void exitOperation(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        switch (opType) {
            case FLUSH: {
                if (failedOperation || newComponent == null) break;
                this.lsmIndex.addDiskComponent(newComponent);
                if (this.replicationEnabled && newComponent != EmptyComponent.INSTANCE) {
                    this.componentsToBeReplicated.clear();
                    this.componentsToBeReplicated.add(newComponent);
                    this.triggerReplication(this.componentsToBeReplicated, opType);
                }
                this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
                break;
            }
            case MERGE: {
                if (failedOperation || newComponent == null) break;
                this.lsmIndex.subsumeMergedComponents(newComponent, ctx.getComponentHolder());
                if (this.replicationEnabled && newComponent != EmptyComponent.INSTANCE) {
                    this.componentsToBeReplicated.clear();
                    this.componentsToBeReplicated.add(newComponent);
                    this.triggerReplication(this.componentsToBeReplicated, opType);
                }
                this.mergePolicy.diskComponentAdded(this.lsmIndex, this.fullMergeIsRequested.get());
                break;
            }
        }
    }

    private void exitOperationalComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean failedOperation) throws HyracksDataException {
        List<ILSMComponent> componentHolder = ctx.getComponentHolder();
        int componentsCount = componentHolder.size();
        for (int i = 0; i < componentsCount; ++i) {
            ILSMComponent c = componentHolder.get(i);
            boolean isMutableComponent = i == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
            boolean needsCleanup = c.threadExit(opType, failedOperation, isMutableComponent);
            if (c.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                if (c.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE && isMutableComponent && (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION)) {
                    this.lsmIndex.changeFlushStatusForCurrentMutableCompoent(true);
                }
                if (!needsCleanup) continue;
                this.lsmIndex.addInactiveMemoryComponent((ILSMMemoryComponent)c);
                continue;
            }
            if (c.getState() != ILSMComponent.ComponentState.INACTIVE) continue;
            this.lsmIndex.addInactiveDiskComponent((AbstractLSMDiskComponent)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        long before = 0L;
        if (ctx.isTracingEnabled()) {
            before = System.nanoTime();
        }
        try {
            this.doExitComponents(ctx, opType, newComponent, failedOperation);
        }
        finally {
            if (ctx.isTracingEnabled()) {
                ctx.incrementEnterExitTime(System.nanoTime() - before);
            }
        }
    }

    @Override
    public void forceModify(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.FORCE_MODIFICATION;
        this.modify(ctx, false, tuple, opType);
    }

    @Override
    public boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.MODIFICATION;
        return this.modify(ctx, tryOperation, tuple, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.MODIFICATION, false);
        try {
            AbstractLSMMemoryComponent c = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            c.getMetadata().put(key, value);
            c.setModified();
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.MODIFICATION);
        }
    }

    private void exitAndComplete(ILSMIndexOperationContext ctx, LSMOperationType op) throws HyracksDataException {
        try {
            this.exitComponents(ctx, op, null, false);
        }
        finally {
            this.opTracker.completeOperation(null, op, null, (IModificationOperationCallback)ctx.getModificationCallback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.FORCE_MODIFICATION, false);
        try {
            AbstractLSMMemoryComponent c = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            c.getMetadata().put(key, value);
            c.setModified();
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.FORCE_MODIFICATION);
        }
    }

    private boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple, LSMOperationType opType) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        boolean failedOperation = false;
        if (!this.getAndEnterComponents(ctx, opType, tryOperation)) {
            return false;
        }
        try {
            this.lsmIndex.modify(ctx, tuple);
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            mutableComponent.setModified();
        }
        catch (Exception e) {
            failedOperation = true;
            throw e;
        }
        finally {
            this.exitComponents(ctx, opType, null, failedOperation);
        }
        return true;
    }

    @Override
    public void search(ILSMIndexOperationContext ctx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.SEARCH;
        ctx.setSearchPredicate(pred);
        ctx.getSearchOperationCallback().before(pred.getLowKey());
        this.getAndEnterComponents(ctx, opType, false);
        try {
            this.lsmIndex.search(ctx, cursor, pred);
        }
        catch (Exception e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endSearch(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.SEARCH) {
            try {
                this.exitComponents(ctx, LSMOperationType.SEARCH, null, false);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    @Override
    public void scanDiskComponents(ILSMIndexOperationContext ctx, IIndexCursor cursor) throws HyracksDataException {
        if (!this.lsmIndex.isPrimaryIndex()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.DISK_COMPONENT_SCAN_NOT_ALLOWED_FOR_SECONDARY_INDEX, (Serializable[])new Serializable[0]);
        }
        LSMOperationType opType = LSMOperationType.DISK_COMPONENT_SCAN;
        this.getAndEnterComponents(ctx, opType, false);
        try {
            ctx.getSearchOperationCallback().before(null);
            this.lsmIndex.scanDiskComponents(ctx, cursor);
        }
        catch (Exception e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endScanDiskComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.DISK_COMPONENT_SCAN) {
            try {
                this.exitComponents(ctx, LSMOperationType.DISK_COMPONENT_SCAN, null, false);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMIOOperation scheduleFlush(ILSMIndexOperationContext ctx) throws HyracksDataException {
        ILSMIOOperation flush;
        LOGGER.debug("Flush is being scheduled on {}", (Object)this.lsmIndex);
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            try {
                flush = this.lsmIndex.createFlushOperation(ctx);
            }
            finally {
                this.opTracker.notifyAll();
            }
        }
        this.ioScheduler.scheduleOperation(flush);
        return flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(ILSMIOOperation operation) throws HyracksDataException {
        LOGGER.debug("Started a flush operation for index: {}", (Object)this.lsmIndex);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            while (!this.enterComponents(operation.getAccessor().getOpContext(), LSMOperationType.FLUSH)) {
                try {
                    this.opTracker.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }
        try {
            this.doIo(operation);
            this.exitComponents(operation.getAccessor().getOpContext(), LSMOperationType.FLUSH, operation.getNewComponent(), operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE);
        }
        catch (Throwable throwable) {
            this.exitComponents(operation.getAccessor().getOpContext(), LSMOperationType.FLUSH, operation.getNewComponent(), operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE);
            this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.FLUSH, operation.getAccessor().getOpContext().getSearchOperationCallback(), (IModificationOperationCallback)operation.getAccessor().getOpContext().getModificationCallback());
            throw throwable;
        }
        this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.FLUSH, operation.getAccessor().getOpContext().getSearchOperationCallback(), (IModificationOperationCallback)operation.getAccessor().getOpContext().getModificationCallback());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished the flush operation for index: {}. Result: {}", (Object)this.lsmIndex, (Object)operation.getStatus());
        }
    }

    public void doIo(ILSMIOOperation operation) {
        try {
            operation.getCallback().beforeOperation(operation);
            ILSMDiskComponent newComponent = operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH ? this.lsmIndex.flush(operation) : this.lsmIndex.merge(operation);
            operation.setNewComponent(newComponent);
            operation.getCallback().afterOperation(operation);
            if (newComponent != null) {
                newComponent.markAsValid(this.lsmIndex.isDurable(), operation);
            }
        }
        catch (Throwable e) {
            operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
            operation.setFailure(e);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.log(Level.ERROR, "{} operation failed on {}", (Object)operation.getIOOpertionType(), (Object)this.lsmIndex, (Object)e);
            }
        }
        finally {
            block15: {
                try {
                    operation.getCallback().afterFinalize(operation);
                }
                catch (Throwable th) {
                    operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
                    operation.setFailure(th);
                    if (!LOGGER.isErrorEnabled()) break block15;
                    LOGGER.log(Level.ERROR, "{} operation.afterFinalize failed on {}", (Object)operation.getIOOpertionType(), (Object)this.lsmIndex, (Object)th);
                }
            }
        }
        if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            operation.cleanup(this.lsmIndex.getBufferCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(ILSMIOOperation operation) throws HyracksDataException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Started a merge operation for index: {}", (Object)this.lsmIndex);
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.enterComponents(operation.getAccessor().getOpContext(), LSMOperationType.MERGE);
        }
        try {
            this.doIo(operation);
            this.exitComponents(operation.getAccessor().getOpContext(), LSMOperationType.MERGE, operation.getNewComponent(), operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE);
        }
        catch (Throwable throwable) {
            this.exitComponents(operation.getAccessor().getOpContext(), LSMOperationType.MERGE, operation.getNewComponent(), operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE);
            this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.MERGE, operation.getAccessor().getOpContext().getSearchOperationCallback(), (IModificationOperationCallback)operation.getAccessor().getOpContext().getModificationCallback());
            throw throwable;
        }
        this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.MERGE, operation.getAccessor().getOpContext().getSearchOperationCallback(), (IModificationOperationCallback)operation.getAccessor().getOpContext().getModificationCallback());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished the merge operation for index: {}. Result: {}", (Object)this.lsmIndex, (Object)operation.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMIOOperation scheduleMerge(ILSMIndexOperationContext ctx) throws HyracksDataException {
        ILSMIOOperation operation;
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            operation = this.lsmIndex.createMergeOperation(ctx);
        }
        this.ioScheduler.scheduleOperation(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMIOOperation scheduleFullMerge(ILSMIndexOperationContext ctx) throws HyracksDataException {
        ILSMIOOperation operation;
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.fullMergeIsRequested.set(true);
            ctx.getComponentsToBeMerged().addAll(this.lsmIndex.getDiskComponents());
            operation = this.lsmIndex.createMergeOperation(ctx);
            if (operation != NoOpIoOperation.INSTANCE) {
                this.fullMergeIsRequested.set(false);
            }
        }
        this.ioScheduler.scheduleOperation(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBulkLoadedComponent(ILSMIOOperation ioOperation) throws HyracksDataException {
        ILSMDiskComponent c = ioOperation.getNewComponent();
        try {
            c.markAsValid(this.lsmIndex.isDurable(), ioOperation);
        }
        catch (Throwable th) {
            ioOperation.setFailure(th);
        }
        if (ioOperation.hasFailed()) {
            throw HyracksDataException.create((Throwable)ioOperation.getFailure());
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.addDiskComponent(c);
            if (this.replicationEnabled) {
                this.componentsToBeReplicated.clear();
                this.componentsToBeReplicated.add(c);
                this.triggerReplication(this.componentsToBeReplicated, LSMOperationType.LOAD);
            }
            this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
        }
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.opTracker;
    }

    protected void triggerReplication(List<ILSMDiskComponent> lsmComponents, LSMOperationType opType) throws HyracksDataException {
        ILSMIndexAccessor accessor = this.lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.scheduleReplication(lsmComponents, opType);
    }

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, LSMOperationType opType) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.REPLICATE, false)) {
            return;
        }
        this.lsmIndex.scheduleReplication(ctx, lsmComponents, IReplicationJob.ReplicationOperation.REPLICATE, opType);
    }

    @Override
    public void endReplication(ILSMIndexOperationContext ctx) throws HyracksDataException {
        this.exitComponents(ctx, LSMOperationType.REPLICATE, null, false);
    }

    protected void validateOperationEnterComponentsState(ILSMIndexOperationContext ctx) {
        if (ctx.isAccessingComponents()) {
            throw new IllegalStateException("Operation already has access to components of index " + this.lsmIndex);
        }
    }

    @Override
    public void updateFilter(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.lsmIndex.updateFilter(ctx, tuple);
    }

    private void enter(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.MODIFICATION, false);
    }

    private void exit(ILSMIndexOperationContext ctx) throws HyracksDataException {
        this.getAndExitComponentsAndComplete(ctx, LSMOperationType.MODIFICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndExitComponentsAndComplete(ILSMIndexOperationContext ctx, LSMOperationType op) throws HyracksDataException {
        this.validateOperationEnterComponentsState(ctx);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.getOperationalComponents(ctx);
            ctx.setAccessingComponents(true);
            this.exitAndComplete(ctx, op);
        }
    }

    @Override
    public void batchOperate(ILSMIndexOperationContext ctx, FrameTupleAccessor accessor, FrameTupleReference tuple, IFrameTupleProcessor processor, IFrameOperationCallback frameOpCallback) throws HyracksDataException {
        processor.start();
        this.enter(ctx);
        try {
            try {
                LSMHarness.processFrame(accessor, tuple, processor);
                frameOpCallback.frameCompleted();
            }
            catch (Throwable th) {
                processor.fail(th);
                throw th;
            }
            finally {
                processor.finish();
            }
        }
        catch (HyracksDataException e) {
            LOGGER.warn("Failed to process frame", (Throwable)e);
            throw e;
        }
        finally {
            this.exit(ctx);
            ctx.logPerformanceCounters(accessor.getTupleCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLaggingMerge() throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            while (this.mergePolicy.isMergeLagging(this.lsmIndex)) {
                try {
                    this.opTracker.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.log(Level.WARN, "Ignoring interrupt while waiting for lagging merge on " + this.lsmIndex, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteComponents(ILSMIndexOperationContext ctx, Predicate<ILSMComponent> predicate) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> toBeDeleted;
        Object memComponent;
        ILSMIOOperation ioOperation = null;
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.waitForFlushesAndMerges();
            memComponent = this.lsmIndex.getCurrentMemoryComponent();
            if (!predicate.test((ILSMComponent)memComponent)) {
                return;
            }
            ctx.reset();
            ctx.setOperation(IndexOperation.DELETE_COMPONENTS);
            ioOperation = this.scheduleFlush(ctx);
        }
        try {
            ioOperation.sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        if (ioOperation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            throw HyracksDataException.create((Throwable)ioOperation.getFailure());
        }
        ctx.reset();
        ctx.setOperation(IndexOperation.DELETE_COMPONENTS);
        memComponent = this.opTracker;
        synchronized (memComponent) {
            this.waitForFlushesAndMerges();
            List<ILSMDiskComponent> diskComponents = this.lsmIndex.getDiskComponents();
            for (ILSMDiskComponent component : diskComponents) {
                if (!predicate.test(component)) break;
                ctx.getComponentsToBeMerged().add(component);
            }
            if (ctx.getComponentsToBeMerged().isEmpty()) {
                return;
            }
            toBeDeleted = new ArrayList<ILSMDiskComponent>(ctx.getComponentsToBeMerged());
            ioOperation = this.scheduleMerge(ctx);
        }
        try {
            ioOperation.sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        if (ioOperation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            throw HyracksDataException.create((Throwable)ioOperation.getFailure());
        }
        ILSMOperationTracker iLSMOperationTracker2 = this.opTracker;
        synchronized (iLSMOperationTracker2) {
            for (ILSMDiskComponent component : toBeDeleted) {
                if (!this.lsmIndex.getDiskComponents().contains(component)) continue;
                throw HyracksDataException.create((ErrorCode)ErrorCode.A_MERGE_OPERATION_HAS_FAILED, (Serializable[])new Serializable[]{component.toString()});
            }
        }
    }

    private void waitForFlushesAndMerges() throws HyracksDataException {
        while (this.flushingOrMerging()) {
            try {
                this.opTracker.wait();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARN, "Interrupted while attempting component level delete", (Throwable)e);
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    private boolean flushingOrMerging() {
        for (ILSMMemoryComponent memComponent : this.lsmIndex.getMemoryComponents()) {
            if (memComponent.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) continue;
            return true;
        }
        for (ILSMDiskComponent diskComponent : this.lsmIndex.getDiskComponents()) {
            if (diskComponent.getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }

    private static void processFrame(FrameTupleAccessor accessor, FrameTupleReference tuple, IFrameTupleProcessor processor) throws HyracksDataException {
        int tupleCount = accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            tuple.reset((IFrameTupleAccessor)accessor, i);
            processor.process((ITupleReference)tuple, i);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.lsmIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceMemoryComponentsWithDiskComponents(ILSMIndexOperationContext ctx, int startIndex) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.componentReplacementCtx.reset();
            for (int i = 0; i < ctx.getComponentHolder().size(); ++i) {
                ILSMComponent next;
                if (i < startIndex || (next = ctx.getComponentHolder().get(i)).getType() != ILSMComponent.LSMComponentType.MEMORY || next.getState() != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) continue;
                this.componentReplacementCtx.getComponentHolder().add(next);
                this.componentReplacementCtx.swapIndex(i);
            }
            if (this.componentReplacementCtx.getComponentHolder().isEmpty()) {
                throw new IllegalStateException("replaceMemoryComponentsWithDiskComponents called with no potential components");
            }
            if (this.componentReplacementCtx.proceed(this.lsmIndex.getDiskComponents())) {
                this.exitComponents(this.componentReplacementCtx, LSMOperationType.SEARCH, null, false);
                this.componentReplacementCtx.prepareToEnter();
                this.enterComponents(this.componentReplacementCtx, LSMOperationType.SEARCH);
                this.componentReplacementCtx.replace(ctx);
            }
        }
    }
}

