/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractTripleStringEval
implements IScalarEvaluator {
    private final IEvaluatorContext ctx;
    private IScalarEvaluator eval0;
    private IScalarEvaluator eval1;
    private IScalarEvaluator eval2;
    final IPointable argPtrFirst = new VoidPointable();
    final IPointable argPtrSecond = new VoidPointable();
    final IPointable argPtrThird = new VoidPointable();
    private final UTF8StringPointable strPtr1st = new UTF8StringPointable();
    private final UTF8StringPointable strPtr2nd = new UTF8StringPointable();
    private final UTF8StringPointable strPtr3rd = new UTF8StringPointable();
    ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    DataOutput dout = this.resultStorage.getDataOutput();
    protected final FunctionIdentifier funcID;
    protected final SourceLocation sourceLoc;

    AbstractTripleStringEval(IEvaluatorContext context, IScalarEvaluatorFactory eval0, IScalarEvaluatorFactory eval1, IScalarEvaluatorFactory eval2, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
        this.eval0 = eval0.createScalarEvaluator(context);
        this.eval1 = eval1.createScalarEvaluator(context);
        this.eval2 = eval2.createScalarEvaluator(context);
        this.funcID = funcID;
        this.sourceLoc = sourceLoc;
        this.ctx = context;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval0.evaluate(tuple, this.argPtrFirst);
        this.eval1.evaluate(tuple, this.argPtrSecond);
        this.eval2.evaluate(tuple, this.argPtrThird);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtrFirst, this.argPtrSecond, this.argPtrThird)) {
            return;
        }
        byte[] bytes0 = this.argPtrFirst.getByteArray();
        int start0 = this.argPtrFirst.getStartOffset();
        int len0 = this.argPtrFirst.getLength();
        byte[] bytes1 = this.argPtrSecond.getByteArray();
        int start1 = this.argPtrSecond.getStartOffset();
        int len1 = this.argPtrSecond.getLength();
        byte[] bytes2 = this.argPtrThird.getByteArray();
        int start2 = this.argPtrThird.getStartOffset();
        int len2 = this.argPtrThird.getLength();
        if (bytes0[start0] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(result);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes0[start0], (int)0, (ATypeTag)ATypeTag.STRING);
            return;
        }
        if (bytes1[start1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(result);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes1[start1], (int)1, (ATypeTag)ATypeTag.STRING);
            return;
        }
        if (bytes2[start2] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(result);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes2[start2], (int)2, (ATypeTag)ATypeTag.STRING);
            return;
        }
        this.strPtr1st.set(bytes0, start0 + 1, len0 - 1);
        this.strPtr2nd.set(bytes1, start1 + 1, len1 - 1);
        this.strPtr3rd.set(bytes2, start2 + 1, len2 - 1);
        this.resultStorage.reset();
        this.process(this.strPtr1st, this.strPtr2nd, this.strPtr3rd, result);
    }

    protected abstract void process(UTF8StringPointable var1, UTF8StringPointable var2, UTF8StringPointable var3, IPointable var4) throws HyracksDataException;
}

