/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

public class PointableHashSet {
    private final IObjectPool<List<IPointable>, ATypeTag> listAllocator;
    private final IBinaryComparator comparator;
    private final IBinaryHashFunction hashFunction;
    private final Int2ObjectMap<List<IPointable>> hashes;

    public PointableHashSet(IObjectPool<List<IPointable>, ATypeTag> listAllocator, IAType itemType) {
        this.listAllocator = listAllocator;
        this.comparator = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)itemType, (Object)itemType, true).createBinaryComparator();
        this.hashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory((Object)itemType).createBinaryHashFunction();
        this.hashes = new Int2ObjectOpenHashMap();
    }

    public void clear() {
        this.hashes.clear();
    }

    public boolean add(IPointable item) throws HyracksDataException {
        int hash = this.hashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength());
        List sameHashes = (List)this.hashes.get(hash);
        if (sameHashes == null) {
            sameHashes = (List)this.listAllocator.allocate(null);
            sameHashes.clear();
            sameHashes.add(this.makeStoredItem(item));
            this.hashes.put(hash, (Object)sameHashes);
            return true;
        }
        if (PointableHelper.findItem((IValueReference)item, sameHashes, this.comparator) == null) {
            sameHashes.add(this.makeStoredItem(item));
            return true;
        }
        return false;
    }

    protected IPointable makeStoredItem(IPointable item) throws HyracksDataException {
        return item;
    }
}

