/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITupleUpdater;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.common.IIndexCursor;

public class BTreeUpdateSearchOperatorNodePushable
extends BTreeSearchOperatorNodePushable {
    private final ITupleUpdater tupleUpdater;

    public BTreeUpdateSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, ITupleUpdater tupleUpdater, boolean appendIndexFilter) throws HyracksDataException {
        super(ctx, partition, inputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, null, null, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter);
        this.tupleUpdater = tupleUpdater;
    }

    protected IIndexCursor createCursor() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        ITreeIndexFrame cursorFrame = treeIndex.getLeafFrameFactory().createFrame();
        return new BTreeRangeSearchCursor((IBTreeLeafFrame)cursorFrame, true);
    }

    protected void writeSearchResults(int tupleIndex) throws Exception {
        while (this.cursor.hasNext()) {
            this.tb.reset();
            this.cursor.next();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            ITupleReference tuple = this.cursor.getTuple();
            this.tupleUpdater.updateTuple(tuple);
            for (int i = 0; i < tuple.getFieldCount(); ++i) {
                this.dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
        }
    }
}

