/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.TupleFieldEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;

public class IndexingConstants {
    public static final String EXTERNAL_FILE_INDEX_NAME_SUFFIX = "FilesIndex";
    public static final String KEY_INPUT_FORMAT = "input-format";
    public static final String INPUT_FORMAT_RC = "rc-input-format";
    public static final String INPUT_FORMAT_RC_FULLY_QUALIFIED = "org.apache.asterix.hivecompat.io.RCFileInputFormat";
    public static final IAType FILE_NUMBER_FIELD_TYPE = BuiltinType.AINT32;
    public static final IAType RECORD_OFFSET_FIELD_TYPE = BuiltinType.AINT64;
    public static final IAType ROW_NUMBER_FIELD_TYPE = BuiltinType.AINT32;
    private static final IBinaryComparatorFactory fileNumberCompFactory = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.AINT32, true);
    private static final IBinaryComparatorFactory recordOffsetCompFactory = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.AINT64, true);
    private static final IBinaryComparatorFactory rowNumberCompFactory = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.AINT32, true);
    private static final IBinaryComparatorFactory[] rCFileRIDComparatorFactories = new IBinaryComparatorFactory[]{fileNumberCompFactory, recordOffsetCompFactory, rowNumberCompFactory};
    private static final IBinaryComparatorFactory[] txtSeqFileRIDComparatorFactories = new IBinaryComparatorFactory[]{fileNumberCompFactory, recordOffsetCompFactory};
    private static final IBinaryComparatorFactory[] buddyBtreeComparatorFactories = new IBinaryComparatorFactory[]{fileNumberCompFactory};
    private static ISerializerDeserializer fileNumberSerializerDeserializer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)FILE_NUMBER_FIELD_TYPE);
    private static ISerializerDeserializer recordOffsetSerializerDeserializer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)RECORD_OFFSET_FIELD_TYPE);
    private static ISerializerDeserializer rowNumberSerializerDeserializer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)ROW_NUMBER_FIELD_TYPE);
    private static ITypeTraits fileNumberTypeTraits = TypeTraitProvider.INSTANCE.getTypeTrait((Object)FILE_NUMBER_FIELD_TYPE);
    private static ITypeTraits recordOffsetTypeTraits = TypeTraitProvider.INSTANCE.getTypeTrait((Object)RECORD_OFFSET_FIELD_TYPE);
    private static ITypeTraits rowNumberTypeTraits = TypeTraitProvider.INSTANCE.getTypeTrait((Object)ROW_NUMBER_FIELD_TYPE);
    private static final IScalarEvaluatorFactory fileNumberEvalFactory = new TupleFieldEvaluatorFactory(1);
    private static final IScalarEvaluatorFactory recordOffsetEvalFactory = new TupleFieldEvaluatorFactory(2);
    private static final IScalarEvaluatorFactory rowNumberEvalFactory = new TupleFieldEvaluatorFactory(3);
    public static final int FILE_NUMBER_FIELD_INDEX = 0;
    public static final int RECORD_OFFSET_FIELD_INDEX = 1;
    public static final int ROW_NUMBER_FIELD_INDEX = 2;
    public static final List<List<String>> RECORD_ID_FIELDS;

    private IndexingConstants() {
    }

    public static int getRIDSize(String fileInputFormat) {
        if (fileInputFormat.equals(INPUT_FORMAT_RC) || fileInputFormat.equals(INPUT_FORMAT_RC_FULLY_QUALIFIED)) {
            return 3;
        }
        return 2;
    }

    public static IBinaryComparatorFactory[] getComparatorFactories(String fileInputFormat) {
        if (fileInputFormat.equals(INPUT_FORMAT_RC) || fileInputFormat.equals(INPUT_FORMAT_RC_FULLY_QUALIFIED)) {
            return rCFileRIDComparatorFactories;
        }
        return txtSeqFileRIDComparatorFactories;
    }

    public static IAType getFieldType(int fieldNumber) throws AsterixException {
        switch (fieldNumber) {
            case 0: {
                return FILE_NUMBER_FIELD_TYPE;
            }
            case 1: {
                return RECORD_OFFSET_FIELD_TYPE;
            }
            case 2: {
                return ROW_NUMBER_FIELD_TYPE;
            }
        }
        throw new AsterixException("Unknown external field RID number");
    }

    public static IBinaryComparatorFactory getComparatorFactory(int fieldNumber) throws AsterixException {
        switch (fieldNumber) {
            case 0: {
                return fileNumberCompFactory;
            }
            case 1: {
                return recordOffsetCompFactory;
            }
            case 2: {
                return rowNumberCompFactory;
            }
        }
        throw new AsterixException("Unknown external field RID number");
    }

    public static ISerializerDeserializer getSerializerDeserializer(int fieldNumber) throws AsterixException {
        switch (fieldNumber) {
            case 0: {
                return fileNumberSerializerDeserializer;
            }
            case 1: {
                return recordOffsetSerializerDeserializer;
            }
            case 2: {
                return rowNumberSerializerDeserializer;
            }
        }
        throw new AsterixException("Unknown external field RID number");
    }

    public static ITypeTraits getTypeTraits(int fieldNumber) throws AsterixException {
        switch (fieldNumber) {
            case 0: {
                return fileNumberTypeTraits;
            }
            case 1: {
                return recordOffsetTypeTraits;
            }
            case 2: {
                return rowNumberTypeTraits;
            }
        }
        throw new AsterixException("Unknown external field RID number");
    }

    public static IScalarEvaluatorFactory getEvalFactory(int fieldNumber) throws AsterixException {
        switch (fieldNumber) {
            case 0: {
                return fileNumberEvalFactory;
            }
            case 1: {
                return recordOffsetEvalFactory;
            }
            case 2: {
                return rowNumberEvalFactory;
            }
        }
        throw new AsterixException("Unknown external field RID number");
    }

    public static IBinaryComparatorFactory[] getBuddyBtreeComparatorFactories() {
        return buddyBtreeComparatorFactories;
    }

    public static int getRIDSize(Map<String, String> properties) {
        return IndexingConstants.getRIDSize(properties.get(KEY_INPUT_FORMAT));
    }

    public static List<List<String>> getRIDKeys(Map<String, String> properties) {
        String fileInputFormat = properties.get(KEY_INPUT_FORMAT);
        if (fileInputFormat.equals(INPUT_FORMAT_RC) || fileInputFormat.equals(INPUT_FORMAT_RC_FULLY_QUALIFIED)) {
            return RECORD_ID_FIELDS;
        }
        return RECORD_ID_FIELDS.subList(0, 2);
    }

    public static String getFilesIndexName(String datasetName) {
        return datasetName.concat(EXTERNAL_FILE_INDEX_NAME_SUFFIX);
    }

    static {
        ArrayList<ArrayList<String>> ridFields = new ArrayList<ArrayList<String>>();
        ridFields.add(new ArrayList<String>(Arrays.asList("FileNumber")));
        ridFields.add(new ArrayList<String>(Arrays.asList("RecordOffset")));
        ridFields.add(new ArrayList<String>(Arrays.asList("RowNumber")));
        RECORD_ID_FIELDS = Collections.unmodifiableList(ridFields);
    }
}

