/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public final class NumberUtils {
    public static final UTF8StringPointable POSITIVE_INF = UTF8StringPointable.generateUTF8Pointable((String)"INF");
    public static final UTF8StringPointable NEGATIVE_INF = UTF8StringPointable.generateUTF8Pointable((String)"-INF");
    public static final UTF8StringPointable NAN = UTF8StringPointable.generateUTF8Pointable((String)"NaN");
    public static final long NAN_BITS = Double.doubleToLongBits(Double.NaN);
    public static final long POSITIVE_ZERO_BITS = Double.doubleToLongBits(0.0);
    public static final long NEGATIVE_ZERO_BITS = Double.doubleToLongBits(-0.0);

    public static boolean parseDouble(UTF8StringPointable textPtr, AMutableDouble result) {
        double v;
        if (POSITIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Double.POSITIVE_INFINITY;
        } else if (NEGATIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Double.NEGATIVE_INFINITY;
        } else if (NAN.compareTo((IPointable)textPtr) == 0) {
            v = Double.NaN;
        } else {
            try {
                v = Double.parseDouble(textPtr.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        result.setValue(v);
        return true;
    }

    public static boolean parseInt64(UTF8StringPointable textPtr, AMutableInt64 result) {
        byte[] bytes = textPtr.getByteArray();
        int offset = textPtr.getCharStartOffset();
        long value = 0L;
        boolean positive = true;
        long limit = -9223372036854775807L;
        if (bytes[offset] == 43) {
            ++offset;
        } else if (bytes[offset] == 45) {
            ++offset;
            positive = false;
            limit = Long.MIN_VALUE;
        }
        int end = textPtr.getStartOffset() + textPtr.getLength();
        while (offset < end) {
            if (bytes[offset] < 48 || bytes[offset] > 57) {
                if (bytes[offset] == 105 && bytes[offset + 1] == 54 && bytes[offset + 2] == 52 && offset + 3 == end) break;
                return false;
            }
            int digit = bytes[offset] - 48;
            if ((value *= 10L) < limit + (long)digit) {
                return false;
            }
            value -= (long)digit;
            ++offset;
        }
        if (value > 0L) {
            return false;
        }
        if (value < 0L && positive) {
            value *= -1L;
        }
        result.setValue(value);
        return true;
    }

    private NumberUtils() {
    }

    public static boolean isSameTypeNumericStrings(String value1, String value2) {
        if (NumberUtils.isNumericString(value1) && NumberUtils.isNumericString(value2)) {
            return NumberUtils.isIntegerNumericString(value1) == NumberUtils.isIntegerNumericString(value2);
        }
        return false;
    }

    public static boolean isNumericString(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public static boolean isIntegerNumericString(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }
}

