/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.resource;

import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;

public class OperatorResourcesComputer {
    public static final int MIN_OPERATOR_CORES = 1;
    private static final long MAX_BUFFER_PER_CONNECTION = 1L;
    private final int numComputationPartitions;
    private final long frameSize;

    public OperatorResourcesComputer(int numComputationPartitions, long frameSize) {
        this.numComputationPartitions = numComputationPartitions;
        this.frameSize = frameSize;
    }

    public int getOperatorRequiredCores(ILogicalOperator operator) {
        if (operator.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || operator.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            return this.numComputationPartitions;
        }
        return 1;
    }

    public long getOperatorRequiredMemory(ILogicalOperator operator) {
        if (operator.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
            return this.getExchangeRequiredMemory((ExchangeOperator)operator);
        }
        IPhysicalOperator physOp = ((AbstractLogicalOperator)operator).getPhysicalOperator();
        return this.getOperatorRequiredMemory(operator.getExecutionMode(), physOp.getLocalMemoryRequirements());
    }

    private long getOperatorRequiredMemory(AbstractLogicalOperator.ExecutionMode opExecMode, long memorySize) {
        if (opExecMode == AbstractLogicalOperator.ExecutionMode.PARTITIONED || opExecMode == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            return memorySize * (long)this.numComputationPartitions;
        }
        return memorySize;
    }

    private long getOperatorRequiredMemory(AbstractLogicalOperator.ExecutionMode opExecMode, LocalMemoryRequirements memoryReqs) {
        return this.getOperatorRequiredMemory(opExecMode, memoryReqs.getMemoryBudgetInBytes(this.frameSize));
    }

    private long getExchangeRequiredMemory(ExchangeOperator op) {
        IPhysicalOperator physicalOperator = op.getPhysicalOperator();
        PhysicalOperatorTag physicalOperatorTag = physicalOperator.getOperatorTag();
        if (physicalOperatorTag == PhysicalOperatorTag.ONE_TO_ONE_EXCHANGE || physicalOperatorTag == PhysicalOperatorTag.SORT_MERGE_EXCHANGE) {
            return this.getOperatorRequiredMemory(op.getExecutionMode(), this.frameSize);
        }
        return 2L * (long)this.numComputationPartitions * (long)this.numComputationPartitions * this.frameSize;
    }
}

