/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INcResponse;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ActiveStatsResponse
implements ICcAddressedMessage,
INcResponse {
    private static final long serialVersionUID = 1L;
    private final long reqId;
    private final String stats;
    private final Exception failure;

    public ActiveStatsResponse(long reqId, String stats, Exception failure) {
        this.reqId = reqId;
        this.stats = stats;
        this.failure = failure;
    }

    public void setResult(MutablePair<ICCMessageBroker.ResponseState, Object> result) {
        ICCMessageBroker.ResponseState responseState = (ICCMessageBroker.ResponseState)result.getLeft();
        if (this.failure != null) {
            result.setLeft((Object)ICCMessageBroker.ResponseState.FAILURE);
            result.setRight((Object)this.failure);
            return;
        }
        switch (responseState) {
            case UNINITIALIZED: {
                result.setRight(new ArrayList());
                result.setLeft((Object)ICCMessageBroker.ResponseState.SUCCESS);
            }
            case SUCCESS: {
                List response = (List)result.getRight();
                response.add(this.stats);
                break;
            }
        }
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        ICCMessageBroker broker = (ICCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        broker.respond(Long.valueOf(this.reqId), (INcResponse)this);
    }

    public boolean isWhispered() {
        return true;
    }
}

