/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAbstractCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMRTreeSortedCursor
extends LSMRTreeAbstractCursor {
    private ILinearizeComparator linearizeCmp;
    private boolean[] depletedRtreeCursors;
    private int foundIn = -1;
    private PermutingTupleReference btreeTuple;

    public LSMRTreeSortedCursor(ILSMIndexOperationContext opCtx, ILinearizeComparatorFactory linearizer, int[] buddyBTreeFields, IIndexCursorStats stats) throws HyracksDataException {
        super(opCtx, stats);
        this.linearizeCmp = linearizer.createBinaryComparator();
        this.btreeTuple = new PermutingTupleReference(buddyBTreeFields);
        this.close();
    }

    public ILSMIndexOperationContext getOpCtx() {
        return this.opCtx;
    }

    public void doClose() throws HyracksDataException {
        this.depletedRtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.rtreeCursors[i].close();
                this.rtreeAccessors[i].search((IIndexCursor)this.rtreeCursors[i], (ISearchPredicate)this.rtreeSearchPredicate);
                try {
                    if (this.rtreeCursors[i].hasNext()) {
                        this.rtreeCursors[i].next();
                        continue;
                    }
                    this.depletedRtreeCursors[i] = true;
                    continue;
                }
                finally {
                    this.rtreeCursors[i].close();
                }
            }
        }
        finally {
            if (this.open) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getFilter() {
        return this.foundIn < 0 ? null : ((ILSMComponent)this.operationalComponents.get(this.foundIn)).getLSMComponentFilter();
    }

    public boolean doHasNext() throws HyracksDataException {
        while (!this.foundNext) {
            this.frameTuple = null;
            if (this.foundIn != -1) {
                if (this.rtreeCursors[this.foundIn].hasNext()) {
                    this.rtreeCursors[this.foundIn].next();
                } else {
                    this.depletedRtreeCursors[this.foundIn] = true;
                }
            }
            this.foundIn = -1;
            for (int i = 0; i < this.numberOfTrees; ++i) {
                if (this.depletedRtreeCursors[i]) continue;
                if (this.frameTuple == null) {
                    this.frameTuple = this.rtreeCursors[i].getTuple();
                    this.foundIn = i;
                    continue;
                }
                if (this.linearizeCmp.compare(this.frameTuple.getFieldData(0), this.frameTuple.getFieldStart(0), this.frameTuple.getFieldLength(0) * this.linearizeCmp.getDimensions(), this.rtreeCursors[i].getTuple().getFieldData(0), this.rtreeCursors[i].getTuple().getFieldStart(0), this.rtreeCursors[i].getTuple().getFieldLength(0) * this.linearizeCmp.getDimensions()) <= 0) continue;
                this.frameTuple = this.rtreeCursors[i].getTuple();
                this.foundIn = i;
            }
            if (this.foundIn == -1) {
                return false;
            }
            boolean killed = false;
            this.btreeTuple.reset(this.frameTuple);
            for (int i = 0; i < this.foundIn; ++i) {
                this.btreeCursors[i].close();
                this.btreeRangePredicate.setHighKey((ITupleReference)this.btreeTuple, true);
                this.btreeRangePredicate.setLowKey((ITupleReference)this.btreeTuple, true);
                this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
                try {
                    if (!this.btreeCursors[i].hasNext()) continue;
                    killed = true;
                    break;
                }
                finally {
                    this.btreeCursors[i].close();
                }
            }
            if (killed) continue;
            this.foundNext = true;
        }
        return true;
    }

    public void doNext() throws HyracksDataException {
        this.foundNext = false;
    }

    @Override
    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        super.doOpen(initialState, searchPred);
        this.depletedRtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.rtreeCursors[i].close();
                this.rtreeAccessors[i].search((IIndexCursor)this.rtreeCursors[i], (ISearchPredicate)this.rtreeSearchPredicate);
                if (this.rtreeCursors[i].hasNext()) {
                    this.rtreeCursors[i].next();
                    continue;
                }
                this.depletedRtreeCursors[i] = true;
            }
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rtreeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
    }
}

