/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.jackson;

import com.fasterxml.jackson.core.JsonParser;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.external.parser.jackson.ADMToken;
import org.apache.asterix.om.types.ATypeTag;

public class GeometryCoParser {
    private static final String DEFAULT_GEOMETERY_KEY = "geometry";
    private static final String COORDINATES_KEY = "coordinates";
    private static final String TYPE_KEY = "type";
    private static final List<String> SUPPORTED_GEOMETRY = Collections.unmodifiableList(Arrays.asList("Point", "LineString", "Polygon"));
    private static final List<ATypeTag> SUPPORTED_GEOMETRY_TYPETAG = Collections.unmodifiableList(Arrays.asList(ATypeTag.POINT, ATypeTag.LINE, ATypeTag.POLYGON));
    private static final String INVALID_GEOMETRY = "Invalid GeoJSON geometry object";
    private static final String UNSUPPORTED_GEOMETRY = "Unsupported geometry type ";
    private static final int POINT = 0;
    private static final int LINE = 1;
    private static final int POLYGON = 2;
    private final List<Double> coordinates;
    private JsonParser jsonParser;
    private String currentField;
    private int geometryType;
    private String geometryTypeString;
    private int currentCoordinateLevel;
    private int coordinateValueLevel;
    private int coordinatesCounter;
    private String errorMsg;

    public GeometryCoParser(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
        this.coordinates = new ArrayList<Double>();
        this.currentField = null;
        this.geometryTypeString = null;
        this.geometryType = -1;
        this.currentCoordinateLevel = 0;
        this.coordinateValueLevel = 0;
        this.coordinatesCounter = 0;
        this.errorMsg = null;
    }

    public void checkFieldName(String fieldName) {
        if (COORDINATES_KEY.equals(fieldName)) {
            this.currentField = COORDINATES_KEY;
        } else if (TYPE_KEY.equals(fieldName)) {
            this.currentField = TYPE_KEY;
        } else {
            this.reset("Invalid geometry object");
        }
    }

    public boolean checkValue(ADMToken token) throws IOException {
        if (this.currentField == null) {
            return false;
        }
        if (this.currentField == DEFAULT_GEOMETERY_KEY && token != ADMToken.OBJECT_START) {
            this.reset(INVALID_GEOMETRY);
        } else if (this.currentField == COORDINATES_KEY) {
            this.parseCoordinates(token);
        } else if (this.currentField == TYPE_KEY) {
            if (token != ADMToken.STRING) {
                this.reset(INVALID_GEOMETRY);
            } else {
                this.geometryTypeString = this.jsonParser.getValueAsString();
                this.geometryType = SUPPORTED_GEOMETRY.indexOf(this.geometryTypeString);
                if (this.geometryType < 0) {
                    this.reset(UNSUPPORTED_GEOMETRY + this.geometryTypeString);
                }
            }
        }
        return this.currentField != null;
    }

    public void starGeometry() {
        this.reset("");
        this.currentField = DEFAULT_GEOMETERY_KEY;
    }

    public void serialize(ATypeTag typeTag, DataOutput out) throws IOException {
        if (!this.isValidGeometry()) {
            throw new IOException(this.errorMsg);
        }
        if (typeTag != SUPPORTED_GEOMETRY_TYPETAG.get(this.geometryType)) {
            throw new RuntimeDataException(3054, new Serializable[]{typeTag});
        }
        switch (this.geometryType) {
            case 0: {
                this.serializePoint(out);
                break;
            }
            case 1: {
                this.serializeLine(out);
                break;
            }
            case 2: {
                this.serializePolygon(out);
                break;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public void reset(JsonParser jsonParser) {
        this.reset("");
        this.jsonParser = jsonParser;
    }

    private void parseCoordinates(ADMToken token) throws IOException {
        if (token == ADMToken.DOUBLE) {
            if (++this.coordinatesCounter > 2) {
                this.reset(INVALID_GEOMETRY);
            }
            this.coordinates.add(this.jsonParser.getDoubleValue());
            if (this.coordinateValueLevel == 0) {
                this.coordinateValueLevel = this.currentCoordinateLevel;
            }
        } else if (token == ADMToken.ARRAY_START) {
            ++this.currentCoordinateLevel;
            if (this.coordinateValueLevel - (this.currentCoordinateLevel - 1) > 1) {
                this.reset("Only simple geometries are supported (Point, LineString and Polygon without holes)");
            }
        } else if (token == ADMToken.ARRAY_END) {
            --this.currentCoordinateLevel;
            this.coordinatesCounter = 0;
        } else {
            this.reset(INVALID_GEOMETRY);
        }
    }

    private void reset(String errorMsg) {
        this.coordinates.clear();
        this.geometryType = -1;
        this.currentField = null;
        this.coordinatesCounter = 0;
        this.coordinateValueLevel = 0;
        this.currentCoordinateLevel = 0;
        this.errorMsg = errorMsg;
    }

    private boolean isValidGeometry() {
        boolean valid;
        switch (this.geometryType) {
            case 0: {
                valid = this.coordinateValueLevel == 1 && this.coordinates.size() == 2;
                this.errorMsg = valid ? null : "Point must have 2 coordinates";
                break;
            }
            case 1: {
                valid = this.coordinateValueLevel == 2 && this.coordinates.size() == 4;
                this.errorMsg = valid ? null : "Line must have 4 coordinates";
                break;
            }
            case 2: {
                valid = this.isValidPolygon();
                break;
            }
            default: {
                valid = false;
                this.errorMsg = UNSUPPORTED_GEOMETRY + this.geometryTypeString;
            }
        }
        return valid;
    }

    private boolean isValidPolygon() {
        int size = this.coordinates.size();
        if (size < 5) {
            this.errorMsg = "Polygon must consists of at least 3 points (6 coordinates)";
            return false;
        }
        if (this.coordinateValueLevel != 3) {
            this.errorMsg = "MultiPolygon is not supported";
        } else if (!this.coordinates.get(0).equals(this.coordinates.get(size - 2)) || !this.coordinates.get(1).equals(this.coordinates.get(size - 1))) {
            this.errorMsg = "Unclosed polygon is not supported";
            return false;
        }
        return true;
    }

    private void serializePoint(DataOutput out) throws IOException {
        out.writeByte(ATypeTag.SERIALIZED_POINT_TYPE_TAG);
        APointSerializerDeserializer.serialize((double)this.coordinates.get(0), (double)this.coordinates.get(1), (DataOutput)out);
    }

    private void serializeLine(DataOutput out) throws IOException {
        out.writeByte(ATypeTag.SERIALIZED_LINE_TYPE_TAG);
        APointSerializerDeserializer.serialize((double)this.coordinates.get(0), (double)this.coordinates.get(1), (DataOutput)out);
        APointSerializerDeserializer.serialize((double)this.coordinates.get(2), (double)this.coordinates.get(3), (DataOutput)out);
    }

    private void serializePolygon(DataOutput out) throws IOException {
        out.writeByte(ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
        out.writeShort(this.coordinates.size() / 2);
        for (int i = 0; i < this.coordinates.size(); i += 2) {
            APointSerializerDeserializer.serialize((double)this.coordinates.get(i), (double)this.coordinates.get(i + 1), (DataOutput)out);
        }
    }
}

