/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;
import org.rosuda.deducer.widgets.param.RFunctionList;

public class RFunctionListChooserWidget
extends ParamWidget
implements ActionListener {
    private JLabel label;
    private RFunctionList model;
    private JComboBox comboBox;
    private JButton options;

    public RFunctionListChooserWidget() {
        this.initGUI();
    }

    public RFunctionListChooserWidget(Param param) {
        this.initGUI();
        this.setModel(param);
    }

    private void initGUI() {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.options = new IconButton("/icons/advanced_32.png", "Options", this, "Options");
        this.add((Component)this.options, new AnchorConstraint(16, 1, 1050, 867, 1, 2, 0, 0));
        this.options.setPreferredSize(new Dimension(32, 31));
        this.setPreferredSize(new Dimension(241, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(null);
        if (this.model != null && this.model.getOptions() != null) {
            for (int i = 0; i < this.model.getOptions().length; ++i) {
                defaultComboBoxModel.addElement(this.model.getOptions()[i]);
            }
        }
        this.comboBox = new JComboBox();
        this.add((Component)this.comboBox, new AnchorConstraint(150, 39, 743, n2, 1, 2, 0, 2));
        this.comboBox.setModel(defaultComboBoxModel);
        this.comboBox.setPreferredSize(new Dimension(159, 22));
        this.setPreferredSize(new Dimension(200, 30));
        this.setMaximumSize(new Dimension(2000, 30));
    }

    @Override
    public void setModel(Param param) {
        this.model = (RFunctionList)param;
        this.initGUI();
        this.label.setText(param.getTitle());
        if (param.getValue() != null && this.model.getActiveFunctions().size() > 0) {
            String string = (String)this.model.getActiveFunctions().get(0);
            this.comboBox.setSelectedItem(string);
        }
    }

    @Override
    public Param getModel() {
        return this.model;
    }

    @Override
    public void updateModel() {
        Vector<Object> vector = new Vector<Object>();
        if (this.comboBox.getSelectedItem() != null) {
            vector.add(this.comboBox.getSelectedItem());
        }
        this.model.setActiveFunctions(vector);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.comboBox.getSelectedItem();
        if (object != null && object.toString().length() > 0) {
            String string = object.toString();
            HashMap hashMap = this.model.getFunctionMap();
            RFunction rFunction = (RFunction)hashMap.get(string);
            RFunctionDialog rFunctionDialog = new RFunctionDialog(rFunction);
            rFunctionDialog.setRun(false);
            rFunctionDialog.setModal(true);
            rFunctionDialog.setLocationRelativeTo(this.options);
            rFunctionDialog.setSize(300, 300);
            rFunctionDialog.setVisible(true);
        }
    }
}

