/* A Bison parser, made by GNU Bison 3.3.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2019 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.3.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "parser.y" /* yacc.c:337  */

#include <config.h>

#include <stdlib.h>
#include <string.h>

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;    /* program in parse/syntax check/codegen */
struct cb_statement		*current_statement = NULL;
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_field		*external_defined_fields_ws;
struct cb_field		*external_defined_fields_global;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

cb_tree				cobc_printer_node = NULL;
int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;

/* Local variables */

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static struct cb_statement	*main_statement;

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static unsigned int		inspect_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static int			call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;
 
static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static unsigned int		exhibit_changed;
static unsigned int		exhibit_named;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

static void
begin_statement (const char *name, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable, _("unreachable statement '%s'"), name);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (const char *name, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement), _("unreachable statement '%s'"), name);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (NULL);
	new_statement->common = current_statement->common;
	new_statement->name = current_statement->name;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement = new_statement;
	main_statement->body = cb_list_add (main_statement->body,
					    CB_TREE (current_statement));
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention)
{
	cb_tree		l;
	cb_tree		check_list;
	cb_tree		label;
	cb_tree		x;
	cb_tree		entry_conv;
	struct cb_field	*f, *ret_f;
	int			param_num;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	param_num = 1;
	check_list = NULL;
	for (l = using_list; l; l = CB_CHAIN (l)) {
		x = CB_VALUE (l);
		if (cb_try_ref (x) != cb_error_node) {
			f = CB_FIELD (cb_ref (x));
			if (!current_program->flag_chained) {
				if (f->storage != CB_STORAGE_LINKAGE) {
					cb_error_x (x, _("'%s' is not in LINKAGE SECTION"), f->name);
				}
				if (f->flag_item_based || f->flag_external) {
					cb_error_x (x, _("'%s' cannot be BASED/EXTERNAL"), f->name);
				}
				f->flag_is_pdiv_parm = 1;
			} else {
				if (f->storage != CB_STORAGE_WORKING) {
					cb_error_x (x, _("'%s' is not in WORKING-STORAGE SECTION"), f->name);
				}
				f->flag_chained = 1;
				f->param_num = param_num;
				param_num++;
			}
			if (f->level != 01 && f->level != 77) {
				cb_error_x (x, _("'%s' not level 01 or 77"), f->name);
			}
			if (f->redefines) {
				cb_error_x (x, _("'%s' REDEFINES field not allowed here"), f->name);
			}
			/* add a "receiving" entry for the USING parameter */
			if (cb_listing_xref) {
				cobc_xref_link (&f->xref, CB_REFERENCE (x)->common.source_line, 1);
			}
			if (CB_PURPOSE_INT (l) == CB_CALL_BY_REFERENCE) {
				check_list = cb_list_add (check_list, x);
			}
		}
	}

	if (check_list != NULL) {
		for (l = check_list; l; l = CB_CHAIN (l)) {
			cb_tree	l2 = CB_VALUE (l);
			x = cb_ref (l2);
			if (x != cb_error_node) {
				for (l2 = check_list; l2 != l; l2 = CB_CHAIN (l2)) {
					if (cb_ref (CB_VALUE (l2)) == x) {
						cb_error_x (l,
							_("duplicate USING BY REFERENCE item '%s'"),
							cb_name (CB_VALUE (l)));
						CB_VALUE (l) = cb_error_node;
						break;
					}
				}
			}
		}
	}

	if (current_program->returning &&
		cb_ref (current_program->returning) != cb_error_node) {
		ret_f = CB_FIELD (cb_ref (current_program->returning));
		if (ret_f->redefines) {
			cb_error_x (current_program->returning,
				_("'%s' REDEFINES field not allowed here"), ret_f->name);
		}
	} else {
		ret_f = NULL;
	}

	/* Check returning item against using items when FUNCTION */
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION && ret_f) {
		for (l = using_list; l; l = CB_CHAIN (l)) {
			x = CB_VALUE (l);
			if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
				f = CB_FIELD (cb_ref (x));
				if (ret_f == f) {
					cb_error_x (x, _("'%s' USING item duplicates RETURNING item"), f->name);
				}
			}
		}
	}

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", current_statement->name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static int
literal_value (cb_tree x)
{
	if (x == cb_space) {
		return ' ';
	} else if (x == cb_zero) {
		return '0';
	} else if (x == cb_quote) {
		return cb_flag_apostrophe ? '\'' : '"';
	} else if (x == cb_null) {
		return 0;
	} else if (x == cb_low) {
		return 0;
	} else if (x == cb_high) {
		return 255;
	} else if (CB_TREE_CLASS (x) == CB_CLASS_NUMERIC) {
		return cb_get_int (x);
	} else {
		return CB_LITERAL (x)->data[0];
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	/* FIXME: replace by a new warning level that is set
	   to warn/error depending on cb_relaxed_syntax_checks */
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("duplicate %s clause"), clause);
		return 0;
	}
	cb_error (_("duplicate %s clause"), clause);
	return 1;
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("cannot specify both %s and %s; %s is ignored"),
			clause, conflicting, clause);
	} else {
		cb_error (_("cannot specify both %s and %s"),
			clause, conflicting);
	}

}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("Cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_relaxed_syntax_checks) {
					cb_warning (COBC_WARN_FILLER, _("TO phrase without DEPENDING phrase"));
					cb_warning (COBC_WARN_FILLER, _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				} else {
					cb_error (_("TO phrase without DEPENDING phrase"));
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
			}
		} else {
			current_field->occurs_max = 0;
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("%s header missing - assumed"), s);
	} else {
		cb_error (_("%s header missing"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	main_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = 0;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	const char	*elt_name;
	const char	*elt_id;
	cb_tree		l;

	/* Error if a program with the same name has been defined. */
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		elt_name = ((struct cb_program *) CB_VALUE (l))->program_name;
		elt_id = ((struct cb_program *) CB_VALUE (l))->orig_program_id;
		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x ((cb_tree) program,
				    _("redefinition of program name '%s'"),
				    elt_name);
		} else if (strcmp (prog_id, elt_id) == 0) {
		        cb_error_x ((cb_tree) program,
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list,
					 (cb_tree) program);
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l = (struct cb_list *) defined_prog_list;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_entry (program->program_id, 0, NULL, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = (struct cb_list *) defined_prog_list;
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
					 CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	    && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p;
			for (p = current_field; p; p = p->parent) {
				if (p == f) {
					cb_error (_("item may not reference itself"));
					x = cb_error_node;
					break;
				}
			}
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name */
static void
inherit_external_definition (cb_tree lvl)
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
	 && tested != 0 /* USAGE as TYPE TO */) {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
			fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl ? cb_get_level (lvl) : 0;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error_x (lvl, _("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

	/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		inherit_external_definition (NULL);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
			   || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (!(previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & (COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		     | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
		   && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node; 
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	    || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *x_list)
{
	return (cb_tree) x_list != cb_null
		&& cb_list_length ((cb_tree) x_list) == 1
		&& is_screen_field (x_list->value);
}

static int
contains_only_screen_fields (struct cb_list *x_list)
{
	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (!is_screen_field (x_list->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *x_list)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (is_screen_field (x_list->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (cb_tree x_list, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields ((struct cb_list *) x_list)) {
		if (!contains_one_screen_field ((struct cb_list *) x_list)
		    || attr_ptr) {
			cb_verify_x (x_list, cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens ((struct cb_list *) x_list)) {
		cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (x_list, cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (cb_tree x_list, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (cb_tree x_list, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (x_list, _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	    && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ((last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		     || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		    && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) {
		return;
	}

	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2306 "parser.c" /* yacc.c:337  */
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOKEN_EOF = 0,
    THREEDIMENSIONAL = 258,
    ABSENT = 259,
    ACCEPT = 260,
    ACCESS = 261,
    ACTIVEX = 262,
    ACTION = 263,
    ACTUAL = 264,
    ADD = 265,
    ADDRESS = 266,
    ADJUSTABLE_COLUMNS = 267,
    ADVANCING = 268,
    AFTER = 269,
    ALIGNMENT = 270,
    ALL = 271,
    ALLOCATE = 272,
    ALLOWING = 273,
    ALPHABET = 274,
    ALPHABETIC = 275,
    ALPHABETIC_LOWER = 276,
    ALPHABETIC_UPPER = 277,
    ALPHANUMERIC = 278,
    ALPHANUMERIC_EDITED = 279,
    ALSO = 280,
    ALTER = 281,
    ALTERNATE = 282,
    AND = 283,
    ANY = 284,
    APPLY = 285,
    ARE = 286,
    AREA = 287,
    AREAS = 288,
    ARGUMENT_NUMBER = 289,
    ARGUMENT_VALUE = 290,
    ARITHMETIC = 291,
    AS = 292,
    ASCENDING = 293,
    ASCII = 294,
    ASSIGN = 295,
    AT = 296,
    ATTRIBUTE = 297,
    ATTRIBUTES = 298,
    AUTO = 299,
    AUTO_DECIMAL = 300,
    AUTO_SPIN = 301,
    AUTOMATIC = 302,
    AWAY_FROM_ZERO = 303,
    BACKGROUND_COLOR = 304,
    BACKGROUND_HIGH = 305,
    BACKGROUND_LOW = 306,
    BACKGROUND_STANDARD = 307,
    BAR = 308,
    BASED = 309,
    BEFORE = 310,
    BELL = 311,
    BINARY = 312,
    BINARY_C_LONG = 313,
    BINARY_CHAR = 314,
    BINARY_DOUBLE = 315,
    BINARY_LONG = 316,
    BINARY_SEQUENTIAL = 317,
    BINARY_SHORT = 318,
    BIT = 319,
    BITMAP = 320,
    BITMAP_END = 321,
    BITMAP_HANDLE = 322,
    BITMAP_NUMBER = 323,
    BITMAP_START = 324,
    BITMAP_TIMER = 325,
    BITMAP_TRAILING = 326,
    BITMAP_TRANSPARENT_COLOR = 327,
    BITMAP_WIDTH = 328,
    BLANK = 329,
    BLINK = 330,
    BLOCK = 331,
    BOTTOM = 332,
    BOX = 333,
    BOXED = 334,
    BULK_ADDITION = 335,
    BUSY = 336,
    BUTTONS = 337,
    BY = 338,
    BYTE_LENGTH = 339,
    C = 340,
    CALENDAR_FONT = 341,
    CALL = 342,
    CANCEL = 343,
    CANCEL_BUTTON = 344,
    CAPACITY = 345,
    CARD_PUNCH = 346,
    CARD_READER = 347,
    CASSETTE = 348,
    CCOL = 349,
    CD = 350,
    CELL = 351,
    CELL_COLOR = 352,
    CELL_DATA = 353,
    CELL_FONT = 354,
    CELL_PROTECTION = 355,
    CENTER = 356,
    CENTERED = 357,
    CENTERED_HEADINGS = 358,
    CENTURY_DATE = 359,
    CF = 360,
    CH = 361,
    CHAINING = 362,
    CHANGED = 363,
    CHARACTER = 364,
    CHARACTERS = 365,
    CHECK_BOX = 366,
    CLASS = 367,
    CLASSIFICATION = 368,
    CLASS_NAME = 369,
    CLEAR_SELECTION = 370,
    CLINE = 371,
    CLINES = 372,
    CLOSE = 373,
    COBOL = 374,
    CODE = 375,
    CODE_SET = 376,
    COLLATING = 377,
    COL = 378,
    COLOR = 379,
    COLORS = 380,
    COLS = 381,
    COLUMN = 382,
    COLUMN_COLOR = 383,
    COLUMN_DIVIDERS = 384,
    COLUMN_FONT = 385,
    COLUMN_HEADINGS = 386,
    COLUMN_PROTECTION = 387,
    COLUMNS = 388,
    COMBO_BOX = 389,
    COMMA = 390,
    COMMAND_LINE = 391,
    COMMA_DELIM = 392,
    COMMIT = 393,
    COMMON = 394,
    COMMUNICATION = 395,
    COMP = 396,
    COMPUTE = 397,
    COMP_0 = 398,
    COMP_1 = 399,
    COMP_2 = 400,
    COMP_3 = 401,
    COMP_4 = 402,
    COMP_5 = 403,
    COMP_6 = 404,
    COMP_N = 405,
    COMP_X = 406,
    CONCATENATE_FUNC = 407,
    CONDITION = 408,
    CONFIGURATION = 409,
    CONSTANT = 410,
    CONTAINS = 411,
    CONTENT = 412,
    CONTENT_LENGTH_FUNC = 413,
    CONTENT_OF_FUNC = 414,
    CONTINUE = 415,
    CONTROL = 416,
    CONTROLS = 417,
    CONVERSION = 418,
    CONVERTING = 419,
    COPY = 420,
    COPY_SELECTION = 421,
    CORE_INDEX = 422,
    CORRESPONDING = 423,
    COUNT = 424,
    CRT = 425,
    CRT_UNDER = 426,
    CSIZE = 427,
    CURRENCY = 428,
    CURRENT_DATE_FUNC = 429,
    CURSOR = 430,
    CURSOR_COL = 431,
    CURSOR_COLOR = 432,
    CURSOR_FRAME_WIDTH = 433,
    CURSOR_ROW = 434,
    CURSOR_X = 435,
    CURSOR_Y = 436,
    CUSTOM_PRINT_TEMPLATE = 437,
    CYCLE = 438,
    CYL_INDEX = 439,
    CYL_OVERFLOW = 440,
    DASHED = 441,
    DATA = 442,
    DATA_COLUMNS = 443,
    DATA_TYPES = 444,
    DATE = 445,
    DATE_ENTRY = 446,
    DAY = 447,
    DAY_OF_WEEK = 448,
    DE = 449,
    DEBUGGING = 450,
    DECIMAL_POINT = 451,
    DECLARATIVES = 452,
    DEFAULT = 453,
    DEFAULT_BUTTON = 454,
    DEFAULT_FONT = 455,
    DELETE = 456,
    DELIMITED = 457,
    DELIMITER = 458,
    DEPENDING = 459,
    DESCENDING = 460,
    DESTINATION = 461,
    DESTROY = 462,
    DETAIL = 463,
    DISABLE = 464,
    DISC = 465,
    DISK = 466,
    DISP = 467,
    DISPLAY = 468,
    DISPLAY_COLUMNS = 469,
    DISPLAY_FORMAT = 470,
    DISPLAY_OF_FUNC = 471,
    DIVIDE = 472,
    DIVIDERS = 473,
    DIVIDER_COLOR = 474,
    DIVISION = 475,
    DOTDASH = 476,
    DOTTED = 477,
    DRAG_COLOR = 478,
    DROP_DOWN = 479,
    DROP_LIST = 480,
    DOWN = 481,
    DUPLICATES = 482,
    DYNAMIC = 483,
    EBCDIC = 484,
    EC = 485,
    ECHO = 486,
    EGI = 487,
    EIGHTY_EIGHT = 488,
    ENABLE = 489,
    ELEMENT = 490,
    ELSE = 491,
    EMI = 492,
    ENCRYPTION = 493,
    ENCODING = 494,
    END = 495,
    END_ACCEPT = 496,
    END_ADD = 497,
    END_CALL = 498,
    END_COMPUTE = 499,
    END_COLOR = 500,
    END_DELETE = 501,
    END_DISPLAY = 502,
    END_DIVIDE = 503,
    END_EVALUATE = 504,
    END_FUNCTION = 505,
    END_IF = 506,
    END_JSON = 507,
    END_MODIFY = 508,
    END_MULTIPLY = 509,
    END_PERFORM = 510,
    END_PROGRAM = 511,
    END_READ = 512,
    END_RECEIVE = 513,
    END_RETURN = 514,
    END_REWRITE = 515,
    END_SEARCH = 516,
    END_START = 517,
    END_STRING = 518,
    END_SUBTRACT = 519,
    END_UNSTRING = 520,
    END_WRITE = 521,
    END_XML = 522,
    ENGRAVED = 523,
    ENSURE_VISIBLE = 524,
    ENTRY = 525,
    ENTRY_CONVENTION = 526,
    ENTRY_FIELD = 527,
    ENTRY_REASON = 528,
    ENVIRONMENT = 529,
    ENVIRONMENT_NAME = 530,
    ENVIRONMENT_VALUE = 531,
    EOL = 532,
    EOP = 533,
    EOS = 534,
    EQUAL = 535,
    ERASE = 536,
    ERROR = 537,
    ESCAPE = 538,
    ESCAPE_BUTTON = 539,
    ESI = 540,
    EVALUATE = 541,
    EVENT = 542,
    EVENT_LIST = 543,
    EVENT_STATUS = 544,
    EVERY = 545,
    EXCEPTION = 546,
    EXCEPTION_CONDITION = 547,
    EXCEPTION_VALUE = 548,
    EXPAND = 549,
    EXCLUSIVE = 550,
    EXHIBIT = 551,
    EXIT = 552,
    EXPONENTIATION = 553,
    EXTEND = 554,
    EXTENDED_SEARCH = 555,
    EXTERNAL = 556,
    EXTERNAL_FORM = 557,
    F = 558,
    FD = 559,
    FH__FCD = 560,
    FH__KEYDEF = 561,
    FILE_CONTROL = 562,
    FILE_ID = 563,
    FILE_LIMIT = 564,
    FILE_LIMITS = 565,
    FILE_NAME = 566,
    FILE_POS = 567,
    FILL_COLOR = 568,
    FILL_COLOR2 = 569,
    FILL_PERCENT = 570,
    FILLER = 571,
    FINAL = 572,
    FINISH_REASON = 573,
    FIRST = 574,
    FIXED = 575,
    FIXED_FONT = 576,
    FIXED_WIDTH = 577,
    FLAT = 578,
    FLAT_BUTTONS = 579,
    FLOAT_BINARY_128 = 580,
    FLOAT_BINARY_32 = 581,
    FLOAT_BINARY_64 = 582,
    FLOAT_DECIMAL_16 = 583,
    FLOAT_DECIMAL_34 = 584,
    FLOAT_DECIMAL_7 = 585,
    FLOAT_EXTENDED = 586,
    FLOAT_LONG = 587,
    FLOAT_SHORT = 588,
    FLOATING = 589,
    FONT = 590,
    FOOTING = 591,
    FOR = 592,
    FOREGROUND_COLOR = 593,
    FOREVER = 594,
    FORMATTED_DATE_FUNC = 595,
    FORMATTED_DATETIME_FUNC = 596,
    FORMATTED_TIME_FUNC = 597,
    FRAME = 598,
    FRAMED = 599,
    FREE = 600,
    FROM = 601,
    FROM_CRT = 602,
    FULL = 603,
    FULL_HEIGHT = 604,
    FUNCTION = 605,
    FUNCTION_ID = 606,
    FUNCTION_NAME = 607,
    GENERATE = 608,
    GIVING = 609,
    GLOBAL = 610,
    GO = 611,
    GO_BACK = 612,
    GO_FORWARD = 613,
    GO_HOME = 614,
    GO_SEARCH = 615,
    GOBACK = 616,
    GRAPHICAL = 617,
    GREATER = 618,
    GREATER_OR_EQUAL = 619,
    GRID = 620,
    GROUP = 621,
    GROUP_VALUE = 622,
    HANDLE = 623,
    HAS_CHILDREN = 624,
    HEADING = 625,
    HEADING_COLOR = 626,
    HEADING_DIVIDER_COLOR = 627,
    HEADING_FONT = 628,
    HEAVY = 629,
    HEIGHT_IN_CELLS = 630,
    HIDDEN_DATA = 631,
    HIGHLIGHT = 632,
    HIGH_COLOR = 633,
    HIGH_VALUE = 634,
    HOT_TRACK = 635,
    HSCROLL = 636,
    HSCROLL_POS = 637,
    ICON = 638,
    ID = 639,
    IDENTIFIED = 640,
    IDENTIFICATION = 641,
    IF = 642,
    IGNORE = 643,
    IGNORING = 644,
    IN = 645,
    INDEPENDENT = 646,
    INDEX = 647,
    INDEXED = 648,
    INDICATE = 649,
    INITIALIZE = 650,
    INITIALIZED = 651,
    INITIATE = 652,
    INPUT = 653,
    INPUT_OUTPUT = 654,
    INQUIRE = 655,
    INSERTION_INDEX = 656,
    INSERT_ROWS = 657,
    INSPECT = 658,
    INTERMEDIATE = 659,
    INTO = 660,
    INTRINSIC = 661,
    INVALID = 662,
    INVALID_KEY = 663,
    IS = 664,
    ITEM = 665,
    ITEM_TEXT = 666,
    ITEM_TO_ADD = 667,
    ITEM_TO_DELETE = 668,
    ITEM_TO_EMPTY = 669,
    ITEM_VALUE = 670,
    I_O = 671,
    I_O_CONTROL = 672,
    JSON = 673,
    JUSTIFIED = 674,
    KEPT = 675,
    KEY = 676,
    KEYBOARD = 677,
    LABEL = 678,
    LABEL_OFFSET = 679,
    LARGE_FONT = 680,
    LARGE_OFFSET = 681,
    LAST = 682,
    LAST_ROW = 683,
    LAYOUT_DATA = 684,
    LAYOUT_MANAGER = 685,
    LEADING = 686,
    LEADING_SHIFT = 687,
    LEAVE = 688,
    LEFT = 689,
    LEFTLINE = 690,
    LEFT_TEXT = 691,
    LENGTH = 692,
    LENGTH_OF = 693,
    LENGTH_FUNC = 694,
    LESS = 695,
    LESS_OR_EQUAL = 696,
    LEVEL_NUMBER = 697,
    LIKE = 698,
    LIMIT = 699,
    LIMITS = 700,
    LINAGE = 701,
    LINAGE_COUNTER = 702,
    LINE = 703,
    LINE_COUNTER = 704,
    LINE_LIMIT = 705,
    LINE_SEQUENTIAL = 706,
    LINES = 707,
    LINES_AT_ROOT = 708,
    LINKAGE = 709,
    LIST_BOX = 710,
    LITERAL = 711,
    LM_RESIZE = 712,
    LOC = 713,
    LOCALE = 714,
    LOCALE_DATE_FUNC = 715,
    LOCALE_TIME_FUNC = 716,
    LOCALE_TIME_FROM_FUNC = 717,
    LOCAL_STORAGE = 718,
    LOCK = 719,
    LOCK_HOLDING = 720,
    LONG_DATE = 721,
    LOWER = 722,
    LOWERED = 723,
    LOWER_CASE_FUNC = 724,
    LOWLIGHT = 725,
    LOW_COLOR = 726,
    LOW_VALUE = 727,
    MAGNETIC_TAPE = 728,
    MANUAL = 729,
    MASS_UPDATE = 730,
    MASTER_INDEX = 731,
    MAX_LINES = 732,
    MAX_PROGRESS = 733,
    MAX_TEXT = 734,
    MAX_VAL = 735,
    MEMORY = 736,
    MEDIUM_FONT = 737,
    MENU = 738,
    MERGE = 739,
    MESSAGE = 740,
    MINUS = 741,
    MIN_VAL = 742,
    MNEMONIC_NAME = 743,
    MODE = 744,
    MODIFY = 745,
    MODULES = 746,
    MOVE = 747,
    MULTILINE = 748,
    MULTIPLE = 749,
    MULTIPLY = 750,
    NAME = 751,
    NAMED = 752,
    NAMESPACE = 753,
    NAMESPACE_PREFIX = 754,
    NATIONAL = 755,
    NATIONAL_EDITED = 756,
    NATIONAL_OF_FUNC = 757,
    NATIVE = 758,
    NAVIGATE_URL = 759,
    NEAREST_AWAY_FROM_ZERO = 760,
    NEAREST_EVEN = 761,
    NEAREST_TOWARD_ZERO = 762,
    NEGATIVE = 763,
    NESTED = 764,
    NEW = 765,
    NEXT = 766,
    NEXT_ITEM = 767,
    NEXT_GROUP = 768,
    NEXT_PAGE = 769,
    NO = 770,
    NO_ADVANCING = 771,
    NO_AUTOSEL = 772,
    NO_AUTO_DEFAULT = 773,
    NO_BOX = 774,
    NO_DATA = 775,
    NO_DIVIDERS = 776,
    NO_ECHO = 777,
    NO_F4 = 778,
    NO_FOCUS = 779,
    NO_GROUP_TAB = 780,
    NO_KEY_LETTER = 781,
    NOMINAL = 782,
    NO_SEARCH = 783,
    NO_UPDOWN = 784,
    NONNUMERIC = 785,
    NORMAL = 786,
    NOT = 787,
    NOTAB = 788,
    NOTHING = 789,
    NOTIFY = 790,
    NOTIFY_CHANGE = 791,
    NOTIFY_DBLCLICK = 792,
    NOTIFY_SELCHANGE = 793,
    NOT_END = 794,
    NOT_EOP = 795,
    NOT_ESCAPE = 796,
    NOT_EQUAL = 797,
    NOT_EXCEPTION = 798,
    NOT_INVALID_KEY = 799,
    NOT_OVERFLOW = 800,
    NOT_SIZE_ERROR = 801,
    NUM_COL_HEADINGS = 802,
    NUM_ROWS = 803,
    NUMBER = 804,
    NUMBERS = 805,
    NUMERIC = 806,
    NUMERIC_EDITED = 807,
    NUMVALC_FUNC = 808,
    OBJECT = 809,
    OBJECT_COMPUTER = 810,
    OCCURS = 811,
    OF = 812,
    OFF = 813,
    OK_BUTTON = 814,
    OMITTED = 815,
    ON = 816,
    ONLY = 817,
    OPEN = 818,
    OPTIONAL = 819,
    OPTIONS = 820,
    OR = 821,
    ORDER = 822,
    ORGANIZATION = 823,
    OTHER = 824,
    OTHERS = 825,
    OUTPUT = 826,
    OVERLAP_LEFT = 827,
    OVERLAP_TOP = 828,
    OVERLINE = 829,
    PACKED_DECIMAL = 830,
    PADDING = 831,
    PASCAL = 832,
    PAGE = 833,
    PAGE_COUNTER = 834,
    PAGE_SETUP = 835,
    PAGED = 836,
    PARAGRAPH = 837,
    PARENT = 838,
    PARSE = 839,
    PASSWORD = 840,
    PERFORM = 841,
    PERMANENT = 842,
    PH = 843,
    PF = 844,
    PHYSICAL = 845,
    PICTURE = 846,
    PICTURE_SYMBOL = 847,
    PIXEL = 848,
    PLACEMENT = 849,
    PLUS = 850,
    POINTER = 851,
    POP_UP = 852,
    POS = 853,
    POSITION = 854,
    POSITION_SHIFT = 855,
    POSITIVE = 856,
    PRESENT = 857,
    PREVIOUS = 858,
    PRINT = 859,
    PRINT_CONTROL = 860,
    PRINT_NO_PROMPT = 861,
    PRINT_PREVIEW = 862,
    PRINTER = 863,
    PRINTER_1 = 864,
    PRINTING = 865,
    PRIORITY = 866,
    PROCEDURE = 867,
    PROCEDURES = 868,
    PROCEED = 869,
    PROCESSING = 870,
    PROGRAM = 871,
    PROGRAM_ID = 872,
    PROGRAM_NAME = 873,
    PROGRAM_POINTER = 874,
    PROGRESS = 875,
    PROHIBITED = 876,
    PROMPT = 877,
    PROPERTIES = 878,
    PROPERTY = 879,
    PROTECTED = 880,
    PURGE = 881,
    PUSH_BUTTON = 882,
    QUERY_INDEX = 883,
    QUEUE = 884,
    QUOTE = 885,
    RADIO_BUTTON = 886,
    RAISE = 887,
    RAISED = 888,
    RANDOM = 889,
    RD = 890,
    READ = 891,
    READERS = 892,
    READ_ONLY = 893,
    READY_TRACE = 894,
    RECEIVE = 895,
    RECORD = 896,
    RECORD_DATA = 897,
    RECORD_OVERFLOW = 898,
    RECORD_TO_ADD = 899,
    RECORD_TO_DELETE = 900,
    RECORDING = 901,
    RECORDS = 902,
    RECURSIVE = 903,
    REDEFINES = 904,
    REEL = 905,
    REFERENCE = 906,
    REFERENCES = 907,
    REFRESH = 908,
    REGION_COLOR = 909,
    RELATIVE = 910,
    RELEASE = 911,
    REMAINDER = 912,
    REMOVAL = 913,
    RENAMES = 914,
    REORG_CRITERIA = 915,
    REPLACE = 916,
    REPLACING = 917,
    REPORT = 918,
    REPORTING = 919,
    REPORTS = 920,
    REPOSITORY = 921,
    REQUIRED = 922,
    REREAD = 923,
    RERUN = 924,
    RESERVE = 925,
    RESET = 926,
    RESET_TRACE = 927,
    RESET_GRID = 928,
    RESET_LIST = 929,
    RESET_TABS = 930,
    RETRY = 931,
    RETURN = 932,
    RETURNING = 933,
    REVERSE = 934,
    REVERSE_FUNC = 935,
    REVERSE_VIDEO = 936,
    REVERSED = 937,
    REWIND = 938,
    REWRITE = 939,
    RF = 940,
    RH = 941,
    RIGHT = 942,
    RIGHT_ALIGN = 943,
    RIMMED = 944,
    ROLLBACK = 945,
    ROUNDED = 946,
    ROUNDING = 947,
    ROW_COLOR = 948,
    ROW_COLOR_PATTERN = 949,
    ROW_DIVIDERS = 950,
    ROW_FONT = 951,
    ROW_HEADINGS = 952,
    ROW_PROTECTION = 953,
    RUN = 954,
    S = 955,
    SAME = 956,
    SAVE_AS = 957,
    SAVE_AS_NO_PROMPT = 958,
    SCREEN = 959,
    SCREEN_CONTROL = 960,
    SCROLL = 961,
    SCROLL_BAR = 962,
    SD = 963,
    SEARCH = 964,
    SEARCH_OPTIONS = 965,
    SEARCH_TEXT = 966,
    SECONDS = 967,
    SECTION = 968,
    SECURE = 969,
    SEGMENT = 970,
    SEGMENT_LIMIT = 971,
    SELECT = 972,
    SELECTION_INDEX = 973,
    SELECTION_TEXT = 974,
    SELECT_ALL = 975,
    SELF_ACT = 976,
    SEMI_COLON = 977,
    SEND = 978,
    SENTENCE = 979,
    SEPARATE = 980,
    SEPARATION = 981,
    SEQUENCE = 982,
    SEQUENTIAL = 983,
    SET = 984,
    SEVENTY_EIGHT = 985,
    SHADING = 986,
    SHADOW = 987,
    SHARING = 988,
    SHORT_DATE = 989,
    SHOW_LINES = 990,
    SHOW_NONE = 991,
    SHOW_SEL_ALWAYS = 992,
    SIGN = 993,
    SIGNED = 994,
    SIGNED_INT = 995,
    SIGNED_LONG = 996,
    SIGNED_SHORT = 997,
    SIXTY_SIX = 998,
    SIZE = 999,
    SIZE_ERROR = 1000,
    SMALL_FONT = 1001,
    SORT = 1002,
    SORT_MERGE = 1003,
    SORT_ORDER = 1004,
    SOURCE = 1005,
    SOURCE_COMPUTER = 1006,
    SPACE = 1007,
    SPECIAL_NAMES = 1008,
    SPINNER = 1009,
    SQUARE = 1010,
    STANDARD = 1011,
    STANDARD_1 = 1012,
    STANDARD_2 = 1013,
    STANDARD_BINARY = 1014,
    STANDARD_DECIMAL = 1015,
    START = 1016,
    START_X = 1017,
    START_Y = 1018,
    STATIC = 1019,
    STATIC_LIST = 1020,
    STATUS = 1021,
    STATUS_BAR = 1022,
    STATUS_TEXT = 1023,
    STDCALL = 1024,
    STEP = 1025,
    STOP = 1026,
    STRING = 1027,
    STRONG = 1028,
    STYLE = 1029,
    SUB_QUEUE_1 = 1030,
    SUB_QUEUE_2 = 1031,
    SUB_QUEUE_3 = 1032,
    SUBSTITUTE_FUNC = 1033,
    SUBSTITUTE_CASE_FUNC = 1034,
    SUBTRACT = 1035,
    SUBWINDOW = 1036,
    SUM = 1037,
    SUPPRESS = 1038,
    SUPPRESS_XML = 1039,
    SYMBOLIC = 1040,
    SYNCHRONIZED = 1041,
    SYSTEM_DEFAULT = 1042,
    SYSTEM_INFO = 1043,
    SYSTEM_OFFSET = 1044,
    TAB = 1045,
    TAB_TO_ADD = 1046,
    TAB_TO_DELETE = 1047,
    TABLE = 1048,
    TALLYING = 1049,
    TEMPORARY = 1050,
    TAPE = 1051,
    TERMINAL = 1052,
    TERMINATE = 1053,
    TERMINAL_INFO = 1054,
    TERMINATION_VALUE = 1055,
    TEST = 1056,
    TEXT = 1057,
    THAN = 1058,
    THEN = 1059,
    THREAD = 1060,
    THREADS = 1061,
    THRU = 1062,
    THUMB_POSITION = 1063,
    TILED_HEADINGS = 1064,
    TIME = 1065,
    TIME_OUT = 1066,
    TIMES = 1067,
    TITLE = 1068,
    TITLE_POSITION = 1069,
    TO = 1070,
    TOK_AMPER = 1071,
    TOK_CLOSE_PAREN = 1072,
    TOK_COLON = 1073,
    TOK_DIV = 1074,
    TOK_DOT = 1075,
    TOK_EQUAL = 1076,
    TOK_EXTERN = 1077,
    TOK_FALSE = 1078,
    TOK_FILE = 1079,
    TOK_GREATER = 1080,
    TOK_INITIAL = 1081,
    TOK_LESS = 1082,
    TOK_MINUS = 1083,
    TOK_MUL = 1084,
    TOK_NULL = 1085,
    TOK_OVERFLOW = 1086,
    TOK_OPEN_PAREN = 1087,
    TOK_PLUS = 1088,
    TOK_TRUE = 1089,
    TOP = 1090,
    TOWARD_GREATER = 1091,
    TOWARD_LESSER = 1092,
    TRACK = 1093,
    TRACKS = 1094,
    TRACK_AREA = 1095,
    TRACK_LIMIT = 1096,
    TRADITIONAL_FONT = 1097,
    TRAILING = 1098,
    TRAILING_SHIFT = 1099,
    TRANSFORM = 1100,
    TRANSPARENT = 1101,
    TREE_VIEW = 1102,
    TRIM_FUNC = 1103,
    TRUNCATION = 1104,
    TYPE = 1105,
    TYPEDEF = 1106,
    U = 1107,
    UCS_4 = 1108,
    UNBOUNDED = 1109,
    UNDERLINE = 1110,
    UNFRAMED = 1111,
    UNIT = 1112,
    UNLOCK = 1113,
    UNSIGNED = 1114,
    UNSIGNED_INT = 1115,
    UNSIGNED_LONG = 1116,
    UNSIGNED_SHORT = 1117,
    UNSORTED = 1118,
    UNSTRING = 1119,
    UNTIL = 1120,
    UP = 1121,
    UPDATE = 1122,
    UPDATERS = 1123,
    UPON = 1124,
    UPON_ARGUMENT_NUMBER = 1125,
    UPON_COMMAND_LINE = 1126,
    UPON_ENVIRONMENT_NAME = 1127,
    UPON_ENVIRONMENT_VALUE = 1128,
    UPPER = 1129,
    UPPER_CASE_FUNC = 1130,
    USAGE = 1131,
    USE = 1132,
    USE_ALT = 1133,
    USE_RETURN = 1134,
    USE_TAB = 1135,
    USER = 1136,
    USER_DEFAULT = 1137,
    USER_FUNCTION_NAME = 1138,
    USING = 1139,
    UTF_8 = 1140,
    UTF_16 = 1141,
    V = 1142,
    VALIDATE = 1143,
    VALIDATING = 1144,
    VALUE = 1145,
    VALUE_FORMAT = 1146,
    VARIABLE = 1147,
    VARIANT = 1148,
    VARYING = 1149,
    VERTICAL = 1150,
    VERY_HEAVY = 1151,
    VIRTUAL_WIDTH = 1152,
    VOLATILE = 1153,
    VPADDING = 1154,
    VSCROLL = 1155,
    VSCROLL_BAR = 1156,
    VSCROLL_POS = 1157,
    VTOP = 1158,
    WAIT = 1159,
    WEB_BROWSER = 1160,
    WHEN = 1161,
    WHEN_COMPILED_FUNC = 1162,
    WHEN_XML = 1163,
    WIDTH = 1164,
    WIDTH_IN_CELLS = 1165,
    WINDOW = 1166,
    WITH = 1167,
    WORD = 1168,
    WORDS = 1169,
    WORKING_STORAGE = 1170,
    WRAP = 1171,
    WRITE = 1172,
    WRITE_ONLY = 1173,
    WRITE_VERIFY = 1174,
    WRITERS = 1175,
    X = 1176,
    XML = 1177,
    XML_DECLARATION = 1178,
    Y = 1179,
    YYYYDDD = 1180,
    YYYYMMDD = 1181,
    ZERO = 1182,
    SHIFT_PREFER = 1183
  };
#endif
/* Tokens.  */
#define TOKEN_EOF 0
#define THREEDIMENSIONAL 258
#define ABSENT 259
#define ACCEPT 260
#define ACCESS 261
#define ACTIVEX 262
#define ACTION 263
#define ACTUAL 264
#define ADD 265
#define ADDRESS 266
#define ADJUSTABLE_COLUMNS 267
#define ADVANCING 268
#define AFTER 269
#define ALIGNMENT 270
#define ALL 271
#define ALLOCATE 272
#define ALLOWING 273
#define ALPHABET 274
#define ALPHABETIC 275
#define ALPHABETIC_LOWER 276
#define ALPHABETIC_UPPER 277
#define ALPHANUMERIC 278
#define ALPHANUMERIC_EDITED 279
#define ALSO 280
#define ALTER 281
#define ALTERNATE 282
#define AND 283
#define ANY 284
#define APPLY 285
#define ARE 286
#define AREA 287
#define AREAS 288
#define ARGUMENT_NUMBER 289
#define ARGUMENT_VALUE 290
#define ARITHMETIC 291
#define AS 292
#define ASCENDING 293
#define ASCII 294
#define ASSIGN 295
#define AT 296
#define ATTRIBUTE 297
#define ATTRIBUTES 298
#define AUTO 299
#define AUTO_DECIMAL 300
#define AUTO_SPIN 301
#define AUTOMATIC 302
#define AWAY_FROM_ZERO 303
#define BACKGROUND_COLOR 304
#define BACKGROUND_HIGH 305
#define BACKGROUND_LOW 306
#define BACKGROUND_STANDARD 307
#define BAR 308
#define BASED 309
#define BEFORE 310
#define BELL 311
#define BINARY 312
#define BINARY_C_LONG 313
#define BINARY_CHAR 314
#define BINARY_DOUBLE 315
#define BINARY_LONG 316
#define BINARY_SEQUENTIAL 317
#define BINARY_SHORT 318
#define BIT 319
#define BITMAP 320
#define BITMAP_END 321
#define BITMAP_HANDLE 322
#define BITMAP_NUMBER 323
#define BITMAP_START 324
#define BITMAP_TIMER 325
#define BITMAP_TRAILING 326
#define BITMAP_TRANSPARENT_COLOR 327
#define BITMAP_WIDTH 328
#define BLANK 329
#define BLINK 330
#define BLOCK 331
#define BOTTOM 332
#define BOX 333
#define BOXED 334
#define BULK_ADDITION 335
#define BUSY 336
#define BUTTONS 337
#define BY 338
#define BYTE_LENGTH 339
#define C 340
#define CALENDAR_FONT 341
#define CALL 342
#define CANCEL 343
#define CANCEL_BUTTON 344
#define CAPACITY 345
#define CARD_PUNCH 346
#define CARD_READER 347
#define CASSETTE 348
#define CCOL 349
#define CD 350
#define CELL 351
#define CELL_COLOR 352
#define CELL_DATA 353
#define CELL_FONT 354
#define CELL_PROTECTION 355
#define CENTER 356
#define CENTERED 357
#define CENTERED_HEADINGS 358
#define CENTURY_DATE 359
#define CF 360
#define CH 361
#define CHAINING 362
#define CHANGED 363
#define CHARACTER 364
#define CHARACTERS 365
#define CHECK_BOX 366
#define CLASS 367
#define CLASSIFICATION 368
#define CLASS_NAME 369
#define CLEAR_SELECTION 370
#define CLINE 371
#define CLINES 372
#define CLOSE 373
#define COBOL 374
#define CODE 375
#define CODE_SET 376
#define COLLATING 377
#define COL 378
#define COLOR 379
#define COLORS 380
#define COLS 381
#define COLUMN 382
#define COLUMN_COLOR 383
#define COLUMN_DIVIDERS 384
#define COLUMN_FONT 385
#define COLUMN_HEADINGS 386
#define COLUMN_PROTECTION 387
#define COLUMNS 388
#define COMBO_BOX 389
#define COMMA 390
#define COMMAND_LINE 391
#define COMMA_DELIM 392
#define COMMIT 393
#define COMMON 394
#define COMMUNICATION 395
#define COMP 396
#define COMPUTE 397
#define COMP_0 398
#define COMP_1 399
#define COMP_2 400
#define COMP_3 401
#define COMP_4 402
#define COMP_5 403
#define COMP_6 404
#define COMP_N 405
#define COMP_X 406
#define CONCATENATE_FUNC 407
#define CONDITION 408
#define CONFIGURATION 409
#define CONSTANT 410
#define CONTAINS 411
#define CONTENT 412
#define CONTENT_LENGTH_FUNC 413
#define CONTENT_OF_FUNC 414
#define CONTINUE 415
#define CONTROL 416
#define CONTROLS 417
#define CONVERSION 418
#define CONVERTING 419
#define COPY 420
#define COPY_SELECTION 421
#define CORE_INDEX 422
#define CORRESPONDING 423
#define COUNT 424
#define CRT 425
#define CRT_UNDER 426
#define CSIZE 427
#define CURRENCY 428
#define CURRENT_DATE_FUNC 429
#define CURSOR 430
#define CURSOR_COL 431
#define CURSOR_COLOR 432
#define CURSOR_FRAME_WIDTH 433
#define CURSOR_ROW 434
#define CURSOR_X 435
#define CURSOR_Y 436
#define CUSTOM_PRINT_TEMPLATE 437
#define CYCLE 438
#define CYL_INDEX 439
#define CYL_OVERFLOW 440
#define DASHED 441
#define DATA 442
#define DATA_COLUMNS 443
#define DATA_TYPES 444
#define DATE 445
#define DATE_ENTRY 446
#define DAY 447
#define DAY_OF_WEEK 448
#define DE 449
#define DEBUGGING 450
#define DECIMAL_POINT 451
#define DECLARATIVES 452
#define DEFAULT 453
#define DEFAULT_BUTTON 454
#define DEFAULT_FONT 455
#define DELETE 456
#define DELIMITED 457
#define DELIMITER 458
#define DEPENDING 459
#define DESCENDING 460
#define DESTINATION 461
#define DESTROY 462
#define DETAIL 463
#define DISABLE 464
#define DISC 465
#define DISK 466
#define DISP 467
#define DISPLAY 468
#define DISPLAY_COLUMNS 469
#define DISPLAY_FORMAT 470
#define DISPLAY_OF_FUNC 471
#define DIVIDE 472
#define DIVIDERS 473
#define DIVIDER_COLOR 474
#define DIVISION 475
#define DOTDASH 476
#define DOTTED 477
#define DRAG_COLOR 478
#define DROP_DOWN 479
#define DROP_LIST 480
#define DOWN 481
#define DUPLICATES 482
#define DYNAMIC 483
#define EBCDIC 484
#define EC 485
#define ECHO 486
#define EGI 487
#define EIGHTY_EIGHT 488
#define ENABLE 489
#define ELEMENT 490
#define ELSE 491
#define EMI 492
#define ENCRYPTION 493
#define ENCODING 494
#define END 495
#define END_ACCEPT 496
#define END_ADD 497
#define END_CALL 498
#define END_COMPUTE 499
#define END_COLOR 500
#define END_DELETE 501
#define END_DISPLAY 502
#define END_DIVIDE 503
#define END_EVALUATE 504
#define END_FUNCTION 505
#define END_IF 506
#define END_JSON 507
#define END_MODIFY 508
#define END_MULTIPLY 509
#define END_PERFORM 510
#define END_PROGRAM 511
#define END_READ 512
#define END_RECEIVE 513
#define END_RETURN 514
#define END_REWRITE 515
#define END_SEARCH 516
#define END_START 517
#define END_STRING 518
#define END_SUBTRACT 519
#define END_UNSTRING 520
#define END_WRITE 521
#define END_XML 522
#define ENGRAVED 523
#define ENSURE_VISIBLE 524
#define ENTRY 525
#define ENTRY_CONVENTION 526
#define ENTRY_FIELD 527
#define ENTRY_REASON 528
#define ENVIRONMENT 529
#define ENVIRONMENT_NAME 530
#define ENVIRONMENT_VALUE 531
#define EOL 532
#define EOP 533
#define EOS 534
#define EQUAL 535
#define ERASE 536
#define ERROR 537
#define ESCAPE 538
#define ESCAPE_BUTTON 539
#define ESI 540
#define EVALUATE 541
#define EVENT 542
#define EVENT_LIST 543
#define EVENT_STATUS 544
#define EVERY 545
#define EXCEPTION 546
#define EXCEPTION_CONDITION 547
#define EXCEPTION_VALUE 548
#define EXPAND 549
#define EXCLUSIVE 550
#define EXHIBIT 551
#define EXIT 552
#define EXPONENTIATION 553
#define EXTEND 554
#define EXTENDED_SEARCH 555
#define EXTERNAL 556
#define EXTERNAL_FORM 557
#define F 558
#define FD 559
#define FH__FCD 560
#define FH__KEYDEF 561
#define FILE_CONTROL 562
#define FILE_ID 563
#define FILE_LIMIT 564
#define FILE_LIMITS 565
#define FILE_NAME 566
#define FILE_POS 567
#define FILL_COLOR 568
#define FILL_COLOR2 569
#define FILL_PERCENT 570
#define FILLER 571
#define FINAL 572
#define FINISH_REASON 573
#define FIRST 574
#define FIXED 575
#define FIXED_FONT 576
#define FIXED_WIDTH 577
#define FLAT 578
#define FLAT_BUTTONS 579
#define FLOAT_BINARY_128 580
#define FLOAT_BINARY_32 581
#define FLOAT_BINARY_64 582
#define FLOAT_DECIMAL_16 583
#define FLOAT_DECIMAL_34 584
#define FLOAT_DECIMAL_7 585
#define FLOAT_EXTENDED 586
#define FLOAT_LONG 587
#define FLOAT_SHORT 588
#define FLOATING 589
#define FONT 590
#define FOOTING 591
#define FOR 592
#define FOREGROUND_COLOR 593
#define FOREVER 594
#define FORMATTED_DATE_FUNC 595
#define FORMATTED_DATETIME_FUNC 596
#define FORMATTED_TIME_FUNC 597
#define FRAME 598
#define FRAMED 599
#define FREE 600
#define FROM 601
#define FROM_CRT 602
#define FULL 603
#define FULL_HEIGHT 604
#define FUNCTION 605
#define FUNCTION_ID 606
#define FUNCTION_NAME 607
#define GENERATE 608
#define GIVING 609
#define GLOBAL 610
#define GO 611
#define GO_BACK 612
#define GO_FORWARD 613
#define GO_HOME 614
#define GO_SEARCH 615
#define GOBACK 616
#define GRAPHICAL 617
#define GREATER 618
#define GREATER_OR_EQUAL 619
#define GRID 620
#define GROUP 621
#define GROUP_VALUE 622
#define HANDLE 623
#define HAS_CHILDREN 624
#define HEADING 625
#define HEADING_COLOR 626
#define HEADING_DIVIDER_COLOR 627
#define HEADING_FONT 628
#define HEAVY 629
#define HEIGHT_IN_CELLS 630
#define HIDDEN_DATA 631
#define HIGHLIGHT 632
#define HIGH_COLOR 633
#define HIGH_VALUE 634
#define HOT_TRACK 635
#define HSCROLL 636
#define HSCROLL_POS 637
#define ICON 638
#define ID 639
#define IDENTIFIED 640
#define IDENTIFICATION 641
#define IF 642
#define IGNORE 643
#define IGNORING 644
#define IN 645
#define INDEPENDENT 646
#define INDEX 647
#define INDEXED 648
#define INDICATE 649
#define INITIALIZE 650
#define INITIALIZED 651
#define INITIATE 652
#define INPUT 653
#define INPUT_OUTPUT 654
#define INQUIRE 655
#define INSERTION_INDEX 656
#define INSERT_ROWS 657
#define INSPECT 658
#define INTERMEDIATE 659
#define INTO 660
#define INTRINSIC 661
#define INVALID 662
#define INVALID_KEY 663
#define IS 664
#define ITEM 665
#define ITEM_TEXT 666
#define ITEM_TO_ADD 667
#define ITEM_TO_DELETE 668
#define ITEM_TO_EMPTY 669
#define ITEM_VALUE 670
#define I_O 671
#define I_O_CONTROL 672
#define JSON 673
#define JUSTIFIED 674
#define KEPT 675
#define KEY 676
#define KEYBOARD 677
#define LABEL 678
#define LABEL_OFFSET 679
#define LARGE_FONT 680
#define LARGE_OFFSET 681
#define LAST 682
#define LAST_ROW 683
#define LAYOUT_DATA 684
#define LAYOUT_MANAGER 685
#define LEADING 686
#define LEADING_SHIFT 687
#define LEAVE 688
#define LEFT 689
#define LEFTLINE 690
#define LEFT_TEXT 691
#define LENGTH 692
#define LENGTH_OF 693
#define LENGTH_FUNC 694
#define LESS 695
#define LESS_OR_EQUAL 696
#define LEVEL_NUMBER 697
#define LIKE 698
#define LIMIT 699
#define LIMITS 700
#define LINAGE 701
#define LINAGE_COUNTER 702
#define LINE 703
#define LINE_COUNTER 704
#define LINE_LIMIT 705
#define LINE_SEQUENTIAL 706
#define LINES 707
#define LINES_AT_ROOT 708
#define LINKAGE 709
#define LIST_BOX 710
#define LITERAL 711
#define LM_RESIZE 712
#define LOC 713
#define LOCALE 714
#define LOCALE_DATE_FUNC 715
#define LOCALE_TIME_FUNC 716
#define LOCALE_TIME_FROM_FUNC 717
#define LOCAL_STORAGE 718
#define LOCK 719
#define LOCK_HOLDING 720
#define LONG_DATE 721
#define LOWER 722
#define LOWERED 723
#define LOWER_CASE_FUNC 724
#define LOWLIGHT 725
#define LOW_COLOR 726
#define LOW_VALUE 727
#define MAGNETIC_TAPE 728
#define MANUAL 729
#define MASS_UPDATE 730
#define MASTER_INDEX 731
#define MAX_LINES 732
#define MAX_PROGRESS 733
#define MAX_TEXT 734
#define MAX_VAL 735
#define MEMORY 736
#define MEDIUM_FONT 737
#define MENU 738
#define MERGE 739
#define MESSAGE 740
#define MINUS 741
#define MIN_VAL 742
#define MNEMONIC_NAME 743
#define MODE 744
#define MODIFY 745
#define MODULES 746
#define MOVE 747
#define MULTILINE 748
#define MULTIPLE 749
#define MULTIPLY 750
#define NAME 751
#define NAMED 752
#define NAMESPACE 753
#define NAMESPACE_PREFIX 754
#define NATIONAL 755
#define NATIONAL_EDITED 756
#define NATIONAL_OF_FUNC 757
#define NATIVE 758
#define NAVIGATE_URL 759
#define NEAREST_AWAY_FROM_ZERO 760
#define NEAREST_EVEN 761
#define NEAREST_TOWARD_ZERO 762
#define NEGATIVE 763
#define NESTED 764
#define NEW 765
#define NEXT 766
#define NEXT_ITEM 767
#define NEXT_GROUP 768
#define NEXT_PAGE 769
#define NO 770
#define NO_ADVANCING 771
#define NO_AUTOSEL 772
#define NO_AUTO_DEFAULT 773
#define NO_BOX 774
#define NO_DATA 775
#define NO_DIVIDERS 776
#define NO_ECHO 777
#define NO_F4 778
#define NO_FOCUS 779
#define NO_GROUP_TAB 780
#define NO_KEY_LETTER 781
#define NOMINAL 782
#define NO_SEARCH 783
#define NO_UPDOWN 784
#define NONNUMERIC 785
#define NORMAL 786
#define NOT 787
#define NOTAB 788
#define NOTHING 789
#define NOTIFY 790
#define NOTIFY_CHANGE 791
#define NOTIFY_DBLCLICK 792
#define NOTIFY_SELCHANGE 793
#define NOT_END 794
#define NOT_EOP 795
#define NOT_ESCAPE 796
#define NOT_EQUAL 797
#define NOT_EXCEPTION 798
#define NOT_INVALID_KEY 799
#define NOT_OVERFLOW 800
#define NOT_SIZE_ERROR 801
#define NUM_COL_HEADINGS 802
#define NUM_ROWS 803
#define NUMBER 804
#define NUMBERS 805
#define NUMERIC 806
#define NUMERIC_EDITED 807
#define NUMVALC_FUNC 808
#define OBJECT 809
#define OBJECT_COMPUTER 810
#define OCCURS 811
#define OF 812
#define OFF 813
#define OK_BUTTON 814
#define OMITTED 815
#define ON 816
#define ONLY 817
#define OPEN 818
#define OPTIONAL 819
#define OPTIONS 820
#define OR 821
#define ORDER 822
#define ORGANIZATION 823
#define OTHER 824
#define OTHERS 825
#define OUTPUT 826
#define OVERLAP_LEFT 827
#define OVERLAP_TOP 828
#define OVERLINE 829
#define PACKED_DECIMAL 830
#define PADDING 831
#define PASCAL 832
#define PAGE 833
#define PAGE_COUNTER 834
#define PAGE_SETUP 835
#define PAGED 836
#define PARAGRAPH 837
#define PARENT 838
#define PARSE 839
#define PASSWORD 840
#define PERFORM 841
#define PERMANENT 842
#define PH 843
#define PF 844
#define PHYSICAL 845
#define PICTURE 846
#define PICTURE_SYMBOL 847
#define PIXEL 848
#define PLACEMENT 849
#define PLUS 850
#define POINTER 851
#define POP_UP 852
#define POS 853
#define POSITION 854
#define POSITION_SHIFT 855
#define POSITIVE 856
#define PRESENT 857
#define PREVIOUS 858
#define PRINT 859
#define PRINT_CONTROL 860
#define PRINT_NO_PROMPT 861
#define PRINT_PREVIEW 862
#define PRINTER 863
#define PRINTER_1 864
#define PRINTING 865
#define PRIORITY 866
#define PROCEDURE 867
#define PROCEDURES 868
#define PROCEED 869
#define PROCESSING 870
#define PROGRAM 871
#define PROGRAM_ID 872
#define PROGRAM_NAME 873
#define PROGRAM_POINTER 874
#define PROGRESS 875
#define PROHIBITED 876
#define PROMPT 877
#define PROPERTIES 878
#define PROPERTY 879
#define PROTECTED 880
#define PURGE 881
#define PUSH_BUTTON 882
#define QUERY_INDEX 883
#define QUEUE 884
#define QUOTE 885
#define RADIO_BUTTON 886
#define RAISE 887
#define RAISED 888
#define RANDOM 889
#define RD 890
#define READ 891
#define READERS 892
#define READ_ONLY 893
#define READY_TRACE 894
#define RECEIVE 895
#define RECORD 896
#define RECORD_DATA 897
#define RECORD_OVERFLOW 898
#define RECORD_TO_ADD 899
#define RECORD_TO_DELETE 900
#define RECORDING 901
#define RECORDS 902
#define RECURSIVE 903
#define REDEFINES 904
#define REEL 905
#define REFERENCE 906
#define REFERENCES 907
#define REFRESH 908
#define REGION_COLOR 909
#define RELATIVE 910
#define RELEASE 911
#define REMAINDER 912
#define REMOVAL 913
#define RENAMES 914
#define REORG_CRITERIA 915
#define REPLACE 916
#define REPLACING 917
#define REPORT 918
#define REPORTING 919
#define REPORTS 920
#define REPOSITORY 921
#define REQUIRED 922
#define REREAD 923
#define RERUN 924
#define RESERVE 925
#define RESET 926
#define RESET_TRACE 927
#define RESET_GRID 928
#define RESET_LIST 929
#define RESET_TABS 930
#define RETRY 931
#define RETURN 932
#define RETURNING 933
#define REVERSE 934
#define REVERSE_FUNC 935
#define REVERSE_VIDEO 936
#define REVERSED 937
#define REWIND 938
#define REWRITE 939
#define RF 940
#define RH 941
#define RIGHT 942
#define RIGHT_ALIGN 943
#define RIMMED 944
#define ROLLBACK 945
#define ROUNDED 946
#define ROUNDING 947
#define ROW_COLOR 948
#define ROW_COLOR_PATTERN 949
#define ROW_DIVIDERS 950
#define ROW_FONT 951
#define ROW_HEADINGS 952
#define ROW_PROTECTION 953
#define RUN 954
#define S 955
#define SAME 956
#define SAVE_AS 957
#define SAVE_AS_NO_PROMPT 958
#define SCREEN 959
#define SCREEN_CONTROL 960
#define SCROLL 961
#define SCROLL_BAR 962
#define SD 963
#define SEARCH 964
#define SEARCH_OPTIONS 965
#define SEARCH_TEXT 966
#define SECONDS 967
#define SECTION 968
#define SECURE 969
#define SEGMENT 970
#define SEGMENT_LIMIT 971
#define SELECT 972
#define SELECTION_INDEX 973
#define SELECTION_TEXT 974
#define SELECT_ALL 975
#define SELF_ACT 976
#define SEMI_COLON 977
#define SEND 978
#define SENTENCE 979
#define SEPARATE 980
#define SEPARATION 981
#define SEQUENCE 982
#define SEQUENTIAL 983
#define SET 984
#define SEVENTY_EIGHT 985
#define SHADING 986
#define SHADOW 987
#define SHARING 988
#define SHORT_DATE 989
#define SHOW_LINES 990
#define SHOW_NONE 991
#define SHOW_SEL_ALWAYS 992
#define SIGN 993
#define SIGNED 994
#define SIGNED_INT 995
#define SIGNED_LONG 996
#define SIGNED_SHORT 997
#define SIXTY_SIX 998
#define SIZE 999
#define SIZE_ERROR 1000
#define SMALL_FONT 1001
#define SORT 1002
#define SORT_MERGE 1003
#define SORT_ORDER 1004
#define SOURCE 1005
#define SOURCE_COMPUTER 1006
#define SPACE 1007
#define SPECIAL_NAMES 1008
#define SPINNER 1009
#define SQUARE 1010
#define STANDARD 1011
#define STANDARD_1 1012
#define STANDARD_2 1013
#define STANDARD_BINARY 1014
#define STANDARD_DECIMAL 1015
#define START 1016
#define START_X 1017
#define START_Y 1018
#define STATIC 1019
#define STATIC_LIST 1020
#define STATUS 1021
#define STATUS_BAR 1022
#define STATUS_TEXT 1023
#define STDCALL 1024
#define STEP 1025
#define STOP 1026
#define STRING 1027
#define STRONG 1028
#define STYLE 1029
#define SUB_QUEUE_1 1030
#define SUB_QUEUE_2 1031
#define SUB_QUEUE_3 1032
#define SUBSTITUTE_FUNC 1033
#define SUBSTITUTE_CASE_FUNC 1034
#define SUBTRACT 1035
#define SUBWINDOW 1036
#define SUM 1037
#define SUPPRESS 1038
#define SUPPRESS_XML 1039
#define SYMBOLIC 1040
#define SYNCHRONIZED 1041
#define SYSTEM_DEFAULT 1042
#define SYSTEM_INFO 1043
#define SYSTEM_OFFSET 1044
#define TAB 1045
#define TAB_TO_ADD 1046
#define TAB_TO_DELETE 1047
#define TABLE 1048
#define TALLYING 1049
#define TEMPORARY 1050
#define TAPE 1051
#define TERMINAL 1052
#define TERMINATE 1053
#define TERMINAL_INFO 1054
#define TERMINATION_VALUE 1055
#define TEST 1056
#define TEXT 1057
#define THAN 1058
#define THEN 1059
#define THREAD 1060
#define THREADS 1061
#define THRU 1062
#define THUMB_POSITION 1063
#define TILED_HEADINGS 1064
#define TIME 1065
#define TIME_OUT 1066
#define TIMES 1067
#define TITLE 1068
#define TITLE_POSITION 1069
#define TO 1070
#define TOK_AMPER 1071
#define TOK_CLOSE_PAREN 1072
#define TOK_COLON 1073
#define TOK_DIV 1074
#define TOK_DOT 1075
#define TOK_EQUAL 1076
#define TOK_EXTERN 1077
#define TOK_FALSE 1078
#define TOK_FILE 1079
#define TOK_GREATER 1080
#define TOK_INITIAL 1081
#define TOK_LESS 1082
#define TOK_MINUS 1083
#define TOK_MUL 1084
#define TOK_NULL 1085
#define TOK_OVERFLOW 1086
#define TOK_OPEN_PAREN 1087
#define TOK_PLUS 1088
#define TOK_TRUE 1089
#define TOP 1090
#define TOWARD_GREATER 1091
#define TOWARD_LESSER 1092
#define TRACK 1093
#define TRACKS 1094
#define TRACK_AREA 1095
#define TRACK_LIMIT 1096
#define TRADITIONAL_FONT 1097
#define TRAILING 1098
#define TRAILING_SHIFT 1099
#define TRANSFORM 1100
#define TRANSPARENT 1101
#define TREE_VIEW 1102
#define TRIM_FUNC 1103
#define TRUNCATION 1104
#define TYPE 1105
#define TYPEDEF 1106
#define U 1107
#define UCS_4 1108
#define UNBOUNDED 1109
#define UNDERLINE 1110
#define UNFRAMED 1111
#define UNIT 1112
#define UNLOCK 1113
#define UNSIGNED 1114
#define UNSIGNED_INT 1115
#define UNSIGNED_LONG 1116
#define UNSIGNED_SHORT 1117
#define UNSORTED 1118
#define UNSTRING 1119
#define UNTIL 1120
#define UP 1121
#define UPDATE 1122
#define UPDATERS 1123
#define UPON 1124
#define UPON_ARGUMENT_NUMBER 1125
#define UPON_COMMAND_LINE 1126
#define UPON_ENVIRONMENT_NAME 1127
#define UPON_ENVIRONMENT_VALUE 1128
#define UPPER 1129
#define UPPER_CASE_FUNC 1130
#define USAGE 1131
#define USE 1132
#define USE_ALT 1133
#define USE_RETURN 1134
#define USE_TAB 1135
#define USER 1136
#define USER_DEFAULT 1137
#define USER_FUNCTION_NAME 1138
#define USING 1139
#define UTF_8 1140
#define UTF_16 1141
#define V 1142
#define VALIDATE 1143
#define VALIDATING 1144
#define VALUE 1145
#define VALUE_FORMAT 1146
#define VARIABLE 1147
#define VARIANT 1148
#define VARYING 1149
#define VERTICAL 1150
#define VERY_HEAVY 1151
#define VIRTUAL_WIDTH 1152
#define VOLATILE 1153
#define VPADDING 1154
#define VSCROLL 1155
#define VSCROLL_BAR 1156
#define VSCROLL_POS 1157
#define VTOP 1158
#define WAIT 1159
#define WEB_BROWSER 1160
#define WHEN 1161
#define WHEN_COMPILED_FUNC 1162
#define WHEN_XML 1163
#define WIDTH 1164
#define WIDTH_IN_CELLS 1165
#define WINDOW 1166
#define WITH 1167
#define WORD 1168
#define WORDS 1169
#define WORKING_STORAGE 1170
#define WRAP 1171
#define WRITE 1172
#define WRITE_ONLY 1173
#define WRITE_VERIFY 1174
#define WRITERS 1175
#define X 1176
#define XML 1177
#define XML_DECLARATION 1178
#define Y 1179
#define YYYYDDD 1180
#define YYYYMMDD 1181
#define ZERO 1182
#define SHIFT_PREFER 1183

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */



#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   18465

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  929
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1318
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3186
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4506

#define YYUNDEFTOK  2
#define YYMAXUTOK   1183

/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  ((unsigned) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  3316,  3316,  3316,  3350,  3351,  3355,  3355,  3364,  3365,
    3369,  3370,  3374,  3374,  3386,  3397,  3405,  3409,  3413,  3414,
    3419,  3418,  3431,  3430,  3445,  3449,  3443,  3461,  3462,  3466,
    3475,  3475,  3480,  3484,  3479,  3500,  3499,  3515,  3526,  3533,
    3534,  3541,  3542,  3545,  3546,  3550,  3559,  3568,  3569,  3576,
    3577,  3581,  3585,  3591,  3593,  3601,  3608,  3610,  3614,  3621,
    3625,  3629,  3645,  3648,  3658,  3660,  3667,  3671,  3675,  3681,
    3683,  3690,  3694,  3698,  3702,  3711,  3716,  3717,  3726,  3730,
    3731,  3741,  3743,  3747,  3748,  3752,  3753,  3754,  3755,  3756,
    3763,  3762,  3773,  3774,  3777,  3778,  3791,  3790,  3804,  3805,
    3806,  3807,  3811,  3812,  3816,  3817,  3818,  3819,  3823,  3831,
    3840,  3839,  3847,  3851,  3857,  3861,  3866,  3873,  3883,  3897,
    3908,  3912,  3916,  3920,  3927,  3928,  3935,  3934,  3947,  3949,
    3950,  3957,  3958,  3962,  3966,  3972,  3973,  3980,  3987,  3992,
    4003,  4017,  4020,  4021,  4024,  4028,  4029,  4030,  4031,  4032,
    4033,  4034,  4035,  4036,  4037,  4038,  4039,  4040,  4041,  4049,
    4048,  4067,  4078,  4099,  4107,  4110,  4111,  4115,  4122,  4137,
    4158,  4157,  4182,  4181,  4190,  4189,  4199,  4201,  4205,  4209,
    4210,  4216,  4222,  4228,  4237,  4238,  4245,  4252,  4262,  4268,
    4276,  4286,  4290,  4297,  4301,  4306,  4305,  4316,  4320,  4327,
    4328,  4329,  4330,  4331,  4332,  4336,  4337,  4344,  4359,  4362,
    4369,  4377,  4381,  4392,  4412,  4420,  4431,  4432,  4439,  4453,
    4454,  4458,  4479,  4500,  4501,  4505,  4509,  4527,  4529,  4533,
    4540,  4542,  4552,  4573,  4640,  4643,  4652,  4671,  4687,  4705,
    4723,  4740,  4758,  4757,  4785,  4791,  4792,  4801,  4802,  4810,
    4811,  4816,  4815,  4862,  4863,  4869,  4870,  4879,  4880,  4881,
    4882,  4883,  4884,  4885,  4886,  4887,  4888,  4889,  4890,  4891,
    4892,  4893,  4894,  4895,  4896,  4897,  4923,  4933,  4943,  4954,
    4965,  4996,  4999,  5003,  5007,  5011,  5016,  5020,  5028,  5032,
    5036,  5044,  5045,  5046,  5047,  5051,  5052,  5053,  5054,  5055,
    5056,  5057,  5061,  5069,  5073,  5081,  5085,  5092,  5093,  5099,
    5106,  5107,  5108,  5115,  5170,  5173,  5178,  5177,  5203,  5206,
    5210,  5220,  5231,  5230,  5238,  5242,  5248,  5252,  5257,  5264,
    5274,  5285,  5300,  5311,  5313,  5314,  5320,  5320,  5327,  5331,
    5335,  5342,  5343,  5344,  5348,  5354,  5355,  5359,  5365,  5366,
    5382,  5383,  5387,  5393,  5399,  5405,  5418,  5429,  5428,  5437,
    5448,  5462,  5475,  5491,  5530,  5533,  5540,  5541,  5545,  5545,
    5549,  5554,  5572,  5583,  5590,  5591,  5597,  5610,  5611,  5612,
    5618,  5626,  5627,  5633,  5643,  5653,  5663,  5673,  5674,  5681,
    5689,  5690,  5691,  5698,  5699,  5703,  5704,  5705,  5706,  5712,
    5740,  5741,  5742,  5743,  5749,  5754,  5758,  5762,  5763,  5770,
    5771,  5772,  5773,  5774,  5775,  5776,  5777,  5784,  5783,  5799,
    5800,  5804,  5807,  5808,  5814,  5818,  5822,  5823,  5832,  5829,
    5843,  5844,  5848,  5856,  5857,  5865,  5866,  5870,  5890,  5889,
    5913,  5920,  5924,  5930,  5931,  5935,  5945,  5960,  5961,  5962,
    5963,  5964,  5965,  5966,  5967,  5968,  5975,  5982,  5982,  5982,
    5988,  5997,  6006,  6016,  6017,  6024,  6025,  6029,  6030,  6037,
    6048,  6053,  6064,  6065,  6069,  6070,  6076,  6087,  6105,  6106,
    6110,  6111,  6112,  6116,  6123,  6130,  6139,  6148,  6149,  6150,
    6151,  6152,  6161,  6162,  6168,  6205,  6206,  6216,  6231,  6232,
    6236,  6250,  6268,  6270,  6269,  6287,  6288,  6292,  6309,  6308,
    6329,  6330,  6334,  6335,  6336,  6339,  6341,  6342,  6346,  6347,
    6351,  6352,  6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,
    6361,  6365,  6369,  6371,  6375,  6376,  6380,  6381,  6382,  6383,
    6384,  6385,  6386,  6389,  6391,  6392,  6396,  6397,  6401,  6402,
    6403,  6404,  6405,  6406,  6410,  6415,  6417,  6416,  6432,  6436,
    6436,  6449,  6450,  6454,  6455,  6456,  6458,  6457,  6477,  6494,
    6500,  6502,  6506,  6513,  6517,  6528,  6531,  6543,  6544,  6546,
    6550,  6554,  6560,  6564,  6568,  6572,  6576,  6580,  6584,  6592,
    6596,  6600,  6604,  6608,  6612,  6623,  6624,  6628,  6629,  6633,
    6634,  6635,  6639,  6640,  6644,  6688,  6691,  6699,  6698,  6711,
    6739,  6738,  6753,  6757,  6764,  6770,  6774,  6781,  6782,  6786,
    6787,  6788,  6789,  6790,  6791,  6792,  6793,  6794,  6795,  6798,
    6800,  6804,  6808,  6812,  6813,  6814,  6815,  6816,  6817,  6818,
    6819,  6820,  6821,  6822,  6823,  6824,  6825,  6826,  6827,  6828,
    6829,  6830,  6831,  6832,  6839,  6860,  6874,  6875,  6878,  6887,
    6905,  6929,  6930,  6940,  6968,  6971,  6979,  6980,  6984,  7009,
    7008,  7020,  7028,  7045,  7057,  7074,  7091,  7112,  7113,  7120,
    7122,  7130,  7145,  7156,  7157,  7158,  7189,  7196,  7200,  7205,
    7209,  7214,  7223,  7227,  7231,  7235,  7239,  7243,  7247,  7251,
    7255,  7259,  7263,  7267,  7272,  7277,  7281,  7285,  7289,  7294,
    7298,  7303,  7307,  7312,  7317,  7322,  7326,  7330,  7338,  7342,
    7346,  7354,  7358,  7362,  7366,  7370,  7374,  7378,  7382,  7386,
    7394,  7402,  7406,  7410,  7414,  7418,  7422,  7430,  7431,  7434,
    7436,  7437,  7438,  7439,  7440,  7441,  7444,  7446,  7452,  7459,
    7472,  7481,  7482,  7491,  7498,  7510,  7528,  7529,  7533,  7534,
    7538,  7539,  7542,  7543,  7548,  7549,  7556,  7557,  7563,  7565,
    7567,  7566,  7575,  7576,  7580,  7602,  7603,  7607,  7632,  7633,
    7636,  7638,  7641,  7648,  7649,  7654,  7665,  7676,  7685,  7687,
    7688,  7698,  7709,  7736,  7735,  7744,  7745,  7749,  7750,  7753,
    7755,  7767,  7776,  7791,  7814,  7833,  7835,  7834,  7856,  7858,
    7857,  7873,  7875,  7874,  7885,  7886,  7893,  7892,  7918,  7919,
    7920,  7927,  7933,  7938,  7939,  7945,  7952,  7953,  7954,  7958,
    7965,  7966,  7970,  7980,  8019,  8030,  8031,  8045,  8058,  8059,
    8062,  8063,  8068,  8069,  8070,  8071,  8072,  8073,  8085,  8099,
    8113,  8127,  8141,  8154,  8155,  8160,  8159,  8169,  8181,  8182,
    8186,  8187,  8188,  8189,  8190,  8191,  8192,  8193,  8194,  8195,
    8196,  8197,  8198,  8199,  8200,  8201,  8202,  8206,  8213,  8217,
    8221,  8222,  8223,  8230,  8234,  8242,  8245,  8253,  8263,  8264,
    8269,  8272,  8277,  8281,  8289,  8296,  8305,  8310,  8317,  8318,
    8319,  8323,  8331,  8332,  8333,  8340,  8344,  8351,  8356,  8362,
    8369,  8375,  8385,  8389,  8396,  8398,  8402,  8406,  8410,  8414,
    8421,  8429,  8430,  8433,  8435,  8439,  8443,  8457,  8472,  8475,
    8477,  8481,  8485,  8489,  8496,  8517,  8521,  8522,  8526,  8547,
    8555,  8564,  8566,  8565,  8584,  8585,  8589,  8590,  8594,  8597,
    8596,  8647,  8659,  8646,  8703,  8723,  8725,  8729,  8734,  8739,
    8743,  8747,  8752,  8757,  8762,  8767,  8776,  8780,  8784,  8788,
    8792,  8798,  8802,  8807,  8813,  8817,  8822,  8827,  8832,  8837,
    8842,  8847,  8856,  8860,  8864,  8870,  8874,  8878,  8882,  8886,
    8890,  8894,  8898,  8909,  8914,  8919,  8923,  8924,  8925,  8926,
    8927,  8928,  8929,  8930,  8939,  8944,  8955,  8956,  8963,  8964,
    8965,  8966,  8967,  8968,  8969,  8970,  8971,  8974,  8977,  8978,
    8979,  8980,  8981,  8982,  8989,  8990,  8995,  8996,  8999,  9001,
    9005,  9006,  9010,  9011,  9015,  9016,  9020,  9021,  9025,  9026,
    9027,  9028,  9029,  9032,  9033,  9034,  9035,  9036,  9038,  9039,
    9041,  9042,  9046,  9047,  9048,  9049,  9051,  9053,  9055,  9056,
    9057,  9058,  9059,  9060,  9061,  9062,  9063,  9069,  9070,  9071,
    9072,  9073,  9074,  9075,  9076,  9077,  9078,  9082,  9083,  9088,
    9089,  9090,  9091,  9092,  9096,  9104,  9105,  9106,  9107,  9108,
    9109,  9110,  9111,  9112,  9113,  9114,  9116,  9118,  9119,  9120,
    9124,  9125,  9126,  9127,  9128,  9129,  9130,  9131,  9132,  9133,
    9138,  9139,  9140,  9141,  9142,  9143,  9144,  9145,  9146,  9147,
    9152,  9153,  9164,  9165,  9189,  9190,  9207,  9210,  9211,  9212,
    9215,  9219,  9220,  9221,  9222,  9223,  9224,  9225,  9226,  9227,
    9228,  9229,  9230,  9231,  9232,  9233,  9234,  9240,  9241,  9242,
    9262,  9263,  9264,  9265,  9266,  9267,  9268,  9269,  9273,  9274,
    9275,  9276,  9277,  9278,  9284,  9285,  9286,  9287,  9288,  9289,
    9290,  9291,  9296,  9298,  9299,  9300,  9305,  9306,  9307,  9311,
    9312,  9313,  9314,  9315,  9316,  9327,  9328,  9329,  9330,  9335,
    9338,  9339,  9340,  9341,  9342,  9344,  9349,  9350,  9351,  9357,
    9358,  9359,  9360,  9361,  9362,  9363,  9364,  9365,  9366,  9370,
    9371,  9372,  9373,  9374,  9375,  9376,  9377,  9378,  9379,  9380,
    9381,  9382,  9383,  9385,  9386,  9387,  9388,  9389,  9390,  9391,
    9392,  9393,  9394,  9395,  9396,  9397,  9398,  9399,  9400,  9401,
    9404,  9405,  9406,  9414,  9415,  9416,  9420,  9421,  9422,  9426,
    9427,  9430,  9431,  9432,  9435,  9444,  9445,  9446,  9447,  9448,
    9449,  9450,  9451,  9452,  9453,  9454,  9455,  9456,  9458,  9459,
    9460,  9461,  9462,  9463,  9464,  9465,  9466,  9467,  9474,  9478,
    9482,  9483,  9484,  9485,  9486,  9487,  9488,  9489,  9495,  9496,
    9497,  9502,  9503,  9508,  9513,  9514,  9518,  9519,  9524,  9525,
    9529,  9530,  9531,  9536,  9537,  9541,  9542,  9546,  9547,  9551,
    9555,  9555,  9559,  9563,  9563,  9567,  9571,  9572,  9576,  9577,
    9581,  9589,  9591,  9595,  9602,  9612,  9615,  9619,  9626,  9638,
    9648,  9657,  9662,  9672,  9694,  9661,  9722,  9722,  9756,  9760,
    9759,  9773,  9772,  9792,  9793,  9798,  9820,  9822,  9826,  9837,
    9839,  9847,  9855,  9863,  9869,  9873,  9909,  9911,  9919,  9922,
    9935,  9940,  9950,  9985,  9987,  9986, 10023, 10024, 10028, 10029,
   10030, 10048, 10049, 10061, 10060, 10106, 10107, 10111, 10156, 10176,
   10179, 10208, 10213, 10207, 10226, 10226, 10266, 10274, 10275, 10276,
   10277, 10278, 10279, 10280, 10281, 10282, 10283, 10284, 10285, 10286,
   10287, 10288, 10289, 10290, 10291, 10292, 10293, 10294, 10295, 10296,
   10297, 10298, 10299, 10300, 10301, 10302, 10304, 10305, 10306, 10307,
   10308, 10309, 10310, 10311, 10312, 10313, 10314, 10315, 10316, 10317,
   10318, 10320, 10321, 10322, 10323, 10324, 10325, 10326, 10327, 10328,
   10329, 10330, 10331, 10332, 10333, 10334, 10335, 10336, 10337, 10338,
   10339, 10340, 10355, 10367, 10366, 10377, 10376, 10411, 10410, 10421,
   10425, 10429, 10435, 10441, 10446, 10451, 10456, 10461, 10467, 10473,
   10477, 10483, 10487, 10492, 10496, 10500, 10504, 10508, 10512, 10516,
   10520, 10534, 10541, 10542, 10549, 10549, 10560, 10561, 10565, 10569,
   10573, 10580, 10584, 10588, 10595, 10596, 10600, 10602, 10606, 10607,
   10611, 10612, 10616, 10620, 10621, 10630, 10631, 10636, 10637, 10641,
   10642, 10646, 10662, 10678, 10691, 10699, 10707, 10714, 10720, 10726,
   10731, 10737, 10742, 10747, 10760, 10765, 10770, 10776, 10782, 10788,
   10795, 10799, 10803, 10807, 10811, 10822, 10827, 10833, 10838, 10843,
   10848, 10854, 10860, 10865, 10871, 10877, 10883, 10890, 10895, 10900,
   10907, 10914, 10920, 10923, 10923, 10927, 10938, 10939, 10940, 10944,
   10945, 10946, 10950, 10951, 10955, 10959, 10978, 10977, 10986, 10990,
   10997, 11001, 11009, 11010, 11014, 11018, 11029, 11028, 11038, 11042,
   11053, 11055, 11068, 11069, 11077, 11076, 11085, 11086, 11090, 11096,
   11096, 11103, 11102, 11119, 11118, 11187, 11191, 11190, 11206, 11210,
   11214, 11222, 11225, 11233, 11241, 11245, 11249, 11253, 11257, 11276,
   11282, 11302, 11306, 11316, 11320, 11325, 11329, 11328, 11345, 11346,
   11351, 11359, 11393, 11395, 11399, 11408, 11421, 11424, 11428, 11432,
   11437, 11460, 11461, 11465, 11466, 11470, 11474, 11478, 11489, 11493,
   11500, 11504, 11512, 11516, 11523, 11530, 11534, 11545, 11544, 11556,
   11560, 11567, 11568, 11578, 11577, 11585, 11586, 11590, 11595, 11603,
   11604, 11605, 11606, 11607, 11612, 11611, 11623, 11624, 11632, 11631,
   11640, 11647, 11651, 11661, 11673, 11672, 11693, 11694, 11694, 11709,
   11708, 11717, 11724, 11735, 11734, 11743, 11747, 11751, 11756, 11764,
   11768, 11779, 11778, 11787, 11790, 11792, 11798, 11800, 11801, 11802,
   11803, 11811, 11810, 11822, 11826, 11830, 11834, 11838, 11839, 11840,
   11841, 11842, 11843, 11844, 11848, 11856, 11865, 11866, 11871, 11870,
   11914, 11918, 11924, 11926, 11930, 11931, 11935, 11936, 11940, 11944,
   11949, 11953, 11954, 11959, 11962, 11966, 11970, 11974, 11978, 11985,
   11986, 11991, 11990, 12007, 12014, 12014, 12026, 12030, 12038, 12039,
   12040, 12051, 12050, 12068, 12070, 12074, 12075, 12079, 12083, 12084,
   12085, 12086, 12091, 12096, 12090, 12110, 12111, 12116, 12121, 12115,
   12140, 12139, 12161, 12162, 12163, 12167, 12168, 12173, 12176, 12183,
   12196, 12208, 12215, 12216, 12222, 12223, 12227, 12228, 12229, 12230,
   12231, 12232, 12236, 12239, 12243, 12244, 12245, 12249, 12250, 12251,
   12252, 12256, 12257, 12262, 12263, 12267, 12277, 12293, 12298, 12304,
   12310, 12315, 12320, 12326, 12332, 12338, 12344, 12351, 12355, 12359,
   12363, 12367, 12372, 12377, 12382, 12387, 12393, 12398, 12403, 12410,
   12420, 12424, 12435, 12434, 12443, 12447, 12451, 12455, 12459, 12466,
   12470, 12481, 12480, 12492, 12491, 12499, 12498, 12508, 12532, 12545,
   12544, 12571, 12579, 12580, 12585, 12596, 12607, 12621, 12629, 12637,
   12638, 12643, 12649, 12659, 12671, 12677, 12687, 12700, 12699, 12711,
   12709, 12723, 12724, 12729, 12804, 12805, 12806, 12807, 12811, 12812,
   12816, 12820, 12830, 12829, 12843, 12842, 12883, 12883, 12884, 12884,
   12887, 12896, 12907, 12908, 12916, 12915, 12927, 12931, 12956, 12970,
   12993, 13016, 13037, 13061, 13064, 13072, 13071, 13080, 13091, 13090,
   13099, 13112, 13111, 13124, 13129, 13140, 13144, 13155, 13175, 13174,
   13183, 13187, 13193, 13200, 13203, 13210, 13216, 13222, 13227, 13239,
   13238, 13246, 13254, 13255, 13259, 13260, 13261, 13266, 13269, 13276,
   13280, 13288, 13295, 13296, 13297, 13298, 13299, 13300, 13301, 13313,
   13316, 13326, 13325, 13333, 13340, 13353, 13352, 13364, 13365, 13372,
   13371, 13380, 13384, 13385, 13386, 13390, 13391, 13392, 13393, 13400,
   13399, 13420, 13430, 13438, 13442, 13449, 13454, 13459, 13464, 13469,
   13474, 13482, 13483, 13487, 13492, 13498, 13500, 13501, 13502, 13503,
   13507, 13535, 13538, 13542, 13546, 13550, 13557, 13564, 13574, 13573,
   13586, 13591, 13584, 13603, 13606, 13613, 13614, 13618, 13626, 13630,
   13640, 13639, 13649, 13656, 13658, 13665, 13664, 13677, 13676, 13689,
   13690, 13694, 13698, 13709, 13708, 13716, 13720, 13731, 13730, 13739,
   13743, 13750, 13754, 13765, 13764, 13773, 13774, 13778, 13806, 13807,
   13811, 13812, 13813, 13814, 13818, 13819, 13823, 13824, 13825, 13829,
   13830, 13838, 13839, 13843, 13844, 13850, 13859, 13860, 13861, 13866,
   13867, 13868, 13872, 13879, 13895, 13896, 13897, 13903, 13902, 13914,
   13926, 13923, 13940, 13937, 13953, 13961, 13968, 13972, 13985, 13992,
   14004, 14007, 14012, 14016, 14029, 14036, 14037, 14041, 14042, 14045,
   14046, 14051, 14094, 14098, 14108, 14107, 14120, 14119, 14127, 14132,
   14142, 14157, 14156, 14166, 14195, 14196, 14200, 14204, 14208, 14212,
   14219, 14220, 14224, 14228, 14231, 14233, 14237, 14246, 14247, 14248,
   14251, 14253, 14257, 14261, 14265, 14273, 14274, 14278, 14279, 14283,
   14287, 14297, 14308, 14307, 14316, 14321, 14322, 14326, 14327, 14328,
   14332, 14333, 14337, 14341, 14342, 14346, 14350, 14354, 14364, 14363,
   14371, 14381, 14392, 14391, 14400, 14407, 14411, 14422, 14421, 14433,
   14442, 14445, 14449, 14453, 14460, 14464, 14474, 14486, 14485, 14494,
   14498, 14507, 14508, 14513, 14516, 14524, 14528, 14535, 14543, 14547,
   14558, 14557, 14565, 14568, 14573, 14575, 14579, 14585, 14586, 14587,
   14588, 14591, 14593, 14600, 14599, 14613, 14614, 14615, 14616, 14617,
   14618, 14619, 14620, 14624, 14625, 14629, 14630, 14636, 14645, 14652,
   14653, 14657, 14661, 14665, 14671, 14677, 14681, 14685, 14689, 14698,
   14702, 14706, 14715, 14724, 14725, 14729, 14738, 14739, 14743, 14747,
   14756, 14765, 14777, 14776, 14785, 14784, 14836, 14837, 14854, 14855,
   14858, 14859, 14868, 14871, 14876, 14881, 14891, 14908, 14913, 14923,
   14941, 14940, 14950, 14963, 14966, 14974, 14977, 14982, 14987, 14995,
   14996, 14997, 14998, 14999, 15000, 15004, 15012, 15013, 15017, 15021,
   15032, 15031, 15042, 15050, 15061, 15068, 15072, 15076, 15084, 15096,
   15099, 15106, 15110, 15117, 15118, 15119, 15120, 15127, 15126, 15135,
   15142, 15142, 15152, 15153, 15157, 15171, 15172, 15177, 15178, 15182,
   15183, 15187, 15191, 15202, 15201, 15210, 15214, 15218, 15222, 15230,
   15234, 15244, 15255, 15256, 15263, 15262, 15270, 15277, 15290, 15289,
   15297, 15311, 15310, 15318, 15335, 15334, 15344, 15352, 15353, 15358,
   15359, 15364, 15371, 15372, 15377, 15384, 15385, 15389, 15390, 15394,
   15398, 15408, 15407, 15422, 15427, 15439, 15438, 15447, 15448, 15449,
   15450, 15451, 15455, 15483, 15486, 15498, 15508, 15513, 15518, 15523,
   15531, 15571, 15572, 15576, 15636, 15646, 15669, 15670, 15671, 15672,
   15676, 15685, 15692, 15703, 15736, 15737, 15741, 15747, 15763, 15764,
   15771, 15770, 15782, 15792, 15793, 15798, 15801, 15805, 15809, 15816,
   15817, 15821, 15822, 15823, 15827, 15831, 15841, 15840, 15853, 15864,
   15851, 15875, 15877, 15881, 15882, 15886, 15890, 15902, 15911, 15921,
   15924, 15934, 15937, 15945, 15948, 15957, 15961, 15968, 15976, 15979,
   15988, 15992, 15999, 16007, 16010, 16014, 16015, 16016, 16019, 16021,
   16029, 16030, 16034, 16039, 16044, 16051, 16056, 16061, 16069, 16073,
   16080, 16084, 16095, 16094, 16111, 16106, 16117, 16119, 16122, 16124,
   16127, 16129, 16133, 16134, 16150, 16151, 16152, 16162, 16166, 16173,
   16181, 16182, 16186, 16187, 16191, 16199, 16200, 16205, 16206, 16207,
   16217, 16221, 16228, 16236, 16237, 16241, 16249, 16250, 16251, 16261,
   16265, 16272, 16280, 16281, 16285, 16293, 16294, 16295, 16305, 16309,
   16316, 16324, 16325, 16329, 16339, 16340, 16341, 16351, 16355, 16362,
   16370, 16371, 16375, 16385, 16386, 16387, 16397, 16401, 16408, 16416,
   16417, 16421, 16432, 16433, 16440, 16442, 16451, 16455, 16462, 16470,
   16471, 16475, 16485, 16486, 16496, 16500, 16507, 16515, 16516, 16520,
   16530, 16531, 16535, 16536, 16546, 16550, 16557, 16565, 16566, 16570,
   16581, 16584, 16593, 16596, 16604, 16608, 16617, 16621, 16628, 16629,
   16635, 16640, 16648, 16655, 16655, 16666, 16667, 16671, 16672, 16674,
   16676, 16678, 16679, 16681, 16682, 16683, 16684, 16685, 16687, 16688,
   16689, 16692, 16694, 16698, 16701, 16703, 16704, 16705, 16706, 16707,
   16708, 16710, 16711, 16712, 16713, 16714, 16717, 16718, 16722, 16723,
   16727, 16728, 16732, 16733, 16737, 16741, 16747, 16751, 16757, 16759,
   16760, 16764, 16765, 16766, 16770, 16771, 16772, 16776, 16780, 16784,
   16785, 16786, 16789, 16790, 16800, 16812, 16821, 16837, 16846, 16862,
   16877, 16878, 16883, 16892, 16898, 16908, 16922, 16944, 16948, 16969,
   16973, 16994, 17006, 17020, 17034, 17035, 17040, 17046, 17047, 17052,
   17061, 17063, 17068, 17082, 17083, 17084, 17091, 17102, 17103, 17107,
   17115, 17116, 17120, 17121, 17125, 17137, 17141, 17148, 17157, 17158,
   17164, 17173, 17184, 17201, 17205, 17212, 17213, 17214, 17221, 17222,
   17226, 17230, 17237, 17238, 17242, 17243, 17247, 17248, 17249, 17250,
   17254, 17258, 17262, 17266, 17270, 17274, 17278, 17299, 17309, 17313,
   17320, 17321, 17322, 17326, 17327, 17328, 17329, 17330, 17334, 17338,
   17345, 17346, 17347, 17348, 17352, 17356, 17363, 17375, 17387, 17401,
   17402, 17406, 17407, 17411, 17418, 17425, 17426, 17433, 17434, 17441,
   17442, 17443, 17447, 17448, 17452, 17456, 17460, 17464, 17465, 17469,
   17473, 17474, 17478, 17482, 17483, 17492, 17496, 17501, 17502, 17508,
   17512, 17516, 17520, 17521, 17527, 17531, 17535, 17536, 17540, 17547,
   17557, 17576, 17597, 17616, 17634, 17641, 17648, 17655, 17665, 17669,
   17676, 17680, 17687, 17697, 17707, 17717, 17730, 17756, 17760, 17768,
   17768, 17781, 17786, 17794, 17802, 17806, 17816, 17831, 17853, 17873,
   17877, 17884, 17898, 17899, 17900, 17901, 17902, 17903, 17907, 17911,
   17928, 17932, 17939, 17940, 17941, 17942, 17943, 17944, 17945, 17949,
   17950, 17951, 17952, 17958, 17962, 17966, 17970, 17974, 17978, 17983,
   17987, 17991, 17995, 17999, 18003, 18007, 18011, 18018, 18019, 18023,
   18024, 18025, 18026, 18030, 18031, 18032, 18033, 18034, 18038, 18042,
   18046, 18053, 18057, 18061, 18068, 18075, 18082, 18092, 18092, 18108,
   18115, 18125, 18132, 18142, 18146, 18159, 18163, 18178, 18186, 18187,
   18191, 18192, 18193, 18197, 18198, 18203, 18206, 18214, 18217, 18224,
   18226, 18227, 18231, 18232, 18236, 18237, 18238, 18243, 18246, 18259,
   18263, 18271, 18275, 18279, 18283, 18287, 18291, 18295, 18299, 18306,
   18307, 18311, 18312, 18322, 18323, 18332, 18336, 18340, 18344, 18351,
   18352, 18353, 18354, 18355, 18356, 18357, 18358, 18359, 18360, 18361,
   18362, 18363, 18364, 18365, 18366, 18367, 18368, 18369, 18370, 18371,
   18372, 18373, 18374, 18375, 18376, 18377, 18378, 18379, 18380, 18381,
   18382, 18383, 18384, 18385, 18386, 18387, 18388, 18389, 18390, 18391,
   18392, 18393, 18394, 18395, 18396, 18397, 18398, 18399, 18400, 18401,
   18402, 18406, 18407, 18408, 18409, 18410, 18411, 18412, 18413, 18414,
   18415, 18416, 18417, 18418, 18419, 18420, 18421, 18422, 18423, 18424,
   18425, 18426, 18427, 18428, 18435, 18435, 18436, 18436, 18437, 18437,
   18438, 18438, 18439, 18439, 18439, 18440, 18440, 18441, 18441, 18442,
   18442, 18443, 18443, 18444, 18444, 18445, 18445, 18446, 18446, 18447,
   18447, 18448, 18448, 18449, 18449, 18450, 18450, 18451, 18451, 18452,
   18452, 18453, 18453, 18454, 18454, 18455, 18455, 18456, 18456, 18457,
   18457, 18458, 18458, 18459, 18459, 18460, 18460, 18460, 18461, 18461,
   18461, 18462, 18462, 18463, 18463, 18464, 18464, 18465, 18465, 18466,
   18466, 18467, 18467, 18467, 18468, 18468, 18468, 18469, 18469, 18469,
   18469, 18470, 18470, 18470, 18471, 18471, 18472, 18472, 18473, 18473,
   18473, 18474, 18474, 18474, 18475, 18475, 18476, 18476, 18477, 18477,
   18478, 18478, 18479, 18479, 18480, 18480, 18481, 18481, 18482, 18482,
   18483, 18483, 18484, 18484, 18484, 18485, 18485, 18485, 18485, 18486,
   18486, 18487, 18487, 18488, 18488, 18489, 18489, 18490, 18490, 18491,
   18491, 18492, 18492, 18492, 18493, 18493, 18494, 18494, 18495, 18495,
   18496, 18496, 18496, 18497, 18497, 18498, 18498, 18499, 18499, 18500,
   18500, 18501, 18501, 18502, 18502, 18503, 18503, 18504, 18504, 18505,
   18505, 18506, 18506, 18507, 18507, 18508, 18508, 18509, 18509, 18510,
   18510, 18510, 18514, 18514, 18515, 18515, 18516, 18516, 18517, 18517,
   18517, 18517, 18518, 18518, 18519, 18519, 18520, 18520, 18521, 18521,
   18522, 18522, 18523, 18523, 18524, 18524, 18525, 18525, 18525, 18526,
   18526, 18527, 18527, 18528, 18528, 18529, 18529, 18530, 18530, 18531,
   18531, 18534, 18534, 18535, 18535, 18536, 18536, 18537, 18537, 18538,
   18538, 18539, 18539, 18540, 18540, 18541, 18541
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "$undefined", "\"3D\"", "ABSENT", "ACCEPT",
  "ACCESS", "\"ACTIVE-X\"", "ACTION", "ACTUAL", "ADD", "ADDRESS",
  "\"ADJUSTABLE-COLUMNS\"", "ADVANCING", "AFTER", "ALIGNMENT", "ALL",
  "ALLOCATE", "ALLOWING", "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"",
  "\"ALPHABETIC-UPPER\"", "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"",
  "ALSO", "ALTER", "ALTERNATE", "AND", "ANY", "APPLY", "ARE", "AREA",
  "AREAS", "\"ARGUMENT-NUMBER\"", "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS",
  "ASCENDING", "ASCII", "ASSIGN", "AT", "ATTRIBUTE", "ATTRIBUTES", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BAR", "BASED", "BEFORE", "BELL", "BINARY",
  "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"", "BUSY",
  "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"", "CALL",
  "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHANGED", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"",
  "CLASS", "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"",
  "CLINE", "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-TYPES\"", "DATE", "\"DATE-ENTRY\"", "DAY", "\"DAY-OF-WEEK\"",
  "DE", "DEBUGGING", "\"DECIMAL-POINT\"", "DECLARATIVES", "DEFAULT",
  "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISP", "DISPLAY",
  "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"", "\"FUNCTION DISPLAY-OF\"",
  "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"", "DIVISION", "DOTDASH",
  "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"", "\"DROP-LIST\"", "DOWN",
  "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI",
  "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI", "ENCRYPTION",
  "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"", "\"END-CALL\"",
  "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"", "\"END-DISPLAY\"",
  "\"END-DIVIDE\"", "\"END-EVALUATE\"", "\"END FUNCTION\"", "\"END-IF\"",
  "\"END-JSON\"", "\"END-MODIFY\"", "\"END-MULTIPLY\"", "\"END-PERFORM\"",
  "\"END PROGRAM\"", "\"END-READ\"", "\"END-RECEIVE\"", "\"END-RETURN\"",
  "\"END-REWRITE\"", "\"END-SEARCH\"", "\"END-START\"", "\"END-STRING\"",
  "\"END-SUBTRACT\"", "\"END-UNSTRING\"", "\"END-WRITE\"", "\"END-XML\"",
  "ENGRAVED", "\"ENSURE-VISIBLE\"", "ENTRY", "\"ENTRY-CONVENTION\"",
  "\"ENTRY-FIELD\"", "\"ENTRY-REASON\"", "ENVIRONMENT",
  "\"ENVIRONMENT-NAME\"", "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS",
  "EQUAL", "ERASE", "ERROR", "ESCAPE", "\"ESCAPE-BUTTON\"", "ESI",
  "EVALUATE", "EVENT", "\"EVENT-LIST\"", "\"EVENT STATUS\"", "EVERY",
  "EXCEPTION", "\"EXCEPTION CONDITION\"", "\"EXCEPTION-VALUE\"", "EXPAND",
  "EXCLUSIVE", "EXHIBIT", "EXIT", "\"exponentiation operator\"", "EXTEND",
  "\"EXTENDED-SEARCH\"", "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FD",
  "\"FH--FCD\"", "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"",
  "\"FILE-LIMIT\"", "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"",
  "\"FILL-COLOR\"", "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER",
  "FINAL", "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "\"FUNCTION FORMATTED-DATE\"",
  "\"FUNCTION FORMATTED-DATETIME\"", "\"FUNCTION FORMATTED-TIME\"",
  "FRAME", "FRAMED", "FREE", "FROM", "\"FROM CRT\"", "FULL",
  "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"", "\"GO-SEARCH\"",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "\"GROUP-VALUE\"", "HANDLE", "\"HAS-CHILDREN\"", "HEADING",
  "\"HEADING-COLOR\"", "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"",
  "HEAVY", "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT",
  "\"HIGH-COLOR\"", "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL",
  "\"HSCROLL-POS\"", "ICON", "ID", "IDENTIFIED", "IDENTIFICATION", "IF",
  "IGNORE", "IGNORING", "IN", "INDEPENDENT", "INDEX", "INDEXED",
  "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE", "INPUT",
  "\"INPUT-OUTPUT\"", "INQUIRE", "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"",
  "INSPECT", "INTERMEDIATE", "INTO", "INTRINSIC", "INVALID",
  "\"INVALID KEY\"", "IS", "ITEM", "\"ITEM-TEXT\"", "\"ITEM-TO_ADD\"",
  "\"ITEM-TO_DELETE\"", "\"ITEM-TO_EMPTY\"", "\"ITEM-VALUE\"", "\"I-O\"",
  "\"I-O-CONTROL\"", "JSON", "JUSTIFIED", "KEPT", "KEY", "KEYBOARD",
  "LABEL", "\"LABEL-OFFSET\"", "\"LARGE-FONT\"", "\"LARGE-OFFSET\"",
  "LAST", "\"LAST-ROW\"", "\"LAYOUT-DATA\"", "\"LAYOUT-MANAGER\"",
  "LEADING", "\"LEADING-SHIFT\"", "LEAVE", "LEFT", "LEFTLINE",
  "\"LEFT-TEXT\"", "LENGTH", "\"LENGTH OF\"",
  "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS", "\"LESS OR EQUAL\"",
  "\"level-number\"", "LIKE", "LIMIT", "LIMITS", "LINAGE",
  "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"", "\"LINE LIMIT\"",
  "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"", "LINKAGE",
  "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC", "LOCALE",
  "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE", "MINUS",
  "\"MIN-VAL\"", "\"Mnemonic name\"", "MODE", "MODIFY", "MODULES", "MOVE",
  "MULTILINE", "MULTIPLE", "MULTIPLY", "NAME", "NAMED", "NAMESPACE",
  "\"NAMESPACE-PREFIX\"", "NATIONAL", "\"NATIONAL-EDITED\"",
  "\"FUNCTION NATIONAL-OF\"", "NATIVE", "\"NAVIGATE-URL\"",
  "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "NOMINAL", "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NONNUMERIC", "NORMAL",
  "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT END\"",
  "\"NOT EOP\"", "\"NOT ESCAPE\"", "\"NOT EQUAL\"", "\"NOT EXCEPTION\"",
  "\"NOT INVALID KEY\"", "\"NOT OVERFLOW\"", "\"NOT SIZE ERROR\"",
  "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER", "NUMBERS", "NUMERIC",
  "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"", "OBJECT",
  "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"", "OMITTED",
  "ON", "ONLY", "OPEN", "OPTIONAL", "OPTIONS", "OR", "ORDER",
  "ORGANIZATION", "OTHER", "OTHERS", "OUTPUT", "\"OVERLAP-LEFT\"",
  "\"OVERLAP-TOP\"", "OVERLINE", "\"PACKED-DECIMAL\"", "PADDING", "PASCAL",
  "PAGE", "\"PAGE-COUNTER\"", "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH",
  "PARENT", "PARSE", "PASSWORD", "PERFORM", "PERMANENT", "PH", "PF",
  "PHYSICAL", "PICTURE", "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT",
  "PLUS", "POINTER", "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"",
  "POSITIVE", "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PURGE", "\"PUSH-BUTTON\"", "\"QUERY-INDEX\"",
  "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE", "RAISED", "RANDOM", "RD",
  "READ", "READERS", "\"READ-ONLY\"", "\"READY TRACE\"", "RECEIVE",
  "RECORD", "\"RECORD-DATA\"", "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"",
  "\"RECORD-TO-DELETE\"", "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES",
  "REEL", "REFERENCE", "REFERENCES", "REFRESH", "\"REGION-COLOR\"",
  "RELATIVE", "RELEASE", "REMAINDER", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPLACE", "REPLACING", "REPORT", "REPORTING",
  "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN", "RESERVE",
  "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"", "\"RESET-LIST\"",
  "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING", "REVERSE",
  "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED", "REWIND",
  "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED", "ROLLBACK",
  "ROUNDED", "ROUNDING", "\"ROW-COLOR\"", "\"ROW-COLOR-PATTERN\"",
  "\"ROW-DIVIDERS\"", "\"ROW-FONT\"", "\"ROW-HEADINGS\"",
  "\"ROW-PROTECTION\"", "RUN", "S", "SAME", "\"SAVE-AS\"",
  "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"", "SCROLL",
  "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALIDATE", "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "Y", "YYYYDDD", "YYYYMMDD", "ZERO",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "_program_body", "$@6", "$@7",
  "_identification_header", "identification_header",
  "identification_or_id", "program_id_paragraph", "$@8", "$@9",
  "function_id_paragraph", "$@10", "program_id_name", "end_program_name",
  "_as_literal", "_program_type", "program_type_clause",
  "init_or_recurse_and_common", "init_or_recurse", "_options_paragraph",
  "_options_clauses", "_arithmetic_clause", "arithmetic_choice",
  "_default_rounded_clause", "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "_configuration_section",
  "_configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "source_computer_paragraph", "$@11", "_source_computer_entry",
  "_with_debugging_mode", "object_computer_paragraph", "$@12",
  "_object_computer_entry", "object_clauses_list", "object_clauses",
  "object_computer_memory", "object_computer_sequence",
  "program_collating_sequence", "$@13", "program_coll_sequence_values",
  "object_computer_segment", "object_computer_class", "locale_class",
  "computer_words", "repository_paragraph", "$@14", "_repository_entry",
  "repository_list", "repository_name", "repository_name_list",
  "special_names_header", "special_names_sentence", "special_name_list",
  "special_name", "mnemonic_name_clause", "$@15", "mnemonic_choices",
  "_special_name_mnemonic_on_off", "on_off_clauses", "on_off_clauses_1",
  "alphabet_name_clause", "@16", "alphabet_definition", "@17", "@18",
  "alphabet_target_alphanumeric", "alphabet_target_national",
  "alphabet_type_alphanumeric", "alphabet_type_national",
  "alphabet_type_common", "alphabet_literal_list", "alphabet_literal",
  "@19", "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "symbolic_characters_clause", "_sym_in_word", "symbolic_collection",
  "symbolic_chars_list", "symbolic_chars_phrase", "char_list",
  "integer_list", "symbolic_constant_clause", "symbolic_constant_list",
  "symbolic_constant", "class_name_clause", "class_item_list",
  "class_item", "_class_type", "_in_alphabet", "locale_clause",
  "currency_sign_clause", "_with_pic_symbol", "decimal_point_clause",
  "numeric_sign_clause", "cursor_clause", "crt_status_clause",
  "screen_control", "event_status", "top_clause", "$@20",
  "_input_output_section", "_input_output_header", "_file_control_header",
  "_file_control_sequence", "file_control_entry", "$@21",
  "_select_clauses_or_error", "_select_clause_sequence", "select_clause",
  "assign_clause", "_assign_device_or_line_adv_file", "assign_device",
  "general_device_name", "line_seq_device_name", "line_adv_file",
  "_ext_clause", "ext_clause", "assignment_name", "access_mode_clause",
  "access_mode", "alternative_record_key_clause", "_password_clause",
  "password_clause", "$@22", "_suppress_clause",
  "collating_sequence_clause", "collating_sequence", "$@23",
  "coll_sequence_values", "collating_sequence_clause_key", "alphabet_name",
  "file_status_clause", "_file_or_sort", "lock_mode_clause", "$@24",
  "lock_mode", "_lock_with", "_with_rollback", "with_rollback",
  "_with_mass_update", "organization_clause", "organization",
  "padding_character_clause", "record_delimiter_clause", "$@25",
  "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@26", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@27",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event", "_data_division",
  "$@28", "_data_division_header", "data_division_header",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@29", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "_communication_section", "$@30",
  "_communication_description_sequence", "communication_description",
  "communication_description_entry", "$@31",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses",
  "_working_storage_section", "$@32", "_record_description_list", "$@33",
  "record_description_list", "data_description", "$@34", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@35", "constant_entry", "$@36", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@37",
  "special_names_target", "volatile_clause", "picture_clause",
  "_pic_locale_format", "_is_locale_name", "locale_name", "type_to_clause",
  "usage_clause", "usage", "double_usage", "_font_name", "_layout_name",
  "sign_clause", "report_occurs_clause", "_occurs_step", "occurs_clause",
  "_occurs_to_integer", "_occurs_from_integer", "_occurs_integer_to",
  "_occurs_depending", "_capacity_in", "_occurs_initialized",
  "_occurs_keys_and_indexed", "$@38", "occurs_keys", "occurs_key_list",
  "occurs_key_field", "ascending_or_descending", "_occurs_indexed",
  "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "$@39",
  "value_item_list", "value_item", "_false_is", "any_length_clause",
  "external_form_clause", "identified_by_clause", "_local_storage_section",
  "$@40", "_linkage_section", "$@41", "_report_section", "$@42",
  "_report_description_sequence", "report_description", "$@43",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@44", "_report_group_options", "report_group_option", "type_is_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "report_varying_clause", "line_clause", "line_keyword_clause",
  "_line_clause_options", "line_clause_option", "column_clause",
  "col_keyword_clause", "_orientation", "_left_right_center",
  "col_or_plus", "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@45",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@46", "$@47", "$@48", "_screen_options",
  "screen_option", "control_definition", "control_type_name",
  "control_type", "control_item", "_control_attributes",
  "control_attributes", "control_attribute", "control_style",
  "control_property", "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause", "_procedure_division",
  "procedure_division", "$@49", "$@50", "$@51", "$@52",
  "_procedure_using_chaining", "$@53", "$@54", "procedure_param_list",
  "procedure_param", "_procedure_type", "_size_optional",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@55",
  "_procedure_list", "procedure", "section_header", "$@56",
  "_use_statement", "paragraph_header", "invalid_statement", "_segment",
  "statement_list", "@57", "@58", "statements", "$@59", "statement",
  "accept_statement", "$@60", "accept_body", "$@61", "$@62",
  "accp_identifier", "field_with_pos_specifier", "$@63", "_pos_specifier",
  "pos_specifier", "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@64", "add_body", "_add_to", "_end_add", "allocate_statement", "$@65",
  "allocate_body", "_loc", "allocate_returning", "alter_statement", "$@66",
  "alter_body", "alter_entry", "_proceed_to", "call_statement", "$@67",
  "call_body", "$@68", "_conv_linkage", "$@69", "conv_linkage_option",
  "_mnemonic_conv", "mnemonic_conv", "program_or_prototype",
  "_id_or_lit_or_func_as", "nested_or_prototype", "call_using", "$@70",
  "call_param_list", "call_param", "_call_type", "call_returning",
  "return_give", "null_or_omitted", "call_exception_phrases",
  "_call_on_exception", "call_on_exception", "_call_not_on_exception",
  "call_not_on_exception", "_end_call", "cancel_statement", "$@71",
  "cancel_body", "id_or_lit_or_program_name", "close_statement", "$@72",
  "close_body", "close_files", "_close_option", "close_window", "$@73",
  "_close_display_option", "compute_statement", "$@74", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@75",
  "_continue_after_phrase", "$@76", "destroy_statement", "$@77",
  "destroy_body", "delete_statement", "$@78", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@79",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@80", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@81", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "_display_upon", "display_upon", "crt_under",
  "display_erase", "$@82", "display_pos_specifier",
  "field_or_literal_or_erase_with_pos_specifier", "$@83",
  "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@84", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@85", "$@86", "sub_or_window", "display_floating_window", "$@87",
  "$@88", "display_initial_window", "$@89", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@90", "divide_body", "_end_divide",
  "enable_statement", "$@91", "entry_statement", "$@92", "$@93",
  "entry_body", "entry_goto_body", "evaluate_statement", "$@94",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@95", "$@96",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exhibit_statement", "$@97", "exhibit_body", "$@98",
  "_changed", "_named", "exhibit_target_list", "exhibit_target",
  "exit_statement", "$@99", "exit_body", "exit_program_returning",
  "free_statement", "$@100", "free_body", "generate_statement", "$@101",
  "generate_body", "goto_statement", "$@102", "go_body", "goto_depending",
  "goback_statement", "if_statement", "$@103", "if_else_statements",
  "_if_then", "if_true", "if_false", "_end_if", "initialize_statement",
  "$@104", "initialize_body", "_initialize_filler", "_initialize_value",
  "_initialize_replacing", "initialize_replacing_list",
  "initialize_replacing_item", "initialize_category",
  "_initialize_default", "initiate_statement", "$@105", "initiate_body",
  "inquire_statement", "$@106", "inquire_body", "inspect_statement",
  "$@107", "inspect_body", "send_identifier", "inspect_list",
  "inspect_tallying", "$@108", "inspect_replacing", "inspect_converting",
  "tallying_list", "tallying_item", "replacing_list", "replacing_item",
  "rep_keyword", "replacing_region", "inspect_region", "inspect_before",
  "inspect_after", "json_generate_statement", "$@109",
  "json_generate_body", "$@110", "$@111", "_json_suppress",
  "json_suppress_list", "json_suppress_entry", "_end_json",
  "json_parse_statement", "$@112", "json_parse_body", "_with_detail",
  "merge_statement", "$@113", "modify_statement", "$@114", "modify_body",
  "_end_modify", "move_statement", "$@115", "move_body",
  "multiply_statement", "$@116", "multiply_body", "_end_multiply",
  "open_statement", "$@117", "open_body", "open_file_entry",
  "_open_exclusive", "open_mode", "_open_sharing", "_open_option",
  "lock_allowing", "open_lock_option", "allowing_option", "allowing_all",
  "open_option_sequential", "osvs_input_mode", "perform_statement",
  "$@118", "perform_body", "$@119", "$@120", "_end_perform",
  "end_perform_or_dot", "perform_procedure", "_perform_option",
  "perform_test", "cond_or_exit", "perform_varying_list",
  "perform_varying", "_by_phrase", "purge_statement", "$@121",
  "raise_statement", "$@122", "raise_body", "exception_name",
  "read_statement", "$@123", "read_body", "_read_into", "_lock_phrases",
  "ignoring_lock", "advancing_lock_or_retry", "_retry_phrase",
  "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@124", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@125", "release_body",
  "reset_statement", "return_statement", "$@126", "return_body",
  "_end_return", "rewrite_statement", "$@127", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search_statement", "$@128", "search_body", "search_varying",
  "search_at_end", "search_whens", "search_when", "_end_search",
  "send_statement", "$@129", "send_body", "_from_identifier",
  "from_identifier", "with_indicator", "_replacing_line", "set_statement",
  "$@130", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@131", "sort_body", "@132", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@133", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "disallowed_op",
  "not_equal_op", "_end_start", "stop_statement", "$@134",
  "stop_returning", "_status_x", "stop_argument", "stop_literal",
  "string_statement", "$@135", "string_body", "string_items", "$@136",
  "string_item_list", "string_item", "_string_delimited",
  "string_delimiter", "_with_pointer", "_end_string", "subtract_statement",
  "$@137", "subtract_body", "_end_subtract", "suppress_statement",
  "_printing", "terminate_statement", "$@138", "terminate_body",
  "transform_statement", "$@139", "transform_body", "unlock_statement",
  "$@140", "unlock_body", "unstring_statement", "$@141", "unstring_body",
  "_unstring_delimited", "unstring_delimited_list",
  "unstring_delimited_item", "unstring_into", "unstring_into_item",
  "_unstring_into_delimiter", "_unstring_tallying", "_end_unstring",
  "validate_statement", "$@142", "validate_fields", "use_statement",
  "$@143", "use_phrase", "use_file_exception", "use_global",
  "use_file_exception_target", "use_debugging", "debugging_list",
  "debugging_target", "_all_refs", "use_start_end", "program_start_end",
  "use_reporting", "use_exception_list", "use_exception", "use_ex_keyw",
  "write_statement", "$@144", "write_body", "from_option", "write_option",
  "before_or_after", "write_handler", "_end_write",
  "xml_generate_statement", "$@145", "xml_generate_body", "$@146", "$@147",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_name_of",
  "identifier_name_list", "identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@148", "xml_parse_body", "$@149",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_display_exception_phrases",
  "_disp_on_exception", "disp_on_exception", "_disp_not_on_exception",
  "disp_not_on_exception", "_xml_exception_phrases", "_xml_on_exception",
  "xml_on_exception", "_xml_not_on_exception", "xml_not_on_exception",
  "_json_exception_phrases", "_json_on_exception", "json_on_exception",
  "_json_not_on_exception", "json_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@150", "expr_tokens",
  "expr_token", "_not_expr", "not_expr", "condition_or_class", "eq", "gt",
  "lt", "ge", "le", "exp_list", "_e_sep", "exp", "exp_term", "exp_factor",
  "exp_unary", "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "length_of_register", "report_x_list", "expr_x",
  "arith_x", "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "simple_display_all_value", "inspect_from",
  "inspect_to", "simple_value", "simple_all_value", "id_or_lit",
  "id_or_lit_or_func", "id_or_lit_or_length_or_func", "num_id_or_lit",
  "positive_id_or_lit", "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit",
  "from_parameter", "sub_identifier", "table_identifier",
  "sub_identifier_1", "display_identifier", "numeric_identifier",
  "identifier_or_file_name", "identifier_field", "type_name", "identifier",
  "identifier_1", "identifier_list", "target_identifier",
  "target_identifier_1", "display_identifier_or_alphabet_name",
  "qualified_word", "unqualified_word", "$@151", "unqualified_word_check",
  "subref", "refmod", "integer", "symbolic_integer",
  "unsigned_pos_integer", "integer_or_zero", "class_value", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@152",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "flag_initialized", "flag_initialized_to", "to_init_val", "_flag_next",
  "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_advancing", "_after",
  "_are", "_area", "_areas", "_as", "_at", "_before", "_binary", "_box",
  "_by", "_character", "_characters", "_collating", "_contains",
  "_controls", "_control", "_data", "_end_of", "_erase", "_every", "_file",
  "_for", "_from", "_in", "_in_equal", "_in_order", "_index", "_indicate",
  "_initial", "_into", "_is", "_is_equal", "_is_are", "_is_are_equal",
  "_is_in", "_key", "_line", "_line_or_lines", "_limits", "_lines",
  "_lock", "_message", "_mode", "_new", "_number", "_number_or_numbers",
  "_of", "_on", "_on_for", "_onoff_status", "_other", "_others",
  "_procedure", "_program", "_protected", "_record", "_records", "_right",
  "_sign", "_signed", "_sign_is", "_size", "_standard", "_status",
  "_symbolic", "_tape", "_terminal", "_then", "_times", "_to", "_up",
  "_when", "_when_set_to", "_with", "_with_for", "column_or_col",
  "columns_or_cols", "column_or_cols", "column_or_col_or_position_or_pos",
  "comp_equal", "exception_or_error", "file_limit_or_limits", "in_of",
  "label_option", "line_or_lines", "lock_records",
  "object_char_or_word_or_modules", "records", "reel_or_unit",
  "size_or_length", "length_of", "track_or_tracks", "using_or_varying",
  "detail_keyword", "ch_keyword", "cf_keyword", "ph_keyword", "pf_keyword",
  "rh_keyword", "rf_keyword", "control_keyword", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183
};
# endif

#define YYPACT_NINF -3969

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-3969)))

#define YYTABLE_NINF -3154

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -3969,  1400,  1510, -3969, -3969, -3969,  1154, -3969,   927, -3969,
   -3969,  1309, -3969, -3969, -3969,    -4, -3969,  1413,   594, -3969,
    1467, -3969, -3969, -3969,   927,   927,   967,  1797,  1693, -3969,
    1789,  1171,  1216,  1890,  1899, -3969,  1661, -3969,  1973,  1370,
    2012,  1489,  1812,  1793,   -77,   -77, -3969, -3969,  1890, -3969,
   -3969, -3969, -3969,  1198,  1579,  1948, -3969,  2057, -3969,  1481,
   -3969,  1488,  1606, -3969,  2022,   108,   108,  1570,  1600,  1661,
    1661,  1661,   108,  1605,  1525,  1530,  1661,  1534,  1539,  1675,
   -3969, -3969, -3969,  1793, -3969, -3969, -3969, -3969, -3969, -3969,
     185, -3969, -3969, -3969, -3969,  1966, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2326,
    2326,   -47, -3969,   -47, -3969, -3969, -3969, -3969, -3969,  1889,
    1661,  1968,  1560,  1513,  1671, -3969, -3969,  1566,  1575, -3969,
   -3969, -3969, -3969,  1066,  1661, -3969,  1661,  1486,  2266,  1486,
    1661,  1661, -3969, -3969,  1486, -3969, -3969, -3969,  1490,  1496,
    1661,  1682, -3969, -3969, -3969, -3969,  1500, -3969,  1976,  1613,
   -3969, -3969, -3969,  1621,  1628, -3969,  1661,    53,  1764,  1638,
   -3969,  2242, -3969, -3969, -3969,  1643,    26, -3969, -3969,   895,
    1066, -3969,  1661,   581,  1486,  2016,   -23, -3969, -3969, -3969,
   -3969,  2020,  1630,   167,  1025, -3969,  1576, -3969,  1490, -3969,
    1661, -3969,  1496, -3969,   124, -3969,   108, -3969, -3969, -3969,
   -3969, -3969,  1528,   -72,  1661,   117, -3969, -3969, -3969,   741,
   -3969, -3969,   178, -3969, -3969, -3969, -3969,  1661, -3969, -3969,
    8607,  9187, -3969, -3969, -3969,  1564, -3969,   769,   122,  1668,
    1378, -3969, -3969,   523, -3969, -3969, -3969,   613,  1135, -3969,
   -3969, -3969,  -278, -3969, -3969,  1486, -3969,  1765, -3969,  1748,
   -3969,  1661, -3969, -3969,   137, -3969, -3969, -3969, -3969, -3969,
     129,  2381,  2374,   120,  1584, -3969,   224, -3969, -3969,    15,
   -3969,   208, -3969, -3969, -3969, -3969,  2047, -3969,   -72, -3969,
    2095,   108,   108, -3969,  1528,  1688,    67, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,  1386,   408,  9752, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  2168, -3969, -3969, -3969, -3969,
   -3969, -3969,   845, -3969, -3969, -3969, -3969, -3969,    -7, -3969,
   -3969, -3969, -3969,  1786, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,  1250, -3969, -3969,  1901, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,     4, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1799,
    2377, -3969,   419,  1698, -3969, -3969, -3969,  1956, -3969,   108,
    1536, -3969,  1952,  1347, -3969,   151, -3969, -3969, -3969, -3969,
   -3969, -3969,  1661,  1661, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1196, -3969,  1707, -3969, -3969,  1927, -3969,
   -3969, -3969,  1661,  2065, -3969, -3969, -3969, -3969,   763,  1661,
   -3969, -3969,  1795,  2120, -3969,  2326,  1199,  2326,  1703, -3969,
   -3969,  1709,  2332,  1597, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  1715, -3969, -3969,  2047, -3969,   108, -3969, -3969,
   -3969, -3969, -3969, -3969,  -253, -3969, -3969, -3969,  1916, -3969,
    2394, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  1622, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  -255,  2467, 17316,   226,   408,   747,
    1143,   271,  2521,  -389,   115,   849,  5461, 12639,   849,  2180,
     408,  1295,  2429,  1339,   271,  1486,  1723, -3969, -3969, 12639,
   -3969,  6752,   271,  1629,   140,  2509, -3969, -3969,  1486,   140,
   11695, 12639, -3969,  2246,   -96,  1632,   -74,  1635,  1632,  1486,
    1635,  -359,   130,  1632,   857,  1486,  1635, -3969, -3969, -3969,
   -3969,  1486, -3969, -3969, -3969, -3969, -3969, -3969,  1720, -3969,
   11632, -3969, -3969,  1629,   132,  1486,  1635,  8040,  1486,  -359,
   -3969, -3969,  1729,  1840,  2091,  1490,  1490,  1490,   974,  1735,
   13576, -3969, -3969, -3969,  2114, -3969, -3969, -3969, -3969,  1952,
    1723,  1723,  2003,  1952,  1952,  1723,  1952,  1952,  1723,  1952,
    1952,  1734, -3969,  2271,   802, -3969, -3969, -3969,  2530,  1743,
   -3969, -3969,  1194,  1694,  1651, -3969, -3969,  1135,  2111,  2065,
   -3969, -3969,   882, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  2080, -3969,  1597, -3969, -3969, -3969, -3969, -3969,
   -3969,    34, -3969,  1301,  2330, -3969, 14999,  1740,  2088,  2235,
    2003, -3969, -3969, -3969,  1486, -3969, -3969,  1750,  1751,  1752,
   -3969, -3969,  1753,   -23,   -23,  1754,  1755,  1756, -3969, -3969,
    1757,   -23, -3969, -3969, -3969,  1486,  1759, -3969,  1752, -3969,
    2351, -3969, 12124, -3969, -3969,  9925, -3969, -3969, -3969,  1762,
    1766,  1767, -3969, 17502, 17316, 17502, -3969,   242,  1044, -3969,
    2298, -3969, -3969,  9925, -3969,   545,  1715, -3969, -3969,   226,
   -3969,  1782, -3969,   -23, -3969,  2357,   -96, -3969, -3969,   747,
   -3969, -3969, -3969, -3969, -3969,  1635, -3969,  1329,  2003,  2358,
   -3969,  1002, -3969,  1910, -3969, -3969,  1720,  1715, -3969, -3969,
    1635,  2360,  1967,  2445, -3969, -3969,  1486,  1821,  1823, -3969,
   -3969, -3969,  1632, -3969,  2249, -3969,  1546,  2539, -3969, -3969,
   -3969, -3969, -3969,  2375,    94, 12284, -3969, -3969, -3969, -3969,
    1712,  1740, -3969, -3969, -3969, -3969, -3969,  2249, 11508,  1550,
    1580,  2382,   252, -3969,  1817,  2173, -3969, -3969, -3969,  2384,
     123, -3969, -3969, -3969,  4846, -3969, -3969,  2139, -3969, -3969,
    2454,   845, -3969, -3969, -3969,   271, -3969, -3969, -3969, -3969,
   -3969,  2368, -3969, -3969,  1836, -3969, -3969,   267, -3969,  1629,
   -3969, -3969,  1486, 11030,  1036, -3969,  1059, -3969,    68, -3969,
   -3969, -3969,  1486,  1486, -3969, -3969, -3969,  1811, 10274,  1036,
    2391, 12639, -3969,  1830,  2392,  2565, -3969,  1738, -3969,  1634,
   -3969, -3969,  6550,  1844, -3969, -3969,  1737, -3969, -3969,  2395,
     724,  2393,   807, -3969,  2308, -3969,  2396,  1967,  1744,  2398,
   -3969,  2308,  1486,  2399,  1768, -3969, -3969,  2310,  9925,  2372,
   -3969, -3969, -3969, -3969, -3969, -3969,  2171, -3969,   271, -3969,
   -3969, -3969,  2054,  -182, -3969,   152,  2627, -3969,   126, -3969,
    2408,  1035,  5798, -3969, 17316,  1839, -3969,  2409,  2269, 12639,
    1486,  1486,  2412, 12339,  1629, -3969, -3969,  -280, -3969, -3969,
   -3969, -3969,  8940, -3969,  2331, -3969, -3969,  1219, -3969,  2413,
    2477, -3969, -3969,  1486, -3969,  2415,  2308,  1486,  1486, -3969,
    1862,  1971,  2233, -3969, -3969,  2030,  1870, -3969,  1871, -3969,
   -3969, -3969,  2537, -3969,  2001,  5724,  1486,  1486,  2065, -3969,
    2065,  1635,  1635,  2065,  1635,  1635,  1486,  1635,  1635, -3969,
    1897, -3969,   997, -3969, -3969, -3969, -3969,  2361, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1004, -3969,   112, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,    61, -3969, -3969, -3969, -3969,
   -3969, -3969,  1781,   -44, -3969, -3969,   134, -3969, -3969,  2019,
   -3969, -3969, 14999,   216, -3969, -3969,  1661, -3969, 14999, -3969,
   -3969, -3969,  1175,  1885, 16444,    33,  1486, -3969,  2532,  4089,
      16,  1888, 17316, 17316, 16065, -3969, -3969,  1791,  1792, 17316,
   17316, 17316,  9925,  1794,  1894,  9925, -3969, -3969, -3969, 12763,
    2356, -3969, -3969,  1715, -3969, 17316, -3969,  9925, 17316, -3969,
   -3969,  -353, -3969,  2315, 17316, 17316, 17316, 17316, 17316, -3969,
    1715, -3969, -3969,  2254, -3969,  2099,  2258, -3969, -3969,  8040,
   -3969,  1486,  1329, -3969, -3969, -3969,    -5,   -11,  1486, -3969,
   -3969, -3969, -3969, -3969, 17316,  2226, -3969,  1839, -3969, 17316,
    1635, -3969, -3969, -3969, -3969,  2040, -3969, -3969, -3969, -3969,
   -3969, -3969,  -122,  1712, -3969,  1813, -3969, 12639, -3969, -3969,
   -3969, -3969, -3969,  2184,  2432, -3969, -3969, 11508,   215,  6685,
   -3969,   929,  1859,  1818,    94,    94,    94,    94, -3969, -3969,
   12639, 12763, -3969,  1622, -3969, -3969,  1295, -3969, -3969,  1824,
   -3969,   -33, -3969, -3969,   625, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, 11880, -3969, -3969, -3969,  1949, -3969, -3969,
   -3969, -3969, -3969,  2277,   -54, -3969,  2498,  1722,  2419, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,   -67, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2065, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   -67,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, 11030, -3969,   -67,   -67,
     -67,  1036, -3969,  1460,   169, -3969, -3969,  2074, -3969, -3969,
    2485,  2397,  2485,  2333,   149, 17316, -3969, -3969,   -97,  7543,
   -3969, -3969,   159, 14269,  1036, -3969, -3969,  1924,   271, -3969,
   -3969, 12763, -3969, -3969, -3969, -3969, -3969,  2007,  2003, -3969,
    1421, -3969,  2376,  2376,   858,  1934,  1955,  1930, -3969,   609,
   -3969, -3969,  1945, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    1967, -3969, -3969, -3969, -3969,  2347,  2509, -3969, -3969, -3969,
    2348, -3969, -3969, -3969,  2040,  2515, -3969, -3969,  1486,  2515,
    1486,  1846,   155,  1941, -3969, -3969,  1715, -3969,  1944, -3969,
   -3969,   516,  1946,  1528, -3969, -3969, 11137, -3969,  2677,   705,
     165, -3969, -3969, -3969,  1661, -3969,   708, 12639, -3969, -3969,
      66,    96,  1319, 17316, -3969, -3969, -3969,  1486, 12639, -3969,
    2560,  2417,  2418, -3969, -3969, 12763, -3969, -3969, -3969, -3969,
    9925, -3969, -3969, -3969, -3969, -3969,  2682,  2362, -3969, -3969,
   -3969,   443,  2499,  2422,  2499,   -25,   769, -3969,  1951,  2056,
    2109,  1892,    87, -3969, -3969, -3969, 15331,    87,  2617,  1661,
    1376,  1376,  1661,    40,  1889,  1661,  2747, -3969,  2222, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   108,
    1556,  1960, -3969,  5766,  1486, -3969,  1952,  1952,  1487,  1635,
   -3969,  1635,  1952,  1635,  1635,  1952,  1635,  1635, -3969,  2617,
    2003,  2003,  2136,  1635, -3969, -3969, -3969,  1004, -3969, -3969,
   -3969, -3969,   -23, -3969, -3969,   665, -3969, -3969, -3969, -3969,
    2338,    84,    84,  -226,  1965,  1717, -3969, -3969, -3969, -3969,
    2710, -3969, -3969, -3969,  2244, -3969, -3969, -3969, -3969,  2244,
     815, -3969,  1661, -3969, -3969, -3969, -3969, -3969,  1661, -3969,
   -3969,  1661, -3969,  1661, -3969, -3969, -3969, -3969, -3969,   109,
   -3969, -3969, -3969,    73, -3969, -3969, -3969, -3969, -3969, -3969,
       8, -3969, -3969, -3969,  2786, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  2383,  2061,   819, -3969,  2673,  1282, -3969, -3969,
   -3969, -3969, -3969,  1717, -3969, -3969, -3969,  1886,  1891, -3969,
    9925,  1717,  2401,  2048,  2049,  2264, -3969, -3969, -3969, -3969,
   -3969,  2321, -3969, -3969, -3969, -3969, -3969,  2003,  2003, -3969,
     864, -3969,  1486,   240,  1365,  2006,   369,  2008, -3969,   372,
    -224,  9925, -3969, -3969,   389,  2010,  2011,  2013,   374, -3969,
    1715, -3969,  2014, -3969,  1486,   398,  2015,  2003,  2464,   904,
   -3969,   -84,   316,   271,  1426,  2018,   406, -3969,  2021,  2254,
    1044,  1044, -3969, -3969, -3969,  2065,  2155,  2023,   226, -3969,
   -3969,   -58,  2797,   706, -3969, -3969,  2154,  2181, -3969,  1144,
    1661, -3969, -3969,  1275, -3969,  1819,   989, -3969, -3969, -3969,
    2420, -3969, -3969, 12639, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,   202, -3969, -3969,  4334, -3969, -3969,  5377,   -97, -3969,
   -3969, -3969, -3969,   867, -3969,  1661, -3969,   121,   -97, -3969,
   -3969, -3969, -3969,   125,  1661, -3969, -3969, -3969,  6685, -3969,
   -3969,   929, -3969, -3969,  1715,  1486, -3969, -3969, -3969, -3969,
   -3969, -3969,  2486,   904,  2488,  2387,  1961, -3969,  4670,  2275,
   -3969, -3969, -3969, -3969, -3969, -3969,  1920,  1949, -3969, -3969,
   -3969, -3969, -3969,  1723, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  1740, -3969,  1195, -3969,  1952, -3969, -3969, -3969,
    2601, -3969,  1723, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    2191,  1723, -3969, -3969, -3969,  1486, -3969, -3969,  1486, -3969,
    1486,  1486,  1486, -3969,  2039, -3969, -3969,  1715, -3969,  2772,
   -3969, -3969, -3969,   681, -3969,  1460,  8859, -3969, -3969, -3969,
    1486, -3969,  1486,   143,   331,  2629, -3969, -3969,   892, -3969,
   -3969, -3969, -3969, 12639, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,   271,   271,   904,
    2503,  1846,  2040,  1955,  2468, 13771,    29,  5528,  1486,   226,
    2042, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   443,
    2348,  1486, -3969, -3969, -3969, -3969,  1486,   110,   658, -3969,
    1953, -3969,  1954, -3969,   443,     7,  9925,  2305,  1355,   291,
   -3969,   864,  2309, -3969, -3969, -3969, 12639,  1528,  1528,  1528,
    1528,  1528,  1528,  1528,  1528,   705, -3969,   856,   989,  -101,
   -3969,  2101,  2101, -3969, -3969, -3969, 17316, 16680,  1319,   714,
   -3969,  2682, -3969,  1486,  1486,   904,  2516,  2065,  2058, -3969,
    2855,  1486,   644, -3969, -3969,  2040,  2863, -3969, -3969,  1486,
   -3969,  2199,  2640, -3969, -3969, -3969,  2060,  2172,  2182,  1188,
   -3969,  1994, -3969,  2534,  1486,    31, -3969, -3969,   651,   668,
     994,  1063,  1088, -3969,  1981, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,  4159, -3969,  2203,  1486, -3969,  1017, -3969,  2434, -3969,
   -3969,  1486,  2857,  2487, -3969, -3969, -3969,   -91,  1723, -3969,
   -3969, -3969,  1661, -3969, -3969, 15712, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    1214,  -103,  1325,  2540, -3969,  2065,  1651,  1188,  1188,  1984,
    -201,   894,  2065,  2005,  1661, -3969, -3969, -3969,   -53,   585,
   -3969, -3969, -3969, -3969,  1889,  2401,  1967,  1723, -3969, -3969,
   -3969,  2174,  2401,  1661,  2792,   282,  -105,   957,  1846, -3969,
   -3969, -3969,  1661,  1661, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  2137, -3969,  2443, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2188,  2851,
    1188, -3969,  1635,  1635, -3969, -3969,  1952, -3969,  1635,  1635,
    1635,   669,  1635, -3969,  1635,  1004, -3969,  1781,  1661,  1661,
    1996, -3969,   106, -3969,  -339,  -288,   270, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  1685,  1486,  1119, -3969, -3969,
   -3969,   216,   216, -3969, -3969, -3969, -3969,   216,   216,   815,
     216, -3969, -3969, -3969,  1661,   892, -3969,   892, -3969,   815,
    2468,  1661,  2094,   711,  2461,  2461, -3969, -3969, -3969,  1717,
   -3969, -3969, -3969, -3969, -3969, -3969,   168, -3969,  1635,  1635,
   -3969, -3969, -3969,  1910, 16742,  1762, 16886,  1762, -3969,  2103,
   -3969, -3969,  1486,  1762,  1762,  1762,  9925, -3969,  1910,  -102,
    1762,    16, -3969, -3969, -3969,  2378,  2176,   -64,  2568,   904,
   17120,  1762,  1762,  1189, -3969,  2155, -3969,   271, -3969, -3969,
   -3969,  2376, -3969, -3969, -3969, -3969, -3969,  2410, -3969, -3969,
   -3969,   178, -3969, -3969, 17316, -3969, -3969, -3969, -3969,  2386,
    2518,   905,  1859,   488, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,   216, -3969, -3969,   216, -3969, -3969,
   -3969, -3969,   878,  2692,   216,   892,   892,   216, -3969, -3969,
   -3969,  1883,  1883,   271, -3969,   271, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  2908, -3969,  2127,     9,  4670, -3969,
   -3969, -3969,  2654, -3969, -3969, -3969,  1486, -3969, -3969, -3969,
    2701,  2050,  1079,   262,  2051, -3969, -3969, -3969, -3969, -3969,
    1189,  9925, -3969, -3969,  2859, -3969,  1868, -3969, -3969,  8859,
   -3969,  1868,  2606,  2607,  2769,   -30, -3969, -3969,  2218, -3969,
   -3969,  2401,     3, -3969, -3969, -3969, 12639,   271, -3969,   271,
     227,  1635, -3969,  1486, -3969, -3969,   153, -3969, -3969, -3969,
    2933, -3969,  2603, -3969, -3969, -3969,   468,   157, -3969, -3969,
   -3969, -3969,  2411,  2711,   989, -3969,    -3, -3969, -3969,  6752,
   -3969,  1954,  2290, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, 12639, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,   -65, -3969,  1486, -3969,
   -3969, -3969,  1061, -3969, -3969, -3969, 17316, -3969, 12639, 12639,
    1365, -3969,  1284,   909,  2363, 12583,  1910,  1910, -3969,   271,
    2133, -3969,  1189, -3969,  2388, -3969,  9925, -3969,  2753,  2163,
   -3969,   658, -3969,  -175,  2769,  2458,  2071,  9925,  2866,   769,
   -3969,  2142,  2251, -3969,  3224,  1661, -3969,  2159, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  2041,  4125, -3969, -3969,  2140, -3969,  2883,  2121,
    2161,   220, -3969, -3969, -3969,  1486, -3969, -3969, -3969, -3969,
    2066,  4381, -3969,  2937, -3969,  2682, -3969,  2207,  2257,  2257,
    2070, -3969,  3224, -3969,  2169,  2648, -3969, -3969, -3969,  1984,
   -3969, -3969, -3969, -3969, -3969, -3969,  2535,    70,  2468,   497,
    1661, -3969, -3969,  1661, -3969,  1661,  1661,  2401,   196, -3969,
    1661,  1637,  1661,  1661,  1661,  1661, -3969,  1728, -3969,   227,
     894,  2065,  1661,  1889,  2431, -3969,  2262,   894,  1635,  1635,
    1635,  1635,  1635,  1635, -3969,  2400, -3969, -3969,  2961, -3969,
   -3969, -3969, -3969, -3969, -3969,  1661,  2247,  2428, -3969, -3969,
   -3969,  2796, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,   905, -3969,  1814,
   -3969, -3969,  1486,   291, -3969, -3969,  2177, -3969, -3969, -3969,
    1661,  1191, -3969, -3969, -3969, -3969,  1101, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2649, -3969, -3969,
   -3969,  2642, -3969, -3969, -3969, -3969, -3969, -3969,  2643, -3969,
   -3969,  1359, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1622,
    2785, -3969,  1436, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,   -97,   -97,   -97,   -97, 12639, -3969,   488, -3969,  8290,
   -3969, -3969, -3969, -3969,  2003, -3969, -3969, -3969, -3969, -3969,
   -3969,    83,   216,  2530, -3969, -3969, -3969, 15135, -3969, -3969,
   -3969,   193, -3969, -3969, -3969, -3969,  5943, 15135,   904,  2343,
     904,  2346,   100,  4670, -3969, -3969, -3969, -3969, -3969,  2908,
   -3969,  1189, -3969, -3969, -3969, -3969,  1079, -3969,  2817, -3969,
   -3969,  1723, -3969,  1868, -3969, -3969,  1868,  1189,  2179,  2179,
   -3969,  2992,  2952, -3969, -3969, -3969,  2468, -3969,  2512,  2802,
    -129, -3969, -3969,  2444, -3969, -3969,   904,  2447,  2447,  2451,
   -3969,  1252, -3969,  2762, -3969, -3969, -3969,  1486, 12639,  1952,
    2554,  2600, -3969,   973, -3969, -3969, -3969,   971, -3969, -3969,
   -3969,  2835,  2504, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    2559, -3969, -3969, -3969,  2577, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1365, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,  2481,  2196,  1661, -3969, -3969, -3969,  1101,  2649,   904,
    2151, -3969, -3969,  2855, -3969,  2468,  2769,  2468,   909,  1617,
   -3969, -3969,  1820, -3969, -3969,  1846,  2414, -3969,   108, -3969,
     769, -3969,   769, -3969,  2210, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  2225, -3969,  3224, -3969,  1165,  1486,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   952,
   -3969, -3969,  2580, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2578, -3969, -3969,
    2468,  2693,  2230,  2065,  2230,  2294,  2131, -3969, -3969, -3969,
   -3969, -3969, -3969,  2589, -3969,   905,   490, -3969, -3969,  2792,
   -3969, -3969, -3969,  3224,  2065,   201,  1486, -3969, -3969, -3969,
   -3969,  2065, -3969,  1748, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,   915,   915,   931,  1486,  1661, -3969, -3969,  2117,
   -3969,  1486, -3969, -3969,   894, -3969,  1486,  1486, -3969, -3969,
   -3969, -3969,  2938,  1487,  1486,  1661,  1486,   -44, -3969,   894,
    2240,  1635, -3969,  2065, -3969,  1004,    75,  1202,   256,  1661,
   -3969, -3969,  2138,  2236, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,   291, -3969, -3969,  2669,  2858, -3969,  1961,
   -3969, -3969, -3969,  1883, 12639, 12639, 12639, 12639, -3969, -3969,
   -3969, -3969, -3969,  1486, -3969,   -97, -3969, -3969, -3969, -3969,
    2250,  -309, -3969, -3969,   271, -3969,   271,  6592, -3969,  -219,
       2, -3969, -3969,  1166, -3969, -3969, -3969, -3969, -3969, -3969,
    2982,  2868, -3969, -3969,  1868, -3969, 12639, 12639, -3969, -3969,
    1486,  2512,  2003,  2283, -3969,  2456,  1635,  1073,  1486, -3969,
   -3969, -3969, -3969, -3969, -3969,   127, -3969, -3969, -3969, -3969,
   -3969,  2555, -3969,   713, -3969, -3969,  2556,  1103, -3969, -3969,
   -3969,  2986,  2608, -3969,  1661,  1595, -3969, -3969,   832,  2610,
    2612, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1486,
   -3969,  2858, -3969, -3969, -3969,  2260, -3969,  1486, -3969,  1486,
   -3969, -3969, -3969, -3969, -3969,  2538,  2803, -3969, -3969, -3969,
   -3969,   136,   608,  2471, -3969, -3969, -3969, -3969, -3969,   179,
     623, -3969, -3969,  2003, -3969, -3969,  3224, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2272,
    2175,  2065,  2276, -3969,  2882, -3969,  2886,  1661, -3969, -3969,
   -3969, -3969,  2327, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  1486,    81,  2938,   913, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  1486, -3969, -3969, -3969, -3969,
    2749, -3969, -3969, -3969, -3969,  3083, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,   409,   835, -3969, -3969, -3969, -3969, -3969,
      64,   618, -3969, -3969, -3969,  1486,  1305,  1661, -3969,   696,
    1651,  2291,   894, -3969, -3969,  2599,  3077, -3969, -3969, -3969,
     700,   251, -3969, -3969, -3969, -3969,   291,  2669,  1101,   845,
   15135, -3969, -3969, -3969, -3969, -3969,  1486,   -97, -3969, -3969,
    1101,  1101, -3969, -3969, 12639, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, 12639, -3969, -3969, -3969, -3969, -3969,  2283,  1486,
    1486,  1121,  1661,  1635,  1635,  2489, -3969, -3969, -3969,  2541,
   -3969, -3969, -3969, -3969, -3969, -3969,  2421, -3969, -3969, -3969,
   -3969,  6375,  2243, -3969,  1486, -3969, -3969,  2411,  2711, -3969,
   -3969, -3969, -3969,  1101,   284, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  2609,   136, -3969,    76,  2192, -3969,
   -3969,  1661, -3969,  2475,   767, -3969,  2385, -3969,  2289,  1486,
   -3969, -3969, -3969, -3969,  2065,  2717,  1952,  1952,  1358,  2065,
   -3969,   894,   894, -3969, -3969, -3969, -3969,  2780, -3969, -3969,
    2169,  2065,   618,  1486,  1734, -3969, -3969, -3969, -3969,  1486,
   -3969, -3969, -3969, -3969, -3969,  1661, -3969,  2533, -3969, -3969,
   -3969,  -306,   206,  -306, -3969,  1651,  1661,  1661,  1651,   894,
   -3969,  1661,  1661, -3969, -3969,  2636, -3969,   133,  2304,   291,
   -3969,   128,   162, -3969, 12639, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1486, -3969,  1661,  1486, -3969, -3969, -3969,
   -3969, -3969,  2581,  2829,   226,  1635,  1661, -3969, -3969, -3969,
    9925, -3969, -3969, -3969, -3969,  6752, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1950, -3969, -3969,
   -3969,   213, -3969,  1737,  2510,  2932,  1661,  2512, -3969, -3969,
    9925, -3969, -3969, -3969,   226,   212,  1629, -3969, 13232, -3969,
   -3969,   767,  2312,  2314,  1661, -3969, -3969,  1358,  1486,  1486,
    2682, -3969,  2737, -3969,   331,  2401,   358, -3969, -3969, -3969,
    3092,  2938, -3969,   -28, -3969, -3969, -3969, -3969, -3969,   -28,
   -3969,  1486,  1486,  -100, -3969, -3969,  2448, -3969,  2660, -3969,
   -3969,  1651,  1651, -3969, -3969, -3969, -3969,  2404,   -22,   291,
   -3969, -3969, -3969, -3969, -3969,  2597,   119,  2003, -3969, -3969,
   -3969, -3969, -3969,  1486, -3969,  1121, -3969,   208, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,   226, -3969,  1715, -3969,
   -3969,  2478,  2389, -3969,  2317,    62,  1952,  9925,  2293, -3969,
   -3969, -3969, -3969,  -215, -3969,  2334,  2620,  2335, -3969, -3969,
     179, -3969,  1358, -3969, -3969, -3969, -3969,  1661,   331,   894,
    2946,  2533,  1015,  1661, -3969, -3969, -3969, -3969, -3969,  2590,
   -3969, -3969,    75,  1202, -3969, -3969,  1661,  2955, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,  1486, -3969, -3969, -3969,
   -3969,  1486, -3969,  1829,  1635,  2329, -3969, -3969, -3969,   141,
    2657,  2003,  2379,  1127,   515,  1514,   229, -3969, -3969,  2924,
   -3969, -3969, -3969,  1996, -3969, -3969, -3969, -3969, -3969,  1952,
   -3969,  2402, -3969,  2930,  1486,  1380,  2658,  3136,   815,  2340,
   -3969, -3969, -3969, -3969,  2549, -3969,  1635,   825,   141, -3969,
   -3969,  1661, -3969,  1486,   -78, -3969, -3969, -3969, -3969,  2619,
    2873,    44,  2745,  2748,  2962,  2730, -3969,   515, -3969,   907,
     870,  2350,    91, 16109,   892, -3969, -3969, -3969,  1996, -3969,
    1486,  2265, -3969, -3969, -3969,  1410, -3969, -3969,   556,  1661,
    1661, -3969, -3969, -3969,  1952, -3969, -3969, -3969,  2615,  1486,
   -3969,  9925,  1486, -3969,  1661,  1128,   785,   -78, -3969, -3969,
    1127, -3969, -3969, -3969, -3969, -3969, -3969,  1661,  2621,  1486,
    1661,  1661,  1661,  1661, -3969,  2754,    69,  2755, -3969,  2741,
   -3969,  1589, -3969, -3969,  1486,  3010,  1321,  2760,   113,  2761,
    2750, -3969,   693, -3969, -3969,  1486,  2403, -3969,  1188,  1188,
    1908, -3969, -3969, -3969, -3969,  2831,  3068,   -86, -3969,  1661,
   -3969, -3969, -3969, -3969,   690, -3969,  2244,  2244,  1661,   -97,
     121,  1661,  2509, -3969, -3969, -3969, -3969,  2244,   -97, -3969,
    2960,  2065, -3969,  3084, -3969, -3969,   -97, -3969, -3969,  1486,
   -3969, -3969,  1486, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  2837,  2244, -3969, -3969, -3969,  7543,
   -3969, -3969,    95,   556, -3969, -3969,  1651,  1651,   187, -3969,
   -3969, -3969, -3969,  1746, -3969, -3969, -3969,  1746,  1746, -3969,
   -3969, -3969, -3969, -3969, -3969,  2628, -3969, -3969, -3969,  1486,
    2065, -3969,  1486,  1486,  1486,  1486,  1661,  1661,  1661,  1661,
    1661, -3969,  1486,  1661,  1661,  1661,  1661,  1661,  1661,  1661,
    1661,  1661,  1661,  1661, -3969,  1486,  1661, -3969, -3969,  1188,
    1188,   663,  2756, -3969,  1661, -3969, -3969,  1486,  1486, -3969,
   -3969,   216, -3969, -3969, -3969,  1661, -3969,  1661,   216,   892,
   -3969, -3969,   216, -3969, -3969,   216,  2230,  1661,   892, -3969,
   -3969, -3969, -3969, -3969,  7543,  1597, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1635, -3969, -3969,
   -3969, -3969,   785, -3969,  2230, -3969, -3969, -3969, -3969,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486, -3969, -3969,
   -3969, -3969, -3969,  1721, -3969, -3969, -3969, 13890, -3969,   905,
    1486, -3969, -3969,   922,   922, -3969, -3969, -3969, -3969, -3969,
     485, -3969,   905, -3969, -3969, 16662, -3969, -3969,  2737, -3969,
   -3969, -3969, -3969, -3969,  1486, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,  1486, -3969,    80,   787,
     879, -3969, -3969,   663,  2405, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,   216, -3969, -3969,   216,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1486,  1486,   283,
    1661,  1661,   305,  1661, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,  1866, -3969, -3969, -3969, -3969,  1486, -3969, -3969, -3969,
    1661,   663,   663, -3969,  2825,  1661,  1661,   663, 14826,  1486,
     663, -3969, -3969, -3969,   663,   663, -3969, -3969, -3969, -3969,
    2808,  1833,  2747,  1661,  2065, -3969,  1661,  2003, -3969,   221,
    1486, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,   150, -3969, -3969,  1048, -3969,   910,
   -3969, -3969, -3969, -3969,  1833,  1486, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1188, -3969,  1573,  2276, 17538, 17538,  1745,
    2861,  2687,  2687,  2017,  6752, -3969, -3969,  1048,  -165, -3969,
   -3969, -3969,  2065,  -165, -3969,   171,  1486, -3969, -3969, -3969,
   -3969, -3969, -3969,  2065, -3969,  2230,  1910, 17391, -3969, -3969,
    1228,  1557, -3969, -3969,  1604, -3969, -3969, -3969, -3969,   935,
     935, -3969, -3969, -3969, -3969, 17538, -3969,   675,   675,  2687,
    2687, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1188,
   -3969,  1486, -3969,  2886, -3969,  1952,  1486, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,   -69,   111,  3120, -3969,
   -3969, -3969,   675, -3969, -3969,  2631,  2634, -3969, -3969,  2435,
     -49, -3969,  2650, -3969,  2650, -3969,  2650, -3969,  2650, 17538,
   -3969, -3969, -3969,  2065, -3969, -3969, -3969, -3969,  2637, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,    12,     1,     3,     5,    27,     4,    53,    31,
      30,    27,     8,    10,    11,     0,    28,     0,     0,    13,
      76,     9,    35,    32,    53,    53,     0,    56,     0,    24,
      79,     0,     0,    16,     0,    29,  3029,    54,    62,     0,
     430,     0,   245,    81,     0,     0,    20,    14,    17,    18,
      22,    15,  3030,     0,     0,    64,    77,     0,    25,   433,
     431,     0,     0,    75,   247,     0,     0,     0,  3096,  3029,
    3029,  3029,     0,     0,     0,     0,  3029,     0,     0,  2989,
     242,   159,    78,    82,    83,    85,    86,    89,    87,    88,
       0,   142,   145,   146,   147,   208,   148,   150,   149,   151,
     152,   153,   154,   155,   156,   157,   158,    38,    37,    41,
      41,     0,    19,     0,    58,    59,    60,    61,    57,  3060,
    3029,    69,     0,  1336,     0,   435,    80,     0,     0,   249,
    2661,  2660,   170,   227,  3029,  3097,  3029,     0,     0,     0,
    3029,  3029,    96,   126,     0,    90,   140,  2990,     0,     0,
    3029,  3029,    84,   144,   141,   143,     0,   207,     0,     0,
      33,    40,    39,     0,     0,  3061,  3029,     0,     0,     0,
     432,     0,    26,  1331,  1384,     0,   428,   246,   248,   387,
     176,  3010,  3029,     0,     0,     0,  2767,   238,  2649,   236,
     241,     0,     0,    98,   128,   240,    92,   574,   218,   219,
    3029,  2662,   210,   211,  3034,   214,     0,  2776,  2204,  2203,
     160,   164,   167,  3075,  3029,     0,   209,    42,    36,  3029,
      21,    23,     0,    66,    68,    67,    65,  3029,    55,  1332,
       0,     0,   434,   441,   442,   555,   436,   558,     0,     0,
    2864,   250,   244,   390,   171,   172,   174,     0,     0,   228,
     229,   239,   234,  3148,  3149,     0,   232,     0,  2988,  3103,
    3086,  3029,   124,    97,  3085,   102,   104,   105,   106,   107,
    3085,     0,  2991,     0,     0,   127,     0,   131,    91,    94,
     220,     0,   212,  3036,  3035,   215,     0,   243,  3075,  3078,
    3077,     0,     0,   161,   165,     0,     0,  2871,  2872,  2873,
    2874,  2875,  2876,  2877,  2878,    63,     0,  1601,     0,  1453,
    1566,  1576,  1584,  1591,  1647,  1653,  1673,  1668,  1674,  1683,
    1679,  1691,  1701,  1832,  1841,  1843,  1849,  1882,  1894,  1905,
    1908,  1911,  1903,  1918,  1929,  1951,  1955,  1959,     0,  2015,
    2017,  2023,  2027,     0,  2033,  2067,  2094,  2096,  2101,  2131,
    2132,  2148,  2151,  2152,  2157,  2166,  2167,  2180,  2193,  2232,
    2250,     0,  2287,  2303,  2312,  2314,  1366,  2318,  2321,  2324,
    2341,  2380,     0,  1386,  1387,  1388,  1389,  1390,  1391,  1392,
    1393,  1395,  1394,  1396,  1398,  1397,  1399,  1400,  1401,  1402,
    1403,  1404,  1405,  1406,  1407,  1408,  1409,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,  1417,  1418,  1419,  1420,  1421,  1422,
    1423,  1424,  1425,  1426,  1427,  1428,  1429,  1430,  1431,  1432,
    1433,  1434,  1435,  1436,  1437,  1438,  1439,  1440,  1441,  1442,
    1443,  1444,  1445,  1446,  1447,  1448,  1449,  1450,  1385,     0,
     502,   437,  2847,     0,  2631,   438,   389,     0,  2865,     0,
       0,   417,  3070,   400,   388,     0,   393,   395,   396,   408,
     397,   398,  3029,  3029,   177,   178,  2785,  2781,  2786,  2784,
    2782,  2787,  2783,   230,   223,   225,  3128,   233,     0,  2768,
     237,  3104,  3029,     0,   101,   103,    99,   125,  3085,  3029,
    2992,   109,     0,     0,   138,    41,     0,    41,     0,   129,
     132,     0,     0,     0,  2796,  2792,  2797,  2795,  2793,  2798,
    2794,   221,  2788,  2790,  2777,   213,   216,     0,  3076,   168,
     162,   163,   166,    34,    45,    48,    52,    51,  3085,    46,
      47,    71,    72,    73,    74,    70,  1605,  1608,  1607,  1603,
    1604,  1606,  1595,  1602,  2889,  2890,  2891,  2892,  2893,  2894,
    2895,  2896,  2897,  2898,  2899,  2900,  2901,  2887,  2941,  2942,
    2943,  2944,  2945,  2946,  2947,  2948,  2949,  2950,  2951,  2952,
    2953,  2954,  2955,  2956,  2957,  2958,  2959,  2960,  2961,  2962,
    2963,  2902,  2903,  2905,  2904,  2906,  2907,  2908,  2909,  2910,
    2911,  2912,  2914,  2913,  2915,  2916,  2917,  2918,  2919,  2920,
    2921,  2922,  2923,  2924,  2925,  2926,  2927,  2928,  2929,  2930,
    2931,  2932,  2933,  2934,  2935,  2885,  2936,  2937,  2938,  2939,
    2940,  1452,  2886,  2888,  1484,     0,     0,     0,  1601,     0,
       0,     0,  1676,     0,     0,  1696,  1744,     0,  1696,     0,
    1601,  2553,  1886,  1896,     0,     0,  3119,  1632,  1631,     0,
    1917,     0,     0,     0,     0,     0,  1998,  2010,     0,     0,
       0,     0,  1451,  2038,  2540,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2283,  2286,  2270,
    2284,  2545,  2285,  2272,  2281,  2273,  2282,  2753,  2757,  2290,
       0,  2313,  2311,     0,  1384,     0,     0,     0,     0,     0,
    2396,  2442,     0,     0,   805,     0,     0,     0,   560,     0,
       0,   564,   565,   563,     0,   440,   443,  2866,   251,  3070,
    3119,  3119,  3068,  3070,  3070,  3119,  3070,  3070,  3119,  3070,
    3070,  3007,  3071,  3005,     0,   401,   402,   403,  2970,     0,
     391,   394,     0,     0,     0,   224,   222,     0,     0,     0,
     118,   100,  2769,   110,   133,   134,   137,   139,   135,   136,
     130,    93,     0,  2789,     0,   217,   169,    50,    44,    49,
    1596,  1338,  1483,  2767,  1564,  1455,  1496,     0,  3058,  1482,
    3068,  2823,  2821,  2824,     0,  2817,  2825,     0,     0,  2831,
    3165,  3166,     0,  2614,  2616,     0,     0,     0,  2820,  2686,
       0,  2618,  2822,  2826,  2827,     0,     0,  2819,  2831,  2818,
    1574,  2678,  1572,  2670,  2673,     0,  2672,  2676,  2677,  2828,
       0,     0,  2687,     0,     0,     0,  1577,     0,  2603,  2606,
    2608,  2611,  2696,     0,  2613,  2853,  2694,  2695,  2646,  1585,
    1586,     0,  2642,  2644,  2643,  1645,  2540,  2725,  1652,  1648,
    1649,  1651,  2724,  1664,  1654,  1655,  1656,  1659,  3068,  1671,
    2761,     0,  2620,  2867,  2665,  2760,  2765,  2666,  1677,  1675,
       0,  1689,  3089,  2995,  1680,  2758,  1682,  3113,     0,  1698,
    1700,  1692,     0,  1741,  1775,  1774,  2792,  2983,  1721,  1773,
    1766,  1772,  1765,  1830,  2467,  2668,  1716,  1718,  1708,  1709,
    1722,     0,  1710,  1711,  1762,  1712,  1713,  1775,  1715,     0,
    2672,  1839,     0,  1842,     0,     0,  1844,  1856,  1855,  1880,
       0,  1852,  1854,  2552,  3029,  1887,  1883,  1888,  1898,  1902,
    1900,  1903,  1901,  1895,  1906,  1907,  2663,  1909,  1910,  3120,
    1912,  2640,  1904,  2551,  1923,  2550,  1930,  1932,  2633,  1952,
    1953,  1027,  1781,     0,     0,  1956,  1026,  1960,     0,  1962,
    1963,  1964,     0,     0,  2016,  2236,  2745,  2746,  2862,     0,
    2021,     0,  2024,     0,  2031,     0,  2039,  2034,  2035,     0,
    3014,  2068,  2080,     0,  2632,  2095,     0,  2097,  2099,  2129,
    2859,  2146,     0,  2149,  2383,  2623,  2155,  3089,     0,  2164,
    2624,  2383,     0,  2178,  2171,  2626,  2181,  2184,     0,     0,
    2636,  2194,  2195,  2196,  2197,  2198,  2199,  2223,  2200,  2226,
    2201,  2202,     0,     0,  2634,     0,     0,  2744,  2765,  2233,
    2268,  2255,  2274,  2544,     0,  2755,  2756,  2301,     0,     0,
       0,     0,  2309,     0,  2315,  2316,  1372,  1378,  1367,  1368,
    1369,  1371,     0,  2319,     0,  2748,  2322,  3091,  2727,  2339,
    2327,  2726,  2728,  2342,  2343,  2394,  2383,     0,     0,   556,
       0,     0,   808,   607,   610,     0,     0,   561,     0,   571,
     572,   566,   573,   569,  3029,     0,     0,     0,     0,  3069,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3008,
    3111,  3006,     0,   307,   425,   308,  2971,  3009,   392,   183,
     182,   203,   199,  2769,   204,   188,   202,   200,   180,   181,
     201,   173,   179,   190,   191,   193,   185,   186,   187,   175,
     184,   331,   231,   226,   235,     0,   121,   123,   122,   119,
     120,  2654,     0,  3009,    95,  2791,     0,  1341,  1339,  1360,
    1565,  1454,  1496,  2978,  2980,  1501,  3029,  1480,  1497,  1498,
    1500,  1502,     0,     0,  2997,     0,     0,  3059,     0,     0,
       0,     0,     0,     0,     0,  2815,  2837,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2816,  1575,  1567,     0,
       0,  2671,  2679,  2680,  2681,     0,  2803,     0,     0,  2610,
    2693,     0,  2609,  2855,     0,     0,     0,     0,     0,  2697,
    2698,  2699,  2854,  1580,  1587,  1589,     0,  1646,  1592,  1611,
    1650,     0,  1659,  3161,  3162,  1657,     0,  1660,     0,  1672,
    1669,  3143,  3142,  2621,     0,  2869,  2622,  2763,  2764,     0,
    1686,  1687,  1690,  1684,  3090,  2114,  2996,  1681,  2759,  3114,
    1697,  1699,  1694,  1722,  1776,     0,  2984,     0,  1831,  1702,
    1381,  1381,  1707,  2473,  2470,  1717,  1714,  2669,  3127,     0,
    1743,     0,  1777,     0,  2467,  2467,  2467,  2467,  1840,  1833,
       0,     0,  1845,  1595,  1881,  1850,  2553,  1867,  1851,  1858,
    1859,  1381,  2569,  2567,  3030,  2573,  2570,  2562,  2566,  2564,
    2565,  2561,  2563,  2554,  2555,  2568,  2557,     0,  1889,  1884,
    1899,  1897,  2664,     0,  1915,  1924,  1925,  1934,     0,  1954,
    1780,  1107,  1136,  1104,  1186,  1121,  1120,  1185,  1187,  1209,
    1188,  1172,  1255,  1289,  1205,  1234,  1208,  1231,  1277,  1180,
    1203,  1199,  1206,  1229,  1275,  1106,  1109,  1216,  1213,  1105,
    1212,  1211,  1261,  1133,  1215,  1134,  1290,  1138,  1198,  1227,
    1224,  1251,  1242,  1279,  1078,  1252,  1262,  1225,  1160,  1162,
    1161,  1228,  1263,  1264,  1265,  1266,  1124,  1125,  1254,  1217,
    1219,  1218,  1223,  1158,  1239,  1132,  1241,  1248,  1249,  1140,
    1142,  1253,  1145,  1084,  1237,  3015,  1183,  1159,  1131,  1101,
    1260,  1100,  1103,  1102,  1258,  1250,  1226,  1210,  1271,  1246,
    1247,  1182,  1268,  1269,  1270,  1259,  1274,     0,  1135,  1236,
    1232,  1235,  1267,  1222,  1233,  1141,  1174,  1204,  1200,  1196,
    1207,  1230,  1272,  1273,  1240,  1143,  1144,  1108,  1276,  1137,
    1181,  1139,  1220,  1221,  1257,  1173,  1175,  1077,  1146,  1163,
    1184,  1256,  1288,  1214,  1197,  1238,  1179,  1202,  1201,  3015,
    1037,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,  1060,
    1061,  1062,  1063,  1064,  1065,  1066,  1957,  1294,  3015,  3015,
    3015,  1958,  1298,     0,  1985,  1969,  1961,  1966,  1967,  1968,
    2008,     0,  2008,     0,  2240,     0,  2747,  2863,  3031,  2019,
    1030,  1032,  3037,     0,  2020,  2022,  2018,     0,     0,  2032,
    2028,     0,  2036,  2043,  2040,  2042,  2041,  2044,  3068,  2082,
    2646,  2730,  2542,  2542,     0,  2078,     0,     0,  2729,  2643,
     577,  2731,     0,  2541,  2100,  2098,  2130,  2102,  2860,  2861,
    3089,  2147,  2133,  2135,  2136,     0,     0,  2150,  2156,  2153,
    2104,  2625,  2165,  2158,  2114,  2173,  2179,  2168,     0,  2173,
       0,  3127,  2182,     0,  2713,  2719,  2720,  2721,     0,  2224,
    2227,     0,     0,     0,  2635,  2206,     0,  2205,     0,     0,
    2763,  2269,  2251,  2257,  3029,  2258,  2253,     0,  2271,  2276,
       0,  2598,  2596,     0,  2754,  2302,  2288,     0,  2291,  2292,
    2295,     0,     0,  2310,  2304,     0,  2317,  1373,  1377,  1370,
       0,  3092,  3093,  2323,  2340,  2325,  2985,     0,  2344,  2395,
    2381,  2385,  2440,     0,  2440,  2446,   558,   503,     0,     0,
     811,     0,   666,  2847,   562,   568,  3029,   575,  2993,  3029,
       0,     0,  3029,  2993,  3060,  3029,  2968,   439,     0,   444,
     447,   448,   449,   450,   451,   452,   453,   454,   455,     0,
       0,     0,   252,  3089,   404,  2647,  3070,  3070,     0,   412,
    2627,   405,  3070,   406,   414,  3070,   407,   416,  3112,  2993,
    3068,  3068,     0,     0,   189,   192,   195,     0,  3156,  3158,
    3157,   108,  2771,  2770,   111,     0,  2769,  1599,  1600,  1598,
       0,  1346,  1346,     0,     0,  2454,  2734,  1513,  2732,  2733,
       0,  1499,  3139,  3138,  3064,  3141,  3140,  1511,  1512,  3064,
       0,  1517,  3029,  1531,  1532,  1533,  1519,  1521,  3029,  2998,
    1522,  3029,  1563,  3029,  1524,  1527,  1525,  1526,  1528,     0,
    1557,  1558,  1535,  1537,  3088,  1538,  1561,  1559,  1560,  1529,
    3121,  1540,  1530,  1518,  2966,  1542,  1562,  1545,  1503,  1534,
    1539,  1544,     0,     0,     0,  2706,     0,  1491,  1495,  1494,
    1485,  1481,  1476,  2454,  3135,  3134,  1473,  1464,  1466,  1467,
       0,  2454,  3044,     0,     0,     0,  1509,  1457,  1462,  1461,
    1471,     0,  1479,  1459,  1478,  1460,  2710,  3068,  3068,  2709,
       0,  2683,     0,  2598,  2596,     0,  2598,     0,  2833,  2598,
       0,     0,  2615,  2617,  2598,     0,     0,     0,  2598,  2690,
    2691,  2692,     0,  2619,     0,  2598,     0,  3068,  2761,  2494,
    1573,  2765,  2666,     0,     0,     0,  2598,  2612,  2857,  1580,
    2602,  2601,  2605,  2604,  2607,     0,  1582,     0,     0,  2645,
    1593,     0,  1609,  1666,  1658,  1663,     0,     0,  2667,  2494,
    3029,  2868,  2762,     0,  1688,  3009,  2530,  2115,  2116,  1693,
       0,  1742,  1767,  1751,  2472,  1382,  2475,  2468,  2474,  2469,
    2471,     0,  1731,  1730,  1719,  1726,  1728,     0,  3031,  1818,
    1819,  1820,  1807,     0,  1810,  3029,  1811,  3001,  3031,  1814,
    1815,  1821,  1816,  3121,  3029,  1817,  1824,  1822,  1723,  1724,
    1750,  1745,  1746,  1748,  1749,     0,  1763,  1770,  1705,  1706,
    1703,  1704,     0,  2494,     0,     0,  1615,  1853,     0,  1867,
    1860,  1857,  1862,  1863,  1869,  1861,     0,  2572,  2556,  2583,
    2584,  2585,  2574,  3119,  2591,  2594,  2593,  2595,  2587,  2580,
    2582,  2581,  2586,  2588,  2590,  2592,  2558,  2575,  2576,  2577,
    2578,  2579,  1486,  2639,  1915,  2637,  3070,  1913,  2641,  1926,
    1927,  1381,  3119,  1942,  1943,  1945,  1947,  1948,  1944,  1946,
    1937,  3119,  1933,  3016,  3017,     0,  1036,  1293,     0,  1295,
       0,     0,     0,  1299,     0,  2766,  2715,  2716,  1986,     0,
    1988,  1987,  1989,  1971,  1981,     0,     0,  1965,  2009,  1999,
       0,  2011,     0,  2242,     0,     0,  3032,  3033,     0,  1031,
    3039,  3038,  3040,     0,  1072,  1195,  1156,  1099,  1115,  1166,
    1085,  1189,  1164,  1113,  1081,  1194,  1281,  1191,  1177,  1110,
    1178,  1176,  1147,  1149,  1152,  1111,  1165,  1119,  1168,  1117,
    1157,  1154,  1070,  1169,  1190,  1079,  1123,  1244,  1282,  1093,
    1151,  1087,  1094,  1114,  1086,  1170,  1284,  1171,  1082,  1130,
    1285,  1069,  1076,  1096,  1127,  1128,  1097,  1112,  1073,  1074,
    1129,  1067,  1150,  1095,  1080,  1286,  1153,  1192,  1075,  1280,
    1243,  1287,  1245,  1098,  1116,  1148,  1068,  1193,  1283,  1083,
    1118,  1126,  1092,  1278,  1090,  1091,  1167,  1155,  1088,  1089,
    1122,  1071,  1035,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,     0,  2025,  2494,
       0,  3127,  2114,     0,  3013,  2080,  2070,     0,     0,     0,
       0,   586,   582,   585,   584,   583,   588,   737,   599,   595,
     597,   598,   600,   596,   601,   738,   589,  2707,   602,   603,
     578,   591,   592,   593,   587,   590,   581,   580,  2081,     0,
    2104,     0,  2384,  2741,  2742,  2743,     0,     0,  2160,  1381,
       0,  2172,     0,  2186,  2385,     0,     0,     0,     0,     0,
    2225,     0,     0,  2229,  2228,  2220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2208,  2209,  2862,  2530,     0,
    2275,  3107,  3107,  2599,  2600,  2773,     0,     0,     0,  2299,
    2293,  2985,  2294,     0,     0,  2494,     0,  1379,     0,  2986,
    2848,     0,  2299,  2390,  2389,  2114,  2964,  2441,  2397,     0,
    2443,  2448,     0,   557,   505,   806,     0,     0,   941,  3034,
     608,     0,   667,     0,     0,     0,   792,   687,  3098,  3098,
    3098,  3098,  3098,   688,  3123,   689,   690,   691,   693,   694,
     695,   696,   698,   697,   700,   733,   731,   732,   734,   735,
     699,   705,   701,  3094,     0,   736,   760,   702,   677,   703,
     704,     0,  2975,  3101,   716,   717,   715,   788,  3119,   719,
     720,   718,  3029,   675,   567,  3029,   631,   633,   636,   634,
     635,   637,   639,   638,   653,   640,   642,   641,   683,   692,
     643,   644,   645,   646,   647,   648,   649,   650,   651,   652,
       0,     0,  2975,     0,  2994,     0,     0,  3034,  3034,     0,
       0,     0,     0,     0,  3029,   498,  2969,   499,     0,     0,
     500,   445,   446,   254,  3060,  3044,  3089,  3119,  3146,  3147,
     352,     0,  3044,  3029,  2987,  3044,   354,     0,  3127,   335,
     253,   334,  3029,  3029,   256,   257,   262,   267,   264,   321,
     265,   268,     0,   269,     0,   259,   351,   260,   261,   266,
     263,   258,   270,   271,   272,   273,   274,   275,     0,  2981,
    3034,  2648,     0,     0,  3167,  3168,  3070,  2628,     0,     0,
       0,     0,     0,   426,   399,     0,   194,     0,  3029,  3029,
     112,  1597,  1346,  1343,  1349,     0,  1346,  1361,  1362,  1333,
    2460,  2461,  2465,  2466,  1456,  2462,  1553,  2457,  1381,  1516,
    3065,     0,     0,  2778,  1504,  2735,  2736,     0,     0,     0,
       0,  1520,  1556,  1543,  3029,  2546,  3122,  2546,  2967,     0,
    3013,  3029,     0,     0,     0,     0,  1477,  1463,  1465,  2454,
    1474,  3045,  1468,  1469,  1470,  1510,  2977,  1472,     0,     0,
    2712,  2682,  2711,  2867,     0,  2828,     0,  2828,  2832,     0,
    2807,  2838,     0,  2828,  2828,  2828,     0,  2809,  2867,     0,
    2828,     0,  1381,  1381,  1568,  2500,  2497,  2763,  2764,  2494,
       0,  2828,  2828,     0,  2856,  1582,  1581,     0,  1578,  1590,
    1588,  2542,  1613,  1614,  1610,  1612,  1665,     0,  1662,  1661,
    1670,     0,  1678,  2119,     0,  1381,  1381,  1685,  2531,  2537,
    2534,     0,  1777,  1753,  1384,  1739,  1740,  1737,  1736,  1738,
    1735,  1727,  1729,  1732,     0,  1808,  1809,     0,  1303,  1305,
    1812,  1813,     0,     0,     0,  2546,  2546,     0,  1725,  1747,
    1778,  3127,  3127,     0,  1834,     0,  1848,  1846,  1616,  1847,
    1877,  1874,  1876,  1875,  1868,  1871,  1878,  1381,     0,  2560,
    2559,  2589,  3003,  1487,  1914,  2638,     0,  1381,  1928,  1919,
    1922,     0,     0,  1949,     0,  1297,  1296,  1302,  1301,  1300,
       0,     0,  1982,  1984,     0,  1977,  1991,  1978,  1979,  1970,
    1973,  1991,     0,  2719,  2548,  2013,  2243,  2234,     0,   778,
     779,  3044,  3018,  1034,  1292,  1291,  1033,  2026,  2029,     0,
       0,     0,   579,     0,  2069,  1381,     0,  2087,  2083,  2088,
    2084,  2089,     0,  2079,   594,  2086,  2106,  2137,  2105,  1381,
    1381,  2154,  2519,     0,  2530,  2161,     0,  2174,  2553,     0,
    2169,  2175,  2191,  2190,  2189,  2188,  2187,  2207,  2230,  2738,
    2231,  2737,  2739,  2740,  2219,     0,  2222,  2211,  2212,  2213,
    2217,  2214,  2218,  2215,  2216,  2210,  2863,  2267,     0,  2264,
    2265,  2259,     0,  2252,  3164,  3163,     0,  3108,  2279,  2279,
    2597,  2774,     0,  2503,     0,     0,  2867,  2867,  2305,     0,
       0,  1380,     0,  2849,  2328,  2329,     0,  2332,  2335,  2337,
    2333,  2160,  2965,     0,  2548,     0,  2450,     0,   504,   558,
     809,     0,     0,   429,     0,  3029,   668,   605,   801,   802,
    3099,   730,   729,   722,   721,   728,   727,   726,   725,   724,
     723,  3124,     0,     0,  3095,   786,   656,  2751,   764,     0,
     756,   679,   676,   654,  2976,     0,  3102,   789,   790,   787,
       0,     0,   632,   664,   803,  2985,   669,   661,  2879,  2879,
       0,   609,     0,   576,   467,   495,  3159,  3160,  2657,   476,
    2655,  3151,  3150,   469,  2659,  2658,  3054,  2989,  3013,     0,
    3029,   473,   472,  3029,   501,  3029,  3029,  3044,   303,   355,
    3029,  3089,  3029,  3029,  3029,  3029,   374,  2972,   375,     0,
       0,     0,  3029,  3060,   322,  2982,     0,     0,   409,   410,
       0,   413,   415,   418,   419,   422,   427,   424,   196,   197,
    2772,  2769,  2769,   113,  1344,  3029,     0,  1358,  1354,  1347,
    1348,  1363,  2455,  2463,  1381,  1554,  1555,  2749,  2456,  2458,
    2464,  1514,  1515,  1548,  1546,  1523,  1547,     0,  1550,     0,
    1549,  1551,     0,     0,  1490,  1489,     0,  1493,  1492,  1475,
    3029,  1458,  1505,  1507,  2684,  2685,  2494,  2844,  2813,  2846,
    2814,  2808,  2842,  2810,  2811,  2812,  2840,  2881,  2835,  2836,
    2806,  2667,  2502,  2499,  2495,  2501,  2496,  2498,  2762,  1569,
    2829,     0,  2804,  2805,  2858,  2722,  2723,  1579,  1583,  1595,
       0,  2870,     0,  2536,  2539,  2532,  2538,  2533,  2535,  1695,
    1768,  3031,  3031,  3031,  3031,     0,  1752,  1754,  1755,     0,
    1827,  1825,  1304,  1306,  3068,  1826,  1829,  1828,  1823,  1796,
    1793,  3041,     0,  2970,  1792,  1795,  1786,  1764,  1782,  1788,
    1789,  1799,  1790,  1784,  1803,  1804,     0,  1771,  2494,  2620,
    2494,  2620,  1622,     0,  2553,  1873,  1865,  1866,  1864,  1870,
    3004,     0,  1916,  1921,  1926,  1935,  1938,  1939,  2999,  3116,
    1931,  3119,  1936,  1991,  2717,  2718,  1991,     0,  3025,  3025,
    1976,  1992,  1993,  1974,  1980,  1975,  3013,  2000,  2413,     0,
    2244,   322,  2238,     0,  3019,  2241,  2494,  3079,  3079,     0,
    2045,  2046,  2543,  2074,  2076,  2077,  2073,     0,     0,  3070,
       0,  2125,  2107,  2120,  2113,  2109,  2122,     0,  1381,  1381,
    2134,  2143,  2140,  2518,  2521,  2512,  2520,  2513,  2159,  2162,
       0,  1381,  1381,  2176,  3046,  2183,  2221,  2266,  2256,  2260,
    2261,  2262,  2263,  2254,  2277,  2280,  2278,  2775,  1381,  1381,
    2289,  2509,  2506,  3029,  2297,  2296,  2298,  2494,  2881,  2494,
    1375,  2320,  2714,  2848,  2331,  3013,  2548,  3013,  2503,  2391,
    2388,  2387,  3048,  2398,  2449,  3127,     0,  2447,     0,   506,
     558,   807,   558,   812,     0,   626,   628,   627,   621,   625,
     623,   624,   620,   622,   619,   798,   793,   795,     0,     0,
     604,   791,  1021,  1017,  1018,  1011,  1015,  1023,  1009,   739,
    1016,  1008,   746,  1014,   710,  1010,  1012,  1013,  1022,   707,
     709,  1019,   711,  1020,   706,   714,   713,     0,   655,   657,
    3013,   758,  3117,   761,  3117,     0,     0,   659,  2752,   682,
     686,   685,   684,     0,   663,     0,     0,   662,   660,  2987,
     748,   749,   613,   612,     0,   457,     0,   494,  2656,  3055,
     478,     0,   460,  3103,   487,   489,   493,   492,   488,   490,
     486,   491,     0,     0,     0,     0,  3029,   306,   305,   281,
     304,     0,   354,   350,     0,   357,     0,     0,  2973,  2974,
     373,   376,  2989,     0,     0,  3029,     0,  3009,   353,   380,
       0,   411,   420,     0,   421,     0,   114,   115,     0,  3029,
    1353,  1359,     0,     0,  1334,  2459,  1536,  3152,  3153,  2547,
    1552,  1541,  1488,     0,  1506,  1570,  3021,  2883,  2830,  1615,
    1667,  2118,  2117,  3127,     0,     0,     0,     0,  1761,  1756,
    3002,  3043,  3042,     0,  1785,  3031,  1783,  1798,  1797,  1800,
       0,     0,  1791,  1836,     0,  1835,     0,  1617,  1618,  1349,
       0,  1872,  1879,  1733,  1890,  1892,  1893,  1381,  1940,  3000,
       0,     0,  1972,  1983,  1991,  3026,     0,     0,  1994,  1995,
       0,  2413,  3068,  2003,  2014,     0,     0,  2247,  2237,  3020,
    2030,  3080,   377,   378,   379,     0,  2066,  3131,  2064,  2065,
    2063,  3130,  2037,  2047,  2048,  2050,     0,     0,  2075,  2071,
    2090,  2092,     0,  2110,  3029,  2530,  2108,  2121,     0,     0,
       0,  2124,  2145,  2142,  2138,  2144,  2139,  2141,  2163,  2170,
    2177,  3047,  2192,  2511,  2508,  2504,  2510,  2505,  2507,     0,
    2307,  2883,  2306,  2345,  1374,     0,  2330,     0,  2334,     0,
    2326,  1381,  1381,  2382,  2393,  2527,  2524,  2392,  3049,  3050,
    2386,  2401,     0,     0,   508,   507,   810,   814,   942,     0,
     799,   796,   616,  3068,   619,   611,   614,   617,   606,   740,
     741,   745,   744,   743,   742,   708,   747,   712,  2708,     0,
       0,     0,   756,  3118,     0,   757,   762,  3029,   681,   680,
     665,   804,     0,   671,   674,   673,   670,  2880,   468,   459,
     458,   456,   496,   477,  2989,   465,   474,   471,   475,   470,
     311,   312,   310,   309,   383,     0,   295,   296,   297,   291,
     292,   286,   298,   299,   287,     0,   300,   301,   290,   288,
     289,   294,   293,     0,   280,   284,   285,   282,   384,   356,
       0,   364,   372,   385,   386,  2650,     0,  3029,   323,     0,
       0,     0,     0,   423,   198,     0,     0,  1350,  1351,  1355,
       0,  1356,  1364,  1366,  1508,  3022,     0,  3021,  2494,  1626,
    1769,  1760,  1759,  1757,  1758,  1806,     0,  3031,  1801,  1802,
    2494,  2494,  1619,  1620,     0,  1624,  1623,  1625,  1885,  1734,
    1891,  1920,     0,  1950,  1990,  1997,  1996,  2549,  2003,     0,
       0,  2485,  3029,  2245,     0,     0,  2235,  2239,  2061,  3081,
    2058,  2060,  2059,  2052,  2057,  2049,     0,  2055,  2053,  2054,
    2051,     0,     0,  2112,     0,  2103,  2128,  2519,  2516,  2127,
    2111,  2123,  2300,  2494,  2353,  1376,  2336,  2338,  2526,  2529,
    2522,  2528,  2523,  2525,  2409,  2402,  2403,     0,     0,  2451,
    2452,  3029,   510,   813,   944,   797,     0,   794,     0,     0,
     618,   658,   765,   759,     0,   766,  3070,  3070,   768,     0,
     672,     0,     0,   479,   480,   481,   482,     0,   461,  3012,
     467,     0,   364,     0,  3007,  3169,  3170,   277,   276,     0,
     361,   360,   359,   362,   358,  3029,   366,   314,   368,  2651,
     332,   341,   348,   341,   337,     0,  3029,  3029,   324,     0,
     381,  3029,  3029,  1352,  1345,     0,  1366,  1384,     0,     0,
    1571,  1635,  3027,  1805,     0,  1838,  1837,  1621,  2675,  2674,
    2750,  1941,  2001,  2414,  2415,  3029,  2004,  2005,  2007,  1381,
    1381,  2012,  2491,  2488,     0,  2248,  3029,  3082,  2056,  2062,
       0,  2093,  2701,  2700,  2702,     0,  2126,  2514,  2515,  2517,
    2308,  2978,  2379,  2378,  2354,  2346,  2347,  2966,  2348,  2349,
    2350,  2351,  2374,     0,     0,     0,  3029,  2413,  2404,  2408,
       0,  2407,  2405,  2453,     0,  3009,     0,   815,     0,   948,
     943,   945,     0,     0,  3029,   615,   767,   768,     0,     0,
    2985,   753,   773,   774,   775,  3044,   772,   678,   485,   484,
    2977,  2989,   466,  2850,   279,   302,   278,   367,   316,  2850,
     315,   365,     0,  3056,   339,   344,     0,   340,     0,   338,
     330,     0,     0,   325,   382,  2769,  2769,     0,  1384,     0,
    2884,  1381,  1381,  1381,  1594,  1642,  1638,  3068,  3028,  1629,
    1634,  1633,  1628,     0,  1787,  2485,  2416,     0,  2006,  2490,
    2493,  2486,  2492,  2487,  2489,  2246,     0,  2703,  2704,  2705,
    2091,     0,  3105,  2375,  2376,     0,  3070,     0,  2418,  2406,
    2444,   509,   511,  3025,   816,     0,   949,     0,   946,  3126,
       0,   755,   768,   763,  2769,   769,   776,  3029,     0,     0,
     463,   314,     0,  3029,   363,   370,   371,   369,  3057,     0,
     347,   349,   326,   327,   116,   117,  3029,     0,  2882,  1640,
    1644,  1641,  1636,  1643,  1637,  1639,     0,  1627,  2002,  2417,
    2249,     0,  3106,     0,     0,  2377,  2372,  2371,  2370,     0,
    2411,  3068,  2428,  2476,   532,     0,     0,   954,   955,     0,
     947,   800,   754,   782,   783,   785,  2769,   771,   483,  3070,
     462,   318,  2852,     0,     0,     0,     0,     0,     0,     0,
    1630,  2373,  3145,  3144,  3083,  2629,     0,  2366,  2360,  2361,
    2363,  3029,  2410,     0,     0,  2399,  1381,  1381,  2445,  2482,
    2479,  3029,     0,     0,     0,     0,   513,   533,   534,   515,
     543,     0,  3029,  3100,     0,   952,  1006,   784,   777,  2652,
       0,     0,   313,  2851,   317,     0,  3154,  3155,   345,  3029,
    3029,  1357,  1365,  3084,  3070,  2630,  2369,  2364,  2367,     0,
    2362,     0,  2419,  2420,  3029,     0,     0,  2429,  2430,  2432,
    2476,  2481,  2484,  2477,  2483,  2478,  2480,  3029,     0,     0,
    3029,  3029,  3029,  3029,   535,     0,  3059,     0,  3110,     0,
     512,   516,   518,   517,     0,     0,     0,     0,     0,     0,
       0,   514,   544,   546,   545,     0,     0,   820,  3034,  3034,
    3051,   853,   819,   823,   824,     0,     0,     0,   978,  3029,
     966,   967,   968,   959,  3123,   960,  3064,  3064,  3029,  3031,
    3001,  3029,     0,   983,   976,   963,   977,  3064,  3031,   964,
       0,     0,   975,   985,   982,   980,  3031,   965,   979,     0,
     986,   974,     0,  1001,   995,   999,   998,   996,  1000,   956,
    1002,   997,   981,   969,     0,  3064,  1007,  1025,  1024,  1028,
    2653,   464,     0,   345,   342,   346,     0,     0,     0,  2368,
    2365,  2412,  2421,     0,  2425,  2427,  2426,  2423,  2423,  2437,
    2433,  2801,  2802,  2799,  2800,  2434,  2438,  2431,  2400,     0,
       0,   541,     0,     0,     0,     0,  3029,  3029,  3029,  3029,
    3029,   519,     0,  3029,  3029,  3029,  3029,  3029,  3029,  3029,
    3029,  3029,  3029,  3029,   547,     0,  3029,  3185,  3186,  3034,
    3034,     0,   817,   821,  3029,   829,   825,   827,   828,   830,
     832,     0,   957,   958,   991,  3029,   989,  3029,     0,     0,
     961,   962,     0,  1004,   987,     0,  3117,  3029,     0,  1005,
    1003,  1329,   990,   955,  1029,     0,   205,   206,   320,   343,
     328,   329,  2359,  2356,  2358,  2357,  2352,  2355,  2422,  2436,
    2424,  2435,     0,   536,  3117,   540,   538,   542,   537,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3052,  3053,
    2780,   840,   835,  3048,   839,  2779,   838,     0,   854,     0,
     826,   831,   994,  1325,  1321,   992,   972,   973,   993,   988,
    1318,  1328,     0,   971,   970,  3100,   319,  2439,   780,   528,
     524,   525,   529,   527,     0,   530,   520,   526,   521,   522,
     523,   552,   548,   549,   553,   551,     0,   550,   833,  3049,
    3050,   834,   837,     0,     0,   855,   573,   822,  1313,  1310,
    1314,  1311,  1326,  1309,  1327,  1312,     0,  1322,  1323,     0,
    1319,  1317,  1315,  1316,   984,   539,   781,     0,     0,     0,
    3029,  3029,     0,  3029,   841,   842,   843,   844,   845,   846,
     836,     0,   857,   858,  1324,  1320,     0,   554,  3172,  3171,
    3029,     0,     0,  3174,     0,  3029,  3029,     0,  3100,     0,
       0,   852,   848,  3173,     0,     0,   847,   913,  3133,  3132,
    3023,  3064,  2968,  3029,     0,   912,  3029,  3068,   856,  3029,
       0,   863,   865,   864,   866,   875,   867,   869,   872,   859,
     860,   861,   871,   873,     0,   876,   862,   923,   868,     0,
     870,   874,  3136,  3137,  3064,     0,   849,   851,   850,  3024,
     940,  3067,  3066,  3034,   922,     0,   756,     0,     0,     0,
       0,  3062,  3062,     0,     0,   925,   920,   923,     0,  1308,
     927,   935,   936,     0,   938,   929,     0,   921,   900,   898,
     899,   894,   897,     0,   895,  3117,  2867,   902,  2688,  3176,
       0,     0,  3178,  3180,     0,  3184,  3182,   877,   882,  3072,
    3072,   879,   883,   878,   884,     0,  3063,   914,   914,  3062,
    3062,   907,   924,   926,   937,   934,   933,   931,   932,  3034,
     930,     0,   896,   762,   939,  3070,     0,   901,  2689,  3175,
    3179,  3177,  3183,  3181,  3074,  3073,   885,   890,     0,   918,
     916,   908,   914,   917,   910,     0,     0,   928,   531,   751,
       0,   904,   888,   880,   888,   893,   888,   881,   888,     0,
     915,   909,   911,     0,   750,   906,   903,   905,     0,   887,
     886,   892,   891,   919,   752,   889
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  3206, -3969, -3969,
   -3969, -3969, -3969, -3969,  3170, -3969, -3969, -3969,  2373, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  3175,
    3108,   210, -3969, -3969, -3969,  2698, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,  3140, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2954,
    1242, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  3030,
   -3969, -3969, -3969, -3969,  2951, -3969, -3969, -3969, -3969,  3138,
   -3969, -3969, -3969, -3969,  2935, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  2490, -3969,  2108, -3969, -3969,
   -1621, -3969, -3969, -3969, -3969, -3969,  3032, -3969, -3969, -3969,
   -3969,  3034, -3969, -3969,  2763, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  -606,
   -3969, -3969, -3969, -3969,  1224, -3969, -3969, -3969, -2278, -3969,
   -3969, -3969, -3969, -3969,  -404,  -842, -3545, -3969, -3969,   421,
   -3969, -3969, -3969, -3969, -3969,  -379, -3969, -3969, -3969,  -518,
   -3969, -3969, -3969, -3969,   420, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  2793, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,   410, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  -366, -3969, -3969, -3969,    52,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  -743, -3969, -3969, -3969,  -681,
   -3969, -3969,  -753, -3969, -3969, -3969, -1563, -3969, -3969,  2558,
   -3969, -3317, -3969, -3462,  -692, -3969,  -961,  1129, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3208, -3969, -3969, -3969,
   -3969, -2783, -3969, -3969,   958, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  1636, -3969, -3969, -3969, -3969,
   -2727, -3969, -3969, -3969, -1064, -2488,   491, -1279, -3969, -3969,
   -2463, -3969, -3969, -3969, -3315, -3969, -3969, -1180, -3969, -3969,
   -3310, -3969,  -563,  -470, -3969,  1263, -3969, -3432, -3969,  -615,
   -2424, -3969, -3969, -2369, -3969, -1611, -3969,   487, -1281, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  -867, -3722, -3969,
   -3969,  -992, -2020, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -2221, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3968, -3969,
   -3969, -3969, -3969, -1115, -3969, -3969, -3969, -3969, -3969, -3969,
   -1119, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  -447, -3969,
   -3969, -3969,  -888, -3969, -3969,  -603, -3969,  2630, -3969,  -789,
   -1472, -3969,  -657, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969,  1815,  2323, -1010,
    -747,  -742, -3969, -2074, -3969,  -939, -3969, -3969, -3969, -3969,
    -746, -3969,  -775, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  1601,  -133, -3969,    18,   449,
   -3969, -3969, -3969, -3969, -3969, -3097, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -1178, -3969, -3969,  -142, -3969,  3078, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  -808, -1564,
   -3969,  2164, -3969,  2170, -3969,   422, -3969,  -729, -3969, -3969,
   -1023, -3969, -3969,   435,  2157, -1142,  1583, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969,  1480,   811, -3969, -3969,
   -3969,  2491, -3969, -3969, -3969, -3969, -3969, -1221, -3969, -3969,
    -150, -3969, -3969, -3969, -3969,    72, -3969, -3969,    45, -3969,
   -3969, -1002, -3969, -3969, -3969,  -453, -3969,  -451, -3969, -3969,
   -3969, -3969,  2492, -3969, -3969, -3969, -3969,  2113, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    2699, -3969, -3969, -3969, -3969, -3969, -3969, -3969,  2449, -3969,
   -3969,  2085, -3969, -3969,  1456, -3969,    50, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,  1434, -3969, -3969, -3969, -3969,   399,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    2441,   810,  2695, -2374, -2669, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -1791, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    2072, -3969, -3969,  2067, -3969, -3969, -3969, -3969,   771,   377,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,    71,
   -3969, -3969, -3969,  2430, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,  1399, -3969, -3969, -3969, -3969, -3969, -3969,
     375, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   370,
    2053, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  1884, -3969, -3969,   753, -3969,
    1373, -3969, -3969, -2394,   361,   367, -3969, -3969, -3969, -3969,
   -3969,  -157, -3969,  -294,  1893, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  2423, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969,    55, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3269,  1251, -3969, -3969, -3969,   352, -3969,
   -3969, -3969, -3969, -3969, -3969,  -323, -3969, -3969, -3969,  1221,
   -3969, -3969, -3969, -1266,   740, -3969, -3969,   355, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,   347, -3969,
     351, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969,   672, -1448, -3969, -3969, -3969, -3969, -3969,
   -3969,  1845,   737, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  -158, -3969, -3969, -3969, -3969,
    1204, -3969, -3969, -3969,  2407, -3969,  2406, -3969, -3969, -3969,
   -3969,  2735, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969,   702, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
    1816, -3969, -3969,  1181, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,   322, -3969,  1185, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -3969,  -500, -3969, -3969, -3969, -3969, -3969,  -292, -3969,
   -3969, -3969, -3969,   734,  1236,  1256, -3969, -3969, -3969, -3969,
   -3969, -3969, -3969, -3969, -3969,  -164, -3969, -3969, -3969, -2169,
   -3969,  -246, -3969, -3969,  -544,  -669, -3543, -3969, -3969,  -547,
   -3969, -3969,  1807, -3969, -3969, -3969, -3969, -3969, -3969, -3969,
   -3969, -1552, -3969,   995, -3969, -3969,   998, -3969,  1190, -3969,
    2178, -3969,  2183,  -546, -3969,  -495, -3969,  -492,  -357, -3969,
    -244, -3969,  -242, -1683, -3969,   937, -3969,   936,   346, -3969,
     363, -3969,   366, -3969, -3969, -3969, -2534,  -119, -2078, -3969,
   -3969,    63, -3969,    65, -2116,   353, -3969,   911, -3969,   916,
    2611, -1407,  2788,  -423, -1546, -2103,  -608, -1825, -3969, -3969,
    2156, -3969,  2166,  1526, -1627,   762,   764,   766,   770,  1041,
     582,  -406,  1200,  1049, -3969,  1497,  -403, -1104,  -564,  -645,
    2770,  2469, -1069, -3969,  -229,  1393,  -674, -3969,  -967, -3969,
    1509, -3969,  -554, -3969,  2259,   288,  -132, -3969, -3969, -1076,
   -3969,   677, -2668,   -55,  3273,  -584,  -573, -3969,  -562,  2746,
   -3969,   -45,    82, -3969, -1085, -2193, -3969,   -39, -3969,   -81,
   -3969,  1291,  -948, -3969,  1478,   477, -2648,   765,  -632,  2267,
   -3969, -2303, -2362, -2691,  -433,  -557,  -658,  -717,  -597, -3969,
   -2387, -3969, -2693, -3969,  2670,  -649, -3969, -3969, -3969, -1359,
     -80, -1955, -3969,  1072,  -745,  -768,  -151,  2975, -3969, -2197,
    2744,  -216,  3130,  -502,  -700,  -506, -3969, -3969, -3969,   -51,
    2688, -3969, -3969, -3969, -3969,  1259, -3969, -3969,  1864, -3969,
    -261, -3969, -3969, -3969, -3969,  1292, -3969, -2443, -3969,   969,
     712,   414,   135, -3969, -3969, -3969, -3969,  -204,  -838,   542,
   -3969,  1177, -3194, -3969, -3969, -3969, -1565, -1671, -2677,  -276,
     445, -3969, -3969, -3969, -3969, -3969, -3969,  -117,  -177, -3969,
   -2012,   862, -3969,     5, -3969, -2867, -3969,   -26, -1818, -2203,
   -3969, -3969, -2260, -3969,  -713, -3969, -3969, -3969,  2733, -1569,
   -2372, -1666,  -861,  -772,  -688,  -916,  3227,   489, -3969, -3969,
    2990, -3969,  -803, -3969, -3969, -3969,   209, -3969,   327, -3969,
    1311, -3509, -3969, -3969, -3969, -3073,  -644,  1618, -3969, -3969,
     646, -3969, -3969, -1163, -3969,  2364, -3969, -3969, -3969,  -640,
   -3969,  -699,  -428, -3969,  1887,  1118, -3969, -3969,   307, -3969,
   -2461,  -856, -3969, -3969, -3969, -3969, -3969, -3969
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     4,     5,     6,    11,    12,     7,     8,
      13,    14,    47,    48,    49,   111,    51,   113,    19,    40,
     123,    15,    16,    17,    24,    32,   219,    25,    31,   109,
     163,   159,   295,   528,   529,   530,    20,    37,    38,   118,
      55,   121,   226,   169,   535,    29,    30,    42,    43,    82,
      83,    84,    85,   196,   278,   501,    86,   193,   263,   264,
     265,   266,   267,   491,  1143,  1694,   268,   269,  1139,   270,
      87,   194,   275,   276,   277,   496,    88,    89,    90,    91,
      92,   151,   210,   521,   211,   212,    93,   180,   244,   462,
     463,   245,   246,  1121,  1129,  1122,  1123,  1124,  2415,  2848,
    1125,  4178,    94,   157,    95,   202,   203,   204,   515,    96,
     198,   199,    97,   473,   474,   182,   746,    98,    99,   477,
     100,   101,   102,   103,   104,   105,   106,   150,    63,    64,
     129,   179,   241,  1085,  1662,  1663,  2374,  2375,  3473,  3474,
    3475,  3476,  3477,  3209,  3210,  1104,  2376,  3453,  2377,  3759,
    3760,  3843,  3952,  2378,  2379,  3227,  3488,  2380,  1132,  2381,
    2382,  2383,  2384,  3644,  3764,  4084,  3765,  3767,  2385,  2386,
    2387,  2388,  3480,  3634,  2389,  3637,  3638,  3761,  3762,  3845,
    2390,  2391,  2827,  2392,  3030,  2393,  3229,  2394,  2395,  2396,
    2397,   242,   243,   454,   455,   456,   457,   738,   458,   459,
     460,   731,  2843,  2844,  3234,   461,   733,  1681,    58,   235,
      59,    60,   125,   176,   236,   237,   716,   238,  1084,  1649,
    1650,  3441,  1651,  3900,  3620,  3185,  1652,  1653,  2813,  3447,
    1654,  1655,  3443,  3613,  3614,  3615,  3616,  1656,  3200,  3201,
    1657,  3187,  1658,  1659,  2349,   704,  2244,  2738,  3109,  3110,
    3592,  3725,  3822,  4000,  4001,  4002,  4003,  3936,  3937,  3938,
    4011,  4012,  4013,  4014,   440,  1626,   441,   442,   708,   709,
    1636,   710,  1080,  1081,   200,  2332,  3124,  2160,  2161,  2162,
    2163,  2164,   711,  3130,   712,  1631,   713,  1632,  2791,  3405,
    3406,  3125,  2304,  2305,  2306,  2307,  2308,  3158,  3159,  2309,
    2310,  3178,  2311,  3174,  2251,  2312,  2313,  3176,  3436,  2314,
    2315,  2772,  3165,  3429,  2316,  2317,  2318,  2319,  3415,  3417,
    2320,  4355,  4494,  2321,  3164,  3422,  2769,  3608,  3161,  3737,
    3741,  3838,  3742,  3743,  3744,  3745,  4295,  3746,  3893,  3894,
    2322,  2323,  2779,  2324,  2325,  2326,  3400,  3126,  3127,  3597,
    2327,  2328,  2329,  1072,  2739,  1630,  3112,  2248,  3397,  3593,
    3727,  3886,  3942,  4022,  4023,  4146,  4147,  4148,  4149,  4024,
    4221,  4222,  4223,  4268,  4304,  4305,  4306,  4307,  4308,  4309,
    4142,  4228,  4313,  4328,  4359,  4360,  4427,  4483,  4499,  4487,
    4361,  4411,  4412,  4362,  4457,  4496,  4363,  4364,  4471,  4472,
    4365,  4366,  4367,  4396,  4397,  4368,  4369,  4449,  4450,  4400,
    4401,  4402,  4370,  4371,  2743,  3594,  3730,  3731,  3732,  3888,
    3889,  4079,  3943,  4069,  3945,  3156,  4076,   953,  4173,  1499,
    1500,  1501,  1502,  2112,  1460,  2113,  1461,  2114,  1462,  2115,
    1463,  2116,  1464,  2117,  1465,  2118,  1466,  2119,  2120,  1467,
    2121,  1468,  2122,  1469,  1470,  2123,  1471,  2124,  1472,  1473,
    2125,  1474,  2126,  1475,  2633,  1986,  1476,  1477,  1481,  1482,
    2560,  2561,  4398,  4399,  4283,  4284,  4285,  4239,  4292,  4293,
    4156,  4289,  4154,  4286,  4070,  4071,   172,   173,   307,  2861,
    3503,   174,  1149,  1702,  1701,  2422,  2423,  2424,  2857,  2858,
    3654,  3242,  1704,  3244,  3656,   694,  1048,  1049,  2227,  3374,
    1050,  1051,  2720,  1874,  1875,  2544,  1052,   231,   373,   374,
     624,   774,  1152,  2476,   775,   776,   777,  2592,  1166,  1766,
    1767,  1157,  1158,  1159,  2891,  2892,  1793,  2966,  1717,  1718,
    1161,  1758,  2864,  2865,  4072,  1907,  1761,  1151,   375,   625,
     810,  1190,  1188,   376,   626,   826,  1846,  2518,   377,   627,
     839,   840,  1848,   378,   628,   845,  2521,   771,  1146,  1700,
     542,   543,  1850,  1851,  2524,  2579,  2982,  3287,  3288,  3289,
    3661,   649,  3792,  3784,  3864,  3785,  3862,  3786,  1218,   379,
     629,   849,   850,   380,   630,   854,   855,  1225,   856,  1221,
    2526,   381,   631,   859,  1230,   382,   383,   632,   869,  1239,
     384,   634,   874,   385,   633,   871,  1240,  1243,   386,   635,
     881,  1869,   882,   387,   636,   893,   894,   895,   896,  1268,
     897,  1270,  1908,  1884,  1885,  3528,  1886,  2549,   898,  1253,
     899,   900,   901,  1911,  1912,   902,  2543,  2946,  2947,  2948,
     903,  1272,  2571,   904,   905,  2542,  3263,   906,  2572,   907,
    1255,  1916,   954,  2967,  2968,  2969,  2970,  2971,  3280,  2972,
    2973,  2974,  2975,  1909,  1259,   388,   637,   911,  1279,   389,
     638,   390,   640,  1925,   916,  2577,   391,   641,   919,   920,
     921,  1288,  1289,  1290,  1931,  1291,  1928,  2588,  2584,  2585,
    2985,  1285,   392,   642,   926,  1962,   927,  1309,  3293,  3294,
     393,   643,   933,   650,   394,   644,   934,   395,   645,   937,
     396,   646,   940,  1967,   397,   398,   651,  1970,  1316,  1971,
    2597,  2599,   399,   652,   946,  1317,  1980,  2603,  2996,  2997,
    2998,  3000,   400,   653,   949,   401,   654,   955,   402,   655,
     957,   958,  1486,  1487,  2006,  1488,  1489,  2619,  2620,  2003,
    2004,  2005,  2613,  3010,  3011,  3012,   403,   962,  1490,  3311,
    3795,  3541,  3676,  3677,  2009,   404,   963,  1492,  3018,   405,
     658,   406,   659,   970,  1506,   407,   660,   972,   408,   661,
     974,  1510,   409,   663,   977,   978,   979,  1517,  2132,  3332,
    3333,  3560,  3553,  3554,  3334,  3335,   410,   664,   981,  2645,
    2646,  3339,  3036,  1522,  1523,  1524,  2648,  2650,  2651,  3562,
     411,   665,   412,   666,   987,  1535,   413,   667,   989,  2177,
    3041,  3042,  3043,  1866,  1867,  1868,  3346,  3045,  3345,  3565,
    1537,   414,   415,   668,   991,  1545,  3050,  3356,  3051,  3354,
    3052,  1542,   416,   669,   993,   417,   418,   670,   996,  1549,
     419,   671,   999,  2664,  2665,  1553,   420,   421,   672,  1003,
    1559,  2180,  2670,  2671,  1557,   422,   673,  1006,  1561,  1562,
    2184,  3065,   423,   674,  1011,   213,  1578,  1012,  1013,  2205,
    2206,  1014,  1015,  1016,  1017,  1018,  1019,  1020,  1021,   424,
     675,   964,  3020,  1494,  3318,  2013,  2627,  3317,  3546,   425,
     676,  1030,  2208,  1586,  2698,  2699,  2700,  1582,   426,  1032,
    1588,  3074,   683,   684,   427,   689,  1037,  1038,  1039,  1598,
    1599,  2222,  3085,  2713,  1596,   428,   690,  1042,  1604,   429,
     692,   430,   693,  1044,   431,   695,  1053,   432,   696,  1056,
     433,   697,  1059,  1617,  2724,  2725,  2232,  2727,  3096,  3098,
    1615,   434,   698,  1063,  3375,  3574,  3705,  3706,  3707,  4186,
    3708,  3918,  3919,  3969,  3709,  3878,  3710,  3711,  3712,  3713,
     435,   699,  1065,  1547,  2235,  2236,  3383,  1620,   436,  1067,
    1622,  3391,  3980,  3584,  3585,  3586,  3722,  3717,  3922,  3313,
    3673,  3674,  3882,  3972,  3973,  4189,  4190,  3925,  3977,  3978,
    4100,  4105,  2238,   437,  1068,  1624,  3883,  2241,  2736,  3106,
    3589,  2434,  2868,  2435,  2436,  2862,  2437,  2438,  1262,  1879,
    1263,  1877,  1264,  3928,  3985,  3929,  3983,  3930,  3681,  3803,
    3682,  3801,  3683,  2504,  2916,  2505,  2914,  2506,  3080,  3367,
    3081,  3365,  3082,  2661,  3566,  3698,  2662,  3055,  3056,  3384,
    3582,  3385,  3580,  3386,  2537,  2538,  2937,  2539,  2935,  2540,
     982,  2135,   685,  2878,  3017,   944,   945,   923,   924,  1303,
    1304,  1936,  1305,  1956,  1957,  1958,  1959,  1960,  1961,  1591,
    2216,  1804,   828,   829,   830,   831,   811,   861,  1233,  1000,
    1001,  1004,  1669,  3875,  1670,   778,   950,  1023,  1024,  1964,
    1965,  1314,  1525,   842,   843,  1664,  2805,  3640,  3948,  1140,
    2799,  2800,  2806,   132,   205,   935,   863,  1266,   812,   813,
    3667,   814,   815,  4417,  1818,   834,  3691,  1768,  2166,  3419,
    1800,  2481,  2621,  3091,  1994,  3003,  1564,  2924,   851,  1060,
    1527,  1707,  2444,  2680,  2681,  2172,  1708,   965,  1027,  1054,
    2622,  3669,  2766,  3169,   816,   687,   876,   864,   865,  1996,
     688,  1141,  1142,  1693,  1035,  1036,  1709,   516,  2446,  4226,
     475,   817,   512,   513,  4106,   818,   819,   820,   821,  1196,
    1175,  1826,  1810,  1811,  1822,  1815,  1805,  1807,   714,  2726,
    3841,  1213,  1839,  2514,  1540,  1503,   449,  1236,  1861,   305,
    3180,  3257,  3508,   621,   622,   623,  2733,  2459,  2347,  1107,
    3220,  2775,  1162,  1163,  2836,  1257,  2425,   271,   149,   492,
    2335,  1247,  1762,  3300,  2562,  2991,  1102,  1100,   183,  3621,
     983,  1985,  3025,  3506,  4380,  3306,  3793,  1307,  2018,   286,
    2023,  3273,  2472,  3362,  3390,  4141,  3190,  3849,  4005,   166,
    4437,  4155,  4383,  1090,   734,  4466,   291,  3322,  3688,  3964,
     272,  1763,  2399,  1613,  2765,   136,  2752,  2331,   482,  3873,
    2708,  4006,  1679,  1250,  3001,  3424,  2563,  2457,  2762,  3598,
    2976,  3337,  4372,  4272,  4374,  4075,  1234,  3914,  2400,   255,
    2803,  3249,  3958,  1691,  2339,  1227,  2706,   822,  2406,  3629,
    4320,  4326,  4430,  4431,  4432,  4433,  4434,  4027
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     214,   763,   941,   247,   909,   187,  1795,   190,  1170,   445,
      53,   133,   195,  1073,  1074,  1075,  1026,   140,  1082,  1045,
    2250,  1521,  1760,  1671,   994,  1673,  1674,  2019,  1676,  1677,
    1587,  1086,   230,   922,  2649,  1091,  1092,  1684,  1094,  1095,
    2896,  1097,  1098,   137,   138,   139,  2744,  1160,  2441,  2866,
     144,  2230,   251,  2442,   288,  2907,  1574,   188,  2795,   188,
    1563,   966,  1926,  2243,   188,   511,  2416,   862,   947,  1245,
    2554,   936,  2454,   841,   908,  2344,  1087,  1088,   966,   936,
    2564,  1093,  3167,  1876,  1096,  1829,  1228,  2875,  1184,  3107,
    1025,  3426,  2703,  1271,   167,  2816,  2553,  2881,  1238,  2663,
    1825,   936,  2820,  2586,   188,  2824,  2825,  3605,   184,   130,
     185,  4175,  1835,  1935,   191,   192,  2136,  2568,   130,  3719,
     837,  1237,  2643,   443,   206,   215,  3630,  4485,  1043,  3057,
    3192,   873, -1337, -1335,  2796,  2797,   493,  1686,  2871,  2872,
     222,  1147,  3307,  3548,  2873,  2874,  1002,  2876,  1286,   961,
    1966,   287,   739,  1177,  1178,   283,   248,  3917,  3611,  3525,
     294,  1183,  3222,   858,  4391,  2451,  1192,  2229, -2746,  3230,
    1764,  1688,   223,  3787,   281,   479,  2530,  1923, -3127, -3127,
     147,   450,   258,  2229,  1209,  1998,   153, -3070,   292,  2229,
    2020,  1062,  3251,   296,  1550,   503,  2334,  2837,  2977, -3127,
    2462,   306,  1794,  1216,    65,  4392,   524, -2747,   966,  1153,
   -3127, -3127,  3975,  3987, -3127,  1943,  1932,   986,  3857,  1697,
     827,  2466,  1496,   832,   503,   498,   297,  3014,   860,  2470,
    3941,  4145,  1483,  2213,  2455,   483,   519,   520,   258,  2673,
    2574,   860, -2987,  3027,  2674,  1883,   258,  2165,  4482,   860,
   -2987,  2950,  4018,  4019,  2951,  2810,  1153, -2985,  2986,  4117,
    1238,  2955,  1145,  1518,  2958,   490,  3826,  1594,  4495,  3315,
   -2757,   860,  4446,  3087,  3088,  1319,   258,  3728,   858,  1999,
   -2987,   207,   858,  1580, -2072,   841,  1796,   293,  2178, -3085,
   -2755,   207,  2675,   181,   980,  3277,  1459,    66,  3276, -3127,
    3497,   951,  3876,  4130, -3044,   772,  1010,  1732,  3276,  1194,
    3835,  3439,  2016,  1010, -3127,  3720,  2471,   837,   837,   837,
     160,  1797,  1798,  1983,  1602,  3701,   181,  1211,  2788,  2908,
     233,  2811,   750,  1267,  2427,  1280,  2704,   289, -2977, -3090,
    2452,  3523, -2977,  2777,  3048,  3407,   656,    22,  2211,  -818,
    2659,  2565,  1203,  2229, -3070,    67,  3884,   700,    68,  2801,
      69, -3119,  1312,  2859,  3848,    52,  2489,   253,   525,  2629,
    1606,  3022,  2545,  2546,  1312, -3127, -3127,  2213,  1575,   107,
    3714,    70, -1337, -1335, -3127,  1260,  3729, -2185, -1337, -1335,
    -818,  -818, -2185,  3023,   718,   526,  -770,  3518,  2558,  4299,
    2559,   857,   838,  3100,   872,  2855,  3657,  2129,  3034,   161,
    3781,  4323,   181,  4085,  3728,  3805,  4300, -3127,  1201,  3781,
     832,   832,   832,  1160,  3207,   503,  4231,  3831,  4486,  1160,
    3102,  4016,  4099,  1607,  1571,   870,   742,   743,   990,   960,
   -2185,   997, -3029,  3702,   966,   936,  2638,  1031,  2882,    52,
    4301,  2522,  1312,    52,  3498,  3820,   749,  2233,   860,  1855,
   -3115,  3059,   766,   752,  1837,   998,  4324,  1057,  2748,  1862,
    4474,  1993,   494,  3271,    71,  1204,  1531,  4318,   846, -3009,
    1205,  3039, -2987, -1337, -1335,  2823,  4182, -3127,  2000,  1765,
     915,  4319,  3272,   536,  1993,  2866,    52,  3208,  2234,  4318,
      52,  2225,  1567,  4016,  4490,  3703,  2213,  4302,  4231,  2213,
    1856,  2213,  3060,  4319,  3702,  3631, -1337, -1335, -1337, -1335,
    2856,  1801,  3892,  3729,   444,  2855,  2213,   858,   837, -2987,
    4303,   504,   860,   284,   254,  2213,  2630,  3870,  4085,  1882,
    1608,   108,  2718,  2213,   860,  3483,  3479,   844,  3058,   181,
    4188,   866,  1689,   450,   186,  2802,  3839,  3206,   504,  3778,
    2523,  3491,  3504,  -770,   866,   938,  3062,  3788,  2021,  4393,
    3024,   162,   866,   527,   273, -3009,  3703,   657,   967,  1858,
    2701,  4290,  2749, -3127,  -818,  4183,   130,   504,   701,   995,
   -3128,   995,  1005,  2490,  1028,   967,  2778,  2212,  1135,   793,
    2001,   794,  2860,  4184,   249,  4447,  3763,  3519,   505,  3302,
     259,  3305,  3303,    23,  2414,   860,   790,   791,   259,   995,
    2420,   181,   860,  3600,   506,   862,  1222,  3278,  1592,    52,
      52,   832,  1799,  1573,   476,   505,   464,  1261,  -818,  3704,
    2856,  1241,  3549,  2705,    72,   451,   504, -3009,   259,  2660,
     504,   506,   705,  3526,  1105, -2693,  2715,  1281,   773,  3274,
    3432,  -497,  2228, -2977,   505,  3433,   837,   837,   837,  4020,
   -2788,  3782,   207,   837,   837,   837,  1821,  3049,   922,  1821,
     506, -3127,   838,   298,   299,   300,  2941,  2428,  2418,   837,
    1010,  1821,   837,  2822,   290,  1873,  3789,  1998,   837,   837,
     837,   837,   837,  2471,  1156,   755,  -497,   759,   833, -3013,
     732,  1698,   207,  1062,   793,   526,   794,   862,   793,  3646,
     794,  3931,  3790,   505,  2017,   967,  2491,   505,   837,  2509,
    1484,   801, -3127,   837,   234, -2985,    73,  2170,   186,   506,
    2789,  2909,  3028,   506,  3653,   260,  2133,   207,  1034, -1337,
   -1335, -2985,  1706,   260,  1984,  3316,  1953, -2985,  4185,   844,
    1968,  2197,  4220,  2586,  3550,  4275,  1530,  3618,  1593,   832,
     832,   832,  -497,  1814,  1814,  1814,   832,   832,   832,  3434,
    2198,   866,   507,   260, -1342,  2815,  1828,  1933,   504,  1834,
     476,  1999,   832,  2600,  2849,   832,  3193,  3932,  1046,   301,
    3194,   832,   832,   832,   832,   832,  2014,  -818, -3044,   507,
    2547,  3567,  1862, -2977, -2977,  3658,  4296,  3195,  2214,  1459,
     452,  3632,   224,  3877,  3650,  4227,  2919,   186,  1859,  2987,
    3976,   832,  2469,  1863,  1995,   186,   832,  3988,   507,   186,
     274,  3276,   647, -2693,   186,   261,   801,  4176,  3440, -2072,
     801,  -283,   453,   261,  2165,   866, -3127,  3040,  4448,   186,
    2812,  1883,  1485,  3029,   186,   505,  2641,   866,   858, -3029,
   -2991,  2942,   258,  1934,  2456,   225, -2987,  2167,  1828,  4118,
    3279,   506,   476,   261,   476,  3191,  -497,   476, -3127,  3510,
      76,  1047,  3527,   527, -3085,   504,   537,   507,   478,  2886,
   -2977,   507,  1529,  1699,   508,   833,   833,   833,  2411,  2412,
    3534,  4021,  2890,  2215,  2550,   858,  3612,  2889,  1148,  1687,
     186, -2985,  1005,  4131,  2128,   502, -1342,   476,   487,   186,
    1683,   508, -3127,  4007, -3029,   936,   939,  1667,   866,  1668,
    -497,  1212,  1672,  3748,  3749,   866,   186,   862, -1340,   486,
    3783,  1682,  1046,  1046,  1665,  1666,  3885,   484,  1034,  3783,
     508,   967,  2214,   793,  1675,   794,  1695,  1576,  3780,  2731,
      79,   740,   505,  3035, -2985,  1690,  1756,  3633,  2402,  2403,
    2022,  3774,   509, -3127,  2408,   538, -2987,  2409,   506,   837,
   -2985,  2456,  3791,   476,  -497,  3551, -2985,  1593,  1312,  3721,
    2000,  2667,  -559,   476,  3310,   154,   188,   188,  -497,   509,
   -3090,  1864,  2002,   858,   302,   303,   188,   451,  1577,   508,
      80,   131,  4177,   508,   186,  2478,  2479,   304,   186,  1287,
     131,  -497,  3821,   495,  3699,   444,   939,   201,   509,   507,
    2175,   862,   487,   186,   499,  1047,  1047,  3552,   476,  -818,
    1857,   952,  2417,   186,   186,  2501,  4394, -2843,  1660, -3127,
   -1985,   476,  2445,  2508,  1526,   186,  2999, -2185, -2185,  3067,
    1204,  4415,  3819,   967,  3840,  1205, -3058, -3115,  4291,   510,
     262,   250,  2199,  3377,  1881,  3379,  2507,   837,  3858, -3009,
   -1340,  2214,   832,  4241,  2214,   801,  2214,   509,    81,  1973,
     444,   509,  1974,  1975,  1567,   860,   510,  2498,  1828,  1831,
    4007,  2214,  2001,   465,  2929,  2548,   833,  1696,   476,   207,
    2214,  4248, -3127,  3264,  3265,  3266,  3267,   476,  2214,   186,
    1710,  1008,   764, -3029, -3119,   510,  1943, -1985,  4152,   186,
    2200,  -818,  3538,  1706,  1865, -3127,   507,  3995,  3420,   706,
      52,  2482,  3409, -1985,  2593,  1882,   207,  1295,  2586,  3450,
   -2985,   508,   707,   476,  4101,  2419,   648,  1765,   860,  3880,
    4094,  3898,   539, -3127,  1521,  2201,  3111,   540,  4008,   476,
     186,   503,   503,  3557,   186,  3282, -2845,  2218,  3103,  2488,
     832, -2839,   452,  3115,   510,  3435,  3647,  3196,   510,   647,
     756,  1831,  1828,   847,   186,   503, -2841,   705,  3046, -2847,
    1910,  -559,  3648,  3255,  -283, -2834,  4063,  1204,  2679,   283,
    3175, -3127,  1205,  2512,   453, -3009,  -497,   966, -3127,  3569,
     541,  -497,  1153,  1109,   844,  1538,   504,  1680,  2677,   509,
   -3127,  4469,  3902, -3152,   259,  2768, -3127,   877,  -497,  1518,
    -497,  3004,  3350,  4470,   833,   833,   833,  4102,  1103,  3619,
    2870,   833,   833,   833,  3225,   878,  1987,  3568,   508,   862,
    3325,  2443,  4464,  3410,  1567,  1765,  4090,   833,  2596,  2202,
     833,  3933,  1231,   504,  1009,  4095,   833,   833,   833,   833,
     833,  -283,  1543,  3625,  2520,  3283,  3059,  3285,  1712,  2591,
    3934,  2943,  1713,  3626,   793,  1821,   794,  -283,   504,    -7,
   -3127, -1985,   239,   505, -2977,  2555,   833,  3935, -2977,  1223,
    2480,   833,   186,  4091,  2912,  2913,  2952,  1539,  2601,   506,
    2174,  2188, -3129,  2838,  2839, -3153,   510,  2604,  2944,  2841,
    2842,  1136,  4453,  3320,  2853,  1010,   509,  3060,   207,  3197,
    2804,   793,  3641,   794,  1583,  4008,  1995,  2933,  2934,  3349,
     505,   847,  2774,  4096, -2693,   848,   207,  3770,  3635, -3011,
    3773,  3446, -3127, -2693, -2693,   273,   506,  3411, -2693,   260,
     476,   504,  3966,  1111,  3198,   505,  2203,  2398,  2696,  3199,
    2750,  3350,  3996, -3127,  4153,  3330,  2629,  2535,  2697,  1966,
       3,   506,  2430,   181,  3370,  -497,  3372,  2750,  4278,  2988,
    2431,  2906,  3679,   207,    27,  2190, -2847,  3290,  3926,  2993,
     879, -2757,  1164,  1110,  1944,  1945,   860,  3544,   866,   186,
     860,  1831,  3588, -1985,  3412,  3059,   801, -3127,  3967,  3636,
    2407,  1034,  2407,   510,  2407,  2407, -3125,  2407,  2407,   793,
    2502,   794, -3127,   207,  3078,  4064,  1584,  3516,   505,  4009,
    1112,  2636,  1585,  3116,  3326,  -283,  1478,  3033,   476,  2978,
   -2632,  2980,  2826,   207,   506,  -497,  1114,  3968,  3998,   261,
    4065,  3053,  3054,   801,  2167,  3837,  3060,   507, -3127, -1779,
   -3109,   866,    18,  3852,  3853,  4010,  4465,   706,   131,  -559,
    1567,  1946,  1947,  1226, -1307,  4279,   485,  2717,  3437,  2763,
    2751, -1985,  -559, -1330,   466,  2783,  2784,  4279,  4063,  4066,
     860,   186,  1544,   648,  2002,  1831,  1224,  2753,  2885,  3596,
    3903,  2682,  2401,  2536,   507,  3026, -3109,  4103,     9,   181,
      10,  2945,  2482,  2637,   504,   504,  3961,  3395,  3818,  3396,
    3378,   757, -2571,  2817,   936,  1312,   476,   186,  2207,   507,
    2204,   -43,  4395,  2630,  4459,  3451, -3009,  3558,   504,  2746,
     476,  2556,  3031,  1111,  4067,   466,   186,   833,  3559,  1976,
    1977,   801,  2953,   751,   188,  2653,   744,  -283,   186,  3327,
    4220,   467,  3810,  1318, -1985,  3046,  2761,   284,  4333,  2785,
    3642,  4351,   790,   791,  2350,   758,  2253,   468, -1985,   508,
    2330,  2333,   240,  2336,  3494,  3089,  2341,  2343,   476,  2345,
     476,   505,   505,  1714,   186,   476,   476,   966,  1532,  1531,
    1978,  1979,   507,    26,  1116,  2767,  4009,   506,   506, -2977,
     967,   274,  2773,  4279,  3545,   505,   880,  2502,  3004,  2503,
    1112,  1963,   467,  1113,  2780,  3998,   508, -3109,  4097,  3452,
     186,   506,   681,  3006,  3680,  -283,  1114, -3109,   468,  1137,
    3927,  2790,  4010,  3997,   719,   833,  3402,  1953,  1590,  4098,
    1567,   508, -3109, -3109, -3109,  3328,  3245,   509,  2534,   928,
    2502,   253,  3998,     9,  2516,    10,  2447,  1115,  3413,  3664,
   -3152,   114,  2448,   720,   706,  2449,   677,  2450,  3259,  3999,
     837,   837,  4104,  2818, -3152,   186, -3129,   707,  2840,  -283,
     721,   722,  3290,  2137,   860,   860,   860, -3129,   186,  -283,
     485,  3117,   186,  2750,   509,  1554,  3351,  2628,  1972,  2918,
    3079,    28,  1973,  4281,   967,  1974,  1975,  2893,  -283,   866,
    4280,  3740,  2138,   866,   508,  4281,  1117,  4064, -3058,   509,
    3218,  3219,  -283, -1330,  1138,   469,  3101, -3127,   844, -1330,
     186,  3231,  4236,  1715,  1716,  3236,  3237,   186,  3094,  3643,
    1479,  4243,  4065,   186,   510,   147, -2632,    35,  4094, -2977,
   -2977,  2445, -3153, -3127,  3414,   507,   507,  2682,  1164,  2682,
    1621,  2445,  2750, -1779,  1164,   186, -3153,   186,  4180,  4181,
    2710,  2712,    65,   832,   832,  4137,  4138,   186,   186,   507,
     186,  4066,   860,  1232,  1116,  3660,   469,  2750,   186,  3995,
     148,   510,   509,    36,  2531,  2659,   723,  3665,  3666,   504,
    4353,  4325,   186,   866, -3127,  3401,  2503,  1774,  4232,  1480,
    4419,  4323,  2911,  2755,  1775,  4235,   510,  2351,   254,  4238,
    1611,    -6,  4240,  1206, -1330,  4354,  1612,  2635,  1226,  2557,
    3352,  3353, -1779,  1207,  3955,  3351,  4067, -3127,  2567,  3895,
     678,  4281,  3008,  3359,  3360,   476,  1954,   470,  1955,  2503,
    3700,   531,   532,  4460,    -6,  3381,    -6, -1330,  1870, -1330,
    3363,  3364,  3401,  4095,  4356,    66,  4420,  2682,  2682,  2939,
     447,  2352,  3939,    39,  1887,   186,   505,   508,   508,  1530,
    3329,   929,  2757,  3009,  1153,   930,  3403,  4461,  4428,   510,
    3940,  1120,   506,  1513,  3330,  2890,  4218,  4219,  3895,  4318,
    4462,   508,   448,    41,  2928,  2945,  1117,  2759,   470,   679,
    4124,  1118,  1119,  4319,   115,   931,  2140,   116,   117,  4357,
    2959,  1995,  2960,    67,  2458,   471,    68,  2786,    69,  1939,
    1940,  1941,  1204,  4454,  4463, -1307,   504,  1205,   837,  1223,
     837,  4096,  3118,  4314,  3119, -1794,  4315,  2532,   735,    70,
    1821,    44,  1774,  3120,  3121,   509,   509,  3122,  3123,  1775,
    2430,   724,   680,  2535,   837,  3811, -2977,   533,  2431,  2979,
   -2977,  2981,   725,  2141,  2142,  2143,  2144,  2337,  2145,   509,
    4438,  3956,  2879,  2338,  2879,  2535,   471,  3957,   837,   207,
    2360,  4439,  1514,   976,  2880,  1881,    45, -2038,  2683,  2687,
    2688,  2689,  2690,  2691,  2692,  2693,  2694,   866,   866,   866,
    1515,  3956,   932,   505,   853,   681,   444,  3957,   985,   844,
    3061,   992,   472,  1942,  1312,  2787,  1007,  4475,  4476,   506,
      52,  4125,  4440,  1111,  3996,   862,  2721,  1638,  2710,   186,
    2710,   832,    71,   832,  4408,  2361,   208,  4409,  2342,   209,
     507,    52,   510,   510,   736,   737,  4126,  4127,  4128,  2146,
    2147,  3077,   186,  1204,  2921,  1567,   860,   832,  1205,   967,
    2464,  3912,  1204,  1567,   860,  2465,   510,  1205,   917,  3531,
    3913,  1120,  1639,   472,  2410,   171,  2767,    -6,  2932,   918,
   -1330,   832,  2879,  2879,  2660,  2770, -2038,  2217,   207,  2536,
    2015,   726,  2956,  2957,   967,   866,    46,  1204,  3261,    50,
    1112,  4410,  1205,  1113, -2038,   862,   181,  3382,  2533,  4282,
    4287,  2536,  2893,   186,  3331,   444,  1114,  3404,  4279,  4269,
     860,    54,   860,  4270,  2747,  3834,  3258,   682,  2193,   727,
    4407,  2845,  3270,  2847,  2794,  2407,  1224,  1204,  1640,  2194,
      56,  2807,  1205,  1204,  4416,  4418,   728,  1115,  1205,    57,
     837,  4443,    61,  3578,  3579,  1516,  4445,  2185,  3456,  3457,
    3458,    62,   508,  1803,  1806,  1809,  2828,  1526, -3109,   120,
    1567,  4159,  1976,  1977,  4458,  2682,  2432,   507,  2433,  1943,
    4165,  1567,  2209, -2792,   860,   534,   860, -2792,  4168,  1836,
     208,   476,  4468,   209,  2510,  3246,  4477,  3543,  3262,  2894,
    2895,  2961,    72,  4311,  1204,  1842,  1843,  1844,  2432,  1205,
    2433,   188,  3247,  4500,  1204,  4501,  3248,  4502,  3388,  1205,
     119,  2242,  3389,  1978,  1979,  1252,  2781,   122,  1244,  2330,
    2148,  2149,  2150,  2151,  2152,  2153,  2154,  2155,  2156,  2854,
     509,  4441,  3212,  2854,  2814,  4403,  4503,  2926,   833,   833,
    3073,  4331,  4332,   832,  2683,   124,  2683,  4336,   126, -2038,
    4376,  4413,  1944,  1945,  4377,  4378,   860, -1794,  2809,   127,
    1199,  1988,  1202,  4421,  1116,  2404,  2405,  3459,  3460,   128,
    3461, -2977,  4068,  4422,  4423,  2962,   134,  2821,   135, -3109,
    1990,  1991,  1992,   141,    73,   142,  2830,  2831,    74,   508,
     143,  3342,  4139,  4140,   145,  3997,   156,  3301,  1995,   146,
    2902,   967,   967,   158, -3109, -3109, -3109,   967,   967,   967,
     967,  4157,   168,   186,  3998,   967,  3292,   967,   165,   967,
     170,  4157,  2440,  4381,   175,  2484,   177,   510,  2486,  1946,
    1947,  3999,  2851,  2852,  3005,   178,  2492,    33,    34,   186,
    2496,   189,  2949,   197,  1840,  1841,  4281,  2499,  4424,   201,
      52,  2157,   188,   216,  2683,  2683, -2725, -2725, -2725, -2725,
    1274,  1275,  1276,  1277,  1641,  2887,  2888,   509,  2877,   866,
    4425,  4426,   217,   218,  2898,  2883,  2900,   866,  3595,  1816,
    1817,   220,  2903,  2904,  2905,  3404,  1117,  1642,   221,  2910,
   -2724, -2724, -2724, -2724,   729,   730,   227,  1948,   228,    75,
    2922,  2923,   229,   232,  1918,  1919,  1920,  1921,  2754,  2756,
    2758,  2760,   252,   257,   967,  3685,   256,   967,   780,   439,
    2963, -2977, -2977,   503,   967,   967,   967,   967,   446,   262,
     480,  1949,   481,   866,   489,   866,   490,   497,    76,  2527,
    1950,  3799,  3800,   514,   518,   639,  2926,  3662,   523,  1951,
     662,   691,   702,   732,   747,  3462,  3463,   703,   715,   748,
     717,   207,   753,   760,   510,   503,   754,   762,  1530,   761,
    1887,   764,   260,   769,   770,   868,   914,   925,   939,  3464,
    3539,   976,   948,  3431,    77,   984,    78,  1126,   444,  1069,
    1952,  2158,  1034,  1070,  1071,  1077,  1083,   866,  1099,   866,
    1089,  1101,  1106,  1108,  1131,  3465,   833,  1134,   833,  1144,
   -1794,  1150,  1165,  1167,  2159,   860,  1530,   860,    79,  1127,
    1128,  1169,  1172,  1173,  1174,  1176,  1179,  1180,  1181,  1182,
    3466,  1185,   833,  1187,  1195,  2682,  1208,  1215,  1197,  1198,
    1217,  1235,  1229,  3859,  3860,  3861,  1242,  1246,  1244,  2407,
    2407,  1254,  2407,  2407,  2845,  2964,   833,  1256,  1249,   781,
    1251,  1120,  1258,   860,  1269,   782,   783,  -951,    80,  1283,
    1278,  3599,  1282,  1284,  4068,   784,  1308,  1310,  1313,   866,
    1315,   785,  1643,  1495,  1505,  1508,  1509,  1644,  1511,  1533,
    1534,  1541,  1536,   967,  1546,  1548,  1560,  1551,  1552,  1010,
    1556,   781,  1558,  1568,  1645,  1572,  1646,   782,   783,  1579,
    1581,  1593,  1595,  -951,  1597,  4382,  1603,  1610,  1614,  1616,
    3223,  1619,  1627,   785,  1628,  -951,   860,  1629,  3467,  1633,
    1634,  1635,  1637,  1678,  1692,  1720, -1794,  1703,   181,  3854,
    3855,  1771,  2019,  1802,  1812,  1813,    81,  1823,  4382,  1824,
    1833,  1838,  1845,  1847,   838,  1860,  1865,  4358,  2965,  3128,
    3520,  3468,  3521,  1260,  1872,  3469,  3470,  1261,  1915,  1917,
    1929,  -951,  2683,  1963,  1969,  1982,  1484,  2008,  2012,  2127,
    2131,  2139,  2168,  2010,  2134,  3166,  2169,  3590,  3981,  3982,
     188,  3471,  2171,  2176,  -951,  2179,  2186,   188,   476,  2187,
    2196,  2189,  2221,  2223,  2224,  2229,  2237,  2231,  2239,  2246,
    1953,  2245,  2247,  2334,  1954,  3296,  1955,  2640,  2346,  2348,
    2353,  1532,  2249,  2413,  3202,  2429,  2439,  3203,   833,  3204,
    3205,  3005,  2421,  2440,  3211,   476,  3214,  3215,  3216,  3217,
    2458,  4073,  2407,   967,  2460,  2461,  3224,   786,   787,   788,
    2463,  -951,  2467,  2475,  2473,  2474,  2468,  2477, -2678,   789,
    3949,  1647,  2471,  2485,  2666,  2487,  1526,  2493,  2494,  3238,
    2495,  2497,  2500,  2517,  2525,  2511,  2513,  2528,  2519,  2529,
    2573,  2541,  2575,  2576,  2587,  2578,   504,  2589,  2682,   786,
     787,   788,  2598,  2602,  2610,  2611,  2632,  2639,   980,  2668,
    2669,   789,  2654,  2678,  3253,  2714,  2685,  2707,   186,  3891,
    2719,  2723,  4080,  2722,  1526,  3670,  2732,  2735,  2714,  2737,
    2740,   860,   967,   860,  2745,  2741,  2742,  2761,   504,  2746,
    2764,  1648,  -951,  2771,  2774,  2793,  2776,  2798,   866,  2808,
     866,   258,  2819,  2832,   790,   791,   792,  2833,  2835, -2769,
    1530,  2884,  1530,  3472,   793,  2834,   794,  1765,  3738,  3739,
    2901,  2503, -2756,   505,  2502,  2930,  2535,   795,   796,   797,
    2536,  3132,  2954,  2983,  2984,  2990,   798,  2994,  3016,   506,
    2995,  3002,  3007,  3015, -2749,  3021,   866,  3037,   792,  3038,
    2660,  2659,  3064,  3090,  3093,   799,  3095,  3097,  3104,  3083,
    3105,  3108,  3113,  -951,  3114,   505,  3129,  1530,  3131,   795,
     796,   797,  3157,  3160,  3173,  3162,  3163,  3133,   798,  3168,
    3177,   506,  3179,  3182,  3184,  3186,  3235,  3189,  3226,  3134,
    3228,  3239,  3241,  3243,  3252,  3256, -2683, -2754,  3260,  3233,
    3284,  2682,  2407,  3286,  3299,  3305,  3008,  3009,  3312,   866,
    3314,  3319,  3425,  3324,  2829,  3866,  3321,  3338,  3343,  4187,
     800,  3344,  3048,  3358,  3049,  3361,  3078,  3079,  3373,  3393,
    3398,   686,  3399,  3438,  3418,  3135,  1082,  3416,  3427,  3421,
    3444,  3807,  3423,  -951,  3428,  3430,   801,  3492,   147,  3408,
    3489,  3501,  3824,  3394,  1665,  3694,  3502,  3369,  3136,  3495,
    3496,  3505,   800,  3517,  3507,  3532,  3533,  3540,  3542,  3561,
   -3128,  3556,  3563,  3454,  3570,  -951,  3571,  3296,  3382,  3478,
    3575,  3381,  3493,  3591,  3481,  3482,  3606,  3499,  3602,  3601,
    3607,  3604,  3485,  3610,  3487,  3623,  3624,   507,  3649,  3651,
    3652,  3686,  2683,  4073,  3689,  3723,   188,  3716,  3695,  3923,
    3726,  3687,  3734,  3736,  3733,  3137,  3750,  3777,  3758,  3779,
    3679,  2682,  3448,  3448,  3680,   188,  3815,  3816,  3879,  3829,
    3740,   188,  3828,  3701,   188,  3851,   188,   188,  3850,   507,
    3782,  3874,  3871,  3881,   188,  3872,   188,   802,  3856,   188,
    3899,  3905,  3909,  3916,  3887,  3890,  3921,  3953,  3959,  3960,
    3962,  3963,  3927,  3924,  3926,  4373,  3990,  3993,  3992,  3991,
    4017,  4082,  4089,   967,  -951,  4116,  4119,  4110,  4120,  4123,
    3455,  4129,  4132,  1530,  3809,  3951,  4143,  4133,  4144,   802,
    1530,  2452,  4171,  4167,  4192,  4333,  3138,  4436, -2847,  3486,
    4136,  3490,  4379,  4489,   866,  4493,   866,  4435,  1526,  4491,
    1526,  3950,  4492,  3500,  1567,  4505,  4498,    21,   112,   508,
     110,   164,   767,   152,   488,  4312,   279,   500,   155,   522,
    3920,  1685,   280,  1130,   282,  3901,   745,  2626,  3547,  3769,
     503,  4179,  3213,  3753,  3847,   803,   804,  -951,   741,  3221,
    2445,  -951,  3115,  3232,  3751,  3449,  3994,  3628,  4121,  4134,
     805,   508,  2642,  2782,  4352,  1526,  1076,  3140,  2252,  3920,
    3603,  3019,  3172,  4479,  3836,  3897,  4088,  2631,  3947,  3183,
    4230,  4310,  4442,  4444,  3827,  4245,  3946,   803,   804,   968,
    4174,  1989,  1504,  4160,   779,  4288,   835,   509,  4161,   852,
    4172,  4164,  3047,  2426,   875,  3240,   910,  3524,  1518,   438,
    2401,  1567,   995,  3254,  2407,   806,  1705,  3250,  3564,  2515,
    2767,  1759,  2453,  3622,   956,   959,  2927,  -951,  1711,   956,
    1214,  3509,  3522,  3865,  3863,  1854,   988,   913,  1871,   509,
    2551,  1220,   807,  3529,  1265,  2569,  3269,  3141,  1273,  3499,
     808,  1033,  2940,  3639,   969,  2683,  1930,   806,  1927,  2989,
    3291,  1311,   188,  2594,  3530,  1055,  3298,  1061,  1064,  3297,
    1981,  2007,  3013,  3309,   809,   188,  2612,  2666,  3308,  3143,
     186,  3672,  3798,   912,   807,  2011,  2644,  -951,  3555,  3340,
    3814,  2656,   808,  3627,   510,   942,  3044,  3715,  3347,  3357,
    1512,  3609,  3355,  3099,  2182,   188,   973,   975,  3063,  2695,
    1029,  3076,   188,  2729,  2220,  3376,   809,  2730,  3970,  3813,
    2672,  3718,   186,  1569,  1570,  2655,   967,  3796,  4092,  4191,
    4107,  2240,  2869,  2863,  4108,  3986,   510,  3984,  3868,  3804,
    3802,  2915,  1880,  2917,  3380,  3368,  1878,  3366,  3697,  3583,
    3581,  2938,  3387,  3425,  1171,  2936,  2407,  1219,  3747,  1938,
    1937,  3645,  1022,  2590,  3069,  1567,  3070,  -951,  3071,  1066,
    3752,  1555,  3072,  2595,  3442,  1849,  3188,   285,  3944,  3668,
    3692,  1526,  2684,  2614,  3304,  4163,  1852,  3092,  1526,  2850,
     765,  1133,  4247,  1200,  1200,  1200,  1186,  2254,  3844,  2702,
    2931,  3181,  3371,  3812,  4384,  3275,  3573,  3755,  2683,  2792,
    4271,  1168,  3659,  4405,  4467,   517,  3684,  3323,   768,   852,
    3445,  2566,  3116,  2709,  4273,  -951,  1719,  4083,  2340,  2846,
    3484,   188,   188,  4429,     0,  4276,  2175,     0,     0,     0,
       0,     0,     0,  3754,     0,     0,  1248,     0,  3823,  3756,
       0,  3145,     0,     0,     0,  3146,     0,     0,  1191,     0,
       0,     0,     0,     0,     0,  3724,     0,     0,     0,   188,
       0,     0,     0,     0,     0,  4388,     0,     0,     0,   967,
       0,  3869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4277,     0,     0,
       0,     0,     0,   504,   844,     0,  3832,  3833,     0,  3757,
    4294,     0,     0,     0,  1530,     0,     0,     0,     0,     0,
    3771,  3772,  1320,     0,     0,  3775,  3776,     0,  2683,  3846,
    3846,  3147,  1491,  1493,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3690,   844,  3915,     0,     0,     0,  3797,
       0,     0,  1528,     0,  1191,     0,     0,     0,   188,   188,
    3806,   790,   791,     0,     0,     0,     0,     0,     0,     0,
    1306,     0,     0,  4246,     0,  3906,  3907,  3336,  1565,     0,
     505,   188,   188,     0,     0,     0,     0,  3965,     0,  3348,
    3817,  3148,     0,     0,     0,     0,   506,     0,     0,   967,
       0,     0,     0,     0,  1200,  2780,     0,     0,  3830,     0,
    1601,     0,     0,     0,     0,     0,     0,  1507,     0,     0,
       0,     0,     0,     0,     0,     0,   844,     0,     0,     0,
       0,     0,     0,  1618,     0,     0,     0,  1623,  1625,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3392,     0,     0,     0,     0,   836,     0,     0,   188,
       0,   867,     0,     0,     0,     0,     0,  4480,     0,     0,
       0,  3151,  3954,     0,   867,     0,     0,     0,  1589,     0,
       0,     0,   867,     0,     0,  1600,     0,     0,     0,  1191,
    3117,     0,     0,  4078,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   867,     0,     0,     0,     0,     0,
       0,  3896,     0,     0,     0,     0,     0,  3904,  4081,     0,
       0,     0,     0,     0,   188,     0,  2174,     0,   967,  3153,
    3908,     0,     0,     0,     0,  1769,  1770,     0,     0,     0,
       0,     0,  1200,  1200,  1200,     0,     0,     0,     0,  1200,
    1200,  1200,  1819,     0,   507,  1819,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1200,     0,  1819,  1200,     0,
     188,     0,     0,     0,  1200,  1200,  1200,  1200,  1200,     0,
       0,   837,   837,     0,     0,     0,     0,     0,     0,  1061,
       0,  1853,     0,     0,     0,  3971,     0,     0,     0,     0,
    4166,     0,     0,     0,  1200,  3989,     0,     0,     0,  1200,
       0,   837,  1526,     0,     0,     0,  4025,  4074,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   837,
       0,     0,     0,  4086,  4087,  1830,     0,     0,     0,     0,
       0,  1913,     0,     0,     0,  1193,     0,     0,  4093,     0,
       0,     0,     0,   836,   836,   836,     0,     0,  2407,  4194,
       0,  4109,     0,  1210,  4112,  4113,  4114,  4115,     0,     0,
       0,     0,     0,     0,     0,     0,   508,     0,     0,  3336,
       0,     0,     0,   837,   832,   832,     0,     0,     0,     0,
    4225,   867,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4151,     0,     0,     0,     0,  4237,     0,
       0,     0,  4158,  1191,   832,  4162,     0,  4244,     0,     0,
       0,     0,     0,     0,     0,     0,  1922,  1924,     0,     0,
       0,     0,   832,     0,     0,     0,     0,  3587,     0,     0,
       0,  3118,     0,  3119,     0,     0,     0,     0,     0,  1306,
       0,     0,  3120,  3121,   509,     0,  3122,  3123,     0,     0,
       0,     0,     0,     0,     0,   867,     0,     0,     0,     0,
       0,   967,     0,     0,     0,     0,     0,   867,   967,     0,
       0,     0,   967,     0,     0,   967,   832,     0,     0,  3617,
    4199,  4200,  4201,  4202,  4203,     0,     0,  4205,  4206,  4207,
    4208,  4209,  4210,  4211,  4212,  4213,  4214,  4215,     0,     0,
    4217,     0,     0,     0,     0,     0,     0,     0,  4229,     0,
       0,     0,  4225,  1772,  1773,     0,     0,     0,     0,  4233,
       0,  4234,  3132,     0,     0,     0,     0,     0,  1566,     0,
       0,  4242,     0,     0,     0,     0,     0,  3655,   867,     0,
       0,   510,     0,     0,     0,   867,     0,     0,     0,     0,
       0,     0,     0,     0,   836,  1200, -3068,     0,     0,     0,
    4225,  4225,     0,     0,     0,     0,  4225,     0,  3133,  4225,
       0,     0,     0,  4225,  4225,     0,     0,     0,     0,     0,
    3134,     0,     0,  4386,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   967,     0,     0,   967,
       0,     0, -3068,     0,     0,  1774,  2173,     0,  4404,  4074,
       0,     0,  1775,     0, -3068,  1776,     0,     0,  2181,     0,
    2183,  3587,     0,     0,  4414,     0,  3135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4225,     0,     0,
       0,  4404,  4225,     0,     0,     0,     0,  2130,     0,  3136,
       0,     0,  4452,  1200,     0,     0,     0,  2219,     0,     0,
   -3068,     0,     0,     0,  4321,  4322,     0,  4327,     0,  1777,
    1565,  1778,  1779,     0,     0,     0,     0,  3766,  3768,  3766,
       0,     0,     0, -3068,  4330,     0,     0,     0,     0,  4334,
    4335,     0,   836,   836,   836,     0,     0,     0,     0,   836,
     836,   836,  1820,     0,     0,  1820,  3137,  4385,     0,  1832,
    4387,     0,  2195,  4389,     0,   836,     0,  1820,   836,     0,
       0,     0,     0,  2210,   836,   836,   836,   836,   836,     0,
       0,     0,  4504,     0,  1600,     0,     0,     0,     0,     0,
   -3068,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1780,   836,  1781,     0,     0,     0,   836,
       0,     0,  1782,     0,     0,  1153,     0,     0,     0,     0,
    1783,     0,  3170, -3127, -3127, -3127, -3127,     0,     0,     0,
   -3127,     0,     0,     0,     0,     0,     0,  3138,     0,  3842,
       0,  1914,     0,     0,     0,  3842,     0,     0, -3127, -3127,
       0,  1832,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3068,     0,     0,  1769,     0,     0,     0,  2257,  2258,
    2259,  2260,  2261,     0,  2262,  2263,     0,     0,     0,     0,
    1565,     0,     0,     0,     0,     0,     0, -2977, -3127,     0,
    3139, -2977,     0,     0,     0,     0,     0,     0,  3140,   833,
     833,     0,  2483,     0,     0,     0,     0,     0,     0,     0,
       0,  1819,     0,     0,     0,     0,     0,  1784,     0,     0,
       0,     0,     0,     0, -3068,     0,     0, -3127,     0,   833,
       0,     0, -3068,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   833,     0,     0,
       0,     0,  2265,     0,  2266,  2267,  2147,  2268,  2269,  2270,
    2271,  2272,  2273,     0,     0,     0,     0,  1785,     0,     0,
       0,  1786,     0,     0,     0,     0,     0,     0,  3141,     0,
       0,     0,     0,     0,     0,  3142,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   833,     0,     0,     0,     0,     0,  1010,     0,     0,
    3143,  1913, -3068,     0,     0,  2570,     0,     0,  4026, -3068,
       0,     0,     0,     0,  2274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3766,     0,     0,     0,  3144,     0,
       0,     0,     0,  1997, -3068, -3127,     0,     0,     0,  1191,
       0,     0,     0,     0,     0,   836,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   867,     0,
       0,  1832, -3068,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2605,     0,     0,  2606,     0,
    2607,  2608,  2609,     0,     0,     0,     0,     0,     0,     0,
       0,  2580, -3127,     0,     0,     0,  2623,     0,     0,     0,
    2624, -2553,  2625,     0,     0,     0, -2553,     0,  2634,     0,
   -2553, -2553, -2553,     0,     0,     0,     0,     0, -2553,  2581,
       0,   867,     0,     0,     0,     0,  2275,  2276,  2277,  2278,
    2279, -3127,     0,  2155,  2280,     0,  1089,     0,     0,     0,
       0,     0,     0,   836,     0,     0,     0,     0,     0,  3766,
       0,     0,     0,     0,     0,  1832,     0,     0,     0,     0,
    1566,     0,     0,     0,     0,     0,     0,     0,     0,  2281,
       0,     0,  3145,     0,     0,     0,  3146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2282,     0,     0,     0,     0,     0,     0,
       0,     0, -2977,     0, -2553,     0, -3068,     0,     0,     0,
   -3068,     0,     0,  1787,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3127,  1528,     0,     0,  2652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2553,  1156,     0,     0,     0,     0, -2553, -2553,
       0,     0,  3147,     0,     0,     0,     0,     0,     0,     0,
       0,  2657,     0,     0, -2553,     0,  2658,     0,     0,     0,
   -3127,     0,     0,     0,     0,  2676,  1565,   780,     0,     0,
       0,     0,   503,     0,     0,     0, -3068,     0,     0,     0,
       0,     0,     0,     0,  1292,     0,     0,  1788,     0,     0,
       0,  2285,     0,     0,     0,     0,  1200,  1200,  1789,     0,
       0,     0,  3148,  2716,     0,     0,     0,     0,     0,  1790,
       0,  2728,  2728,     0,     0,     0,  3149,     0, -3127,  2734,
    1566,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3068,     0,     0,     0,
    3150,     0, -2977, -2977,     0,     0,     0,     0,     0,     0,
   -3068,  1820,  2686,     0,     0,     0,     0,     0,     0,     0,
   -2553,     0,     0,     0,     0,     0,  2287,     0,     0,   867,
       0,     0,     0,   867, -3068,     0,     0,     0, -2553,     0,
    1791,     0,  3151,     0,     0,     0,     0,  2289,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   781,     0,
    2290,     0,  1792,     0,   782,   783, -3068,     0,     0,     0,
   -2553, -2553, -2553, -3127,     0, -3127, -3127,     0,  3152,     0,
     785,     0, -2553,     0,     0,     0,     0,     0,     0,     0,
    3153,     0,     0, -2553, -2553, -3127,  3154,     0,  3155,     0,
   -3127,  1914,     0,     0,     0,     0,     0,     0,     0, -2553,
       0,     0, -3068,   867,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3068,     0,     0,     0,     0,     0,
   -3068,     0, -3068,     0,     0,     0,     0,     0, -3127, -2553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3127,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2867, -2553, -2553, -2553,
   -2553, -2553,     0,     0,     0,     0,     0, -2553,     0, -2553,
       0,  2294,  2295,  2296,     0,     0, -2553,     0,     0,     0,
   -2553, -2553, -2553,  1769,     0,  1997,  1566,     0,     0, -2553,
       0,     0, -2553,     0,  1293,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1200,     0,  1200,     0, -2553,     0,
       0,     0,     0,     0,     0,     0,  1819,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2553,     0,
    1200,     0,     0,  2925,     0,     0,   786,   787,   788, -3127,
       0,     0,     0,     0,     0,     0,     0,     0,   789,     0,
       0,     0, -2553,  1881,  1200,     0,     0,     0,     0,     0,
       0,   852, -2553,     0,     0,     0,     0,     0,     0,     0,
       0, -2553,     0, -2553,     0,   504,     0,     0,     0,     0,
   -2553,     0,     0,     0,     0,     0, -2553,     0,     0,     0,
       0,  2299,  2300,  2301,     0,     0,   476,     0,     0, -2553,
       0,     0,     0,     0,     0,  1294,     0,   867,   867,   867,
       0,     0,     0,     0,     0,     0,  2992,     0,     0,     0,
       0, -2553,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1565,     0,   790,   791,   792,     0,     0,     0,  2623,
       0,     0,     0,   793,  3171,   794,     0,     0,     0,     0,
   -2553,     0,   505,     0,     0,     0,   795,   796,   797,     0,
       0,     0,     0,  3032,     0,   798,  1566,     0,   506,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   799,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   836,   836,     0,     0,
   -2553,     0,     0,     0,     0,   867,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3068,     0,
       0,     0,     0,     0,     0,     0,  1200,     0,  1295,     0,
       0,     0,  1191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2925,     0,     0,     0,  1565,     0,     0,   800,
       0,     0,     0,     0,     0,     0,     0,  1565,     0,     0,
       0,     0,  1296,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2553,     0,     0,   801,  1888,  1889,  1890,  1891,
       0,  3066,     0,  1892,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2553, -2553,
       0,  1893,  1894,     0,  3075,  3075,     0,     0,     0,     0,
       0,  3086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   780,     0,     0,     0,   507,   503,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2553,     0, -2553,
       0, -2553,     0,  2582,     0, -2553,     0, -2553, -2553, -2553,
   -2553,  1895, -2553, -2553,  2583,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2553,     0,
       0,     0,     0,     0,     0,     0,   802,     0,     0,   943,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2553,
    1896,     0,     0,     0, -2553, -2553,     0,   852, -2553, -2553,
   -2553,     0,  2867, -2553,     0,     0, -2553,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2553,     0,     0,
       0,     0,     0, -2553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2553,   508,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   781,   836,     0,   836,     0,     0,   782,
     783,     0,     0,     0,   803,   804,  1820,     0,     0,     0,
       0,     0,     0,     0,     0,   785,     0,     0,     0,   867,
     836,     0, -2553,     0,     0,     0,     0,   867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1897,     0,
       0,  3295,     0,  1297,   836,  1298,     0,     0,     0,     0,
       0,     0,     0,     0,  1299,  1300,   509,     0,  1301,  1302,
   -2553,     0,     0,     0,     0,     0, -2553, -2553,     0,     0,
       0,  3268,     0,     0,   806,     0,     0,     0,     0,     0,
       0,     0, -2553,   867,     0,   867,     0,  2652,     0,     0,
       0,     0,     0,     0,     0,  1898,     0,     0,     0,     0,
       0,   807,     0,     0,     0,  1661,     0,     0,     0,   808,
    -255,     0,     0,  -255,     0,     0,     0,     0,     0,     0,
       0,  1566,   883,     0,     0,     0,     0,     0,     0,  1566,
       0,  -255,     0,   809,  1899,     0,     0,     0,     0,   186,
       0,     0,     0,     0,  -255,     0,     0,   867,     0,   867,
       0,     0,  2354,   510,     0,  2355,     0,     0,     0,     0,
       0,  -255,     0,     0,  3341,     0,     0,     0,     0,     0,
       0,     0,     0,  2356,     0,   884,     0,     0,     0,     0,
       0,   786,   787,   788,     0,     0,  2357,     0, -2553,   780,
       0,     0,     0,   789,   503,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2647, -2553,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   836,     0,     0,     0,
     504,     0,     0,     0,     0,   852,  -255,  1900,     0,   867,
       0,     0,   885,     0,     0,     0,  1566,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1566, -2553, -2553,
   -2553,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2553,     0,     0,     0,     0,     0,     0,     0,   490,     0,
       0, -2553, -2553,  2552,     0,     0,     0,     0,   790,   791,
     792,     0,     0,     0,     0,     0,     0, -2553,   793,     0,
     794,     0,     0,     0,     0,     0,     0,   886,     0,     0,
       0,   795,   796,   797,     0,     0,     0,     0,     0,     0,
     798,     0,     0,   506,     0,     0,     0, -2553,     0,     0,
       0,     0,     0,  3515,     0,     0,   887,     0,     0,   799,
     781,  1901,     0,     0,     0,     0,   782,   783,     0,     0,
       0,     0,     0,  3295,     0, -2553, -2553, -2553, -2553, -2553,
       0,     0,   785,     0,     0, -2553,     0, -2553,     0,     0,
    3537,     0,     0,     0, -2553,     0,     0,     0, -2553, -2553,
   -2553,     0,  1888,  1889,  1890,  1891,     0, -2553,     0,  1892,
   -2553,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3511,  3512,  3513,  3514,   800,     0, -2553,  1893,  1894,     0,
       0,   888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -255,  -255,     0, -2553,     0,     0,  3572,
     801,     0,     0,     0,     0,     0,     0,  3576,     0,  3577,
       0,     0,  3535,  3536,     0,     0,  1746,     0,  1747,  1748,
   -2553,     0,     0,     0,     0,     0,     0,  1895,     0,     0,
   -2553,     0,     0,     0,     0,  2358,  2359,     0,  1902, -2553,
   -3127, -2553,     0,  1903,     0,     0,     0,     0, -2553,     0,
       0,   507,     0,     0, -2553,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1896, -2553,   867,     0,
     867,     0,     0,     0,     0,     0,     0,  -255,     0,     0,
       0,  1904,     0,     0,     0,     0,     0,     0,     0, -2553,
       0,     0,     0,  1905,     0,     0,     0,     0,   786,   787,
     788,   802,     0,     0,     0,     0,     0,     0,     0,     0,
     789,     0,   647,     0,     0,     0,   867,     0, -2553,  2360,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -255,     0,     0,     0,     0,   504,     0,     0,
       0,     0,     0,     0,     0,     0,  3663,     0,  -255,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2553,  3675,
    3678,     0,     0,   508,  2361,     0,     0,   889,     0,   867,
       0,     0,     0,     0,  1897,     0,     0,     0,     0,     0,
    -336,  3693,  1906,     0,  3696,   790,   791,   792,     0,   803,
     804,     0,   890,     0,     0,   793,     0,   794,     0,     0,
       0,  -255,     0,     0,   505,     0,     0,     0,   795,   796,
     797,     0,     0,     0,     0,     0,     0,   798,     0,  3735,
     506,     0,     0,     0,     0,     0,     0,     0,  3671,     0,
   -2553,  1898,     0,     0,     0,     0,   799,   891,     0,     0,
       0,   509,  -255,  2362,     0,     0,     0,     0,     0,     0,
    -255,     0,     0,     0,     0,     0, -2553, -2553,     0,   806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1899,     0,     0,     0,     0,     0,     0,     0,     0, -3127,
       0,     0,     0,     0,  2363,     0,   807,     0,     0,     0,
       0,     0,  2364,  3675,   808, -2553,  3678, -2553,     0, -2553,
       0,   800,     0, -2553,     0, -2553, -2553, -2553, -2553,     0,
   -2553, -2553,     0,     0,     0,  -255,     0,     0,   809,     0,
       0,     0,   892,     0,   186,     0, -2553,   801,     0,  -255,
       0,     0,     0,     0,     0,     0,     0,     0,   510,     0,
    1565,     0,     0,     0,  -255,     0,     0,     0,     0,     0,
       0,     0,     0, -2553,     0,     0,     0,  2365,     0,     0,
    3794, -2553,     0,  1900,   867,     0,   867,     0,     0,     0,
       0,  2366,     0,     0,     0,     0,     0,     0,   507,     0,
       0,     0,     0,     0,     0, -2553,  2367,     0,     0,     0,
       0, -2553,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -255,  -255,     0,     0, -2553,     0,  -255,  3281,     0,
       0,     0,     0,  3867,     0,     0,     0,     0,     0,     0,
       0,  -255,     0,     0,     0,     0,   648,     0,   802,     0,
       0,     0,     0,     0,     0,     0,     0,  1565,     0,     0,
    -255,     0,     0, -2991,     0,     0,     0,     0,     0,  2368,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2369,     0,     0,     0,  1901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   781,     0,     0,
       0,     0,  -333,   782,   783,     0,  3910,     0,     0,     0,
       0,  3911,     0,     0,  -255,     0,     0,     0,  -255,   785,
     508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -255,  -255,   503,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,   804,     0,     0,
       0,     0,     0,     0,     0,     0,  2370,     0,     0,     0,
    2371,     0,     0,  3974,  3979,     0,     0,     0,     0,     0,
       0,     0,     0, -1622,     0,     0,  2372,  2373, -1622,  4004,
    4015,     0,     0,     0,  4077,     0,     0,     0,     0,     0,
       0,     0,  1746,     0,  1747,  1748,     0,     0,   509,     0,
       0,     0,     0,     0,  1518,     0,     0,     0,     0,     0,
       0,  1565,  3974,     0,  1902,     0,   806,  3979,     0,  1903,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4111,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   807,  4122,  2229,     0,     0,     0,     0,
       0,   808,     0,     0,     0,  4135,     0,  1904,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4150,     0,  1905,
       0,     0,   781,     0,     0,   809,     0,     0,   782,   783,
     476,   186,  2173,     0,     0,   786,   787,   788,     0,     0,
       0,     0,     0,     0,   785,   510,     0,   789,     0,  4169,
       0,     0,  4170,     0,  1888,  1889,  1890,  1891,     0,     0,
       0,  1892,     0,     0, -1622,     0,     0,     0,     0, -2985,
   -1622, -1622,     0,   943,     0,     0,     0,     0,     0,  1893,
    1894,     0,     0, -2553,     0,     0, -1622,     0, -2553,     0,
       0,     0, -2553, -2553, -2553,     0,     0,     0,     0,  4193,
   -2553,     0,  4195,  4196,  4197,  4198,     0,     0,     0,     0,
       0,     0,  4204,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,     0,     0,     0,  4216,     0,     0,     0,  1895,
       0,  4224,   790,   791,   792,     0,     0,  4150,  4150,     0,
    3808,     0,     0,     0,     0,     0,     0,     0,     0,  2867,
       0,  3418,     0,     0,     0,   795,   796,   797,  2867,     0,
       0,     0,     0,     0,   798,     0,     0,     0,  1896,     0,
    1566,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2553,     0,     0,  4249,
    4250,  4251,  4252,  4253,  4254,  4255,  4256,  4257,  4258,  4259,
    4260,  4261,  4262,  4263,  4264,  4265,  4266,  4267,     0,  1519,
     786,   787,   788,     0,     0,     0,     0,     0,     0,   852,
    4150,     0,   789,     0, -2553,     0,     0,     0,     0,     0,
   -2553, -2553,   852,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4297,     0, -2553,     0,   800,   504,
       0,     0, -1622, -1622, -1622,     0,  4298,     0,     0,     0,
       0,     0,     0,  4224, -1622,     0,     0,  1566,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1897,  4316,  4317,     0,
       0, -1622,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4329,   790,   791,   792,
       0,  4224,  4224,     0,     0,     0,     0,  4224,     0,  4375,
    4224,     0,     0,     0,  4224,  4224,  1520,     0,     0,     0,
     795,   796,   797,     0,     0,     0,     0,     0,     0,   798,
    4390,     0,   506,  1898,     0,     0,     0,     0,     0, -1622,
   -1622, -1622, -2553,     0,     0,     0,     0,     0,     0, -1622,
       0, -1622,     0,     0,     0,  4406,     0,     0, -1622,     0,
   -2553,     0, -1622, -1622, -1622,   802,     0,  1200,  1200,     0,
       0, -1622,  1899,     0, -1622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4451,     0,     0,     0,
   -1622,     0,     0,     0,     0,     0,     0,  1200,     0,     0,
       0,     0, -2553, -2553, -2553,     0,     0,     0,     0,     0,
       0,  1566,     0,   800, -2553,  1200,     0,  4473,  4473,     0,
       0,     0,     0,     0,     0, -2553, -2553,     0,     0,     0,
       0,  4478,     0,     0,     0,     0,  4481,     0,     0,     0,
       0, -2553,     0,     0,     0,     0,  4484,  4488,     0,     0,
       0,     0,  4473,     0,     0, -1622,     0,     0,     0,     0,
    4497,     0, -1622,   803,   804,  1900,     0,     0,     0,  1200,
       0, -2553,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1622,     0,     0,     0,     0,     0,     0,     0,     0,
     507,     0,     0,     0,     0,     0,     0,     0,     0, -2553,
   -2553, -2553, -2553, -2553,     0,     0,     0,     0,     0, -2553,
       0, -2553,     0,     0,     0,     0,     0,     0, -2553,     0,
       0,     0, -2553, -2553, -2553,     0,     0,     0,     0,     0,
       0, -2553, -1622,   806, -2553,     0,     0,     0,     0,     0,
     802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2553,     0,     0, -2985,     0,     0,     0,     0,     0,     0,
     807,     0,     0,     0,     0,     0,     0,     0,   808,  1901,
   -2553,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   809,     0, -2553,     0,     0,     0,   186,     0,
       0,     0,     0,     0, -2553,     0,     0,     0,     0,     0,
       0,     0,   508, -2553,     0, -2553,     0,     0,     0,     0,
       0,     0, -2553,     0,     0,     0,     0,     0, -2553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   803,   804,
       0, -2553,     0,     0,     0,     0, -1622,     0,     0,     0,
       0,     0,     0,     0, -1622,     0,     0,     0,     0,     0,
       0, -3127,     0, -2553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1746,     0,  1747,  1748,     0,     0,
   -1622, -1622,     0,     0,     0,     0,     0,     0,     0,     0,
     509,     0, -2553,     0,     0,     0,  1902,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,   806,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2085,     0,     0,     0,     0,
       0,     0, -1622,     0,     0,   807,     0,     0,     0,  1904,
       0,     0, -2553,   808,     0,     0,     0,     0,     0,     0,
   -1622,  1905,     0,     0, -2085,     0,     0,     0,     0,     0,
       0, -1622,     0,     0,     0,     0,     0,   809,     0,     0,
       0,     0,   476,   186,     0,     0,     0, -1622,     0,     0,
       0,     0,     0,     0,     0, -1622,     0,   510,     0,     0,
       0,     0, -2985,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1622,
       0,     0,     0,     0, -2553, -1622,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   836,   836, -1622,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2553, -2553,     0,     0,     0,     0,     0,     0,     0,     0,
    1906,     0,     0,     0,     0,     0, -2862,   836,     0,     0,
       0,  1321,     0,     0,     0, -2862,     0,     0,  1322,     0,
       0,     0,     0,     0,     0,   836,     0,     0,     0, -2553,
   -2862, -2553,     0, -2553,     0,     0,     0, -2553,     0, -2553,
   -2553, -2553, -2553,     0, -2553, -2553,     0,     0,  1323, -2862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2553,     0,     0,     0,     0,     0,     0,     0, -2862,  1324,
    1325,  1326,  1327,  1328,  1329,  1330,  1331,     0,     0,   836,
   -2862, -2862, -2862,     0,  1332, -2862,     0, -2553,     0,  1333,
       0,     0, -2862,     0,     0, -2553,     0,     0,     0,     0,
    1334,  1335,  1336,  1337, -2862,     0, -2862, -2862,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1338, -2553,
       0,     0,     0,     0,     0, -2553,     0,     0,  1339,     0,
       0,  1340,  1341,  1342, -2862,  1343,     0,     0,     0, -2553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1344,
       0,     0,     0,     0,     0,     0,     0,     0,  1345,  1346,
    1347,  1348,  1349,  1350,  1351,  1352,     0,     0,     0, -2862,
       0,  1353,  1354,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2862,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1355,  1356,     0,
       0,  1357,  1358,     0, -2862, -2862,  1359, -2862, -2862,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1360,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2862,  1361,     0,     0,     0,  1362,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2862,     0,     0,
       0,  1363,     0,     0,     0,     0,  1364,  1365,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1366,  1367,  1368,  1369,  1370,     0,
       0,  1371,     0,     0,     0, -2862, -2862, -2862,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2862,     0,     0,
       0,     0, -2862,     0,     0,     0,     0,     0,     0,     0,
    1372,  1373,  1374,  1375,     0,     0,     0,     0,     0,  1376,
    1377,     0,  1378,     0,  1379,  1380,  1381, -2862, -2862,  1382,
       0,  1383,     0, -2862, -2862,  1384,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1385,  1386,     0,     0,     0,     0,
       0,     0,     0,  1387,  1388,  1389,  1390,  1391,  1392,     0,
       0,     0,     0,     0,     0,     0,     0,  1393,     0,     0,
       0,  1394,     0,     0,     0,  1396,     0, -2862,     0, -2862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2862,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2862,
   -2862, -2862,     0,     0,  1397,     0,     0,     0,  1398,     0,
    1399,  1400,  1401,  1402,     0,     0,     0,     0,     0,     0,
    1403,     0,     0,     0,     0,     0, -2862,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1404,     0,     0,
       0,     0,     0,     0,     0,  1405,     0,     0,     0,     0,
   -2862, -2862, -2862,     0, -2862,     0, -2862, -2862,     0, -2862,
       0, -2862, -2862,     0,     0,  1497, -2862,     0, -2862, -2862,
   -2862, -2862,     0,     0,     0,     0,     0,     0,     0,     0,
    1406,  1407,     0,     0, -2862,     0,     0,     0,     0,     0,
       0,     0, -2862,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2862, -2862,     0,     0,     0,
       0,     0,     0,  1408, -2862,     0,  1409,     0,     0,     0,
   -2862,     0,     0,     0,     0,     0,     0,  1410,     0,     0,
       0,     0,     0,  1411,     0,     0,     0,  1412,     0,  1413,
    1414,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1415,     0,     0,  1416,  1417,     0,     0,
       0,  1418,     0,     0,     0,     0, -2862,     0,     0,     0,
       0, -2862,     0,     0,     0,  1419,     0,  1420,  1421,     0,
       0,     0,   781,     0,     0,     0,  1422,  1423,   782,   783,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   785,     0,  1424,  1425,  1426,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2862, -2862, -2862,     0,     0,     0,  1427,  1428,  1429,  1430,
   -2862,  1431,     0,     0,     0,  1432,  1433,     0,     0,     0,
       0,     0,     0,  1434,  1435,     0,     0,     0,     0,     0,
       0,  1436,  1437,  1438, -2862,     0,     0,     0,     0,  1439,
       0,     0,     0,     0,  1440,     0,     0, -2862, -2862, -2862,
   -2862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   308,  1441,     0,     0,   309,     0, -2862, -2862,     0,
     310,     0,     0,     0,     0,  1442,  1443,   311, -2862,     0,
       0,  1444,     0,     0,     0,     0,   312,  1498,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1445,  1446,     0,     0, -2862,     0,
       0,     0,     0,  1447,     0,     0,     0,     0,     0,     0,
       0,  1448, -2862, -2862,     0,     0,     0,  1449,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,   314,     0,
     786,   787,   788,     0,     0,     0,     0,  1450,     0, -2862,
       0,     0,   789,  1451,     0,     0,     0,     0,     0, -2862,
       0,     0,     0,     0,     0,     0, -2862,     0,   315,     0,
       0,     0,     0,     0,     0,     0,     0, -2862,     0,     0,
       0, -2862, -2862, -2862,     0,     0,     0,     0,   316,     0,
       0,     0,   317,     0,  1452,     0,     0,     0, -2862, -2862,
    1453,     0,  1454, -2862, -2862,  1455, -2862,     0,     0,     0,
     318,     0,  1456, -2862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1457,     0,     0,  1458,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1383,     0,   792,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   319,     0,     0,     0,     0,  1058,   320,     0,   321,
     795,   796,   797,   322,     0,     0,     0,   323,     0,   798,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,     0, -1383,     0,     0,     0,
   -1383, -1383, -1383, -1383, -1383,     0, -1383, -1383, -1383, -1383,
       0, -1383, -1383,     0, -1383, -1383,     0, -1383, -1383, -1383,
   -1383, -1383, -1383, -1383, -1383, -1383, -1383, -1383,     0,     0,
     325,     0,     0,     0,     0,     0,     0,     0, -1383,     0,
       0,     0,     0, -1383,     0,     0,   326,     0,     0,     0,
       0, -1383,     0,     0,     0,     0,   327,   328,     0,     0,
       0,     0,     0,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   308,     0,
       0,     0,   309,     0,     0,     0,     0,   310,     0,     0,
       0,     0,     0,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,   312,     0,   329,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,     0,     0,     0,
       0,   332,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   333,     0,     0,
       0,     0,     0,     0,     0,   334,     0,   335,     0,     0,
     336,     0,     0,   337,   313,   314,     0,     0, -1383,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   338,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     802,     0,     0,     0,     0,   315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   316,     0,     0,     0,   317,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   318,     0,     0,
       0,     0,     0,     0,   339,     0,     0,     0,     0,     0,
     340,     0,   341,     0,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,     0,     0,     0,     0,     0,     0,   319,     0,
   -1383,     0,     0,     0,   320,     0,   321,     0,   803,   804,
     322,     0,     0,     0,   323,     0,     0,     0,     0, -1383,
   -1383, -1383,     0, -1383, -1383, -1383, -1383,     0,     0,     0,
       0,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2615,   345,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   806,     0,
       0,     0,     0,   326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,   328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   807,   346,     0,     0,     0,
       0,     0,   347,   808,     0,     0,   348,     0,     0,   349,
     350,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   308,     0,     0,     0,   309,   351,   809,     0,     0,
     310,     0,   329,   186,     0,     0,     0,   311,     0,     0,
     330,     0,   352,   331,     0,     0,   312,   353,   332,  2616,
       0,     0,     0,     0,   354,     0,     0,     0,     0,     0,
     355,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   333,     0,     0,     0,     0,   356,
       0,     0,   334,     0,   335,     0,     0,   336,     0,     0,
     337,   781,     0,   357,     0,     0,     0,   782,   783,   358,
       0,     0,     0,     0,     0,   338,     0,   313,   314,     0,
       0,     0,     0,   785,     0, -1383,     0,   359,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   360,     0,     0,     0,     0,     0,     0,   315,     0,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,     0,     0,   316,     0,
       0,     0,   317,     0,     0,     0,     0,     0,   365,     0,
       0,   339,     0,     0,     0,     0,     0,   340,     0,   341,
     318,     0,   342,     0,     0,     0,     0,     0,     0,     0,
   -1383,     0,     0,     0,     0,     0,     0,     0,   343,     0,
       0, -1383,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   367,     0,     0,     0,     0,
       0,   319,     0,     0,     0,     0,     0,   320,   368,   321,
       0,     0,     0,   322,   369,     0,     0,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,     0,     0,     0,   324,     0,     0,     0,   370,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   308,     0,
       0,     0,   309,   345,     0,     0, -1383,   310,     0,   786,
     787,   788,     0,     0,   311,     0,     0,   371,     0,     0,
     325,   789,   372,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   326,     0,     0,     0,
       0,     0,     0,   346,     0,     0,   327,   328,   504,   347,
       0,     0,     0,   348,     0,     0,   349,   350,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   351,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   313,   314,     0,     0,     0,   352,
       0,     0,     0,     0,   353,   329,     0,     0,     0,     0,
    2617,   354,     0,   330,     0,     0,   331,   355,   792,     0,
       0,   332,     0,     0,     0,   315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   505,   356,     0,     0,   795,
     796,   797,     0,     0,     0,   316,     0,   333,   798,   317,
     357,   506,     0,     0,     0,   334,   358,   335,     0,     0,
     336,     0,     0,   337,     0,     0,     0,   318,     0,     0,
       0,     0,     0,     0,   359,     0,     0,     0,   338,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   360,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   361,   362,
       0,     0,     0,     0,     0,     0,     0,   363,   319,     0,
     364,     0,     0,     0,   320,     0,   321,     0,     0,     0,
     322,     0,     0,     0,   323,   365,     0,     0,     0,     0,
       0,     0,   800,     0,     0,     0,     0,     0,     0,     0,
       0,   324,     0,     0,   339,     0,     0,   366,     0,     0,
     340,     0,   341,     0,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   367,     0,     0,     0,     0,   325,     0,     0,
       0,     0,     0,     0,     0,   368,     0,     0,     0,     0,
       0,   369,     0,   326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,   328,     0,     0,     0,     0,   507,
       0,     0,     0,     0,     0,   370,     0,     0,     0,     0,
       0,     0,     0,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   371,     0,   345,     0,     0,   372,
       0,     0,   329,     0,     0,     0,     0,     0,     0,   802,
     330,     0,     0,   331,     0,     0,     0,     0,   332,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   346,     0,     0,     0,
       0,     0,   347,     0,   333,     0,   348,     0,     0,   349,
     350,     0,   334,     0,   335,     0,     0,   336,     0,     0,
     337,     0,     0,     0,     0,     0,   351,     0,     0,     0,
       0,     0,     0,     0,     0,   338,     0,     0,     0,     0,
       0,   508,   352,     0,     0,     0,     0,   353,     0,     0,
       0,     0,     0,     0,   354,     0,     0,     0,     0,     0,
     355,     0,     0,     0,     0,     0,     0,   803,   804,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   356,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   357,     0,     0,     0,     0,     0,   358,
       0,   339,     0,     0,     0,     0,     0,   340,     0,   341,
       0,     0,   342,     0,     0,     0,     0,   359,     0,   509,
       0,     0,     0,     0,     0,     0,     0,     0,   343,     0,
       0,   360,  2618,     0,     0,     0,     0,   806,     0,     0,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   807,     0,     0,     0,   365,     0,
       0,     0,   808,     0,     0,     0,     0,     0,     0,     0,
     344,     0,     0,     0,     0,     0,     0,   544,     0,     0,
    1609,     0,   545,     0,     0,     0,   809,     0,     0,   546,
       0,     0,   186,   345,     0,     0,     0,     0,   547,     0,
       0,     0,     0,     0,     0,   367,   510,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   368,     0,
       0,     0,     0,     0,   369,     0,     0,     0,     0,     0,
       0,     0,     0,   346,     0,     0,     0,     0,     0,   347,
       0,     0,     0,   348,     0,     0,   349,   350,   370,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   548,
     549,     0,     0,   351,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   371,     0,   352,
       0,     0,   372,     0,   353,     0,     0,     0,     0,     0,
     550,   354,     0,     0,     0,     0,     0,   355,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     551,     0,     0,     0,   552,     0,   356,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     357,     0,   553,     0,     0,     0,   358,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   360,     0,
       0,     0,     0,   554,     0,     0,     0,     0,   361,   362,
       0,     0,     0,     0,     0,   555,     0,   363,     0,   556,
     364,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   365,     0,     0,   557,     0,
       0,     0,     0,   558,   559,   560,   561,     0,   562,   563,
     564,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   578,   579,   580,
       0,     0,   581,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   367,     0,     0,     0,     0,     0,   582,     0,
       0,     0,     0,     0,     0,   368,     0,     0,   583,   584,
       0,   369,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   370,     0,   781,     0,     0,
       0,     0,     0,   782,   783,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   585,     0,   785,
       0,     0,     0,     0,   371,   586,     0,     0,   587,   372,
       0,     0,     0,   588,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   589,
       0,     0,     0,     0,     0,     0,     0,   590,     0,   591,
       0,     0,   592,     0,     0,   593,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   594,     0,     0,     0,
       0,     0,   595,     0,   596,     0,     0,   597,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   598,     0,   786,   787,   788,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   789,     0,     0,
       0,     0,  1321,     0,     0,     0,     0,     0,     0,  1322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   504,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   599,     0,     0,     0,  1323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   600,     0,
    1324,  1325,  1326,  1327,  1328,  1329,  1330,  1331,     0,     0,
       0,     0,     0,     0,     0,  1332,     0,     0,     0,     0,
    1333,     0,     0,     0,   792,     0,     0,     0,     0,     0,
       0,  1334,  1335,  1336,  1337,     0,     0,     0,     0,     0,
       0,   505,     0,     0,     0,   795,   796,   797,   601,  1338,
       0,     0,     0,     0,   798,     0,     0,   506,     0,  1339,
       0,     0,  1340,  1341,  1342,     0,  1343,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,     0,     0,     0,     0,     0,   604,     0,     0,     0,
    1344,     0,   605,     0,     0,     0,     0,     0,     0,  1345,
    1346,  1347,  1348,  1349,  1350,  1351,  1352,     0,     0,     0,
       0,   606,  1353,  1354,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   800,     0,
       0,   607,     0,     0,     0,     0,     0,     0,  1355,  1356,
       0,     0,  1357,  1358,     0,     0,     0,  1359,     0,   608,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   609,     0,     0,     0,     0,     0,  1360,
       0,     0,     0,   610,   611,     0,     0,     0,     0,     0,
       0,     0,   612,     0,     0,   613,     0,     0,     0,     0,
       0,     0,     0,  1361,     0,     0,     0,  1362,     0,     0,
     614,     0,     0,     0,     0,   507,     0,     0,     0,     0,
       0,     0,  1363,     0,     0,     0,     0,  1364,  1365,     0,
       0,     0,   615,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1366,  1367,  1368,  1369,  1370,
       0,     0,  1371,     0,     0,     0,     0,   616,     0,     0,
       0,     0,     0,     0,     0,   802,     0,     0,     0,     0,
     617,     0,     0,     0,     0,     0,   618,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1372,  1373,  1374,  1375,     0,     0,     0,     0,     0,
    1376,  1377,     0,  1378,     0,  1379,  1380,  1381,     0,     0,
    1382,     0,  1383,     0,     0,     0,  1384,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   619,
       0,     0,     0,     0,   620,  1385,  1386,   508,     0,     0,
       0,     0,     0,     0,  1387,  1388,  1389,  1390,  1391,  1392,
       0,     0,     0,     0,     0,     0,     0,     0,  1393,     0,
       0,     0,  1394,   803,   804,     0,  1396,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1397,     0,     0,     0,  1398,
       0,  1399,  1400,  1401,  1402,   509,     0,     0,     0,     0,
       0,  1403,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   806,     0,     0,     0,     0,  1404,     0,
       0,     0,     0,     0,     0,     0,  1405,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     807,     0,     0,     0,     0,     0,  1497,     0,   808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1406,  1407,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   809,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   510,     0,  1408,     0,     0,  1409,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1410,     0,
       0,     0,     0,     0,  1411,     0,     0,     0,  1412,     0,
    1413,  1414,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1415,     0,     0,  1416,  1417,     0,
       0,     0,  1418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1419,     0,  1420,  1421,
       0,     0,     0,     0,     0,     0,     0,  1422,  1423,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1424,  1425,  1426,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1427,  1428,  1429,
    1430,     0,  1431,     0,     0,     0,  1432,  1433,     0,     0,
       0,     0,     0,     0,  1434,  1435,     0,     0,     0,     0,
       0,     0,  1436,  1437,  1438,     0,     0,     0,     0,     0,
    1439,     0,     0,     0,     0,  1440,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1441,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1442,  1443,  1321,     0,
       0,     0,  1444,     0,     0,  1322,     0,     0,  1498,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1445,  1446,     0,     0,     0,
       0,     0,     0,     0,  1447,  1323,     0,     0,     0,     0,
       0,     0,  1448,     0,     0,     0,     0,     0,  1449,     0,
       0,     0,     0,     0,     0,     0,  1324,  1325,  1326,  1327,
    1328,  1329,  1330,  1331,     0,     0,     0,     0,     0,     0,
       0,  1332,     0,     0,     0,     0,  1333,     0,  1450,     0,
       0,     0,     0,     0,  1451,     0,     0,  1334,  1335,  1336,
    1337,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1338,     0,     0,   780,     0,
       0,     0,     0,   503,     0,  1339,     0,     0,  1340,  1341,
    1342,     0,  1343,     0,     0,  1452,     0,     0,     0,     0,
       0,  1453,     0,  1454,     0,     0,  1455,     0,     0,     0,
       0,     0,     0,  1456,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1457,  1344,     0,  1458,     0,
       0,     0,     0,     0,     0,  1345,  1346,  1347,  1348,  1349,
    1350,  1351,  1352,     0,     0,     0,     0,     0,  1353,  1354,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1355,  1356,     0,     0,  1357,  1358,
       0,     0,     0,  1359,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1360,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   781,
       0,     0,     0,     0,     0,   782,   783,     0,     0,  1361,
       0,     0,     0,  1362,     0,     0,     0,     0,     0,     0,
       0,   785,     0,     0,     0,     0,     0,     0,  1363,     0,
       0,     0,     0,  1364,  1365,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1366,  1367,  1368,  1369,  1370,     0,     0,  1371,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1372,  1373,  1374,
    1375,     0,     0,     0,     0,     0,  1376,  1377,     0,  1378,
       0,  1379,  1380,  1381,     0,     0,  1382,  2191,  1383,     0,
       0,     0,  1384,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1385,  1386,     0,     0,     0,     0,     0,     0,     0,
    1387,  1388,  1389,  1390,  1391,  1392,     0,     0,     0,     0,
       0,     0,     0,     0,  1393,     0,     0,     0,  1394,  1395,
       0,     0,  1396,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   786,   787,   788,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   789,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1397,     0,     0,     0,  1398,     0,  1399,  1400,  1401,
    1402,     0,     0,     0,     0,     0,   504,  1403,     0,   780,
       0,     0,     0,     0,   503,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1404,     0,     0,     0,     0,     0,
       0,     0,  1405,     0,     0,     0,     0,     0,     0, -1720,
       0,     0,     0,     0,     0,     0,     0, -1720, -1720, -1720,
   -1720,     0,     0,     0, -1720,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   790,   791,   792,  1406,  1407,     0,
       0,     0, -1720, -1720,   793,     0,   794,     0,     0,     0,
       0,     0,     0,   505,     0,     0,     0,   795,   796,   797,
       0,     0,     0,     0,     0,     0,   798,     0,     0,   506,
    1408,     0,     0,  1409,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1410,   799,     0,     0,     0,     0,
    1411, -1720, -1720,     0,  1412, -1720,  1413,  1414,     0,     0,
       0,     0,     0,   780,     0,     0,     0,     0,   503,     0,
    1415,     0,     0,  1416,  1417,     0,     0,     0,  1418,     0,
     781,     0,     0,     0,     0,     0,   782,   783,     0,     0,
       0, -1720,  1419,     0,  1420,  1421,     0,     0,     0,     0,
       0,     0,   785,  1422,  1423,     0,     0,     0,     0,     0,
     800,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1424,  1425,  1426,   780,     0,     0,     0,
       0,   503,     0,     0,     0,     0,   801,     0,     0,     0,
       0,     0,     0,  1427,  1428,  1429,  1430,     0,  1431,     0,
       0,     0,  1432,  1433,     0,     0,     0,     0,     0,     0,
    1434,  1435,     0,     0,     0,     0,     0,     0,  1436,  1437,
    1438,     0,     0,     0,     0,     0,  1439,     0,     0,     0,
       0,  1440,     0,     0,     0,     0,     0,   507,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1441,
       0,     0,     0,     0,   781,     0,     0,     0,     0, -1720,
     782,   783,  1442,  1443,     0,     0,     0,     0,  1444,     0,
    1040,     0,     0,     0,     0,     0,   785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   802,     0,     0,
       0,  1445,  1446,     0,     0,     0,     0,     0,     0,     0,
    1447,     0,     0,     0,     0,     0,     0,     0,  1448,     0,
       0,     0,     0,     0,  1449,     0, -1720,   781,   786,   787,
     788,     0,     0,   782,   783,     0,     0,     0,     0,     0,
     789,     0,     0,   971,     0,     0,     0,     0,     0,   785,
       0,     0,     0,     0,  1450,     0,     0,     0,     0,     0,
    1451,  2192,     0,     0,     0, -1720,     0,   504,     0,   508,
       0,   780,     0,     0,     0,     0,   503,     0,     0,     0,
   -3029, -3029, -3029,     0,     0,     0,     0,     0,  1292,     0,
       0,     0,     0,     0,     0,   803,   804,     0,     0,     0,
       0,  1452,     0,     0,     0,     0,     0,  1453,     0,  1454,
       0,     0,  1455,     0,     0,     0,     0,     0,     0,  1456,
       0,     0,     0,     0,     0,   790,   791,   792,     0,     0,
       0,  1457,     0,     0,  1458,   793, -1720,   794,     0,     0,
    2193,     0,     0,     0,   505,     0,     0,   509,   795,   796,
     797,  2194,   786,   787,   788,     0,     0,   798, -1720,     0,
     506,     0,     0,     0,   789,   806,     0,     0,     0,     0,
       0,     0,     0,     0, -3029,     0,   799, -1720,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   504,   807,     0,     0,     0,     0,     0,     0,     0,
     808,     0,     0,     0, -1720,     0,     0,     0,     0,     0,
       0,     0,   781,     0,     0,   786,   787,   788,   782,   783,
       0,     0,     0,     0,   809,     0,     0,   789,     0,     0,
     186,     0,     0,     0,   785,     0,     0,     0,     0,     0,
       0,   800,     0,     0,   510,     0,     0,     0,     0,   790,
     791,   792,     0,     0,   504,     0,     0,     0,     0,   793,
       0,   794, -1720,     0,     0,     0,     0,   801,   505,     0,
       0,     0,   795,   796,   797,     0,     0,     0,     0,     0,
       0,   798,     0,     0,   506,     0, -1720, -1720,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     799,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   790,   791,   792,   780,     0,     0,   507,     0,
     503,     0,   793,     0,   794,     0,     0,     0,     0,     0,
       0,   505,     0,     0,     0,   795,   796,   797,     0,     0,
   -3029,     0,     0,     0,   798,     0,     0,   506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1293,     0,
       0,     0,     0,   799,     0,   800,     0, -1720,   802, -1720,
   -1720,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1720,
       0,   801,     0,     0, -1720,     0,     0,     0,     0,     0,
     786,   787,   788,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   789,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3029, -3029,     0,     0,     0,   800,     0,
       0,     0, -1720,     0,     0,     0,     0,     0,     0,   504,
     508,     0,   507,     0, -1720,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   801,     0,   781,     0,     0,     0,
       0,     0,   782,   783,     0,     0,   803,   804,     0,  1294,
       0,     0,     0,     0,     0,   780,     0,     0,   785,     0,
     503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,     0,     0,     0,     0,   790,   791,   792,
   -3029, -3029,     0,     0,     0,   507,     0,   793,     0,   794,
       0,     0,     0,     0,     0,     0,   505,     0,   509,     0,
     795,   796,   797,     0,     0,     0,     0,     0,     0,   798,
     780,     0,   506,     0,     0,   503,   806,     0,     0,     0,
       0,     0,     0, -1720,     0,     0,     0,     0,   799,     0,
       0,     0,     0,     0,     0,   802,     0, -1720,     0,     0,
       0,     0,     0,   807,   508,     0,     0,     0, -3029,     0,
       0,   808,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     803,   804,  1295,     0,     0,   809,     0,     0,     0,     0,
   -1720,   186, -3029,     0,     0,  1041,     0,     0,     0,     0,
       0, -3029,     0,   800,     0,   510,   781,     0,     0,     0,
   -3029,     0,   782,   783,     0,     0,  1296,   508,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   785,   801,
       0,     0,   509,     0,   786,   787,   788,     0,     0,     0,
       0,     0,     0,   803,   804,     0,   789,     0,     0,     0,
     806, -3029,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   781,     0,     0,     0,     0,     0,   782,   783,     0,
       0,     0,     0,   504,     0,     0,     0,   807,     0,     0,
     507,     0,     0,   785,     0,   808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   509,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   809,
       0,     0,     0,   806,     0,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   510,
     802,   790,   791,   792,     0,     0,     0,     0,     0,     0,
     807,   793,     0,   794,     0,     0,     0,     0,   808,     0,
     505,     0,     0,     0,   795,   796,   797,     0,     0,     0,
       0,     0,     0,   798,   780,     0,   506,     0,     0,   503,
       0,     0,   809,     0,     0,     0,     0,     0,   186,     0,
       0,     0,   799,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   510,     0,   786,   787,   788,     0,     0,     0,
       0,     0,   508,     0,     0,     0,   789,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     780,     0,     0,     0,     0,   503,     0,     0,   803,   804,
       0,     0,     0,   504,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   800,     0,   786,
     787,   788,     0,     0,     0,  1605,     0,     0,     0,     0,
       0,   789,     0,     0,     0,     0,     0,  1297,     0,  1298,
       0, -3029,     0,   801,     0, -3029,     0, -3029,  1299,  1300,
     509,     0,  1301,  1302,     0,     0,     0,     0,   504,     0,
       0,   790,   791,   792,     0,     0,     0,     0,   806,     0,
       0,   793,     0,   794,     0,   781,     0,     0,     0,     0,
     505,   782,   783,     0,   795,   796,   797,     0,     0,     0,
       0,     0,     0,   798,   507,   807,   506,   785,     0,     0,
       0,     0,     0,   808,     0,     0,     0,     0,     0,     0,
       0,     0,   799,     0,  1827,     0,   790,   791,   792,   503,
       0,     0,     0,     0,     0,     0,   793,   809,   794,     0,
       0,   781,     0,   186,     0,   505,     0,   782,   783,   795,
     796,   797,     0,     0,   802,     0,     0,   510,   798,     0,
       0,   506,     0,   785,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   799,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   800,     0,     0,
       0,     0,     0,     0,   888,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   801,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   508,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   800,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,   804,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   507,   781,     0,     0,   801,     0,
       0,   782,   783,   786,   787,   788,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   789,     0,   785,     0,  1189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   509,     0,     0,     0,     0,     0,
       0,     0,   504,     0,   802,     0,     0,     0,     0,   507,
       0,     0,   806,     0,     0,     0,     0,     0,     0,   786,
     787,   788,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   789,     0,     0,     0,     0,     0,     0,     0,   807,
       0,     0,     0,     0,     0,     0,     0,   808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   504,   802,
     790,   791,   792,     0,     0,     0,     0,     0,     0,     0,
     793,   809,   794,     0,     0,     0,   508,   186,     0,   505,
       0,     0,     0,   795,   796,   797,     0,     0,     0,     0,
       0,   510,   798,     0,     0,   506,     0,     0,     0,     0,
       0,     0,   803,   804,     0,     0,     0,     0,     0,     0,
       0,   799,     0,     0,     0,     0,   790,   791,   792,     0,
       0,     0,     0,     0,     0,     0,   793,     0,   794,     0,
       0,   508,     0,     0,     0,   505,     0,     0,     0,   795,
     796,   797,     0,   786,   787,   788,     0,     0,   798,     0,
       0,   506,     0,     0,   509,   789,     0,   803,   804,     0,
       0,     0,     0,     0,     0,     0,     0,   799,     0,     0,
       0,     0,   806,     0,     0,     0,   800,     0,     0,     0,
       0,     0,   504,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   807,
       0,     0,   801,     0,     0,     0,     0,   808,     0,   509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   806,     0,     0,
       0,   809,   800,     0,     0,     0,     0,   186,     0,     0,
     790,   791,   792,     0,     0,     0,     0,     0,     0,     0,
     793,   510,   794,   507,   807,     0,     0,     0,   801,   505,
       0,     0,   808,   795,   796,   797,     0,     0,     0,     0,
       0,     0,   798,  3825,     0,   506,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,   809,     0,     0,     0,
       0,   799,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   802,     0,     0,   510,     0,     0,   507,
       0,     0,     0,     0,     0,     0,  -570,     0,     0,     0,
       0,  -570,  -570,  -570,  -570,  -570,     0,     0,  -570,  -570,
    -570,  -570,  -570,  -570,     0,  -570,  -570,  -570,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,  -570,     0,     0,
       0,     0,     0,     0,     0,     0,   800,     0,     0,   802,
       0,     0,     0,     0,     0,     0,  -570,  3084,     0,     0,
       0,     0,     0,     0,     0,   508,     0,     0,     0,     0,
       0,     0,   801,  -570,     0,     0,     0,     0,  -570,     0,
       0,     0,     0,     0,     0,  -570,  -570,     0,     0,  -570,
       0,   803,   804,     0,     0,     0,  -570,     0,     0,     0,
       0,     0,     0,  -570,     0,  -570,  -570,  -570,  -570,  -570,
    -570,  -570,  -570,  -570,     0,     0,     0,     0,     0,     0,
       0,   508,     0,   507,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,   509,     0,     0,     0,   803,   804,     0,
       0,     0,     0,  -570,     0,     0,     0,     0,     0,     0,
       0,   806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   802,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   807,     0,
       0,     0,     0,     0,     0,     0,   808,     0,     0,   509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   806,     0,     0,
     809,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
     510,     0,     0,  -570,   807,   508,     0,     0,     0,     0,
       0,     0,   808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   803,   804,     0,     0,     0,   809,     0,  1079,     0,
       0,     0,   186,     0,     0,     0,     0,  -570,  -570,  -570,
    -570,  -570,     0,     0,  -570,  -570,   510,     0,     0,     0,
    -570,     0,     0,     0,     0,  -570,     0,  1078,  -570,     0,
    -570,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,     0,   509,     0,     0,     0,  -570,     0,     0,
    -570,     0,     0,     0,     0,  -570,     0,     0,     0,  -570,
       0,   806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
    -570,     0,     0,  -570,  -570,  -570,  -570,  -570,   807,  -570,
    -570,  -570,     0,     0,     0,     0,   808,     0,     0,     0,
    -570,  -570,     0,     0,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,  -570,     0,     0,     0,  -570,     0,     0,
     809,     0,     0,     0,     0,     0,   186,     0,     0,     0,
    -570,     0,     0,     0,  -570,     0,     0,  -570,     0,     0,
     510,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,  -570,
    -570,  -570,  -570,  -570,  -570,  -570,  -570,  -570,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,   503,  -570,  -570,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,  -570,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -570,     0,     0,     0,     0,  -570,     0,
    -570,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,  -570,  1518,     0,     0,     0,  -570,
       0,     0,     0,  -570,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,  -570,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4274,  1079,     0,  -570,     0,     0,     0,     0,  -570,
       0,  -570,  -570,  -570,  -570,  -570,     0,     0,  -570,  -570,
       0,  -570,     0,  -570,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,   781,     0,     0,     0,     0,     0,   782,
     783,  -570,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,  -570,   785,  -570,  -570,  -570,  -570,
    -570,  -570,     0,  -570,  -570,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,  -570,     0,     0,     0,  -570,     0,
    -570,     0,  -570,  -570,  -570,     0,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,  -570,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,     0,  -570,     0,     0,  -570,  -570,     0,  -570,
       0,     0,  -570,  -570,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,  -570,  -570,  -570,  -570,  -570,  -570,  -570,
    -570,  -570,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,  -570,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,  -570,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,  -570,  -570,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,  -570,     0,     0,     0,     0,  -570,     0,
    1519,   786,   787,   788,     0,     0,  -570,     0,     0,     0,
       0,     0,  -570,   789,     0,     0,     0,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,     0,     0,     0,   197,     0,     0,     0,     0,
     504,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1079,     0,   790,   791,
     792,     0,     0,     0,     0,  -570,  -570,  -570,  -570,  -570,
       0,     0,  -570,  -570,     0,  -570,     0,   505,     0,     0,
       0,   795,   796,   797,     0,     0,     0,     0,     0,     0,
     798,     0,     0,   506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,     0,  -570,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2024,     0,     0,     0,     0,  -570,     0,     0,
       0,  2025,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2026,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,  -570,  2027,  -570,  -570,  -570,     0,
       0,  -570,     0,     0,   800,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,  2028,     0,     0,     0,  -570,     0,
       0,     0,  -570,     0,     0,     0,  2029,  2030,  2031,     0,
       0,  2032,     0,     0,     0,     0,     0,     0,  2033,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
    2034,     0,  2035,  2036,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,     0,     0,  -570,     0,     0,     0,
    2037,   507,     0,  -570,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,  -570,  -570,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,  -570,  -570,     0,
       0,     0,     0,     0,     0,     0,  -570,     0,     0,     0,
       0,   802,  -570,     0,     0,  2038,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,  -570,     0,  2039,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,  -570,     0,     0,   197,
    2040,  2041,  -570,  2042,  2043,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   508,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2044,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   803,
     804,     0,     0,  2045,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3127,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2046,  2047,  2048,     0,     0,     0,     0,     0,     0,
       0,   509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2049,     0,     0,     0,     0,  2050,   806,
       0,     0,     0,     0,     0,     0,     0,     0,  -570,     0,
    -570,  -570,  -570,     0,     0,     0, -2085,     0,     0,     0,
    -570,     0,     0,  2051,  2052,     0,   807,     0,     0,  2053,
    2054,     0,     0,     0,   808,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2085,     0,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,   809,     0,
       0,     0,     0,   476,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   510,     0,
       0,     0,     0,  2055,     0,  2056,     0,     0,     0,     0,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2057,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -570,     0,  2058,  2059,  2060,     0,     0,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -570,  -570,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2061,     0,     0,     0,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,  -570,     0,  2062,  2063,  2064,     0,
    2065,     0,  2066,  2067,     0,  2068,     0,  2069,  2070,     0,
       0,     0,  2071,   197,  2072,  2073,  2074,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2076,     0,     0,     0,     0,     0,     0,     0,  2077,     0,
    4337,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2078,  2079,     0,     0,     0,     0,     0,     0,     0,
    2080,     0,     0,     0,     0,     0,  2081,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2257,  2258,  2259,  2260,  2261,     0,  2262,
    2263,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2264,     0,  2082,     0,     0,     0,     0,  2083,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4338,
       0,     0,  1774,  4339,     0,     0,  2084,  2085,  2086,  1775,
       0,     0,     0,     0,     0,     0,  2087,  2265,     0,  2266,
    2267,  2147,  2268,  2269,  2270,  2271,  2272,  2273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2088,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2089,  2090,  2091,  2092,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2093,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2095,     0,     0,     0,     0,  2274,
    1153,     0,     0, -3127,     0,     0,     0,     0, -3127, -3127,
   -3127, -3127,     0,     0,  1154, -3127,     0,     0,     0,     0,
       0,     0,     0,     0,  2096,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3127,     0,     0,     0,  2097,  2098,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2099,     0,     0,     0,     0,
       0,     0, -2977, -3127,     0,  2100, -2977,     0,     0,     0,
       0,     0,  2101,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2102,     0,     0,     0,  2103,  2104,  2105,
       0,  2275,  2276,  2277,  2278,  2279,     0,     0,  2155,  2280,
   -3127,     0, -3127,     0,  2106,  2107,     0,     0,     0,  2108,
    2109,     0,  2110,     0, -3127,     0,  1153,     0,     0,  2111,
       0,     0,     0,     0, -3127, -3127, -3127, -3127,     0,     0,
       0, -3127,  4340,     0,  2281,     0,     0, -3127,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3127,
   -3127,     0,  2959,     0,  2960,     0,     0,     0,  2282,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1794,     0,     0,
       0,     0,     0,     0,     0,  2283,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2977, -3127,
       0,     0, -2977,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4341,     0,     0,     0,  4342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3127,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2285,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3127,     0,  4343,
       0,     0,     0,     0,     0,     0,  1155, -3127,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3127,     0,     0,     0,
       0,     0,  4344,     0,     0,  2256,     0,     0,  2257,  2258,
    2259,  2260,  2261,     0,  2262,  2263,     0,     0,     0,     0,
       0,  2287,     0,     0,     0,  2264,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3127,  2288,     0,     0,
   -3127,     0,  2289,     0,     0,     0,     0,     0,  4345,     0,
       0,     0,     0,     0, -3127,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2290,     0, -2977,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3127,     0,     0, -3127,
       0,     0,  2265, -3127,  2266,  2267,  2147,  2268,  2269,  2270,
    2271,  2272,  2273,     0,     0,     0,     0,     0,  1156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2961,     0,     0,     0,     0,     0,     0,
       0,     0, -3127,     0, -3127,     0,     0,     0,     0,     0,
       0, -3127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3127,     0,     0,
       0,     0,     0,     0,  2293,     0,  2294,  2295,  2296, -1794,
       0,     0,     0, -3127,     0,     0,  4346,     0,     0,     0,
       0,     0,     0, -2977,     0,     0,     0,  2962,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2977, -2977,     0,
       0,     0,     0,     0,     0, -3127,     0,     0,  4347,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3127,     0,     0, -3127,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4348,     0,     0,     0,
   -3127,     0,     0,     0,     0,     0,  2275,  2276,  2277,  2278,
    2279,     0,     0,  2155,  2280,     0, -3127,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4349,     0, -3127,     0,
   -3127, -3127,     0,     0,     0,     0,  2299,  2300,  2301,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2281,
   -3127,     0,  2302,     0,     0, -3127,     0,     0,     0, -3127,
       0,     0,     0, -3127,     0,     0,  2249,     0,     0,     0,
    4350,     0,     0,  2282,     0,     0,     0,     0,     0,     0,
       0,     0,  2963, -2977, -2977,     0,     0,     0,     0,     0,
      52,  2255,     0, -3127,     0,     0,     0,     0,     0,     0,
    2283,     0,     0,     0,     0, -3127,     0,     0,     0,     0,
       0,     0, -3100,     0,     0,     0,  2256,     0,     0,  2257,
    2258,  2259,  2260,  2261,  2284,  2262,  2263,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2264,     0,     0, -3127,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2979,
   -3127,     0,     0,     0, -3127,     0, -3127, -3127,     0,     0,
       0,     0, -1794,     0,     0,     0,     0,     0,     0,     0,
       0,  2285,     0,     0,     0,     0, -3127,     0,     0,     0,
       0, -3127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2265, -3127,  2266,  2267,  2147,  2268,  2269,
    2270,  2271,  2272,  2273,     0,     0, -3127,  2964,     0,     0,
       0,     0,     0, -3127,     0,     0,     0,     0,     0, -3127,
       0,     0,     0,     0,     0,     0,     0,  2286,     0,     0,
       0, -3127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2287,     0,     0,     0,
       0,   476,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2288,     0,     0,  2274,     0,  2289,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1794,     0,
    2290,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2965,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2291,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3127,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2292,     0,     0,     0,     0,  2275,  2276,  2277,
    2278,  2279,     0,     0,  2155,  2280,     0,   476,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2293,
       0,  2294,  2295,  2296,     0,     0,     0,     0,     0,     0,
    2281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2282,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2297,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2283,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3100,     0,     0,     0,     0,     0,     0,
       0,  -629,     0,  4028,     0,  2284,     0,     0,  4029,  4030,
    4031,  4032,     0,     0,     0,  4033,  2257,  2258,  2259,  2260,
    2261,     0,  2262,  2263, -3100,     0,     0,     0,     0,     0,
       0,  2298,     0,  4034,  4035,     0,     0,     0,     0,     0,
       0,  2299,  2300,  2301,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4036,     0,     0,     0,  2302,     0,     0,
       0,     0,  2285,     0,     0,     0,     0,   781,     0,     0,
       0,  2249,     0,   782,   783,  4037,     0,     0,     0,  2303,
       0,     0,  1712,  4038,     0,     0,  1713,     0,     0,   785,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2265,     0,  2266,  2267,  2147,  2268,  2269,  2270,  2271,  2272,
    2273,     0,     0,     0,     0,     0,     0,     0,  2286,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4039,     0,     0,     0,     0,     0,  2287,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2288,     0,     0,     0,     0,  2289,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2274,     0,     0,     0,     0,     0,     0,     0,
       0,  2290,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4040,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   786,   787,   788,     0,     0,
       0,     0,     0,  2292,     0,     0,     0,   789,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2275,  2276,  2277,  2278,  2279,     0,
       0,  2155,  2280,     0,   504,     0,     0,  4041,     0,     0,
    2293,     0,  2294,  2295,  2296,  4042,     0,  4043,     0,     0,
       0,     0,     0,     0, -3029,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4044,     0,     0,  2281,     0,     0,
       0,     0,     0,     0,     0,     0,  4045,     0,  1721,     0,
       0,     0,     0,  1722,  1723,  1724,  1725,     0,  2297,     0,
    1726,  2282,   790,   791,   792,     0,     0,     0,     0,     0,
       0,     0,   793,     0,   794,     0,     0,     0,    52,  1727,
       0,   505,     0,     0,     0,   795,   796,   797,  2283,     0,
       0,     0,  -630,     0,   798,     0,     0,   506,     0,     0,
       0,     0,     0,     0,  4046,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3100,     0,  4047,     0,     0,
       0,  4048,  2298,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,  2299,  2300,  2301,     0,     0,     0,     0,  4049,
       0,     0,     0,     0,     0,     0,     0,     0,  2302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2249,     0,     0,  1729,     0,  1730,     0,  2285,
    2303,     0,     0,     0,     0,     0,     0,     0,   800,  1731,
       0,     0,     0,     0,  4050,     0,     0,     0,     0,     0,
       0,  1740,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1732,     0,   801,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4051,     0,  1741,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4052,  2287,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   507,     0,     0,     0,     0,
    2288,     0,     0,     0,     0,  2289,  4028,  1715,  1716,     0,
       0,  4029,  4030,  4031,  4032,     0,     0,     0,  4033,  2257,
    2258,  2259,  2260,  2261,     0,  2262,  2263,     0,  2290,     0,
       0,  4053,     0,     0,     0,     0,  4034,  4035,     0,     0,
       0,     0,     0,     0,     0,   802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4036,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4054,     0,  4037,     0,
       0,     0,  1733,     0,     0,  1712,  4038,     0,  1746,  1713,
    1747,  1748,  1734,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2265,     0,  2266,  2267,  2147,  2268,  2269,
    2270,  2271,  2272,  2273,     0,     0,     0,   508,     0,     0,
       0,  1735,     0,  4055,     0,     0,     0,     0,     0,     0,
       0,     0,   781,     0,  4039,     0,     0,     0,   782,   783,
       0,     0,     0,   803,   804,     0,     0,  2293,     0,  2294,
    2295,  2296,     0,  4056,   785,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4057,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2274,     0,     0,     0,  1736,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   823,   781,   509,     0,   824,   825,  4058,
     782,   783,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1737,     0,   806,  1738,     0,   785,     0,     0,     0,
       0,     0,     0,     0,  4059,     0,     0,     0,     0,  -950,
       0,     0,     0,     0,     0,  4060,     0,     0,     0,     0,
     807,     0,     0,  4040,     0,     0,     0,     0,   808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,  4061,     0,  1740,     0,     0,  2299,
    2300,  2301,   809,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,  2302,     0,  2275,  2276,  2277,
    2278,  2279,   510,  4062,  2155,  2280,     0,     0,     0,  2249,
    4041,     0,  1741,     0,     0,     0,     0,     0,  4042,     0,
    4043,     0,     0,     0,     0,     0,     0, -3029,  1742,     0,
     786,   787,   788,     0,     0,     0,     0,  4044,     0,     0,
    2281,     0,   789,     0,     0,     0,     0,     0,   781,  4045,
       0,     0,     0,     0,   782,   783,     0,     0,     0,     0,
       0,     0,     0,     0,  2282,     0,     0,     0,     0,   504,
     785,     0,     0,     0,     0,     0,  1743,     0,     0,  1744,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2283,   786,   787,   788,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   789,     0,     0,  4046,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4047,  1745,     0,     0,  4048,     0,     0,   790,   791,   792,
       0,   504,     0,  1746,     0,  1747,  1748,   793,     0,   794,
       0,     0,  4049,     0,     0,     0,   505,     0,     0,     0,
     795,   796,   797,     0,     0,  1749,     0,     0,     0,   798,
    1750,     0,   506,     0,     0,     0,     0,     0,  1751,     0,
       0,     0,  2285,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4050,     0,   790,
     791,   792,     0,     0,  1740,     0,     0,     0, -3087,   793,
       0,   794,     0,     0,     0,     0,     0,     0,   505,     0,
    1752,     0,   795,   796,   797,     0,     0,     0,     0,     0,
       0,   798,     0,     0,   506,     0,     0,     0,  4051,     0,
    1741,     0,     0,     0,     0,     0,   786,   787,   788,     0,
       0,     0,     0,   800,  1753,     0,  4052,  2287,   789,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2288,     0,  1754,     0,     0,  2289,   801,
    1715,  1716,     0,     0,     0,   504,     0,     0,     0,     0,
       0,     0,   781,     0,     0,     0,     0,     0,   782,   783,
       0,  2290,     0,     0,  4053,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   785,   800,     0,     0,     0,  1755,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     507,  1756,     0,     0,     0,     0,     0,     0,  1757,     0,
       0,   801,     0,   790,   791,   792,     0,     0,     0,  4054,
       0,     0,     0,   793,     0,   794,     0,     0,     0,     0,
       0,  1746,   505,  1747,  1748,     0,   795,   796,   797,     0,
       0,     0,     0,     0,     0,   798,     0,     0,   506,     0,
     802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   507,     0,     0,     0,  4055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2293,     0,  2294,  2295,  2296,     0,  4056,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4057,     0,
       0,     0,   802,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   508,     0,     0,     0,     0,     0,     0,   800,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4058,     0,     0,     0,     0,     0,   803,   804,
     786,   787,   788,     0,     0,   801,     0,     0,   781,     0,
       0,     0,   789,     0,   782,   783,     0,  4059,     0,     0,
       0,     0,  -953,     0,     0,     0,     0,     0,  4060,     0,
     785,     0,     0,     0,   508,     0,     0,  2711,     0,   504,
       0,     0,     0,     0,     0,     0,     0,     0,   823,     0,
     509,     0,   824,   825,     0,     0,   507,  4061,     0,     0,
     803,   804,  2299,  2300,  2301,     0,     0,     0,   806,     0,
       0,  2897,     0,     0,     0,     0,     0,     0,  2302,     0,
       0,     0,     0,   781,     0,     0,  4062,     0,     0,   782,
     783,     0,  2249,     0,     0,   807,     0,   790,   791,   792,
       0,     0,     0,   808,     0,   785,   802,   793,     0,   794,
     823,     0,   509,     0,   824,   825,   505,     0,     0,     0,
     795,   796,   797,     0,     0,     0,     0,   809,     0,   798,
     806,     0,   506,   186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   807,     0,     0,
       0,     0,     0,     0,     0,   808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   508,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   809,
       0,     0,     0,     0,   781,   186,   786,   787,   788,     0,
     782,   783,     0,     0,   803,   804,     0,     0,   789,   510,
       0,     0,     0,   800,     0,  2899,   785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     781,     0,     0,     0,     0,   504,   782,   783,     0,   801,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   785,     0,   823,     0,   509,     0,   824,   825,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   786,   787,   788,   806,     0,     0,     0,     0,     0,
       0,     0,     0,   789,     0,     0,     0,     0,     0,     0,
     507,     0,     0,   790,   791,   792,     0,     0,     0,     0,
       0,   807,     0,   793,     0,   794,     0,     0,     0,   808,
     504,     0,   505,     0,     0,     0,   795,   796,   797,     0,
       0,     0,     0,     0,     0,   798,     0,     0,   506,     0,
       0,     0,     0,   809,     0,     0,     0,     0,     0,   186,
     802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   510,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   790,   791,
     792,     0,     0,     0,     0,     0,     0,     0,   793,     0,
     794,     0,   786,   787,   788,     0,     0,   505,     0,     0,
       0,   795,   796,   797,   789,     0,     0,     0,     0,     0,
     798,     0,     0,   506,     0,     0,     0,     0,     0,   800,
       0,     0,   508,     0,     0,     0,     0,     0,   786,   787,
     788,   504,     0,     0,     0,     0,     0,     0,     0,     0,
     789,     0,     0,     0,     0,   801,     0,     0,   803,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   504,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2920,     0,   790,
     791,   792,     0,     0,   800,     0,   507,     0,   823,   793,
     509,   794,   824,   825,     0,     0,     0,     0,   505,     0,
       0,     0,   795,   796,   797,     0,     0,     0,   806,     0,
     801,   798,     0,     0,   506,   790,   791,   792,     0,     0,
       0,     0,     0,     0,     0,   793,     0,   794,     0,     0,
       0,     0,     0,     0,   505,   807,   802,     0,   795,   796,
     797,     0,     0,   808,     0,     0,     0,   798,     0,     0,
     506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   507,     0,     0,     0,     0,     0,   809,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   510,     0,     0,
       0,     0,     0,     0,     0,   800,     0,     0,     0,     0,
       0,     0,  4455,     0,     0,     0,     0,     0,   508,     0,
       0,   802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   801,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   800,     0,     0,   803,   804,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   507,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   508,   823,     0,   509,     0,   824,   825,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   806,     0,     0,     0,   507,   803,
     804,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,     0,     0,     0,     0,     0,     0,     0,
       0,   807,     0,     0,     0,     0,     0,     0,     0,   808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   802,     0,
       0,   509,     0,   809,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   806,
       0,     0,     0,   510,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   508,     0,     0,     0,     0,     0,
    4456,     0,     0,     0,     0,     0,   807,     0,     0,     0,
       0,     0,     0,     0,   808,     0,     0,     0,     0,     0,
     803,   804,     0,     0,     0,     0,     0,     0,     0,     0,
     508,     0,     0,     0,     0,     0,     0,     0,   809,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,   804,   510,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   509,     0,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     806,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   509,     0,
       0,     0,     0,     0,     0,     0,     0,   807,     0,     0,
       0,     0,     0,     0,     0,   808,   806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   809,
       0,     0,     0,   807,     0,   186,     0,     0,     0,     0,
       0,   808,     0,     0,     0,     0,     0,     0,     0,   510,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   809,     0,     0,     0,     0,
       0,   186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   510
};

static const yytype_int16 yycheck[] =
{
     151,   503,   646,   180,   636,   137,  1169,   139,   780,   238,
      36,    66,   144,   705,   706,   707,   674,    72,   710,   693,
    1631,   982,  1164,  1092,   669,  1094,  1095,  1499,  1097,  1098,
    1032,   719,   174,   641,  2137,   723,   724,  1113,   726,   727,
    2483,   729,   730,    69,    70,    71,  2249,   776,  1714,  2436,
      76,  1616,   184,  1719,   212,  2498,  1023,   137,  2336,   139,
    1008,   658,  1283,  1626,   144,   281,  1687,   631,   652,   872,
    1888,   644,  1743,   627,   636,  1644,   720,   721,   675,   652,
    1898,   725,  2775,  1261,   728,  1189,   858,  2449,   805,  2737,
     674,  3164,  2208,   901,   120,  2355,  1887,  2459,   866,  2177,
    1185,   674,  2362,  1928,   184,  2365,  2366,  3422,   134,     1,
     136,    16,  1197,  1291,   140,   141,  1523,  1908,     1,    43,
     626,   866,  2134,     1,   150,   151,    62,    16,   690,  2663,
    2807,    16,     0,     0,  2337,  2338,    16,    25,  2441,  2442,
     166,   107,  3009,    16,  2447,  2448,    16,  2450,    25,   655,
     204,   206,     1,   793,   794,    31,   182,    16,    77,   157,
     215,   801,  2830,    11,    14,    56,   815,    83,    42,  2837,
     137,   110,   119,    11,   200,   255,  1859,  1281,   208,    43,
     110,    30,   109,    83,   833,    16,     1,    38,   214,    83,
      31,   697,  2883,   219,   997,    16,   156,  2400,  2572,   227,
    1764,   227,  1169,   843,    19,    55,   139,    42,   805,    41,
     195,   120,   290,   169,   239,   280,   249,   291,   240,    85,
     626,  1773,   967,   626,    16,     1,    48,  2621,   631,  1781,
       1,   317,   164,   137,   226,   261,   291,   292,   109,   232,
    1923,   644,   113,    16,   237,  1268,   109,  1526,   317,   652,
     113,  2554,   161,   162,  2557,   308,    41,   157,   249,   190,
    1028,  2564,   764,    84,  2567,   122,  3728,  1035,   317,   398,
     354,   674,   101,  2716,  2717,   949,   109,  3594,    11,   110,
     113,   456,    11,  1028,   255,   839,   270,   170,  1554,   122,
     354,   456,   285,   337,   390,   102,   953,   112,  2967,   421,
      44,   161,   240,   190,   409,   560,   488,   198,  2977,   815,
    3742,   110,   409,   488,   592,   239,   421,   823,   824,   825,
     110,   305,   306,   390,  1041,    41,   337,   833,   431,   431,
     304,   384,   483,   895,   560,    83,   437,   409,   123,    57,
     231,   560,   127,   434,   187,  3128,   353,   351,   282,   120,
     240,   226,   110,    83,   205,   170,   571,   353,   173,   560,
     175,   240,   935,   651,   464,   409,   590,   390,   301,    38,
    1044,  2631,   170,   171,   947,   239,   227,   137,   226,   456,
    3574,   196,   250,   250,   690,   291,  3594,   232,   256,   256,
     161,   162,   237,   390,   449,   648,    38,   706,   277,   319,
     279,   630,   456,   578,   633,   744,  3503,  1511,   255,   456,
     291,   106,   337,  3958,  3731,  3684,   336,   336,   824,   291,
     823,   824,   825,  1152,   228,    16,  4148,  3737,   317,  1158,
    2733,  3940,  3975,   713,  1018,   824,   462,   463,   667,   655,
     285,   670,   355,   230,  1041,  1018,  2129,   676,  2460,   409,
     370,   509,  1025,   409,   198,  3724,   482,    14,   861,   464,
     198,   464,   517,   489,   817,   824,   161,   696,   437,  1237,
    4438,  1481,   352,   390,   289,   828,   982,   194,   628,   195,
     833,    13,   409,   351,   351,   203,   299,   515,   319,   456,
     640,   208,   409,    85,  1504,  2882,   409,   301,    55,   194,
     409,  1605,  1008,  4012,  4472,   292,   137,   427,  4230,   137,
     515,   137,   515,   208,   230,   451,   384,   384,   386,   386,
     859,  1170,  3832,  3731,   913,   744,   137,    11,  1034,   456,
     450,   379,   935,   409,   557,   137,   205,  3806,  4083,  1268,
     820,   618,  2225,   137,   947,  3222,  3214,   627,  2664,   337,
    4093,   631,   491,    30,   913,   756,  3750,  2817,   379,  3656,
     618,  3229,  3253,   205,   644,   645,  2669,   405,   409,   419,
     567,   618,   652,   826,   350,   500,   292,   584,   658,  1228,
    2207,    96,   551,   316,   355,   398,     1,   379,   584,   669,
     690,   671,   672,   817,   674,   675,   687,   531,   749,   447,
     431,   449,   890,   416,    23,   434,   912,   916,   456,  3003,
     481,   826,  3006,   617,  1683,  1018,   437,   438,   481,   699,
    1696,   337,  1025,  3406,   472,  1189,   855,   434,  1034,   409,
     409,  1034,   616,   815,   912,   456,    23,   543,   409,   355,
     859,   870,   515,   744,   459,   494,   379,   658,   481,   539,
     379,   472,   233,   651,   734,   110,  2221,   405,   913,  2962,
     170,    76,  1610,   448,   456,   175,  1172,  1173,  1174,   578,
     354,   543,   456,  1179,  1180,  1181,  1182,   520,  1286,  1185,
     472,   475,   456,   505,   506,   507,   198,   913,    23,  1195,
     488,  1197,  1198,  2364,   766,  1257,   534,    16,  1204,  1205,
    1206,  1207,  1208,   421,   489,   495,   121,   497,   626,   805,
     561,   577,   456,  1219,   447,   648,   449,  1281,   447,    23,
     449,   206,   560,   456,   821,   805,  1811,   456,  1234,  1833,
     662,   579,   481,  1239,   708,   651,   551,  1540,   913,   472,
     843,   843,   515,   472,    44,   616,  1518,   456,   832,   617,
     617,   651,   927,   616,   821,   884,   821,   651,   571,   839,
    1314,    56,   927,  2588,   637,  4227,   982,  3444,   832,  1172,
    1173,  1174,   187,  1179,  1180,  1181,  1179,  1180,  1181,   289,
      75,   861,   630,   616,   678,  2354,  1189,   820,   379,  1195,
     912,   110,  1195,  1971,  2415,  1198,  2808,   282,   820,   621,
     303,  1204,  1205,  1206,  1207,  1208,  1494,   578,   913,   630,
     608,  3345,  1580,   598,   599,  3506,  4248,   320,   722,  1476,
     669,   757,   769,   761,  3492,  4142,  2509,   913,  1234,   820,
     908,  1234,  1780,  1239,  1483,   913,  1239,   793,   630,   913,
     616,  3510,   354,   298,   913,   716,   579,   752,   647,   820,
     579,    16,   701,   716,  2133,   935,   388,   389,   687,   913,
     913,  1884,   794,   636,   913,   456,  2132,   947,    11,   913,
     727,   383,   109,   906,   866,   822,   113,  1526,  1281,   810,
     687,   472,   912,   716,   912,   815,   301,   912,   420,  3263,
     705,   913,   890,   826,   727,   379,   488,   630,   252,  2463,
     616,   630,   982,   769,   752,   823,   824,   825,  1680,  1681,
    3304,   820,   744,   817,  1881,    11,   835,  2469,   884,   807,
     913,   651,  1002,   810,  1508,   279,   820,   912,   913,   913,
    1107,   752,   464,   240,   894,  1508,   815,  1088,  1018,  1090,
     355,   396,  1093,  3611,  3612,  1025,   913,  1511,   678,   820,
     831,  1102,   820,   820,  1086,  1087,  3823,   820,   832,   831,
     752,  1041,   722,   447,  1096,   449,  1143,   815,  3659,  2235,
     785,   820,   456,   820,   890,   914,   867,   913,  1666,  1667,
     821,  3649,   830,   515,  1672,   577,   913,  1675,   472,  1495,
     890,   866,   830,   912,   409,   868,   890,   832,  1571,   923,
     319,  2179,   233,   912,  3016,   820,  1086,  1087,   423,   830,
     728,  1240,   843,    11,   836,   837,  1096,   494,   866,   752,
     835,   913,   927,   752,   913,  1797,  1798,   849,   913,   906,
     913,   446,   820,   913,  3568,   913,   815,   913,   830,   630,
    1546,  1605,   913,   913,   820,   913,   913,   920,   912,   820,
    1227,   911,  1692,   913,   913,  1827,   906,   817,  1084,   923,
     379,   912,  1720,  1831,   982,   913,   804,   912,   913,  2696,
     828,  4386,  3720,  1153,  3751,   833,   169,   815,   593,   927,
     913,   500,   377,  3095,   869,  3097,  1831,  1593,  3779,    23,
     820,   722,  1495,  4166,   722,   579,   722,   830,   913,    20,
     913,   830,    23,    24,  1610,  1508,   927,  1824,  1511,  1189,
     240,   722,   431,   500,  2521,   913,  1034,  1143,   912,   456,
     722,  4194,   464,  2941,  2942,  2943,  2944,   912,   722,   913,
    1156,   274,   816,   913,   913,   927,   280,   456,   448,   913,
     435,   912,  3311,   927,   676,   437,   630,   240,  3160,   730,
     409,  1800,   200,   472,  1962,  1884,   456,   532,  2983,   228,
     890,   752,   743,   912,   379,   500,   678,   456,  1571,  3817,
      42,  3839,   764,   515,  2135,   470,  2739,   769,   485,   912,
     913,    16,    16,    80,   913,  2976,   817,  1593,  2734,   817,
    1593,   817,   669,    28,   927,   705,   500,   700,   927,   354,
       1,  1281,  1605,   456,   913,    16,   817,   233,  2656,   442,
     281,   442,  3490,  2896,   379,   817,  3943,   828,   927,    31,
    2785,   515,   833,   817,   701,    23,   641,  1824,   515,  3345,
     822,   646,    41,    39,  1314,   511,   379,   240,  2186,   830,
     596,   566,   227,   456,   481,   228,   690,   398,   663,    84,
     665,  2610,   420,   578,  1172,  1173,  1174,   472,   456,   346,
    2438,  1179,  1180,  1181,  2833,   416,  1417,  3345,   752,  1833,
      18,   456,   337,   321,  1780,   456,  3969,  1195,  1966,   574,
    1198,   766,   280,   379,   427,   157,  1204,  1205,  1206,  1207,
    1208,   456,   485,   884,  1848,  2978,   464,  2980,   123,  1943,
     785,   813,   127,   894,   447,  1811,   449,   472,   379,     0,
     596,   630,   417,   456,   123,   448,  1234,   802,   127,   650,
     456,  1239,   913,  3971,  2502,  2503,   448,   603,  1972,   472,
    1546,   815,    80,  2402,  2403,   456,   927,  1981,   850,  2408,
    2409,   459,  4415,  3026,  2420,   488,   830,   515,   456,   852,
     456,   447,    47,   449,   319,   485,  2005,  2535,  2536,   388,
     456,   456,    37,   235,   819,   618,   456,  3645,   750,   456,
    3648,   456,   904,   828,   829,   350,   472,   425,   833,   616,
     912,   379,   557,   379,   887,   456,   681,  1663,   532,   892,
     739,   420,   485,   420,   704,   682,    38,   408,   542,   204,
       0,   472,   283,   337,  3087,   820,  3089,   739,   486,  2587,
     291,  2496,   291,   456,   820,  1573,   442,  2982,   291,  2597,
     571,   812,   776,   229,   363,   364,  1829,   354,  1508,   913,
    1833,  1511,   824,   752,   482,   464,   579,   464,   613,   821,
    1669,   832,  1671,   927,  1673,  1674,   823,  1676,  1677,   447,
     546,   449,   744,   456,   545,  3943,   421,  3275,   456,   766,
     456,  2023,   427,   298,   212,   630,   430,  2645,   912,  2573,
     169,  2575,   515,   456,   472,   890,   472,   652,   785,   716,
    3943,  2659,  2660,   579,  2133,  3745,   515,   630,   515,   430,
     797,  1571,   565,  3771,  3772,   802,   561,   730,   913,   730,
    2006,   440,   441,   857,   456,   595,   264,  2224,  3179,  2281,
     859,   830,   743,     0,   379,   301,   302,   595,  4245,  3943,
    1923,   913,   715,   678,   843,  1605,   857,   859,   817,   906,
     515,  2189,  1664,   544,   630,  2639,   629,   752,   384,   337,
     386,  2543,  2191,  2127,   379,   379,  3908,  3110,  3717,  3112,
    3096,   352,   927,  2356,  2127,  2128,   912,   913,  1584,   630,
     855,   820,   514,   205,   336,   634,   500,   464,   379,   355,
     912,   704,  2641,   379,  3943,   379,   913,  1495,   475,   500,
     501,   579,   704,   820,  1664,  2139,   390,   752,   913,   337,
     927,   456,  3695,   947,   913,  3043,   906,   409,   370,   385,
     295,  4328,   437,   438,  1659,   406,  1632,   472,   927,   752,
    1636,  1637,   717,  1639,  3235,  2719,  1642,  1643,   912,  1645,
     912,   456,   456,   448,   913,   912,   912,  2224,   982,  2135,
     551,   552,   630,   220,   630,  2284,   766,   472,   472,   448,
    1720,   616,  2291,   595,   571,   456,   797,   546,  3007,   745,
     456,   456,   456,   459,  2298,   785,   752,   750,   530,   728,
     913,   472,   805,  2611,   543,   830,   472,   797,   472,   787,
     543,   346,   802,   766,   138,  1593,   511,   821,  1032,   551,
    2186,   752,   775,   776,   777,   433,  2864,   830,  1865,   350,
     546,   390,   785,   384,  1845,   386,  1722,   503,   746,  3517,
     913,   503,  1728,   167,   730,  1731,   456,  1733,  2929,   802,
    2216,  2217,   927,  2357,   927,   913,   464,   743,  2406,   884,
     184,   185,  3287,   865,  2127,  2128,  2129,   475,   913,   894,
     488,   566,   913,   739,   830,  1001,   904,  2013,    16,  2507,
     831,   274,    20,   833,  1824,    23,    24,  2476,   913,  1829,
     828,   393,   894,  1833,   752,   833,   752,  4245,   169,   830,
      32,    33,   927,   250,   882,   630,  2733,   515,  1848,   256,
     913,  2840,  4159,   598,   599,  2851,  2852,   913,  2726,   474,
     744,  4168,  4245,   913,   927,   110,   485,   820,    42,   598,
     599,  2449,   913,   464,   842,   630,   630,  2455,  1152,  2457,
    1066,  2459,   739,   744,  1158,   913,   927,   913,  4086,  4087,
    2216,  2217,    19,  2216,  2217,  4018,  4019,   913,   913,   630,
     913,  4245,  2225,   821,   630,  3508,   630,   739,   913,   240,
     155,   927,   830,    36,  1860,   240,   300,  3520,  3521,   379,
    4328,  4302,   913,  1923,   515,  3126,   745,   126,  4151,   813,
     105,   106,  2501,   859,   133,  4158,   927,   301,   557,  4162,
     641,   351,  4165,   819,   351,  4328,   647,  2018,  1222,  1895,
    3048,  3049,   813,   829,   494,   904,  4245,   904,  1904,  3834,
     630,   833,    14,  3061,  3062,   912,   825,   752,   827,   745,
    3573,   505,   506,   336,   384,   278,   386,   384,  1252,   386,
    3078,  3079,  3183,   157,  4328,   112,   161,  2565,  2566,  2541,
     532,   355,   398,   220,  1268,   913,   456,   752,   752,  2135,
     668,   582,   859,    55,    41,   586,   761,   370,  4389,   927,
     416,   927,   472,   299,   682,   744,  4139,  4140,  3893,   194,
     336,   752,   564,   154,  2517,  2947,   752,   859,   752,   699,
     629,   757,   758,   208,   756,   616,     1,   759,   760,  4328,
      77,  2610,    79,   170,    14,   830,   173,   753,   175,    20,
      21,    22,   828,  4416,   370,   927,   379,   833,  2484,   650,
    2486,   235,   817,  4286,   819,   102,  4289,   712,   641,   196,
    2496,   820,   126,   828,   829,   830,   830,   832,   833,   133,
     283,   465,   752,   408,  2510,    55,   123,   621,   291,  2573,
     127,  2575,   476,    58,    59,    60,    61,   641,    63,   830,
    4392,   641,  2455,   647,  2457,   408,   830,   647,  2534,   456,
     393,    14,   398,   295,  2457,   869,   820,   299,  2189,  2197,
    2198,  2199,  2200,  2201,  2202,  2203,  2204,  2127,  2128,  2129,
     416,   641,   713,   456,   911,   805,   913,   647,   665,  2139,
    2668,   668,   927,   114,  2637,   851,   673,  4439,  4440,   472,
     409,   750,    55,   379,   485,  2639,  2227,    76,  2484,   913,
    2486,  2484,   289,  2486,   511,   448,   558,   514,  1643,   561,
     630,   409,   927,   927,   747,   748,   775,   776,   777,   144,
     145,   817,   913,   828,  2510,  2611,  2509,  2510,   833,  2189,
     828,   282,   828,  2619,  2517,   833,   927,   833,   823,  3297,
     291,   927,   121,   927,  1679,   612,  2775,   617,  2534,   834,
     617,  2534,  2565,  2566,   539,  2286,   398,   818,   456,   544,
    1494,   605,  2565,  2566,  2224,  2225,   256,   828,   712,   250,
     456,   578,   833,   459,   416,  2719,   337,   540,   339,  4233,
    4234,   544,  2891,   913,   912,   913,   472,  3128,   595,   448,
    2573,   198,  2575,   452,  2254,  3740,   817,   927,   823,   643,
    4383,  2410,  2954,  2412,  2335,  2414,   857,   828,   187,   834,
     820,  2342,   833,   828,  4387,  4388,   660,   503,   833,   187,
    2706,  4398,   713,  3381,  3382,   571,  4403,  1561,    91,    92,
      93,   399,   752,  1172,  1173,  1174,  2367,  2135,   629,   271,
    2726,  4039,   500,   501,  4417,  2883,   541,   630,   543,   280,
    4048,  2737,  1586,   812,  2637,   849,  2639,   816,  4056,  1198,
     558,   912,  4435,   561,   818,  2877,  4449,  3316,   812,  2478,
    2479,   368,   459,  4273,   828,  1206,  1207,  1208,   541,   833,
     543,  2341,   448,  4484,   828,  4486,   452,  4488,   448,   833,
     691,  1625,   452,   551,   552,   882,  2302,   220,   641,  2305,
     325,   326,   327,   328,   329,   330,   331,   332,   333,  2422,
     830,  4394,   655,  2426,  2349,  4369,  4489,  2513,  2216,  2217,
    2706,  4321,  4322,  2706,  2455,   824,  2457,  4327,   820,   571,
    4330,  4385,   363,   364,  4334,  4335,  2719,   434,  2344,   713,
     823,  1459,   825,   578,   630,   838,   839,   210,   211,   307,
     213,   448,  3943,   588,   589,   452,   766,  2363,   738,   750,
    1478,  1479,  1480,   738,   551,   820,  2372,  2373,   555,   752,
     820,  3039,   444,   445,   820,   766,   390,  3001,  3007,   820,
    2492,  2441,  2442,    37,   775,   776,   777,  2447,  2448,  2449,
    2450,  4037,   404,   913,   785,  2455,  2984,  2457,   489,  2459,
     820,  4047,   549,   550,   713,  1803,   820,   927,  1806,   440,
     441,   802,  2418,  2419,  2610,   820,  1814,    24,    25,   913,
    1818,   135,  2544,   913,  1204,  1205,   833,  1825,   663,   913,
     409,   456,  2492,   913,  2565,  2566,   870,   871,   872,   873,
     870,   871,   872,   873,   423,  2464,  2465,   830,  2454,  2509,
     685,   686,   456,   820,  2485,  2461,  2487,  2517,  3399,  1180,
    1181,   820,  2493,  2494,  2495,  3406,   752,   446,   820,  2500,
     870,   871,   872,   873,   918,   919,   692,   508,   820,   666,
    2511,  2512,   220,   820,  1274,  1275,  1276,  1277,  2259,  2260,
    2261,  2262,   456,   843,  2554,  3544,   456,  2557,    11,   915,
     597,   598,   599,    16,  2564,  2565,  2566,  2567,   820,   913,
     725,   542,   744,  2573,   113,  2575,   122,   913,   705,  1853,
     551,  3679,  3680,   456,   409,   337,  2722,  3509,   820,   560,
     724,   610,   713,   561,   807,   398,   399,   140,   820,   592,
     564,   456,   727,   820,   927,    16,   406,   195,  2744,   820,
    1884,   816,   616,   139,   912,    14,   356,   108,   815,   422,
    3312,   295,   913,  3175,   751,   913,   753,   853,   913,   820,
     601,   596,   832,   713,   463,   820,   442,  2637,   824,  2639,
     557,   290,    32,   820,   913,   448,  2484,   456,  2486,   489,
     687,   241,   832,   485,   619,  2978,  2792,  2980,   785,   885,
     886,   346,   832,   832,   832,   832,   832,   832,   832,   832,
     473,   832,  2510,   242,   832,  3253,   298,   815,   832,   832,
     243,   691,   244,  3781,  3782,  3783,   246,   162,   641,  2838,
    2839,   362,  2841,  2842,  2843,   732,  2534,    78,   797,   152,
     797,   927,   247,  3026,   912,   158,   159,     7,   835,   456,
     248,  3403,   815,   249,  4245,   168,   497,   183,   270,  2719,
     804,   174,   641,   832,   253,   815,   254,   646,    83,   805,
     913,   258,   257,  2733,   346,   259,   346,   913,   260,   488,
     261,   152,   894,   291,   663,   611,   665,   158,   159,    42,
     262,   832,   263,    53,   405,  4341,   264,   346,   265,   202,
    2831,   266,   820,   174,   713,    65,  3089,   454,   571,   659,
     820,   820,   155,   796,   913,   810,   813,   678,   337,  3775,
    3776,   169,  4174,   815,   913,   913,   913,   913,  4374,   815,
     354,   396,   458,   614,   456,   489,   676,  4328,   835,  2745,
    3284,   604,  3286,   291,   911,   608,   609,   543,   869,   911,
     906,   111,  2883,   456,   236,   316,   662,   252,   405,   815,
     733,   807,   812,   346,   368,  2771,   801,  3392,  3926,  3927,
    2830,   634,   405,   405,   134,   240,   815,  2837,   912,   815,
      83,   815,   202,   346,   346,    83,   267,   405,   346,   713,
     821,   820,   663,   156,   825,  2991,   827,  2131,    31,   557,
     820,  2135,   890,   647,  2810,   820,    76,  2813,  2706,  2815,
    2816,  3007,   454,   549,  2820,   912,  2822,  2823,  2824,  2825,
      14,  3943,  3031,  2883,   421,   744,  2832,   340,   341,   342,
     137,   191,   926,   549,   766,   766,   925,   496,   354,   352,
    3896,   820,   421,   817,  2178,   817,  2744,   817,   817,  2855,
     817,   817,   817,   678,    37,   817,   815,   683,   815,   658,
     354,   421,   354,   456,   569,   884,   379,   927,  3506,   340,
     341,   342,   251,   662,   815,    83,   227,   354,   390,   906,
     906,   352,   820,   558,  2890,  2219,   557,   766,   913,  3830,
     354,    16,  3948,   815,  2792,  3524,    13,   678,  2232,   239,
     820,  3284,  2962,  3286,   890,   713,   704,   906,   379,   355,
     687,   890,   272,   459,    37,   355,   409,   913,  2978,   894,
    2980,   109,   728,   766,   437,   438,   439,   464,    57,   913,
    3126,   817,  3128,   796,   447,   727,   449,   456,  3606,  3607,
     817,   745,   354,   456,   546,   515,   408,   460,   461,   462,
     544,     7,   240,    25,   807,   281,   469,   236,   169,   472,
     890,   890,    83,   337,   337,   727,  3026,    14,   439,   346,
     539,   240,   662,   820,   566,   488,   203,   794,   500,   596,
     889,    95,   820,   343,   713,   456,   807,  3183,   927,   460,
     461,   462,   832,    90,    37,   854,   815,    53,   469,   913,
     773,   472,   725,   913,   815,   337,    25,   452,   557,    65,
     728,   744,   564,   197,   817,   346,   354,   354,   213,   599,
     657,  3659,  3231,   657,   187,   826,    14,    55,   496,  3089,
     208,   567,  3163,   562,  2368,  3787,   569,   255,   464,  4088,
     553,   421,   187,   464,   520,   448,   545,   831,   877,   615,
     820,   361,   807,  3184,   456,   111,  3728,   457,   744,   346,
    3191,  3690,   812,   423,   913,   456,   579,   807,   110,  3129,
    3227,   913,  3726,  3108,  3186,  3561,   820,  3083,   134,  3236,
    3237,   392,   553,   813,   206,    83,   198,   784,   612,    83,
     515,   515,   464,  3205,   464,   455,   464,  3293,   540,  3211,
     820,   278,  3233,   612,  3216,  3217,   204,  3238,   913,   817,
     204,   815,  3224,   766,  3226,   346,    13,   630,   807,   500,
      23,   612,  3253,  4245,   683,   913,  3186,   498,   865,  3881,
     635,   570,   823,   396,   729,   191,   336,   481,   585,   815,
     291,  3779,  3202,  3203,   543,  3205,   616,   195,  3816,   815,
     393,  3211,   820,    41,  3214,   475,  3216,  3217,   690,   630,
     543,   824,   664,   850,  3224,   756,  3226,   680,   744,  3229,
     204,   561,   197,   824,   820,   820,   499,   227,   500,    23,
     820,   612,   543,   784,   291,  4328,   421,   437,   206,   421,
     820,   906,   557,  3253,   554,   421,   421,   556,   437,   169,
    3206,   421,   421,  3399,  3690,   783,   355,   437,   120,   680,
    3406,   231,   355,   109,   566,   370,   272,   510,   442,  3225,
     797,  3227,   394,    83,  3284,   770,  3286,   346,  3126,   578,
    3128,  3899,   578,  3239,  3720,   578,   566,    11,    48,   752,
      45,   113,   524,    83,   270,   820,   196,   276,    90,   294,
    3879,  1123,   198,   743,   202,  3841,   473,  2013,  3318,  3643,
      16,  4083,  2821,  3622,  3762,   778,   779,   627,   455,  2829,
    3908,   631,    28,  2843,  3620,  3203,  3937,  3473,  4001,  4012,
     793,   752,  2133,  2305,  4328,  3183,   708,   343,  1632,  3918,
    3421,  2625,  2781,  4453,  3744,  3838,  3964,  2014,  3893,  2792,
    4147,  4273,  4397,  4402,  3731,  4173,  3889,   778,   779,   659,
    4079,  1476,   969,  4040,   624,  4234,   626,   830,  4040,   629,
    4075,  4047,  2656,  1702,   634,  2856,   636,  3289,    84,   231,
    3442,  3817,  3392,  2891,  3543,   848,  1152,  2882,  3344,  1839,
    3969,  1164,  1739,  3455,   654,   655,  2515,   707,  1158,   659,
     839,  3259,  3287,  3786,  3785,  1222,   666,   638,  1253,   830,
    1884,   849,   875,  3293,   895,  1911,  2947,   423,   907,  3500,
     883,   681,  2542,  3485,   659,  3506,  1289,   848,  1286,  2588,
    2983,   931,  3442,  1964,  3293,   695,  2996,   697,   698,  2994,
    1317,  1487,  2619,  3012,   907,  3455,  2003,  2731,  3011,   455,
     913,  3538,  3676,   637,   875,  1492,  2135,   767,  3333,  3037,
    3713,  2170,   883,  3473,   927,   649,  2656,  3574,  3043,  3052,
     977,  3427,  3051,  2731,  1559,  3485,   660,   661,  2671,  2205,
     675,  2709,  3492,  2232,  1598,  3093,   907,  2232,  3918,  3711,
    2184,  3585,   913,  1016,  1018,  2169,  3506,  3673,  3972,  4098,
    3977,  1624,  2437,  2435,  3980,  3930,   927,  3929,  3795,  3683,
    3682,  2505,  1264,  2506,  3098,  3082,  1263,  3081,  3567,  3386,
    3385,  2540,  3099,  3604,   784,  2539,  3685,   846,  3609,  1303,
    1294,  3487,   674,  1937,  2702,  3971,  2702,   847,  2702,   699,
    3621,  1002,  2702,  1964,  3186,  1216,  2799,   204,   554,  3524,
    3561,  3399,  2191,  2005,  3007,  4042,  1219,  2722,  3406,  2417,
     515,   747,  4192,   823,   824,   825,   808,  1633,  3759,  2207,
    2531,  2789,  3088,  3707,  4342,  2963,  3371,  3624,  3659,  2332,
    4223,   778,  3507,  4374,  4430,   288,  3542,  3028,   528,   849,
    3193,  1903,   298,  2212,  4223,   905,  1162,  3955,  1641,  2411,
    3223,  3611,  3612,  4389,    -1,  4227,  4042,    -1,    -1,    -1,
      -1,    -1,    -1,  3623,    -1,    -1,   876,    -1,  3725,  3629,
      -1,   627,    -1,    -1,    -1,   631,    -1,    -1,   812,    -1,
      -1,    -1,    -1,    -1,    -1,  3591,    -1,    -1,    -1,  3649,
      -1,    -1,    -1,    -1,    -1,  4347,    -1,    -1,    -1,  3659,
      -1,  3797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4229,    -1,    -1,
      -1,    -1,    -1,   379,  3684,    -1,  3738,  3739,    -1,  3635,
    4242,    -1,    -1,    -1,  3830,    -1,    -1,    -1,    -1,    -1,
    3646,  3647,   952,    -1,    -1,  3651,  3652,    -1,  3779,  3761,
    3762,   707,   962,   963,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3561,  3724,  3874,    -1,    -1,    -1,  3675,
      -1,    -1,   982,    -1,   908,    -1,    -1,    -1,  3738,  3739,
    3686,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     924,    -1,    -1,  4175,    -1,  3852,  3853,  3031,  1008,    -1,
     456,  3761,  3762,    -1,    -1,    -1,    -1,  3916,    -1,  3043,
    3716,   767,    -1,    -1,    -1,    -1,   472,    -1,    -1,  3779,
      -1,    -1,    -1,    -1,  1034,  4349,    -1,    -1,  3734,    -1,
    1040,    -1,    -1,    -1,    -1,    -1,    -1,   971,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3806,    -1,    -1,    -1,
      -1,    -1,    -1,  1063,    -1,    -1,    -1,  1067,  1068,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3105,    -1,    -1,    -1,    -1,   626,    -1,    -1,  3839,
      -1,   631,    -1,    -1,    -1,    -1,    -1,  4455,    -1,    -1,
      -1,   847,  3904,    -1,   644,    -1,    -1,    -1,  1032,    -1,
      -1,    -1,   652,    -1,    -1,  1039,    -1,    -1,    -1,  1043,
     566,    -1,    -1,  3944,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   674,    -1,    -1,    -1,    -1,    -1,
      -1,  3837,    -1,    -1,    -1,    -1,    -1,  3843,  3950,    -1,
      -1,    -1,    -1,    -1,  3904,    -1,  4042,    -1,  3908,   905,
    3856,    -1,    -1,    -1,    -1,  1165,  1166,    -1,    -1,    -1,
      -1,    -1,  1172,  1173,  1174,    -1,    -1,    -1,    -1,  1179,
    1180,  1181,  1182,    -1,   630,  1185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1195,    -1,  1197,  1198,    -1,
    3950,    -1,    -1,    -1,  1204,  1205,  1206,  1207,  1208,    -1,
      -1,  4387,  4388,    -1,    -1,    -1,    -1,    -1,    -1,  1219,
      -1,  1221,    -1,    -1,    -1,  3921,    -1,    -1,    -1,    -1,
    4051,    -1,    -1,    -1,  1234,  3931,    -1,    -1,    -1,  1239,
      -1,  4417,  3830,    -1,    -1,    -1,  3942,  3943,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4435,
      -1,    -1,    -1,  3959,  3960,  1189,    -1,    -1,    -1,    -1,
      -1,  1271,    -1,    -1,    -1,   815,    -1,    -1,  3974,    -1,
      -1,    -1,    -1,   823,   824,   825,    -1,    -1,  4187,  4110,
      -1,  3987,    -1,   833,  3990,  3991,  3992,  3993,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,  3333,
      -1,    -1,    -1,  4489,  4387,  4388,    -1,    -1,    -1,    -1,
    4141,   861,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4029,    -1,    -1,    -1,    -1,  4159,    -1,
      -1,    -1,  4038,  1267,  4417,  4041,    -1,  4168,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1280,  1281,    -1,    -1,
      -1,    -1,  4435,    -1,    -1,    -1,    -1,  3391,    -1,    -1,
      -1,   817,    -1,   819,    -1,    -1,    -1,    -1,    -1,  1303,
      -1,    -1,   828,   829,   830,    -1,   832,   833,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   935,    -1,    -1,    -1,    -1,
      -1,  4151,    -1,    -1,    -1,    -1,    -1,   947,  4158,    -1,
      -1,    -1,  4162,    -1,    -1,  4165,  4489,    -1,    -1,  3443,
    4116,  4117,  4118,  4119,  4120,    -1,    -1,  4123,  4124,  4125,
    4126,  4127,  4128,  4129,  4130,  4131,  4132,  4133,    -1,    -1,
    4136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4144,    -1,
      -1,    -1,  4273,    34,    35,    -1,    -1,    -1,    -1,  4155,
      -1,  4157,     7,    -1,    -1,    -1,    -1,    -1,  1008,    -1,
      -1,  4167,    -1,    -1,    -1,    -1,    -1,  3501,  1018,    -1,
      -1,   927,    -1,    -1,    -1,  1025,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1034,  1495,     7,    -1,    -1,    -1,
    4321,  4322,    -1,    -1,    -1,    -1,  4327,    -1,    53,  4330,
      -1,    -1,    -1,  4334,  4335,    -1,    -1,    -1,    -1,    -1,
      65,    -1,    -1,  4344,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4286,    -1,    -1,  4289,
      -1,    -1,    53,    -1,    -1,   126,  1546,    -1,  4369,  4245,
      -1,    -1,   133,    -1,    65,   136,    -1,    -1,  1558,    -1,
    1560,  3585,    -1,    -1,  4385,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4398,    -1,    -1,
      -1,  4402,  4403,    -1,    -1,    -1,    -1,  1511,    -1,   134,
      -1,    -1,  4413,  1593,    -1,    -1,    -1,  1597,    -1,    -1,
     111,    -1,    -1,    -1,  4300,  4301,    -1,  4303,    -1,   190,
    1610,   192,   193,    -1,    -1,    -1,    -1,  3641,  3642,  3643,
      -1,    -1,    -1,   134,  4320,    -1,    -1,    -1,    -1,  4325,
    4326,    -1,  1172,  1173,  1174,    -1,    -1,    -1,    -1,  1179,
    1180,  1181,  1182,    -1,    -1,  1185,   191,  4343,    -1,  1189,
    4346,    -1,  1576,  4349,    -1,  1195,    -1,  1197,  1198,    -1,
      -1,    -1,    -1,  1587,  1204,  1205,  1206,  1207,  1208,    -1,
      -1,    -1,  4493,    -1,  1598,    -1,    -1,    -1,    -1,    -1,
     191,  1605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   274,  1234,   276,    -1,    -1,    -1,  1239,
      -1,    -1,   283,    -1,    -1,    41,    -1,    -1,    -1,    -1,
     291,    -1,     1,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    -1,    -1,    -1,    -1,    -1,    -1,   272,    -1,  3753,
      -1,  1271,    -1,    -1,    -1,  3759,    -1,    -1,    74,    75,
      -1,  1281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   272,    -1,    -1,  1764,    -1,    -1,    -1,    57,    58,
      59,    60,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,
    1780,    -1,    -1,    -1,    -1,    -1,    -1,   123,   124,    -1,
     335,   127,    -1,    -1,    -1,    -1,    -1,    -1,   343,  4387,
    4388,    -1,  1802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1811,    -1,    -1,    -1,    -1,    -1,   398,    -1,    -1,
      -1,    -1,    -1,    -1,   335,    -1,    -1,   163,    -1,  4417,
      -1,    -1,   343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4435,    -1,    -1,
      -1,    -1,   141,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,    -1,    -1,    -1,   448,    -1,    -1,
      -1,   452,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4489,    -1,    -1,    -1,    -1,    -1,   488,    -1,    -1,
     455,  1911,   423,    -1,    -1,  1915,    -1,    -1,  3942,   430,
      -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3958,    -1,    -1,    -1,   483,    -1,
      -1,    -1,    -1,  1483,   455,   281,    -1,    -1,    -1,  1873,
      -1,    -1,    -1,    -1,    -1,  1495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1508,    -1,
      -1,  1511,   483,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1985,    -1,    -1,  1988,    -1,
    1990,  1991,  1992,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,   338,    -1,    -1,    -1,  2006,    -1,    -1,    -1,
    2010,    11,  2012,    -1,    -1,    -1,    16,    -1,  2018,    -1,
      20,    21,    22,    -1,    -1,    -1,    -1,    -1,    28,    29,
      -1,  1571,    -1,    -1,    -1,    -1,   325,   326,   327,   328,
     329,   377,    -1,   332,   333,    -1,   557,    -1,    -1,    -1,
      -1,    -1,    -1,  1593,    -1,    -1,    -1,    -1,    -1,  4083,
      -1,    -1,    -1,    -1,    -1,  1605,    -1,    -1,    -1,    -1,
    1610,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,   627,    -1,    -1,    -1,   631,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   448,    -1,   114,    -1,   627,    -1,    -1,    -1,
     631,    -1,    -1,   704,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   470,  2135,    -1,    -1,  2138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,   489,    -1,    -1,    -1,    -1,   158,   159,
      -1,    -1,   707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2171,    -1,    -1,   174,    -1,  2176,    -1,    -1,    -1,
     516,    -1,    -1,    -1,    -1,  2185,  2186,    11,    -1,    -1,
      -1,    -1,    16,    -1,    -1,    -1,   707,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,    -1,    -1,   788,    -1,    -1,
      -1,   500,    -1,    -1,    -1,    -1,  2216,  2217,   799,    -1,
      -1,    -1,   767,  2223,    -1,    -1,    -1,    -1,    -1,   810,
      -1,  2231,  2232,    -1,    -1,    -1,   781,    -1,   574,  2239,
    1780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   767,    -1,    -1,    -1,
     805,    -1,   598,   599,    -1,    -1,    -1,    -1,    -1,    -1,
     781,  1811,  2196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     280,    -1,    -1,    -1,    -1,    -1,   575,    -1,    -1,  1829,
      -1,    -1,    -1,  1833,   805,    -1,    -1,    -1,   298,    -1,
     881,    -1,   847,    -1,    -1,    -1,    -1,   596,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,    -1,
     619,    -1,   913,    -1,   158,   159,   847,    -1,    -1,    -1,
     340,   341,   342,   679,    -1,   681,   682,    -1,   893,    -1,
     174,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     905,    -1,    -1,   363,   364,   701,   911,    -1,   913,    -1,
     706,  1911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
      -1,    -1,   893,  1923,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   905,    -1,    -1,    -1,    -1,    -1,
     911,    -1,   913,    -1,    -1,    -1,    -1,    -1,   744,   409,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     756,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2436,   437,   438,   439,
     440,   441,    -1,    -1,    -1,    -1,    -1,   447,    -1,   449,
      -1,   740,   741,   742,    -1,    -1,   456,    -1,    -1,    -1,
     460,   461,   462,  2463,    -1,  2005,  2006,    -1,    -1,   469,
      -1,    -1,   472,    -1,   298,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2484,    -1,  2486,    -1,   488,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2496,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,
    2510,    -1,    -1,  2513,    -1,    -1,   340,   341,   342,   855,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,
      -1,    -1,   532,   869,  2534,    -1,    -1,    -1,    -1,    -1,
      -1,  2541,   542,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   551,    -1,   553,    -1,   379,    -1,    -1,    -1,    -1,
     560,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
      -1,   860,   861,   862,    -1,    -1,   912,    -1,    -1,   579,
      -1,    -1,    -1,    -1,    -1,   409,    -1,  2127,  2128,  2129,
      -1,    -1,    -1,    -1,    -1,    -1,  2596,    -1,    -1,    -1,
      -1,   601,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2611,    -1,   437,   438,   439,    -1,    -1,    -1,  2619,
      -1,    -1,    -1,   447,   913,   449,    -1,    -1,    -1,    -1,
     630,    -1,   456,    -1,    -1,    -1,   460,   461,   462,    -1,
      -1,    -1,    -1,  2643,    -1,   469,  2186,    -1,   472,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   488,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2216,  2217,    -1,    -1,
     680,    -1,    -1,    -1,    -1,  2225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2698,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2706,    -1,   532,    -1,
      -1,    -1,  2636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2722,    -1,    -1,    -1,  2726,    -1,    -1,   553,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2737,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   752,    -1,    -1,   579,    49,    50,    51,    52,
      -1,  2685,    -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   778,   779,
      -1,    74,    75,    -1,  2708,  2709,    -1,    -1,    -1,    -1,
      -1,  2715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    11,    -1,    -1,    -1,   630,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,   819,
      -1,   821,    -1,   823,    -1,   825,    -1,   827,   828,   829,
     830,   124,   832,   833,   834,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    11,
     163,    -1,    -1,    -1,    16,   875,    -1,  2877,    20,    21,
      22,    -1,  2882,   883,    -1,    -1,    28,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,   752,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,  2484,    -1,  2486,    -1,    -1,   158,
     159,    -1,    -1,    -1,   778,   779,  2496,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,  2509,
    2510,    -1,   114,    -1,    -1,    -1,    -1,  2517,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,    -1,
      -1,  2991,    -1,   817,  2534,   819,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   828,   829,   830,    -1,   832,   833,
     152,    -1,    -1,    -1,    -1,    -1,   158,   159,    -1,    -1,
      -1,  2945,    -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   174,  2573,    -1,  2575,    -1,  3037,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,
      -1,   875,    -1,    -1,    -1,     1,    -1,    -1,    -1,   883,
       6,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2611,   281,    -1,    -1,    -1,    -1,    -1,    -1,  2619,
      -1,    27,    -1,   907,   377,    -1,    -1,    -1,    -1,   913,
      -1,    -1,    -1,    -1,    40,    -1,    -1,  2637,    -1,  2639,
      -1,    -1,     6,   927,    -1,     9,    -1,    -1,    -1,    -1,
      -1,    57,    -1,    -1,  3038,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    27,    -1,   334,    -1,    -1,    -1,    -1,
      -1,   340,   341,   342,    -1,    -1,    40,    -1,   280,    11,
      -1,    -1,    -1,   352,    16,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   297,   298,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2706,    -1,    -1,    -1,
     379,    -1,    -1,    -1,    -1,  3175,   122,   470,    -1,  2719,
      -1,    -1,   391,    -1,    -1,    -1,  2726,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2737,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,
      -1,   363,   364,   516,    -1,    -1,    -1,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,    -1,   379,   447,    -1,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,    -1,
      -1,   460,   461,   462,    -1,    -1,    -1,    -1,    -1,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   409,    -1,    -1,
      -1,    -1,    -1,  3273,    -1,    -1,   485,    -1,    -1,   488,
     152,   574,    -1,    -1,    -1,    -1,   158,   159,    -1,    -1,
      -1,    -1,    -1,  3293,    -1,   437,   438,   439,   440,   441,
      -1,    -1,   174,    -1,    -1,   447,    -1,   449,    -1,    -1,
    3310,    -1,    -1,    -1,   456,    -1,    -1,    -1,   460,   461,
     462,    -1,    49,    50,    51,    52,    -1,   469,    -1,    56,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3264,  3265,  3266,  3267,   553,    -1,   488,    74,    75,    -1,
      -1,   560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   309,   310,    -1,   508,    -1,    -1,  3369,
     579,    -1,    -1,    -1,    -1,    -1,    -1,  3377,    -1,  3379,
      -1,    -1,  3306,  3307,    -1,    -1,   679,    -1,   681,   682,
     532,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,
     542,    -1,    -1,    -1,    -1,   309,   310,    -1,   701,   551,
     282,   553,    -1,   706,    -1,    -1,    -1,    -1,   560,    -1,
      -1,   630,    -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   163,   579,  2978,    -1,
    2980,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,
      -1,   744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   601,
      -1,    -1,    -1,   756,    -1,    -1,    -1,    -1,   340,   341,
     342,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,    -1,   354,    -1,    -1,    -1,  3026,    -1,   630,   393,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   448,    -1,    -1,    -1,    -1,   379,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3516,    -1,   464,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   680,  3539,
    3540,    -1,    -1,   752,   448,    -1,    -1,   756,    -1,  3089,
      -1,    -1,    -1,    -1,   281,    -1,    -1,    -1,    -1,    -1,
     464,  3561,   855,    -1,  3564,   437,   438,   439,    -1,   778,
     779,    -1,   781,    -1,    -1,   447,    -1,   449,    -1,    -1,
      -1,   527,    -1,    -1,   456,    -1,    -1,    -1,   460,   461,
     462,    -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,  3599,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3532,    -1,
     752,   338,    -1,    -1,    -1,    -1,   488,   826,    -1,    -1,
      -1,   830,   568,   527,    -1,    -1,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    -1,    -1,    -1,   778,   779,    -1,   848,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,
      -1,    -1,    -1,    -1,   568,    -1,   875,    -1,    -1,    -1,
      -1,    -1,   576,  3673,   883,   817,  3676,   819,    -1,   821,
      -1,   553,    -1,   825,    -1,   827,   828,   829,   830,    -1,
     832,   833,    -1,    -1,    -1,   641,    -1,    -1,   907,    -1,
      -1,    -1,   911,    -1,   913,    -1,   848,   579,    -1,   655,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,
    3720,    -1,    -1,    -1,   670,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   875,    -1,    -1,    -1,   641,    -1,    -1,
    3664,   883,    -1,   470,  3284,    -1,  3286,    -1,    -1,    -1,
      -1,   655,    -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,
      -1,    -1,    -1,    -1,    -1,   907,   670,    -1,    -1,    -1,
      -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   727,   728,    -1,    -1,   927,    -1,   733,   515,    -1,
      -1,    -1,    -1,  3793,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   747,    -1,    -1,    -1,    -1,   678,    -1,   680,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3817,    -1,    -1,
     766,    -1,    -1,   727,    -1,    -1,    -1,    -1,    -1,   733,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   747,    -1,    -1,    -1,   574,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,    -1,    -1,
      -1,    -1,   766,   158,   159,    -1,  3866,    -1,    -1,    -1,
      -1,  3871,    -1,    -1,   820,    -1,    -1,    -1,   824,   174,
     752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   840,   841,    16,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   778,   779,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   820,    -1,    -1,    -1,
     824,    -1,    -1,  3923,  3924,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,   840,   841,    16,  3939,
    3940,    -1,    -1,    -1,  3944,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   679,    -1,   681,   682,    -1,    -1,   830,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,
      -1,  3971,  3972,    -1,   701,    -1,   848,  3977,    -1,   706,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3989,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   875,  4004,    83,    -1,    -1,    -1,    -1,
      -1,   883,    -1,    -1,    -1,  4015,    -1,   744,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4027,    -1,   756,
      -1,    -1,   152,    -1,    -1,   907,    -1,    -1,   158,   159,
     912,   913,  4042,    -1,    -1,   340,   341,   342,    -1,    -1,
      -1,    -1,    -1,    -1,   174,   927,    -1,   352,    -1,  4059,
      -1,    -1,  4062,    -1,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    -1,    -1,   152,    -1,    -1,    -1,    -1,   157,
     158,   159,    -1,     1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    -1,    -1,    11,    -1,    -1,   174,    -1,    16,    -1,
      -1,    -1,    20,    21,    22,    -1,    -1,    -1,    -1,  4109,
      28,    -1,  4112,  4113,  4114,  4115,    -1,    -1,    -1,    -1,
      -1,    -1,  4122,    -1,    -1,    -1,    -1,    -1,   855,    -1,
      -1,    -1,    -1,    -1,    -1,  4135,    -1,    -1,    -1,   124,
      -1,  4141,   437,   438,   439,    -1,    -1,  4147,  4148,    -1,
    3690,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4159,
      -1,   456,    -1,    -1,    -1,   460,   461,   462,  4168,    -1,
      -1,    -1,    -1,    -1,   469,    -1,    -1,    -1,   163,    -1,
    3720,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,    -1,  4199,
    4200,  4201,  4202,  4203,  4204,  4205,  4206,  4207,  4208,  4209,
    4210,  4211,  4212,  4213,  4214,  4215,  4216,  4217,    -1,   339,
     340,   341,   342,    -1,    -1,    -1,    -1,    -1,    -1,  4229,
    4230,    -1,   352,    -1,   152,    -1,    -1,    -1,    -1,    -1,
     158,   159,  4242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4254,    -1,   174,    -1,   553,   379,
      -1,    -1,   340,   341,   342,    -1,  4266,    -1,    -1,    -1,
      -1,    -1,    -1,  4273,   352,    -1,    -1,  3817,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   281,  4297,  4298,    -1,
      -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4316,   437,   438,   439,
      -1,  4321,  4322,    -1,    -1,    -1,    -1,  4327,    -1,  4329,
    4330,    -1,    -1,    -1,  4334,  4335,   456,    -1,    -1,    -1,
     460,   461,   462,    -1,    -1,    -1,    -1,    -1,    -1,   469,
    4350,    -1,   472,   338,    -1,    -1,    -1,    -1,    -1,   437,
     438,   439,   280,    -1,    -1,    -1,    -1,    -1,    -1,   447,
      -1,   449,    -1,    -1,    -1,  4375,    -1,    -1,   456,    -1,
     298,    -1,   460,   461,   462,   680,    -1,  4387,  4388,    -1,
      -1,   469,   377,    -1,   472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4406,    -1,    -1,    -1,
     488,    -1,    -1,    -1,    -1,    -1,    -1,  4417,    -1,    -1,
      -1,    -1,   340,   341,   342,    -1,    -1,    -1,    -1,    -1,
      -1,  3971,    -1,   553,   352,  4435,    -1,  4437,  4438,    -1,
      -1,    -1,    -1,    -1,    -1,   363,   364,    -1,    -1,    -1,
      -1,  4451,    -1,    -1,    -1,    -1,  4456,    -1,    -1,    -1,
      -1,   379,    -1,    -1,    -1,    -1,  4466,  4467,    -1,    -1,
      -1,    -1,  4472,    -1,    -1,   553,    -1,    -1,    -1,    -1,
    4480,    -1,   560,   778,   779,   470,    -1,    -1,    -1,  4489,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,
     438,   439,   440,   441,    -1,    -1,    -1,    -1,    -1,   447,
      -1,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,
      -1,    -1,   460,   461,   462,    -1,    -1,    -1,    -1,    -1,
      -1,   469,   630,   848,   472,    -1,    -1,    -1,    -1,    -1,
     680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     488,    -1,    -1,   651,    -1,    -1,    -1,    -1,    -1,    -1,
     875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   883,   574,
     508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   907,    -1,   532,    -1,    -1,    -1,   913,    -1,
      -1,    -1,    -1,    -1,   542,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   752,   551,    -1,   553,    -1,    -1,    -1,    -1,
      -1,    -1,   560,    -1,    -1,    -1,    -1,    -1,   566,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   778,   779,
      -1,   579,    -1,    -1,    -1,    -1,   744,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,
      -1,   801,    -1,   601,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   679,    -1,   681,   682,    -1,    -1,
     778,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     830,    -1,   630,    -1,    -1,    -1,   701,    -1,    -1,    -1,
      -1,   706,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   865,    -1,    -1,    -1,    -1,
      -1,    -1,   830,    -1,    -1,   875,    -1,    -1,    -1,   744,
      -1,    -1,   680,   883,    -1,    -1,    -1,    -1,    -1,    -1,
     848,   756,    -1,    -1,   894,    -1,    -1,    -1,    -1,    -1,
      -1,   859,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,   912,   913,    -1,    -1,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   883,    -1,   927,    -1,    -1,
      -1,    -1,   890,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,   752,   913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4387,  4388,   927,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     778,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     855,    -1,    -1,    -1,    -1,    -1,     3,  4417,    -1,    -1,
      -1,     8,    -1,    -1,    -1,    12,    -1,    -1,    15,    -1,
      -1,    -1,    -1,    -1,    -1,  4435,    -1,    -1,    -1,   817,
      27,   819,    -1,   821,    -1,    -1,    -1,   825,    -1,   827,
     828,   829,   830,    -1,   832,   833,    -1,    -1,    45,    46,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    -1,    -1,  4489,
      77,    78,    79,    -1,    81,    82,    -1,   875,    -1,    86,
      -1,    -1,    89,    -1,    -1,   883,    -1,    -1,    -1,    -1,
      97,    98,    99,   100,   101,    -1,   103,   104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,   907,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,    -1,    -1,   927,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,   176,
     177,   178,   179,   180,   181,   182,    -1,    -1,    -1,   186,
      -1,   188,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,   215,    -1,
      -1,   218,   219,    -1,   221,   222,   223,   224,   225,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   268,   269,    -1,    -1,    -1,   273,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,
      -1,   288,    -1,    -1,    -1,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   311,   312,   313,   314,   315,    -1,
      -1,   318,    -1,    -1,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,    -1,
      -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     357,   358,   359,   360,    -1,    -1,    -1,    -1,    -1,   366,
     367,    -1,   369,    -1,   371,   372,   373,   374,   375,   376,
      -1,   378,    -1,   380,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   401,   402,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,   411,   412,   413,   414,   415,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   424,    -1,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,   436,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,   468,    -1,    -1,   471,    -1,    -1,    -1,   475,    -1,
     477,   478,   479,   480,    -1,    -1,    -1,    -1,    -1,    -1,
     487,    -1,    -1,    -1,    -1,    -1,   493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   504,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   512,    -1,    -1,    -1,    -1,
     517,   518,   519,    -1,   521,    -1,   523,   524,    -1,   526,
      -1,   528,   529,    -1,    -1,   532,   533,    -1,   535,   536,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   572,   573,    -1,    -1,    -1,
      -1,    -1,    -1,   580,   581,    -1,   583,    -1,    -1,    -1,
     587,    -1,    -1,    -1,    -1,    -1,    -1,   594,    -1,    -1,
      -1,    -1,    -1,   600,    -1,    -1,    -1,   604,    -1,   606,
     607,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   620,    -1,    -1,   623,   624,    -1,    -1,
      -1,   628,    -1,    -1,    -1,    -1,   633,    -1,    -1,    -1,
      -1,   638,    -1,    -1,    -1,   642,    -1,   644,   645,    -1,
      -1,    -1,   152,    -1,    -1,    -1,   653,   654,   158,   159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,    -1,   673,   674,   675,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     687,   688,   689,    -1,    -1,    -1,   693,   694,   695,   696,
     697,   698,    -1,    -1,    -1,   702,   703,    -1,    -1,    -1,
      -1,    -1,    -1,   710,   711,    -1,    -1,    -1,    -1,    -1,
      -1,   718,   719,   720,   721,    -1,    -1,    -1,    -1,   726,
      -1,    -1,    -1,    -1,   731,    -1,    -1,   734,   735,   736,
     737,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,   749,    -1,    -1,     5,    -1,   754,   755,    -1,
      10,    -1,    -1,    -1,    -1,   762,   763,    17,   765,    -1,
      -1,   768,    -1,    -1,    -1,    -1,    26,   774,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   791,   792,    -1,    -1,   795,    -1,
      -1,    -1,    -1,   800,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   808,   809,   810,    -1,    -1,    -1,   814,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,
     340,   341,   342,    -1,    -1,    -1,    -1,   844,    -1,   846,
      -1,    -1,   352,   850,    -1,    -1,    -1,    -1,    -1,   856,
      -1,    -1,    -1,    -1,    -1,    -1,   863,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   874,    -1,    -1,
      -1,   878,   879,   880,    -1,    -1,    -1,    -1,   138,    -1,
      -1,    -1,   142,    -1,   891,    -1,    -1,    -1,   895,   896,
     897,    -1,   899,   900,   901,   902,   903,    -1,    -1,    -1,
     160,    -1,   909,   910,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   921,    -1,    -1,   924,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   187,    -1,   439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,    -1,   456,   207,    -1,   209,
     460,   461,   462,   213,    -1,    -1,    -1,   217,    -1,   469,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   234,    -1,   236,    -1,    -1,    -1,
     240,   241,   242,   243,   244,    -1,   246,   247,   248,   249,
      -1,   251,   252,    -1,   254,   255,    -1,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,    -1,
      -1,    -1,    -1,   283,    -1,    -1,   286,    -1,    -1,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,    -1,    -1,
      -1,    -1,    -1,   553,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    10,    -1,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    26,    -1,   345,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   353,    -1,    -1,   356,    -1,    -1,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   395,    -1,   397,    -1,    -1,
     400,    -1,    -1,   403,    87,    88,    -1,    -1,   408,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   418,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     680,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,   142,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   160,    -1,    -1,
      -1,    -1,    -1,    -1,   484,    -1,    -1,    -1,    -1,    -1,
     490,    -1,   492,    -1,    -1,   495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   511,    -1,    -1,    -1,    -1,    -1,    -1,   201,    -1,
     520,    -1,    -1,    -1,   207,    -1,   209,    -1,   778,   779,
     213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,   539,
     540,   541,    -1,   543,   544,   545,   546,    -1,    -1,    -1,
      -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   563,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    16,   586,   270,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,
      -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   296,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   875,   626,    -1,    -1,    -1,
      -1,    -1,   632,   883,    -1,    -1,   636,    -1,    -1,   639,
     640,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    -1,     5,   656,   907,    -1,    -1,
      10,    -1,   345,   913,    -1,    -1,    -1,    17,    -1,    -1,
     353,    -1,   672,   356,    -1,    -1,    26,   677,   361,   110,
      -1,    -1,    -1,    -1,   684,    -1,    -1,    -1,    -1,    -1,
     690,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,   709,
      -1,    -1,   395,    -1,   397,    -1,    -1,   400,    -1,    -1,
     403,   152,    -1,   723,    -1,    -1,    -1,   158,   159,   729,
      -1,    -1,    -1,    -1,    -1,   418,    -1,    87,    88,    -1,
      -1,    -1,    -1,   174,    -1,   745,    -1,   747,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   761,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,   771,   772,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     780,    -1,    -1,   783,    -1,    -1,    -1,    -1,   138,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,   798,    -1,
      -1,   484,    -1,    -1,    -1,    -1,    -1,   490,    -1,   492,
     160,    -1,   495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,
      -1,   831,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,    -1,    -1,   207,   858,   209,
      -1,    -1,    -1,   213,   864,    -1,    -1,   217,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     563,    -1,    -1,    -1,   234,    -1,    -1,    -1,   888,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,    -1,     5,   586,    -1,    -1,   906,    10,    -1,   340,
     341,   342,    -1,    -1,    17,    -1,    -1,   917,    -1,    -1,
     270,   352,   922,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,
      -1,    -1,    -1,   626,    -1,    -1,   296,   297,   379,   632,
      -1,    -1,    -1,   636,    -1,    -1,   639,   640,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    87,    88,    -1,    -1,    -1,   672,
      -1,    -1,    -1,    -1,   677,   345,    -1,    -1,    -1,    -1,
     431,   684,    -1,   353,    -1,    -1,   356,   690,   439,    -1,
      -1,   361,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   709,    -1,    -1,   460,
     461,   462,    -1,    -1,    -1,   138,    -1,   387,   469,   142,
     723,   472,    -1,    -1,    -1,   395,   729,   397,    -1,    -1,
     400,    -1,    -1,   403,    -1,    -1,    -1,   160,    -1,    -1,
      -1,    -1,    -1,    -1,   747,    -1,    -1,    -1,   418,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   771,   772,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   780,   201,    -1,
     783,    -1,    -1,    -1,   207,    -1,   209,    -1,    -1,    -1,
     213,    -1,    -1,    -1,   217,   798,    -1,    -1,    -1,    -1,
      -1,    -1,   553,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   234,    -1,    -1,   484,    -1,    -1,   820,    -1,    -1,
     490,    -1,   492,    -1,    -1,   495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   511,   845,    -1,    -1,    -1,    -1,   270,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   858,    -1,    -1,    -1,    -1,
      -1,   864,    -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   296,   297,    -1,    -1,    -1,    -1,   630,
      -1,    -1,    -1,    -1,    -1,   888,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   563,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   917,    -1,   586,    -1,    -1,   922,
      -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,    -1,   680,
     353,    -1,    -1,   356,    -1,    -1,    -1,    -1,   361,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   626,    -1,    -1,    -1,
      -1,    -1,   632,    -1,   387,    -1,   636,    -1,    -1,   639,
     640,    -1,   395,    -1,   397,    -1,    -1,   400,    -1,    -1,
     403,    -1,    -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   418,    -1,    -1,    -1,    -1,
      -1,   752,   672,    -1,    -1,    -1,    -1,   677,    -1,    -1,
      -1,    -1,    -1,    -1,   684,    -1,    -1,    -1,    -1,    -1,
     690,    -1,    -1,    -1,    -1,    -1,    -1,   778,   779,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   709,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   723,    -1,    -1,    -1,    -1,    -1,   729,
      -1,   484,    -1,    -1,    -1,    -1,    -1,   490,    -1,   492,
      -1,    -1,   495,    -1,    -1,    -1,    -1,   747,    -1,   830,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,
      -1,   761,   843,    -1,    -1,    -1,    -1,   848,    -1,    -1,
      -1,   771,   772,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     780,    -1,    -1,   783,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   875,    -1,    -1,    -1,   798,    -1,
      -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     563,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,
     820,    -1,    10,    -1,    -1,    -1,   907,    -1,    -1,    17,
      -1,    -1,   913,   586,    -1,    -1,    -1,    -1,    26,    -1,
      -1,    -1,    -1,    -1,    -1,   845,   927,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   858,    -1,
      -1,    -1,    -1,    -1,   864,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   626,    -1,    -1,    -1,    -1,    -1,   632,
      -1,    -1,    -1,   636,    -1,    -1,   639,   640,   888,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    -1,    -1,   656,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   917,    -1,   672,
      -1,    -1,   922,    -1,   677,    -1,    -1,    -1,    -1,    -1,
     118,   684,    -1,    -1,    -1,    -1,    -1,   690,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,   142,    -1,   709,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     723,    -1,   160,    -1,    -1,    -1,   729,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   747,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   761,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,   771,   772,
      -1,    -1,    -1,    -1,    -1,   213,    -1,   780,    -1,   217,
     783,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   798,    -1,    -1,   236,    -1,
      -1,    -1,    -1,   241,   242,   243,   244,    -1,   246,   247,
     248,   249,    -1,   251,    -1,   253,   254,   255,    -1,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,    -1,    -1,    -1,    -1,   858,    -1,    -1,   296,   297,
      -1,   864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   888,    -1,   152,    -1,    -1,
      -1,    -1,    -1,   158,   159,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,   174,
      -1,    -1,    -1,    -1,   917,   353,    -1,    -1,   356,   922,
      -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   395,    -1,   397,
      -1,    -1,   400,    -1,    -1,   403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   484,    -1,    -1,    -1,
      -1,    -1,   490,    -1,   492,    -1,    -1,   495,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   511,    -1,   340,   341,   342,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,    -1,
      -1,    -1,     8,    -1,    -1,    -1,    -1,    -1,    -1,    15,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   563,    -1,    -1,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   586,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,   439,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,   100,    -1,    -1,    -1,    -1,    -1,
      -1,   456,    -1,    -1,    -1,   460,   461,   462,   636,   115,
      -1,    -1,    -1,    -1,   469,    -1,    -1,   472,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,   132,    -1,   656,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   677,
      -1,    -1,    -1,    -1,    -1,    -1,   684,    -1,    -1,    -1,
     166,    -1,   690,    -1,    -1,    -1,    -1,    -1,    -1,   175,
     176,   177,   178,   179,   180,   181,   182,    -1,    -1,    -1,
      -1,   709,   188,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,
      -1,   729,    -1,    -1,    -1,    -1,    -1,    -1,   214,   215,
      -1,    -1,   218,   219,    -1,    -1,    -1,   223,    -1,   747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   761,    -1,    -1,    -1,    -1,    -1,   245,
      -1,    -1,    -1,   771,   772,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   780,    -1,    -1,   783,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,    -1,    -1,
     798,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,    -1,
      -1,    -1,   288,    -1,    -1,    -1,    -1,   293,   294,    -1,
      -1,    -1,   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   311,   312,   313,   314,   315,
      -1,    -1,   318,    -1,    -1,    -1,    -1,   845,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,
     858,    -1,    -1,    -1,    -1,    -1,   864,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   357,   358,   359,   360,    -1,    -1,    -1,    -1,    -1,
     366,   367,    -1,   369,    -1,   371,   372,   373,    -1,    -1,
     376,    -1,   378,    -1,    -1,    -1,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   917,
      -1,    -1,    -1,    -1,   922,   401,   402,   752,    -1,    -1,
      -1,    -1,    -1,    -1,   410,   411,   412,   413,   414,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   424,    -1,
      -1,    -1,   428,   778,   779,    -1,   432,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,   475,
      -1,   477,   478,   479,   480,   830,    -1,    -1,    -1,    -1,
      -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   848,    -1,    -1,    -1,    -1,   504,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     875,    -1,    -1,    -1,    -1,    -1,   532,    -1,   883,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   547,   548,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,   913,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   927,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   594,    -1,
      -1,    -1,    -1,    -1,   600,    -1,    -1,    -1,   604,    -1,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   620,    -1,    -1,   623,   624,    -1,
      -1,    -1,   628,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   642,    -1,   644,   645,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   653,   654,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   673,   674,   675,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   693,   694,   695,
     696,    -1,   698,    -1,    -1,    -1,   702,   703,    -1,    -1,
      -1,    -1,    -1,    -1,   710,   711,    -1,    -1,    -1,    -1,
      -1,    -1,   718,   719,   720,    -1,    -1,    -1,    -1,    -1,
     726,    -1,    -1,    -1,    -1,   731,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   762,   763,     8,    -1,
      -1,    -1,   768,    -1,    -1,    15,    -1,    -1,   774,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   791,   792,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   800,    45,    -1,    -1,    -1,    -1,
      -1,    -1,   808,    -1,    -1,    -1,    -1,    -1,   814,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,   844,    -1,
      -1,    -1,    -1,    -1,   850,    -1,    -1,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    11,    -1,
      -1,    -1,    -1,    16,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,   132,    -1,    -1,   891,    -1,    -1,    -1,    -1,
      -1,   897,    -1,   899,    -1,    -1,   902,    -1,    -1,    -1,
      -1,    -1,    -1,   909,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   921,   166,    -1,   924,    -1,
      -1,    -1,    -1,    -1,    -1,   175,   176,   177,   178,   179,
     180,   181,   182,    -1,    -1,    -1,    -1,    -1,   188,   189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   214,   215,    -1,    -1,   218,   219,
      -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,
      -1,    -1,    -1,    -1,    -1,   158,   159,    -1,    -1,   269,
      -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,   288,    -1,
      -1,    -1,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   311,   312,   313,   314,   315,    -1,    -1,   318,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   357,   358,   359,
     360,    -1,    -1,    -1,    -1,    -1,   366,   367,    -1,   369,
      -1,   371,   372,   373,    -1,    -1,   376,   270,   378,    -1,
      -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   401,   402,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     410,   411,   412,   413,   414,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   424,    -1,    -1,    -1,   428,   429,
      -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,   342,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   471,    -1,    -1,    -1,   475,    -1,   477,   478,   479,
     480,    -1,    -1,    -1,    -1,    -1,   379,   487,    -1,    11,
      -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   512,    -1,    -1,    -1,    -1,    -1,    -1,    41,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   437,   438,   439,   547,   548,    -1,
      -1,    -1,    74,    75,   447,    -1,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,    -1,    -1,    -1,   460,   461,   462,
      -1,    -1,    -1,    -1,    -1,    -1,   469,    -1,    -1,   472,
     580,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   594,   488,    -1,    -1,    -1,    -1,
     600,   123,   124,    -1,   604,   127,   606,   607,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,    16,    -1,
     620,    -1,    -1,   623,   624,    -1,    -1,    -1,   628,    -1,
     152,    -1,    -1,    -1,    -1,    -1,   158,   159,    -1,    -1,
      -1,   163,   642,    -1,   644,   645,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   653,   654,    -1,    -1,    -1,    -1,    -1,
     553,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   673,   674,   675,    11,    -1,    -1,    -1,
      -1,    16,    -1,    -1,    -1,    -1,   579,    -1,    -1,    -1,
      -1,    -1,    -1,   693,   694,   695,   696,    -1,   698,    -1,
      -1,    -1,   702,   703,    -1,    -1,    -1,    -1,    -1,    -1,
     710,   711,    -1,    -1,    -1,    -1,    -1,    -1,   718,   719,
     720,    -1,    -1,    -1,    -1,    -1,   726,    -1,    -1,    -1,
      -1,   731,    -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,
      -1,    -1,    -1,    -1,   152,    -1,    -1,    -1,    -1,   281,
     158,   159,   762,   763,    -1,    -1,    -1,    -1,   768,    -1,
     168,    -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,
      -1,   791,   792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   808,    -1,
      -1,    -1,    -1,    -1,   814,    -1,   338,   152,   340,   341,
     342,    -1,    -1,   158,   159,    -1,    -1,    -1,    -1,    -1,
     352,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,   174,
      -1,    -1,    -1,    -1,   844,    -1,    -1,    -1,    -1,    -1,
     850,   744,    -1,    -1,    -1,   377,    -1,   379,    -1,   752,
      -1,    11,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,
      20,    21,    22,    -1,    -1,    -1,    -1,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    -1,   778,   779,    -1,    -1,    -1,
      -1,   891,    -1,    -1,    -1,    -1,    -1,   897,    -1,   899,
      -1,    -1,   902,    -1,    -1,    -1,    -1,    -1,    -1,   909,
      -1,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,   921,    -1,    -1,   924,   447,   448,   449,    -1,    -1,
     823,    -1,    -1,    -1,   456,    -1,    -1,   830,   460,   461,
     462,   834,   340,   341,   342,    -1,    -1,   469,   470,    -1,
     472,    -1,    -1,    -1,   352,   848,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,    -1,   488,   489,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     883,    -1,    -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,    -1,    -1,   340,   341,   342,   158,   159,
      -1,    -1,    -1,    -1,   907,    -1,    -1,   352,    -1,    -1,
     913,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
      -1,   553,    -1,    -1,   927,    -1,    -1,    -1,    -1,   437,
     438,   439,    -1,    -1,   379,    -1,    -1,    -1,    -1,   447,
      -1,   449,   574,    -1,    -1,    -1,    -1,   579,   456,    -1,
      -1,    -1,   460,   461,   462,    -1,    -1,    -1,    -1,    -1,
      -1,   469,    -1,    -1,   472,    -1,   598,   599,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     488,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   437,   438,   439,    11,    -1,    -1,   630,    -1,
      16,    -1,   447,    -1,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,    -1,    -1,    -1,   460,   461,   462,    -1,    -1,
     280,    -1,    -1,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   298,    -1,
      -1,    -1,    -1,   488,    -1,   553,    -1,   679,   680,   681,
     682,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   701,
      -1,   579,    -1,    -1,   706,    -1,    -1,    -1,    -1,    -1,
     340,   341,   342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   363,   364,    -1,    -1,    -1,   553,    -1,
      -1,    -1,   744,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     752,    -1,   630,    -1,   756,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   579,    -1,   152,    -1,    -1,    -1,
      -1,    -1,   158,   159,    -1,    -1,   778,   779,    -1,   409,
      -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,   174,    -1,
      16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   680,    -1,    -1,    -1,    -1,   437,   438,   439,
     440,   441,    -1,    -1,    -1,   630,    -1,   447,    -1,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,   830,    -1,
     460,   461,   462,    -1,    -1,    -1,    -1,    -1,    -1,   469,
      11,    -1,   472,    -1,    -1,    16,   848,    -1,    -1,    -1,
      -1,    -1,    -1,   855,    -1,    -1,    -1,    -1,   488,    -1,
      -1,    -1,    -1,    -1,    -1,   680,    -1,   869,    -1,    -1,
      -1,    -1,    -1,   875,   752,    -1,    -1,    -1,   508,    -1,
      -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     778,   779,   532,    -1,    -1,   907,    -1,    -1,    -1,    -1,
     912,   913,   542,    -1,    -1,   793,    -1,    -1,    -1,    -1,
      -1,   551,    -1,   553,    -1,   927,   152,    -1,    -1,    -1,
     560,    -1,   158,   159,    -1,    -1,   566,   752,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,   579,
      -1,    -1,   830,    -1,   340,   341,   342,    -1,    -1,    -1,
      -1,    -1,    -1,   778,   779,    -1,   352,    -1,    -1,    -1,
     848,   601,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,    -1,    -1,    -1,    -1,    -1,   158,   159,    -1,
      -1,    -1,    -1,   379,    -1,    -1,    -1,   875,    -1,    -1,
     630,    -1,    -1,   174,    -1,   883,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   830,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,   848,    -1,   913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,
     680,   437,   438,   439,    -1,    -1,    -1,    -1,    -1,    -1,
     875,   447,    -1,   449,    -1,    -1,    -1,    -1,   883,    -1,
     456,    -1,    -1,    -1,   460,   461,   462,    -1,    -1,    -1,
      -1,    -1,    -1,   469,    11,    -1,   472,    -1,    -1,    16,
      -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,   913,    -1,
      -1,    -1,   488,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   927,    -1,   340,   341,   342,    -1,    -1,    -1,
      -1,    -1,   752,    -1,    -1,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    -1,    -1,    -1,    -1,    16,    -1,    -1,   778,   779,
      -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,   340,
     341,   342,    -1,    -1,    -1,   346,    -1,    -1,    -1,    -1,
      -1,   352,    -1,    -1,    -1,    -1,    -1,   817,    -1,   819,
      -1,   821,    -1,   579,    -1,   825,    -1,   827,   828,   829,
     830,    -1,   832,   833,    -1,    -1,    -1,    -1,   379,    -1,
      -1,   437,   438,   439,    -1,    -1,    -1,    -1,   848,    -1,
      -1,   447,    -1,   449,    -1,   152,    -1,    -1,    -1,    -1,
     456,   158,   159,    -1,   460,   461,   462,    -1,    -1,    -1,
      -1,    -1,    -1,   469,   630,   875,   472,   174,    -1,    -1,
      -1,    -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   488,    -1,    11,    -1,   437,   438,   439,    16,
      -1,    -1,    -1,    -1,    -1,    -1,   447,   907,   449,    -1,
      -1,   152,    -1,   913,    -1,   456,    -1,   158,   159,   460,
     461,   462,    -1,    -1,   680,    -1,    -1,   927,   469,    -1,
      -1,   472,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   488,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,
      -1,    -1,    -1,    -1,   560,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   579,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   553,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   778,   779,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   630,   152,    -1,    -1,   579,    -1,
      -1,   158,   159,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   352,    -1,   174,    -1,   815,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   830,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,    -1,   680,    -1,    -1,    -1,    -1,   630,
      -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,   342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   883,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   680,
     437,   438,   439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     447,   907,   449,    -1,    -1,    -1,   752,   913,    -1,   456,
      -1,    -1,    -1,   460,   461,   462,    -1,    -1,    -1,    -1,
      -1,   927,   469,    -1,    -1,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   778,   779,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   488,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   447,    -1,   449,    -1,
      -1,   752,    -1,    -1,    -1,   456,    -1,    -1,    -1,   460,
     461,   462,    -1,   340,   341,   342,    -1,    -1,   469,    -1,
      -1,   472,    -1,    -1,   830,   352,    -1,   778,   779,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   488,    -1,    -1,
      -1,    -1,   848,    -1,    -1,    -1,   553,    -1,    -1,    -1,
      -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,
      -1,    -1,   579,    -1,    -1,    -1,    -1,   883,    -1,   830,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,    -1,
      -1,   907,   553,    -1,    -1,    -1,    -1,   913,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     447,   927,   449,   630,   875,    -1,    -1,    -1,   579,   456,
      -1,    -1,   883,   460,   461,   462,    -1,    -1,    -1,    -1,
      -1,    -1,   469,     1,    -1,   472,    -1,    -1,    -1,     7,
      -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,
      -1,   488,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   680,    -1,    -1,   927,    -1,    -1,   630,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,
      -1,    49,    50,    51,    52,    53,    -1,    -1,    56,    57,
      58,    59,    60,    61,    -1,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,   680,
      -1,    -1,    -1,    -1,    -1,    -1,    94,   744,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,
      -1,    -1,   579,   111,    -1,    -1,    -1,    -1,   116,    -1,
      -1,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,   127,
      -1,   778,   779,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,    -1,    -1,   141,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   752,    -1,   630,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   830,    -1,    -1,    -1,   778,   779,    -1,
      -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   680,    -1,   213,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   883,    -1,    -1,   830,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,    -1,
     907,    -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   272,    -1,    -1,    -1,    -1,    -1,
     927,    -1,    -1,   281,   875,   752,    -1,    -1,    -1,    -1,
      -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   778,   779,    -1,    -1,    -1,   907,    -1,   316,    -1,
      -1,    -1,   913,    -1,    -1,    -1,    -1,   325,   326,   327,
     328,   329,    -1,    -1,   332,   333,   927,    -1,    -1,    -1,
     338,    -1,    -1,    -1,    -1,   343,    -1,     1,   346,    -1,
     348,    -1,    -1,    -1,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   830,    -1,    -1,    -1,   365,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,   377,
      -1,   848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
      54,    -1,    -1,    57,    58,    59,    60,    61,   875,    63,
      64,   409,    -1,    -1,    -1,    -1,   883,    -1,    -1,    -1,
      74,   419,    -1,    -1,    -1,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,    -1,    -1,
     907,    -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,
     448,    -1,    -1,    -1,   452,    -1,    -1,   455,    -1,    -1,
     927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,    -1,
      -1,    -1,   500,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   515,    -1,    -1,
      -1,    -1,    -1,    -1,   522,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   554,    16,   556,   213,
     558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   574,   575,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   591,    -1,    -1,    -1,    -1,   596,    -1,
     598,   599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   619,    -1,    -1,   622,    84,    -1,    -1,    -1,   627,
      -1,    -1,    -1,   631,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   301,   302,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,   316,    -1,     4,    -1,    -1,    -1,    -1,   667,
      -1,   325,   326,   327,   328,   329,    -1,    -1,   332,   333,
      -1,   679,    -1,   681,   682,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,    -1,    -1,    -1,    -1,   158,
     159,   355,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   707,
      -1,    -1,    -1,    -1,   368,   174,   714,    57,    58,    59,
      60,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,   385,    -1,    -1,    74,    -1,    -1,    -1,   392,    -1,
     738,    -1,   740,   741,   742,    -1,   744,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,   756,    -1,
      -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,    -1,   767,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,   126,   127,    -1,   443,
      -1,    -1,   790,   133,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   141,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,    -1,    -1,    -1,    -1,   815,    -1,    -1,
      -1,    -1,   820,    -1,    -1,    -1,    -1,    -1,   826,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   843,   500,    -1,    -1,   847,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   855,    -1,    -1,
      -1,    -1,   860,   861,   862,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,   876,    -1,
     339,   340,   341,   342,    -1,    -1,   884,    -1,    -1,    -1,
      -1,    -1,   890,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   556,    -1,    -1,    -1,    -1,   905,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
     379,   575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   591,    -1,    -1,
      -1,    -1,   596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   619,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,   325,   326,   327,   328,   329,
      -1,    -1,   332,   333,    -1,   649,    -1,   456,    -1,    -1,
      -1,   460,   461,   462,    -1,    -1,    -1,    -1,    -1,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,    -1,    -1,    -1,    -1,   701,    -1,    -1,
      -1,    12,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   419,
      -1,    -1,    -1,    -1,   738,    46,   740,   741,   742,    -1,
      -1,   431,    -1,    -1,   553,    -1,    -1,    -1,    -1,   753,
      -1,    -1,    -1,    -1,    65,    -1,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,    -1,    -1,    77,    78,    79,    -1,
      -1,    82,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,   786,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,    -1,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     500,    -1,    -1,    -1,    -1,    -1,   820,    -1,    -1,    -1,
     131,   630,    -1,   513,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   843,
      -1,    -1,    -1,    -1,    -1,    -1,   850,   851,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   860,   861,   862,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,
      -1,   680,   876,    -1,    -1,   186,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   575,   890,    -1,   199,    -1,
      -1,    -1,    -1,    -1,   898,    -1,    -1,    -1,    -1,    -1,
      -1,   591,    -1,    -1,    -1,    -1,   596,    -1,    -1,   913,
     221,   222,   602,   224,   225,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   619,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   268,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   778,
     779,    -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   801,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   830,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   344,    -1,    -1,    -1,    -1,   349,   848,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   738,    -1,
     740,   741,   742,    -1,    -1,    -1,   865,    -1,    -1,    -1,
     750,    -1,    -1,   374,   375,    -1,   875,    -1,    -1,   380,
     381,    -1,    -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   894,    -1,    -1,    -1,    -1,
      -1,    -1,   782,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,    -1,   912,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,
      -1,    -1,    -1,   434,    -1,   436,    -1,    -1,    -1,    -1,
     820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   843,    -1,   466,   467,   468,    -1,    -1,
     850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     860,   861,   862,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   493,    -1,    -1,    -1,   876,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     890,    -1,    -1,    -1,   894,    -1,   517,   518,   519,    -1,
     521,    -1,   523,   524,    -1,   526,    -1,   528,   529,    -1,
      -1,    -1,   533,   913,   535,   536,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   559,    -1,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   572,   573,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     581,    -1,    -1,    -1,    -1,    -1,   587,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    58,    59,    60,    61,    -1,    63,
      64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    -1,   633,    -1,    -1,    -1,    -1,   638,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   123,
      -1,    -1,   126,   127,    -1,    -1,   687,   688,   689,   133,
      -1,    -1,    -1,    -1,    -1,    -1,   697,   141,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     721,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   734,   735,   736,   737,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   754,   755,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   765,    -1,    -1,    -1,    -1,   213,
      41,    -1,    -1,    44,    -1,    -1,    -1,    -1,    49,    50,
      51,    52,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   795,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    -1,    -1,    -1,   809,   810,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   846,    -1,    -1,    -1,    -1,
      -1,    -1,   123,   124,    -1,   856,   127,    -1,    -1,    -1,
      -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   874,    -1,    -1,    -1,   878,   879,   880,
      -1,   325,   326,   327,   328,   329,    -1,    -1,   332,   333,
     161,    -1,   163,    -1,   895,   896,    -1,    -1,    -1,   900,
     901,    -1,   903,    -1,   175,    -1,    41,    -1,    -1,   910,
      -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,
      -1,    56,   366,    -1,   368,    -1,    -1,   198,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    -1,    77,    -1,    79,    -1,    -1,    -1,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   123,   124,
      -1,    -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   163,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   500,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   347,   348,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,
      -1,    -1,   556,    -1,    -1,    54,    -1,    -1,    57,    58,
      59,    60,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,
      -1,   575,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   281,   591,    -1,    -1,
     421,    -1,   596,    -1,    -1,    -1,    -1,    -1,   602,    -1,
      -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   619,    -1,   448,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,   470,
      -1,    -1,   141,   338,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,    -1,    -1,    -1,    -1,   489,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   377,    -1,   515,    -1,    -1,    -1,    -1,    -1,
      -1,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   558,    -1,    -1,
      -1,    -1,    -1,    -1,   738,    -1,   740,   741,   742,   434,
      -1,    -1,    -1,   574,    -1,    -1,   750,    -1,    -1,    -1,
      -1,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   598,   599,    -1,
      -1,    -1,    -1,    -1,    -1,   470,    -1,    -1,   782,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   622,    -1,    -1,   625,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   820,    -1,    -1,    -1,
     515,    -1,    -1,    -1,    -1,    -1,   325,   326,   327,   328,
     329,    -1,    -1,   332,   333,    -1,   667,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   850,    -1,   679,    -1,
     681,   682,    -1,    -1,    -1,    -1,   860,   861,   862,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
     701,    -1,   876,    -1,    -1,   706,    -1,    -1,    -1,   574,
      -1,    -1,    -1,   714,    -1,    -1,   890,    -1,    -1,    -1,
     894,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   597,   598,   599,    -1,    -1,    -1,    -1,    -1,
     409,    29,    -1,   744,    -1,    -1,    -1,    -1,    -1,    -1,
     419,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,    -1,
      -1,    -1,   431,    -1,    -1,    -1,    54,    -1,    -1,    57,
      58,    59,    60,    61,   443,    63,    64,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,   790,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   810,
     811,    -1,    -1,    -1,   679,    -1,   681,   682,    -1,    -1,
      -1,    -1,   687,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   500,    -1,    -1,    -1,    -1,   701,    -1,    -1,    -1,
      -1,   706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   141,   855,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,    -1,   867,   732,    -1,    -1,
      -1,    -1,    -1,   874,    -1,    -1,    -1,    -1,    -1,   744,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,    -1,
      -1,   756,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   575,    -1,    -1,    -1,
      -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   591,    -1,    -1,   213,    -1,   596,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   813,    -1,
     619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     855,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   701,    -1,    -1,    -1,    -1,   325,   326,   327,
     328,   329,    -1,    -1,   332,   333,    -1,   912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   738,
      -1,   740,   741,   742,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   786,    -1,    -1,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   431,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   820,    -1,    44,    -1,   443,    -1,    -1,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    58,    59,    60,
      61,    -1,    63,    64,   843,    -1,    -1,    -1,    -1,    -1,
      -1,   850,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,   860,   861,   862,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    94,    -1,    -1,    -1,   876,    -1,    -1,
      -1,    -1,   500,    -1,    -1,    -1,    -1,   152,    -1,    -1,
      -1,   890,    -1,   158,   159,   116,    -1,    -1,    -1,   898,
      -1,    -1,   123,   124,    -1,    -1,   127,    -1,    -1,   174,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     141,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   172,    -1,    -1,    -1,    -1,    -1,   575,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   591,    -1,    -1,    -1,    -1,   596,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,   342,    -1,    -1,
      -1,    -1,    -1,   701,    -1,    -1,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   325,   326,   327,   328,   329,    -1,
      -1,   332,   333,    -1,   379,    -1,    -1,   338,    -1,    -1,
     738,    -1,   740,   741,   742,   346,    -1,   348,    -1,    -1,
      -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   365,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    44,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,    -1,   786,    -1,
      56,   392,   437,   438,   439,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   447,    -1,   449,    -1,    -1,    -1,   409,    75,
      -1,   456,    -1,    -1,    -1,   460,   461,   462,   419,    -1,
      -1,    -1,   820,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   843,    -1,   448,    -1,    -1,
      -1,   452,   850,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,    -1,   860,   861,   862,    -1,    -1,    -1,    -1,   470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   876,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   890,    -1,    -1,   161,    -1,   163,    -1,   500,
     898,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,   175,
      -1,    -1,    -1,    -1,   515,    -1,    -1,    -1,    -1,    -1,
      -1,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   198,    -1,   579,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   556,    -1,   558,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   574,   575,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,    -1,
     591,    -1,    -1,    -1,    -1,   596,    44,   598,   599,    -1,
      -1,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      58,    59,    60,    61,    -1,    63,    64,    -1,   619,    -1,
      -1,   622,    -1,    -1,    -1,    -1,    74,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   667,    -1,   116,    -1,
      -1,    -1,   338,    -1,    -1,   123,   124,    -1,   679,   127,
     681,   682,   348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   141,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,    -1,    -1,   752,    -1,    -1,
      -1,   377,    -1,   714,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,    -1,   172,    -1,    -1,    -1,   158,   159,
      -1,    -1,    -1,   778,   779,    -1,    -1,   738,    -1,   740,
     741,   742,    -1,   744,   174,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,   435,
      -1,    -1,   817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   828,   152,   830,    -1,   832,   833,   790,
     158,   159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   467,    -1,   848,   470,    -1,   174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   815,    -1,    -1,    -1,    -1,   820,
      -1,    -1,    -1,    -1,    -1,   826,    -1,    -1,    -1,    -1,
     875,    -1,    -1,   281,    -1,    -1,    -1,    -1,   883,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   855,    -1,   522,    -1,    -1,   860,
     861,   862,   907,    -1,    -1,    -1,    -1,    -1,   913,    -1,
      -1,    -1,    -1,    -1,    -1,   876,    -1,   325,   326,   327,
     328,   329,   927,   884,   332,   333,    -1,    -1,    -1,   890,
     338,    -1,   558,    -1,    -1,    -1,    -1,    -1,   346,    -1,
     348,    -1,    -1,    -1,    -1,    -1,    -1,   355,   574,    -1,
     340,   341,   342,    -1,    -1,    -1,    -1,   365,    -1,    -1,
     368,    -1,   352,    -1,    -1,    -1,    -1,    -1,   152,   377,
      -1,    -1,    -1,    -1,   158,   159,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,   379,
     174,    -1,    -1,    -1,    -1,    -1,   622,    -1,    -1,   625,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   419,   340,   341,   342,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,    -1,    -1,   435,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     448,   667,    -1,    -1,   452,    -1,    -1,   437,   438,   439,
      -1,   379,    -1,   679,    -1,   681,   682,   447,    -1,   449,
      -1,    -1,   470,    -1,    -1,    -1,   456,    -1,    -1,    -1,
     460,   461,   462,    -1,    -1,   701,    -1,    -1,    -1,   469,
     706,    -1,   472,    -1,    -1,    -1,    -1,    -1,   714,    -1,
      -1,    -1,   500,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   515,    -1,   437,
     438,   439,    -1,    -1,   522,    -1,    -1,    -1,   744,   447,
      -1,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,
     756,    -1,   460,   461,   462,    -1,    -1,    -1,    -1,    -1,
      -1,   469,    -1,    -1,   472,    -1,    -1,    -1,   556,    -1,
     558,    -1,    -1,    -1,    -1,    -1,   340,   341,   342,    -1,
      -1,    -1,    -1,   553,   790,    -1,   574,   575,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   591,    -1,   811,    -1,    -1,   596,   579,
     598,   599,    -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,
      -1,    -1,   152,    -1,    -1,    -1,    -1,    -1,   158,   159,
      -1,   619,    -1,    -1,   622,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,   553,    -1,    -1,    -1,   855,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     630,   867,    -1,    -1,    -1,    -1,    -1,    -1,   874,    -1,
      -1,   579,    -1,   437,   438,   439,    -1,    -1,    -1,   667,
      -1,    -1,    -1,   447,    -1,   449,    -1,    -1,    -1,    -1,
      -1,   679,   456,   681,   682,    -1,   460,   461,   462,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,    -1,   472,    -1,
     680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   630,    -1,    -1,    -1,   714,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     738,    -1,   740,   741,   742,    -1,   744,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   756,    -1,
      -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,   553,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   790,    -1,    -1,    -1,    -1,    -1,   778,   779,
     340,   341,   342,    -1,    -1,   579,    -1,    -1,   152,    -1,
      -1,    -1,   352,    -1,   158,   159,    -1,   815,    -1,    -1,
      -1,    -1,   820,    -1,    -1,    -1,    -1,    -1,   826,    -1,
     174,    -1,    -1,    -1,   752,    -1,    -1,   817,    -1,   379,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   828,    -1,
     830,    -1,   832,   833,    -1,    -1,   630,   855,    -1,    -1,
     778,   779,   860,   861,   862,    -1,    -1,    -1,   848,    -1,
      -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,   876,    -1,
      -1,    -1,    -1,   152,    -1,    -1,   884,    -1,    -1,   158,
     159,    -1,   890,    -1,    -1,   875,    -1,   437,   438,   439,
      -1,    -1,    -1,   883,    -1,   174,   680,   447,    -1,   449,
     828,    -1,   830,    -1,   832,   833,   456,    -1,    -1,    -1,
     460,   461,   462,    -1,    -1,    -1,    -1,   907,    -1,   469,
     848,    -1,   472,   913,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   883,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,   152,   913,   340,   341,   342,    -1,
     158,   159,    -1,    -1,   778,   779,    -1,    -1,   352,   927,
      -1,    -1,    -1,   553,    -1,   789,   174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     152,    -1,    -1,    -1,    -1,   379,   158,   159,    -1,   579,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   174,    -1,   828,    -1,   830,    -1,   832,   833,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,   342,   848,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
     630,    -1,    -1,   437,   438,   439,    -1,    -1,    -1,    -1,
      -1,   875,    -1,   447,    -1,   449,    -1,    -1,    -1,   883,
     379,    -1,   456,    -1,    -1,    -1,   460,   461,   462,    -1,
      -1,    -1,    -1,    -1,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,   913,
     680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   927,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,    -1,
     449,    -1,   340,   341,   342,    -1,    -1,   456,    -1,    -1,
      -1,   460,   461,   462,   352,    -1,    -1,    -1,    -1,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,   553,
      -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,   340,   341,
     342,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,   579,    -1,    -1,   778,   779,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,   437,
     438,   439,    -1,    -1,   553,    -1,   630,    -1,   828,   447,
     830,   449,   832,   833,    -1,    -1,    -1,    -1,   456,    -1,
      -1,    -1,   460,   461,   462,    -1,    -1,    -1,   848,    -1,
     579,   469,    -1,    -1,   472,   437,   438,   439,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   447,    -1,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   875,   680,    -1,   460,   461,
     462,    -1,    -1,   883,    -1,    -1,    -1,   469,    -1,    -1,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   630,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,    -1,    -1,
      -1,    -1,   671,    -1,    -1,    -1,    -1,    -1,   752,    -1,
      -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   553,    -1,    -1,   778,   779,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   579,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   752,   828,    -1,   830,    -1,   832,   833,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   848,    -1,    -1,    -1,   630,   778,
     779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   883,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,
      -1,   830,    -1,   907,    -1,    -1,    -1,    -1,    -1,   913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,
      -1,    -1,    -1,   927,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,
     869,    -1,    -1,    -1,    -1,    -1,   875,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,
     778,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   778,   779,   927,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   830,    -1,   832,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   830,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   883,   848,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,   875,    -1,   913,    -1,    -1,    -1,    -1,
      -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,
      -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   927
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   930,   931,     0,   932,   933,   934,   937,   938,   384,
     386,   935,   936,   939,   940,   950,   951,   952,   565,   947,
     965,   936,   351,   617,   953,   956,   220,   820,   274,   974,
     975,   957,   954,   947,   947,   820,    36,   966,   967,   220,
     948,   154,   976,   977,   820,   820,   256,   941,   942,   943,
     250,   945,   409,  2176,   198,   969,   820,   187,  1137,  1139,
    1140,   713,   399,  1057,  1058,    19,   112,   170,   173,   175,
     196,   289,   459,   551,   555,   666,   705,   751,   753,   785,
     835,   913,   978,   979,   980,   981,   985,   999,  1005,  1006,
    1007,  1008,  1009,  1015,  1031,  1033,  1038,  1041,  1046,  1047,
    1049,  1050,  1051,  1052,  1053,  1054,  1055,   456,   618,   958,
     958,   944,   943,   946,   503,   756,   759,   760,   968,   691,
     271,   970,   220,   949,   824,  1141,   820,   713,   307,  1059,
       1,   913,  2052,  2052,   766,   738,  2204,  2176,  2176,  2176,
    2052,   738,   820,   820,  2176,   820,   820,   110,   155,  2157,
    1056,  1010,   980,     1,   820,  1008,   390,  1032,    37,   960,
     960,   456,   618,   959,   959,   489,  2188,  2176,   404,   972,
     820,   612,  1415,  1416,  1420,   713,  1142,   820,   820,  1060,
    1016,   337,  1044,  2167,  2176,  2176,   913,  2045,  2099,   135,
    2045,  2176,  2176,   986,  1000,  2045,   982,   913,  1039,  1040,
    1203,   913,  1034,  1035,  1036,  2053,  2176,   456,   558,   561,
    1011,  1013,  1014,  1814,  2105,  2176,   913,   456,   820,   955,
     820,   820,  2176,   119,   769,   822,   971,   692,   820,   220,
    1445,  1446,   820,   304,   708,  1138,  1143,  1144,  1146,   417,
     717,  1061,  1120,  1121,  1017,  1020,  1021,  2167,  2176,    23,
     500,  2045,   456,   390,   557,  2228,   456,   843,   109,   481,
     616,   716,   913,   987,   988,   989,   990,   991,   995,   996,
     998,  2156,  2199,   350,   616,  1001,  1002,  1003,   983,   998,
    1040,  2176,  1035,    31,   409,  2053,  2178,  2052,  1814,   409,
     766,  2195,  2176,   170,  2052,   961,  2176,    48,   505,   506,
     507,   621,   836,   837,   849,  2138,  2176,  1417,     1,     5,
      10,    17,    26,    87,    88,   118,   138,   142,   160,   201,
     207,   209,   213,   217,   234,   270,   286,   296,   297,   345,
     353,   356,   361,   387,   395,   397,   400,   403,   418,   484,
     490,   492,   495,   511,   563,   586,   626,   632,   636,   639,
     640,   656,   672,   677,   684,   690,   709,   723,   729,   747,
     761,   771,   772,   780,   783,   798,   820,   845,   858,   864,
     888,   917,   922,  1447,  1448,  1477,  1482,  1487,  1492,  1518,
    1522,  1530,  1534,  1535,  1539,  1542,  1547,  1552,  1604,  1608,
    1610,  1615,  1631,  1639,  1643,  1646,  1649,  1653,  1654,  1661,
    1671,  1674,  1677,  1695,  1704,  1708,  1710,  1714,  1717,  1721,
    1735,  1749,  1751,  1755,  1770,  1771,  1781,  1784,  1785,  1789,
    1795,  1796,  1804,  1811,  1828,  1838,  1847,  1853,  1864,  1868,
    1870,  1873,  1876,  1879,  1890,  1909,  1917,  1942,  1447,   915,
    1193,  1195,  1196,     1,   913,  2033,   820,   532,   564,  2135,
      30,   494,   669,   701,  1122,  1123,  1124,  1125,  1127,  1128,
    1129,  1134,  1018,  1019,    23,   500,   379,   456,   472,   630,
     752,   830,   927,  1042,  1043,  2109,   912,  1048,  2219,  2099,
     725,   744,  2207,  2176,   820,   989,   820,   913,   988,   113,
     122,   992,  2158,    16,   352,   913,  1004,   913,     1,   820,
    1003,   984,  2219,    16,   379,   456,   472,   630,   752,   830,
     927,  2110,  2111,  2112,   456,  1037,  2106,  2195,   409,  2052,
    2052,  1012,  1013,   820,   139,   301,   648,   826,   962,   963,
     964,   505,   506,   621,   849,   973,    85,   488,   577,   764,
     769,   822,  1499,  1500,     5,    10,    17,    26,    87,    88,
     118,   138,   142,   160,   201,   213,   217,   236,   241,   242,
     243,   244,   246,   247,   248,   249,   251,   253,   254,   255,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   270,   286,   296,   297,   345,   353,   356,   361,   387,
     395,   397,   400,   403,   484,   490,   492,   495,   511,   563,
     586,   636,   656,   677,   684,   690,   709,   729,   747,   761,
     771,   772,   780,   783,   798,   820,   845,   858,   864,   917,
     922,  2142,  2143,  2144,  1449,  1478,  1483,  1488,  1493,  1519,
    1523,  1531,  1536,  1543,  1540,  1548,  1553,  1605,  1609,   337,
    1611,  1616,  1632,  1640,  1644,  1647,  1650,   354,   678,  1510,
    1642,  1655,  1662,  1672,  1675,  1678,   353,   584,  1709,  1711,
    1715,  1718,   724,  1722,  1736,  1750,  1752,  1756,  1772,  1782,
    1786,  1790,  1797,  1805,  1812,  1829,  1839,   456,   630,   699,
     752,   805,   927,  1851,  1852,  2001,  2093,  2094,  2099,  1854,
    1865,   610,  1869,  1871,  1434,  1874,  1877,  1880,  1891,  1910,
     353,   584,   713,   140,  1174,   233,   730,   743,  1197,  1198,
    1200,  1211,  1213,  1215,  2127,   820,  1145,   564,  2052,   138,
     167,   184,   185,   300,   465,   476,   605,   643,   660,   918,
     919,  1130,   561,  1135,  2193,   641,   747,   748,  1126,     1,
     820,  1124,  2176,  2176,   390,  1043,  1045,   807,   592,  2176,
    2105,   820,  2176,   727,   406,   960,     1,   352,   406,   960,
     820,   820,   195,  2112,   816,  2106,  2052,   964,  2199,   139,
     912,  1496,   560,   913,  1450,  1453,  1454,  1455,  2034,  2093,
      11,   152,   158,   159,   168,   174,   340,   341,   342,   352,
     437,   438,   439,   447,   449,   460,   461,   462,   469,   488,
     553,   579,   680,   778,   779,   793,   848,   875,   883,   907,
    1479,  2025,  2057,  2058,  2060,  2061,  2093,  2110,  2114,  2115,
    2116,  2117,  2236,   828,   832,   833,  1484,  2020,  2021,  2022,
    2023,  2024,  2025,  2061,  2064,  2093,  2111,  2114,   456,  1489,
    1490,  2041,  2042,  2043,  2099,  1494,  1499,   456,   618,  1520,
    1521,  2077,  2093,   911,  1524,  1525,  1527,  2033,    11,  1532,
    2025,  2026,  2027,  2055,  2096,  2097,  2099,  2111,    14,  1537,
     824,  1544,  2033,    16,  1541,  2093,  2095,   398,   416,   571,
     797,  1549,  1551,   281,   334,   391,   456,   485,   560,   756,
     781,   826,   911,  1554,  1555,  1556,  1557,  1559,  1567,  1569,
    1570,  1571,  1574,  1579,  1582,  1583,  1586,  1588,  2057,  2077,
    2093,  1606,  2058,  1549,   356,  1499,  1613,   823,   834,  1617,
    1618,  1619,  2005,  2006,  2007,   108,  1633,  1635,   350,   582,
     586,   616,   713,  1641,  1645,  2054,  2055,  1648,  2099,   815,
    1651,  2215,  2058,     1,  2004,  2005,  1663,  2054,   913,  1673,
    2035,   161,   911,  1356,  1591,  1676,  2093,  1679,  1680,  2093,
    2110,  2114,  1696,  1705,  1830,  2086,  2087,  2099,  1356,  1591,
    1712,   168,  1716,  2058,  1719,  2058,   295,  1723,  1724,  1725,
     390,  1737,  1999,  2169,   913,  2034,   291,  1753,  2093,  1757,
    2033,  1773,  2034,  1783,  2028,  2099,  1787,  2033,   824,  1791,
    2028,  2029,    16,  1798,  2030,  2099,  1806,  2034,   274,   427,
     488,  1813,  1816,  1817,  1820,  1821,  1822,  1823,  1824,  1825,
    1826,  1827,  2001,  2036,  2037,  2054,  2085,  2087,  2099,  1830,
    1840,  2033,  1848,  2093,   832,  2103,  2104,  1855,  1856,  1857,
     168,   793,  1866,  2057,  1872,  2035,   820,   913,  1435,  1436,
    1439,  1440,  1445,  1875,  2088,  2093,  1878,  2033,   456,  1881,
    2078,  2093,  2114,  1892,  2093,  1911,  2029,  1918,  1943,   820,
     713,   463,  1282,  1203,  1203,  1203,  1198,   820,     1,   316,
    1201,  1202,  1203,   442,  1147,  1062,  2193,  2215,  2215,   557,
    2192,  2193,  2193,  2215,  2193,  2193,  2215,  2193,  2193,   824,
    2166,   290,  2165,   456,  1074,  2099,    32,  2148,   820,    39,
     229,   379,   456,   459,   472,   503,   630,   752,   757,   758,
     927,  1022,  1024,  1025,  1026,  1029,   853,   885,   886,  1023,
    1024,   913,  1087,  2109,   456,  2105,   459,   787,   882,   997,
    2048,  2100,  2101,   993,   489,  2112,  1497,   107,   884,  1421,
     241,  1476,  1451,    41,    55,   347,   489,  1460,  1461,  1462,
    1466,  1469,  2151,  2152,  2219,   832,  1457,   485,  2187,   346,
    2192,  2093,   832,   832,   832,  2119,   832,  2228,  2228,   832,
     832,   832,   832,  2228,  2086,   832,  2119,   242,  1481,   815,
    1480,  2058,  2094,  2111,  2114,   832,  2118,   832,   832,  2024,
    2093,  2020,  2024,   110,   828,   833,   819,   829,   298,  2094,
    2111,  2114,   396,  2130,  1490,   815,  2228,   243,  1517,  1999,
    1521,  1528,  2033,   650,   857,  1526,  2219,  2234,  2192,   244,
    1533,   280,   821,  2027,  2225,   691,  2136,  2103,  2104,  1538,
    1545,  2033,   246,  1546,   641,  2201,   162,  2160,  2093,   797,
    2212,   797,  2034,  1568,   362,  1589,    78,  2154,   247,  1603,
     291,   543,  1957,  1959,  1961,  1557,  2056,  2057,  1558,   912,
    1560,  1457,  1580,  1589,   870,   871,   872,   873,   248,  1607,
      83,   405,   815,   456,   249,  1630,    25,   906,  1620,  1621,
    1622,  1624,    28,   298,   409,   532,   566,   817,   819,   828,
     829,   832,   833,  2008,  2009,  2011,  2058,  2176,   497,  1636,
     183,  1642,  2055,   270,  2040,   804,  1657,  1664,  2219,  2035,
    2093,     8,    15,    45,    66,    67,    68,    69,    70,    71,
      72,    73,    81,    86,    97,    98,    99,   100,   115,   125,
     128,   129,   130,   132,   166,   175,   176,   177,   178,   179,
     180,   181,   182,   188,   189,   214,   215,   218,   219,   223,
     245,   269,   273,   288,   293,   294,   311,   312,   313,   314,
     315,   318,   357,   358,   359,   360,   366,   367,   369,   371,
     372,   373,   376,   378,   382,   401,   402,   410,   411,   412,
     413,   414,   415,   424,   428,   429,   432,   471,   475,   477,
     478,   479,   480,   487,   504,   512,   547,   548,   580,   583,
     594,   600,   604,   606,   607,   620,   623,   624,   628,   642,
     644,   645,   653,   654,   673,   674,   675,   693,   694,   695,
     696,   698,   702,   703,   710,   711,   718,   719,   720,   726,
     731,   749,   762,   763,   768,   791,   792,   800,   808,   814,
     844,   850,   891,   897,   899,   902,   909,   921,   924,  1361,
    1363,  1365,  1367,  1369,  1371,  1373,  1375,  1378,  1380,  1382,
    1383,  1385,  1387,  1388,  1390,  1392,  1395,  1396,   430,   744,
     813,  1397,  1398,   164,   662,   794,  1681,  1682,  1684,  1685,
    1697,  2093,  1706,  2093,  1832,   832,  2103,   532,   774,  1358,
    1359,  1360,  1361,  2134,  1397,   253,  1713,  2058,   815,   254,
    1720,    83,  1724,   299,   398,   416,   571,  1726,    84,   339,
     456,  1205,  1742,  1743,  1744,  2041,  2061,  2079,  2093,  2099,
    2110,  2114,  2219,   805,   913,  1754,   257,  1769,   511,   603,
    2133,   258,  1780,   485,   715,  1774,   346,  1912,   259,  1788,
    2201,   913,   260,  1794,  1912,  2030,   261,  1803,   894,  1799,
     346,  1807,  1808,  2071,  2075,  2093,  2111,  2114,   291,  1823,
    1825,  2054,   611,   815,  2037,   226,   815,   866,  1815,    42,
    2103,   262,  1846,   319,   421,   427,  1842,  1510,  1849,  2058,
    2219,  2018,  2020,   832,  2104,   263,  1863,   405,  1858,  1859,
    2058,  2093,  2086,   264,  1867,   346,  2035,   713,   820,   820,
     346,   641,   647,  2202,   265,  1889,   202,  1882,  2093,   266,
    1916,  1912,  1919,  2093,  1944,  2093,  1194,   820,   713,   454,
    1284,  1214,  1216,   659,   820,   820,  1199,   155,    76,   121,
     187,   423,   446,   641,   646,   663,   665,   820,   890,  1148,
    1149,  1151,  1155,  1156,  1159,  1160,  1166,  1169,  1171,  1172,
    2176,     1,  1063,  1064,  2044,  2045,  2045,  2105,  2105,  2031,
    2033,  2031,  2105,  2031,  2031,  2045,  2031,  2031,   796,  2211,
     240,  1136,  2105,  2167,  2048,  1026,    25,   807,   110,   491,
     914,  2232,   913,  2102,   994,  2167,  2176,    85,   577,   769,
    1498,  1423,  1422,   678,  1431,  1460,   927,  2080,  2085,  2105,
    2176,  1462,   123,   127,   448,   598,   599,  1467,  1468,  2224,
     810,    44,    49,    50,    51,    52,    56,    75,   124,   161,
     163,   175,   198,   338,   348,   377,   435,   467,   470,   515,
     522,   558,   574,   622,   625,   667,   679,   681,   682,   701,
     706,   714,   756,   790,   811,   855,   867,   874,  1470,  1473,
    1474,  1475,  2161,  2200,   137,   456,  1458,  1459,  2066,  2093,
    2093,   169,    34,    35,   126,   133,   136,   190,   192,   193,
     274,   276,   283,   291,   398,   448,   452,   704,   788,   799,
     810,   881,   913,  1465,  2037,  2222,   270,   305,   306,   616,
    2069,  2094,   815,  2018,  2020,  2125,  2018,  2126,   817,  2018,
    2121,  2122,   913,   913,  2020,  2124,  2124,  2124,  2063,  2093,
    2111,  2114,  2123,   913,   815,  2063,  2120,    11,  2025,  2026,
    2058,  2099,  2111,   354,  2020,  2063,  2018,   817,   396,  2131,
    2021,  2021,  2022,  2022,  2022,   458,  1485,   614,  1491,  2043,
    1501,  1502,  2078,  2093,  1526,   464,   515,  2167,  2094,  2020,
     489,  2137,  2104,  2020,  2033,   676,  1762,  1763,  1764,  1550,
    2219,  1560,   911,  2057,  1442,  1443,  1442,  1960,  1961,  1958,
    1959,   869,  1466,  1469,  1562,  1563,  1565,  2219,    49,    50,
      51,    52,    56,    74,    75,   124,   163,   281,   338,   377,
     470,   574,   701,   706,   744,   756,   855,  1474,  1561,  1602,
     281,  1572,  1573,  2093,  2111,   869,  1590,   911,  1957,  1957,
    1957,  1957,  2058,  2026,  2058,  1612,  1496,  1619,  1625,   906,
    1622,  1623,   249,   820,   906,  1442,  2010,  2011,  2009,    20,
      21,    22,   114,   280,   363,   364,   440,   441,   508,   542,
     551,   560,   601,   821,   825,   827,  2012,  2013,  2014,  2015,
    2016,  2017,  1634,   456,  2038,  2039,   204,  1652,  2041,   236,
    1656,  1658,    16,    20,    23,    24,   500,   501,   551,   552,
    1665,  1669,   316,   390,   821,  2170,  1394,  2105,  2170,  1396,
    2170,  2170,  2170,  1398,  2073,  2094,  2098,  2111,    16,   110,
     319,   431,   843,  1688,  1689,  1690,  1683,  1684,   252,  1703,
     346,  1703,   405,  1834,  2193,  2219,   409,   821,  2177,  1359,
      31,   409,   821,  2179,     3,    12,    27,    46,    65,    77,
      78,    79,    82,    89,   101,   103,   104,   131,   186,   199,
     221,   222,   224,   225,   268,   284,   322,   323,   324,   344,
     349,   374,   375,   380,   381,   434,   436,   453,   466,   467,
     468,   493,   517,   518,   519,   521,   523,   524,   526,   528,
     529,   533,   535,   536,   537,   538,   551,   559,   572,   573,
     581,   587,   633,   638,   687,   688,   689,   697,   721,   734,
     735,   736,   737,   754,   755,   765,   795,   809,   810,   846,
     856,   863,   874,   878,   879,   880,   895,   896,   900,   901,
     903,   910,  1362,  1364,  1366,  1368,  1370,  1372,  1374,  1376,
    1377,  1379,  1381,  1384,  1386,  1389,  1391,   815,  2054,  2026,
    2058,   733,  1727,  2192,   368,  2000,  2000,   865,   894,   807,
       1,    58,    59,    60,    61,    63,   144,   145,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   456,   596,   619,
    1206,  1207,  1208,  1209,  1210,  1246,  2067,  2094,   812,   801,
    2201,   405,  2084,  2093,  2110,  2114,   405,  1758,  1762,   240,
    1800,  2093,  1800,  2093,  1809,  2219,   815,   815,   815,   815,
    1814,   270,   744,   823,   834,  2058,    83,    56,    75,   377,
     435,   470,   574,   681,   855,  1818,  1819,  2176,  1841,  2219,
    2058,   282,   531,   137,   722,   817,  2019,   818,  2020,  2093,
    1859,   202,  1860,   346,   346,  2026,  2058,  1437,  2071,    83,
    2155,   405,  1885,    14,    55,  1913,  1914,   267,  1941,   346,
    1941,  1946,  2219,  1195,  1175,   820,   713,   663,  1286,   890,
    1274,  1233,  1234,  2176,  2127,    29,    54,    57,    58,    59,
      60,    61,    63,    64,    74,   141,   143,   144,   146,   147,
     148,   149,   150,   151,   213,   325,   326,   327,   328,   329,
     333,   368,   392,   419,   443,   500,   556,   575,   591,   596,
     619,   649,   701,   738,   740,   741,   742,   786,   850,   860,
     861,   862,   876,   898,  1221,  1222,  1223,  1224,  1225,  1228,
    1229,  1231,  1234,  1235,  1238,  1239,  1243,  1244,  1245,  1246,
    1249,  1252,  1269,  1270,  1272,  1273,  1274,  1279,  1280,  1281,
    2176,  2206,  1204,  2176,   156,  2159,  2176,   641,   647,  2233,
    2233,  2176,  2159,  2176,  2188,  2176,    31,  2147,   557,  1173,
    2052,   301,   355,   820,     6,     9,    27,    40,   309,   310,
     393,   448,   527,   568,   576,   641,   655,   670,   733,   747,
     820,   824,   840,   841,  1065,  1066,  1075,  1077,  1082,  1083,
    1086,  1088,  1089,  1090,  1091,  1097,  1098,  1099,  1100,  1103,
    1109,  1110,  1112,  1114,  1116,  1117,  1118,  1119,  2158,  2201,
    2227,  2045,  2193,  2193,   838,   839,  2237,  2033,  2193,  2193,
    2159,  2192,  2192,   647,  2031,  1027,  1029,  2228,    23,   500,
    2048,   454,  1424,  1425,  1426,  2155,  1424,   560,   913,   820,
     283,   291,   541,   543,  1950,  1952,  1953,  1955,  1956,    76,
     549,  2190,  2190,   456,  2081,  2085,  2107,  2176,  2176,  2176,
    2176,    56,   231,  1475,  2156,   226,   866,  2216,    14,  2146,
     421,   744,  1458,   137,   828,   833,  1950,   926,   925,  2071,
    1950,   421,  2181,   766,   766,   549,  1452,   496,  2192,  2192,
     456,  2070,  2094,  2093,  2019,   817,  2019,   817,   817,   590,
     817,  2063,  2019,   817,   817,   817,  2019,   817,  2086,  2019,
     817,  2192,   546,   745,  1972,  1974,  1976,  2103,  2104,  2026,
     818,   817,   817,   815,  2132,  1485,  2105,   678,  1486,   815,
    2041,  1495,   509,   618,  1503,    37,  1529,  2219,   683,   658,
    1972,  2176,   712,   339,  2167,   408,   544,  1993,  1994,  1996,
    1998,   421,  1584,  1575,  1444,   170,   171,   608,   913,  1566,
    2037,  1563,   516,  1602,  2177,   448,   704,  2176,   277,   279,
    1399,  1400,  2163,  2215,  2177,   226,  2216,  2176,  1602,  1573,
    2093,  1581,  1587,   354,  1972,   354,   456,  1614,   884,  1504,
       1,    29,   823,   834,  1627,  1628,  2006,   569,  1626,   927,
    2012,  2215,  1456,  1457,  1652,  2039,  2193,  1659,   251,  1660,
    1442,  2215,   662,  1666,  2215,  2093,  2093,  2093,  2093,  2093,
     815,    83,  1689,  1691,  2073,    16,   110,   431,   843,  1686,
    1687,  2071,  2089,  2093,  2093,  2093,  1083,  1835,  2158,    38,
     205,  1264,   227,  1393,  2093,  2105,  2057,  2054,  1972,   354,
    2219,  1762,  1206,  2169,  1743,  1738,  1739,   297,  1745,  2004,
    1746,  1747,  2093,  2041,   820,  1914,  1758,  2093,  2093,   240,
     539,  1982,  1985,  1987,  1792,  1793,  2219,  1442,   906,   906,
    1801,  1802,  1913,   232,   237,   285,  2093,  2071,   558,   927,
    2082,  2083,  2085,  2105,  2070,   557,  2058,  1814,  1814,  1814,
    1814,  1814,  1814,  1814,  1814,  1819,   532,   542,  1843,  1844,
    1845,  2013,  2134,  1993,   437,   744,  2235,   766,  2209,  2209,
    2020,   817,  2020,  1862,  2219,  2155,  2093,  2086,  1972,   354,
    1441,  2105,   815,    16,  1883,  1884,  2128,  1886,  2093,  1862,
    1886,  1762,    13,  2145,  2093,   678,  1947,   239,  1176,  1283,
     820,   713,   704,  1343,  2178,   890,   355,  2099,   437,   551,
     739,   859,  2205,   859,  2205,   859,  2205,   859,  2205,   859,
    2205,   906,  2217,  2192,   687,  2203,  2091,  2094,   228,  1255,
    2105,   459,  1240,  2094,    37,  2150,   409,   434,   687,  1271,
    2215,  2176,  1223,   301,   302,   385,   753,   851,   431,   843,
     346,  1217,  2150,   355,  2105,  1087,  2178,  2178,   913,  2049,
    2050,   560,   756,  2229,   456,  2045,  2051,  2105,   894,  2176,
     308,   384,   913,  1157,  2052,  2188,  2181,  2201,  2215,   728,
    2181,  2176,  2156,   203,  2181,  2181,   515,  1111,  2105,  2219,
    2176,  2176,   766,   464,   727,    57,  2153,  2178,  2031,  2031,
    2193,  2031,  2031,  1131,  1132,  2033,  2234,  2033,  1028,  1029,
    2102,  2176,  2176,  2048,  1425,   744,   859,  1427,  1428,   651,
     890,  1418,  1954,  1955,  1471,  1472,  2089,  2093,  1951,  1952,
    1442,  2080,  2080,  2080,  2080,  2081,  2080,  2176,  2002,  2083,
    2002,  2081,  2169,  2176,   817,   817,  1458,  2066,  2066,  1950,
     744,  1463,  1464,  1466,  2033,  2033,  2136,   789,  2118,   789,
    2118,   817,  2045,  2118,  2118,  2118,  2063,  2136,   431,   843,
    2118,  2094,  1442,  1442,  1975,  1976,  1973,  1974,  2104,  1972,
     817,  2020,  2118,  2118,  2076,  2093,  2110,  1486,  2055,  2000,
     515,  2138,  2020,  1442,  1442,  1997,  1998,  1995,  1996,  2077,
    1590,   198,   383,   813,   850,  1510,  1576,  1577,  1578,  1445,
    2080,  2080,   448,   704,   240,  2080,  2002,  2002,  2080,    77,
      79,   368,   452,   597,   732,   835,  1466,  1592,  1593,  1594,
    1595,  1596,  1598,  1599,  1600,  1601,  2219,  1592,  2026,  2027,
    2026,  2027,  1505,    25,   807,  1629,   249,   820,  1442,  1627,
     281,  2164,  2093,  1442,   236,   890,  1667,  1668,  1669,   804,
    1670,  2213,   890,  2074,  2098,  2110,  2071,    83,    14,    55,
    1692,  1693,  1694,  1687,  1692,   337,   169,  2003,  1707,  2219,
    1831,   727,  2181,   390,   567,  2171,  2026,    16,   515,   636,
    1113,  2031,  2093,  1442,   255,   820,  1741,    14,   346,    13,
     389,  1759,  1760,  1761,  1763,  1766,  1793,  2219,   187,   520,
    1775,  1777,  1779,  1442,  1442,  1986,  1987,  1985,  1993,   464,
     515,  2005,  2004,  1801,   662,  1810,  2058,  2013,  2093,  2014,
    2015,  2016,  2017,  2020,  1850,  2058,  1850,   817,   545,   831,
    1977,  1979,  1981,   596,   744,  1861,  2058,  2136,  2136,  2026,
     820,  2072,  2076,   566,  2071,   203,  1887,   794,  1888,  1792,
     578,  2037,  2080,  2003,   500,   889,  1948,  2075,    95,  1177,
    1178,  1195,  1285,   820,   713,    28,   298,   566,   817,   819,
     828,   829,   832,   833,  1205,  1220,  1276,  1277,  2176,   807,
    1212,   927,     7,    53,    65,   111,   134,   191,   272,   335,
     343,   423,   430,   455,   483,   627,   631,   707,   767,   781,
     805,   847,   893,   905,   911,   913,  1354,   832,  1226,  1227,
      90,  1257,   854,   815,  1253,  1241,  2176,  2091,   913,  2092,
       1,   913,  1245,    37,  1232,  2155,  1236,   773,  1230,   725,
    2139,  2139,   913,  1276,   815,  1154,   337,  1170,  2050,   452,
    2185,   815,  2157,  2169,   303,   320,   700,   852,   887,   892,
    1167,  1168,  2176,  2176,  2176,  2176,  2181,   228,   301,  1072,
    1073,  2176,   655,  1098,  2176,  2176,  2176,  2176,    32,    33,
    2149,  1113,  2051,  2105,  2176,  2188,   557,  1084,   728,  1115,
    2051,  2031,  1132,   599,  1133,    25,  2048,  2048,  2176,   744,
    1428,   564,  1430,   197,  1432,  1442,  2077,   448,   452,  2230,
    1472,  2082,   817,  2176,  1464,  1972,   346,  2140,   817,  1496,
     213,   712,   812,  1585,  2177,  2177,  2177,  2177,  2058,  1578,
    2192,   390,   409,  2180,  2080,  2148,  1593,   102,   434,   687,
    1597,   515,  1602,  1972,   657,  1972,   657,  1506,  1507,  1508,
    2155,  1628,  2005,  1637,  1638,  2093,  2110,  1659,  1668,   187,
    2162,  2215,  1692,  1692,  2074,   826,  2174,  2174,  1694,  1693,
    2169,  1698,   496,  1928,   208,   398,   884,  1836,  1833,   567,
    1972,   569,  2196,  2196,   562,    18,   212,   337,   433,   668,
     682,   912,  1728,  1729,  1733,  1734,  2219,  2220,   255,  1740,
    1747,  2058,  2193,   464,   421,  1767,  1765,  1766,  2219,   388,
     420,   904,  1442,  1442,  1778,  1779,  1776,  1777,   464,  1442,
    1442,   448,  2182,  1442,  1442,  1980,  1981,  1978,  1979,  2176,
    1972,  2140,  1972,   877,  1438,  1893,  1884,  2169,  2003,  2169,
    1977,   278,   540,  1915,  1988,  1990,  1992,  1994,   448,   452,
    2183,  1920,  2219,   615,  2052,  1195,  1195,  1287,   820,   807,
    1275,  1277,   511,   761,  1205,  1218,  1219,  1220,  2099,   200,
     321,   425,   482,   746,   842,  1247,   457,  1248,   456,  2068,
    2169,   346,  1254,   812,  2214,  2105,  2214,   744,   913,  1242,
     456,  2077,   170,   175,   289,   705,  1237,  2156,  2105,   110,
     647,  1150,  2044,  1161,  2105,  2207,   456,  1158,  2099,  1158,
     228,   634,   728,  1076,  2045,  2176,    91,    92,    93,   210,
     211,   213,   398,   399,   422,   448,   473,   571,   604,   608,
     609,   634,   796,  1067,  1068,  1069,  1070,  1071,  2045,  2051,
    1101,  2045,  2045,  2157,  2237,  2045,  2176,  2045,  1085,  2167,
    2176,  2051,   807,  2105,  1029,  2167,  2167,    44,   198,  2105,
    2176,   913,   820,  1419,  2082,   392,  2172,   206,  2141,  1504,
    1592,  2058,  2058,  2058,  2058,  2093,  2177,   813,   706,   916,
    2027,  2027,  1507,   560,  1427,   157,   651,   890,  1564,  1565,
    1638,  1442,    83,   198,  1692,  2058,  2058,  2093,  1928,  2192,
     784,  1700,   612,  2031,   354,   571,  1837,  2099,    16,   515,
     637,   868,   920,  1731,  1732,  1733,   515,    80,   464,   475,
    1730,    83,  1748,   464,  2176,  1768,  1983,  1985,  1987,  1993,
     464,   464,  2093,  2141,  1894,   820,  2093,  2093,  1442,  1442,
    1991,  1992,  1989,  1990,  1922,  1923,  1924,  2219,   824,  1949,
    2028,   612,  1179,  1288,  1344,  1205,   906,  1278,  2218,  2192,
    1220,   817,   913,  2105,   815,  1253,   204,   204,  1256,  2176,
     766,    77,   835,  1162,  1163,  1164,  1165,  2219,  2157,   346,
    1153,  2168,  2045,   346,    13,   884,   894,  2099,  2110,  2238,
      62,   451,   757,   913,  1102,   750,   821,  1104,  1105,  2045,
    2046,    47,   295,   474,  1092,  2176,    23,   500,  1087,   807,
    2051,   500,    23,    44,  1429,  2219,  1433,  1434,  2082,  2172,
    1972,  1509,  1510,  2093,  2177,  1972,  1972,  2059,  2060,  2090,
    2094,  2058,  1700,  1929,  1930,  2093,  1701,  1702,  2093,   291,
     543,  1967,  1969,  1971,  2176,  2031,   612,   570,  2197,   683,
    2061,  2065,  2068,  2093,  2114,   865,  2093,  1986,  1984,  1985,
    1972,    41,   230,   292,   355,  1895,  1896,  1897,  1899,  1903,
    1905,  1906,  1907,  1908,  2151,  2167,   498,  1926,  1924,    43,
     239,   923,  1925,   913,  2176,  1180,   635,  1289,  1200,  1215,
    1345,  1346,  1347,   729,   823,  2093,   396,  1258,  2193,  2193,
     393,  1259,  1261,  1262,  1263,  1264,  1266,  2105,  2051,  2051,
     336,  1154,  2105,  1104,  2099,  2166,  2099,  2176,   585,  1078,
    1079,  1106,  1107,   912,  1093,  1095,  2219,  1096,  2219,  1093,
    1087,  2176,  2176,  1087,  2051,  2176,  2176,   481,  1434,   815,
    2082,   291,   543,   831,  1512,  1514,  1516,    11,   405,   534,
     560,   830,  1511,  2175,  2058,  1699,  1930,  2176,  1702,  1442,
    1442,  1970,  1971,  1968,  1969,  1742,  2176,  2094,  2111,  2114,
    2004,    55,  2146,  1907,  1754,   616,   195,  2176,  1928,  2075,
    1742,   820,  1181,  2167,  2035,     1,  1202,  1347,   820,   815,
    2176,  1259,  2045,  2045,  2155,  1266,  1262,  2181,  1260,  2151,
    2157,  2129,  2219,  1080,  2129,  1108,  2045,  1108,   464,  2186,
     690,   475,  1087,  1087,  2048,  2048,   744,   240,  2082,  1442,
    1442,  1442,  1515,  1516,  1513,  1514,  2192,  2093,  1967,  2110,
    1742,   664,   756,  2208,   824,  2032,   240,   761,  1904,  2193,
    2075,   850,  1931,  1945,   571,  2174,  1290,   820,  1348,  1349,
     820,  1205,  1259,  1267,  1268,  2100,  2176,  1261,  2051,   204,
    1152,  1078,   227,   515,  2176,   561,  2167,  2167,  2176,   197,
    2093,  2093,   282,   291,  2226,  2033,   824,    16,  1900,  1901,
    2094,   499,  1927,  2192,   784,  1936,   291,   543,  1962,  1964,
    1966,   206,   282,   766,   785,   802,  1186,  1187,  1188,   398,
     416,     1,  1291,  1351,   554,  1353,  1354,  1268,  2047,  2048,
    2193,   783,  1081,   227,  2045,   494,   641,   647,  2231,   500,
      23,  2081,   820,   612,  2198,  2033,   557,   613,   652,  1902,
    1901,  2176,  1932,  1933,  2093,   290,   908,  1937,  1938,  2093,
    1921,  1442,  1442,  1965,  1966,  1963,  1964,   169,   793,  2176,
     421,   421,   206,   437,  1188,   240,   485,   766,   785,   802,
    1182,  1183,  1184,  1185,  2093,  2187,  2210,   240,   485,   766,
     802,  1189,  1190,  1191,  1192,  2093,  2210,   820,   161,   162,
     578,   820,  1292,  1293,  1298,  2176,  2219,  2246,    44,    49,
      50,    51,    52,    56,    74,    75,    94,   116,   124,   172,
     281,   338,   346,   348,   365,   377,   435,   448,   452,   470,
     515,   556,   574,   622,   667,   714,   744,   756,   790,   815,
     826,   855,   884,  1239,  1244,  1249,  1269,  1272,  1274,  1352,
    1413,  1414,  1473,  1474,  2176,  2224,  1355,  2093,  2105,  1350,
    2048,  2045,   906,  2231,  1094,  1095,  2176,  2176,  2193,   557,
    2091,  2075,  1933,  2176,    42,   157,   235,   530,   551,  1935,
    1939,   379,   472,   752,   927,  1940,  2113,  1938,  1962,  2176,
     556,  2093,  2176,  2176,  2176,  2176,   421,   190,   810,   421,
     437,  1184,  2093,   169,   629,   750,   775,   776,   777,   421,
     190,   810,   421,   437,  1191,  2093,   797,  2178,  2178,   444,
     445,  2184,  1309,   355,   120,   317,  1294,  1295,  1296,  1297,
    2093,  2176,   448,   704,  1411,  2190,  1409,  2190,  2176,  2177,
    1399,  1400,  2176,  2084,  1409,  2177,  2105,   109,  2177,  2093,
    2093,   355,  1411,  1357,  1358,    16,   752,   927,  1030,  1094,
    1087,  1087,   299,   398,   416,   571,  1898,  2031,  1935,  1934,
    1935,  1934,   566,  2093,  2105,  2093,  2093,  2093,  2093,  2176,
    2176,  2176,  2176,  2176,  2093,  2176,  2176,  2176,  2176,  2176,
    2176,  2176,  2176,  2176,  2176,  2176,  2093,  2176,  2178,  2178,
     927,  1299,  1300,  1301,  2093,  2105,  2108,  1200,  1310,  2176,
    1296,  1297,  2080,  2176,  2176,  2080,  2089,  2105,  2080,  1406,
    2080,  2214,  2176,  2089,  2105,  1351,  2112,  2113,  2214,  2093,
    2093,  2093,  2093,  2093,  2093,  2093,  2093,  2093,  2093,  2093,
    2093,  2093,  2093,  2093,  2093,  2093,  2093,  2093,  1302,   448,
     452,  2183,  2222,  2230,     1,  1202,  1203,  2077,   486,   595,
     828,   833,  1402,  1403,  1404,  1405,  1412,  1402,  1404,  1410,
      96,   593,  1407,  1408,  2077,  1265,  1266,  2093,  2093,   319,
     336,   370,   427,   450,  1303,  1304,  1305,  1306,  1307,  1308,
    1300,  1301,   820,  1311,  2080,  2080,  2093,  2093,   194,   208,
    2239,  2176,  2176,   106,   161,  2239,  2240,  2176,  1312,  2093,
    2176,  1301,  1301,   370,  2176,  2176,  1301,     4,   123,   127,
     366,   448,   452,   513,   556,   602,   750,   782,   820,   850,
     894,  1239,  1243,  1244,  1249,  1250,  1269,  1272,  1274,  1313,
    1314,  1319,  1322,  1325,  1326,  1329,  1330,  1331,  1334,  1335,
    1341,  1342,  2221,  2222,  2223,  2093,  1301,  1301,  1301,   394,
    2173,   550,  2190,  2191,  2147,  2176,  2105,  2176,  2192,  2176,
    2093,    14,    55,   419,   906,   514,  1332,  1333,  1401,  1402,
    1338,  1339,  1340,  1402,  2105,  2191,  2093,  2178,   511,   514,
     578,  1320,  1321,  1402,  2105,  1253,  2064,  2062,  2064,   105,
     161,   578,   588,   589,   663,   685,   686,  1315,  2239,  2240,
    2241,  2242,  2243,  2244,  2245,   346,   510,  2189,  2189,    14,
      55,  2004,  1332,  2108,  1339,  2108,   101,   434,   687,  1336,
    1337,  2093,  2105,  2214,  2136,   671,   869,  1323,  2064,   336,
     336,   370,   336,   370,   337,   561,  2194,  2194,  2064,   566,
     578,  1327,  1328,  2093,  1327,  2189,  2189,  2178,  2093,  1256,
    2193,  2093,   317,  1316,  2093,    16,   317,  1318,  2093,    83,
    1327,   578,   578,   770,  1251,   317,  1324,  2093,   566,  1317,
    1317,  1317,  1317,  2064,  2105,   578
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   929,   931,   930,   932,   932,   934,   933,   935,   935,
     936,   936,   938,   937,   939,   940,   941,   941,   942,   942,
     944,   943,   946,   945,   948,   949,   947,   950,   950,   951,
     952,   952,   954,   955,   953,   957,   956,   958,   958,   959,
     959,   960,   960,   961,   961,   962,   962,   962,   962,   963,
     963,   964,   964,   965,   965,   966,   967,   967,   968,   968,
     968,   968,   969,   969,   970,   970,   971,   971,   971,   972,
     972,   973,   973,   973,   973,   974,   975,   975,   976,   977,
     977,   978,   978,   979,   979,   980,   980,   980,   980,   980,
     982,   981,   983,   983,   984,   984,   986,   985,   987,   987,
     987,   987,   988,   988,   989,   989,   989,   989,   990,   991,
     993,   992,   994,   994,   994,   994,   994,   994,   995,   996,
     997,   997,   997,   997,   998,   998,  1000,   999,  1001,  1001,
    1001,  1002,  1002,  1003,  1003,  1003,  1003,  1003,  1004,  1004,
    1005,  1006,  1007,  1007,  1007,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1010,
    1009,  1011,  1011,  1011,  1011,  1012,  1012,  1013,  1014,  1014,
    1016,  1015,  1018,  1017,  1019,  1017,  1020,  1020,  1021,  1022,
    1022,  1022,  1022,  1022,  1023,  1023,  1023,  1023,  1024,  1024,
    1024,  1025,  1025,  1026,  1026,  1027,  1026,  1028,  1028,  1029,
    1029,  1029,  1029,  1029,  1029,  1030,  1030,  1031,  1032,  1032,
    1033,  1034,  1034,  1035,  1036,  1036,  1037,  1037,  1038,  1039,
    1039,  1040,  1041,  1042,  1042,  1043,  1043,  1044,  1044,  1044,
    1045,  1045,  1046,  1047,  1048,  1048,  1049,  1050,  1051,  1052,
    1053,  1054,  1056,  1055,  1057,  1058,  1058,  1059,  1059,  1060,
    1060,  1062,  1061,  1063,  1063,  1064,  1064,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1066,  1066,  1066,  1066,
    1066,  1067,  1067,  1067,  1068,  1068,  1068,  1068,  1068,  1068,
    1068,  1069,  1069,  1069,  1069,  1070,  1070,  1070,  1070,  1070,
    1070,  1070,  1071,  1072,  1072,  1073,  1073,  1074,  1074,  1075,
    1076,  1076,  1076,  1077,  1078,  1078,  1080,  1079,  1081,  1081,
    1081,  1082,  1084,  1083,  1085,  1085,  1085,  1085,  1085,  1085,
    1086,  1087,  1088,  1089,  1089,  1089,  1091,  1090,  1092,  1092,
    1092,  1093,  1093,  1093,  1093,  1094,  1094,  1095,  1096,  1096,
    1097,  1097,  1098,  1098,  1098,  1098,  1099,  1101,  1100,  1102,
    1102,  1102,  1102,  1103,  1104,  1104,  1105,  1105,  1107,  1106,
    1106,  1108,  1109,  1110,  1111,  1111,  1112,  1113,  1113,  1113,
    1114,  1115,  1115,  1116,  1117,  1118,  1119,  1120,  1120,  1121,
    1122,  1122,  1122,  1123,  1123,  1124,  1124,  1124,  1124,  1125,
    1126,  1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1130,  1129,  1131,
    1131,  1132,  1133,  1133,  1134,  1135,  1136,  1136,  1138,  1137,
    1139,  1139,  1140,  1141,  1141,  1142,  1142,  1143,  1145,  1144,
    1144,  1146,  1146,  1147,  1147,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1149,  1150,  1150,  1150,
    1151,  1151,  1151,  1152,  1152,  1153,  1153,  1154,  1154,  1155,
    1156,  1156,  1157,  1157,  1158,  1158,  1159,  1160,  1161,  1161,
    1162,  1162,  1162,  1163,  1164,  1165,  1166,  1167,  1167,  1167,
    1167,  1167,  1168,  1168,  1169,  1170,  1170,  1171,  1172,  1172,
    1173,  1173,  1174,  1175,  1174,  1176,  1176,  1177,  1179,  1178,
    1180,  1180,  1181,  1181,  1181,  1182,  1182,  1182,  1183,  1183,
    1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,
    1184,  1185,  1186,  1186,  1187,  1187,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1189,  1189,  1189,  1190,  1190,  1191,  1191,
    1191,  1191,  1191,  1191,  1192,  1193,  1194,  1193,  1195,  1196,
    1195,  1197,  1197,  1198,  1198,  1198,  1199,  1198,  1198,  1200,
    1201,  1201,  1202,  1202,  1203,  1204,  1204,  1205,  1205,  1205,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1207,  1207,  1208,  1208,  1209,
    1209,  1209,  1210,  1210,  1211,  1212,  1212,  1214,  1213,  1215,
    1216,  1215,  1217,  1217,  1218,  1218,  1218,  1219,  1219,  1220,
    1220,  1220,  1220,  1220,  1220,  1220,  1220,  1220,  1220,  1221,
    1221,  1222,  1222,  1223,  1223,  1223,  1223,  1223,  1223,  1223,
    1223,  1223,  1223,  1223,  1223,  1223,  1223,  1223,  1223,  1223,
    1223,  1223,  1223,  1223,  1224,  1225,  1226,  1226,  1227,  1228,
    1229,  1230,  1230,  1231,  1232,  1232,  1233,  1233,  1234,  1236,
    1235,  1237,  1237,  1237,  1237,  1238,  1239,  1240,  1240,  1241,
    1241,  1242,  1243,  1244,  1244,  1244,  1244,  1245,  1245,  1245,
    1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,
    1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,
    1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,
    1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,  1245,
    1245,  1245,  1245,  1245,  1245,  1245,  1245,  1246,  1246,  1247,
    1247,  1247,  1247,  1247,  1247,  1247,  1248,  1248,  1249,  1249,
    1250,  1251,  1251,  1252,  1252,  1252,  1253,  1253,  1254,  1254,
    1255,  1255,  1256,  1256,  1257,  1257,  1258,  1258,  1259,  1259,
    1260,  1259,  1259,  1259,  1261,  1262,  1262,  1263,  1264,  1264,
    1265,  1265,  1266,  1267,  1267,  1268,  1269,  1270,  1271,  1271,
    1271,  1272,  1273,  1275,  1274,  1276,  1276,  1277,  1277,  1278,
    1278,  1279,  1279,  1280,  1281,  1282,  1283,  1282,  1284,  1285,
    1284,  1286,  1287,  1286,  1288,  1288,  1290,  1289,  1291,  1291,
    1291,  1292,  1292,  1292,  1292,  1293,  1294,  1294,  1294,  1295,
    1296,  1296,  1297,  1298,  1299,  1299,  1299,  1300,  1301,  1301,
    1302,  1302,  1303,  1303,  1303,  1303,  1303,  1303,  1304,  1305,
    1306,  1307,  1308,  1309,  1309,  1311,  1310,  1310,  1312,  1312,
    1313,  1313,  1313,  1313,  1313,  1313,  1313,  1313,  1313,  1313,
    1313,  1313,  1313,  1313,  1313,  1313,  1313,  1314,  1315,  1315,
    1315,  1315,  1315,  1315,  1315,  1316,  1316,  1316,  1317,  1317,
    1318,  1318,  1318,  1318,  1319,  1320,  1320,  1320,  1321,  1321,
    1321,  1322,  1323,  1323,  1323,  1324,  1324,  1325,  1325,  1325,
    1325,  1325,  1326,  1326,  1327,  1327,  1328,  1328,  1328,  1329,
    1330,  1331,  1331,  1332,  1332,  1333,  1333,  1334,  1335,  1336,
    1336,  1337,  1337,  1337,  1338,  1338,  1339,  1339,  1340,  1341,
    1342,  1343,  1344,  1343,  1345,  1345,  1346,  1346,  1347,  1348,
    1347,  1349,  1350,  1347,  1347,  1351,  1351,  1352,  1352,  1352,
    1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,
    1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,
    1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,
    1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,  1352,
    1352,  1352,  1352,  1352,  1352,  1352,  1353,  1353,  1354,  1354,
    1354,  1354,  1354,  1354,  1354,  1354,  1354,  1354,  1354,  1354,
    1354,  1354,  1354,  1354,  1355,  1355,  1356,  1356,  1357,  1357,
    1358,  1358,  1359,  1359,  1360,  1360,  1361,  1361,  1362,  1362,
    1362,  1362,  1362,  1362,  1362,  1362,  1362,  1362,  1362,  1362,
    1362,  1362,  1363,  1363,  1363,  1363,  1363,  1363,  1363,  1363,
    1363,  1363,  1363,  1363,  1363,  1363,  1363,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1365,  1365,  1366,
    1366,  1366,  1366,  1366,  1367,  1368,  1368,  1368,  1368,  1368,
    1368,  1368,  1368,  1368,  1368,  1368,  1368,  1368,  1368,  1368,
    1369,  1369,  1369,  1369,  1369,  1369,  1369,  1369,  1369,  1369,
    1370,  1370,  1370,  1370,  1370,  1370,  1370,  1370,  1370,  1370,
    1371,  1371,  1372,  1372,  1373,  1373,  1374,  1374,  1374,  1374,
    1374,  1375,  1375,  1375,  1375,  1375,  1375,  1375,  1375,  1375,
    1375,  1375,  1375,  1375,  1375,  1375,  1375,  1376,  1376,  1376,
    1377,  1377,  1377,  1377,  1377,  1377,  1377,  1377,  1378,  1378,
    1378,  1378,  1378,  1378,  1379,  1379,  1379,  1379,  1379,  1379,
    1379,  1379,  1380,  1380,  1380,  1380,  1381,  1381,  1381,  1382,
    1382,  1382,  1382,  1382,  1382,  1383,  1383,  1383,  1383,  1384,
    1384,  1384,  1384,  1384,  1384,  1384,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1386,  1386,  1386,  1387,  1387,  1387,  1387,
    1387,  1387,  1387,  1387,  1387,  1388,  1388,  1388,  1388,  1388,
    1388,  1388,  1388,  1388,  1388,  1388,  1388,  1388,  1388,  1388,
    1388,  1388,  1388,  1388,  1388,  1388,  1388,  1388,  1389,  1390,
    1391,  1391,  1391,  1391,  1391,  1391,  1391,  1391,  1392,  1392,
    1392,  1393,  1393,  1394,  1395,  1395,  1396,  1396,  1397,  1397,
    1398,  1398,  1398,  1399,  1399,  1400,  1400,  1401,  1401,  1402,
    1403,  1403,  1404,  1405,  1405,  1406,  1407,  1407,  1408,  1408,
    1409,  1410,  1410,  1410,  1411,  1412,  1412,  1412,  1413,  1414,
    1415,  1415,  1417,  1418,  1419,  1416,  1420,  1416,  1421,  1422,
    1421,  1423,  1421,  1424,  1424,  1425,  1426,  1426,  1426,  1427,
    1427,  1427,  1427,  1427,  1427,  1428,  1429,  1429,  1430,  1430,
    1431,  1431,  1431,  1432,  1433,  1432,  1434,  1434,  1435,  1435,
    1435,  1435,  1435,  1437,  1436,  1438,  1438,  1439,  1440,  1441,
    1441,  1443,  1444,  1442,  1446,  1445,  1445,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1449,  1448,  1451,  1450,  1452,  1450,  1450,
    1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,
    1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,  1450,
    1450,  1450,  1453,  1453,  1455,  1454,  1456,  1456,  1457,  1457,
    1457,  1458,  1458,  1458,  1459,  1459,  1460,  1460,  1461,  1461,
    1462,  1462,  1462,  1462,  1462,  1463,  1463,  1464,  1464,  1465,
    1465,  1466,  1466,  1466,  1467,  1468,  1469,  1470,  1470,  1470,
    1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,
    1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,
    1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,  1470,
    1470,  1470,  1470,  1471,  1471,  1472,  1473,  1473,  1473,  1474,
    1474,  1474,  1475,  1475,  1476,  1476,  1478,  1477,  1479,  1479,
    1479,  1479,  1480,  1480,  1481,  1481,  1483,  1482,  1484,  1484,
    1485,  1485,  1486,  1486,  1488,  1487,  1489,  1489,  1490,  1491,
    1491,  1493,  1492,  1495,  1494,  1496,  1497,  1496,  1498,  1498,
    1498,  1499,  1499,  1500,  1500,  1500,  1500,  1500,  1500,  1501,
    1501,  1502,  1502,  1503,  1503,  1504,  1505,  1504,  1506,  1506,
    1507,  1507,  1508,  1508,  1508,  1508,  1509,  1509,  1509,  1509,
    1509,  1510,  1510,  1511,  1511,  1512,  1512,  1512,  1513,  1513,
    1514,  1514,  1515,  1515,  1516,  1517,  1517,  1519,  1518,  1520,
    1520,  1521,  1521,  1523,  1522,  1524,  1524,  1525,  1525,  1526,
    1526,  1526,  1526,  1526,  1528,  1527,  1529,  1529,  1531,  1530,
    1532,  1533,  1533,  1534,  1536,  1535,  1537,  1538,  1537,  1540,
    1539,  1541,  1541,  1543,  1542,  1544,  1544,  1545,  1545,  1546,
    1546,  1548,  1547,  1549,  1550,  1550,  1551,  1551,  1551,  1551,
    1551,  1553,  1552,  1554,  1554,  1554,  1554,  1554,  1554,  1554,
    1554,  1554,  1554,  1554,  1555,  1555,  1556,  1556,  1558,  1557,
    1559,  1559,  1560,  1560,  1561,  1561,  1562,  1562,  1563,  1563,
    1563,  1563,  1563,  1564,  1564,  1565,  1565,  1565,  1565,  1566,
    1566,  1568,  1567,  1569,  1571,  1570,  1572,  1572,  1573,  1573,
    1573,  1575,  1574,  1576,  1576,  1577,  1577,  1578,  1578,  1578,
    1578,  1578,  1580,  1581,  1579,  1582,  1582,  1584,  1585,  1583,
    1587,  1586,  1588,  1588,  1588,  1589,  1589,  1590,  1590,  1591,
    1591,  1591,  1592,  1592,  1593,  1593,  1593,  1593,  1593,  1593,
    1593,  1593,  1594,  1595,  1596,  1596,  1596,  1597,  1597,  1597,
    1597,  1598,  1598,  1599,  1599,  1600,  1601,  1602,  1602,  1602,
    1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,
    1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,  1602,
    1603,  1603,  1605,  1604,  1606,  1606,  1606,  1606,  1606,  1607,
    1607,  1609,  1608,  1611,  1610,  1612,  1610,  1613,  1614,  1616,
    1615,  1617,  1618,  1618,  1619,  1619,  1619,  1620,  1620,  1621,
    1621,  1622,  1622,  1622,  1623,  1623,  1623,  1625,  1624,  1626,
    1624,  1627,  1627,  1628,  1628,  1628,  1628,  1628,  1629,  1629,
    1630,  1630,  1632,  1631,  1634,  1633,  1635,  1635,  1636,  1636,
    1637,  1637,  1638,  1638,  1640,  1639,  1641,  1641,  1641,  1641,
    1641,  1641,  1641,  1642,  1642,  1644,  1643,  1645,  1647,  1646,
    1648,  1650,  1649,  1651,  1651,  1652,  1652,  1653,  1655,  1654,
    1656,  1656,  1656,  1657,  1657,  1658,  1659,  1660,  1660,  1662,
    1661,  1663,  1664,  1664,  1665,  1665,  1665,  1666,  1666,  1667,
    1667,  1668,  1669,  1669,  1669,  1669,  1669,  1669,  1669,  1670,
    1670,  1672,  1671,  1673,  1673,  1675,  1674,  1676,  1676,  1678,
    1677,  1679,  1680,  1680,  1680,  1681,  1681,  1681,  1681,  1683,
    1682,  1684,  1685,  1686,  1686,  1687,  1687,  1687,  1687,  1687,
    1687,  1688,  1688,  1689,  1689,  1690,  1690,  1690,  1690,  1690,
    1691,  1692,  1692,  1692,  1692,  1692,  1693,  1694,  1696,  1695,
    1698,  1699,  1697,  1700,  1700,  1701,  1701,  1702,  1703,  1703,
    1705,  1704,  1706,  1707,  1707,  1709,  1708,  1711,  1710,  1712,
    1712,  1713,  1713,  1715,  1714,  1716,  1716,  1718,  1717,  1719,
    1719,  1720,  1720,  1722,  1721,  1723,  1723,  1724,  1725,  1725,
    1726,  1726,  1726,  1726,  1727,  1727,  1728,  1728,  1728,  1728,
    1728,  1729,  1729,  1730,  1730,  1730,  1731,  1731,  1731,  1732,
    1732,  1732,  1733,  1733,  1734,  1734,  1734,  1736,  1735,  1737,
    1738,  1737,  1739,  1737,  1740,  1740,  1741,  1741,  1742,  1742,
    1743,  1743,  1743,  1743,  1743,  1744,  1744,  1745,  1745,  1746,
    1746,  1747,  1748,  1748,  1750,  1749,  1752,  1751,  1753,  1753,
    1754,  1756,  1755,  1757,  1758,  1758,  1759,  1759,  1759,  1759,
    1760,  1760,  1761,  1761,  1762,  1762,  1763,  1764,  1764,  1764,
    1765,  1765,  1766,  1766,  1766,  1767,  1767,  1768,  1768,  1769,
    1769,  1770,  1772,  1771,  1773,  1774,  1774,  1775,  1775,  1775,
    1776,  1776,  1777,  1778,  1778,  1779,  1780,  1780,  1782,  1781,
    1783,  1784,  1786,  1785,  1787,  1788,  1788,  1790,  1789,  1791,
    1792,  1792,  1793,  1793,  1794,  1794,  1795,  1797,  1796,  1798,
    1798,  1799,  1799,  1800,  1800,  1801,  1801,  1802,  1803,  1803,
    1805,  1804,  1806,  1806,  1807,  1807,  1808,  1809,  1809,  1809,
    1809,  1810,  1810,  1812,  1811,  1813,  1813,  1813,  1813,  1813,
    1813,  1813,  1813,  1814,  1814,  1815,  1815,  1816,  1817,  1818,
    1818,  1819,  1819,  1819,  1819,  1819,  1819,  1819,  1819,  1820,
    1820,  1820,  1821,  1822,  1822,  1823,  1824,  1824,  1825,  1825,
    1826,  1827,  1829,  1828,  1831,  1830,  1832,  1832,  1833,  1833,
    1834,  1834,  1835,  1835,  1836,  1836,  1836,  1837,  1837,  1837,
    1839,  1838,  1840,  1841,  1841,  1842,  1842,  1842,  1842,  1843,
    1843,  1843,  1843,  1843,  1843,  1844,  1845,  1845,  1846,  1846,
    1848,  1847,  1847,  1847,  1849,  1849,  1849,  1849,  1849,  1850,
    1850,  1851,  1851,  1852,  1852,  1852,  1852,  1854,  1853,  1855,
    1857,  1856,  1858,  1858,  1859,  1860,  1860,  1861,  1861,  1862,
    1862,  1863,  1863,  1865,  1864,  1866,  1866,  1866,  1866,  1867,
    1867,  1868,  1869,  1869,  1871,  1870,  1872,  1872,  1874,  1873,
    1875,  1877,  1876,  1878,  1880,  1879,  1881,  1882,  1882,  1883,
    1883,  1884,  1885,  1885,  1886,  1887,  1887,  1888,  1888,  1889,
    1889,  1891,  1890,  1892,  1892,  1894,  1893,  1895,  1895,  1895,
    1895,  1895,  1896,  1897,  1897,  1898,  1898,  1898,  1898,  1898,
    1899,  1900,  1900,  1901,  1901,  1901,  1902,  1902,  1902,  1902,
    1903,  1904,  1904,  1905,  1906,  1906,  1907,  1907,  1908,  1908,
    1910,  1909,  1911,  1912,  1912,  1913,  1913,  1913,  1913,  1914,
    1914,  1915,  1915,  1915,  1916,  1916,  1918,  1917,  1920,  1921,
    1919,  1922,  1922,  1923,  1923,  1924,  1925,  1925,  1925,  1926,
    1926,  1927,  1927,  1928,  1928,  1929,  1929,  1930,  1931,  1931,
    1932,  1932,  1933,  1934,  1934,  1935,  1935,  1935,  1936,  1936,
    1937,  1937,  1938,  1938,  1938,  1939,  1939,  1939,  1940,  1940,
    1941,  1941,  1943,  1942,  1945,  1944,  1946,  1946,  1947,  1947,
    1948,  1948,  1949,  1949,  1950,  1950,  1950,  1951,  1951,  1952,
    1953,  1953,  1954,  1954,  1955,  1956,  1956,  1957,  1957,  1957,
    1958,  1958,  1959,  1960,  1960,  1961,  1962,  1962,  1962,  1963,
    1963,  1964,  1965,  1965,  1966,  1967,  1967,  1967,  1968,  1968,
    1969,  1970,  1970,  1971,  1972,  1972,  1972,  1973,  1973,  1974,
    1975,  1975,  1976,  1977,  1977,  1977,  1978,  1978,  1979,  1980,
    1980,  1981,  1982,  1982,  1983,  1983,  1984,  1984,  1985,  1986,
    1986,  1987,  1988,  1988,  1989,  1989,  1990,  1991,  1991,  1992,
    1993,  1993,  1994,  1994,  1995,  1995,  1996,  1997,  1997,  1998,
    1999,  1999,  2000,  2000,  2001,  2001,  2002,  2002,  2003,  2003,
    2004,  2004,  2005,  2007,  2006,  2008,  2008,  2009,  2009,  2009,
    2009,  2009,  2009,  2009,  2009,  2009,  2009,  2009,  2009,  2009,
    2009,  2010,  2010,  2011,  2012,  2012,  2012,  2012,  2012,  2012,
    2012,  2012,  2012,  2012,  2012,  2012,  2012,  2012,  2013,  2013,
    2014,  2014,  2015,  2015,  2016,  2017,  2018,  2018,  2019,  2019,
    2019,  2020,  2020,  2020,  2021,  2021,  2021,  2022,  2022,  2023,
    2023,  2023,  2024,  2024,  2025,  2025,  2025,  2025,  2025,  2025,
    2026,  2026,  2027,  2028,  2029,  2029,  2030,  2031,  2031,  2032,
    2032,  2033,  2034,  2035,  2036,  2036,  2037,  2038,  2038,  2039,
    2040,  2040,  2041,  2042,  2042,  2042,  2043,  2044,  2044,  2045,
    2046,  2046,  2047,  2047,  2048,  2049,  2049,  2050,  2051,  2051,
    2052,  2052,  2053,  2054,  2054,  2055,  2055,  2055,  2056,  2056,
    2057,  2057,  2058,  2058,  2059,  2059,  2060,  2060,  2060,  2060,
    2060,  2060,  2060,  2060,  2060,  2060,  2060,  2061,  2062,  2062,
    2063,  2063,  2063,  2064,  2064,  2064,  2064,  2064,  2064,  2064,
    2065,  2065,  2065,  2065,  2065,  2065,  2066,  2067,  2068,  2069,
    2069,  2070,  2070,  2071,  2072,  2073,  2073,  2074,  2074,  2075,
    2075,  2075,  2076,  2076,  2077,  2077,  2078,  2078,  2078,  2079,
    2079,  2079,  2080,  2080,  2080,  2081,  2081,  2082,  2082,  2083,
    2083,  2084,  2084,  2084,  2085,  2086,  2087,  2087,  2088,  2089,
    2090,  2091,  2092,  2093,  2094,  2094,  2094,  2094,  2095,  2095,
    2096,  2096,  2097,  2097,  2097,  2097,  2098,  2099,  2099,  2101,
    2100,  2102,  2102,  2103,  2104,  2104,  2105,  2106,  2107,  2108,
    2108,  2109,  2109,  2109,  2109,  2109,  2109,  2109,  2110,  2110,
    2111,  2111,  2112,  2112,  2112,  2112,  2112,  2112,  2112,  2113,
    2113,  2113,  2113,  2114,  2114,  2114,  2114,  2114,  2114,  2114,
    2114,  2114,  2114,  2114,  2114,  2114,  2114,  2115,  2115,  2116,
    2116,  2116,  2116,  2117,  2117,  2117,  2117,  2117,  2118,  2118,
    2118,  2119,  2119,  2119,  2120,  2120,  2120,  2122,  2121,  2123,
    2123,  2124,  2124,  2125,  2125,  2126,  2126,  2127,  2128,  2128,
    2129,  2129,  2129,  2130,  2130,  2131,  2131,  2132,  2132,  2133,
    2133,  2133,  2134,  2134,  2135,  2135,  2135,  2136,  2136,  2137,
    2137,  2138,  2138,  2138,  2138,  2138,  2138,  2138,  2138,  2139,
    2139,  2140,  2140,  2141,  2141,  2142,  2142,  2142,  2142,  2143,
    2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,
    2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,
    2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,
    2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,
    2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,  2143,
    2143,  2144,  2144,  2144,  2144,  2144,  2144,  2144,  2144,  2144,
    2144,  2144,  2144,  2144,  2144,  2144,  2144,  2144,  2144,  2144,
    2144,  2144,  2144,  2144,  2145,  2145,  2146,  2146,  2147,  2147,
    2148,  2148,  2149,  2149,  2149,  2150,  2150,  2151,  2151,  2152,
    2152,  2153,  2153,  2154,  2154,  2155,  2155,  2156,  2156,  2157,
    2157,  2158,  2158,  2159,  2159,  2160,  2160,  2161,  2161,  2162,
    2162,  2163,  2163,  2164,  2164,  2165,  2165,  2166,  2166,  2167,
    2167,  2168,  2168,  2169,  2169,  2170,  2170,  2170,  2171,  2171,
    2171,  2172,  2172,  2173,  2173,  2174,  2174,  2175,  2175,  2176,
    2176,  2177,  2177,  2177,  2178,  2178,  2178,  2179,  2179,  2179,
    2179,  2180,  2180,  2180,  2181,  2181,  2182,  2182,  2183,  2183,
    2183,  2184,  2184,  2184,  2185,  2185,  2186,  2186,  2187,  2187,
    2188,  2188,  2189,  2189,  2190,  2190,  2191,  2191,  2192,  2192,
    2193,  2193,  2194,  2194,  2194,  2195,  2195,  2195,  2195,  2196,
    2196,  2197,  2197,  2198,  2198,  2199,  2199,  2200,  2200,  2201,
    2201,  2202,  2202,  2202,  2203,  2203,  2204,  2204,  2205,  2205,
    2206,  2206,  2206,  2207,  2207,  2208,  2208,  2209,  2209,  2210,
    2210,  2211,  2211,  2212,  2212,  2213,  2213,  2214,  2214,  2215,
    2215,  2216,  2216,  2217,  2217,  2218,  2218,  2219,  2219,  2220,
    2220,  2220,  2221,  2221,  2222,  2222,  2223,  2223,  2224,  2224,
    2224,  2224,  2225,  2225,  2226,  2226,  2227,  2227,  2228,  2228,
    2229,  2229,  2230,  2230,  2231,  2231,  2232,  2232,  2232,  2233,
    2233,  2234,  2234,  2235,  2235,  2236,  2236,  2237,  2237,  2238,
    2238,  2239,  2239,  2240,  2240,  2241,  2241,  2242,  2242,  2243,
    2243,  2244,  2244,  2245,  2245,  2246,  2246
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     2,     1,     2,
       1,     1,     0,     2,     4,     4,     0,     1,     1,     2,
       0,     4,     0,     4,     0,     0,     6,     0,     1,     3,
       1,     1,     0,     0,     8,     0,     6,     1,     1,     1,
       1,     0,     2,     0,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     0,     3,     5,     0,     3,     1,     1,
       1,     1,     0,     5,     0,     3,     1,     1,     1,     0,
       4,     1,     1,     1,     1,     3,     0,     3,     2,     0,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     4,     0,     3,     0,     3,     0,     4,     0,     2,
       3,     2,     1,     2,     1,     1,     1,     1,     5,     2,
       0,     4,     2,     3,     4,     4,     8,     8,     3,     4,
       1,     1,     1,     1,     1,     2,     0,     4,     0,     2,
       3,     1,     2,     3,     3,     3,     3,     3,     1,     2,
       2,     2,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     2,     3,     3,     1,     0,     1,     1,     3,     4,
       0,     4,     0,     4,     0,     4,     0,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     2,     1,     3,     0,     4,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     2,
       3,     1,     2,     3,     1,     2,     1,     2,     3,     1,
       2,     3,     6,     1,     2,     1,     3,     0,     2,     2,
       0,     2,     4,     5,     0,     3,     3,     5,     3,     4,
       3,     3,     0,     4,     4,     0,     3,     0,     2,     0,
       2,     0,     5,     2,     2,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     5,     6,     6,
       4,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     1,     4,
       1,     1,     1,     9,     0,     1,     0,     4,     0,     4,
       3,     1,     0,     4,     2,     3,     4,     4,     8,     8,
       6,     1,     5,     0,     1,     1,     0,     5,     2,     2,
       2,     0,     5,     6,     1,     0,     1,     2,     0,     2,
       3,     1,     1,     3,     1,     2,     4,     0,     5,     1,
       1,     1,     1,     7,     0,     2,     1,     2,     0,     2,
       2,     1,     4,     3,     1,     1,     3,     2,     2,     2,
       3,     3,     4,     4,     4,     4,     4,     0,     2,     2,
       0,     2,     3,     1,     2,     1,     1,     1,     1,     5,
       0,     1,     1,     1,     4,     4,     4,     4,     1,     6,
       6,     7,     4,     6,     4,     6,     4,     0,     6,     1,
       2,     2,     0,     2,     6,     2,     2,     3,     0,    10,
       0,     1,     3,     0,     3,     0,     2,     2,     0,     5,
       3,     1,     1,     0,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     0,     1,     1,
       4,     6,     9,     0,     3,     0,     2,     0,     2,     3,
       5,     5,     1,     1,     1,     1,     3,     5,     0,     2,
       1,     1,     1,     4,     2,     2,     4,     1,     1,     1,
       1,     1,     1,     1,     4,     0,     2,     2,     2,     2,
       1,     2,     0,     0,     5,     0,     2,     2,     0,     5,
       0,     2,     4,     3,     4,     0,     1,     1,     1,     2,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,    11,     0,     1,     1,     2,     4,     4,     4,     6,
       4,     3,     4,     0,     1,     1,     1,     2,     4,     4,
       4,     4,     4,     4,     6,     0,     0,     5,     0,     0,
       2,     2,     3,     1,     1,     1,     0,     4,     3,     2,
       0,     1,     1,     1,     1,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     6,     0,     2,     0,     4,     5,
       0,     7,     2,     2,     1,     3,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     0,     1,     3,     3,
       3,     0,     1,     3,     0,     2,     0,     1,     2,     0,
       4,     1,     2,     1,     1,     1,     2,     0,     5,     0,
       2,     1,     3,     1,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     4,     3,
       3,     3,     4,     3,     3,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     0,     1,     3,     3,
       6,     0,     2,     6,     8,     7,     0,     2,     0,     2,
       0,     2,     0,     3,     0,     3,     0,     1,     0,     2,
       0,     3,     1,     1,     1,     1,     2,     4,     1,     1,
       0,     1,     3,     1,     2,     1,     2,     2,     0,     1,
       1,     3,     1,     0,     5,     1,     2,     3,     1,     0,
       4,     2,     2,     2,     4,     0,     0,     5,     0,     0,
       5,     0,     0,     5,     0,     2,     0,     6,     0,     2,
       2,     2,     4,     1,     1,     2,     2,     1,     1,     1,
       1,     2,     1,     4,     2,     1,     3,     2,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     3,     3,     4,
       4,     4,     3,     0,     2,     0,     5,     3,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       3,     3,     1,     1,     1,     0,     2,     2,     0,     2,
       0,     2,     2,     1,     3,     1,     2,     1,     1,     1,
       1,     4,     0,     3,     2,     1,     1,     3,     4,     5,
       4,     5,     1,     1,     0,     2,     1,     1,     1,     6,
       2,     3,     2,     0,     2,     1,     2,     2,     4,     0,
       1,     1,     1,     1,     2,     1,     1,     2,     1,     4,
       2,     0,     0,     5,     0,     1,     2,     3,     1,     0,
       4,     0,     0,     7,     3,     0,     2,     2,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     1,     1,     2,     3,     2,
       2,     2,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     2,     1,     3,     3,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     3,     1,     2,
       3,     3,     3,     1,     2,     1,     2,     0,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     0,     1,
       4,     0,     1,     1,     4,     0,     1,     1,     3,     2,
       0,     1,     0,     0,     0,    12,     0,     4,     0,     0,
       3,     0,     3,     1,     2,     5,     0,     2,     2,     0,
       3,     3,     4,     2,     1,     3,     0,     5,     0,     1,
       0,     2,     2,     0,     0,     7,     0,     2,     1,     1,
       2,     1,     1,     0,     6,     0,     2,     2,     1,     0,
       1,     0,     0,     3,     0,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     0,     4,     0,     4,     0,     5,     3,
       3,     3,     3,     4,     3,     4,     3,     3,     4,     4,
       4,     3,     4,     3,     4,     5,     3,     4,     3,     3,
       2,     3,     1,     1,     0,     3,     0,     1,     5,     4,
       4,     1,     3,     3,     1,     1,     0,     1,     1,     2,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       2,     2,     2,     2,     3,     3,     3,     1,     1,     1,
       2,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     1,     1,
       1,     4,     1,     2,     1,     1,     3,     3,     3,     3,
       3,     3,     4,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     4,     4,     5,
       6,     8,     0,     2,     0,     1,     0,     3,     4,     5,
       0,     2,     0,     2,     0,     3,     1,     2,     4,     0,
       2,     0,     4,     0,     9,     0,     0,     4,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     2,     1,     1,     0,     0,     3,     1,     2,
       2,     3,     0,     2,     2,     2,     0,     3,     2,     2,
       4,     1,     1,     1,     1,     0,     2,     2,     0,     1,
       2,     2,     0,     1,     2,     0,     1,     0,     3,     1,
       2,     1,     1,     0,     3,     1,     1,     2,     3,     0,
       1,     3,     3,     2,     0,     4,     0,     3,     0,     4,
       4,     0,     1,     1,     0,     3,     0,     0,     4,     0,
       3,     2,     1,     0,     4,     4,     2,     1,     2,     0,
       1,     0,     3,     3,     0,     3,     0,     2,     1,     2,
       1,     0,     4,     3,     3,     3,     3,     2,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     2,     0,     3,
       1,     1,     0,     2,     1,     2,     1,     2,     1,     2,
       1,     1,     2,     0,     1,     2,     2,     2,     2,     1,
       1,     0,     3,     2,     0,     3,     1,     2,     1,     1,
       1,     0,     5,     0,     1,     1,     2,     3,     3,     3,
       3,     2,     0,     0,     5,     1,     1,     0,     0,     7,
       0,     5,     1,     1,     1,     0,     1,     0,     2,     1,
       2,     1,     1,     2,     1,     2,     1,     5,     1,     1,
       1,     2,     1,     1,     0,     1,     1,     1,     1,     0,
       1,     3,     3,     1,     1,     4,     3,     1,     2,     2,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     3,     3,     3,     3,     3,
       0,     1,     0,     4,     4,     6,     6,     8,     8,     0,
       1,     0,     3,     0,     3,     0,     6,     4,     1,     0,
       4,     2,     1,     3,     1,     1,     1,     2,     1,     1,
       2,     2,     2,     2,     3,     3,     3,     0,     3,     0,
       4,     1,     3,     2,     1,     1,     1,     1,     0,     2,
       0,     1,     0,     3,     0,     7,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     3,     0,     2,     1,     2,
       1,     1,     1,     0,     2,     0,     3,     1,     0,     3,
       1,     0,     3,     3,     4,     0,     3,     2,     0,     6,
       5,     3,     2,     0,     1,     0,     0,     0,     1,     0,
       3,     5,     0,     2,     0,     3,     3,     0,     2,     1,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     3,     1,     2,     0,     3,     2,     2,     0,
       3,     2,     1,     1,     1,     2,     1,     1,     1,     0,
       3,     2,     5,     1,     2,     2,     2,     1,     1,     1,
       2,     1,     2,     4,     2,     0,     1,     1,     1,     1,
       4,     0,     1,     1,     2,     2,     3,     3,     0,     5,
       0,     0,     9,     0,     2,     1,     2,     1,     0,     1,
       0,     5,     7,     0,     2,     0,     3,     0,     4,     2,
       2,     0,     1,     0,     3,     3,     4,     0,     4,     4,
       6,     0,     1,     0,     3,     1,     2,     6,     0,     1,
       1,     1,     1,     1,     0,     3,     0,     1,     1,     2,
       1,     2,     2,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     0,     3,     4,
       0,     6,     0,     5,     0,     1,     1,     1,     1,     3,
       0,     2,     1,     3,     3,     0,     3,     1,     1,     1,
       3,     6,     0,     2,     0,     3,     0,     3,     2,     1,
       1,     0,     4,     7,     0,     2,     0,     1,     2,     1,
       2,     3,     3,     1,     0,     1,     1,     4,     4,     2,
       0,     1,     1,     3,     2,     0,     3,     1,     1,     0,
       1,     1,     0,     4,     5,     1,     1,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     1,     0,     3,
       2,     1,     0,     4,     4,     0,     1,     0,     4,     5,
       0,     1,     2,     3,     0,     1,     1,     0,     4,     4,
       6,     0,     2,     0,     2,     1,     2,     3,     0,     1,
       0,     3,     2,     5,     0,     1,     2,     2,     2,     2,
       2,     0,     2,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     1,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     4,
       3,     5,     4,     1,     2,     3,     1,     2,     3,     3,
       4,     4,     0,     3,     0,     7,     0,     5,     0,     2,
       0,     3,     0,     1,     0,     2,     4,     0,     2,     4,
       0,     4,     4,     0,     3,     0,     4,     1,     1,     1,
       2,     2,     2,     2,     1,     1,     2,     1,     0,     1,
       0,     4,     2,     2,     0,     2,     1,     4,     4,     0,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     5,
       0,     2,     1,     2,     2,     0,     3,     1,     1,     0,
       4,     0,     1,     0,     4,     4,     6,     6,     8,     0,
       1,     2,     0,     1,     0,     3,     1,     2,     0,     3,
       5,     0,     3,     2,     0,     4,     6,     0,     3,     1,
       3,     2,     2,     2,     3,     0,     3,     0,     3,     0,
       1,     0,     3,     1,     2,     0,     3,     1,     1,     1,
       1,     1,     7,     0,     1,     1,     1,     1,     1,     1,
       4,     1,     2,     1,     2,     3,     0,     1,     2,     1,
       3,     1,     1,     4,     1,     2,     2,     3,     1,     1,
       0,     4,     6,     0,     2,     0,     4,     3,     3,     1,
       1,     0,     1,     1,     0,     1,     0,     5,     0,     0,
      12,     0,     1,     1,     2,     2,     2,     1,     1,     0,
       4,     0,     3,     0,     3,     1,     2,     3,     0,     3,
       1,     2,     3,     0,     1,     1,     1,     1,     0,     2,
       1,     2,     1,     2,     2,     2,     2,     1,     1,     3,
       0,     1,     0,     5,     0,    10,     0,     3,     0,     2,
       0,     3,     1,     2,     0,     2,     2,     0,     1,     3,
       1,     1,     0,     1,     2,     1,     1,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     2,     2,     0,     1,     2,     0,
       1,     2,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     1,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     2,     0,     3,     2,     1,     0,     2,     0,     3,
       1,     1,     1,     0,     2,     1,     2,     1,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     0,     1,
       1,     3,     3,     1,     3,     3,     1,     3,     1,     2,
       2,     1,     3,     1,     1,     3,     1,     3,     1,     3,
       1,     2,     2,     1,     1,     2,     1,     1,     2,     2,
       3,     1,     1,     1,     1,     2,     1,     1,     2,     1,
       0,     2,     1,     1,     1,     3,     1,     1,     2,     1,
       0,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     3,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     4,     3,     5,     5,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       1,     1,     1,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     3,     2,     2,     1,     1,     2,
       1,     1,     3,     2,     2,     1,     1,     1,     3,     0,
       2,     1,     3,     3,     4,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     5,     5,     5,     4,     5,     4,
       5,     5,     5,     5,     5,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       5,     0,     3,     2,     1,     3,     3,     0,     2,     1,
       3,     1,     3,     1,     3,     1,     3,     0,     0,     1,
       0,     3,     2,     0,     1,     0,     2,     0,     2,     0,
       1,     1,     0,     1,     0,     1,     2,     0,     2,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     0,     5,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     3,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     1,     0,     1,     1,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     2,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     1,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     2,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     3,     0,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     1,     2,     1,     2,
       1,     2,     1,     2,     1,     2,     2
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return (YYSIZE_T) (yystpcpy (yyres, yystr) - yyres);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yynewstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  *yyssp = (yytype_int16) yystate;

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = (YYSIZE_T) (yyssp - yyss + 1);

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 3316 "parser.y" /* yacc.c:1652  */
    {
	clear_initial_values ();
	current_program = NULL;
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;
	current_program = cb_build_program (NULL, 0);
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
  }
#line 12307 "parser.c" /* yacc.c:1652  */
    break;

  case 3:
#line 3328 "parser.y" /* yacc.c:1652  */
    {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		backup_current_pos ();
		emit_entry (current_program->program_id, 0, NULL, NULL);
	}
  }
#line 12331 "parser.c" /* yacc.c:1652  */
    break;

  case 6:
#line 3355 "parser.y" /* yacc.c:1652  */
    {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 12341 "parser.c" /* yacc.c:1652  */
    break;

  case 12:
#line 3374 "parser.y" /* yacc.c:1652  */
    {
	program_init_without_program_id ();
  }
#line 12349 "parser.c" /* yacc.c:1652  */
    break;

  case 13:
#line 3379 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12358 "parser.c" /* yacc.c:1652  */
    break;

  case 16:
#line 3405 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12367 "parser.c" /* yacc.c:1652  */
    break;

  case 20:
#line 3419 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 12375 "parser.c" /* yacc.c:1652  */
    break;

  case 21:
#line 3423 "parser.y" /* yacc.c:1652  */
    {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 12384 "parser.c" /* yacc.c:1652  */
    break;

  case 22:
#line 3431 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 12392 "parser.c" /* yacc.c:1652  */
    break;

  case 23:
#line 3435 "parser.y" /* yacc.c:1652  */
    {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 12400 "parser.c" /* yacc.c:1652  */
    break;

  case 24:
#line 3445 "parser.y" /* yacc.c:1652  */
    {
	cb_validate_program_environment (current_program);
  }
#line 12408 "parser.c" /* yacc.c:1652  */
    break;

  case 25:
#line 3449 "parser.y" /* yacc.c:1652  */
    {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 12419 "parser.c" /* yacc.c:1652  */
    break;

  case 29:
#line 3467 "parser.y" /* yacc.c:1652  */
    {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 12428 "parser.c" /* yacc.c:1652  */
    break;

  case 32:
#line 3480 "parser.y" /* yacc.c:1652  */
    {
	cobc_in_id = 1;
  }
#line 12436 "parser.c" /* yacc.c:1652  */
    break;

  case 33:
#line 3484 "parser.y" /* yacc.c:1652  */
    {
	if (setup_program (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM)) {
		YYABORT;
	}

	setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 1);
  }
#line 12448 "parser.c" /* yacc.c:1652  */
    break;

  case 34:
#line 3492 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12457 "parser.c" /* yacc.c:1652  */
    break;

  case 35:
#line 3500 "parser.y" /* yacc.c:1652  */
    {
	cobc_in_id = 1;
  }
#line 12465 "parser.c" /* yacc.c:1652  */
    break;

  case 36:
#line 3504 "parser.y" /* yacc.c:1652  */
    {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12478 "parser.c" /* yacc.c:1652  */
    break;

  case 37:
#line 3516 "parser.y" /* yacc.c:1652  */
    {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 12493 "parser.c" /* yacc.c:1652  */
    break;

  case 38:
#line 3527 "parser.y" /* yacc.c:1652  */
    {
	cb_trim_program_id (yyvsp[0]);
  }
#line 12501 "parser.c" /* yacc.c:1652  */
    break;

  case 40:
#line 3535 "parser.y" /* yacc.c:1652  */
    {
	cb_trim_program_id (yyvsp[0]);
  }
#line 12509 "parser.c" /* yacc.c:1652  */
    break;

  case 41:
#line 3541 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 12515 "parser.c" /* yacc.c:1652  */
    break;

  case 42:
#line 3542 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 12521 "parser.c" /* yacc.c:1652  */
    break;

  case 45:
#line 3551 "parser.y" /* yacc.c:1652  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12534 "parser.c" /* yacc.c:1652  */
    break;

  case 46:
#line 3560 "parser.y" /* yacc.c:1652  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12547 "parser.c" /* yacc.c:1652  */
    break;

  case 48:
#line 3570 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("CALL prototypes"));
  }
#line 12555 "parser.c" /* yacc.c:1652  */
    break;

  case 51:
#line 3582 "parser.y" /* yacc.c:1652  */
    {
	current_program->flag_initial = 1;
  }
#line 12563 "parser.c" /* yacc.c:1652  */
    break;

  case 52:
#line 3586 "parser.y" /* yacc.c:1652  */
    {
	current_program->flag_recursive = 1;
  }
#line 12571 "parser.c" /* yacc.c:1652  */
    break;

  case 54:
#line 3595 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 12579 "parser.c" /* yacc.c:1652  */
    break;

  case 58:
#line 3615 "parser.y" /* yacc.c:1652  */
    {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 12590 "parser.c" /* yacc.c:1652  */
    break;

  case 59:
#line 3622 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 12598 "parser.c" /* yacc.c:1652  */
    break;

  case 60:
#line 3626 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 12606 "parser.c" /* yacc.c:1652  */
    break;

  case 61:
#line 3630 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 12614 "parser.c" /* yacc.c:1652  */
    break;

  case 62:
#line 3645 "parser.y" /* yacc.c:1652  */
    {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 12622 "parser.c" /* yacc.c:1652  */
    break;

  case 63:
#line 3649 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 12634 "parser.c" /* yacc.c:1652  */
    break;

  case 65:
#line 3661 "parser.y" /* yacc.c:1652  */
    {
	current_program->entry_convention = yyvsp[0];
  }
#line 12642 "parser.c" /* yacc.c:1652  */
    break;

  case 66:
#line 3668 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 12650 "parser.c" /* yacc.c:1652  */
    break;

  case 67:
#line 3672 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 12658 "parser.c" /* yacc.c:1652  */
    break;

  case 68:
#line 3676 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 12666 "parser.c" /* yacc.c:1652  */
    break;

  case 70:
#line 3684 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 12674 "parser.c" /* yacc.c:1652  */
    break;

  case 71:
#line 3691 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 12682 "parser.c" /* yacc.c:1652  */
    break;

  case 72:
#line 3695 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 12690 "parser.c" /* yacc.c:1652  */
    break;

  case 73:
#line 3699 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 12698 "parser.c" /* yacc.c:1652  */
    break;

  case 74:
#line 3703 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 12706 "parser.c" /* yacc.c:1652  */
    break;

  case 77:
#line 3718 "parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 12714 "parser.c" /* yacc.c:1652  */
    break;

  case 80:
#line 3732 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 12726 "parser.c" /* yacc.c:1652  */
    break;

  case 90:
#line 3763 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 12737 "parser.c" /* yacc.c:1652  */
    break;

  case 95:
#line 3779 "parser.y" /* yacc.c:1652  */
    {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 12748 "parser.c" /* yacc.c:1652  */
    break;

  case 96:
#line 3791 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 12759 "parser.c" /* yacc.c:1652  */
    break;

  case 97:
#line 3798 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 12767 "parser.c" /* yacc.c:1652  */
    break;

  case 108:
#line 3824 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 12775 "parser.c" /* yacc.c:1652  */
    break;

  case 109:
#line 3832 "parser.y" /* yacc.c:1652  */
    {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 12784 "parser.c" /* yacc.c:1652  */
    break;

  case 110:
#line 3840 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 12792 "parser.c" /* yacc.c:1652  */
    break;

  case 112:
#line 3848 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 12800 "parser.c" /* yacc.c:1652  */
    break;

  case 113:
#line 3852 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12810 "parser.c" /* yacc.c:1652  */
    break;

  case 114:
#line 3858 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 12818 "parser.c" /* yacc.c:1652  */
    break;

  case 115:
#line 3862 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12827 "parser.c" /* yacc.c:1652  */
    break;

  case 116:
#line 3868 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12837 "parser.c" /* yacc.c:1652  */
    break;

  case 117:
#line 3875 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 12847 "parser.c" /* yacc.c:1652  */
    break;

  case 118:
#line 3884 "parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 12862 "parser.c" /* yacc.c:1652  */
    break;

  case 119:
#line 3898 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 12874 "parser.c" /* yacc.c:1652  */
    break;

  case 120:
#line 3909 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 12882 "parser.c" /* yacc.c:1652  */
    break;

  case 121:
#line 3913 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 12890 "parser.c" /* yacc.c:1652  */
    break;

  case 122:
#line 3917 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 12898 "parser.c" /* yacc.c:1652  */
    break;

  case 123:
#line 3921 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 12906 "parser.c" /* yacc.c:1652  */
    break;

  case 126:
#line 3935 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 12917 "parser.c" /* yacc.c:1652  */
    break;

  case 127:
#line 3942 "parser.y" /* yacc.c:1652  */
    {
	cobc_in_repository = 0;
  }
#line 12925 "parser.c" /* yacc.c:1652  */
    break;

  case 130:
#line 3951 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 12933 "parser.c" /* yacc.c:1652  */
    break;

  case 133:
#line 3963 "parser.y" /* yacc.c:1652  */
    {
	functions_are_all = 1;
  }
#line 12941 "parser.c" /* yacc.c:1652  */
    break;

  case 134:
#line 3967 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 12951 "parser.c" /* yacc.c:1652  */
    break;

  case 136:
#line 3974 "parser.y" /* yacc.c:1652  */
    {
	  if (yyvsp[-1] != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 12962 "parser.c" /* yacc.c:1652  */
    break;

  case 137:
#line 3981 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 12970 "parser.c" /* yacc.c:1652  */
    break;

  case 138:
#line 3988 "parser.y" /* yacc.c:1652  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 12979 "parser.c" /* yacc.c:1652  */
    break;

  case 139:
#line 3993 "parser.y" /* yacc.c:1652  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 12988 "parser.c" /* yacc.c:1652  */
    break;

  case 140:
#line 4004 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
  }
#line 13003 "parser.c" /* yacc.c:1652  */
    break;

  case 159:
#line 4049 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 13022 "parser.c" /* yacc.c:1652  */
    break;

  case 161:
#line 4068 "parser.y" /* yacc.c:1652  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 13036 "parser.c" /* yacc.c:1652  */
    break;

  case 162:
#line 4079 "parser.y" /* yacc.c:1652  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (strcasecmp (CB_NAME(yyvsp[0]), "EXTERN" ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "STDCALL") == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "STATIC" ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "C"      ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "PASCAL" ) == 0) {
				remove_context_sensitivity (CB_NAME(yyvsp[0]), CB_CS_CALL);
			}
		}
	}
  }
#line 13061 "parser.c" /* yacc.c:1652  */
    break;

  case 163:
#line 4100 "parser.y" /* yacc.c:1652  */
    {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 13073 "parser.c" /* yacc.c:1652  */
    break;

  case 167:
#line 4116 "parser.y" /* yacc.c:1652  */
    {
	  check_on_off_duplicate = 0;
  }
#line 13081 "parser.c" /* yacc.c:1652  */
    break;

  case 168:
#line 4123 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 13100 "parser.c" /* yacc.c:1652  */
    break;

  case 169:
#line 4138 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 13119 "parser.c" /* yacc.c:1652  */
    break;

  case 170:
#line 4158 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 13136 "parser.c" /* yacc.c:1652  */
    break;

  case 171:
#line 4171 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 13148 "parser.c" /* yacc.c:1652  */
    break;

  case 172:
#line 4182 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 13159 "parser.c" /* yacc.c:1652  */
    break;

  case 174:
#line 4190 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 13170 "parser.c" /* yacc.c:1652  */
    break;

  case 180:
#line 4211 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13180 "parser.c" /* yacc.c:1652  */
    break;

  case 181:
#line 4217 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13190 "parser.c" /* yacc.c:1652  */
    break;

  case 182:
#line 4223 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 13200 "parser.c" /* yacc.c:1652  */
    break;

  case 183:
#line 4229 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13210 "parser.c" /* yacc.c:1652  */
    break;

  case 185:
#line 4239 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 13221 "parser.c" /* yacc.c:1652  */
    break;

  case 186:
#line 4246 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 13232 "parser.c" /* yacc.c:1652  */
    break;

  case 187:
#line 4253 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 13243 "parser.c" /* yacc.c:1652  */
    break;

  case 188:
#line 4263 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 13253 "parser.c" /* yacc.c:1652  */
    break;

  case 189:
#line 4269 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 13265 "parser.c" /* yacc.c:1652  */
    break;

  case 190:
#line 4277 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 13276 "parser.c" /* yacc.c:1652  */
    break;

  case 191:
#line 4287 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 13284 "parser.c" /* yacc.c:1652  */
    break;

  case 192:
#line 4291 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 13292 "parser.c" /* yacc.c:1652  */
    break;

  case 193:
#line 4298 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13300 "parser.c" /* yacc.c:1652  */
    break;

  case 194:
#line 4302 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 13308 "parser.c" /* yacc.c:1652  */
    break;

  case 195:
#line 4306 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 13316 "parser.c" /* yacc.c:1652  */
    break;

  case 196:
#line 4310 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 13324 "parser.c" /* yacc.c:1652  */
    break;

  case 197:
#line 4317 "parser.y" /* yacc.c:1652  */
    {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 13332 "parser.c" /* yacc.c:1652  */
    break;

  case 198:
#line 4321 "parser.y" /* yacc.c:1652  */
    {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 13340 "parser.c" /* yacc.c:1652  */
    break;

  case 199:
#line 4327 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 13346 "parser.c" /* yacc.c:1652  */
    break;

  case 200:
#line 4328 "parser.y" /* yacc.c:1652  */
    { yyval = cb_space; }
#line 13352 "parser.c" /* yacc.c:1652  */
    break;

  case 201:
#line 4329 "parser.y" /* yacc.c:1652  */
    { yyval = cb_zero; }
#line 13358 "parser.c" /* yacc.c:1652  */
    break;

  case 202:
#line 4330 "parser.y" /* yacc.c:1652  */
    { yyval = cb_quote; }
#line 13364 "parser.c" /* yacc.c:1652  */
    break;

  case 203:
#line 4331 "parser.y" /* yacc.c:1652  */
    { yyval = cb_norm_high; }
#line 13370 "parser.c" /* yacc.c:1652  */
    break;

  case 204:
#line 4332 "parser.y" /* yacc.c:1652  */
    { yyval = cb_norm_low; }
#line 13376 "parser.c" /* yacc.c:1652  */
    break;

  case 205:
#line 4336 "parser.y" /* yacc.c:1652  */
    { yyval = cb_space; }
#line 13382 "parser.c" /* yacc.c:1652  */
    break;

  case 206:
#line 4337 "parser.y" /* yacc.c:1652  */
    { yyval = cb_zero; }
#line 13388 "parser.c" /* yacc.c:1652  */
    break;

  case 207:
#line 4345 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else if (yyvsp[-1]) {
		CB_CHAIN_PAIR (current_program->symbolic_char_list, yyvsp[-1], yyvsp[0]);
	}
  }
#line 13403 "parser.c" /* yacc.c:1652  */
    break;

  case 208:
#line 4359 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13411 "parser.c" /* yacc.c:1652  */
    break;

  case 209:
#line 4363 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13419 "parser.c" /* yacc.c:1652  */
    break;

  case 210:
#line 4371 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13427 "parser.c" /* yacc.c:1652  */
    break;

  case 211:
#line 4378 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13435 "parser.c" /* yacc.c:1652  */
    break;

  case 212:
#line 4382 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 13447 "parser.c" /* yacc.c:1652  */
    break;

  case 213:
#line 4393 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 13468 "parser.c" /* yacc.c:1652  */
    break;

  case 214:
#line 4413 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 13480 "parser.c" /* yacc.c:1652  */
    break;

  case 215:
#line 4421 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 13492 "parser.c" /* yacc.c:1652  */
    break;

  case 216:
#line 4431 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 13498 "parser.c" /* yacc.c:1652  */
    break;

  case 217:
#line 4432 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 13504 "parser.c" /* yacc.c:1652  */
    break;

  case 218:
#line 4441 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 13518 "parser.c" /* yacc.c:1652  */
    break;

  case 221:
#line 4459 "parser.y" /* yacc.c:1652  */
    {
	struct cb_field *f;
	cb_tree v;

	v = CB_LIST_INIT (yyvsp[0]);
	f = CB_FIELD (cb_build_constant (yyvsp[-2], v));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = v;
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 13538 "parser.c" /* yacc.c:1652  */
    break;

  case 222:
#line 4480 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
	}
  }
#line 13560 "parser.c" /* yacc.c:1652  */
    break;

  case 223:
#line 4500 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 13566 "parser.c" /* yacc.c:1652  */
    break;

  case 224:
#line 4501 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 13572 "parser.c" /* yacc.c:1652  */
    break;

  case 225:
#line 4506 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13580 "parser.c" /* yacc.c:1652  */
    break;

  case 226:
#line 4510 "parser.y" /* yacc.c:1652  */
    {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (literal_value (yyvsp[-2]) <= literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 13600 "parser.c" /* yacc.c:1652  */
    break;

  case 228:
#line 4530 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13608 "parser.c" /* yacc.c:1652  */
    break;

  case 229:
#line 4534 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL CLASS");
	yyval = cb_int0;
  }
#line 13617 "parser.c" /* yacc.c:1652  */
    break;

  case 231:
#line 4543 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
	yyval = yyvsp[0];
  }
#line 13626 "parser.c" /* yacc.c:1652  */
    break;

  case 232:
#line 4553 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 13646 "parser.c" /* yacc.c:1652  */
    break;

  case 233:
#line 4574 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 13712 "parser.c" /* yacc.c:1652  */
    break;

  case 234:
#line 4640 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13720 "parser.c" /* yacc.c:1652  */
    break;

  case 235:
#line 4644 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13728 "parser.c" /* yacc.c:1652  */
    break;

  case 236:
#line 4653 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 13745 "parser.c" /* yacc.c:1652  */
    break;

  case 237:
#line 4672 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 13760 "parser.c" /* yacc.c:1652  */
    break;

  case 238:
#line 4688 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 13776 "parser.c" /* yacc.c:1652  */
    break;

  case 239:
#line 4706 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 13792 "parser.c" /* yacc.c:1652  */
    break;

  case 240:
#line 4724 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 13808 "parser.c" /* yacc.c:1652  */
    break;

  case 241:
#line 4741 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 13824 "parser.c" /* yacc.c:1652  */
    break;

  case 242:
#line 4758 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 13843 "parser.c" /* yacc.c:1652  */
    break;

  case 243:
#line 4773 "parser.y" /* yacc.c:1652  */
    {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 13855 "parser.c" /* yacc.c:1652  */
    break;

  case 246:
#line 4793 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 13864 "parser.c" /* yacc.c:1652  */
    break;

  case 248:
#line 4803 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 13874 "parser.c" /* yacc.c:1652  */
    break;

  case 251:
#line 4816 "parser.y" /* yacc.c:1652  */
    {
	char	buff[COB_MINI_BUFF];
	  
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else {
		/* Create dummy file */
		snprintf (buff, COB_MINI_BUFF, "SELECT on line %d",
			  cb_source_line);
		current_file = build_file (cb_build_reference (buff));
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);

	}
	key_type = NO_KEY;
  }
#line 13905 "parser.c" /* yacc.c:1652  */
    break;

  case 252:
#line 4843 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 13926 "parser.c" /* yacc.c:1652  */
    break;

  case 254:
#line 4864 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 13934 "parser.c" /* yacc.c:1652  */
    break;

  case 256:
#line 4871 "parser.y" /* yacc.c:1652  */
    {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 13943 "parser.c" /* yacc.c:1652  */
    break;

  case 276:
#line 4924 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13957 "parser.c" /* yacc.c:1652  */
    break;

  case 277:
#line 4934 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13971 "parser.c" /* yacc.c:1652  */
    break;

  case 278:
#line 4944 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
        cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13986 "parser.c" /* yacc.c:1652  */
    break;

  case 279:
#line 4955 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, _("ASSIGN DISK FROM"));

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 14001 "parser.c" /* yacc.c:1652  */
    break;

  case 280:
#line 4966 "parser.y" /* yacc.c:1652  */
    {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 14032 "parser.c" /* yacc.c:1652  */
    break;

  case 281:
#line 4996 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 14040 "parser.c" /* yacc.c:1652  */
    break;

  case 282:
#line 5000 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 14048 "parser.c" /* yacc.c:1652  */
    break;

  case 284:
#line 5008 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 14056 "parser.c" /* yacc.c:1652  */
    break;

  case 285:
#line 5012 "parser.y" /* yacc.c:1652  */
    {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 14065 "parser.c" /* yacc.c:1652  */
    break;

  case 286:
#line 5017 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 14073 "parser.c" /* yacc.c:1652  */
    break;

  case 287:
#line 5021 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 14081 "parser.c" /* yacc.c:1652  */
    break;

  case 288:
#line 5029 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
  }
#line 14089 "parser.c" /* yacc.c:1652  */
    break;

  case 289:
#line 5033 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
  }
#line 14097 "parser.c" /* yacc.c:1652  */
    break;

  case 290:
#line 5037 "parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
  }
#line 14105 "parser.c" /* yacc.c:1652  */
    break;

  case 302:
#line 5062 "parser.y" /* yacc.c:1652  */
    {
	current_file->flag_line_adv = 1;
  }
#line 14113 "parser.c" /* yacc.c:1652  */
    break;

  case 303:
#line 5069 "parser.y" /* yacc.c:1652  */
    {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 14122 "parser.c" /* yacc.c:1652  */
    break;

  case 304:
#line 5074 "parser.y" /* yacc.c:1652  */
    {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 14131 "parser.c" /* yacc.c:1652  */
    break;

  case 305:
#line 5082 "parser.y" /* yacc.c:1652  */
    {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 14139 "parser.c" /* yacc.c:1652  */
    break;

  case 306:
#line 5086 "parser.y" /* yacc.c:1652  */
    {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 14147 "parser.c" /* yacc.c:1652  */
    break;

  case 309:
#line 5100 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 14155 "parser.c" /* yacc.c:1652  */
    break;

  case 310:
#line 5106 "parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 14161 "parser.c" /* yacc.c:1652  */
    break;

  case 311:
#line 5107 "parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 14167 "parser.c" /* yacc.c:1652  */
    break;

  case 312:
#line 5108 "parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 14173 "parser.c" /* yacc.c:1652  */
    break;

  case 313:
#line 5116 "parser.y" /* yacc.c:1652  */
    {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 14228 "parser.c" /* yacc.c:1652  */
    break;

  case 314:
#line 5170 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 14236 "parser.c" /* yacc.c:1652  */
    break;

  case 316:
#line 5178 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("PASSWORD clause");
  }
#line 14244 "parser.c" /* yacc.c:1652  */
    break;

  case 317:
#line 5182 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 14252 "parser.c" /* yacc.c:1652  */
    break;

  case 318:
#line 5203 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 14260 "parser.c" /* yacc.c:1652  */
    break;

  case 319:
#line 5207 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (literal_value (yyvsp[0]));
  }
#line 14268 "parser.c" /* yacc.c:1652  */
    break;

  case 320:
#line 5211 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (literal_value (yyvsp[0]));
  }
#line 14276 "parser.c" /* yacc.c:1652  */
    break;

  case 321:
#line 5221 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 14287 "parser.c" /* yacc.c:1652  */
    break;

  case 322:
#line 5231 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 14295 "parser.c" /* yacc.c:1652  */
    break;

  case 324:
#line 5239 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 14303 "parser.c" /* yacc.c:1652  */
    break;

  case 325:
#line 5243 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14313 "parser.c" /* yacc.c:1652  */
    break;

  case 326:
#line 5249 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 14321 "parser.c" /* yacc.c:1652  */
    break;

  case 327:
#line 5253 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14330 "parser.c" /* yacc.c:1652  */
    break;

  case 328:
#line 5259 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14340 "parser.c" /* yacc.c:1652  */
    break;

  case 329:
#line 5266 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 14350 "parser.c" /* yacc.c:1652  */
    break;

  case 330:
#line 5275 "parser.y" /* yacc.c:1652  */
    {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 14362 "parser.c" /* yacc.c:1652  */
    break;

  case 331:
#line 5286 "parser.y" /* yacc.c:1652  */
    {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 14376 "parser.c" /* yacc.c:1652  */
    break;

  case 332:
#line 5301 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* Ignore VSAM STATUS field */
		cb_verify (cb_vsam_status, _("VSAM status"));
	}
  }
#line 14389 "parser.c" /* yacc.c:1652  */
    break;

  case 336:
#line 5320 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 14397 "parser.c" /* yacc.c:1652  */
    break;

  case 338:
#line 5328 "parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 14405 "parser.c" /* yacc.c:1652  */
    break;

  case 339:
#line 5332 "parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 14413 "parser.c" /* yacc.c:1652  */
    break;

  case 340:
#line 5336 "parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 14421 "parser.c" /* yacc.c:1652  */
    break;

  case 343:
#line 5345 "parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 14429 "parser.c" /* yacc.c:1652  */
    break;

  case 344:
#line 5349 "parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 14437 "parser.c" /* yacc.c:1652  */
    break;

  case 347:
#line 5360 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 14445 "parser.c" /* yacc.c:1652  */
    break;

  case 349:
#line 5367 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 14459 "parser.c" /* yacc.c:1652  */
    break;

  case 352:
#line 5388 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 14469 "parser.c" /* yacc.c:1652  */
    break;

  case 353:
#line 5394 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 14479 "parser.c" /* yacc.c:1652  */
    break;

  case 354:
#line 5400 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 14489 "parser.c" /* yacc.c:1652  */
    break;

  case 355:
#line 5406 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 14500 "parser.c" /* yacc.c:1652  */
    break;

  case 356:
#line 5419 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 14509 "parser.c" /* yacc.c:1652  */
    break;

  case 357:
#line 5429 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 14518 "parser.c" /* yacc.c:1652  */
    break;

  case 359:
#line 5438 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 14533 "parser.c" /* yacc.c:1652  */
    break;

  case 360:
#line 5449 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 14551 "parser.c" /* yacc.c:1652  */
    break;

  case 361:
#line 5463 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 14568 "parser.c" /* yacc.c:1652  */
    break;

  case 362:
#line 5476 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 14583 "parser.c" /* yacc.c:1652  */
    break;

  case 363:
#line 5492 "parser.y" /* yacc.c:1652  */
    {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 14622 "parser.c" /* yacc.c:1652  */
    break;

  case 364:
#line 5530 "parser.y" /* yacc.c:1652  */
    {
  	yyval = NULL;
  }
#line 14630 "parser.c" /* yacc.c:1652  */
    break;

  case 365:
#line 5534 "parser.y" /* yacc.c:1652  */
    {
  	yyval = cb_int0;
  }
#line 14638 "parser.c" /* yacc.c:1652  */
    break;

  case 368:
#line 5545 "parser.y" /* yacc.c:1652  */
    {
	key_component_list = NULL;
  }
#line 14646 "parser.c" /* yacc.c:1652  */
    break;

  case 371:
#line 5555 "parser.y" /* yacc.c:1652  */
    {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 14663 "parser.c" /* yacc.c:1652  */
    break;

  case 372:
#line 5573 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 14673 "parser.c" /* yacc.c:1652  */
    break;

  case 373:
#line 5584 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 14681 "parser.c" /* yacc.c:1652  */
    break;

  case 376:
#line 5598 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 14690 "parser.c" /* yacc.c:1652  */
    break;

  case 377:
#line 5610 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14696 "parser.c" /* yacc.c:1652  */
    break;

  case 378:
#line 5611 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 14702 "parser.c" /* yacc.c:1652  */
    break;

  case 379:
#line 5612 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14708 "parser.c" /* yacc.c:1652  */
    break;

  case 380:
#line 5619 "parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 14717 "parser.c" /* yacc.c:1652  */
    break;

  case 383:
#line 5634 "parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 14726 "parser.c" /* yacc.c:1652  */
    break;

  case 384:
#line 5644 "parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 14735 "parser.c" /* yacc.c:1652  */
    break;

  case 385:
#line 5654 "parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 14744 "parser.c" /* yacc.c:1652  */
    break;

  case 386:
#line 5664 "parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 14753 "parser.c" /* yacc.c:1652  */
    break;

  case 388:
#line 5675 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 14761 "parser.c" /* yacc.c:1652  */
    break;

  case 389:
#line 5682 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 14771 "parser.c" /* yacc.c:1652  */
    break;

  case 392:
#line 5692 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 14779 "parser.c" /* yacc.c:1652  */
    break;

  case 399:
#line 5713 "parser.y" /* yacc.c:1652  */
    {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 14808 "parser.c" /* yacc.c:1652  */
    break;

  case 400:
#line 5740 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 14814 "parser.c" /* yacc.c:1652  */
    break;

  case 401:
#line 5741 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 14820 "parser.c" /* yacc.c:1652  */
    break;

  case 402:
#line 5742 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 14826 "parser.c" /* yacc.c:1652  */
    break;

  case 403:
#line 5743 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 14832 "parser.c" /* yacc.c:1652  */
    break;

  case 404:
#line 5750 "parser.y" /* yacc.c:1652  */
    {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 14841 "parser.c" /* yacc.c:1652  */
    break;

  case 405:
#line 5755 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 14849 "parser.c" /* yacc.c:1652  */
    break;

  case 406:
#line 5759 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 14857 "parser.c" /* yacc.c:1652  */
    break;

  case 408:
#line 5764 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 14865 "parser.c" /* yacc.c:1652  */
    break;

  case 417:
#line 5784 "parser.y" /* yacc.c:1652  */
    {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 14874 "parser.c" /* yacc.c:1652  */
    break;

  case 418:
#line 5789 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 14886 "parser.c" /* yacc.c:1652  */
    break;

  case 428:
#line 5832 "parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_WORKING;
  }
#line 14894 "parser.c" /* yacc.c:1652  */
    break;

  case 432:
#line 5849 "parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 14902 "parser.c" /* yacc.c:1652  */
    break;

  case 434:
#line 5858 "parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 14912 "parser.c" /* yacc.c:1652  */
    break;

  case 437:
#line 5872 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 14929 "parser.c" /* yacc.c:1652  */
    break;

  case 438:
#line 5890 "parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	current_file->description_entry = yyvsp[0];
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 14956 "parser.c" /* yacc.c:1652  */
    break;

  case 440:
#line 5914 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 14964 "parser.c" /* yacc.c:1652  */
    break;

  case 441:
#line 5921 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 14972 "parser.c" /* yacc.c:1652  */
    break;

  case 442:
#line 5925 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 14980 "parser.c" /* yacc.c:1652  */
    break;

  case 445:
#line 5936 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	current_file->flag_external = 1;
  }
#line 14994 "parser.c" /* yacc.c:1652  */
    break;

  case 446:
#line 5946 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 15013 "parser.c" /* yacc.c:1652  */
    break;

  case 456:
#line 5976 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 15022 "parser.c" /* yacc.c:1652  */
    break;

  case 460:
#line 5989 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 15035 "parser.c" /* yacc.c:1652  */
    break;

  case 461:
#line 5998 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-3], yyvsp[-1]);
	}
  }
#line 15048 "parser.c" /* yacc.c:1652  */
    break;

  case 462:
#line 6008 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 15059 "parser.c" /* yacc.c:1652  */
    break;

  case 464:
#line 6018 "parser.y" /* yacc.c:1652  */
    {
	current_file->record_depending = yyvsp[0];
  }
#line 15067 "parser.c" /* yacc.c:1652  */
    break;

  case 465:
#line 6024 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 15073 "parser.c" /* yacc.c:1652  */
    break;

  case 466:
#line 6025 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15079 "parser.c" /* yacc.c:1652  */
    break;

  case 467:
#line 6029 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 15085 "parser.c" /* yacc.c:1652  */
    break;

  case 468:
#line 6030 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15091 "parser.c" /* yacc.c:1652  */
    break;

  case 469:
#line 6038 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 15100 "parser.c" /* yacc.c:1652  */
    break;

  case 470:
#line 6049 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 15109 "parser.c" /* yacc.c:1652  */
    break;

  case 471:
#line 6054 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 15121 "parser.c" /* yacc.c:1652  */
    break;

  case 476:
#line 6077 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 15130 "parser.c" /* yacc.c:1652  */
    break;

  case 477:
#line 6089 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 15149 "parser.c" /* yacc.c:1652  */
    break;

  case 483:
#line 6117 "parser.y" /* yacc.c:1652  */
    {
	current_file->latfoot = yyvsp[0];
  }
#line 15157 "parser.c" /* yacc.c:1652  */
    break;

  case 484:
#line 6124 "parser.y" /* yacc.c:1652  */
    {
	current_file->lattop = yyvsp[0];
  }
#line 15165 "parser.c" /* yacc.c:1652  */
    break;

  case 485:
#line 6131 "parser.y" /* yacc.c:1652  */
    {
	current_file->latbot = yyvsp[0];
  }
#line 15173 "parser.c" /* yacc.c:1652  */
    break;

  case 486:
#line 6140 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 15183 "parser.c" /* yacc.c:1652  */
    break;

  case 491:
#line 6153 "parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 15193 "parser.c" /* yacc.c:1652  */
    break;

  case 494:
#line 6169 "parser.y" /* yacc.c:1652  */
    {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		switch (al->alphabet_type) {
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
		case CB_ALPHABET_CUSTOM:
			current_file->code_set = al;
			CB_PENDING ("CODE-SET");
			break;
		default:
			if (cb_warn_additional) {
				cb_warning_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			} else {
				CB_PENDING ("CODE-SET");
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 15232 "parser.c" /* yacc.c:1652  */
    break;

  case 496:
#line 6207 "parser.y" /* yacc.c:1652  */
    {
	  CB_PENDING ("FOR sub-records");
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 15241 "parser.c" /* yacc.c:1652  */
    break;

  case 497:
#line 6217 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 15257 "parser.c" /* yacc.c:1652  */
    break;

  case 500:
#line 6237 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15275 "parser.c" /* yacc.c:1652  */
    break;

  case 501:
#line 6251 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15293 "parser.c" /* yacc.c:1652  */
    break;

  case 503:
#line 6270 "parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 15312 "parser.c" /* yacc.c:1652  */
    break;

  case 507:
#line 6294 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 15326 "parser.c" /* yacc.c:1652  */
    break;

  case 508:
#line 6309 "parser.y" /* yacc.c:1652  */
    {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 15348 "parser.c" /* yacc.c:1652  */
    break;

  case 556:
#line 6417 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 15358 "parser.c" /* yacc.c:1652  */
    break;

  case 557:
#line 6423 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 15368 "parser.c" /* yacc.c:1652  */
    break;

  case 558:
#line 6432 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15376 "parser.c" /* yacc.c:1652  */
    break;

  case 559:
#line 6436 "parser.y" /* yacc.c:1652  */
    {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 15387 "parser.c" /* yacc.c:1652  */
    break;

  case 560:
#line 6443 "parser.y" /* yacc.c:1652  */
    {
	yyval = get_finalized_description_tree ();
  }
#line 15395 "parser.c" /* yacc.c:1652  */
    break;

  case 566:
#line 6458 "parser.y" /* yacc.c:1652  */
    {
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (yyvsp[-1]);
	}
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 15410 "parser.c" /* yacc.c:1652  */
    break;

  case 567:
#line 6469 "parser.y" /* yacc.c:1652  */
    {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 15423 "parser.c" /* yacc.c:1652  */
    break;

  case 568:
#line 6478 "parser.y" /* yacc.c:1652  */
    {
#if 0 /* works fine without, leads to invalid free otherwise [COB_TREE_DEBUG] */
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
#endif
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 15441 "parser.c" /* yacc.c:1652  */
    break;

  case 569:
#line 6495 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15449 "parser.c" /* yacc.c:1652  */
    break;

  case 572:
#line 6507 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15460 "parser.c" /* yacc.c:1652  */
    break;

  case 574:
#line 6518 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15471 "parser.c" /* yacc.c:1652  */
    break;

  case 575:
#line 6528 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15479 "parser.c" /* yacc.c:1652  */
    break;

  case 576:
#line 6532 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 15492 "parser.c" /* yacc.c:1652  */
    break;

  case 577:
#line 6543 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15498 "parser.c" /* yacc.c:1652  */
    break;

  case 578:
#line 6544 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_const_length (yyvsp[0]); }
#line 15504 "parser.c" /* yacc.c:1652  */
    break;

  case 579:
#line 6546 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_const_length (yyvsp[0]); }
#line 15510 "parser.c" /* yacc.c:1652  */
    break;

  case 580:
#line 6551 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15518 "parser.c" /* yacc.c:1652  */
    break;

  case 581:
#line 6555 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15526 "parser.c" /* yacc.c:1652  */
    break;

  case 582:
#line 6561 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 15534 "parser.c" /* yacc.c:1652  */
    break;

  case 583:
#line 6565 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int2;
  }
#line 15542 "parser.c" /* yacc.c:1652  */
    break;

  case 584:
#line 6569 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int4;
  }
#line 15550 "parser.c" /* yacc.c:1652  */
    break;

  case 585:
#line 6573 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int8;
  }
#line 15558 "parser.c" /* yacc.c:1652  */
    break;

  case 586:
#line 6577 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(long));
  }
#line 15566 "parser.c" /* yacc.c:1652  */
    break;

  case 587:
#line 6581 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 15574 "parser.c" /* yacc.c:1652  */
    break;

  case 588:
#line 6585 "parser.y" /* yacc.c:1652  */
    {
	if (cb_binary_comp_1) {
		yyval = cb_int2;
	} else {
		yyval = cb_int ((int)sizeof(float));
	}
  }
#line 15586 "parser.c" /* yacc.c:1652  */
    break;

  case 589:
#line 6593 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(float));
  }
#line 15594 "parser.c" /* yacc.c:1652  */
    break;

  case 590:
#line 6597 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(double));
  }
#line 15602 "parser.c" /* yacc.c:1652  */
    break;

  case 591:
#line 6601 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int4;
  }
#line 15610 "parser.c" /* yacc.c:1652  */
    break;

  case 592:
#line 6605 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int8;
  }
#line 15618 "parser.c" /* yacc.c:1652  */
    break;

  case 593:
#line 6609 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int16;
  }
#line 15626 "parser.c" /* yacc.c:1652  */
    break;

  case 594:
#line 6613 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 15638 "parser.c" /* yacc.c:1652  */
    break;

  case 604:
#line 6645 "parser.y" /* yacc.c:1652  */
    {
	cb_tree renames_target = cb_ref (yyvsp[-1]);

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field (yyvsp[-5], yyvsp[-4])) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = yyvsp[0];

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, yyvsp[-1], yyvsp[0])) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 15682 "parser.c" /* yacc.c:1652  */
    break;

  case 605:
#line 6688 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15690 "parser.c" /* yacc.c:1652  */
    break;

  case 606:
#line 6692 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0] == cb_error_node ? NULL : yyvsp[0];
  }
#line 15698 "parser.c" /* yacc.c:1652  */
    break;

  case 607:
#line 6699 "parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 15708 "parser.c" /* yacc.c:1652  */
    break;

  case 608:
#line 6705 "parser.y" /* yacc.c:1652  */
    {
	cb_validate_88_item (current_field);
  }
#line 15716 "parser.c" /* yacc.c:1652  */
    break;

  case 609:
#line 6712 "parser.y" /* yacc.c:1652  */
    {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level (yyvsp[-4]);
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-4]);
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if (yyvsp[0]) {
		if (cb_verify(cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant (yyvsp[-3], yyvsp[0]);
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = yyvsp[0];
			cb_needs_01 = 1;
			if (yyvsp[-1]) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 15747 "parser.c" /* yacc.c:1652  */
    break;

  case 610:
#line 6739 "parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 15757 "parser.c" /* yacc.c:1652  */
    break;

  case 611:
#line 6746 "parser.y" /* yacc.c:1652  */
    {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 15766 "parser.c" /* yacc.c:1652  */
    break;

  case 612:
#line 6754 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15774 "parser.c" /* yacc.c:1652  */
    break;

  case 613:
#line 6758 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT(cb_build_const_from (yyvsp[0]));
  }
#line 15782 "parser.c" /* yacc.c:1652  */
    break;

  case 614:
#line 6765 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_field)) {
		current_field->values = yyvsp[0];
	}
  }
#line 15792 "parser.c" /* yacc.c:1652  */
    break;

  case 615:
#line 6771 "parser.y" /* yacc.c:1652  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_start (current_field, yyvsp[0]));
  }
#line 15800 "parser.c" /* yacc.c:1652  */
    break;

  case 616:
#line 6775 "parser.y" /* yacc.c:1652  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_next (current_field));
  }
#line 15808 "parser.c" /* yacc.c:1652  */
    break;

  case 617:
#line 6781 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 15814 "parser.c" /* yacc.c:1652  */
    break;

  case 618:
#line 6782 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 15820 "parser.c" /* yacc.c:1652  */
    break;

  case 619:
#line 6786 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15826 "parser.c" /* yacc.c:1652  */
    break;

  case 620:
#line 6787 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("(", 1); }
#line 15832 "parser.c" /* yacc.c:1652  */
    break;

  case 621:
#line 6788 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal (")", 1); }
#line 15838 "parser.c" /* yacc.c:1652  */
    break;

  case 622:
#line 6789 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("+", 1); }
#line 15844 "parser.c" /* yacc.c:1652  */
    break;

  case 623:
#line 6790 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("-", 1); }
#line 15850 "parser.c" /* yacc.c:1652  */
    break;

  case 624:
#line 6791 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("*", 1); }
#line 15856 "parser.c" /* yacc.c:1652  */
    break;

  case 625:
#line 6792 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("/", 1); }
#line 15862 "parser.c" /* yacc.c:1652  */
    break;

  case 626:
#line 6793 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("&", 1); }
#line 15868 "parser.c" /* yacc.c:1652  */
    break;

  case 627:
#line 6794 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("|", 1); }
#line 15874 "parser.c" /* yacc.c:1652  */
    break;

  case 628:
#line 6795 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("^", 1); }
#line 15880 "parser.c" /* yacc.c:1652  */
    break;

  case 631:
#line 6805 "parser.y" /* yacc.c:1652  */
    {
	save_tree = cb_int0;
  }
#line 15888 "parser.c" /* yacc.c:1652  */
    break;

  case 654:
#line 6840 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if (save_tree != NULL) {
		cb_verify_x (yyvsp[0], cb_free_redefines_position,
			     _("REDEFINES clause not following entry-name"));
	}

	current_field->redefines = cb_resolve_redefines (current_field, yyvsp[0]);
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 15907 "parser.c" /* yacc.c:1652  */
    break;

  case 655:
#line 6861 "parser.y" /* yacc.c:1652  */
    {
	if (!check_repeated ("LIKE", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		setup_external_definition (yyvsp[-1], 0);
		current_field->like_modifier = yyvsp[0];
		CB_PENDING_X (yyvsp[-1], "LIKE clause");
	}
  }
#line 15922 "parser.c" /* yacc.c:1652  */
    break;

  case 656:
#line 6874 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 15928 "parser.c" /* yacc.c:1652  */
    break;

  case 658:
#line 6879 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 15936 "parser.c" /* yacc.c:1652  */
    break;

  case 659:
#line 6888 "parser.y" /* yacc.c:1652  */
    {
	if (!check_repeated ("SAME AS", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		cb_verify (cb_same_as_clause, _("SAME AS clause"));
		setup_external_definition (yyvsp[0], 0);
	}


  }
#line 15952 "parser.c" /* yacc.c:1652  */
    break;

  case 660:
#line 6906 "parser.y" /* yacc.c:1652  */
    {
	if (current_field->flag_is_typedef) {
		emit_duplicate_clause_message ("TYPEDEF");
		YYERROR;
	}
	/* note: no explicit verification as all dialects with this reserved word use it */
	current_field->flag_is_typedef = 1;
	within_typedef_definition = 1;

	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "TYPEDEF");
	}
	if (!qualifier) {
		cb_error (_("%s requires a data name"), "TYPEDEF");
	}
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error (_("%s not allowed in %s"), "TYPEDEF",
			enum_explain_storage(current_storage));
	}
  }
#line 15978 "parser.c" /* yacc.c:1652  */
    break;

  case 662:
#line 6931 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("TYPEDEF STRONG");
  }
#line 15986 "parser.c" /* yacc.c:1652  */
    break;

  case 663:
#line 6941 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 16014 "parser.c" /* yacc.c:1652  */
    break;

  case 664:
#line 6968 "parser.y" /* yacc.c:1652  */
    {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 16022 "parser.c" /* yacc.c:1652  */
    break;

  case 665:
#line 6972 "parser.y" /* yacc.c:1652  */
    {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL (yyvsp[0])->data);
  }
#line 16030 "parser.c" /* yacc.c:1652  */
    break;

  case 668:
#line 6985 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 16053 "parser.c" /* yacc.c:1652  */
    break;

  case 669:
#line 7009 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_verify (cb_special_names_clause, "SPECIAL-NAMES clause");
	}
  }
#line 16065 "parser.c" /* yacc.c:1652  */
    break;

  case 671:
#line 7021 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		current_program->cursor_pos = cb_build_reference (current_field->name);
	}
  }
#line 16077 "parser.c" /* yacc.c:1652  */
    break;

  case 672:
#line 7029 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->crt_status) {
		emit_duplicate_clause_message ("CRT STATUS");
	} else {
		current_program->crt_status = cb_build_reference (current_field->name);
	}
  }
#line 16089 "parser.c" /* yacc.c:1652  */
    break;

  case 673:
#line 7046 "parser.y" /* yacc.c:1652  */
    {
#if 0 /* not yet implemented */
	if (current_program->screen_control) {
		emit_duplicate_clause_message ("SCREEN CONTROL");
	} else {
		CB_PENDING ("SCREEN CONTROL");
	}
#else
	CB_PENDING ("SCREEN CONTROL");
#endif
  }
#line 16105 "parser.c" /* yacc.c:1652  */
    break;

  case 674:
#line 7058 "parser.y" /* yacc.c:1652  */
    {
#if 0 /* not yet implemented */
	if (current_program->event_status) {
		emit_duplicate_clause_message ("EVENT STATUS");
	} else {
		CB_PENDING ("EVENT STATUS");
	}
#else
	CB_PENDING ("EVENT STATUS");
#endif
  }
#line 16121 "parser.c" /* yacc.c:1652  */
    break;

  case 675:
#line 7075 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VOLATILE", SYN_CLAUSE_24, &check_pic_duplicate);
	/* note: there is no reason to check current_storage as we only parse
	         volatile_clause and its parent tokens where applicable,
	         same is true for level 66,78,88 */
	/* missing part: always generate and initialize storage */
	CB_UNFINISHED ("VOLATILE");
	current_field->flag_volatile = 1;
	/* TODO: set VOLATILE flag for all parent fields */
  }
#line 16136 "parser.c" /* yacc.c:1652  */
    break;

  case 676:
#line 7093 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE (yyvsp[-1]);

	if (CB_VALID_TREE (yyvsp[0])) {
		if (  (current_field->pic->category != CB_CATEGORY_NUMERIC
		    && current_field->pic->category != CB_CATEGORY_NUMERIC_EDITED)
		 || strpbrk (current_field->pic->orig, " CRDB-*") /* the standard seems to forbid also ',' */) {
			cb_error_x (yyvsp[-1], _("a locale-format PICTURE string must only consist of '9', '.', '+', 'Z' and the currency-sign"));
		} else {
			/* TODO: check that not we're not within a CONSTANT RECORD */
			CB_PENDING_X (yyvsp[-1], "locale-format PICTURE");
		}
	}
  }
#line 16156 "parser.c" /* yacc.c:1652  */
    break;

  case 677:
#line 7112 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16162 "parser.c" /* yacc.c:1652  */
    break;

  case 678:
#line 7114 "parser.y" /* yacc.c:1652  */
    {
	/* $2 -> optional locale-name to be used */
	yyval = yyvsp[0];
  }
#line 16171 "parser.c" /* yacc.c:1652  */
    break;

  case 680:
#line 7123 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 16179 "parser.c" /* yacc.c:1652  */
    break;

  case 681:
#line 7131 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LOCALE_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a locale-name"),	cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 16192 "parser.c" /* yacc.c:1652  */
    break;

  case 682:
#line 7146 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_type_to_clause, _("TYPE TO clause"));
	setup_external_definition_type (yyvsp[0]);
  }
#line 16201 "parser.c" /* yacc.c:1652  */
    break;

  case 685:
#line 7159 "parser.y" /* yacc.c:1652  */
    {
	{
		cb_tree x = cb_try_ref (yyvsp[0]);
		if (!CB_INVALID_TREE (x) && CB_FIELD_P (x) && CB_FIELD (x)->flag_is_typedef) {
			if (!check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate)) {
				if (current_field->external_definition) {
					emit_conflicting_clause_message ("USAGE", "SAME AS / TYPE TO");
				} else {
					cb_verify (cb_usage_type_name, _("USAGE type-name"));
					/* replace usage by type definition */
					check_pic_duplicate &= ~SYN_CLAUSE_5;
					check_repeated ("USAGE/TYPE", SYN_CLAUSE_31, &check_pic_duplicate);
					setup_external_definition (yyvsp[0], 1);
					break;	/* everything done here */
				}
			}
			YYERROR;
		}
	}
	if (is_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not a valid USAGE"), CB_NAME (yyvsp[0]));
	} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not defined, but is a reserved word in another dialect"),
				CB_NAME (yyvsp[0]));
	} else {
		cb_error_x (yyvsp[0], _("unknown USAGE: %s"), CB_NAME (yyvsp[0]));
	}
	check_and_set_usage (CB_USAGE_ERROR);
	YYERROR;
  }
#line 16236 "parser.c" /* yacc.c:1652  */
    break;

  case 686:
#line 7190 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_ERROR);
  }
#line 16244 "parser.c" /* yacc.c:1652  */
    break;

  case 687:
#line 7197 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16252 "parser.c" /* yacc.c:1652  */
    break;

  case 688:
#line 7201 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 16261 "parser.c" /* yacc.c:1652  */
    break;

  case 689:
#line 7206 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16269 "parser.c" /* yacc.c:1652  */
    break;

  case 690:
#line 7210 "parser.y" /* yacc.c:1652  */
    {
	/* see FR #310 */
	CB_PENDING ("USAGE COMP-0");
  }
#line 16278 "parser.c" /* yacc.c:1652  */
    break;

  case 691:
#line 7215 "parser.y" /* yacc.c:1652  */
    {
	current_field->flag_comp_1 = 1;
	if (cb_binary_comp_1) {
		check_and_set_usage (CB_USAGE_SIGNED_SHORT);
	} else {
		check_and_set_usage (CB_USAGE_FLOAT);
	}
  }
#line 16291 "parser.c" /* yacc.c:1652  */
    break;

  case 692:
#line 7224 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 16299 "parser.c" /* yacc.c:1652  */
    break;

  case 693:
#line 7228 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16307 "parser.c" /* yacc.c:1652  */
    break;

  case 694:
#line 7232 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16315 "parser.c" /* yacc.c:1652  */
    break;

  case 695:
#line 7236 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 16323 "parser.c" /* yacc.c:1652  */
    break;

  case 696:
#line 7240 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 16331 "parser.c" /* yacc.c:1652  */
    break;

  case 697:
#line 7244 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 16339 "parser.c" /* yacc.c:1652  */
    break;

  case 698:
#line 7248 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_N);
  }
#line 16347 "parser.c" /* yacc.c:1652  */
    break;

  case 699:
#line 7252 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 16355 "parser.c" /* yacc.c:1652  */
    break;

  case 700:
#line 7256 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 16363 "parser.c" /* yacc.c:1652  */
    break;

  case 701:
#line 7260 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 16371 "parser.c" /* yacc.c:1652  */
    break;

  case 702:
#line 7264 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16379 "parser.c" /* yacc.c:1652  */
    break;

  case 703:
#line 7268 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16388 "parser.c" /* yacc.c:1652  */
    break;

  case 704:
#line 7273 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16397 "parser.c" /* yacc.c:1652  */
    break;

  case 705:
#line 7278 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 16405 "parser.c" /* yacc.c:1652  */
    break;

  case 706:
#line 7282 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 16413 "parser.c" /* yacc.c:1652  */
    break;

  case 707:
#line 7286 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 16421 "parser.c" /* yacc.c:1652  */
    break;

  case 708:
#line 7290 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 16430 "parser.c" /* yacc.c:1652  */
    break;

  case 709:
#line 7295 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 16438 "parser.c" /* yacc.c:1652  */
    break;

  case 710:
#line 7299 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 16447 "parser.c" /* yacc.c:1652  */
    break;

  case 711:
#line 7304 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 16455 "parser.c" /* yacc.c:1652  */
    break;

  case 712:
#line 7308 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 16464 "parser.c" /* yacc.c:1652  */
    break;

  case 713:
#line 7313 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	CB_PENDING ("HANDLE OF control-type");
  }
#line 16473 "parser.c" /* yacc.c:1652  */
    break;

  case 714:
#line 7318 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	cb_error_x (yyvsp[0], _("unknown HANDLE type: %s"), CB_NAME (yyvsp[0]));
  }
#line 16482 "parser.c" /* yacc.c:1652  */
    break;

  case 715:
#line 7323 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 16490 "parser.c" /* yacc.c:1652  */
    break;

  case 716:
#line 7327 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 16498 "parser.c" /* yacc.c:1652  */
    break;

  case 717:
#line 7331 "parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 16510 "parser.c" /* yacc.c:1652  */
    break;

  case 718:
#line 7339 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 16518 "parser.c" /* yacc.c:1652  */
    break;

  case 719:
#line 7343 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 16526 "parser.c" /* yacc.c:1652  */
    break;

  case 720:
#line 7347 "parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 16538 "parser.c" /* yacc.c:1652  */
    break;

  case 721:
#line 7355 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 16546 "parser.c" /* yacc.c:1652  */
    break;

  case 722:
#line 7359 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 16554 "parser.c" /* yacc.c:1652  */
    break;

  case 723:
#line 7363 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 16562 "parser.c" /* yacc.c:1652  */
    break;

  case 724:
#line 7367 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 16570 "parser.c" /* yacc.c:1652  */
    break;

  case 725:
#line 7371 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 16578 "parser.c" /* yacc.c:1652  */
    break;

  case 726:
#line 7375 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 16586 "parser.c" /* yacc.c:1652  */
    break;

  case 727:
#line 7379 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
  }
#line 16594 "parser.c" /* yacc.c:1652  */
    break;

  case 728:
#line 7383 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
  }
#line 16602 "parser.c" /* yacc.c:1652  */
    break;

  case 729:
#line 7387 "parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 16614 "parser.c" /* yacc.c:1652  */
    break;

  case 730:
#line 7395 "parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 16626 "parser.c" /* yacc.c:1652  */
    break;

  case 731:
#line 7403 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN32);
  }
#line 16634 "parser.c" /* yacc.c:1652  */
    break;

  case 732:
#line 7407 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN64);
  }
#line 16642 "parser.c" /* yacc.c:1652  */
    break;

  case 733:
#line 7411 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN128);
  }
#line 16650 "parser.c" /* yacc.c:1652  */
    break;

  case 734:
#line 7415 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC64);
  }
#line 16658 "parser.c" /* yacc.c:1652  */
    break;

  case 735:
#line 7419 "parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC128);
  }
#line 16666 "parser.c" /* yacc.c:1652  */
    break;

  case 736:
#line 7423 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	CB_UNFINISHED ("USAGE NATIONAL");
  }
#line 16675 "parser.c" /* yacc.c:1652  */
    break;

  case 748:
#line 7453 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 1;
  }
#line 16686 "parser.c" /* yacc.c:1652  */
    break;

  case 749:
#line 7460 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 0;
  }
#line 16697 "parser.c" /* yacc.c:1652  */
    break;

  case 750:
#line 7474 "parser.y" /* yacc.c:1652  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 16707 "parser.c" /* yacc.c:1652  */
    break;

  case 752:
#line 7483 "parser.y" /* yacc.c:1652  */
    {
	current_field->step_count = cb_get_int (yyvsp[0]);
  }
#line 16715 "parser.c" /* yacc.c:1652  */
    break;

  case 753:
#line 7493 "parser.y" /* yacc.c:1652  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 16725 "parser.c" /* yacc.c:1652  */
    break;

  case 754:
#line 7500 "parser.y" /* yacc.c:1652  */
    {
	current_field->flag_unbounded = 1;
	if (current_field->parent) {
		current_field->parent->flag_unbounded = 1;
	}
	current_field->depending = yyvsp[-1];
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-6], cb_int0);
  }
#line 16740 "parser.c" /* yacc.c:1652  */
    break;

  case 755:
#line 7512 "parser.y" /* yacc.c:1652  */
    {
	setup_occurs ();
	current_field->occurs_min = yyvsp[-3] ? cb_get_int (yyvsp[-3]) : 0;
	if (yyvsp[-2]) {
		current_field->occurs_max = cb_get_int (yyvsp[-2]);
		if (current_field->occurs_max <= current_field->occurs_min) {
			cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
		}
	} else {
		current_field->occurs_max = 0;
	}
	CB_PENDING ("OCCURS DYNAMIC");
  }
#line 16758 "parser.c" /* yacc.c:1652  */
    break;

  case 756:
#line 7528 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16764 "parser.c" /* yacc.c:1652  */
    break;

  case 757:
#line 7529 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 16770 "parser.c" /* yacc.c:1652  */
    break;

  case 758:
#line 7533 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16776 "parser.c" /* yacc.c:1652  */
    break;

  case 759:
#line 7534 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 16782 "parser.c" /* yacc.c:1652  */
    break;

  case 760:
#line 7538 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16788 "parser.c" /* yacc.c:1652  */
    break;

  case 761:
#line 7539 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 16794 "parser.c" /* yacc.c:1652  */
    break;

  case 763:
#line 7544 "parser.y" /* yacc.c:1652  */
    {
	current_field->depending = yyvsp[0];
  }
#line 16802 "parser.c" /* yacc.c:1652  */
    break;

  case 765:
#line 7550 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_index (yyvsp[0], cb_zero, 0, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 16811 "parser.c" /* yacc.c:1652  */
    break;

  case 767:
#line 7558 "parser.y" /* yacc.c:1652  */
    {
	/* current_field->initialized = 1; */
  }
#line 16819 "parser.c" /* yacc.c:1652  */
    break;

  case 770:
#line 7567 "parser.y" /* yacc.c:1652  */
    {
	if (!cb_relaxed_syntax_checks) {
		cb_error (_("INDEXED should follow ASCENDING/DESCENDING"));
	} else {
		cb_warning (cb_warn_additional, _("INDEXED should follow ASCENDING/DESCENDING"));
	}
  }
#line 16831 "parser.c" /* yacc.c:1652  */
    break;

  case 774:
#line 7581 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;
	struct cb_key	*keys;
	int		i;
	int		nkeys;

	l = yyvsp[0];
	nkeys = cb_list_length (yyvsp[0]);
	keys = cobc_parse_malloc (sizeof (struct cb_key) * nkeys);

	for (i = 0; i < nkeys; i++) {
		keys[i].dir = CB_PURPOSE_INT (l);
		keys[i].key = CB_VALUE (l);
		l = CB_CHAIN (l);
	}
	current_field->keys = keys;
	current_field->nkeys = nkeys;
  }
#line 16854 "parser.c" /* yacc.c:1652  */
    break;

  case 777:
#line 7608 "parser.y" /* yacc.c:1652  */
    {
	cb_tree ref = NULL;
	cb_tree rchain = NULL;
	cb_tree l;

	/* create reference chaing all the way up
	   as later fields may have same name */
	if (!within_typedef_definition) {
		rchain = cb_build_full_field_reference (current_field->parent);
	}

	for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = yyvsp[-3];
		ref = CB_VALUE (l);
		if (CB_VALID_TREE(ref)) {
			CB_REFERENCE (ref)->chain = rchain;
		}
	}
	keys_list = cb_list_append (keys_list, yyvsp[0]);
	yyval = keys_list;
  }
#line 16880 "parser.c" /* yacc.c:1652  */
    break;

  case 778:
#line 7632 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_ASCENDING); }
#line 16886 "parser.c" /* yacc.c:1652  */
    break;

  case 779:
#line 7633 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_DESCENDING); }
#line 16892 "parser.c" /* yacc.c:1652  */
    break;

  case 782:
#line 7642 "parser.y" /* yacc.c:1652  */
    {
	current_field->index_list = yyvsp[0];
  }
#line 16900 "parser.c" /* yacc.c:1652  */
    break;

  case 783:
#line 7648 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16906 "parser.c" /* yacc.c:1652  */
    break;

  case 784:
#line 7650 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16912 "parser.c" /* yacc.c:1652  */
    break;

  case 785:
#line 7655 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_index (yyvsp[0], cb_int1, 1U, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 16921 "parser.c" /* yacc.c:1652  */
    break;

  case 786:
#line 7666 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("JUSTIFIED", SYN_CLAUSE_8, &check_pic_duplicate);
	current_field->flag_justified = 1;
  }
#line 16930 "parser.c" /* yacc.c:1652  */
    break;

  case 787:
#line 7677 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SYNCHRONIZED", SYN_CLAUSE_9, &check_pic_duplicate);
	if (cb_verify (cb_synchronized_clause, _("SYNCHRONIZED clause"))) {
		current_field->flag_synchronized = 1;
	}
  }
#line 16941 "parser.c" /* yacc.c:1652  */
    break;

  case 790:
#line 7689 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SYNCHRONIZED RIGHT");
  }
#line 16949 "parser.c" /* yacc.c:1652  */
    break;

  case 791:
#line 7699 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK", SYN_CLAUSE_10, &check_pic_duplicate);
	current_field->flag_blank_zero = 1;
  }
#line 16958 "parser.c" /* yacc.c:1652  */
    break;

  case 792:
#line 7710 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BASED", SYN_CLAUSE_11, &check_pic_duplicate);
	if (current_storage == CB_STORAGE_FILE) {
		cb_error (_("%s not allowed here"), "BASED");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "BASED");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "BASED");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "REDEFINES");
	} else if (current_field->flag_any_length) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else {
		current_field->flag_item_based = 1;
	}
  }
#line 16983 "parser.c" /* yacc.c:1652  */
    break;

  case 793:
#line 7736 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = yyvsp[0];
  }
#line 16992 "parser.c" /* yacc.c:1652  */
    break;

  case 795:
#line 7744 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16998 "parser.c" /* yacc.c:1652  */
    break;

  case 796:
#line 7745 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 17004 "parser.c" /* yacc.c:1652  */
    break;

  case 797:
#line 7749 "parser.y" /* yacc.c:1652  */
    { yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]); }
#line 17010 "parser.c" /* yacc.c:1652  */
    break;

  case 800:
#line 7756 "parser.y" /* yacc.c:1652  */
    {
	if (current_field->level != 88) {
		cb_error (_("FALSE clause only allowed for 88 level"));
	}
	current_field->false_88 = CB_LIST_INIT (yyvsp[0]);
  }
#line 17021 "parser.c" /* yacc.c:1652  */
    break;

  case 801:
#line 7768 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else {
		current_field->flag_any_length = 1;
	}
  }
#line 17034 "parser.c" /* yacc.c:1652  */
    break;

  case 802:
#line 7777 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY NUMERIC");
	} else {
		current_field->flag_any_length = 1;
		current_field->flag_any_numeric = 1;
	}
  }
#line 17048 "parser.c" /* yacc.c:1652  */
    break;

  case 803:
#line 7792 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL-FORM", SYN_CLAUSE_2, &check_pic_duplicate);
	CB_PENDING ("EXTERNAL-FORM");
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL-FORM");
	} else if (current_field->level != 1) {	/* docs say: at group level */
		cb_error (_("%s only allowed at 01 level"), "EXTERNAL-FORM");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL-FORM");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s combination not allowed"), "EXTERNAL-FORM", "REDEFINES");
	} else {
		current_field->flag_is_external_form = 1;
	}
  }
#line 17068 "parser.c" /* yacc.c:1652  */
    break;

  case 804:
#line 7815 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("IDENTIFIED BY", SYN_CLAUSE_3, &check_pic_duplicate);
	if (!current_field->flag_is_external_form) {
		CB_PENDING ("EXTERNAL-FORM (IDENTIFIED BY)");
		if (current_storage != CB_STORAGE_WORKING) {
			cb_error (_("%s not allowed here"), "IDENTIFIED BY");
		} else if (!qualifier) {
			cb_error (_("%s requires a data name"), "IDENTIFIED BY");
		} else if (current_field->redefines) {
			cb_error (_("%s and %s combination not allowed"), "IDENTIFIED BY", "REDEFINES");
		}
	}
	current_field->external_form_identifier = yyvsp[0];
  }
#line 17087 "parser.c" /* yacc.c:1652  */
    break;

  case 806:
#line 7835 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LOCAL_STORAGE_SECTION;
	current_storage = CB_STORAGE_LOCAL;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "LOCAL-STORAGE");
	} else if (cb_local_implies_recursive) {
		current_program->flag_recursive = 1;
	}
  }
#line 17102 "parser.c" /* yacc.c:1652  */
    break;

  case 807:
#line 7846 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_program->local_storage = CB_FIELD (yyvsp[0]);
	}
  }
#line 17112 "parser.c" /* yacc.c:1652  */
    break;

  case 809:
#line 7858 "parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LINKAGE_SECTION;
	current_storage = CB_STORAGE_LINKAGE;
  }
#line 17122 "parser.c" /* yacc.c:1652  */
    break;

  case 810:
#line 7864 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_program->linkage_storage = CB_FIELD (yyvsp[0]);
	}
  }
#line 17132 "parser.c" /* yacc.c:1652  */
    break;

  case 812:
#line 7875 "parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_REPORT_SECTION;
	current_storage = CB_STORAGE_REPORT;
	description_field = NULL;
	current_program->flag_report = 1;
	cb_clear_real_field ();
  }
#line 17144 "parser.c" /* yacc.c:1652  */
    break;

  case 816:
#line 7893 "parser.y" /* yacc.c:1652  */
    {
	if (CB_INVALID_TREE (yyvsp[0])) {
		YYERROR;
	} else {
		current_field = NULL;
		control_field = NULL;
		description_field = NULL;
		current_report = CB_REPORT_PTR (yyvsp[0]);
	}
	check_duplicate = 0;
  }
#line 17160 "parser.c" /* yacc.c:1652  */
    break;

  case 817:
#line 7906 "parser.y" /* yacc.c:1652  */
    {
	yyval = get_finalized_description_tree ();

	current_program->report_storage = description_field;
	current_program->flag_report = 1;
	if (current_report->records == NULL) {
		current_report->records = description_field;
	}
	finalize_report (current_report, description_field);
  }
#line 17175 "parser.c" /* yacc.c:1652  */
    break;

  case 820:
#line 7921 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 17183 "parser.c" /* yacc.c:1652  */
    break;

  case 821:
#line 7928 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_1, &check_duplicate);
	current_report->global = 1;
	cb_error (_("GLOBAL is not allowed with RD"));
  }
#line 17193 "parser.c" /* yacc.c:1652  */
    break;

  case 822:
#line 7934 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CODE", SYN_CLAUSE_2, &check_duplicate);
	current_report->code_clause = yyvsp[0];
  }
#line 17202 "parser.c" /* yacc.c:1652  */
    break;

  case 825:
#line 7946 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONTROL", SYN_CLAUSE_3, &check_duplicate);
  }
#line 17210 "parser.c" /* yacc.c:1652  */
    break;

  case 829:
#line 7959 "parser.y" /* yacc.c:1652  */
    {
	current_report->control_final = 1;
  }
#line 17218 "parser.c" /* yacc.c:1652  */
    break;

  case 832:
#line 7971 "parser.y" /* yacc.c:1652  */
    {
	/* Add field to current control list */
	CB_ADD_TO_CHAIN (yyvsp[0], current_report->controls);
  }
#line 17227 "parser.c" /* yacc.c:1652  */
    break;

  case 833:
#line 7982 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PAGE", SYN_CLAUSE_4, &check_duplicate);
	if (!current_report->heading) {
		current_report->heading = 1;
	}
	if (!current_report->first_detail) {
		current_report->first_detail = current_report->heading;
	}
	if (!current_report->last_control) {
		if (current_report->last_detail) {
			current_report->last_control = current_report->last_detail;
		} else if (current_report->footing) {
			current_report->last_control = current_report->footing;
		} else {
			current_report->last_control = current_report->lines;
		}
		if (current_report->t_last_detail) {
			current_report->t_last_control = current_report->t_last_detail;
		} else if (current_report->t_footing) {
			current_report->t_last_control = current_report->t_footing;
		} else if(current_report->t_lines) {
			current_report->t_last_control = current_report->t_lines;
		}
	}
	if (!current_report->last_detail && !current_report->footing) {
		current_report->last_detail = current_report->lines;
		current_report->footing = current_report->lines;
	} else if (!current_report->last_detail) {
		current_report->last_detail = current_report->footing;
	} else if (!current_report->footing) {
		current_report->footing = current_report->last_detail;
	}
	/* PAGE LIMIT values checked in finalize_report in typeck.c */
  }
#line 17266 "parser.c" /* yacc.c:1652  */
    break;

  case 834:
#line 8020 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-1])) {
		current_report->lines = cb_get_int (yyvsp[-1]);
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = yyvsp[-1];
	}
  }
#line 17281 "parser.c" /* yacc.c:1652  */
    break;

  case 836:
#line 8032 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-2])) {
		current_report->lines = cb_get_int (yyvsp[-2]);
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = yyvsp[-2];
	}
  }
#line 17296 "parser.c" /* yacc.c:1652  */
    break;

  case 837:
#line 8046 "parser.y" /* yacc.c:1652  */
    {
	/* may be repeated later by page detail */
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P (yyvsp[-1])) {
		current_report->columns = cb_get_int (yyvsp[-1]);
	} else {
		current_report->t_columns = yyvsp[-1];
	}
  }
#line 17310 "parser.c" /* yacc.c:1652  */
    break;

  case 847:
#line 8074 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->columns = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_columns = yyvsp[0];
	}
  }
#line 17323 "parser.c" /* yacc.c:1652  */
    break;

  case 848:
#line 8086 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HEADING", SYN_CLAUSE_6, &check_duplicate);
	error_if_no_page_lines_limit ("HEADING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->heading = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_heading = yyvsp[0];
	}
  }
#line 17338 "parser.c" /* yacc.c:1652  */
    break;

  case 849:
#line 8100 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FIRST DETAIL", SYN_CLAUSE_7, &check_duplicate);
	error_if_no_page_lines_limit ("FIRST DETAIL");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->first_detail = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_first_detail = yyvsp[0];
	}
  }
#line 17353 "parser.c" /* yacc.c:1652  */
    break;

  case 850:
#line 8114 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LAST CONTROL HEADING", SYN_CLAUSE_8, &check_duplicate);
	error_if_no_page_lines_limit ("LAST CONTROL HEADING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->last_control = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_last_control = yyvsp[0];
	}
  }
#line 17368 "parser.c" /* yacc.c:1652  */
    break;

  case 851:
#line 8128 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LAST DETAIL", SYN_CLAUSE_9, &check_duplicate);
	error_if_no_page_lines_limit ("LAST DETAIL");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->last_detail = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_last_detail = yyvsp[0];
	}
  }
#line 17383 "parser.c" /* yacc.c:1652  */
    break;

  case 852:
#line 8142 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOOTING", SYN_CLAUSE_10, &check_duplicate);
	error_if_no_page_lines_limit ("FOOTING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->footing = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_footing = yyvsp[0];
	}
  }
#line 17398 "parser.c" /* yacc.c:1652  */
    break;

  case 855:
#line 8160 "parser.y" /* yacc.c:1652  */
    {
	if (set_current_field(yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 17411 "parser.c" /* yacc.c:1652  */
    break;

  case 857:
#line 8170 "parser.y" /* yacc.c:1652  */
    {
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
	cb_unput_dot ();
	yyerrok;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 17425 "parser.c" /* yacc.c:1652  */
    break;

  case 877:
#line 8207 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("TYPE IS", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 17433 "parser.c" /* yacc.c:1652  */
    break;

  case 878:
#line 8214 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_HEADING;
  }
#line 17441 "parser.c" /* yacc.c:1652  */
    break;

  case 879:
#line 8218 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_HEADING;
  }
#line 17449 "parser.c" /* yacc.c:1652  */
    break;

  case 882:
#line 8224 "parser.y" /* yacc.c:1652  */
    {
	if (current_report != NULL) {
		current_report->has_detail = 1;
	}
	current_field->report_flag |= COB_REPORT_DETAIL;
  }
#line 17460 "parser.c" /* yacc.c:1652  */
    break;

  case 883:
#line 8231 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_FOOTING;
  }
#line 17468 "parser.c" /* yacc.c:1652  */
    break;

  case 884:
#line 8235 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_FOOTING;
  }
#line 17476 "parser.c" /* yacc.c:1652  */
    break;

  case 885:
#line 8242 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
  }
#line 17484 "parser.c" /* yacc.c:1652  */
    break;

  case 886:
#line 8246 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
	current_field->report_control = yyvsp[-1];
	if (yyvsp[0]) {
		current_field->report_flag |= COB_REPORT_PAGE;
	}
  }
#line 17496 "parser.c" /* yacc.c:1652  */
    break;

  case 887:
#line 8254 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING_FINAL;
  }
#line 17504 "parser.c" /* yacc.c:1652  */
    break;

  case 888:
#line 8263 "parser.y" /* yacc.c:1652  */
    {yyval = NULL;}
#line 17510 "parser.c" /* yacc.c:1652  */
    break;

  case 889:
#line 8264 "parser.y" /* yacc.c:1652  */
    {yyval = cb_int0;}
#line 17516 "parser.c" /* yacc.c:1652  */
    break;

  case 890:
#line 8269 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
  }
#line 17524 "parser.c" /* yacc.c:1652  */
    break;

  case 891:
#line 8273 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_control = yyvsp[-1];
  }
#line 17533 "parser.c" /* yacc.c:1652  */
    break;

  case 892:
#line 8278 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING_FINAL;
  }
#line 17541 "parser.c" /* yacc.c:1652  */
    break;

  case 893:
#line 8282 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_flag |= COB_REPORT_ALL;
  }
#line 17550 "parser.c" /* yacc.c:1652  */
    break;

  case 894:
#line 8290 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NEXT GROUP", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 17558 "parser.c" /* yacc.c:1652  */
    break;

  case 895:
#line 8297 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P(yyvsp[0]) && CB_LITERAL (yyvsp[0])->sign > 0) {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	} else {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_LINE;
	}
	current_field->next_group_line = cb_get_int (yyvsp[0]);
  }
#line 17571 "parser.c" /* yacc.c:1652  */
    break;

  case 896:
#line 8306 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	current_field->next_group_line = cb_get_int(yyvsp[0]);
  }
#line 17580 "parser.c" /* yacc.c:1652  */
    break;

  case 897:
#line 8311 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PAGE;
  }
#line 17588 "parser.c" /* yacc.c:1652  */
    break;

  case 901:
#line 8324 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SUM", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->report_sum_list = yyvsp[-1];
	build_sum_counter (current_report, current_field);
  }
#line 17598 "parser.c" /* yacc.c:1652  */
    break;

  case 904:
#line 8334 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_sum_upon = yyvsp[0];
  }
#line 17606 "parser.c" /* yacc.c:1652  */
    break;

  case 905:
#line 8341 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_reset = yyvsp[0];
  }
#line 17614 "parser.c" /* yacc.c:1652  */
    break;

  case 906:
#line 8345 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_RESET_FINAL;
  }
#line 17622 "parser.c" /* yacc.c:1652  */
    break;

  case 907:
#line 8352 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_when = yyvsp[0];
  }
#line 17631 "parser.c" /* yacc.c:1652  */
    break;

  case 908:
#line 8357 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
  }
#line 17641 "parser.c" /* yacc.c:1652  */
    break;

  case 909:
#line 8363 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17652 "parser.c" /* yacc.c:1652  */
    break;

  case 910:
#line 8370 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
  }
#line 17662 "parser.c" /* yacc.c:1652  */
    break;

  case 911:
#line 8376 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17673 "parser.c" /* yacc.c:1652  */
    break;

  case 912:
#line 8386 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
  }
#line 17681 "parser.c" /* yacc.c:1652  */
    break;

  case 913:
#line 8390 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_NEGATE;
  }
#line 17690 "parser.c" /* yacc.c:1652  */
    break;

  case 916:
#line 8403 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17698 "parser.c" /* yacc.c:1652  */
    break;

  case 917:
#line 8407 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_control = yyvsp[0];
  }
#line 17706 "parser.c" /* yacc.c:1652  */
    break;

  case 919:
#line 8415 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RW VARYING clause");
  }
#line 17714 "parser.c" /* yacc.c:1652  */
    break;

  case 920:
#line 8422 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_LINE;
  }
#line 17723 "parser.c" /* yacc.c:1652  */
    break;

  case 925:
#line 8440 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_LINE_NEXT_PAGE;
  }
#line 17731 "parser.c" /* yacc.c:1652  */
    break;

  case 926:
#line 8444 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_line = cb_get_int (yyvsp[0]);
	if (yyvsp[-1]) {
		current_field->report_flag |= COB_REPORT_LINE_PLUS;
		if (current_field->report_line == 0) {
			CB_PENDING ("LINE PLUS 0");
		}
	}
  }
#line 17745 "parser.c" /* yacc.c:1652  */
    break;

  case 927:
#line 8458 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_18, &check_pic_duplicate);
	if ((current_field->report_flag & (COB_REPORT_COLUMN_LEFT|COB_REPORT_COLUMN_RIGHT|COB_REPORT_COLUMN_CENTER))
	 && (current_field->report_flag & COB_REPORT_COLUMN_PLUS)) {
		if (cb_relaxed_syntax_checks) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is not recommended with LEFT, RIGHT or CENTER"));
		} else {
			cb_error (_("PLUS is not allowed with LEFT, RIGHT or CENTER"));
		}
	}
  }
#line 17761 "parser.c" /* yacc.c:1652  */
    break;

  case 931:
#line 8482 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_LEFT;
  }
#line 17769 "parser.c" /* yacc.c:1652  */
    break;

  case 932:
#line 8486 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_RIGHT;
  }
#line 17777 "parser.c" /* yacc.c:1652  */
    break;

  case 933:
#line 8490 "parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_CENTER;
  }
#line 17785 "parser.c" /* yacc.c:1652  */
    break;

  case 934:
#line 8497 "parser.y" /* yacc.c:1652  */
    {
	int colnum = cb_get_int (yyvsp[0]);
	if (colnum != 0) {
		if (current_field->parent
		 && current_field->parent->children == current_field) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is ignored on first field of line"));
			if (current_field->step_count == 0) {
				current_field->step_count = colnum;
			}
		} else {
			current_field->report_flag |= COB_REPORT_COLUMN_PLUS;
		}
	} else {
		colnum = 0;
	}
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17810 "parser.c" /* yacc.c:1652  */
    break;

  case 938:
#line 8527 "parser.y" /* yacc.c:1652  */
    {
	int colnum;
	colnum = cb_get_int (yyvsp[0]);
	if (colnum < 0) {
		/* already handled by integer check */
	} else if (colnum == 0) {
		cb_error (_("invalid COLUMN integer; must be > 0"));
	} else if (colnum <= current_field->report_column) {
		cb_warning (COBC_WARN_FILLER, _("COLUMN numbers should increase"));
	}
	current_field->report_column_list =
			cb_list_append (current_field->report_column_list, CB_LIST_INIT (yyvsp[0]));
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17832 "parser.c" /* yacc.c:1652  */
    break;

  case 939:
#line 8548 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SOURCE", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->report_source = yyvsp[-1];
  }
#line 17841 "parser.c" /* yacc.c:1652  */
    break;

  case 940:
#line 8556 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GROUP", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_GROUP_INDICATE;
  }
#line 17850 "parser.c" /* yacc.c:1652  */
    break;

  case 942:
#line 8566 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = CB_CS_SCREEN;
	current_storage = CB_STORAGE_SCREEN;
	current_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 17862 "parser.c" /* yacc.c:1652  */
    break;

  case 943:
#line 8574 "parser.y" /* yacc.c:1652  */
    {
	if (description_field) {
		get_finalized_description_tree ();
		current_program->screen_storage = description_field;
		current_program->flag_screen = 1;
	}
	cobc_cs_check = 0;
  }
#line 17875 "parser.c" /* yacc.c:1652  */
    break;

  case 949:
#line 8597 "parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17890 "parser.c" /* yacc.c:1652  */
    break;

  case 950:
#line 8608 "parser.y" /* yacc.c:1652  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
  }
#line 17932 "parser.c" /* yacc.c:1652  */
    break;

  case 951:
#line 8647 "parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}

	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17948 "parser.c" /* yacc.c:1652  */
    break;

  case 952:
#line 8659 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 17956 "parser.c" /* yacc.c:1652  */
    break;

  case 953:
#line 8664 "parser.y" /* yacc.c:1652  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
	cobc_cs_check = CB_CS_SCREEN;
  }
#line 17999 "parser.c" /* yacc.c:1652  */
    break;

  case 954:
#line 8704 "parser.y" /* yacc.c:1652  */
    {
	/*
	  Tree associated with level number has already been freed; we don't
	  need to do anything here.
	*/
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if	1	/* RXWRXW Screen field */
	if (current_field) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	}
#endif
	current_field = cb_get_real_field ();
  }
#line 18021 "parser.c" /* yacc.c:1652  */
    break;

  case 957:
#line 8730 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				       "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 18030 "parser.c" /* yacc.c:1652  */
    break;

  case 958:
#line 8735 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				       "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 18039 "parser.c" /* yacc.c:1652  */
    break;

  case 959:
#line 8740 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("BELL", COB_SCREEN_BELL);
  }
#line 18047 "parser.c" /* yacc.c:1652  */
    break;

  case 960:
#line 8744 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("BLINK", COB_SCREEN_BLINK);
  }
#line 18055 "parser.c" /* yacc.c:1652  */
    break;

  case 961:
#line 8748 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				       "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 18064 "parser.c" /* yacc.c:1652  */
    break;

  case 962:
#line 8753 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				       "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 18073 "parser.c" /* yacc.c:1652  */
    break;

  case 963:
#line 8758 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				       "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 18082 "parser.c" /* yacc.c:1652  */
    break;

  case 964:
#line 8763 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 18091 "parser.c" /* yacc.c:1652  */
    break;

  case 965:
#line 8768 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
#if 0 /* in general we could simply remove high/low, but for syntax checks
	we still need a flag */
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
#endif
  }
#line 18104 "parser.c" /* yacc.c:1652  */
    break;

  case 966:
#line 8777 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18112 "parser.c" /* yacc.c:1652  */
    break;

  case 967:
#line 8781 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18120 "parser.c" /* yacc.c:1652  */
    break;

  case 968:
#line 8785 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18128 "parser.c" /* yacc.c:1652  */
    break;

  case 969:
#line 8789 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("REVERSE-VIDEO", COB_SCREEN_REVERSE);
  }
#line 18136 "parser.c" /* yacc.c:1652  */
    break;

  case 970:
#line 8793 "parser.y" /* yacc.c:1652  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int (yyvsp[0]);
  }
#line 18146 "parser.c" /* yacc.c:1652  */
    break;

  case 971:
#line 8799 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("screen positions from data-item"));
  }
#line 18154 "parser.c" /* yacc.c:1652  */
    break;

  case 972:
#line 8803 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("screen positions from data-item"));
	CB_PENDING ("SIZE clause");
  }
#line 18163 "parser.c" /* yacc.c:1652  */
    break;

  case 973:
#line 8808 "parser.y" /* yacc.c:1652  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int (yyvsp[0]);
  }
#line 18173 "parser.c" /* yacc.c:1652  */
    break;

  case 974:
#line 8814 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("UNDERLINE", COB_SCREEN_UNDERLINE);
  }
#line 18181 "parser.c" /* yacc.c:1652  */
    break;

  case 975:
#line 8818 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("OVERLINE", COB_SCREEN_OVERLINE);
	CB_PENDING ("OVERLINE");
  }
#line 18190 "parser.c" /* yacc.c:1652  */
    break;

  case 976:
#line 8823 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("GRID", COB_SCREEN_GRID);
	CB_PENDING ("GRID");
  }
#line 18199 "parser.c" /* yacc.c:1652  */
    break;

  case 977:
#line 8828 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("LEFTLINE", COB_SCREEN_LEFTLINE);
	CB_PENDING ("LEFTLINE");
  }
#line 18208 "parser.c" /* yacc.c:1652  */
    break;

  case 978:
#line 8833 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				       "TAB", COB_SCREEN_TAB);
  }
#line 18217 "parser.c" /* yacc.c:1652  */
    break;

  case 979:
#line 8838 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("TAB", COB_SCREEN_TAB,
				       "AUTO", COB_SCREEN_AUTO);
  }
#line 18226 "parser.c" /* yacc.c:1652  */
    break;

  case 980:
#line 8843 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				       "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 18235 "parser.c" /* yacc.c:1652  */
    break;

  case 981:
#line 8848 "parser.y" /* yacc.c:1652  */
    {
	if (cb_no_echo_means_secure) {
		set_screen_attr ("SECURE", COB_SCREEN_SECURE);
	} else {
		set_screen_attr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					       "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 18248 "parser.c" /* yacc.c:1652  */
    break;

  case 982:
#line 8857 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("REQUIRED", COB_SCREEN_REQUIRED);
  }
#line 18256 "parser.c" /* yacc.c:1652  */
    break;

  case 983:
#line 8861 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("FULL", COB_SCREEN_FULL);
  }
#line 18264 "parser.c" /* yacc.c:1652  */
    break;

  case 984:
#line 8865 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: ACUCOBOL and (undocumented) MF have CHARACTER as optional here */
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
	current_field->screen_prompt = yyvsp[0];
  }
#line 18274 "parser.c" /* yacc.c:1652  */
    break;

  case 985:
#line 8871 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
  }
#line 18282 "parser.c" /* yacc.c:1652  */
    break;

  case 986:
#line 8875 "parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("INITIAL", COB_SCREEN_INITIAL);
  }
#line 18290 "parser.c" /* yacc.c:1652  */
    break;

  case 987:
#line 8879 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 18298 "parser.c" /* yacc.c:1652  */
    break;

  case 988:
#line 8883 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("LINES clause");	/* note: should only occur with controls */
  }
#line 18306 "parser.c" /* yacc.c:1652  */
    break;

  case 989:
#line 8887 "parser.y" /* yacc.c:1652  */
    {
	/*check_repeated ("CLINE", SYN_CLAUSE_5000, &check_pic_duplicate);*/
  }
#line 18314 "parser.c" /* yacc.c:1652  */
    break;

  case 990:
#line 8891 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 18322 "parser.c" /* yacc.c:1652  */
    break;

  case 991:
#line 8895 "parser.y" /* yacc.c:1652  */
    {
	/*check_repeated ("CCOL", SYN_CLAUSE_5001, &check_pic_duplicate);*/
  }
#line 18330 "parser.c" /* yacc.c:1652  */
    break;

  case 992:
#line 8899 "parser.y" /* yacc.c:1652  */
    {
#if 0 /* TODO: implement, and add reverse to BACKGROUND/FOREGROUND-COLOR */
	check_repeated ("COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "BACKGROUND-COLOR", COB_SCREEN_BACKGROUND_COLOR);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "FOREGROUND-COLOR", FOREGROUND_COLOR);
#endif
	CB_PENDING ("COLOR clause");
  }
#line 18345 "parser.c" /* yacc.c:1652  */
    break;

  case 993:
#line 8910 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_18, &check_pic_duplicate);
	current_field->screen_foreg = yyvsp[0];
  }
#line 18354 "parser.c" /* yacc.c:1652  */
    break;

  case 994:
#line 8915 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->screen_backg = yyvsp[0];
  }
#line 18363 "parser.c" /* yacc.c:1652  */
    break;

  case 1003:
#line 8931 "parser.y" /* yacc.c:1652  */
    {
	yyval = check_not_88_level (yyvsp[0]);

	check_repeated ("USING", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->screen_from = yyval;
	current_field->screen_to = yyval;
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18376 "parser.c" /* yacc.c:1652  */
    break;

  case 1004:
#line 8940 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FROM", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->screen_from = yyvsp[0];
  }
#line 18385 "parser.c" /* yacc.c:1652  */
    break;

  case 1005:
#line 8945 "parser.y" /* yacc.c:1652  */
    {
	yyval = check_not_88_level (yyvsp[0]);

	check_repeated ("TO", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->screen_to = yyval;
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18397 "parser.c" /* yacc.c:1652  */
    break;

  case 1007:
#line 8957 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check |= CB_CS_GRAPHICAL_CONTROL;
  }
#line 18405 "parser.c" /* yacc.c:1652  */
    break;

  case 1307:
#line 9546 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 18411 "parser.c" /* yacc.c:1652  */
    break;

  case 1308:
#line 9547 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 18417 "parser.c" /* yacc.c:1652  */
    break;

  case 1309:
#line 9551 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 18423 "parser.c" /* yacc.c:1652  */
    break;

  case 1312:
#line 9559 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 18429 "parser.c" /* yacc.c:1652  */
    break;

  case 1316:
#line 9571 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 18435 "parser.c" /* yacc.c:1652  */
    break;

  case 1317:
#line 9572 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 18441 "parser.c" /* yacc.c:1652  */
    break;

  case 1318:
#line 9576 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 18447 "parser.c" /* yacc.c:1652  */
    break;

  case 1319:
#line 9577 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 18453 "parser.c" /* yacc.c:1652  */
    break;

  case 1320:
#line 9582 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_field->screen_line = yyvsp[0];
	}
  }
#line 18463 "parser.c" /* yacc.c:1652  */
    break;

  case 1322:
#line 9592 "parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_PLUS;
  }
#line 18471 "parser.c" /* yacc.c:1652  */
    break;

  case 1323:
#line 9596 "parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_MINUS;
  }
#line 18479 "parser.c" /* yacc.c:1652  */
    break;

  case 1324:
#line 9603 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_field->screen_column = yyvsp[0];
	}
  }
#line 18489 "parser.c" /* yacc.c:1652  */
    break;

  case 1325:
#line 9612 "parser.y" /* yacc.c:1652  */
    {
	/* Nothing */
  }
#line 18497 "parser.c" /* yacc.c:1652  */
    break;

  case 1326:
#line 9616 "parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_PLUS;
  }
#line 18505 "parser.c" /* yacc.c:1652  */
    break;

  case 1327:
#line 9620 "parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_MINUS;
  }
#line 18513 "parser.c" /* yacc.c:1652  */
    break;

  case 1328:
#line 9627 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("OCCURS screen items"));
	check_repeated ("OCCURS", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->occurs_max = cb_get_int (yyvsp[-1]);
	current_field->occurs_min = current_field->occurs_max;
	current_field->indexes++;
	current_field->flag_occurs = 1;
  }
#line 18526 "parser.c" /* yacc.c:1652  */
    break;

  case 1329:
#line 9639 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("GLOBAL screen items"));
  }
#line 18534 "parser.c" /* yacc.c:1652  */
    break;

  case 1330:
#line 9648 "parser.y" /* yacc.c:1652  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 18548 "parser.c" /* yacc.c:1652  */
    break;

  case 1332:
#line 9662 "parser.y" /* yacc.c:1652  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	cobc_in_procedure = 1U;
	cb_set_system_names ();
	backup_current_pos ();
  }
#line 18562 "parser.c" /* yacc.c:1652  */
    break;

  case 1333:
#line 9672 "parser.y" /* yacc.c:1652  */
    {
	cb_tree call_conv = yyvsp[-4];
	if (yyvsp[-3]) {
		call_conv = yyvsp[-3];
		if (yyvsp[-4]) {
			/* note: $4 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x (yyvsp[-3], _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if (call_conv) {
		if (current_program->entry_convention) {
			cb_warning (COBC_WARN_FILLER,
				_("overriding convention specified in ENTRY-CONVENTION"));
		}
		current_program->entry_convention = call_conv;
	} else if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	header_check |= COBC_HD_PROCEDURE_DIVISION;
  }
#line 18588 "parser.c" /* yacc.c:1652  */
    break;

  case 1334:
#line 9694 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_main
	 && !current_program->flag_chained && yyvsp[-4]) {
		cb_error (_("executable program requested but PROCEDURE/ENTRY has USING clause"));
	}
	/* Main entry point */
	emit_entry (current_program->program_id, 0, yyvsp[-4], NULL);
	current_program->num_proc_params = cb_list_length (yyvsp[-4]);
	if (current_program->source_name) {
		emit_entry (current_program->source_name, 1, yyvsp[-4], NULL);
	}
  }
#line 18605 "parser.c" /* yacc.c:1652  */
    break;

  case 1335:
#line 9707 "parser.y" /* yacc.c:1652  */
    {
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
  }
#line 18624 "parser.c" /* yacc.c:1652  */
    break;

  case 1336:
#line 9722 "parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	/* No PROCEDURE DIVISION header here */
	/* Only a statement is allowed as first element */
	/* Thereafter, sections/paragraphs may be used */
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	cobc_in_procedure = 1U;
	label = cb_build_reference ("MAIN SECTION");
	current_section = CB_LABEL (cb_build_label (label, NULL));
	current_section->flag_section = 1;
	current_section->flag_dummy_section = 1;
	current_section->flag_skip_label = !!skip_statements;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->xref.skip = 1;
	emit_statement (CB_TREE (current_section));
	label = cb_build_reference ("MAIN PARAGRAPH");
	current_paragraph = CB_LABEL (cb_build_label (label, NULL));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_dummy_paragraph = 1;
	current_paragraph->xref.skip = 1;
	emit_statement (CB_TREE (current_paragraph));
	cb_set_system_names ();
  }
#line 18658 "parser.c" /* yacc.c:1652  */
    break;

  case 1338:
#line 9756 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 18666 "parser.c" /* yacc.c:1652  */
    break;

  case 1339:
#line 9760 "parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 18675 "parser.c" /* yacc.c:1652  */
    break;

  case 1340:
#line 9765 "parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 18687 "parser.c" /* yacc.c:1652  */
    break;

  case 1341:
#line 9773 "parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("CHAINING invalid in user FUNCTION"));
	} else {
		current_program->flag_chained = 1;
	}
  }
#line 18700 "parser.c" /* yacc.c:1652  */
    break;

  case 1342:
#line 9782 "parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 18712 "parser.c" /* yacc.c:1652  */
    break;

  case 1343:
#line 9792 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 18718 "parser.c" /* yacc.c:1652  */
    break;

  case 1344:
#line 9794 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 18724 "parser.c" /* yacc.c:1652  */
    break;

  case 1345:
#line 9799 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;
	struct cb_field	*f;

	x = cb_build_identifier (yyvsp[-1], 0);
	if (yyvsp[-2] == cb_int1 && CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
		f = CB_FIELD (cb_ref (x));
		f->flag_is_pdiv_opt = 1;
	}

	if (call_mode == CB_CALL_BY_VALUE
	 && CB_REFERENCE_P (yyvsp[-1])
	 && CB_FIELD (cb_ref (yyvsp[-1]))->flag_any_length) {
		cb_error_x (yyvsp[-1], _("ANY LENGTH items may only be BY REFERENCE formal parameters"));
	}

	yyval = CB_BUILD_PAIR (cb_int (call_mode), x);
	CB_SIZES (yyval) = size_mode;
  }
#line 18748 "parser.c" /* yacc.c:1652  */
    break;

  case 1347:
#line 9823 "parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 18756 "parser.c" /* yacc.c:1652  */
    break;

  case 1348:
#line 9827 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error (_("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		CB_UNFINISHED (_("parameters passed BY VALUE"));
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 18769 "parser.c" /* yacc.c:1652  */
    break;

  case 1350:
#line 9840 "parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO;
	}
  }
#line 18781 "parser.c" /* yacc.c:1652  */
    break;

  case 1351:
#line 9848 "parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_4;
	}
  }
#line 18793 "parser.c" /* yacc.c:1652  */
    break;

  case 1352:
#line 9856 "parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO | CB_SIZE_UNSIGNED;
	}
  }
#line 18805 "parser.c" /* yacc.c:1652  */
    break;

  case 1353:
#line 9864 "parser.y" /* yacc.c:1652  */
    {
	if (size_mode) {
		size_mode |= CB_SIZE_UNSIGNED;
	}
  }
#line 18815 "parser.c" /* yacc.c:1652  */
    break;

  case 1355:
#line 9874 "parser.y" /* yacc.c:1652  */
    {
	unsigned char *s = CB_LITERAL (yyvsp[0])->data;
	size_mode = 0;

	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else if (CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error_x (yyvsp[0], _("invalid value for SIZE"));
	} else {
		size_mode = 0;
		switch (*s) {
		case '1':
			size_mode = CB_SIZE_1;
			break;
		case '2':
			size_mode = CB_SIZE_2;
			break;
		case '4':
			size_mode = CB_SIZE_4;
			break;
		case '8':
			size_mode = CB_SIZE_8;
			break;
		default:
			cb_error_x (yyvsp[0], _("invalid value for SIZE"));
			break;
		}
	}
  }
#line 18849 "parser.c" /* yacc.c:1652  */
    break;

  case 1357:
#line 9912 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-1], _("MEMORY SIZE phrase in CALL statement"));
  }
#line 18857 "parser.c" /* yacc.c:1652  */
    break;

  case 1358:
#line 9919 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 18865 "parser.c" /* yacc.c:1652  */
    break;

  case 1359:
#line 9923 "parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error (_("OPTIONAL only allowed for BY REFERENCE items"));
		yyval = cb_int0;
	} else {
		yyval = cb_int1;
	}
  }
#line 18878 "parser.c" /* yacc.c:1652  */
    break;

  case 1360:
#line 9935 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause is required for a FUNCTION"));
	}
  }
#line 18888 "parser.c" /* yacc.c:1652  */
    break;

  case 1361:
#line 9941 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_main) {
		cb_error (_("RETURNING clause cannot be OMITTED for main program"));
	}
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause cannot be OMITTED for a FUNCTION"));
	}
	current_program->flag_void = 1;
  }
#line 18902 "parser.c" /* yacc.c:1652  */
    break;

  case 1362:
#line 9951 "parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		/* standard rule: returning item is allocated in the
		   activating runtime element */
		if (f->storage != CB_STORAGE_LINKAGE) {
			cb_error (_("RETURNING item is not defined in LINKAGE SECTION"));
		} else if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01"));
		} else if (f->flag_occurs) {
			cb_error (_("RETURNING item should not have OCCURS"));
		} else {
			if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
				if (f->flag_any_length) {
					cb_error (_("function RETURNING item may not be ANY LENGTH"));
				}
				f->flag_is_returning = 1;
			}
#if 0	/* doesn't work for programs, will be fixed with allocating in the source-unit */
			current_program->returning = yyvsp[0];
#else
			if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
				current_program->returning = yyvsp[0];
			} else {
				CB_PENDING ("program RETURNING");
			}
#endif
		}
	}
  }
#line 18939 "parser.c" /* yacc.c:1652  */
    break;

  case 1364:
#line 9987 "parser.y" /* yacc.c:1652  */
    {
	in_declaratives = 1;
	emit_statement (cb_build_comment ("DECLARATIVES"));
  }
#line 18948 "parser.c" /* yacc.c:1652  */
    break;

  case 1365:
#line 9993 "parser.y" /* yacc.c:1652  */
    {
	if (needs_field_debug) {
		start_debug = 1;
	}
	in_declaratives = 0;
	in_debugging = 0;
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		current_paragraph = NULL;
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		current_section->flag_fatal_check = 1;
		emit_statement (cb_build_perform_exit (current_section));
		current_section = NULL;
	}
	skip_statements = 0;
	emit_statement (cb_build_comment ("END DECLARATIVES"));
	check_unreached = 0;
  }
#line 18978 "parser.c" /* yacc.c:1652  */
    break;

  case 1370:
#line 10031 "parser.y" /* yacc.c:1652  */
    {
	if (next_label_list) {
		cb_tree	plabel;
		char	name[32];

		snprintf (name, sizeof(name), "L$%d", next_label_id);
		plabel = cb_build_label (cb_build_reference (name), NULL);
		CB_LABEL (plabel)->flag_next_sentence = 1;
		emit_statement (plabel);
		current_program->label_list =
			cb_list_append (current_program->label_list, next_label_list);
		next_label_list = NULL;
		next_label_id++;
	}
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 19000 "parser.c" /* yacc.c:1652  */
    break;

  case 1372:
#line 10050 "parser.y" /* yacc.c:1652  */
    {
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 19009 "parser.c" /* yacc.c:1652  */
    break;

  case 1373:
#line 10061 "parser.y" /* yacc.c:1652  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[-1], 0) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph/section */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
	if (current_program->flag_debugging && !in_debugging) {
		if (current_paragraph || current_section) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new section */
	current_section = CB_LABEL (cb_build_label (yyvsp[-1], NULL));
	current_section->flag_section = 1;
	/* Careful here, one negation */
	current_section->flag_real_label = !in_debugging;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->flag_skip_label = !!skip_statements;
	current_paragraph = NULL;
  }
#line 19052 "parser.c" /* yacc.c:1652  */
    break;

  case 1374:
#line 10101 "parser.y" /* yacc.c:1652  */
    {
	emit_statement (CB_TREE (current_section));
  }
#line 19060 "parser.c" /* yacc.c:1652  */
    break;

  case 1377:
#line 10112 "parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[-1], 1) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		if (current_program->flag_debugging && !in_debugging) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new paragraph */
	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->flag_skip_label = !!skip_statements;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	current_paragraph = CB_LABEL (cb_build_label (yyvsp[-1], current_section));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_real_label = !in_debugging;
	current_paragraph->segment = current_section->segment;
	emit_statement (CB_TREE (current_paragraph));
  }
#line 19106 "parser.c" /* yacc.c:1652  */
    break;

  case 1378:
#line 10157 "parser.y" /* yacc.c:1652  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[0], 0) != cb_error_node) {
		if (is_reserved_word (CB_NAME (yyvsp[0]))) {
			cb_error_x (yyvsp[0], _("'%s' is not a statement"), CB_NAME (yyvsp[0]));
		} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
			cb_error_x (yyvsp[0], _("unknown statement '%s'; it may exist in another dialect"),
				    CB_NAME (yyvsp[0]));
		} else {
			cb_error_x (yyvsp[0], _("unknown statement '%s'"), CB_NAME (yyvsp[0]));
		}
	}
	YYERROR;
  }
#line 19126 "parser.c" /* yacc.c:1652  */
    break;

  case 1379:
#line 10176 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 19134 "parser.c" /* yacc.c:1652  */
    break;

  case 1380:
#line 10180 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
	if (cb_verify (cb_section_segments, _("section segments"))) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum > 99) {
			cb_error (_("SECTION segment-number must be less than or equal to 99"));
		} else {
			if (in_declaratives && segnum > 49) {
				cb_error (_("SECTION segment-number in DECLARATIVES must be less than 50"));
			}
			if (!in_declaratives) {
				current_program->flag_segments = 1;
				current_section->segment = segnum;
			} else {
				/* Simon: old version did not allow segments in declaratives at all
					ToDo: check codegen for possible missing parts */
				CB_PENDING (_("SECTION segment within DECLARATIVES"));
			}
		}
	}
  }
#line 19160 "parser.c" /* yacc.c:1652  */
    break;

  case 1381:
#line 10208 "parser.y" /* yacc.c:1652  */
    {
	yyval = current_program->exec_list;
	current_program->exec_list = NULL;
	check_unreached = 0;
  }
#line 19170 "parser.c" /* yacc.c:1652  */
    break;

  case 1382:
#line 10213 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_TREE (current_statement);
	current_statement = NULL;
  }
#line 19179 "parser.c" /* yacc.c:1652  */
    break;

  case 1383:
#line 10218 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_reverse (current_program->exec_list);
	current_program->exec_list = yyvsp[-2];
	current_statement = CB_STATEMENT (yyvsp[-1]);
  }
#line 19189 "parser.c" /* yacc.c:1652  */
    break;

  case 1384:
#line 10226 "parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_skip_label = !!skip_statements;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	if (!current_paragraph) {
		label = cb_build_reference ("MAIN PARAGRAPH");
		current_paragraph = CB_LABEL (cb_build_label (label, NULL));
		CB_TREE (current_paragraph)->source_file
			= CB_TREE (current_section)->source_file;
		CB_TREE (current_paragraph)->source_line
			= CB_TREE (current_section)->source_line;
		current_paragraph->flag_declaratives = !!in_declaratives;
		current_paragraph->flag_skip_label = !!skip_statements;
		current_paragraph->flag_dummy_paragraph = 1;
		current_paragraph->xref.skip = 1;
		emit_statement (CB_TREE (current_paragraph));
	}
	if (check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0) == 1) {
		if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM) {
			backup_current_pos ();
			emit_entry (current_program->program_id, 0, NULL, NULL);
		}
	}

	cobc_apply_turn_directives ();
  }
#line 19229 "parser.c" /* yacc.c:1652  */
    break;

  case 1385:
#line 10262 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_apply_turn_directives ();
  }
#line 19238 "parser.c" /* yacc.c:1652  */
    break;

  case 1386:
#line 10267 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_apply_turn_directives ();
  }
#line 19247 "parser.c" /* yacc.c:1652  */
    break;

  case 1451:
#line 10342 "parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_next_sentence_phrase, "NEXT SENTENCE")) {
		cb_tree label;
		char	name[32];

		begin_statement ("NEXT SENTENCE", 0);
		sprintf (name, "L$%d", next_label_id);
		label = cb_build_reference (name);
		next_label_list = cb_list_add (next_label_list, label);
		emit_statement (cb_build_goto (label, NULL));
	}
	check_unreached = 0;
  }
#line 19265 "parser.c" /* yacc.c:1652  */
    break;

  case 1452:
#line 10356 "parser.y" /* yacc.c:1652  */
    {
	yyerrok;
	cobc_cs_check = 0;
  }
#line 19274 "parser.c" /* yacc.c:1652  */
    break;

  case 1453:
#line 10367 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ACCEPT", TERM_ACCEPT);
	cobc_cs_check = CB_CS_ACCEPT;
  }
#line 19283 "parser.c" /* yacc.c:1652  */
    break;

  case 1455:
#line 10377 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19293 "parser.c" /* yacc.c:1652  */
    break;

  case 1456:
#line 10383 "parser.y" /* yacc.c:1652  */
    {
	/* Check for invalid use of screen clauses */
	if (current_statement->attr_ptr
	 || (!is_screen_field (yyvsp[-3]) && line_column)) {
		cb_verify_x (yyvsp[-3], cb_accept_display_extensions,
			     _("non-standard ACCEPT"));
	}

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	if (yyvsp[-3] == cb_null && current_statement->attr_ptr) {
		if (current_statement->attr_ptr->prompt) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("PROMPT clause"));
		}
		if (current_statement->attr_ptr->size_is) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("SIZE IS clause"));
		}
	}
	cobc_cs_check = 0;
	cb_emit_accept (yyvsp[-3], line_column, current_statement->attr_ptr);
  }
#line 19325 "parser.c" /* yacc.c:1652  */
    break;

  case 1457:
#line 10411 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19335 "parser.c" /* yacc.c:1652  */
    break;

  case 1458:
#line 10417 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	CB_PENDING ("ACCEPT FROM SCREEN");
  }
#line 19344 "parser.c" /* yacc.c:1652  */
    break;

  case 1459:
#line 10422 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_line_or_col (yyvsp[-2], 0);
  }
#line 19352 "parser.c" /* yacc.c:1652  */
    break;

  case 1460:
#line 10426 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_line_or_col (yyvsp[-2], 1);
  }
#line 19360 "parser.c" /* yacc.c:1652  */
    break;

  case 1461:
#line 10430 "parser.y" /* yacc.c:1652  */
    {
	/* information about terminal and its capabilities
	cb_emit_accept_terminal_info ($1); */
	CB_PENDING ("ACCEPT FROM TERMINAL INFO");
  }
#line 19370 "parser.c" /* yacc.c:1652  */
    break;

  case 1462:
#line 10436 "parser.y" /* yacc.c:1652  */
    {
	/* information about OS and runtime features
	cb_emit_accept_system_info ($1); */
	CB_PENDING ("ACCEPT FROM SYSTEM INFO");
  }
#line 19380 "parser.c" /* yacc.c:1652  */
    break;

  case 1463:
#line 10442 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date_yyyymmdd (yyvsp[-3]);
  }
#line 19389 "parser.c" /* yacc.c:1652  */
    break;

  case 1464:
#line 10447 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date (yyvsp[-2]);
  }
#line 19398 "parser.c" /* yacc.c:1652  */
    break;

  case 1465:
#line 10452 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day_yyyyddd (yyvsp[-3]);
  }
#line 19407 "parser.c" /* yacc.c:1652  */
    break;

  case 1466:
#line 10457 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day (yyvsp[-2]);
  }
#line 19416 "parser.c" /* yacc.c:1652  */
    break;

  case 1467:
#line 10462 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_day_of_week (yyvsp[-2]);
  }
#line 19424 "parser.c" /* yacc.c:1652  */
    break;

  case 1468:
#line 10468 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_escape_key (yyvsp[-3]);
  }
#line 19432 "parser.c" /* yacc.c:1652  */
    break;

  case 1469:
#line 10474 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_exception_status (yyvsp[-3]);
  }
#line 19440 "parser.c" /* yacc.c:1652  */
    break;

  case 1470:
#line 10478 "parser.y" /* yacc.c:1652  */
    {
	/* check is data from keyboard available? "1", else "0"
	cb_emit_accept_input_status ($1); */
	CB_PENDING ("ACCEPT FROM INPUT STATUS");
  }
#line 19450 "parser.c" /* yacc.c:1652  */
    break;

  case 1471:
#line 10484 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_time (yyvsp[-2]);
  }
#line 19458 "parser.c" /* yacc.c:1652  */
    break;

  case 1472:
#line 10488 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_user_name (yyvsp[-3]);
  }
#line 19467 "parser.c" /* yacc.c:1652  */
    break;

  case 1473:
#line 10493 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_command_line (yyvsp[-2]);
  }
#line 19475 "parser.c" /* yacc.c:1652  */
    break;

  case 1474:
#line 10497 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_environment (yyvsp[-3]);
  }
#line 19483 "parser.c" /* yacc.c:1652  */
    break;

  case 1475:
#line 10501 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_get_environment (yyvsp[-1], yyvsp[-4]);
  }
#line 19491 "parser.c" /* yacc.c:1652  */
    break;

  case 1476:
#line 10505 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_arg_number (yyvsp[-2]);
  }
#line 19499 "parser.c" /* yacc.c:1652  */
    break;

  case 1477:
#line 10509 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_arg_value (yyvsp[-3]);
  }
#line 19507 "parser.c" /* yacc.c:1652  */
    break;

  case 1478:
#line 10513 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_mnemonic (yyvsp[-2], yyvsp[0]);
  }
#line 19515 "parser.c" /* yacc.c:1652  */
    break;

  case 1479:
#line 10517 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_name (yyvsp[-2], yyvsp[0]);
  }
#line 19523 "parser.c" /* yacc.c:1652  */
    break;

  case 1480:
#line 10521 "parser.y" /* yacc.c:1652  */
    {
	cb_verify_x (yyvsp[-1], cb_accept_display_extensions,
		     _("non-standard ACCEPT"));

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	cobc_cs_check = 0;
	cb_emit_accept (yyvsp[-1], line_column, current_statement->attr_ptr);
  }
#line 19541 "parser.c" /* yacc.c:1652  */
    break;

  case 1481:
#line 10535 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ACCEPT MESSAGE COUNT");
  }
#line 19549 "parser.c" /* yacc.c:1652  */
    break;

  case 1483:
#line 10543 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 19557 "parser.c" /* yacc.c:1652  */
    break;

  case 1484:
#line 10549 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19567 "parser.c" /* yacc.c:1652  */
    break;

  case 1485:
#line 10555 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 19575 "parser.c" /* yacc.c:1652  */
    break;

  case 1488:
#line 10566 "parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (yyvsp[-3], yyvsp[-1]);
  }
#line 19583 "parser.c" /* yacc.c:1652  */
    break;

  case 1489:
#line 10570 "parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (yyvsp[-2], cb_int0);
  }
#line 19591 "parser.c" /* yacc.c:1652  */
    break;

  case 1490:
#line 10574 "parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (cb_int0, yyvsp[-1]);
  }
#line 19599 "parser.c" /* yacc.c:1652  */
    break;

  case 1491:
#line 10581 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 19607 "parser.c" /* yacc.c:1652  */
    break;

  case 1492:
#line 10585 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_binary_op (yyvsp[-2], '+', yyvsp[0]);
  }
#line 19615 "parser.c" /* yacc.c:1652  */
    break;

  case 1493:
#line 10589 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_binary_op (yyvsp[-2], '-', yyvsp[0]);
  }
#line 19623 "parser.c" /* yacc.c:1652  */
    break;

  case 1501:
#line 10613 "parser.y" /* yacc.c:1652  */
    {
	  check_repeated ("FROM CRT", SYN_CLAUSE_2, &check_duplicate);
  }
#line 19631 "parser.c" /* yacc.c:1652  */
    break;

  case 1502:
#line 10617 "parser.y" /* yacc.c:1652  */
    {
	  check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 19639 "parser.c" /* yacc.c:1652  */
    break;

  case 1504:
#line 10622 "parser.y" /* yacc.c:1652  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, yyvsp[0], NULL, NULL, 0);
  }
#line 19649 "parser.c" /* yacc.c:1652  */
    break;

  case 1511:
#line 10647 "parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict ("LINE", SYN_CLAUSE_1,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P (yyvsp[0]) && cb_get_int (yyvsp[0]) == 0) || yyvsp[0] == cb_zero) {
		cb_verify (cb_accept_display_extensions, "LINE 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (yyvsp[0], cb_int0);
	} else {
		CB_PAIR_X (line_column) = yyvsp[0];
	}
  }
#line 19669 "parser.c" /* yacc.c:1652  */
    break;

  case 1512:
#line 10663 "parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict ("COLUMN", SYN_CLAUSE_2,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P (yyvsp[0]) && cb_get_int (yyvsp[0]) == 0) || yyvsp[0] == cb_zero) {
		cb_verify (cb_accept_display_extensions, "COLUMN 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (cb_int0, yyvsp[0]);
	} else {
		CB_PAIR_Y (line_column) = yyvsp[0];
	}
  }
#line 19689 "parser.c" /* yacc.c:1652  */
    break;

  case 1513:
#line 10679 "parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict (_("AT screen-location"), SYN_CLAUSE_3,
				_("LINE or COLUMN"), SYN_CLAUSE_1 | SYN_CLAUSE_2,
				1, &check_line_col_duplicate);

	cb_verify (cb_accept_display_extensions, "AT clause");

	line_column = yyvsp[0];
  }
#line 19703 "parser.c" /* yacc.c:1652  */
    break;

  case 1514:
#line 10692 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	yyval = yyvsp[0];
  }
#line 19712 "parser.c" /* yacc.c:1652  */
    break;

  case 1515:
#line 10700 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	yyval = yyvsp[0];
  }
#line 19721 "parser.c" /* yacc.c:1652  */
    break;

  case 1516:
#line 10708 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 19729 "parser.c" /* yacc.c:1652  */
    break;

  case 1517:
#line 10715 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("AUTO", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				    "TAB", COB_SCREEN_TAB);
  }
#line 19739 "parser.c" /* yacc.c:1652  */
    break;

  case 1518:
#line 10721 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("TAB", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("TAB", COB_SCREEN_TAB,
				    "AUTO", COB_SCREEN_AUTO);
  }
#line 19749 "parser.c" /* yacc.c:1652  */
    break;

  case 1519:
#line 10727 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 19758 "parser.c" /* yacc.c:1652  */
    break;

  case 1520:
#line 10732 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	/* FIXME: do we need a COB_NO_SCREEN_BELL here?
	set_dispattr (COB_SCREEN_BELL); */
  }
#line 19768 "parser.c" /* yacc.c:1652  */
    break;

  case 1521:
#line 10738 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_8, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 19777 "parser.c" /* yacc.c:1652  */
    break;

  case 1522:
#line 10743 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_9, &check_duplicate);
	CB_PENDING ("ACCEPT CONVERSION");
  }
#line 19786 "parser.c" /* yacc.c:1652  */
    break;

  case 1523:
#line 10748 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		/* TODO: actually reasonable and easy extension: an 
		         *offset within the field* [auto-correct to 1/max]
				 (when variable also stored back on return)
		*/
		CB_PENDING ("ACCEPT ... WITH CURSOR");
	}
  }
#line 19803 "parser.c" /* yacc.c:1652  */
    break;

  case 1524:
#line 10761 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FULL", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr (COB_SCREEN_FULL);
  }
#line 19812 "parser.c" /* yacc.c:1652  */
    break;

  case 1525:
#line 10766 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LEFTLINE", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr (COB_SCREEN_LEFTLINE);
  }
#line 19821 "parser.c" /* yacc.c:1652  */
    break;

  case 1526:
#line 10771 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWER", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr_with_conflict ("LOWER", COB_SCREEN_LOWER,
				    "UPPER", COB_SCREEN_UPPER);
  }
#line 19831 "parser.c" /* yacc.c:1652  */
    break;

  case 1527:
#line 10777 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 19841 "parser.c" /* yacc.c:1652  */
    break;

  case 1528:
#line 10783 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 19851 "parser.c" /* yacc.c:1652  */
    break;

  case 1529:
#line 10790 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 19861 "parser.c" /* yacc.c:1652  */
    break;

  case 1530:
#line 10796 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 19869 "parser.c" /* yacc.c:1652  */
    break;

  case 1531:
#line 10800 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19877 "parser.c" /* yacc.c:1652  */
    break;

  case 1532:
#line 10804 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19885 "parser.c" /* yacc.c:1652  */
    break;

  case 1533:
#line 10808 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19893 "parser.c" /* yacc.c:1652  */
    break;

  case 1534:
#line 10812 "parser.y" /* yacc.c:1652  */
    {
	if (cb_no_echo_means_secure) {
		check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
		set_dispattr (COB_SCREEN_SECURE);
	} else {
		check_repeated ("NO-ECHO", SYN_CLAUSE_15, &check_duplicate);
		set_dispattr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					    "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 19908 "parser.c" /* yacc.c:1652  */
    break;

  case 1535:
#line 10823 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 19917 "parser.c" /* yacc.c:1652  */
    break;

  case 1536:
#line 10828 "parser.y" /* yacc.c:1652  */
    {
	/* Note: CHARACTER optional in ACUCOBOL, required by others */
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, yyvsp[0], NULL, COB_SCREEN_PROMPT);
  }
#line 19927 "parser.c" /* yacc.c:1652  */
    break;

  case 1537:
#line 10834 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_dispattr (COB_SCREEN_PROMPT);
  }
#line 19936 "parser.c" /* yacc.c:1652  */
    break;

  case 1538:
#line 10839 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REQUIRED", SYN_CLAUSE_18, &check_duplicate);
	set_dispattr (COB_SCREEN_REQUIRED);
  }
#line 19945 "parser.c" /* yacc.c:1652  */
    break;

  case 1539:
#line 10844 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_19, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 19954 "parser.c" /* yacc.c:1652  */
    break;

  case 1540:
#line 10849 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
	set_dispattr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				    "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 19964 "parser.c" /* yacc.c:1652  */
    break;

  case 1541:
#line 10855 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("SIZE", SYN_CLAUSE_21, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, yyvsp[0], 0);
  }
#line 19974 "parser.c" /* yacc.c:1652  */
    break;

  case 1542:
#line 10861 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_22, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 19983 "parser.c" /* yacc.c:1652  */
    break;

  case 1543:
#line 10866 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NO UPDATE", SYN_CLAUSE_23, &check_duplicate);
	set_dispattr_with_conflict ("NO UPDATE", COB_SCREEN_NO_UPDATE,
				    "UPDATE", COB_SCREEN_UPDATE);
  }
#line 19993 "parser.c" /* yacc.c:1652  */
    break;

  case 1544:
#line 10872 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPDATE", SYN_CLAUSE_24, &check_duplicate);
	set_dispattr_with_conflict ("UPDATE", COB_SCREEN_UPDATE,
				    "NO UPDATE", COB_SCREEN_NO_UPDATE);
  }
#line 20003 "parser.c" /* yacc.c:1652  */
    break;

  case 1545:
#line 10878 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPPER", SYN_CLAUSE_25, &check_duplicate);
	set_dispattr_with_conflict ("UPPER", COB_SCREEN_UPPER,
				    "LOWER", COB_SCREEN_LOWER);
  }
#line 20013 "parser.c" /* yacc.c:1652  */
    break;

  case 1546:
#line 10884 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 20024 "parser.c" /* yacc.c:1652  */
    break;

  case 1547:
#line 10891 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	set_attribs (yyvsp[0], NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 20033 "parser.c" /* yacc.c:1652  */
    break;

  case 1548:
#line 10896 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	set_attribs (NULL, yyvsp[0], NULL, NULL, NULL, NULL, 0);
  }
#line 20042 "parser.c" /* yacc.c:1652  */
    break;

  case 1549:
#line 10901 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_28, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 20053 "parser.c" /* yacc.c:1652  */
    break;

  case 1550:
#line 10908 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 20064 "parser.c" /* yacc.c:1652  */
    break;

  case 1551:
#line 10915 "parser.y" /* yacc.c:1652  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, yyvsp[0], NULL, NULL, 0);
  }
#line 20074 "parser.c" /* yacc.c:1652  */
    break;

  case 1555:
#line 10928 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONTROL KEY", SYN_CLAUSE_29, &check_duplicate);
	CB_PENDING ("CONTROL KEY");
#if 0 /* should generate the following *after* the ACCEPT is finished */
	cb_emit_accept_escape_key (yyvsp[0]);
#endif
  }
#line 20086 "parser.c" /* yacc.c:1652  */
    break;

  case 1564:
#line 10956 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], ACCEPT);
  }
#line 20094 "parser.c" /* yacc.c:1652  */
    break;

  case 1565:
#line 10960 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], ACCEPT);
# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
	if (current_statement->attr_ptr) {
		print_bits (current_statement->attr_ptr->dispattrs);
	} else {
		fputs("No Attribs", stderr);
	}
#endif
  }
#line 20110 "parser.c" /* yacc.c:1652  */
    break;

  case 1566:
#line 10978 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ADD", TERM_ADD);
  }
#line 20118 "parser.c" /* yacc.c:1652  */
    break;

  case 1568:
#line 10987 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '+', cb_build_binary_list (yyvsp[-3], '+'));
  }
#line 20126 "parser.c" /* yacc.c:1652  */
    break;

  case 1569:
#line 10991 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-3]) {
		cb_list_add (yyvsp[-4], yyvsp[-3]);
	}
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_list (yyvsp[-4], '+'));
  }
#line 20137 "parser.c" /* yacc.c:1652  */
    break;

  case 1570:
#line 10998 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_corresponding (cb_build_add, yyvsp[-2], yyvsp[-4], yyvsp[-1]);
  }
#line 20145 "parser.c" /* yacc.c:1652  */
    break;

  case 1571:
#line 11002 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ADD TABLE");
	cb_emit_tab_arithmetic (cb_build_add, yyvsp[-4], yyvsp[-6], yyvsp[-3], yyvsp[-2], yyvsp[-1]);
  }
#line 20154 "parser.c" /* yacc.c:1652  */
    break;

  case 1572:
#line 11009 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20160 "parser.c" /* yacc.c:1652  */
    break;

  case 1573:
#line 11010 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20166 "parser.c" /* yacc.c:1652  */
    break;

  case 1574:
#line 11015 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], ADD);
  }
#line 20174 "parser.c" /* yacc.c:1652  */
    break;

  case 1575:
#line 11019 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], ADD);
  }
#line 20182 "parser.c" /* yacc.c:1652  */
    break;

  case 1576:
#line 11029 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ALLOCATE", 0);
	cobc_cs_check = CB_CS_ALLOCATE;
	current_statement->flag_no_based = 1;
  }
#line 20192 "parser.c" /* yacc.c:1652  */
    break;

  case 1578:
#line 11039 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_allocate (yyvsp[-3], yyvsp[0], NULL, yyvsp[-2]);
  }
#line 20200 "parser.c" /* yacc.c:1652  */
    break;

  case 1579:
#line 11043 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		cb_error_x (CB_TREE (current_statement),
			    _("ALLOCATE CHARACTERS requires RETURNING clause"));
	} else {
		cb_emit_allocate (NULL, yyvsp[0], yyvsp[-4], yyvsp[-2]);
	}
  }
#line 20213 "parser.c" /* yacc.c:1652  */
    break;

  case 1581:
#line 11056 "parser.y" /* yacc.c:1652  */
    {
	int adressing = cb_get_int (yyvsp[0]);

	if (adressing == 24
	 || adressing == 31) {
		cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "LOC");
	} else {
		cb_error (_("addressing mode should be either 24 or 31 bit"));
	}
  }
#line 20228 "parser.c" /* yacc.c:1652  */
    break;

  case 1582:
#line 11068 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20234 "parser.c" /* yacc.c:1652  */
    break;

  case 1583:
#line 11069 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20240 "parser.c" /* yacc.c:1652  */
    break;

  case 1584:
#line 11077 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ALTER", 0);
	cb_verify (cb_alter_statement, "ALTER");
  }
#line 20249 "parser.c" /* yacc.c:1652  */
    break;

  case 1588:
#line 11091 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_alter (yyvsp[-3], yyvsp[0]);
  }
#line 20257 "parser.c" /* yacc.c:1652  */
    break;

  case 1591:
#line 11103 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CALL", TERM_CALL);
	cobc_cs_check = CB_CS_CALL;
	call_nothing = 0;
	cobc_allow_program_name = 1;
	backup_current_pos ();
  }
#line 20269 "parser.c" /* yacc.c:1652  */
    break;

  case 1592:
#line 11112 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 20277 "parser.c" /* yacc.c:1652  */
    break;

  case 1593:
#line 11119 "parser.y" /* yacc.c:1652  */
    {
	cobc_allow_program_name = 0;
  }
#line 20285 "parser.c" /* yacc.c:1652  */
    break;

  case 1594:
#line 11127 "parser.y" /* yacc.c:1652  */
    {
	int call_conv = 0;
	int call_conv_local = 0;

	if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM
	 && !current_program->flag_recursive
	 && is_recursive_call (yyvsp[-6])) {
		cb_warning_x (COBC_WARN_FILLER, yyvsp[-6],
			_("recursive program call - assuming RECURSIVE attribute"));
		current_program->flag_recursive = 1;
	}
	call_conv = current_call_convention;
	if (yyvsp[-3]) {
		if (current_call_convention & CB_CONV_STATIC_LINK) {
			call_conv = CB_INTEGER (yyvsp[-3])->val | CB_CONV_STATIC_LINK;
		} else {
			call_conv = CB_INTEGER (yyvsp[-3])->val;
		}
		if (yyvsp[-8]) {
			/* note: $1 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x (yyvsp[-3], _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if ((CB_PAIR_X (yyvsp[0]) != NULL)
	 && (call_conv & CB_CONV_STATIC_LINK)) {
		cb_warning_x (COBC_WARN_FILLER, yyvsp[-6],
		    _("STATIC CALL convention ignored because of ON EXCEPTION"));
		call_conv &= ~CB_CONV_STATIC_LINK;
	}
	if (yyvsp[-8]) {
		if (CB_INTEGER_P (yyvsp[-8])) {
			call_conv_local = CB_INTEGER (yyvsp[-8])->val;
			if ((CB_PAIR_X (yyvsp[0]) != NULL)
			 && (call_conv_local & CB_CONV_STATIC_LINK)) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[-8],
					_("ON EXCEPTION ignored because of STATIC CALL"));
				CB_PAIR_X (yyvsp[0]) = NULL;
			}
			call_conv |= call_conv_local;
			if (CB_INTEGER (yyvsp[-8])->val & CB_CONV_COBOL) {
				call_conv &= ~CB_CONV_STDCALL;
			} else {
				call_conv &= ~CB_CONV_COBOL;
			}
		} else {
			call_conv = cb_get_int(yyvsp[-8]);
		}
	}
	/* For CALL ... RETURNING NOTHING, set the call convention bit */
	if (call_nothing) {
		call_conv |= CB_CONV_NO_RET_UPD;
	}
	cb_emit_call (yyvsp[-6], yyvsp[-2], yyvsp[-1], CB_PAIR_X (yyvsp[0]), CB_PAIR_Y (yyvsp[0]),
		      cb_int (call_conv), yyvsp[-7], yyvsp[-4], backup_source_line);
  }
#line 20346 "parser.c" /* yacc.c:1652  */
    break;

  case 1595:
#line 11187 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20354 "parser.c" /* yacc.c:1652  */
    break;

  case 1596:
#line 11191 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: hack - fake cs for context-sensitive WITH ... LINKAGE */
	cobc_cs_check |= CB_CS_OPTIONS;
	backup_current_pos ();
  }
#line 20364 "parser.c" /* yacc.c:1652  */
    break;

  case 1597:
#line 11197 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	restore_backup_pos (yyval);
	cobc_cs_check ^= CB_CS_OPTIONS;
	cb_verify_x (yyval, cb_call_convention_linkage, "WITH ... LINKAGE");
  }
#line 20375 "parser.c" /* yacc.c:1652  */
    break;

  case 1598:
#line 11207 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 20383 "parser.c" /* yacc.c:1652  */
    break;

  case 1599:
#line 11211 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20391 "parser.c" /* yacc.c:1652  */
    break;

  case 1600:
#line 11215 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_PASCAL);
  }
#line 20399 "parser.c" /* yacc.c:1652  */
    break;

  case 1601:
#line 11222 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20407 "parser.c" /* yacc.c:1652  */
    break;

  case 1602:
#line 11226 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_call_convention_mnemonic, "CALL-/ENTRY-CONVENTION");
	yyval = yyvsp[0];
  }
#line 20416 "parser.c" /* yacc.c:1652  */
    break;

  case 1603:
#line 11234 "parser.y" /* yacc.c:1652  */
    {
	if (current_call_convention & CB_CONV_COBOL) {
		yyval = cb_int (CB_CONV_STATIC_LINK | CB_CONV_COBOL);
	} else {
		yyval = cb_int (CB_CONV_STATIC_LINK);
	}
  }
#line 20428 "parser.c" /* yacc.c:1652  */
    break;

  case 1604:
#line 11242 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 20436 "parser.c" /* yacc.c:1652  */
    break;

  case 1605:
#line 11246 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20444 "parser.c" /* yacc.c:1652  */
    break;

  case 1606:
#line 11250 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20452 "parser.c" /* yacc.c:1652  */
    break;

  case 1607:
#line 11254 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_PASCAL);
  }
#line 20460 "parser.c" /* yacc.c:1652  */
    break;

  case 1608:
#line 11258 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	x = cb_ref (yyvsp[0]);
	if (CB_VALID_TREE (x)) {
		if (CB_SYSTEM_NAME(x)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (yyvsp[0], _("invalid mnemonic name"));
			yyval = NULL;
		} else {
			yyval = CB_SYSTEM_NAME(x)->value;
		}
	} else {
		yyval = NULL;
	}
  }
#line 20480 "parser.c" /* yacc.c:1652  */
    break;

  case 1609:
#line 11277 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[0])) {
		cb_trim_program_id (yyvsp[0]);
	}
  }
#line 20490 "parser.c" /* yacc.c:1652  */
    break;

  case 1610:
#line 11283 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
	/* hack to push the prototype name */
	if (yyvsp[0] && CB_REFERENCE_P (yyvsp[0])) {
		if (yyvsp[-1]) {
			cb_warning_x (COBC_WARN_FILLER, yyvsp[-1], _("id/literal ignored, using prototype name"));
		}
		yyval = yyvsp[0];
	} else if (yyvsp[-1] && CB_LITERAL_P (yyvsp[-1])) {
		yyval = yyvsp[-1];
	} else {
		cb_error (_("NESTED phrase is only valid with literal"));
		yyval = cb_error_node;
	}
  }
#line 20510 "parser.c" /* yacc.c:1652  */
    break;

  case 1611:
#line 11302 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20518 "parser.c" /* yacc.c:1652  */
    break;

  case 1612:
#line 11307 "parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-1])) {
		cb_trim_program_id (yyvsp[-1]);
	}
	yyval = yyvsp[-1];
  }
#line 20529 "parser.c" /* yacc.c:1652  */
    break;

  case 1613:
#line 11317 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("NESTED phrase for CALL statement");
  }
#line 20537 "parser.c" /* yacc.c:1652  */
    break;

  case 1615:
#line 11325 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20545 "parser.c" /* yacc.c:1652  */
    break;

  case 1616:
#line 11329 "parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 20554 "parser.c" /* yacc.c:1652  */
    break;

  case 1617:
#line 11334 "parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error_x (CB_TREE (current_statement),
			    _("number of arguments exceeds maximum %d"),
			    MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 20567 "parser.c" /* yacc.c:1652  */
    break;

  case 1618:
#line 11345 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20573 "parser.c" /* yacc.c:1652  */
    break;

  case 1619:
#line 11347 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 20579 "parser.c" /* yacc.c:1652  */
    break;

  case 1620:
#line 11352 "parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error_x (CB_TREE (current_statement),
			    _("OMITTED only allowed when arguments are passed BY REFERENCE"));
	}
	yyval = CB_BUILD_PAIR (cb_int (call_mode), cb_null);
  }
#line 20591 "parser.c" /* yacc.c:1652  */
    break;

  case 1621:
#line 11360 "parser.y" /* yacc.c:1652  */
    {
	int	save_mode;	/* internal single parameter only mode */

	save_mode = call_mode;
	if (call_mode != CB_CALL_BY_REFERENCE) {
		if (CB_FILE_P (yyvsp[0]) || (CB_REFERENCE_P (yyvsp[0]) &&
		    CB_FILE_P (CB_REFERENCE (yyvsp[0])->value))) {
			cb_error_x (CB_TREE (current_statement),
				    _("invalid file name reference"));
		} else if (call_mode == CB_CALL_BY_VALUE) {
			/* FIXME: compiler configuration needed, IBM allows one-byte
			          alphanumeric items [--> a `char`], too, while
			          COBOL 2002/2014 allow only numeric literals
			   --> revise after rw-merge */
			if (cb_category_is_alpha (yyvsp[0])) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[0],
					      _("BY CONTENT assumed for alphanumeric item '%s'"),
						  cb_name (yyvsp[0]));
				call_mode = CB_CALL_BY_CONTENT;
			} else if (cb_category_is_national (yyvsp[0])) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[0],
					      _("BY CONTENT assumed for national item '%s'"),
						  cb_name (yyvsp[0]));
				call_mode = CB_CALL_BY_CONTENT;
			}
		}
	}
	yyval = CB_BUILD_PAIR (cb_int (call_mode), yyvsp[0]);
	CB_SIZES (yyval) = size_mode;
	call_mode = save_mode;
  }
#line 20627 "parser.c" /* yacc.c:1652  */
    break;

  case 1623:
#line 11396 "parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 20635 "parser.c" /* yacc.c:1652  */
    break;

  case 1624:
#line 11400 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY CONTENT");
	} else {
		call_mode = CB_CALL_BY_CONTENT;
	}
  }
#line 20648 "parser.c" /* yacc.c:1652  */
    break;

  case 1625:
#line 11409 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 20661 "parser.c" /* yacc.c:1652  */
    break;

  case 1626:
#line 11421 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20669 "parser.c" /* yacc.c:1652  */
    break;

  case 1627:
#line 11425 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20677 "parser.c" /* yacc.c:1652  */
    break;

  case 1628:
#line 11429 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 20685 "parser.c" /* yacc.c:1652  */
    break;

  case 1629:
#line 11433 "parser.y" /* yacc.c:1652  */
    {
	call_nothing = CB_CONV_NO_RET_UPD;
	yyval = cb_null;
  }
#line 20694 "parser.c" /* yacc.c:1652  */
    break;

  case 1630:
#line 11438 "parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01 or 77"));
			yyval = NULL;
		} else if (f->storage != CB_STORAGE_LINKAGE &&
			   !f->flag_item_based) {
			cb_error (_("RETURNING item must be a LINKAGE SECTION item or have BASED clause"));
			yyval = NULL;
		} else {
			yyval = cb_build_address (yyvsp[0]);
		}
	} else {
		yyval = NULL;
	}
  }
#line 20718 "parser.c" /* yacc.c:1652  */
    break;

  case 1635:
#line 11471 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (NULL, NULL);
  }
#line 20726 "parser.c" /* yacc.c:1652  */
    break;

  case 1636:
#line 11475 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 20734 "parser.c" /* yacc.c:1652  */
    break;

  case 1637:
#line 11479 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
	yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-1]);
  }
#line 20746 "parser.c" /* yacc.c:1652  */
    break;

  case 1638:
#line 11490 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20754 "parser.c" /* yacc.c:1652  */
    break;

  case 1639:
#line 11494 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20762 "parser.c" /* yacc.c:1652  */
    break;

  case 1640:
#line 11501 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20770 "parser.c" /* yacc.c:1652  */
    break;

  case 1641:
#line 11505 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_call_overflow, "ON OVERFLOW");
	yyval = yyvsp[0];
  }
#line 20779 "parser.c" /* yacc.c:1652  */
    break;

  case 1642:
#line 11513 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20787 "parser.c" /* yacc.c:1652  */
    break;

  case 1643:
#line 11517 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20795 "parser.c" /* yacc.c:1652  */
    break;

  case 1644:
#line 11524 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20803 "parser.c" /* yacc.c:1652  */
    break;

  case 1645:
#line 11531 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], CALL);
  }
#line 20811 "parser.c" /* yacc.c:1652  */
    break;

  case 1646:
#line 11535 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], CALL);
  }
#line 20819 "parser.c" /* yacc.c:1652  */
    break;

  case 1647:
#line 11545 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CANCEL", 0);
	cobc_allow_program_name = 1;
  }
#line 20828 "parser.c" /* yacc.c:1652  */
    break;

  case 1648:
#line 11550 "parser.y" /* yacc.c:1652  */
    {
	cobc_allow_program_name = 0;
  }
#line 20836 "parser.c" /* yacc.c:1652  */
    break;

  case 1649:
#line 11557 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_cancel (yyvsp[0]);
  }
#line 20844 "parser.c" /* yacc.c:1652  */
    break;

  case 1650:
#line 11561 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_cancel (yyvsp[0]);
  }
#line 20852 "parser.c" /* yacc.c:1652  */
    break;

  case 1652:
#line 11569 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
  }
#line 20860 "parser.c" /* yacc.c:1652  */
    break;

  case 1653:
#line 11578 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CLOSE", 0);
  }
#line 20868 "parser.c" /* yacc.c:1652  */
    break;

  case 1657:
#line 11591 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_close (yyvsp[-1], yyvsp[0]);
  }
#line 20877 "parser.c" /* yacc.c:1652  */
    break;

  case 1658:
#line 11596 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_close (yyvsp[-1], yyvsp[0]);
  }
#line 20886 "parser.c" /* yacc.c:1652  */
    break;

  case 1659:
#line 11603 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_NORMAL); }
#line 20892 "parser.c" /* yacc.c:1652  */
    break;

  case 1660:
#line 11604 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_UNIT); }
#line 20898 "parser.c" /* yacc.c:1652  */
    break;

  case 1661:
#line 11605 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_UNIT_REMOVAL); }
#line 20904 "parser.c" /* yacc.c:1652  */
    break;

  case 1662:
#line 11606 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_NO_REWIND); }
#line 20910 "parser.c" /* yacc.c:1652  */
    break;

  case 1663:
#line 11607 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_LOCK); }
#line 20916 "parser.c" /* yacc.c:1652  */
    break;

  case 1664:
#line 11612 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "CLOSE WINDOW";
  }
#line 20925 "parser.c" /* yacc.c:1652  */
    break;

  case 1665:
#line 11617 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_close_window (yyvsp[-1], yyvsp[0]);
  }
#line 20933 "parser.c" /* yacc.c:1652  */
    break;

  case 1666:
#line 11623 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20939 "parser.c" /* yacc.c:1652  */
    break;

  case 1667:
#line 11624 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 20945 "parser.c" /* yacc.c:1652  */
    break;

  case 1668:
#line 11632 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("COMPUTE", TERM_COMPUTE);
  }
#line 20953 "parser.c" /* yacc.c:1652  */
    break;

  case 1670:
#line 11641 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-3], 0, yyvsp[-1]);
  }
#line 20961 "parser.c" /* yacc.c:1652  */
    break;

  case 1671:
#line 11648 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], COMPUTE);
  }
#line 20969 "parser.c" /* yacc.c:1652  */
    break;

  case 1672:
#line 11652 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], COMPUTE);
  }
#line 20977 "parser.c" /* yacc.c:1652  */
    break;

  case 1673:
#line 11662 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("COMMIT", 0);
	cb_emit_commit ();
  }
#line 20986 "parser.c" /* yacc.c:1652  */
    break;

  case 1674:
#line 11673 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 20994 "parser.c" /* yacc.c:1652  */
    break;

  case 1675:
#line 11677 "parser.y" /* yacc.c:1652  */
    {
	if (!yyvsp[0]) {
		/* Do not check unreached for CONTINUE without after phrase */
		unsigned int	save_unreached = check_unreached;
		check_unreached = 0;
		begin_statement_from_backup_pos ("CONTINUE", 0);
		cb_emit_continue (NULL);
		check_unreached = save_unreached;
	} else {
		begin_statement_from_backup_pos ("CONTINUE AFTER", 0);
		cb_emit_continue (yyvsp[0]);
	}
  }
#line 21012 "parser.c" /* yacc.c:1652  */
    break;

  case 1676:
#line 11693 "parser.y" /* yacc.c:1652  */
    { yyval = NULL;}
#line 21018 "parser.c" /* yacc.c:1652  */
    break;

  case 1677:
#line 11694 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: hack - fake cs for context-sensitive SECONDS */
	cobc_cs_check = CB_CS_RETRY;
  }
#line 21027 "parser.c" /* yacc.c:1652  */
    break;

  case 1678:
#line 11699 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 21035 "parser.c" /* yacc.c:1652  */
    break;

  case 1679:
#line 11709 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DESTROY", 0);
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 21044 "parser.c" /* yacc.c:1652  */
    break;

  case 1681:
#line 11718 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_destroy (NULL);
  }
#line 21052 "parser.c" /* yacc.c:1652  */
    break;

  case 1682:
#line 11725 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_destroy (yyvsp[0]);
  }
#line 21060 "parser.c" /* yacc.c:1652  */
    break;

  case 1683:
#line 11735 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DELETE", TERM_DELETE);
  }
#line 21068 "parser.c" /* yacc.c:1652  */
    break;

  case 1685:
#line 11744 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_delete (yyvsp[-3]);
  }
#line 21076 "parser.c" /* yacc.c:1652  */
    break;

  case 1687:
#line 11752 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file (yyvsp[0]);
  }
#line 21085 "parser.c" /* yacc.c:1652  */
    break;

  case 1688:
#line 11757 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file (yyvsp[0]);
  }
#line 21094 "parser.c" /* yacc.c:1652  */
    break;

  case 1689:
#line 11765 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DELETE);
  }
#line 21102 "parser.c" /* yacc.c:1652  */
    break;

  case 1690:
#line 11769 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DELETE);
  }
#line 21110 "parser.c" /* yacc.c:1652  */
    break;

  case 1691:
#line 11779 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DISABLE", 0);
  }
#line 21118 "parser.c" /* yacc.c:1652  */
    break;

  case 1695:
#line 11793 "parser.y" /* yacc.c:1652  */
    {
	/* Add cb_verify for <= COBOL-85 */
  }
#line 21126 "parser.c" /* yacc.c:1652  */
    break;

  case 1701:
#line 11811 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DISPLAY", TERM_DISPLAY);
	cobc_cs_check = CB_CS_DISPLAY;
	display_type = UNKNOWN_DISPLAY;
	is_first_display_item = 1;
  }
#line 21137 "parser.c" /* yacc.c:1652  */
    break;

  case 1703:
#line 11823 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_env_name (yyvsp[-2]);
  }
#line 21145 "parser.c" /* yacc.c:1652  */
    break;

  case 1704:
#line 11827 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_env_value (yyvsp[-2]);
  }
#line 21153 "parser.c" /* yacc.c:1652  */
    break;

  case 1705:
#line 11831 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arg_number (yyvsp[-2]);
  }
#line 21161 "parser.c" /* yacc.c:1652  */
    break;

  case 1706:
#line 11835 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_command_line (yyvsp[-2]);
  }
#line 21169 "parser.c" /* yacc.c:1652  */
    break;

  case 1714:
#line 11849 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] != NULL) {
		error_if_different_display_type (yyvsp[0], NULL, NULL, NULL);
		cb_emit_display (yyvsp[0], NULL, cb_int1, NULL, NULL, 0,
				 display_type);
	}
  }
#line 21181 "parser.c" /* yacc.c:1652  */
    break;

  case 1715:
#line 11857 "parser.y" /* yacc.c:1652  */
    {
	set_display_type (yyvsp[0], NULL, NULL, NULL);
	cb_emit_display (yyvsp[0], NULL, cb_int1, NULL, NULL, 1,
			 display_type);
  }
#line 21191 "parser.c" /* yacc.c:1652  */
    break;

  case 1718:
#line 11871 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	advancing_value = cb_int1;
	upon_value = NULL;
	line_column = NULL;
  }
#line 21203 "parser.c" /* yacc.c:1652  */
    break;

  case 1719:
#line 11879 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-2] == cb_null) {
		/* Emit DISPLAY OMITTED. */
		CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY OMITTED");
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	/* Emit device or screen DISPLAY. */

	/*
	  Check that disp_list does not contain an invalid mix of fields.
	*/
	if (display_type == UNKNOWN_DISPLAY) {
		set_display_type (yyvsp[-2], upon_value, line_column,
				  current_statement->attr_ptr);
	} else {
		error_if_different_display_type (yyvsp[-2], upon_value,
						 line_column,
						 current_statement->attr_ptr);
	}

	if (display_type == SCREEN_DISPLAY
	 || display_type == FIELD_ON_SCREEN_DISPLAY) {
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	cb_emit_display (yyvsp[-2], upon_value, advancing_value, line_column,
			 current_statement->attr_ptr,
			 is_first_display_item, display_type);

	is_first_display_item = 0;
  }
#line 21240 "parser.c" /* yacc.c:1652  */
    break;

  case 1720:
#line 11915 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21248 "parser.c" /* yacc.c:1652  */
    break;

  case 1721:
#line 11919 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 21256 "parser.c" /* yacc.c:1652  */
    break;

  case 1728:
#line 11941 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPON", SYN_CLAUSE_1, &check_duplicate);
  }
#line 21264 "parser.c" /* yacc.c:1652  */
    break;

  case 1729:
#line 11945 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NO ADVANCING", SYN_CLAUSE_2, &check_duplicate);
	advancing_value = cb_int0;
  }
#line 21273 "parser.c" /* yacc.c:1652  */
    break;

  case 1730:
#line 11950 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 21281 "parser.c" /* yacc.c:1652  */
    break;

  case 1733:
#line 11959 "parser.y" /* yacc.c:1652  */
    {
	  upon_value = NULL;
  }
#line 21289 "parser.c" /* yacc.c:1652  */
    break;

  case 1735:
#line 11967 "parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_build_display_mnemonic (yyvsp[0]);
  }
#line 21297 "parser.c" /* yacc.c:1652  */
    break;

  case 1736:
#line 11971 "parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_build_display_name (yyvsp[0]);
  }
#line 21305 "parser.c" /* yacc.c:1652  */
    break;

  case 1737:
#line 11975 "parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_int2;
  }
#line 21313 "parser.c" /* yacc.c:1652  */
    break;

  case 1738:
#line 11979 "parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_null;
  }
#line 21321 "parser.c" /* yacc.c:1652  */
    break;

  case 1741:
#line 11991 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = SYN_CLAUSE_10;
	check_line_col_duplicate = 0;
	line_column = NULL;
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21333 "parser.c" /* yacc.c:1652  */
    break;

  case 1742:
#line 11999 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_display (CB_LIST_INIT (cb_space), cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21341 "parser.c" /* yacc.c:1652  */
    break;

  case 1743:
#line 12008 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_display (yyvsp[-1], cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21349 "parser.c" /* yacc.c:1652  */
    break;

  case 1744:
#line 12014 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 21359 "parser.c" /* yacc.c:1652  */
    break;

  case 1745:
#line 12020 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21367 "parser.c" /* yacc.c:1652  */
    break;

  case 1746:
#line 12027 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 21375 "parser.c" /* yacc.c:1652  */
    break;

  case 1747:
#line 12031 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 21383 "parser.c" /* yacc.c:1652  */
    break;

  case 1750:
#line 12041 "parser.y" /* yacc.c:1652  */
    {
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
	yyval = cb_space;
  }
#line 21393 "parser.c" /* yacc.c:1652  */
    break;

  case 1751:
#line 12051 "parser.y" /* yacc.c:1652  */
    {
	CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY MESSAGE");
	upon_value = NULL;
  }
#line 21402 "parser.c" /* yacc.c:1652  */
    break;

  case 1752:
#line 12056 "parser.y" /* yacc.c:1652  */
    {
	/* for now: minimal support for display and prompt only */
	if (upon_value) {
		cb_emit_display (CB_LIST_INIT (upon_value), NULL, NULL, NULL,
				 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	}
	cb_emit_display (yyvsp[-2], NULL, NULL, NULL,
			 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
  }
#line 21417 "parser.c" /* yacc.c:1652  */
    break;

  case 1757:
#line 12080 "parser.y" /* yacc.c:1652  */
    {
	upon_value = yyvsp[0];
  }
#line 21425 "parser.c" /* yacc.c:1652  */
    break;

  case 1762:
#line 12091 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY WINDOW";
  }
#line 21434 "parser.c" /* yacc.c:1652  */
    break;

  case 1763:
#line 12096 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21445 "parser.c" /* yacc.c:1652  */
    break;

  case 1764:
#line 12103 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_display_window (NULL, upon_value, yyvsp[-2], line_column,
			 current_statement->attr_ptr);
  }
#line 21454 "parser.c" /* yacc.c:1652  */
    break;

  case 1767:
#line 12116 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY FLOATING WINDOW";
  }
#line 21463 "parser.c" /* yacc.c:1652  */
    break;

  case 1768:
#line 12121 "parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21474 "parser.c" /* yacc.c:1652  */
    break;

  case 1769:
#line 12128 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-5]) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (cb_int0, upon_value, yyvsp[-2], line_column,
			 current_statement->attr_ptr);
  }
#line 21487 "parser.c" /* yacc.c:1652  */
    break;

  case 1770:
#line 12140 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY INITIAL WINDOW";
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
	/* TODO: initialize attributes for SHADOW, BOTTOM */
  }
#line 21501 "parser.c" /* yacc.c:1652  */
    break;

  case 1771:
#line 12150 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-3]) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (yyvsp[-4], upon_value, NULL, line_column,
			 current_statement->attr_ptr);
  }
#line 21514 "parser.c" /* yacc.c:1652  */
    break;

  case 1772:
#line 12161 "parser.y" /* yacc.c:1652  */
    {yyval = cb_int1;}
#line 21520 "parser.c" /* yacc.c:1652  */
    break;

  case 1773:
#line 12162 "parser.y" /* yacc.c:1652  */
    {yyval = cb_int2;}
#line 21526 "parser.c" /* yacc.c:1652  */
    break;

  case 1774:
#line 12163 "parser.y" /* yacc.c:1652  */
    {yyval = cb_int3;}
#line 21532 "parser.c" /* yacc.c:1652  */
    break;

  case 1775:
#line 12167 "parser.y" /* yacc.c:1652  */
    {yyval = NULL;}
#line 21538 "parser.c" /* yacc.c:1652  */
    break;

  case 1776:
#line 12168 "parser.y" /* yacc.c:1652  */
    {yyval = cb_int1;}
#line 21544 "parser.c" /* yacc.c:1652  */
    break;

  case 1777:
#line 12173 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 21552 "parser.c" /* yacc.c:1652  */
    break;

  case 1778:
#line 12177 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21560 "parser.c" /* yacc.c:1652  */
    break;

  case 1779:
#line 12184 "parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->usage != CB_USAGE_HNDL_WINDOW
		 && f->usage != CB_USAGE_HNDL_SUBWINDOW) {
			cb_error_x (yyvsp[0], _("HANDLE must be a %s HANDLE"), "WINDOW");
		}
	}
	yyval = yyvsp[0];
  }
#line 21577 "parser.c" /* yacc.c:1652  */
    break;

  case 1780:
#line 12197 "parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->usage != CB_USAGE_HNDL) {
			cb_error_x (yyvsp[0], _("HANDLE must be a generic HANDLE"));
		}
	}
	yyval = yyvsp[0];
  }
#line 21593 "parser.c" /* yacc.c:1652  */
    break;

  case 1781:
#line 12209 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 21601 "parser.c" /* yacc.c:1652  */
    break;

  case 1785:
#line 12224 "parser.y" /* yacc.c:1652  */
    {
	/* TODO: store */
  }
#line 21609 "parser.c" /* yacc.c:1652  */
    break;

  case 1792:
#line 12236 "parser.y" /* yacc.c:1652  */
    { /* TODO: set attribute */ }
#line 21615 "parser.c" /* yacc.c:1652  */
    break;

  case 1793:
#line 12239 "parser.y" /* yacc.c:1652  */
    { /* TODO: set attribute */ }
#line 21621 "parser.c" /* yacc.c:1652  */
    break;

  case 1794:
#line 12243 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21627 "parser.c" /* yacc.c:1652  */
    break;

  case 1795:
#line 12244 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21633 "parser.c" /* yacc.c:1652  */
    break;

  case 1796:
#line 12245 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21639 "parser.c" /* yacc.c:1652  */
    break;

  case 1797:
#line 12249 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21645 "parser.c" /* yacc.c:1652  */
    break;

  case 1798:
#line 12250 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21651 "parser.c" /* yacc.c:1652  */
    break;

  case 1799:
#line 12251 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21657 "parser.c" /* yacc.c:1652  */
    break;

  case 1800:
#line 12252 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 21663 "parser.c" /* yacc.c:1652  */
    break;

  case 1805:
#line 12268 "parser.y" /* yacc.c:1652  */
    {
	if (upon_value) {
		emit_duplicate_clause_message("POP-UP AREA");
	}
	upon_value = yyvsp[0];
  }
#line 21674 "parser.c" /* yacc.c:1652  */
    break;

  case 1806:
#line 12278 "parser.y" /* yacc.c:1652  */
    {
	if (!strcmp (current_statement->name, "DISPLAY WINDOW")) {
		cb_error_x (yyvsp[0], _("HANDLE clause invalid for %s"),
			current_statement->name);
		upon_value = cb_error_node;
	} else{
		if (upon_value) {
			emit_duplicate_clause_message("POP-UP AREA / HANDLE IN");
		}
		upon_value = yyvsp[0];
	}
  }
#line 21691 "parser.c" /* yacc.c:1652  */
    break;

  case 1807:
#line 12294 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_4, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 21700 "parser.c" /* yacc.c:1652  */
    break;

  case 1808:
#line 12299 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK LINE", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				    "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 21710 "parser.c" /* yacc.c:1652  */
    break;

  case 1809:
#line 12305 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK SCREEN", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				    "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 21720 "parser.c" /* yacc.c:1652  */
    break;

  case 1810:
#line 12311 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 21729 "parser.c" /* yacc.c:1652  */
    break;

  case 1811:
#line 12316 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_8, &check_duplicate);
	cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "CONVERSION");
  }
#line 21738 "parser.c" /* yacc.c:1652  */
    break;

  case 1812:
#line 12321 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ERASE EOL", SYN_CLAUSE_9, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				    "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 21748 "parser.c" /* yacc.c:1652  */
    break;

  case 1813:
#line 12327 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ERASE EOS", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21758 "parser.c" /* yacc.c:1652  */
    break;

  case 1814:
#line 12333 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 21768 "parser.c" /* yacc.c:1652  */
    break;

  case 1815:
#line 12339 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 21778 "parser.c" /* yacc.c:1652  */
    break;

  case 1816:
#line 12346 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 21788 "parser.c" /* yacc.c:1652  */
    break;

  case 1817:
#line 12352 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 21796 "parser.c" /* yacc.c:1652  */
    break;

  case 1818:
#line 12356 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21804 "parser.c" /* yacc.c:1652  */
    break;

  case 1819:
#line 12360 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21812 "parser.c" /* yacc.c:1652  */
    break;

  case 1820:
#line 12364 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21820 "parser.c" /* yacc.c:1652  */
    break;

  case 1821:
#line 12368 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 21829 "parser.c" /* yacc.c:1652  */
    break;

  case 1822:
#line 12373 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 21838 "parser.c" /* yacc.c:1652  */
    break;

  case 1823:
#line 12378 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_15, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, yyvsp[0], 0);
  }
#line 21847 "parser.c" /* yacc.c:1652  */
    break;

  case 1824:
#line 12383 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 21856 "parser.c" /* yacc.c:1652  */
    break;

  case 1825:
#line 12388 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 21866 "parser.c" /* yacc.c:1652  */
    break;

  case 1826:
#line 12394 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (yyvsp[0], NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 21875 "parser.c" /* yacc.c:1652  */
    break;

  case 1827:
#line 12399 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	set_attribs (NULL, yyvsp[0], NULL, NULL, NULL, NULL, 0);
  }
#line 21884 "parser.c" /* yacc.c:1652  */
    break;

  case 1828:
#line 12404 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 21895 "parser.c" /* yacc.c:1652  */
    break;

  case 1829:
#line 12411 "parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_20, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 21906 "parser.c" /* yacc.c:1652  */
    break;

  case 1830:
#line 12421 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DISPLAY);
  }
#line 21914 "parser.c" /* yacc.c:1652  */
    break;

  case 1831:
#line 12425 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DISPLAY);
  }
#line 21922 "parser.c" /* yacc.c:1652  */
    break;

  case 1832:
#line 12435 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DIVIDE", TERM_DIVIDE);
  }
#line 21930 "parser.c" /* yacc.c:1652  */
    break;

  case 1834:
#line 12444 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '/', yyvsp[-3]);
  }
#line 21938 "parser.c" /* yacc.c:1652  */
    break;

  case 1835:
#line 12448 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-3], '/', yyvsp[-5]));
  }
#line 21946 "parser.c" /* yacc.c:1652  */
    break;

  case 1836:
#line 12452 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-5], '/', yyvsp[-3]));
  }
#line 21954 "parser.c" /* yacc.c:1652  */
    break;

  case 1837:
#line 12456 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_divide (yyvsp[-5], yyvsp[-7], yyvsp[-3], yyvsp[-1]);
  }
#line 21962 "parser.c" /* yacc.c:1652  */
    break;

  case 1838:
#line 12460 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_divide (yyvsp[-7], yyvsp[-5], yyvsp[-3], yyvsp[-1]);
  }
#line 21970 "parser.c" /* yacc.c:1652  */
    break;

  case 1839:
#line 12467 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DIVIDE);
  }
#line 21978 "parser.c" /* yacc.c:1652  */
    break;

  case 1840:
#line 12471 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DIVIDE);
  }
#line 21986 "parser.c" /* yacc.c:1652  */
    break;

  case 1841:
#line 12481 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ENABLE", 0);
  }
#line 21994 "parser.c" /* yacc.c:1652  */
    break;

  case 1843:
#line 12492 "parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY", 0);
	backup_current_pos ();
  }
#line 22004 "parser.c" /* yacc.c:1652  */
    break;

  case 1845:
#line 12499 "parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY FOR GO TO", 0);
	backup_current_pos ();
  }
#line 22014 "parser.c" /* yacc.c:1652  */
    break;

  case 1847:
#line 12509 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "ENTRY");
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "ENTRY");
	} else if (cb_verify (cb_entry_statement, "ENTRY")) {
		cb_tree call_conv = yyvsp[-3];
		if (yyvsp[-1]) {
			call_conv = yyvsp[-1];
			if (yyvsp[-3]) {
				/* note: $1 is likely to be a reference to SPECIAL-NAMES */
				cb_error_x (yyvsp[-1], _("%s and %s are mutually exclusive"),
					"CALL-CONVENTION", "WITH LINKAGE");
			}
		}
		if (!cobc_check_valid_name ((char *)(CB_LITERAL (yyvsp[-2])->data), ENTRY_NAME)) {
			emit_entry ((char *)(CB_LITERAL (yyvsp[-2])->data), 1, yyvsp[0], call_conv);
		}
	}
  }
#line 22039 "parser.c" /* yacc.c:1652  */
    break;

  case 1848:
#line 12533 "parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		emit_entry_goto ((char *)(CB_LITERAL (yyvsp[0])->data));
	}
  }
#line 22049 "parser.c" /* yacc.c:1652  */
    break;

  case 1849:
#line 12545 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("EVALUATE", TERM_EVALUATE);
	eval_level++;
	if (eval_level >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_level = 0;
		eval_inc = 0;
		eval_inc2 = 0;
		YYERROR;
	} else {
		for (eval_inc = 0; eval_inc < EVAL_DEPTH; ++eval_inc) {
			eval_check[eval_level][eval_inc] = NULL;
		}
		eval_inc = 0;
		eval_inc2 = 0;
	}
	cb_end_cond (cb_any);
	cb_save_cond ();
	cb_true_side ();
  }
#line 22075 "parser.c" /* yacc.c:1652  */
    break;

  case 1851:
#line 12572 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_evaluate (yyvsp[-1], yyvsp[0]);
	eval_level--;
  }
#line 22084 "parser.c" /* yacc.c:1652  */
    break;

  case 1852:
#line 12579 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 22090 "parser.c" /* yacc.c:1652  */
    break;

  case 1853:
#line 12581 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 22096 "parser.c" /* yacc.c:1652  */
    break;

  case 1854:
#line 12586 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	eval_check[eval_level][eval_inc++] = yyvsp[0];
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22111 "parser.c" /* yacc.c:1652  */
    break;

  case 1855:
#line 12597 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_true;
	eval_check[eval_level][eval_inc++] = NULL;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22126 "parser.c" /* yacc.c:1652  */
    break;

  case 1856:
#line 12608 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_false;
	eval_check[eval_level][eval_inc++] = cb_false;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22141 "parser.c" /* yacc.c:1652  */
    break;

  case 1857:
#line 12622 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 22153 "parser.c" /* yacc.c:1652  */
    break;

  case 1858:
#line 12631 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22161 "parser.c" /* yacc.c:1652  */
    break;

  case 1859:
#line 12637 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 22167 "parser.c" /* yacc.c:1652  */
    break;

  case 1860:
#line 12639 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 22173 "parser.c" /* yacc.c:1652  */
    break;

  case 1861:
#line 12645 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_CHAIN (yyvsp[0], yyvsp[-1]);
	eval_inc2 = 0;
  }
#line 22182 "parser.c" /* yacc.c:1652  */
    break;

  case 1862:
#line 12650 "parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	yyval = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), yyvsp[-1]);
  }
#line 22196 "parser.c" /* yacc.c:1652  */
    break;

  case 1863:
#line 12660 "parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	yyval = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), yyvsp[-1]);
  }
#line 22209 "parser.c" /* yacc.c:1652  */
    break;

  case 1864:
#line 12673 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_CHAIN (yyvsp[0], NULL);
	eval_inc2 = 0;
  }
#line 22218 "parser.c" /* yacc.c:1652  */
    break;

  case 1865:
#line 12678 "parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	yyval = NULL;
  }
#line 22232 "parser.c" /* yacc.c:1652  */
    break;

  case 1866:
#line 12688 "parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	yyval = NULL;
  }
#line 22245 "parser.c" /* yacc.c:1652  */
    break;

  case 1867:
#line 12700 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 22253 "parser.c" /* yacc.c:1652  */
    break;

  case 1868:
#line 12704 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
	restore_backup_pos (yyval);
	eval_inc2 = 0;
  }
#line 22263 "parser.c" /* yacc.c:1652  */
    break;

  case 1869:
#line 12711 "parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 22271 "parser.c" /* yacc.c:1652  */
    break;

  case 1870:
#line 12715 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-3], yyvsp[0]);
	restore_backup_pos (yyval);
	eval_inc2 = 0;
  }
#line 22281 "parser.c" /* yacc.c:1652  */
    break;

  case 1871:
#line 12723 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 22287 "parser.c" /* yacc.c:1652  */
    break;

  case 1872:
#line 12725 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 22293 "parser.c" /* yacc.c:1652  */
    break;

  case 1873:
#line 12730 "parser.y" /* yacc.c:1652  */
    {
	cb_tree	not0;
	cb_tree	e1;
	cb_tree	e2;
	cb_tree	x;
	cb_tree	parm1;

	not0 = cb_int0;
	e2 = yyvsp[0];
	x = NULL;
	parm1 = yyvsp[-1];
	if (eval_check[eval_level][eval_inc2]
	 && eval_check[eval_level][eval_inc2] != cb_false) {
		/* Check if the first token is NOT */
		/* It may belong to the EVALUATE, however see */
		/* below when it may be part of a partial expression */
		if (CB_PURPOSE_INT (parm1) == '!') {
			/* Pop stack if subject not TRUE / FALSE */
			not0 = cb_int1;
			x = parm1;
			parm1 = CB_CHAIN (parm1);
		}
		/* Partial expression handling */
		switch (CB_PURPOSE_INT (parm1)) {
		/* Relational conditions */
		case '<':
		case '>':
		case '[':
		case ']':
		case '~':
		case '=':
		/* Class conditions */
		case '9':
		case 'A':
		case 'L':
		case 'U':
		case 'P':
		case 'N':
		case 'O':
		case 'C':
			if (e2) {
				cb_error_x (e2, _("invalid THROUGH usage"));
				e2 = NULL;
			}
			not0 = CB_PURPOSE (parm1);
			if (x) {
				/* Rebind the NOT to the partial expression */
				parm1 = cb_build_list (cb_int ('!'), NULL, parm1);
			}
			/* Insert subject at head of list */
			parm1 = cb_build_list (cb_int ('x'),
					    eval_check[eval_level][eval_inc2], parm1);
			break;
		}
	}

	/* Build expr now */
	e1 = cb_build_expr (parm1);

	eval_inc2++;
	yyval = CB_BUILD_PAIR (not0, CB_BUILD_PAIR (e1, e2));

	if (eval_check[eval_level][eval_inc2-1] == cb_false) {
		/* It was  EVALUATE FALSE; So flip condition */
		if (e1 == cb_true)
			e1 = cb_false;
		else if (e1 == cb_false)
			e1 = cb_true;
	}
	cb_terminate_cond ();
	cb_end_cond (e1);
	cb_save_cond ();
	cb_true_side ();
  }
#line 22372 "parser.c" /* yacc.c:1652  */
    break;

  case 1874:
#line 12804 "parser.y" /* yacc.c:1652  */
    { yyval = cb_any; eval_inc2++; }
#line 22378 "parser.c" /* yacc.c:1652  */
    break;

  case 1875:
#line 12805 "parser.y" /* yacc.c:1652  */
    { yyval = cb_true; eval_inc2++; }
#line 22384 "parser.c" /* yacc.c:1652  */
    break;

  case 1876:
#line 12806 "parser.y" /* yacc.c:1652  */
    { yyval = cb_false; eval_inc2++; }
#line 22390 "parser.c" /* yacc.c:1652  */
    break;

  case 1877:
#line 12807 "parser.y" /* yacc.c:1652  */
    { yyval = cb_error_node; eval_inc2++; }
#line 22396 "parser.c" /* yacc.c:1652  */
    break;

  case 1878:
#line 12811 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22402 "parser.c" /* yacc.c:1652  */
    break;

  case 1879:
#line 12812 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 22408 "parser.c" /* yacc.c:1652  */
    break;

  case 1880:
#line 12817 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], EVALUATE);
  }
#line 22416 "parser.c" /* yacc.c:1652  */
    break;

  case 1881:
#line 12821 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], EVALUATE);
  }
#line 22424 "parser.c" /* yacc.c:1652  */
    break;

  case 1882:
#line 12830 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("EXHIBIT", 0);
	line_column = NULL;
	cobc_cs_check = CB_CS_EXHIBIT;
  }
#line 22434 "parser.c" /* yacc.c:1652  */
    break;

  case 1883:
#line 12836 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 22442 "parser.c" /* yacc.c:1652  */
    break;

  case 1884:
#line 12843 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] || !yyvsp[-1]) {
		exhibit_named = 1;
		advancing_value = cb_int1;
	} else {
		exhibit_named = 0;
	}
	if (yyvsp[-1]) {
		exhibit_changed = 1;
		/* TODO: feature for a later version (needs temporary fields,
		   one per target, but not duplicated between multiple EXHIBIT) */
		CB_PENDING ("EXHIBIT CHANGED");
		/* note: literals are _always_ displayed, unchanged are replaced
		         by spaces in full length (including the possible NAMED part) */
	} else {
		exhibit_changed = 0;
	}
  }
#line 22465 "parser.c" /* yacc.c:1652  */
    break;

  case 1885:
#line 12862 "parser.y" /* yacc.c:1652  */
    {
	/* note: position-specifier, ERASE and UPON are MS-COBOL extensions,
	         but we won't add an extra dialect option for this - if wanted
			 we can add one for the position-specifier and use that for
			 those clauses, too */
	if (upon_value != NULL) {
		/* TODO: come back to this MS-COBOL feature later */
		CB_PENDING ("EXHIBIT UPON");
	}
	if (yyvsp[-2] != NULL) {
		attach_attrib_to_cur_stmt ();
		current_statement->attr_ptr->dispattrs = COB_SCREEN_ERASE_EOS;
	}
	/* note: while MF does not do this, OSVS had empty line suppression for
	         CHANGED - do the same ... later */
	cb_emit_display (yyvsp[-1], NULL, cb_int1, line_column,
			 current_statement->attr_ptr,
			 0, DEVICE_DISPLAY);
  }
#line 22489 "parser.c" /* yacc.c:1652  */
    break;

  case 1886:
#line 12883 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22495 "parser.c" /* yacc.c:1652  */
    break;

  case 1887:
#line 12883 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 22501 "parser.c" /* yacc.c:1652  */
    break;

  case 1888:
#line 12884 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22507 "parser.c" /* yacc.c:1652  */
    break;

  case 1889:
#line 12884 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 22513 "parser.c" /* yacc.c:1652  */
    break;

  case 1890:
#line 12888 "parser.y" /* yacc.c:1652  */
    {
	if (exhibit_named && !CB_LITERAL_P (yyvsp[0])) {
		yyval = CB_LIST_INIT (cb_exhbit_literal (yyvsp[0]));
		yyval = cb_list_add (yyval, yyvsp[0]);
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 22526 "parser.c" /* yacc.c:1652  */
    break;

  case 1891:
#line 12897 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], cb_space);
	if (exhibit_named && !CB_LITERAL_P (yyvsp[0])) {
		yyval = cb_list_add (yyval, cb_exhbit_literal (yyvsp[0]));
	}
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 22538 "parser.c" /* yacc.c:1652  */
    break;

  case 1894:
#line 12916 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("EXIT", 0);
	cobc_cs_check = CB_CS_EXIT;
  }
#line 22547 "parser.c" /* yacc.c:1652  */
    break;

  case 1895:
#line 12921 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 22555 "parser.c" /* yacc.c:1652  */
    break;

  case 1896:
#line 12928 "parser.y" /* yacc.c:1652  */
    {
  /* TODO: add warning/error if there's another statement in the paragraph */
  }
#line 22563 "parser.c" /* yacc.c:1652  */
    break;

  case 1897:
#line 12932 "parser.y" /* yacc.c:1652  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_PROGRAM) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM not allowed within a FUNCTION"));
	}
	if (current_program->flag_main) {
		check_unreached = 0;
	} else {
		check_unreached = 1;
	}
	if (yyvsp[0]) {
		if (!current_program->cb_return_code) {
			cb_error_x (yyvsp[0], _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move (yyvsp[0], CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	current_statement->name = (const char *)"EXIT PROGRAM";
	cb_emit_exit (0);
  }
#line 22592 "parser.c" /* yacc.c:1652  */
    break;

  case 1898:
#line 12957 "parser.y" /* yacc.c:1652  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_FUNCTION) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION only allowed within a FUNCTION"));
	}
	check_unreached = 1;
	current_statement->name = (const char *)"EXIT FUNCTION";
	cb_emit_exit (0);
  }
#line 22610 "parser.c" /* yacc.c:1652  */
    break;

  case 1899:
#line 12971 "parser.y" /* yacc.c:1652  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->cycle_label) {
			sprintf (name, "EXIT PERFORM CYCLE %d", cb_id);
			p->cycle_label = cb_build_reference (name);
			plabel = cb_build_label (p->cycle_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM CYCLE";
		cb_emit_goto (CB_LIST_INIT (p->cycle_label), NULL);
		check_unreached = 1;
	}
  }
#line 22637 "parser.c" /* yacc.c:1652  */
    break;

  case 1900:
#line 12994 "parser.y" /* yacc.c:1652  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->exit_label) {
			sprintf (name, "EXIT PERFORM %d", cb_id);
			p->exit_label = cb_build_reference (name);
			plabel = cb_build_label (p->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM";
		cb_emit_goto (CB_LIST_INIT (p->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22664 "parser.c" /* yacc.c:1652  */
    break;

  case 1901:
#line 13017 "parser.y" /* yacc.c:1652  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_section) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT SECTION is only valid with an active SECTION"));
	} else {
		if (!current_section->exit_label) {
			sprintf (name, "EXIT SECTION %d", cb_id);
			current_section->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_section->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT SECTION";
		cb_emit_goto (CB_LIST_INIT (current_section->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22689 "parser.c" /* yacc.c:1652  */
    break;

  case 1902:
#line 13038 "parser.y" /* yacc.c:1652  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_paragraph) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PARAGRAPH is only valid with an active PARAGRAPH"));
	} else {
		if (!current_paragraph->exit_label) {
			sprintf (name, "EXIT PARAGRAPH %d", cb_id);
			current_paragraph->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_paragraph->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PARAGRAPH";
		cb_emit_goto (CB_LIST_INIT (current_paragraph->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22714 "parser.c" /* yacc.c:1652  */
    break;

  case 1903:
#line 13061 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22720 "parser.c" /* yacc.c:1652  */
    break;

  case 1904:
#line 13064 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 22726 "parser.c" /* yacc.c:1652  */
    break;

  case 1905:
#line 13072 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("FREE", 0);
	current_statement->flag_no_based = 1;
  }
#line 22735 "parser.c" /* yacc.c:1652  */
    break;

  case 1907:
#line 13081 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_free (yyvsp[0]);
  }
#line 22743 "parser.c" /* yacc.c:1652  */
    break;

  case 1908:
#line 13091 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("GENERATE", 0);
  }
#line 22751 "parser.c" /* yacc.c:1652  */
    break;

  case 1910:
#line 13100 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_generate (yyvsp[0]);
	}
  }
#line 22762 "parser.c" /* yacc.c:1652  */
    break;

  case 1911:
#line 13112 "parser.y" /* yacc.c:1652  */
    {
	if (!current_paragraph->flag_statement) {
		current_paragraph->flag_first_is_goto = 1;
	}
	begin_statement ("GO TO", 0);
	save_debug = start_debug;
	start_debug = 0;
  }
#line 22775 "parser.c" /* yacc.c:1652  */
    break;

  case 1913:
#line 13125 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_goto (yyvsp[-1], yyvsp[0]);
	start_debug = save_debug;
  }
#line 22784 "parser.c" /* yacc.c:1652  */
    break;

  case 1914:
#line 13130 "parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		cb_emit_goto_entry (yyvsp[-1], yyvsp[0]);
	}
	start_debug = save_debug;
  }
#line 22795 "parser.c" /* yacc.c:1652  */
    break;

  case 1915:
#line 13140 "parser.y" /* yacc.c:1652  */
    {
	check_unreached = 1;
	yyval = NULL;
  }
#line 22804 "parser.c" /* yacc.c:1652  */
    break;

  case 1916:
#line 13145 "parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	yyval = yyvsp[0];
  }
#line 22813 "parser.c" /* yacc.c:1652  */
    break;

  case 1917:
#line 13156 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("GOBACK", 0);
	check_unreached = 1;
	if (yyvsp[0]) {
		if (!current_program->cb_return_code) {
			cb_error_x (yyvsp[0], _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move (yyvsp[0], CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	cb_emit_exit (1U);
  }
#line 22830 "parser.c" /* yacc.c:1652  */
    break;

  case 1918:
#line 13175 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("IF", TERM_IF);
  }
#line 22838 "parser.c" /* yacc.c:1652  */
    break;

  case 1920:
#line 13184 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (5)], yyvsp[-3], yyvsp[0]);
  }
#line 22846 "parser.c" /* yacc.c:1652  */
    break;

  case 1921:
#line 13188 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (3)], NULL, yyvsp[0]);
	cb_verify (cb_missing_statement,
		_("IF without imperative statement"));
  }
#line 22856 "parser.c" /* yacc.c:1652  */
    break;

  case 1922:
#line 13194 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (2)], yyvsp[0], NULL);
  }
#line 22864 "parser.c" /* yacc.c:1652  */
    break;

  case 1923:
#line 13200 "parser.y" /* yacc.c:1652  */
    {
	cb_save_cond ();
  }
#line 22872 "parser.c" /* yacc.c:1652  */
    break;

  case 1924:
#line 13204 "parser.y" /* yacc.c:1652  */
    {
	cb_save_cond ();
  }
#line 22880 "parser.c" /* yacc.c:1652  */
    break;

  case 1925:
#line 13210 "parser.y" /* yacc.c:1652  */
    {
	cb_true_side ();
  }
#line 22888 "parser.c" /* yacc.c:1652  */
    break;

  case 1926:
#line 13216 "parser.y" /* yacc.c:1652  */
    {
	cb_false_side ();
  }
#line 22896 "parser.c" /* yacc.c:1652  */
    break;

  case 1927:
#line 13223 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-4) - (0)], IF);
	cb_terminate_cond ();
  }
#line 22905 "parser.c" /* yacc.c:1652  */
    break;

  case 1928:
#line 13228 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-4) - (1)], IF);
	cb_terminate_cond ();
  }
#line 22914 "parser.c" /* yacc.c:1652  */
    break;

  case 1929:
#line 13239 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INITIALIZE", 0);
  }
#line 22922 "parser.c" /* yacc.c:1652  */
    break;

  case 1931:
#line 13248 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_initialize (yyvsp[-4], yyvsp[-3], yyvsp[-2], yyvsp[-1], yyvsp[0]);
  }
#line 22930 "parser.c" /* yacc.c:1652  */
    break;

  case 1932:
#line 13254 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22936 "parser.c" /* yacc.c:1652  */
    break;

  case 1933:
#line 13255 "parser.y" /* yacc.c:1652  */
    { yyval = cb_true; }
#line 22942 "parser.c" /* yacc.c:1652  */
    break;

  case 1934:
#line 13259 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22948 "parser.c" /* yacc.c:1652  */
    break;

  case 1935:
#line 13260 "parser.y" /* yacc.c:1652  */
    { yyval = cb_true; }
#line 22954 "parser.c" /* yacc.c:1652  */
    break;

  case 1936:
#line 13261 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-2]; }
#line 22960 "parser.c" /* yacc.c:1652  */
    break;

  case 1937:
#line 13266 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 22968 "parser.c" /* yacc.c:1652  */
    break;

  case 1938:
#line 13270 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22976 "parser.c" /* yacc.c:1652  */
    break;

  case 1939:
#line 13277 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22984 "parser.c" /* yacc.c:1652  */
    break;

  case 1940:
#line 13282 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
  }
#line 22992 "parser.c" /* yacc.c:1652  */
    break;

  case 1941:
#line 13289 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-3], yyvsp[0]);
  }
#line 23000 "parser.c" /* yacc.c:1652  */
    break;

  case 1942:
#line 13295 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHABETIC); }
#line 23006 "parser.c" /* yacc.c:1652  */
    break;

  case 1943:
#line 13296 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHANUMERIC); }
#line 23012 "parser.c" /* yacc.c:1652  */
    break;

  case 1944:
#line 13297 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NUMERIC); }
#line 23018 "parser.c" /* yacc.c:1652  */
    break;

  case 1945:
#line 13298 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHANUMERIC_EDITED); }
#line 23024 "parser.c" /* yacc.c:1652  */
    break;

  case 1946:
#line 13299 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NUMERIC_EDITED); }
#line 23030 "parser.c" /* yacc.c:1652  */
    break;

  case 1947:
#line 13300 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NATIONAL); }
#line 23036 "parser.c" /* yacc.c:1652  */
    break;

  case 1948:
#line 13301 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NATIONAL_EDITED); }
#line 23042 "parser.c" /* yacc.c:1652  */
    break;

  case 1949:
#line 13313 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 23050 "parser.c" /* yacc.c:1652  */
    break;

  case 1950:
#line 13317 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_true;
  }
#line 23058 "parser.c" /* yacc.c:1652  */
    break;

  case 1951:
#line 13326 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INITIATE", 0);
  }
#line 23066 "parser.c" /* yacc.c:1652  */
    break;

  case 1953:
#line 13334 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_initiate (yyvsp[0]);
	}
  }
#line 23077 "parser.c" /* yacc.c:1652  */
    break;

  case 1954:
#line 13341 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_initiate (yyvsp[0]);
	}
  }
#line 23088 "parser.c" /* yacc.c:1652  */
    break;

  case 1955:
#line 13353 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INQUIRE", 0);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 23097 "parser.c" /* yacc.c:1652  */
    break;

  case 1956:
#line 13358 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 23105 "parser.c" /* yacc.c:1652  */
    break;

  case 1959:
#line 13372 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INSPECT", 0);
	inspect_keyword = 0;
  }
#line 23114 "parser.c" /* yacc.c:1652  */
    break;

  case 1969:
#line 13400 "parser.y" /* yacc.c:1652  */
    {
	previous_tallying_phrase = NO_PHRASE;
	cb_init_tallying ();
  }
#line 23123 "parser.c" /* yacc.c:1652  */
    break;

  case 1970:
#line 13405 "parser.y" /* yacc.c:1652  */
    {
	if (!(previous_tallying_phrase == CHARACTERS_PHRASE
	      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
		cb_error (_("TALLYING clause is incomplete"));
	} else {
		cb_emit_inspect (yyvsp[-3], yyvsp[0], TALLYING_CLAUSE);
	}

	yyval = yyvsp[-3];
  }
#line 23138 "parser.c" /* yacc.c:1652  */
    break;

  case 1971:
#line 13421 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_inspect (yyvsp[-2], yyvsp[0], REPLACING_CLAUSE);
	inspect_keyword = 0;
  }
#line 23147 "parser.c" /* yacc.c:1652  */
    break;

  case 1972:
#line 13431 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x = cb_build_converting (yyvsp[-3], yyvsp[-1], yyvsp[0]);
	cb_emit_inspect (yyvsp[-5], x, CONVERTING_CLAUSE);
  }
#line 23156 "parser.c" /* yacc.c:1652  */
    break;

  case 1973:
#line 13439 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23164 "parser.c" /* yacc.c:1652  */
    break;

  case 1974:
#line 13443 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
  }
#line 23172 "parser.c" /* yacc.c:1652  */
    break;

  case 1975:
#line 13450 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (FOR_PHRASE);
	yyval = cb_build_tallying_data (yyvsp[-1]);
  }
#line 23181 "parser.c" /* yacc.c:1652  */
    break;

  case 1976:
#line 13455 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (CHARACTERS_PHRASE);
	yyval = cb_build_tallying_characters (yyvsp[0]);
  }
#line 23190 "parser.c" /* yacc.c:1652  */
    break;

  case 1977:
#line 13460 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_all ();
  }
#line 23199 "parser.c" /* yacc.c:1652  */
    break;

  case 1978:
#line 13465 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_leading ();
  }
#line 23208 "parser.c" /* yacc.c:1652  */
    break;

  case 1979:
#line 13470 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_trailing ();
  }
#line 23217 "parser.c" /* yacc.c:1652  */
    break;

  case 1980:
#line 13475 "parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (VALUE_REGION_PHRASE);
	yyval = cb_build_tallying_value (yyvsp[-1], yyvsp[0]);
  }
#line 23226 "parser.c" /* yacc.c:1652  */
    break;

  case 1981:
#line 13482 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23232 "parser.c" /* yacc.c:1652  */
    break;

  case 1982:
#line 13483 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 23238 "parser.c" /* yacc.c:1652  */
    break;

  case 1983:
#line 13488 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_replacing_characters (yyvsp[-1], yyvsp[0]);
	inspect_keyword = 0;
  }
#line 23247 "parser.c" /* yacc.c:1652  */
    break;

  case 1984:
#line 13493 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23255 "parser.c" /* yacc.c:1652  */
    break;

  case 1986:
#line 13500 "parser.y" /* yacc.c:1652  */
    { inspect_keyword = 1; }
#line 23261 "parser.c" /* yacc.c:1652  */
    break;

  case 1987:
#line 13501 "parser.y" /* yacc.c:1652  */
    { inspect_keyword = 2; }
#line 23267 "parser.c" /* yacc.c:1652  */
    break;

  case 1988:
#line 13502 "parser.y" /* yacc.c:1652  */
    { inspect_keyword = 3; }
#line 23273 "parser.c" /* yacc.c:1652  */
    break;

  case 1989:
#line 13503 "parser.y" /* yacc.c:1652  */
    { inspect_keyword = 4; }
#line 23279 "parser.c" /* yacc.c:1652  */
    break;

  case 1990:
#line 13508 "parser.y" /* yacc.c:1652  */
    {
	switch (inspect_keyword) {
		case 1:
			yyval = cb_build_replacing_all (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 2:
			yyval = cb_build_replacing_leading (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 3:
			yyval = cb_build_replacing_first (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 4:
			yyval = cb_build_replacing_trailing (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		default:
			cb_error_x (CB_TREE (current_statement),
				    _("INSPECT missing ALL/FIRST/LEADING/TRAILING"));
			yyval = cb_build_replacing_all (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
	}
  }
#line 23305 "parser.c" /* yacc.c:1652  */
    break;

  case 1991:
#line 13535 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_inspect_region_start ();
  }
#line 23313 "parser.c" /* yacc.c:1652  */
    break;

  case 1992:
#line 13539 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_build_inspect_region_start (), yyvsp[0]);
  }
#line 23321 "parser.c" /* yacc.c:1652  */
    break;

  case 1993:
#line 13543 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_build_inspect_region_start (), yyvsp[0]);
  }
#line 23329 "parser.c" /* yacc.c:1652  */
    break;

  case 1994:
#line 13547 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_list_add (cb_build_inspect_region_start (), yyvsp[-1]), yyvsp[0]);
  }
#line 23337 "parser.c" /* yacc.c:1652  */
    break;

  case 1995:
#line 13551 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_list_add (cb_build_inspect_region_start (), yyvsp[-1]), yyvsp[0]);
  }
#line 23345 "parser.c" /* yacc.c:1652  */
    break;

  case 1996:
#line 13558 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_FUNCALL_1 ("cob_inspect_before", yyvsp[0]);
  }
#line 23353 "parser.c" /* yacc.c:1652  */
    break;

  case 1997:
#line 13565 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_FUNCALL_1 ("cob_inspect_after", yyvsp[0]);
  }
#line 23361 "parser.c" /* yacc.c:1652  */
    break;

  case 1998:
#line 13574 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("JSON GENERATE", TERM_JSON);
	cobc_in_json_generate_body = 1;
	cobc_cs_check = CB_CS_JSON_GENERATE;
  }
#line 23371 "parser.c" /* yacc.c:1652  */
    break;

  case 2000:
#line 13586 "parser.y" /* yacc.c:1652  */
    {
	ml_suppress_list = NULL;
  }
#line 23379 "parser.c" /* yacc.c:1652  */
    break;

  case 2001:
#line 13591 "parser.y" /* yacc.c:1652  */
    {
	cobc_in_json_generate_body = 0;
	cobc_cs_check = 0;
  }
#line 23388 "parser.c" /* yacc.c:1652  */
    break;

  case 2002:
#line 13596 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_json_generate (yyvsp[-8], yyvsp[-6], yyvsp[-5], yyvsp[-3], ml_suppress_list);
  }
#line 23396 "parser.c" /* yacc.c:1652  */
    break;

  case 2003:
#line 13603 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 23404 "parser.c" /* yacc.c:1652  */
    break;

  case 2004:
#line 13607 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23412 "parser.c" /* yacc.c:1652  */
    break;

  case 2007:
#line 13619 "parser.y" /* yacc.c:1652  */
    {
	error_if_following_every_clause ();
	add_identifier_to_ml_suppress_conds (yyvsp[0]);
  }
#line 23421 "parser.c" /* yacc.c:1652  */
    break;

  case 2008:
#line 13627 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], JSON);
  }
#line 23429 "parser.c" /* yacc.c:1652  */
    break;

  case 2009:
#line 13631 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], JSON);
  }
#line 23437 "parser.c" /* yacc.c:1652  */
    break;

  case 2010:
#line 13640 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("JSON PARSE", TERM_JSON);
	CB_PENDING (_("JSON PARSE"));
  }
#line 23446 "parser.c" /* yacc.c:1652  */
    break;

  case 2015:
#line 13665 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MERGE", 0);
	current_statement->flag_merge = 1;
  }
#line 23455 "parser.c" /* yacc.c:1652  */
    break;

  case 2017:
#line 13677 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MODIFY", TERM_MODIFY);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 23464 "parser.c" /* yacc.c:1652  */
    break;

  case 2018:
#line 13683 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 23472 "parser.c" /* yacc.c:1652  */
    break;

  case 2021:
#line 13695 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], MODIFY);
  }
#line 23480 "parser.c" /* yacc.c:1652  */
    break;

  case 2022:
#line 13699 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], MODIFY);
  }
#line 23488 "parser.c" /* yacc.c:1652  */
    break;

  case 2023:
#line 13709 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MOVE", 0);
  }
#line 23496 "parser.c" /* yacc.c:1652  */
    break;

  case 2025:
#line 13717 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_move (yyvsp[-2], yyvsp[0]);
  }
#line 23504 "parser.c" /* yacc.c:1652  */
    break;

  case 2026:
#line 13721 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_move_corresponding (yyvsp[-2], yyvsp[0]);
  }
#line 23512 "parser.c" /* yacc.c:1652  */
    break;

  case 2027:
#line 13731 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MULTIPLY", TERM_MULTIPLY);
  }
#line 23520 "parser.c" /* yacc.c:1652  */
    break;

  case 2029:
#line 13740 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '*', yyvsp[-3]);
  }
#line 23528 "parser.c" /* yacc.c:1652  */
    break;

  case 2030:
#line 13744 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-5], '*', yyvsp[-3]));
  }
#line 23536 "parser.c" /* yacc.c:1652  */
    break;

  case 2031:
#line 13751 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], MULTIPLY);
  }
#line 23544 "parser.c" /* yacc.c:1652  */
    break;

  case 2032:
#line 13755 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], MULTIPLY);
  }
#line 23552 "parser.c" /* yacc.c:1652  */
    break;

  case 2033:
#line 13765 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("OPEN", 0);
	cobc_cs_check = CB_CS_OPEN;
  }
#line 23561 "parser.c" /* yacc.c:1652  */
    break;

  case 2037:
#line 13779 "parser.y" /* yacc.c:1652  */
    {
	cb_tree l;
	cb_tree x;

	if ((yyvsp[-5] && yyvsp[-3]) || (yyvsp[-5] && yyvsp[0]) || (yyvsp[-3] && yyvsp[0])) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s and %s are mutually exclusive"), "SHARING", _("LOCK clauses"));
	}
	if (yyvsp[0]) {
		x = yyvsp[0];
	} else if (yyvsp[-3]) {
		x = yyvsp[-3];
	} else {
		x = yyvsp[-5];
	}

	for (l = yyvsp[-1]; l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			begin_implicit_statement ();
			cb_emit_open (CB_VALUE (l), yyvsp[-4], x);
		}
	}
  }
#line 23589 "parser.c" /* yacc.c:1652  */
    break;

  case 2038:
#line 13806 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23595 "parser.c" /* yacc.c:1652  */
    break;

  case 2039:
#line 13807 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23601 "parser.c" /* yacc.c:1652  */
    break;

  case 2040:
#line 13811 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_INPUT); }
#line 23607 "parser.c" /* yacc.c:1652  */
    break;

  case 2041:
#line 13812 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_OUTPUT); }
#line 23613 "parser.c" /* yacc.c:1652  */
    break;

  case 2042:
#line 13813 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_I_O); }
#line 23619 "parser.c" /* yacc.c:1652  */
    break;

  case 2043:
#line 13814 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_EXTEND); }
#line 23625 "parser.c" /* yacc.c:1652  */
    break;

  case 2044:
#line 13818 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23631 "parser.c" /* yacc.c:1652  */
    break;

  case 2045:
#line 13819 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23637 "parser.c" /* yacc.c:1652  */
    break;

  case 2046:
#line 13823 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23643 "parser.c" /* yacc.c:1652  */
    break;

  case 2047:
#line 13824 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23649 "parser.c" /* yacc.c:1652  */
    break;

  case 2048:
#line 13825 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23655 "parser.c" /* yacc.c:1652  */
    break;

  case 2049:
#line 13829 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 23661 "parser.c" /* yacc.c:1652  */
    break;

  case 2050:
#line 13831 "parser.y" /* yacc.c:1652  */
    {
	  (void)cb_verify (CB_OBSOLETE, "OPEN LEAVE/REREAD/DISP");
	  yyval = NULL;
  }
#line 23670 "parser.c" /* yacc.c:1652  */
    break;

  case 2051:
#line 13838 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23676 "parser.c" /* yacc.c:1652  */
    break;

  case 2052:
#line 13839 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23682 "parser.c" /* yacc.c:1652  */
    break;

  case 2053:
#line 13843 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23688 "parser.c" /* yacc.c:1652  */
    break;

  case 2054:
#line 13845 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH MASS-UPDATE");
  }
#line 23698 "parser.c" /* yacc.c:1652  */
    break;

  case 2055:
#line 13851 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH BULK-ADDITION");
  }
#line 23708 "parser.c" /* yacc.c:1652  */
    break;

  case 2056:
#line 13859 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23714 "parser.c" /* yacc.c:1652  */
    break;

  case 2057:
#line 13860 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23720 "parser.c" /* yacc.c:1652  */
    break;

  case 2058:
#line 13861 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23726 "parser.c" /* yacc.c:1652  */
    break;

  case 2062:
#line 13873 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: only allow for sequential files */
	/* FIXME: only allow with INPUT or OUTPUT */
	CB_PENDING ("OPEN WITH NO REWIND");
	yyval = NULL;
  }
#line 23737 "parser.c" /* yacc.c:1652  */
    break;

  case 2063:
#line 13880 "parser.y" /* yacc.c:1652  */
    {
	/* FIXME: only allow for sequential / line-sequential files */
	/* FIXME: only allow with INPUT */
	/* FIXME: add actual compiler configuration */
	if (cb_warn_opt_val[cb_warn_obsolete] == COBC_WARN_AS_ERROR) {
		(void)cb_verify (CB_OBSOLETE, "OPEN REVERSED");
	} else {
		/* FIXME: set file attribute */
		CB_PENDING ("OPEN REVERSED");
	};
	yyval = NULL;
  }
#line 23754 "parser.c" /* yacc.c:1652  */
    break;

  case 2067:
#line 13903 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("PERFORM", TERM_PERFORM);
	/* Turn off field debug - PERFORM is special */
	save_debug = start_debug;
	start_debug = 0;
	cobc_cs_check = CB_CS_PERFORM;
  }
#line 23766 "parser.c" /* yacc.c:1652  */
    break;

  case 2069:
#line 13918 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_perform (yyvsp[0], yyvsp[-2], yyvsp[-3], yyvsp[-1]);
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23776 "parser.c" /* yacc.c:1652  */
    break;

  case 2070:
#line 13926 "parser.y" /* yacc.c:1652  */
    {
	CB_ADD_TO_CHAIN (yyvsp[-1], perform_stack);
	/* Restore field debug before inline statements */
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23787 "parser.c" /* yacc.c:1652  */
    break;

  case 2071:
#line 13933 "parser.y" /* yacc.c:1652  */
    {
	perform_stack = CB_CHAIN (perform_stack);
	cb_emit_perform (yyvsp[-4], yyvsp[-1], yyvsp[-5], yyvsp[-3]);
  }
#line 23796 "parser.c" /* yacc.c:1652  */
    break;

  case 2072:
#line 13940 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_missing_statement,
		_("inline PERFORM without imperative statement"));
  }
#line 23805 "parser.c" /* yacc.c:1652  */
    break;

  case 2073:
#line 13945 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_perform (yyvsp[-3], NULL, yyvsp[-4], yyvsp[-2]);
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23815 "parser.c" /* yacc.c:1652  */
    break;

  case 2074:
#line 13954 "parser.y" /* yacc.c:1652  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING (yyvsp[(-6) - (0)], PERFORM);
	} else {
		TERMINATOR_ERROR (yyvsp[(-6) - (0)], PERFORM);
	}
  }
#line 23827 "parser.c" /* yacc.c:1652  */
    break;

  case 2075:
#line 13962 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-6) - (1)], PERFORM);
  }
#line 23835 "parser.c" /* yacc.c:1652  */
    break;

  case 2076:
#line 13969 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-3) - (1)], PERFORM);
  }
#line 23843 "parser.c" /* yacc.c:1652  */
    break;

  case 2077:
#line 13973 "parser.y" /* yacc.c:1652  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING (yyvsp[(-3) - (1)], PERFORM);
	} else {
		TERMINATOR_ERROR (yyvsp[(-3) - (1)], PERFORM);
	}
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
  }
#line 23857 "parser.c" /* yacc.c:1652  */
    break;

  case 2078:
#line 13986 "parser.y" /* yacc.c:1652  */
    {
	/* Return from $1 */
	CB_REFERENCE (yyvsp[0])->length = cb_true;
	CB_REFERENCE (yyvsp[0])->flag_decl_ok = 1;
	yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[0]);
  }
#line 23868 "parser.c" /* yacc.c:1652  */
    break;

  case 2079:
#line 13993 "parser.y" /* yacc.c:1652  */
    {
	/* Return from $3 */
	CB_REFERENCE (yyvsp[0])->length = cb_true;
	CB_REFERENCE (yyvsp[-2])->flag_decl_ok = 1;
	CB_REFERENCE (yyvsp[0])->flag_decl_ok = 1;
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 23880 "parser.c" /* yacc.c:1652  */
    break;

  case 2080:
#line 14004 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_once (NULL);
  }
#line 23888 "parser.c" /* yacc.c:1652  */
    break;

  case 2081:
#line 14008 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_times (yyvsp[-1]);
	current_program->loop_counter++;
  }
#line 23897 "parser.c" /* yacc.c:1652  */
    break;

  case 2082:
#line 14013 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_forever (NULL);
  }
#line 23905 "parser.c" /* yacc.c:1652  */
    break;

  case 2083:
#line 14017 "parser.y" /* yacc.c:1652  */
    {
	cb_tree varying;

	if (!yyvsp[0]) {
		yyval = cb_build_perform_forever (NULL);
	} else {
		if (yyvsp[-2] == CB_AFTER)
			cb_build_perform_after_until();
		varying = CB_LIST_INIT (cb_build_perform_varying (NULL, NULL, NULL, yyvsp[0]));
		yyval = cb_build_perform_until (yyvsp[-2], varying);
	}
  }
#line 23922 "parser.c" /* yacc.c:1652  */
    break;

  case 2084:
#line 14030 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_until (yyvsp[-2], yyvsp[0]);
  }
#line 23930 "parser.c" /* yacc.c:1652  */
    break;

  case 2085:
#line 14036 "parser.y" /* yacc.c:1652  */
    { yyval = CB_BEFORE; }
#line 23936 "parser.c" /* yacc.c:1652  */
    break;

  case 2086:
#line 14037 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23942 "parser.c" /* yacc.c:1652  */
    break;

  case 2087:
#line 14041 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23948 "parser.c" /* yacc.c:1652  */
    break;

  case 2088:
#line 14042 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23954 "parser.c" /* yacc.c:1652  */
    break;

  case 2089:
#line 14045 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 23960 "parser.c" /* yacc.c:1652  */
    break;

  case 2090:
#line 14047 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 23966 "parser.c" /* yacc.c:1652  */
    break;

  case 2091:
#line 14052 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;
	int		data_type_ok = 1;

	if (yyvsp[-5] != cb_error_node
	 && yyvsp[-3] != cb_error_node
	 && yyvsp[-2] != cb_error_node) {

		if (cb_tree_category (yyvsp[-5]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-5]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category (yyvsp[-3]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-3]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category (yyvsp[-2]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-2]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}

		if (data_type_ok) {
			yyval = cb_build_perform_varying (yyvsp[-5], yyvsp[-3], yyvsp[-2], yyvsp[0]);
		}
	}
  }
#line 24009 "parser.c" /* yacc.c:1652  */
    break;

  case 2092:
#line 14094 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_perform_varying_without_by, _("PERFORM VARYING without BY phrase"));
	yyval = cb_build_numeric_literal (0, "1", 0);
  }
#line 24018 "parser.c" /* yacc.c:1652  */
    break;

  case 2093:
#line 14099 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24026 "parser.c" /* yacc.c:1652  */
    break;

  case 2094:
#line 14108 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("PURGE", 0);
  }
#line 24034 "parser.c" /* yacc.c:1652  */
    break;

  case 2095:
#line 14112 "parser.y" /* yacc.c:1652  */
    {
  }
#line 24041 "parser.c" /* yacc.c:1652  */
    break;

  case 2096:
#line 14120 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RAISE", 0);
  }
#line 24049 "parser.c" /* yacc.c:1652  */
    break;

  case 2098:
#line 14128 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RAISE statement");
	/* TODO: check for level 3 error here */
  }
#line 24058 "parser.c" /* yacc.c:1652  */
    break;

  case 2099:
#line 14133 "parser.y" /* yacc.c:1652  */
    {
	/* easy cheating here as we don't have any OO in */
	cb_error(_("'%s' is not an object-reference"), cb_name (yyvsp[0]));
  }
#line 24067 "parser.c" /* yacc.c:1652  */
    break;

  case 2100:
#line 14143 "parser.y" /* yacc.c:1652  */
    {
	/* TODO:
	cb_tree exception = get_exception (CB_NAME($1));
	if (!exception) {
		cb_error (_("'%s' is not an exception-name"), CB_NAME ($1));
	}
	*/
  }
#line 24080 "parser.c" /* yacc.c:1652  */
    break;

  case 2101:
#line 14157 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("READ", TERM_READ);
	cobc_cs_check = CB_CS_READ;
  }
#line 24089 "parser.c" /* yacc.c:1652  */
    break;

  case 2103:
#line 14167 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;

	if (CB_VALID_TREE (yyvsp[-6])) {
		struct cb_file	*cf;

		cf = CB_FILE(cb_ref (yyvsp[-6]));
		if (yyvsp[-2] && (cf->lock_mode & COB_LOCK_AUTOMATIC)) {
			cb_error_x (CB_TREE (current_statement),
				    _("LOCK clause invalid with file LOCK AUTOMATIC"));
		} else if (yyvsp[-1] &&
		      (cf->organization != COB_ORG_RELATIVE &&
		       cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("KEY clause invalid with this file type"));
		} else if (current_statement->handler_type == INVALID_KEY_HANDLER &&
			   (cf->organization != COB_ORG_RELATIVE &&
			    cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("INVALID KEY clause invalid with this file type"));
		} else {
			cb_emit_read (yyvsp[-6], yyvsp[-5], yyvsp[-3], yyvsp[-1], yyvsp[-2]);
		}
	}
  }
#line 24119 "parser.c" /* yacc.c:1652  */
    break;

  case 2104:
#line 14195 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 24125 "parser.c" /* yacc.c:1652  */
    break;

  case 2105:
#line 14196 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 24131 "parser.c" /* yacc.c:1652  */
    break;

  case 2106:
#line 14201 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24139 "parser.c" /* yacc.c:1652  */
    break;

  case 2107:
#line 14205 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int3;
  }
#line 24147 "parser.c" /* yacc.c:1652  */
    break;

  case 2108:
#line 14209 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24155 "parser.c" /* yacc.c:1652  */
    break;

  case 2109:
#line 14213 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24163 "parser.c" /* yacc.c:1652  */
    break;

  case 2112:
#line 14225 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ADVANCING ON LOCK");
  }
#line 24171 "parser.c" /* yacc.c:1652  */
    break;

  case 2116:
#line 14238 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RETRY");
	cobc_cs_check = 0;
  }
#line 24180 "parser.c" /* yacc.c:1652  */
    break;

  case 2122:
#line 14258 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24188 "parser.c" /* yacc.c:1652  */
    break;

  case 2123:
#line 14262 "parser.y" /* yacc.c:1652  */
    {
   yyval = cb_int5;
  }
#line 24196 "parser.c" /* yacc.c:1652  */
    break;

  case 2124:
#line 14266 "parser.y" /* yacc.c:1652  */
    {
	/* TO-DO: Merge with RETRY phrase */
	yyval = cb_int4;
  }
#line 24205 "parser.c" /* yacc.c:1652  */
    break;

  case 2125:
#line 14273 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 24211 "parser.c" /* yacc.c:1652  */
    break;

  case 2126:
#line 14274 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 24217 "parser.c" /* yacc.c:1652  */
    break;

  case 2129:
#line 14284 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], READ);
  }
#line 24225 "parser.c" /* yacc.c:1652  */
    break;

  case 2130:
#line 14288 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], READ);
  }
#line 24233 "parser.c" /* yacc.c:1652  */
    break;

  case 2131:
#line 14298 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("READY TRACE", 0);
	cb_emit_ready_trace ();
  }
#line 24242 "parser.c" /* yacc.c:1652  */
    break;

  case 2132:
#line 14308 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RECEIVE", TERM_RECEIVE);
  }
#line 24250 "parser.c" /* yacc.c:1652  */
    break;

  case 2146:
#line 14351 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], RECEIVE);
  }
#line 24258 "parser.c" /* yacc.c:1652  */
    break;

  case 2147:
#line 14355 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], RECEIVE);
  }
#line 24266 "parser.c" /* yacc.c:1652  */
    break;

  case 2148:
#line 14364 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RELEASE", 0);
  }
#line 24274 "parser.c" /* yacc.c:1652  */
    break;

  case 2150:
#line 14372 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_release (yyvsp[-1], yyvsp[0]);
  }
#line 24282 "parser.c" /* yacc.c:1652  */
    break;

  case 2151:
#line 14382 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RESET TRACE", 0);
	cb_emit_reset_trace ();
  }
#line 24291 "parser.c" /* yacc.c:1652  */
    break;

  case 2152:
#line 14392 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RETURN", TERM_RETURN);
  }
#line 24299 "parser.c" /* yacc.c:1652  */
    break;

  case 2154:
#line 14401 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_return (yyvsp[-3], yyvsp[-1]);
  }
#line 24307 "parser.c" /* yacc.c:1652  */
    break;

  case 2155:
#line 14408 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], RETURN);
  }
#line 24315 "parser.c" /* yacc.c:1652  */
    break;

  case 2156:
#line 14412 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], RETURN);
  }
#line 24323 "parser.c" /* yacc.c:1652  */
    break;

  case 2157:
#line 14422 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("REWRITE", TERM_REWRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 24334 "parser.c" /* yacc.c:1652  */
    break;

  case 2159:
#line 14434 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_rewrite (yyvsp[-4], yyvsp[-3], yyvsp[-1]);
	start_debug = save_debug;
  }
#line 24343 "parser.c" /* yacc.c:1652  */
    break;

  case 2160:
#line 14442 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24351 "parser.c" /* yacc.c:1652  */
    break;

  case 2162:
#line 14450 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 24359 "parser.c" /* yacc.c:1652  */
    break;

  case 2163:
#line 14454 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int2;
  }
#line 24367 "parser.c" /* yacc.c:1652  */
    break;

  case 2164:
#line 14461 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], REWRITE);
  }
#line 24375 "parser.c" /* yacc.c:1652  */
    break;

  case 2165:
#line 14465 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], REWRITE);
  }
#line 24383 "parser.c" /* yacc.c:1652  */
    break;

  case 2166:
#line 14475 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ROLLBACK", 0);
	cb_emit_rollback ();
  }
#line 24392 "parser.c" /* yacc.c:1652  */
    break;

  case 2167:
#line 14486 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SEARCH", TERM_SEARCH);
  }
#line 24400 "parser.c" /* yacc.c:1652  */
    break;

  case 2169:
#line 14495 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_search (yyvsp[-3], yyvsp[-2], yyvsp[-1], yyvsp[0]);
  }
#line 24408 "parser.c" /* yacc.c:1652  */
    break;

  case 2170:
#line 14500 "parser.y" /* yacc.c:1652  */
    {
	current_statement->name = (const char *)"SEARCH ALL";
	cb_emit_search_all (yyvsp[-4], yyvsp[-3], yyvsp[-1], yyvsp[0]);
  }
#line 24417 "parser.c" /* yacc.c:1652  */
    break;

  case 2171:
#line 14507 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 24423 "parser.c" /* yacc.c:1652  */
    break;

  case 2172:
#line 14508 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 24429 "parser.c" /* yacc.c:1652  */
    break;

  case 2173:
#line 14513 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24437 "parser.c" /* yacc.c:1652  */
    break;

  case 2174:
#line 14518 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24445 "parser.c" /* yacc.c:1652  */
    break;

  case 2175:
#line 14525 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 24453 "parser.c" /* yacc.c:1652  */
    break;

  case 2176:
#line 14529 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[0], yyvsp[-1]);
  }
#line 24461 "parser.c" /* yacc.c:1652  */
    break;

  case 2177:
#line 14537 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_if_check_break (yyvsp[-1], yyvsp[0]);
  }
#line 24469 "parser.c" /* yacc.c:1652  */
    break;

  case 2178:
#line 14544 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], SEARCH);
  }
#line 24477 "parser.c" /* yacc.c:1652  */
    break;

  case 2179:
#line 14548 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], SEARCH);
  }
#line 24485 "parser.c" /* yacc.c:1652  */
    break;

  case 2180:
#line 14558 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SEND", 0);
  }
#line 24493 "parser.c" /* yacc.c:1652  */
    break;

  case 2182:
#line 14566 "parser.y" /* yacc.c:1652  */
    {
  }
#line 24500 "parser.c" /* yacc.c:1652  */
    break;

  case 2183:
#line 14569 "parser.y" /* yacc.c:1652  */
    {
  }
#line 24507 "parser.c" /* yacc.c:1652  */
    break;

  case 2186:
#line 14580 "parser.y" /* yacc.c:1652  */
    {
  }
#line 24514 "parser.c" /* yacc.c:1652  */
    break;

  case 2193:
#line 14600 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SET", 0);
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	cobc_cs_check = CB_CS_SET;
  }
#line 24525 "parser.c" /* yacc.c:1652  */
    break;

  case 2194:
#line 14607 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 24533 "parser.c" /* yacc.c:1652  */
    break;

  case 2203:
#line 14624 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 24539 "parser.c" /* yacc.c:1652  */
    break;

  case 2204:
#line 14625 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 24545 "parser.c" /* yacc.c:1652  */
    break;

  case 2205:
#line 14629 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 24551 "parser.c" /* yacc.c:1652  */
    break;

  case 2206:
#line 14630 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 24557 "parser.c" /* yacc.c:1652  */
    break;

  case 2207:
#line 14637 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_setenv (yyvsp[-2], yyvsp[0]);
  }
#line 24565 "parser.c" /* yacc.c:1652  */
    break;

  case 2208:
#line 14646 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_attribute (yyvsp[-2], set_attr_val_on, set_attr_val_off);
  }
#line 24573 "parser.c" /* yacc.c:1652  */
    break;

  case 2211:
#line 14658 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_BELL);
  }
#line 24581 "parser.c" /* yacc.c:1652  */
    break;

  case 2212:
#line 14662 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_BLINK);
  }
#line 24589 "parser.c" /* yacc.c:1652  */
    break;

  case 2213:
#line 14666 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_HIGHLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_HIGHLIGHT);
  }
#line 24599 "parser.c" /* yacc.c:1652  */
    break;

  case 2214:
#line 14672 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_LOWLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_LOWLIGHT);
  }
#line 24609 "parser.c" /* yacc.c:1652  */
    break;

  case 2215:
#line 14678 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_REVERSE);
  }
#line 24617 "parser.c" /* yacc.c:1652  */
    break;

  case 2216:
#line 14682 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_UNDERLINE);
  }
#line 24625 "parser.c" /* yacc.c:1652  */
    break;

  case 2217:
#line 14686 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_LEFTLINE);
  }
#line 24633 "parser.c" /* yacc.c:1652  */
    break;

  case 2218:
#line 14690 "parser.y" /* yacc.c:1652  */
    {
	bit_set_attr (yyvsp[0], COB_SCREEN_OVERLINE);
  }
#line 24641 "parser.c" /* yacc.c:1652  */
    break;

  case 2219:
#line 14699 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_to (yyvsp[-3], cb_build_ppointer (yyvsp[0]));
  }
#line 24649 "parser.c" /* yacc.c:1652  */
    break;

  case 2220:
#line 14703 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_to (yyvsp[-2], yyvsp[0]);
  }
#line 24657 "parser.c" /* yacc.c:1652  */
    break;

  case 2221:
#line 14707 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_move (cb_build_length (yyvsp[0]), yyvsp[-4]);
  }
#line 24665 "parser.c" /* yacc.c:1652  */
    break;

  case 2222:
#line 14716 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_up_down (yyvsp[-3], yyvsp[-2], yyvsp[0]);
  }
#line 24673 "parser.c" /* yacc.c:1652  */
    break;

  case 2225:
#line 14730 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_on_off (yyvsp[-2], yyvsp[0]);
  }
#line 24681 "parser.c" /* yacc.c:1652  */
    break;

  case 2228:
#line 14744 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_true (yyvsp[-2]);
  }
#line 24689 "parser.c" /* yacc.c:1652  */
    break;

  case 2229:
#line 14748 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_false (yyvsp[-2]);
  }
#line 24697 "parser.c" /* yacc.c:1652  */
    break;

  case 2230:
#line 14757 "parser.y" /* yacc.c:1652  */
    {
	  cb_emit_set_last_exception_to_off ();
  }
#line 24705 "parser.c" /* yacc.c:1652  */
    break;

  case 2231:
#line 14766 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_set_thread_priority (yyvsp[-3], yyvsp[0]);
	CB_PENDING ("THREAD");
  }
#line 24714 "parser.c" /* yacc.c:1652  */
    break;

  case 2232:
#line 14777 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SORT", 0);
  }
#line 24722 "parser.c" /* yacc.c:1652  */
    break;

  case 2234:
#line 14785 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x = cb_ref (yyvsp[-3]);

	yyval = NULL;
	if (CB_VALID_TREE (x)) {
		if (yyvsp[-2] == NULL || CB_VALUE(yyvsp[-2]) == NULL) {
			if (CB_FILE_P (x)) {
				cb_error (_("file sort requires KEY phrase"));
				yyvsp[-2] = cb_error_node;
			} else {
				struct cb_field	*f = CB_FIELD_PTR (x);
/* TODO: add compiler configuration cb_sort_without_keys
				if (f->nkeys
				 && cb_verify (cb_sort_without_keys, _("table SORT without keys"))) {
*/
				if (yyvsp[-2] != NULL || f->nkeys) {
					cb_tree lparm;
					if (yyvsp[-2] == NULL) {
						/* create reference to first key */
						x = cb_ref (f->keys[0].key);
					}
					/* use the OCCURS field / its defined KEY as single sort key */
					lparm = cb_list_add (NULL, x);
					/* search order is either specified, otherwise derived from definition */
					if (yyvsp[-2] != NULL) {
						CB_PURPOSE (lparm) = CB_PURPOSE (yyvsp[-2]);
					} else {
						CB_PURPOSE (lparm) = cb_int (f->keys[0].dir);
					}
					yyvsp[-2] = cb_list_append (NULL, lparm);
				} else {
					cb_error (_("table SORT requires KEY phrase"));
					yyvsp[-2] = cb_error_node;
				}
			}
		}
		if (CB_VALID_TREE (yyvsp[-2])) {
			cb_emit_sort_init (yyvsp[-3], yyvsp[-2], alphanumeric_collation, national_collation);
			yyval = yyvsp[-3];
		}
	}
  }
#line 24769 "parser.c" /* yacc.c:1652  */
    break;

  case 2235:
#line 14828 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-2] && CB_VALID_TREE (yyvsp[-6])) {
		cb_emit_sort_finish (yyvsp[-6]);
	}
  }
#line 24779 "parser.c" /* yacc.c:1652  */
    break;

  case 2236:
#line 14836 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 24785 "parser.c" /* yacc.c:1652  */
    break;

  case 2237:
#line 14839 "parser.y" /* yacc.c:1652  */
    {
	cb_tree lparm = yyvsp[0];
	cb_tree l;

	if (lparm == NULL) {
		lparm = CB_LIST_INIT (NULL);
	}
	for (l = lparm; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = yyvsp[-2];
	}
	yyval = cb_list_append (yyvsp[-4], lparm);
  }
#line 24802 "parser.c" /* yacc.c:1652  */
    break;

  case 2238:
#line 14854 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 24808 "parser.c" /* yacc.c:1652  */
    break;

  case 2239:
#line 14855 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 24814 "parser.c" /* yacc.c:1652  */
    break;

  case 2241:
#line 14860 "parser.y" /* yacc.c:1652  */
    {
	/* The GnuCOBOL sort is a stable sort. ie. dups are per default in order */
	/* Therefore nothing to do here */
  }
#line 24823 "parser.c" /* yacc.c:1652  */
    break;

  case 2242:
#line 14868 "parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 24831 "parser.c" /* yacc.c:1652  */
    break;

  case 2244:
#line 14876 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] && CB_FILE_P (cb_ref (yyvsp[0]))) {
		cb_error (_("file sort requires USING or INPUT PROCEDURE"));
	}
  }
#line 24841 "parser.c" /* yacc.c:1652  */
    break;

  case 2245:
#line 14882 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-2]) {
		if (!CB_FILE_P (cb_ref (yyvsp[-2]))) {
			cb_error (_("USING invalid with table SORT"));
		} else {
			cb_emit_sort_using (yyvsp[-2], yyvsp[0]);
		}
	}
  }
#line 24855 "parser.c" /* yacc.c:1652  */
    break;

  case 2246:
#line 14892 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-4]) {
		if (!CB_FILE_P (cb_ref (yyvsp[-4]))) {
			cb_error (_("INPUT PROCEDURE invalid with table SORT"));
		} else if (current_statement->flag_merge) {
			cb_error (_("INPUT PROCEDURE invalid with MERGE"));
		} else {
			cb_emit_sort_input (yyvsp[0]);
		}
	}
	cobc_cs_check = 0;
  }
#line 24872 "parser.c" /* yacc.c:1652  */
    break;

  case 2247:
#line 14908 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (0)] && CB_FILE_P (cb_ref (yyvsp[(-1) - (0)]))) {
		cb_error (_("file sort requires GIVING or OUTPUT PROCEDURE"));
	}
  }
#line 24882 "parser.c" /* yacc.c:1652  */
    break;

  case 2248:
#line 14914 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (2)]) {
		if (!CB_FILE_P (cb_ref (yyvsp[(-1) - (2)]))) {
			cb_error (_("GIVING invalid with table SORT"));
		} else {
			cb_emit_sort_giving (yyvsp[(-1) - (2)], yyvsp[0]);
		}
	}
  }
#line 24896 "parser.c" /* yacc.c:1652  */
    break;

  case 2249:
#line 14924 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (4)]) {
		if (!CB_FILE_P (cb_ref (yyvsp[(-1) - (4)]))) {
			cb_error (_("OUTPUT PROCEDURE invalid with table SORT"));
		} else {
			cb_emit_sort_output (yyvsp[0]);
		}
	}
	cobc_cs_check = 0;
  }
#line 24911 "parser.c" /* yacc.c:1652  */
    break;

  case 2250:
#line 14941 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("START", TERM_START);
	start_tree = cb_int (COB_EQ);
  }
#line 24920 "parser.c" /* yacc.c:1652  */
    break;

  case 2252:
#line 14951 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-1] && !yyvsp[-2]) {
		cb_error_x (CB_TREE (current_statement),
			    _("SIZE/LENGTH invalid here"));
	} else {
		cb_emit_start (yyvsp[-3], start_tree, yyvsp[-2], yyvsp[-1]);
	}
  }
#line 24933 "parser.c" /* yacc.c:1652  */
    break;

  case 2253:
#line 14963 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24941 "parser.c" /* yacc.c:1652  */
    break;

  case 2254:
#line 14967 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 24949 "parser.c" /* yacc.c:1652  */
    break;

  case 2255:
#line 14974 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24957 "parser.c" /* yacc.c:1652  */
    break;

  case 2256:
#line 14978 "parser.y" /* yacc.c:1652  */
    {
	start_tree = yyvsp[-1];
	yyval = yyvsp[0];
  }
#line 24966 "parser.c" /* yacc.c:1652  */
    break;

  case 2257:
#line 14983 "parser.y" /* yacc.c:1652  */
    {
	start_tree = cb_int (COB_FI);
	yyval = NULL;
  }
#line 24975 "parser.c" /* yacc.c:1652  */
    break;

  case 2258:
#line 14988 "parser.y" /* yacc.c:1652  */
    {
	start_tree = cb_int (COB_LA);
	yyval = NULL;
  }
#line 24984 "parser.c" /* yacc.c:1652  */
    break;

  case 2259:
#line 14995 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_EQ); }
#line 24990 "parser.c" /* yacc.c:1652  */
    break;

  case 2260:
#line 14996 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (yyvsp[-1] ? COB_LE : COB_GT); }
#line 24996 "parser.c" /* yacc.c:1652  */
    break;

  case 2261:
#line 14997 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (yyvsp[-1] ? COB_GE : COB_LT); }
#line 25002 "parser.c" /* yacc.c:1652  */
    break;

  case 2262:
#line 14998 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (yyvsp[-1] ? COB_LT : COB_GE); }
#line 25008 "parser.c" /* yacc.c:1652  */
    break;

  case 2263:
#line 14999 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (yyvsp[-1] ? COB_GT : COB_LE); }
#line 25014 "parser.c" /* yacc.c:1652  */
    break;

  case 2264:
#line 15000 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_NE); }
#line 25020 "parser.c" /* yacc.c:1652  */
    break;

  case 2265:
#line 15005 "parser.y" /* yacc.c:1652  */
    {
	cb_error_x (CB_TREE (current_statement),
		    _("NOT EQUAL condition not allowed on START statement"));
  }
#line 25029 "parser.c" /* yacc.c:1652  */
    break;

  case 2268:
#line 15018 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], START);
  }
#line 25037 "parser.c" /* yacc.c:1652  */
    break;

  case 2269:
#line 15022 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], START);
  }
#line 25045 "parser.c" /* yacc.c:1652  */
    break;

  case 2270:
#line 15032 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("STOP RUN", 0);
	cobc_cs_check = CB_CS_STOP;
  }
#line 25054 "parser.c" /* yacc.c:1652  */
    break;

  case 2271:
#line 15037 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_stop_run (yyvsp[0]);
	check_unreached = 1;
	cobc_cs_check = 0;
  }
#line 25064 "parser.c" /* yacc.c:1652  */
    break;

  case 2272:
#line 15043 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("STOP", 0);
	cb_emit_display (CB_LIST_INIT (yyvsp[0]), cb_int0, cb_int1, NULL,
			 NULL, 1, DEVICE_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
	cobc_cs_check = 0;
  }
#line 25076 "parser.c" /* yacc.c:1652  */
    break;

  case 2273:
#line 15051 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("STOP THREAD", 0);
	cb_emit_stop_thread (yyvsp[0]);
	cobc_cs_check = 0;
	cb_warning_x (COBC_WARN_FILLER, yyvsp[0], _("%s is replaced by %s"), "STOP THREAD", "STOP RUN");
  }
#line 25087 "parser.c" /* yacc.c:1652  */
    break;

  case 2274:
#line 15061 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->cb_return_code) {
		yyval = current_program->cb_return_code;
	} else {
		yyval = cb_int0;
	}
  }
#line 25099 "parser.c" /* yacc.c:1652  */
    break;

  case 2275:
#line 15069 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 25107 "parser.c" /* yacc.c:1652  */
    break;

  case 2276:
#line 15073 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 25115 "parser.c" /* yacc.c:1652  */
    break;

  case 2277:
#line 15077 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = yyvsp[0];
	} else {
		yyval = cb_int1;
	}
  }
#line 25127 "parser.c" /* yacc.c:1652  */
    break;

  case 2278:
#line 15085 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = yyvsp[0];
	} else {
		yyval = cb_int0;
	}
  }
#line 25139 "parser.c" /* yacc.c:1652  */
    break;

  case 2279:
#line 15096 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 25147 "parser.c" /* yacc.c:1652  */
    break;

  case 2280:
#line 15100 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 25155 "parser.c" /* yacc.c:1652  */
    break;

  case 2281:
#line 15107 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_stop_literal_statement, _("STOP literal"));
  }
#line 25163 "parser.c" /* yacc.c:1652  */
    break;

  case 2282:
#line 15111 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_stop_identifier_statement, _("STOP identifier"));
  }
#line 25171 "parser.c" /* yacc.c:1652  */
    break;

  case 2283:
#line 15117 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25177 "parser.c" /* yacc.c:1652  */
    break;

  case 2284:
#line 15118 "parser.y" /* yacc.c:1652  */
    { yyval = cb_space; }
#line 25183 "parser.c" /* yacc.c:1652  */
    break;

  case 2285:
#line 15119 "parser.y" /* yacc.c:1652  */
    { yyval = cb_zero; }
#line 25189 "parser.c" /* yacc.c:1652  */
    break;

  case 2286:
#line 15120 "parser.y" /* yacc.c:1652  */
    { yyval = cb_quote; }
#line 25195 "parser.c" /* yacc.c:1652  */
    break;

  case 2287:
#line 15127 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("STRING", TERM_STRING);
  }
#line 25203 "parser.c" /* yacc.c:1652  */
    break;

  case 2289:
#line 15136 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_string (yyvsp[-4], yyvsp[-2], yyvsp[-1]);
  }
#line 25211 "parser.c" /* yacc.c:1652  */
    break;

  case 2290:
#line 15142 "parser.y" /* yacc.c:1652  */
    {
	save_tree = NULL;
  }
#line 25219 "parser.c" /* yacc.c:1652  */
    break;

  case 2291:
#line 15146 "parser.y" /* yacc.c:1652  */
    {
	yyval = save_tree;
  }
#line 25227 "parser.c" /* yacc.c:1652  */
    break;

  case 2294:
#line 15158 "parser.y" /* yacc.c:1652  */
    {
	if (!save_tree) {
		save_tree = CB_LIST_INIT (yyvsp[-1]);
	} else {
		save_tree = cb_list_add (save_tree, yyvsp[-1]);
	}
	if (yyvsp[0]) {
		save_tree = cb_list_add (save_tree, yyvsp[0]);
	}
  }
#line 25242 "parser.c" /* yacc.c:1652  */
    break;

  case 2295:
#line 15171 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25248 "parser.c" /* yacc.c:1652  */
    break;

  case 2296:
#line 15173 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25254 "parser.c" /* yacc.c:1652  */
    break;

  case 2297:
#line 15177 "parser.y" /* yacc.c:1652  */
    { yyval = CB_BUILD_PAIR (cb_int0, NULL); }
#line 25260 "parser.c" /* yacc.c:1652  */
    break;

  case 2298:
#line 15178 "parser.y" /* yacc.c:1652  */
    { yyval = CB_BUILD_PAIR (yyvsp[0], NULL); }
#line 25266 "parser.c" /* yacc.c:1652  */
    break;

  case 2299:
#line 15182 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25272 "parser.c" /* yacc.c:1652  */
    break;

  case 2300:
#line 15183 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25278 "parser.c" /* yacc.c:1652  */
    break;

  case 2301:
#line 15188 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], STRING);
  }
#line 25286 "parser.c" /* yacc.c:1652  */
    break;

  case 2302:
#line 15192 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], STRING);
  }
#line 25294 "parser.c" /* yacc.c:1652  */
    break;

  case 2303:
#line 15202 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SUBTRACT", TERM_SUBTRACT);
  }
#line 25302 "parser.c" /* yacc.c:1652  */
    break;

  case 2305:
#line 15211 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '-', cb_build_binary_list (yyvsp[-3], '+'));
  }
#line 25310 "parser.c" /* yacc.c:1652  */
    break;

  case 2306:
#line 15215 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_list (CB_BUILD_CHAIN (yyvsp[-3], yyvsp[-5]), '-'));
  }
#line 25318 "parser.c" /* yacc.c:1652  */
    break;

  case 2307:
#line 15219 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_corresponding (cb_build_sub, yyvsp[-2], yyvsp[-4], yyvsp[-1]);
  }
#line 25326 "parser.c" /* yacc.c:1652  */
    break;

  case 2308:
#line 15223 "parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SUBTRACT TABLE");
	cb_emit_tab_arithmetic (cb_build_sub, yyvsp[-4], yyvsp[-6], yyvsp[-3], yyvsp[-2], yyvsp[-1]);
  }
#line 25335 "parser.c" /* yacc.c:1652  */
    break;

  case 2309:
#line 15231 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], SUBTRACT);
  }
#line 25343 "parser.c" /* yacc.c:1652  */
    break;

  case 2310:
#line 15235 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], SUBTRACT);
  }
#line 25351 "parser.c" /* yacc.c:1652  */
    break;

  case 2311:
#line 15245 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("SUPPRESS", 0);
	if (!in_declaratives) {
		cb_error_x (CB_TREE (current_statement),
			    _("SUPPRESS statement must be within DECLARATIVES"));
	}
	cb_emit_suppress (control_field);
  }
#line 25364 "parser.c" /* yacc.c:1652  */
    break;

  case 2314:
#line 15263 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("TERMINATE", 0);
  }
#line 25372 "parser.c" /* yacc.c:1652  */
    break;

  case 2316:
#line 15271 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
	    cb_emit_terminate (yyvsp[0]);
	}
  }
#line 25383 "parser.c" /* yacc.c:1652  */
    break;

  case 2317:
#line 15278 "parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_terminate (yyvsp[0]);
	}
  }
#line 25394 "parser.c" /* yacc.c:1652  */
    break;

  case 2318:
#line 15290 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("TRANSFORM", 0);
  }
#line 25402 "parser.c" /* yacc.c:1652  */
    break;

  case 2320:
#line 15298 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	x = cb_build_converting (yyvsp[-2], yyvsp[0], cb_build_inspect_region_start ());
	cb_emit_inspect (yyvsp[-4], x, TRANSFORM_STATEMENT);
  }
#line 25413 "parser.c" /* yacc.c:1652  */
    break;

  case 2321:
#line 15311 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("UNLOCK", 0);
  }
#line 25421 "parser.c" /* yacc.c:1652  */
    break;

  case 2323:
#line 15319 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[-1])) {
		if (CB_FILE (cb_ref (yyvsp[-1]))->organization == COB_ORG_SORT) {
			cb_error_x (CB_TREE (current_statement),
				    _("UNLOCK invalid for SORT files"));
		} else {
			cb_emit_unlock (yyvsp[-1]);
		}
	}
  }
#line 25436 "parser.c" /* yacc.c:1652  */
    break;

  case 2324:
#line 15335 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("UNSTRING", TERM_UNSTRING);
  }
#line 25444 "parser.c" /* yacc.c:1652  */
    break;

  case 2326:
#line 15346 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_unstring (yyvsp[-5], yyvsp[-4], yyvsp[-3], yyvsp[-2], yyvsp[-1]);
  }
#line 25452 "parser.c" /* yacc.c:1652  */
    break;

  case 2327:
#line 15352 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25458 "parser.c" /* yacc.c:1652  */
    break;

  case 2328:
#line 15354 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25464 "parser.c" /* yacc.c:1652  */
    break;

  case 2329:
#line 15358 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 25470 "parser.c" /* yacc.c:1652  */
    break;

  case 2330:
#line 15360 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 25476 "parser.c" /* yacc.c:1652  */
    break;

  case 2331:
#line 15365 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_unstring_delimited (yyvsp[-1], yyvsp[0]);
  }
#line 25484 "parser.c" /* yacc.c:1652  */
    break;

  case 2332:
#line 15371 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 25490 "parser.c" /* yacc.c:1652  */
    break;

  case 2333:
#line 15373 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 25496 "parser.c" /* yacc.c:1652  */
    break;

  case 2334:
#line 15378 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_unstring_into (yyvsp[-2], yyvsp[-1], yyvsp[0]);
  }
#line 25504 "parser.c" /* yacc.c:1652  */
    break;

  case 2335:
#line 15384 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25510 "parser.c" /* yacc.c:1652  */
    break;

  case 2336:
#line 15385 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25516 "parser.c" /* yacc.c:1652  */
    break;

  case 2337:
#line 15389 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25522 "parser.c" /* yacc.c:1652  */
    break;

  case 2338:
#line 15390 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25528 "parser.c" /* yacc.c:1652  */
    break;

  case 2339:
#line 15395 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], UNSTRING);
  }
#line 25536 "parser.c" /* yacc.c:1652  */
    break;

  case 2340:
#line 15399 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], UNSTRING);
  }
#line 25544 "parser.c" /* yacc.c:1652  */
    break;

  case 2341:
#line 15408 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("VALIDATE", 0);
  }
#line 25552 "parser.c" /* yacc.c:1652  */
    break;

  case 2342:
#line 15412 "parser.y" /* yacc.c:1652  */
    {
#if 0	/* FIXME: at least add syntax checks here */
	cb_emit_validate (yyvsp[0]);
#else
	CB_PENDING ("VALIDATE");
#endif
  }
#line 25564 "parser.c" /* yacc.c:1652  */
    break;

  case 2343:
#line 15423 "parser.y" /* yacc.c:1652  */
    {
	check_validate_item (yyvsp[0]);
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 25573 "parser.c" /* yacc.c:1652  */
    break;

  case 2344:
#line 15428 "parser.y" /* yacc.c:1652  */
    {
	check_validate_item (yyvsp[0]);
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 25582 "parser.c" /* yacc.c:1652  */
    break;

  case 2345:
#line 15439 "parser.y" /* yacc.c:1652  */
    {
	skip_statements = 0;
	in_debugging = 0;
  }
#line 25591 "parser.c" /* yacc.c:1652  */
    break;

  case 2352:
#line 15457 "parser.y" /* yacc.c:1652  */
    {
	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (!current_section) {
		cb_error (_("SECTION header missing before USE statement"));
	} else {
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 1;
		current_section->flag_skip_label = 0;
		/* TO-DO: Use cobc_ec_turn? */
		CB_EXCEPTION_ENABLE (COB_EC_I_O) = 1;
		if (use_global_ind) {
			current_section->flag_global = 1;
			current_program->global_list =
				cb_list_add (current_program->global_list,
					     CB_TREE (current_section));
		}
		emit_statement (cb_build_comment ("USE AFTER ERROR"));
	}
  }
#line 25618 "parser.c" /* yacc.c:1652  */
    break;

  case 2353:
#line 15483 "parser.y" /* yacc.c:1652  */
    {
	use_global_ind = 0;
  }
#line 25626 "parser.c" /* yacc.c:1652  */
    break;

  case 2354:
#line 15487 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		use_global_ind = 1;
		current_program->flag_global_use = 1;
	}
  }
#line 25639 "parser.c" /* yacc.c:1652  */
    break;

  case 2355:
#line 15499 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;

	for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			setup_use_file (CB_FILE (cb_ref (CB_VALUE (l))));
		}
	}
  }
#line 25653 "parser.c" /* yacc.c:1652  */
    break;

  case 2356:
#line 15509 "parser.y" /* yacc.c:1652  */
    {
	current_program->global_handler[COB_OPEN_INPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_INPUT].handler_prog = current_program;
  }
#line 25662 "parser.c" /* yacc.c:1652  */
    break;

  case 2357:
#line 15514 "parser.y" /* yacc.c:1652  */
    {
	current_program->global_handler[COB_OPEN_OUTPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_OUTPUT].handler_prog = current_program;
  }
#line 25671 "parser.c" /* yacc.c:1652  */
    break;

  case 2358:
#line 15519 "parser.y" /* yacc.c:1652  */
    {
	current_program->global_handler[COB_OPEN_I_O].handler_label = current_section;
	current_program->global_handler[COB_OPEN_I_O].handler_prog = current_program;
  }
#line 25680 "parser.c" /* yacc.c:1652  */
    break;

  case 2359:
#line 15524 "parser.y" /* yacc.c:1652  */
    {
	current_program->global_handler[COB_OPEN_EXTEND].handler_label = current_section;
	current_program->global_handler[COB_OPEN_EXTEND].handler_prog = current_program;
  }
#line 25689 "parser.c" /* yacc.c:1652  */
    break;

  case 2360:
#line 15532 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		plabel;
	char		name[64];

	cb_verify (cb_use_for_debugging, "USE FOR DEBUGGING");

	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (current_program->nested_level) {
		cb_error (_("USE DEBUGGING not supported in contained program"));
	} else {
		in_debugging = 1;
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 0;
		current_section->flag_is_debug_sect = 1;
		if (!needs_debug_item) {
			needs_debug_item = 1;
			cb_build_debug_item ();
		}
		if (!current_program->flag_debugging) {
			skip_statements = 1;
			current_section->flag_skip_label = 1;
		} else {
			current_program->flag_gen_debug = 1;
			sprintf (name, "EXIT SECTION %d", cb_id);
			plabel = cb_build_reference (name);
			plabel = cb_build_label (plabel, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
			current_section->exit_label = plabel;
			emit_statement (cb_build_comment ("USE FOR DEBUGGING"));
		}
	}
  }
#line 25730 "parser.c" /* yacc.c:1652  */
    break;

  case 2363:
#line 15577 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_debugging) {

		cb_tree		z = CB_LIST_INIT (yyvsp[0]);
		current_program->debug_list =
			cb_list_append (current_program->debug_list, z);
		/* Check backward refs to file/data names */
		if (CB_WORD_COUNT (yyvsp[0]) > 0) {
			cb_tree		l = CB_VALUE (CB_WORD_ITEMS (yyvsp[0]));
			switch (CB_TREE_TAG (l)) {
			case CB_TAG_CD:
				if (CB_CD (l)->flag_field_debug) {
					cb_error_x (yyvsp[0], _("duplicate DEBUGGING target: '%s'"),
					    cb_name (l));
				} else {
					CB_CD (l)->debug_section = current_section;
					CB_CD (l)->flag_field_debug = 1;
				}
				break;
			case CB_TAG_FILE:
				if (CB_FILE (l)->flag_fl_debug) {
					cb_error_x (yyvsp[0], _("duplicate DEBUGGING target: '%s'"),
					    cb_name (l));
				} else {
					CB_FILE (l)->debug_section = current_section;
					CB_FILE (l)->flag_fl_debug = 1;
				}
				break;
			case CB_TAG_FIELD:
				{
					struct cb_field* fld;
					cb_tree		x = cb_ref (yyvsp[0]);
					if (!x || !CB_FIELD_P (x)) {
						break;
					}
					fld = CB_FIELD (x);
					if (fld->flag_item_78) {
						cb_error_x (yyvsp[0], _("constant item cannot be used here"));
					} else if (fld->flag_field_debug) {
						cb_error_x (yyvsp[0], _("duplicate DEBUGGING target: '%s'"),
							cb_name (x));
					} else {
						needs_field_debug = 1;
						fld->debug_section = current_section;
						fld->flag_field_debug = 1;
						CB_PURPOSE (z) = x;
					}
				}
				break;
			default:
				/* Label refs will be checked later (forward/backward ref) */
				break;
			}
		}
		CB_REFERENCE (yyvsp[0])->debug_section = current_section;
		CB_REFERENCE (yyvsp[0])->flag_debug_code = 1;
		CB_REFERENCE (yyvsp[0])->flag_all_debug = 0;
	}
  }
#line 25794 "parser.c" /* yacc.c:1652  */
    break;

  case 2364:
#line 15637 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_debugging) {
		if (current_program->all_procedure) {
			cb_error (_("duplicate USE DEBUGGING ON ALL PROCEDURES"));
		} else {
			current_program->all_procedure = current_section;
		}
	}
  }
#line 25808 "parser.c" /* yacc.c:1652  */
    break;

  case 2365:
#line 15647 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_debugging && yyvsp[0] != cb_error_node) {
		cb_tree x = cb_ref (yyvsp[0]);
		struct cb_field *fld = CB_FIELD (x);
		if (fld->flag_field_debug) {
			cb_error_x (yyvsp[0], _("duplicate DEBUGGING target: '%s'"),
				cb_name (x));
		} else {
			struct cb_reference *r = CB_REFERENCE (yyvsp[0]);
			needs_field_debug = 1;
			fld->debug_section = current_section;
			fld->flag_field_debug = 1;
			fld->flag_all_debug = 1;
			r->debug_section = current_section;
			r->flag_debug_code = 1;
			r->flag_all_debug = 1;
			CB_CHAIN_PAIR (current_program->debug_list, x, yyvsp[0]);
		}
	}
  }
#line 25833 "parser.c" /* yacc.c:1652  */
    break;

  case 2370:
#line 15677 "parser.y" /* yacc.c:1652  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "USE AT");
	}
  }
#line 25843 "parser.c" /* yacc.c:1652  */
    break;

  case 2371:
#line 15686 "parser.y" /* yacc.c:1652  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM START"));
	backup_current_pos ();
	CB_PENDING ("USE AT PROGRAM START");
	/* emit_entry ("_AT_START", 0, NULL, NULL); */
  }
#line 25854 "parser.c" /* yacc.c:1652  */
    break;

  case 2372:
#line 15693 "parser.y" /* yacc.c:1652  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM END"));
	backup_current_pos ();
	CB_PENDING ("USE AT PROGRAM END");
	/* emit_entry ("_AT_END", 0, NULL, NULL); */
  }
#line 25865 "parser.c" /* yacc.c:1652  */
    break;

  case 2373:
#line 15704 "parser.y" /* yacc.c:1652  */
    {
	char *wrk;
	cb_tree x;
	struct cb_field		*f;
	struct cb_report	*r;

	x = cb_ref (yyvsp[0]);
	if (!CB_FIELD_P (x)) {
		cb_error_x (yyvsp[0], _("'%s' is not a report group"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	} else {
		control_field = f = CB_FIELD (x);
		f->report_decl_id = current_section->id;
		if ((r = f->report) != NULL) {
			r->has_declarative = 1;
		}
	}
	wrk = cobc_main_malloc (COB_MINI_BUFF);
	snprintf (wrk, COB_MINI_MAX, "USE BEFORE REPORTING %s is %s%d",
		cb_name (yyvsp[0]), CB_PREFIX_LABEL, current_section->id);
	current_section->flag_real_label = 1;
	current_section->flag_declaratives = 1;
	current_section->flag_begin = 1;
	current_section->flag_return = 1;
	current_section->flag_declarative_exit = 1;
	current_section->flag_real_label = 1;
	current_section->flag_skip_label = 0;
	emit_statement (cb_build_comment (wrk));
  }
#line 25899 "parser.c" /* yacc.c:1652  */
    break;

  case 2376:
#line 15742 "parser.y" /* yacc.c:1652  */
    {
	current_section->flag_real_label = 1;
	emit_statement (cb_build_comment ("USE AFTER EXCEPTION CONDITION"));
	CB_PENDING ("USE AFTER EXCEPTION CONDITION");
  }
#line 25909 "parser.c" /* yacc.c:1652  */
    break;

  case 2377:
#line 15748 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;

	for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			setup_use_file (CB_FILE (cb_ref (CB_VALUE (l))));
		}
	}
	current_section->flag_real_label = 1;
	emit_statement(cb_build_comment("USE AFTER EXCEPTION CONDITION"));
	CB_PENDING("USE AFTER EXCEPTION CONDITION");
  }
#line 25926 "parser.c" /* yacc.c:1652  */
    break;

  case 2380:
#line 15771 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("WRITE", TERM_WRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 25937 "parser.c" /* yacc.c:1652  */
    break;

  case 2382:
#line 15783 "parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[-5])) {
		cb_emit_write (yyvsp[-5], yyvsp[-4], yyvsp[-3], yyvsp[-1]);
	}
	start_debug = save_debug;
  }
#line 25948 "parser.c" /* yacc.c:1652  */
    break;

  case 2383:
#line 15792 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 25954 "parser.c" /* yacc.c:1652  */
    break;

  case 2384:
#line 15793 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 25960 "parser.c" /* yacc.c:1652  */
    break;

  case 2385:
#line 15798 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 25968 "parser.c" /* yacc.c:1652  */
    break;

  case 2386:
#line 15802 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_write_advancing_lines (yyvsp[-3], yyvsp[-1]);
  }
#line 25976 "parser.c" /* yacc.c:1652  */
    break;

  case 2387:
#line 15806 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_write_advancing_mnemonic (yyvsp[-2], yyvsp[0]);
  }
#line 25984 "parser.c" /* yacc.c:1652  */
    break;

  case 2388:
#line 15810 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_write_advancing_page (yyvsp[-2]);
  }
#line 25992 "parser.c" /* yacc.c:1652  */
    break;

  case 2389:
#line 15816 "parser.y" /* yacc.c:1652  */
    { yyval = CB_BEFORE; }
#line 25998 "parser.c" /* yacc.c:1652  */
    break;

  case 2390:
#line 15817 "parser.y" /* yacc.c:1652  */
    { yyval = CB_AFTER; }
#line 26004 "parser.c" /* yacc.c:1652  */
    break;

  case 2394:
#line 15828 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], WRITE);
  }
#line 26012 "parser.c" /* yacc.c:1652  */
    break;

  case 2395:
#line 15832 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], WRITE);
  }
#line 26020 "parser.c" /* yacc.c:1652  */
    break;

  case 2396:
#line 15841 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("XML GENERATE", TERM_XML);
	cobc_in_xml_generate_body = 1;
	cobc_cs_check = CB_CS_XML_GENERATE;
  }
#line 26030 "parser.c" /* yacc.c:1652  */
    break;

  case 2398:
#line 15853 "parser.y" /* yacc.c:1652  */
    {
	xml_encoding = NULL;
	with_xml_dec = 0;
	with_attrs = 0;
	ml_suppress_list = NULL;
  }
#line 26041 "parser.c" /* yacc.c:1652  */
    break;

  case 2399:
#line 15864 "parser.y" /* yacc.c:1652  */
    {
	cobc_in_xml_generate_body = 0;
	cobc_cs_check = 0;
  }
#line 26050 "parser.c" /* yacc.c:1652  */
    break;

  case 2400:
#line 15869 "parser.y" /* yacc.c:1652  */
    {
	cb_emit_xml_generate (yyvsp[-11], yyvsp[-9], yyvsp[-8], xml_encoding, with_xml_dec,
			      with_attrs, yyvsp[-5], yyvsp[-4], yyvsp[-3], ml_suppress_list);
  }
#line 26059 "parser.c" /* yacc.c:1652  */
    break;

  case 2406:
#line 15891 "parser.y" /* yacc.c:1652  */
    {
	xml_encoding = yyvsp[0];
	if (with_xml_dec) {
		cb_error (_("ENCODING clause must come before XML-DECLARATION"));
	} else if (with_attrs) {
		cb_error (_("ENCODING clause must come before ATTRIBUTES"));
	}
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE ENCODING clause"));
	CB_PENDING ("XML GENERATE ENCODING");
  }
#line 26075 "parser.c" /* yacc.c:1652  */
    break;

  case 2407:
#line 15903 "parser.y" /* yacc.c:1652  */
    {
	with_xml_dec = 1;
	if (with_attrs) {
		cb_error (_("XML-DECLARATION clause must come before ATTRIBUTES"));
	}
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE XML-DECLARATION clause"));
  }
#line 26088 "parser.c" /* yacc.c:1652  */
    break;

  case 2408:
#line 15912 "parser.y" /* yacc.c:1652  */
    {
	with_attrs = 1;
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE WITH ATTRIBUTES clause"));
  }
#line 26098 "parser.c" /* yacc.c:1652  */
    break;

  case 2409:
#line 15921 "parser.y" /* yacc.c:1652  */
    {
	 yyval = NULL;
  }
#line 26106 "parser.c" /* yacc.c:1652  */
    break;

  case 2410:
#line 15925 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE NAMESPACE clause"));
  }
#line 26116 "parser.c" /* yacc.c:1652  */
    break;

  case 2411:
#line 15934 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 26124 "parser.c" /* yacc.c:1652  */
    break;

  case 2412:
#line 15938 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 26132 "parser.c" /* yacc.c:1652  */
    break;

  case 2413:
#line 15945 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26140 "parser.c" /* yacc.c:1652  */
    break;

  case 2414:
#line 15949 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE NAME OF clause"));
  }
#line 26150 "parser.c" /* yacc.c:1652  */
    break;

  case 2415:
#line 15958 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 26158 "parser.c" /* yacc.c:1652  */
    break;

  case 2416:
#line 15962 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 26166 "parser.c" /* yacc.c:1652  */
    break;

  case 2417:
#line 15969 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 26174 "parser.c" /* yacc.c:1652  */
    break;

  case 2418:
#line 15976 "parser.y" /* yacc.c:1652  */
    {
       yyval = NULL;
  }
#line 26182 "parser.c" /* yacc.c:1652  */
    break;

  case 2419:
#line 15980 "parser.y" /* yacc.c:1652  */
    {
       yyval = yyvsp[0];
       	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE TYPE OF clause"));
  }
#line 26192 "parser.c" /* yacc.c:1652  */
    break;

  case 2420:
#line 15989 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 26200 "parser.c" /* yacc.c:1652  */
    break;

  case 2421:
#line 15993 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 26208 "parser.c" /* yacc.c:1652  */
    break;

  case 2422:
#line 16000 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 26216 "parser.c" /* yacc.c:1652  */
    break;

  case 2423:
#line 16007 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int) CB_ML_ANY_TYPE);
  }
#line 26224 "parser.c" /* yacc.c:1652  */
    break;

  case 2425:
#line 16014 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int ((int) CB_ML_ATTRIBUTE); }
#line 26230 "parser.c" /* yacc.c:1652  */
    break;

  case 2426:
#line 16015 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int ((int) CB_ML_ELEMENT); }
#line 26236 "parser.c" /* yacc.c:1652  */
    break;

  case 2427:
#line 16016 "parser.y" /* yacc.c:1652  */
    { yyval = cb_int ((int) CB_ML_CONTENT); }
#line 26242 "parser.c" /* yacc.c:1652  */
    break;

  case 2429:
#line 16022 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE SUPPRESS clause"));
  }
#line 26251 "parser.c" /* yacc.c:1652  */
    break;

  case 2432:
#line 16035 "parser.y" /* yacc.c:1652  */
    {
	error_if_following_every_clause ();
	add_identifier_to_ml_suppress_conds (yyvsp[0]);
  }
#line 26260 "parser.c" /* yacc.c:1652  */
    break;

  case 2433:
#line 16040 "parser.y" /* yacc.c:1652  */
    {
	error_if_following_every_clause ();
	add_type_to_ml_suppress_conds (ml_suppress_category, (enum cb_ml_type) CB_INTEGER (yyvsp[0])->val);
  }
#line 26269 "parser.c" /* yacc.c:1652  */
    break;

  case 2434:
#line 16045 "parser.y" /* yacc.c:1652  */
    {
	add_when_to_ml_suppress_conds (yyvsp[0]);
  }
#line 26277 "parser.c" /* yacc.c:1652  */
    break;

  case 2435:
#line 16052 "parser.y" /* yacc.c:1652  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_NUMERIC;
	yyval = yyvsp[0];
  }
#line 26286 "parser.c" /* yacc.c:1652  */
    break;

  case 2436:
#line 16057 "parser.y" /* yacc.c:1652  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_NONNUMERIC;
	yyval = yyvsp[0];
  }
#line 26295 "parser.c" /* yacc.c:1652  */
    break;

  case 2437:
#line 16062 "parser.y" /* yacc.c:1652  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_ANY;
	yyval = yyvsp[0];
  }
#line 26304 "parser.c" /* yacc.c:1652  */
    break;

  case 2438:
#line 16070 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 26312 "parser.c" /* yacc.c:1652  */
    break;

  case 2439:
#line 16074 "parser.y" /* yacc.c:1652  */
    {
       yyval = cb_list_add (yyvsp[-2], yyvsp[0]);
  }
#line 26320 "parser.c" /* yacc.c:1652  */
    break;

  case 2440:
#line 16081 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], XML);
  }
#line 26328 "parser.c" /* yacc.c:1652  */
    break;

  case 2441:
#line 16085 "parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], XML);
  }
#line 26336 "parser.c" /* yacc.c:1652  */
    break;

  case 2442:
#line 16095 "parser.y" /* yacc.c:1652  */
    {
	begin_statement ("XML PARSE", TERM_XML);
	/* TO-DO: Add xml-parse and xml-parse-extra-phrases config options. */
	CB_PENDING (_("XML PARSE"));
	cobc_cs_check = CB_CS_XML_PARSE;
  }
#line 26347 "parser.c" /* yacc.c:1652  */
    break;

  case 2444:
#line 16111 "parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 26355 "parser.c" /* yacc.c:1652  */
    break;

  case 2453:
#line 16135 "parser.y" /* yacc.c:1652  */
    {
	if (CB_FILE_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a file name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 26368 "parser.c" /* yacc.c:1652  */
    break;

  case 2456:
#line 16153 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26379 "parser.c" /* yacc.c:1652  */
    break;

  case 2457:
#line 16163 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26387 "parser.c" /* yacc.c:1652  */
    break;

  case 2458:
#line 16167 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26395 "parser.c" /* yacc.c:1652  */
    break;

  case 2459:
#line 16174 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26404 "parser.c" /* yacc.c:1652  */
    break;

  case 2464:
#line 16192 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26413 "parser.c" /* yacc.c:1652  */
    break;

  case 2469:
#line 16208 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26424 "parser.c" /* yacc.c:1652  */
    break;

  case 2470:
#line 16218 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26432 "parser.c" /* yacc.c:1652  */
    break;

  case 2471:
#line 16222 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26440 "parser.c" /* yacc.c:1652  */
    break;

  case 2472:
#line 16229 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26449 "parser.c" /* yacc.c:1652  */
    break;

  case 2475:
#line 16242 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26458 "parser.c" /* yacc.c:1652  */
    break;

  case 2478:
#line 16252 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			   _("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26469 "parser.c" /* yacc.c:1652  */
    break;

  case 2479:
#line 16262 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26477 "parser.c" /* yacc.c:1652  */
    break;

  case 2480:
#line 16266 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26485 "parser.c" /* yacc.c:1652  */
    break;

  case 2481:
#line 16273 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = XML_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26494 "parser.c" /* yacc.c:1652  */
    break;

  case 2484:
#line 16286 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = XML_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26503 "parser.c" /* yacc.c:1652  */
    break;

  case 2487:
#line 16296 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			   _("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26514 "parser.c" /* yacc.c:1652  */
    break;

  case 2488:
#line 16306 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26522 "parser.c" /* yacc.c:1652  */
    break;

  case 2489:
#line 16310 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26530 "parser.c" /* yacc.c:1652  */
    break;

  case 2490:
#line 16317 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = JSON_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26539 "parser.c" /* yacc.c:1652  */
    break;

  case 2493:
#line 16330 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = JSON_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26548 "parser.c" /* yacc.c:1652  */
    break;

  case 2496:
#line 16342 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT SIZE ERROR before SIZE ERROR"));
	}
  }
#line 26559 "parser.c" /* yacc.c:1652  */
    break;

  case 2497:
#line 16352 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26567 "parser.c" /* yacc.c:1652  */
    break;

  case 2498:
#line 16356 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26575 "parser.c" /* yacc.c:1652  */
    break;

  case 2499:
#line 16363 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26584 "parser.c" /* yacc.c:1652  */
    break;

  case 2502:
#line 16376 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26593 "parser.c" /* yacc.c:1652  */
    break;

  case 2505:
#line 16388 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT OVERFLOW before OVERFLOW"));
	}
  }
#line 26604 "parser.c" /* yacc.c:1652  */
    break;

  case 2506:
#line 16398 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26612 "parser.c" /* yacc.c:1652  */
    break;

  case 2507:
#line 16402 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26620 "parser.c" /* yacc.c:1652  */
    break;

  case 2508:
#line 16409 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26629 "parser.c" /* yacc.c:1652  */
    break;

  case 2511:
#line 16422 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26638 "parser.c" /* yacc.c:1652  */
    break;

  case 2513:
#line 16434 "parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
  }
#line 26646 "parser.c" /* yacc.c:1652  */
    break;

  case 2515:
#line 16443 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
	}
  }
#line 26656 "parser.c" /* yacc.c:1652  */
    break;

  case 2516:
#line 16452 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26664 "parser.c" /* yacc.c:1652  */
    break;

  case 2517:
#line 16456 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26672 "parser.c" /* yacc.c:1652  */
    break;

  case 2518:
#line 16463 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26681 "parser.c" /* yacc.c:1652  */
    break;

  case 2521:
#line 16476 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26690 "parser.c" /* yacc.c:1652  */
    break;

  case 2523:
#line 16487 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT AT END-OF-PAGE before AT END-OF-PAGE"));
	}
  }
#line 26701 "parser.c" /* yacc.c:1652  */
    break;

  case 2524:
#line 16497 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26709 "parser.c" /* yacc.c:1652  */
    break;

  case 2525:
#line 16501 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26717 "parser.c" /* yacc.c:1652  */
    break;

  case 2526:
#line 16508 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26726 "parser.c" /* yacc.c:1652  */
    break;

  case 2529:
#line 16521 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26735 "parser.c" /* yacc.c:1652  */
    break;

  case 2533:
#line 16537 "parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT INVALID KEY before INVALID KEY"));
	}
  }
#line 26746 "parser.c" /* yacc.c:1652  */
    break;

  case 2534:
#line 16547 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26754 "parser.c" /* yacc.c:1652  */
    break;

  case 2535:
#line 16551 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 26762 "parser.c" /* yacc.c:1652  */
    break;

  case 2536:
#line 16558 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->ex_handler = yyvsp[0];
  }
#line 26771 "parser.c" /* yacc.c:1652  */
    break;

  case 2539:
#line 16571 "parser.y" /* yacc.c:1652  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->not_ex_handler = yyvsp[0];
  }
#line 26780 "parser.c" /* yacc.c:1652  */
    break;

  case 2540:
#line 16581 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26788 "parser.c" /* yacc.c:1652  */
    break;

  case 2541:
#line 16585 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
	CB_PENDING ("THREAD");
  }
#line 26797 "parser.c" /* yacc.c:1652  */
    break;

  case 2542:
#line 16593 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26805 "parser.c" /* yacc.c:1652  */
    break;

  case 2543:
#line 16597 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	CB_PENDING ("THREAD");
  }
#line 26814 "parser.c" /* yacc.c:1652  */
    break;

  case 2544:
#line 16605 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 26822 "parser.c" /* yacc.c:1652  */
    break;

  case 2545:
#line 16609 "parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 26830 "parser.c" /* yacc.c:1652  */
    break;

  case 2546:
#line 16618 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_one;
  }
#line 26838 "parser.c" /* yacc.c:1652  */
    break;

  case 2547:
#line 16622 "parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 26846 "parser.c" /* yacc.c:1652  */
    break;

  case 2548:
#line 16628 "parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 26852 "parser.c" /* yacc.c:1652  */
    break;

  case 2549:
#line 16629 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 26858 "parser.c" /* yacc.c:1652  */
    break;

  case 2550:
#line 16636 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_cond (yyvsp[0]);
	cb_end_cond (yyval);
  }
#line 26867 "parser.c" /* yacc.c:1652  */
    break;

  case 2551:
#line 16641 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_error_node;
	cb_end_cond (yyval);
  }
#line 26876 "parser.c" /* yacc.c:1652  */
    break;

  case 2552:
#line 16649 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_expr (yyvsp[0]);
  }
#line 26884 "parser.c" /* yacc.c:1652  */
    break;

  case 2553:
#line 16655 "parser.y" /* yacc.c:1652  */
    {
	current_expr = NULL;
	cb_exp_line = cb_source_line;
  }
#line 26893 "parser.c" /* yacc.c:1652  */
    break;

  case 2554:
#line 16660 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_reverse (current_expr);
  }
#line 26901 "parser.c" /* yacc.c:1652  */
    break;

  case 2557:
#line 16671 "parser.y" /* yacc.c:1652  */
    { push_expr ('x', yyvsp[0]); }
#line 26907 "parser.c" /* yacc.c:1652  */
    break;

  case 2560:
#line 16676 "parser.y" /* yacc.c:1652  */
    { push_expr ('x', cb_zero); }
#line 26913 "parser.c" /* yacc.c:1652  */
    break;

  case 2561:
#line 16678 "parser.y" /* yacc.c:1652  */
    { push_expr ('(', NULL); }
#line 26919 "parser.c" /* yacc.c:1652  */
    break;

  case 2562:
#line 16679 "parser.y" /* yacc.c:1652  */
    { push_expr (')', NULL); }
#line 26925 "parser.c" /* yacc.c:1652  */
    break;

  case 2563:
#line 16681 "parser.y" /* yacc.c:1652  */
    { push_expr ('+', NULL); }
#line 26931 "parser.c" /* yacc.c:1652  */
    break;

  case 2564:
#line 16682 "parser.y" /* yacc.c:1652  */
    { push_expr ('-', NULL); }
#line 26937 "parser.c" /* yacc.c:1652  */
    break;

  case 2565:
#line 16683 "parser.y" /* yacc.c:1652  */
    { push_expr ('*', NULL); }
#line 26943 "parser.c" /* yacc.c:1652  */
    break;

  case 2566:
#line 16684 "parser.y" /* yacc.c:1652  */
    { push_expr ('/', NULL); }
#line 26949 "parser.c" /* yacc.c:1652  */
    break;

  case 2567:
#line 16685 "parser.y" /* yacc.c:1652  */
    { push_expr ('^', NULL); }
#line 26955 "parser.c" /* yacc.c:1652  */
    break;

  case 2569:
#line 16688 "parser.y" /* yacc.c:1652  */
    { push_expr ('&', NULL); }
#line 26961 "parser.c" /* yacc.c:1652  */
    break;

  case 2570:
#line 16689 "parser.y" /* yacc.c:1652  */
    { push_expr ('|', NULL); }
#line 26967 "parser.c" /* yacc.c:1652  */
    break;

  case 2573:
#line 16698 "parser.y" /* yacc.c:1652  */
    { push_expr ('!', NULL); }
#line 26973 "parser.c" /* yacc.c:1652  */
    break;

  case 2574:
#line 16701 "parser.y" /* yacc.c:1652  */
    { push_expr ('C', yyvsp[0]); }
#line 26979 "parser.c" /* yacc.c:1652  */
    break;

  case 2575:
#line 16703 "parser.y" /* yacc.c:1652  */
    { push_expr ('=', NULL); }
#line 26985 "parser.c" /* yacc.c:1652  */
    break;

  case 2576:
#line 16704 "parser.y" /* yacc.c:1652  */
    { push_expr ('>', NULL); }
#line 26991 "parser.c" /* yacc.c:1652  */
    break;

  case 2577:
#line 16705 "parser.y" /* yacc.c:1652  */
    { push_expr ('<', NULL); }
#line 26997 "parser.c" /* yacc.c:1652  */
    break;

  case 2578:
#line 16706 "parser.y" /* yacc.c:1652  */
    { push_expr (']', NULL); }
#line 27003 "parser.c" /* yacc.c:1652  */
    break;

  case 2579:
#line 16707 "parser.y" /* yacc.c:1652  */
    { push_expr ('[', NULL); }
#line 27009 "parser.c" /* yacc.c:1652  */
    break;

  case 2580:
#line 16708 "parser.y" /* yacc.c:1652  */
    { push_expr ('~', NULL); }
#line 27015 "parser.c" /* yacc.c:1652  */
    break;

  case 2581:
#line 16710 "parser.y" /* yacc.c:1652  */
    { push_expr ('O', NULL); }
#line 27021 "parser.c" /* yacc.c:1652  */
    break;

  case 2582:
#line 16711 "parser.y" /* yacc.c:1652  */
    { push_expr ('9', NULL); }
#line 27027 "parser.c" /* yacc.c:1652  */
    break;

  case 2583:
#line 16712 "parser.y" /* yacc.c:1652  */
    { push_expr ('A', NULL); }
#line 27033 "parser.c" /* yacc.c:1652  */
    break;

  case 2584:
#line 16713 "parser.y" /* yacc.c:1652  */
    { push_expr ('L', NULL); }
#line 27039 "parser.c" /* yacc.c:1652  */
    break;

  case 2585:
#line 16714 "parser.y" /* yacc.c:1652  */
    { push_expr ('U', NULL); }
#line 27045 "parser.c" /* yacc.c:1652  */
    break;

  case 2586:
#line 16717 "parser.y" /* yacc.c:1652  */
    { push_expr ('P', NULL); }
#line 27051 "parser.c" /* yacc.c:1652  */
    break;

  case 2587:
#line 16718 "parser.y" /* yacc.c:1652  */
    { push_expr ('N', NULL); }
#line 27057 "parser.c" /* yacc.c:1652  */
    break;

  case 2596:
#line 16748 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 27065 "parser.c" /* yacc.c:1652  */
    break;

  case 2597:
#line 16752 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-2], yyvsp[0]);
  }
#line 27073 "parser.c" /* yacc.c:1652  */
    break;

  case 2601:
#line 16764 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_binary_op (yyvsp[-2], '+', yyvsp[0]); }
#line 27079 "parser.c" /* yacc.c:1652  */
    break;

  case 2602:
#line 16765 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_binary_op (yyvsp[-2], '-', yyvsp[0]); }
#line 27085 "parser.c" /* yacc.c:1652  */
    break;

  case 2603:
#line 16766 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27091 "parser.c" /* yacc.c:1652  */
    break;

  case 2604:
#line 16770 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_binary_op (yyvsp[-2], '*', yyvsp[0]); }
#line 27097 "parser.c" /* yacc.c:1652  */
    break;

  case 2605:
#line 16771 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_binary_op (yyvsp[-2], '/', yyvsp[0]); }
#line 27103 "parser.c" /* yacc.c:1652  */
    break;

  case 2606:
#line 16772 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27109 "parser.c" /* yacc.c:1652  */
    break;

  case 2607:
#line 16777 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_binary_op (yyvsp[-2], '^', yyvsp[0]);
  }
#line 27117 "parser.c" /* yacc.c:1652  */
    break;

  case 2608:
#line 16780 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27123 "parser.c" /* yacc.c:1652  */
    break;

  case 2609:
#line 16784 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27129 "parser.c" /* yacc.c:1652  */
    break;

  case 2610:
#line 16785 "parser.y" /* yacc.c:1652  */
    { yyval = cb_build_binary_op (cb_zero, '-', yyvsp[0]); }
#line 27135 "parser.c" /* yacc.c:1652  */
    break;

  case 2611:
#line 16786 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27141 "parser.c" /* yacc.c:1652  */
    break;

  case 2612:
#line 16789 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 27147 "parser.c" /* yacc.c:1652  */
    break;

  case 2613:
#line 16790 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27153 "parser.c" /* yacc.c:1652  */
    break;

  case 2614:
#line 16801 "parser.y" /* yacc.c:1652  */
    {
	if (current_linage > 1) {
		cb_error (_("LINAGE-COUNTER must be qualified here"));
		yyval = cb_error_node;
	} else if (current_linage == 0) {
		cb_error (_("invalid LINAGE-COUNTER usage"));
		yyval = cb_error_node;
	} else {
		yyval = linage_file->linage_ctr;
	}
  }
#line 27169 "parser.c" /* yacc.c:1652  */
    break;

  case 2615:
#line 16813 "parser.y" /* yacc.c:1652  */
    {
	if (CB_FILE_P (cb_ref (yyvsp[0]))) {
		yyval = CB_FILE (cb_ref (yyvsp[0]))->linage_ctr;
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a file name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27182 "parser.c" /* yacc.c:1652  */
    break;

  case 2616:
#line 16822 "parser.y" /* yacc.c:1652  */
    {
	if (report_count > 1) {
		if (current_report != NULL) {
			yyval = current_report->line_counter;
		} else {
			cb_error (_("LINE-COUNTER must be qualified here"));
			yyval = cb_error_node;
		}
	} else if (report_count == 0) {
		cb_error (_("invalid LINE-COUNTER usage"));
		yyval = cb_error_node;
	} else {
		yyval = report_instance->line_counter;
	}
  }
#line 27202 "parser.c" /* yacc.c:1652  */
    break;

  case 2617:
#line 16838 "parser.y" /* yacc.c:1652  */
    {
	if (CB_REF_OR_REPORT_P (yyvsp[0])) {
		yyval = CB_REPORT_PTR (yyvsp[0])->line_counter;
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a report name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27215 "parser.c" /* yacc.c:1652  */
    break;

  case 2618:
#line 16847 "parser.y" /* yacc.c:1652  */
    {
	if (report_count > 1) {
		if (current_report != NULL) {
			yyval = current_report->page_counter;
		} else {
			cb_error (_("PAGE-COUNTER must be qualified here"));
			yyval = cb_error_node;
		}
	} else if (report_count == 0) {
		cb_error (_("invalid PAGE-COUNTER usage"));
		yyval = cb_error_node;
	} else {
		yyval = report_instance->page_counter;
	}
  }
#line 27235 "parser.c" /* yacc.c:1652  */
    break;

  case 2619:
#line 16863 "parser.y" /* yacc.c:1652  */
    {
	if (CB_REF_OR_REPORT_P (yyvsp[0])) {
		yyval = CB_REPORT_PTR (yyvsp[0])->page_counter;
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a report name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27248 "parser.c" /* yacc.c:1652  */
    break;

  case 2620:
#line 16877 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27254 "parser.c" /* yacc.c:1652  */
    break;

  case 2621:
#line 16879 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 27260 "parser.c" /* yacc.c:1652  */
    break;

  case 2622:
#line 16884 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-1]);
  }
#line 27268 "parser.c" /* yacc.c:1652  */
    break;

  case 2623:
#line 16892 "parser.y" /* yacc.c:1652  */
    { cb_build_identifier (yyvsp[0], 0); }
#line 27274 "parser.c" /* yacc.c:1652  */
    break;

  case 2624:
#line 16899 "parser.y" /* yacc.c:1652  */
    {
	if (!CB_FILE_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("%s requires a record name as subject"),
			current_statement->name);
		yyval = cb_error_node;
	}
  }
#line 27288 "parser.c" /* yacc.c:1652  */
    break;

  case 2625:
#line 16909 "parser.y" /* yacc.c:1652  */
    {
	if (CB_FILE_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a file name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27301 "parser.c" /* yacc.c:1652  */
    break;

  case 2626:
#line 16923 "parser.y" /* yacc.c:1652  */
    {
	cb_tree x;

	x = cb_ref (yyvsp[0]);
	if (!CB_FIELD_P (x)) {
		yyval = cb_error_node;
	} else if (!CB_FIELD (x)->index_list) {
		cb_error_x (yyvsp[0], _("'%s' not indexed"), cb_name (yyvsp[0]));
		listprint_suppress ();
		cb_note_x (COB_WARNOPT_NONE, x, _("'%s' defined here"), cb_name (x));
		listprint_restore ();
		yyval = cb_error_node;
	} else {
		yyval = yyvsp[0];
	}
  }
#line 27322 "parser.c" /* yacc.c:1652  */
    break;

  case 2627:
#line 16945 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 27330 "parser.c" /* yacc.c:1652  */
    break;

  case 2628:
#line 16949 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;

	if (CB_VALID_TREE (yyvsp[0])) {
		for (l = yyvsp[-1]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l)) &&
			    !strcasecmp (CB_NAME (yyvsp[0]), CB_NAME (CB_VALUE (l)))) {
				cb_error_x (yyvsp[0], _("multiple reference to '%s' "),
					    CB_NAME (yyvsp[0]));
				break;
			}
		}
		if (!l) {
			yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
		}
	}
  }
#line 27352 "parser.c" /* yacc.c:1652  */
    break;

  case 2629:
#line 16970 "parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 27360 "parser.c" /* yacc.c:1652  */
    break;

  case 2630:
#line 16974 "parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;

	if (CB_VALID_TREE (yyvsp[0])) {
		for (l = yyvsp[-2]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l)) &&
			    !strcasecmp (CB_NAME (yyvsp[0]), CB_NAME (CB_VALUE (l)))) {
				cb_error_x (yyvsp[0], _("multiple reference to '%s' "),
					    CB_NAME (yyvsp[-1]));
				break;
			}
		}
		if (!l) {
			yyval = cb_list_add (yyvsp[-2], yyvsp[0]);
		}
	}
  }
#line 27382 "parser.c" /* yacc.c:1652  */
    break;

  case 2631:
#line 16995 "parser.y" /* yacc.c:1652  */
    {
	if (CB_FILE_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a file name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27395 "parser.c" /* yacc.c:1652  */
    break;

  case 2632:
#line 17007 "parser.y" /* yacc.c:1652  */
    {
	if (CB_CD_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a CD name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27408 "parser.c" /* yacc.c:1652  */
    break;

  case 2633:
#line 17021 "parser.y" /* yacc.c:1652  */
    {
	if (CB_REF_OR_REPORT_P (yyvsp[0])) {
		yyval = yyvsp[0];
	} else {
		cb_error (_("'%s' is not a valid report name"), CB_NAME (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 27421 "parser.c" /* yacc.c:1652  */
    break;

  case 2634:
#line 17034 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 27427 "parser.c" /* yacc.c:1652  */
    break;

  case 2635:
#line 17036 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 27433 "parser.c" /* yacc.c:1652  */
    break;

  case 2636:
#line 17040 "parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 27439 "parser.c" /* yacc.c:1652  */
    break;

  case 2637:
#line 17046 "parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 27445 "parser.c" /* yacc.c:1652  */
    break;

  case 2638:
#line 17048 "parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 27451 "parser.c" /* yacc.c:1652  */
    break;

  case 2639:
#line 17053 "parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_reference ((char *)(CB_LITERAL (yyvsp[0])->dat