/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.javax;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.apache.wicket.Application;
import org.apache.wicket.IApplicationListener;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.javax.JavaxWebSocketProcessor;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketEndpoint
extends Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(WicketEndpoint.class);
    private static final String WICKET_APP_PARAM_NAME = "wicket-app-name";
    private final AtomicBoolean applicationDestroyed = new AtomicBoolean(false);
    private JavaxWebSocketProcessor javaxWebSocketProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        String appName = this.getApplicationName(session);
        WebApplication app = (WebApplication)WebApplication.get((String)appName);
        app.getApplicationListeners().add((Object)new ApplicationListener(this.applicationDestroyed));
        try {
            ThreadContext.setApplication((Application)app);
            this.javaxWebSocketProcessor = new JavaxWebSocketProcessor(session, app, endpointConfig);
        }
        finally {
            ThreadContext.detach();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        if (this.isApplicationAlive()) {
            this.javaxWebSocketProcessor.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }
    }

    public void onError(Session session, Throwable t) {
        if (this.isIgnorableError(t)) {
            LOG.debug("An error occurred in web socket connection with id : {}", (Object)session.getId(), (Object)t);
        } else {
            LOG.error("An error occurred in web socket connection with id : {}", (Object)session.getId(), (Object)t);
        }
        super.onError(session, t);
        if (this.isApplicationAlive()) {
            this.javaxWebSocketProcessor.onError(t);
        }
    }

    private boolean isIgnorableError(Throwable t) {
        return t instanceof EOFException || t instanceof IOException && "Broken pipe".equals(t.getMessage());
    }

    private boolean isApplicationAlive() {
        return !this.applicationDestroyed.get();
    }

    private String getApplicationName(Session session) {
        String appName = null;
        Map parameters = session.getRequestParameterMap();
        if (parameters != null) {
            appName = (String)((List)parameters.get(WICKET_APP_PARAM_NAME)).get(0);
        } else {
            String queryString = session.getQueryString();
            if (!Strings.isEmpty((CharSequence)queryString)) {
                String[] params;
                for (String paramPair : params = Strings.split((String)queryString, (char)'&')) {
                    String[] nameValues = Strings.split((String)paramPair, (char)'=');
                    if (!WICKET_APP_PARAM_NAME.equals(nameValues[0])) continue;
                    appName = nameValues[1];
                }
            }
        }
        Checks.notNull((Object)appName, (String)"The application name cannot be read from the upgrade request's parameters", (Object[])new Object[0]);
        return appName;
    }

    private static class ApplicationListener
    implements IApplicationListener {
        private final AtomicBoolean applicationDestroyed;

        private ApplicationListener(AtomicBoolean applicationDestroyed) {
            this.applicationDestroyed = applicationDestroyed;
        }

        public void onAfterInitialized(Application application) {
        }

        public void onBeforeDestroyed(Application application) {
            this.applicationDestroyed.set(true);
        }
    }
}

