/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class PropertyColumn<T, S>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S, Object> {
    private static final long serialVersionUID = 1L;
    private final String propertyExpression;

    public PropertyColumn(IModel<String> displayModel, S sortProperty, String propertyExpression) {
        super(displayModel, sortProperty);
        this.propertyExpression = propertyExpression;
    }

    public PropertyColumn(IModel<String> displayModel, String propertyExpression) {
        super(displayModel, null);
        this.propertyExpression = propertyExpression;
    }

    @Override
    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        item.add(new Component[]{new Label(componentId, this.createLabelModel(rowModel))});
    }

    protected IModel<?> createLabelModel(IModel<T> rowModel) {
        return this.getDataModel(rowModel);
    }

    public String getPropertyExpression() {
        return this.propertyExpression;
    }

    @Override
    public IModel<Object> getDataModel(IModel<T> rowModel) {
        PropertyModel propertyModel = new PropertyModel(rowModel, this.propertyExpression);
        return propertyModel;
    }
}

