/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.ws.api.HttpSessionCopy;

public class ServletRequestCopy
implements HttpServletRequest {
    private final String contextPath;
    private final String servletPath;
    private final String pathInfo;
    private final String requestUri;
    private final HttpSessionCopy httpSession;
    private final StringBuffer requestURL;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final String method;
    private final String serverName;
    private final int serverPort;
    private final String protocol;
    private final String scheme;
    private final String contentType;
    private final Locale locale;
    private final Enumeration<Locale> locales;
    private final boolean isSecure;
    private final String remoteUser;
    private final String remoteAddr;
    private final String remoteHost;
    private final int remotePort;
    private final String localAddr;
    private final String localName;
    private final int localPort;
    private final String pathTranslated;
    private final String requestedSessionId;
    private final Principal principal;
    private String characterEncoding;

    public ServletRequestCopy(HttpServletRequest request) {
        String s;
        this.servletPath = request.getServletPath();
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.requestUri = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.method = request.getMethod();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.protocol = request.getProtocol();
        this.scheme = request.getScheme();
        this.characterEncoding = request.getCharacterEncoding();
        this.contentType = request.getContentType();
        this.locale = request.getLocale();
        this.locales = request.getLocales();
        this.isSecure = request.isSecure();
        this.remoteUser = request.getRemoteUser();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.remotePort = request.getRemotePort();
        this.localAddr = request.getLocalAddr();
        this.localName = request.getLocalName();
        this.localPort = request.getLocalPort();
        this.pathTranslated = request.getPathTranslated();
        this.requestedSessionId = request.getRequestedSessionId();
        this.principal = request.getUserPrincipal();
        HttpSession session = request.getSession(true);
        this.httpSession = new HttpSessionCopy(session);
        Enumeration e = request.getHeaderNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.headers.put(s, request.getHeader(s));
        }
        e = request.getAttributeNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.attributes.put(s, request.getAttribute(s));
        }
        e = request.getParameterNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.parameters.put(s, request.getParameterValues(s));
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Enumeration<String> getHeaders(final String name) {
        return new Enumeration<String>(){
            boolean hasNext = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasNext && ServletRequestCopy.this.headers.get(name) != null;
            }

            @Override
            public String nextElement() {
                this.hasNext = false;
                return (String)ServletRequestCopy.this.headers.get(name);
            }
        };
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String getParameter(String name) {
        return this.parameters.get(name) != null ? this.parameters.get(name)[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        String _protocol = "ws";
        if ("https".equalsIgnoreCase(this.protocol)) {
            _protocol = "wss";
        }
        return _protocol;
    }

    public String getScheme() {
        String _scheme = "ws";
        if ("https".equalsIgnoreCase(this.scheme)) {
            _scheme = "wss";
        }
        return _scheme;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String value = this.headers.get(name);
        int result = -1;
        if (value != null) {
            result = Integer.parseInt(value, 10);
        }
        return result;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        return this.locales;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }
}

