/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.translog.Translog;

final class TranslogLeafReader
extends LeafReader {
    private final Translog.Index operation;
    private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
    private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);

    TranslogLeafReader(Translog.Index operation) {
        this.operation = operation;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public Terms terms(String field) {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public BinaryDocValues getBinaryDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedDocValues getSortedDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedSetDocValues getSortedSetDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNormValues(String field) {
        throw new UnsupportedOperationException();
    }

    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException();
    }

    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    public PointValues getPointValues(String field) {
        throw new UnsupportedOperationException();
    }

    public void checkIntegrity() {
    }

    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public Fields getTermVectors(int docID) {
        throw new UnsupportedOperationException();
    }

    public int numDocs() {
        return 1;
    }

    public int maxDoc() {
        return 1;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        if (docID != 0) {
            throw new IllegalArgumentException("no such doc ID " + docID);
        }
        if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
            assert (this.operation.source().toBytesRef().offset == 0);
            assert (this.operation.source().toBytesRef().length == this.operation.source().toBytesRef().bytes.length);
            visitor.binaryField(FAKE_SOURCE_FIELD, this.operation.source().toBytesRef().bytes);
        }
        if (this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
            visitor.stringField(FAKE_ROUTING_FIELD, this.operation.routing().getBytes(StandardCharsets.UTF_8));
        }
        if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
            BytesRef bytesRef = Uid.encodeId(this.operation.id());
            byte[] id = new byte[bytesRef.length];
            System.arraycopy(bytesRef.bytes, bytesRef.offset, id, 0, bytesRef.length);
            visitor.stringField(FAKE_ID_FIELD, id);
        }
    }

    protected void doClose() {
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }
}

