/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.MainClassNamespace;
import aQute.bnd.service.externalplugin.ExternalPluginNamespace;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.progress.TaskManager;
import aQute.bnd.service.result.FunctionWithException;
import aQute.bnd.service.result.Result;
import aQute.bnd.version.MavenVersion;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.command.Command;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;

public class WorkspaceExternalPluginHandler
implements AutoCloseable {
    final Workspace workspace;

    WorkspaceExternalPluginHandler(Workspace workspace) {
        this.workspace = workspace;
    }

    /*
     * Loose catch block
     */
    public <T, R> Result<R, String> call(String pluginName, Class<T> c, FunctionWithException<T, Result<R, String>> f) {
        Result<R, String> result;
        Throwable throwable;
        URLClassLoader cl;
        block24: {
            block25: {
                String filter = ExternalPluginNamespace.filter(pluginName, c);
                Optional<Capability> optCap = this.workspace.findProviders("bnd.external.plugin", filter).findAny();
                if (!optCap.isPresent()) {
                    return Result.err("no such plugin %s for type %s", pluginName, c.getName());
                }
                Capability cap = optCap.get();
                Result<File, String> bundle = this.workspace.getBundle(cap.getResource());
                if (bundle.isErr()) {
                    return bundle.asError();
                }
                Object object = cap.getAttributes().get("implementation");
                if (object == null || !(object instanceof String)) {
                    return Result.err("no proper class attribute in plugin capability %s is %s", pluginName, object);
                }
                String className = (String)object;
                URL url = bundle.unwrap().toURI().toURL();
                cl = new URLClassLoader(new URL[]{url}, WorkspaceExternalPluginHandler.class.getClassLoader());
                throwable = null;
                Class<?> impl = cl.loadClass(className);
                T instance = c.cast(impl.newInstance());
                result = f.apply(instance);
                if (cl == null) break block24;
                if (throwable == null) break block25;
                try {
                    cl.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block24;
            }
            cl.close();
        }
        return result;
        {
            catch (Exception e) {
                Result result2;
                block26: {
                    block27: {
                        result2 = Result.err("external plugin '%s' failed with: %s", pluginName, Exceptions.causes(e));
                        if (cl == null) break block26;
                        if (throwable == null) break block27;
                        try {
                            cl.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    cl.close();
                }
                return result2;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (cl != null) {
                                if (throwable != null) {
                                    try {
                                        cl.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    cl.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (ClassNotFoundException e2) {
                        return Result.err("no such class %s in %s for plugin %s", e2.getMessage(), pluginName);
                    }
                    catch (Exception e3) {
                        return Result.err("could not instantiate class %s in %s for plugin %s: %s", e3.getMessage(), pluginName, Exceptions.causes(e3));
                    }
                }
            }
        }
    }

    public Result<Integer, String> call(String mainClass, VersionRange range, Processor context, Map<String, String> attrs, List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        ArrayList<File> cp = new ArrayList<File>();
        try {
            String filter = MainClassNamespace.filter(mainClass, range);
            Optional<Capability> optCap = this.workspace.findProviders("bnd.mainclass", filter).findAny();
            if (!optCap.isPresent()) {
                return Result.err("no such main class %s", mainClass);
            }
            Capability cap = optCap.get();
            Result<File, String> bundle = this.workspace.getBundle(cap.getResource());
            if (bundle.isErr()) {
                return bundle.asError();
            }
            cp.add(bundle.unwrap());
            Command c = new Command();
            c.setTrace();
            File cwd = context.getBase();
            String workingdir = attrs.get("workingdir");
            if (workingdir != null) {
                cwd = context.getFile(workingdir);
                cwd.mkdirs();
                if (!cwd.isDirectory()) {
                    return Result.err("Working dir set to %s but cannot make it a directory", cwd);
                }
            }
            c.setCwd(cwd);
            c.setTimeout(1L, TimeUnit.MINUTES);
            c.add(context.getProperty("java", IO.getJavaExecutablePath("java")));
            c.add("-cp");
            Parameters cpp = new Parameters(attrs.get("classpath"));
            for (Map.Entry<String, Attrs> entry : cpp.entrySet()) {
                String v = entry.getValue().getVersion();
                MavenVersion mv = MavenVersion.parseMavenString(v);
                Result<File, String> result = this.workspace.getBundle(entry.getKey(), mv.getOSGiVersion(), null);
                if (result.isErr()) {
                    return result.asError();
                }
                cp.add(result.unwrap());
            }
            String classpath = Strings.join(File.pathSeparator, cp);
            c.add(classpath);
            c.add(mainClass);
            for (String arg : args) {
                c.add(arg);
            }
            int n = TaskManager.with(this.getTask(c), () -> {
                PrintWriter lstdout = IO.writer(stdout == null ? System.out : stdout);
                PrintWriter lstderr = IO.writer(stderr == null ? System.err : stderr);
                try {
                    Integer n = c.execute(stdin, (Appendable)lstdout, (Appendable)lstderr);
                    return n;
                }
                finally {
                    lstdout.flush();
                    lstderr.flush();
                }
            });
            return Result.ok(n);
        }
        catch (Exception e) {
            return Result.err("Failed with: %s", Exceptions.causes(e));
        }
    }

    private ProgressPlugin.Task getTask(final Command c) {
        return new ProgressPlugin.Task(){
            private boolean canceled;

            @Override
            public void worked(int units) {
            }

            @Override
            public void done(String message, Throwable e) {
            }

            @Override
            public boolean isCanceled() {
                return this.canceled;
            }

            @Override
            public void abort() {
                this.canceled = true;
                c.cancel();
            }
        };
    }

    @Override
    public void close() {
    }
}

