/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProvider;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.indices.analysis.PreBuiltAnalyzers;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public class PreBuiltAnalyzerProviderFactory
extends PreConfiguredAnalysisComponent<AnalyzerProvider<?>>
implements Closeable {
    private final Function<Version, Analyzer> create;
    private final PreBuiltAnalyzerProvider current;

    PreBuiltAnalyzerProviderFactory(String name, PreBuiltAnalyzers preBuiltAnalyzer) {
        super(name, new PreBuiltAnalyzersDelegateCache(name, preBuiltAnalyzer));
        this.create = preBuiltAnalyzer::getAnalyzer;
        Analyzer analyzer = preBuiltAnalyzer.getAnalyzer(Version.CURRENT);
        analyzer.setVersion(Version.CURRENT.luceneVersion);
        this.current = new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, analyzer);
    }

    public PreBuiltAnalyzerProviderFactory(String name, PreBuiltCacheFactory.CachingStrategy cache, Supplier<Analyzer> create) {
        super(name, cache);
        this.create = version -> (Analyzer)create.get();
        Analyzer analyzer = create.get();
        analyzer.setVersion(Version.CURRENT.luceneVersion);
        this.current = new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, analyzer);
    }

    @Override
    public AnalyzerProvider<?> get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(versionCreated)) {
            return (AnalyzerProvider)super.get(indexSettings, environment, name, settings);
        }
        return this.current;
    }

    @Override
    protected AnalyzerProvider<?> create(Version version) {
        assert (!Version.CURRENT.equals(version));
        Analyzer analyzer = this.create.apply(version);
        analyzer.setVersion(version.luceneVersion);
        return new PreBuiltAnalyzerProvider(this.getName(), AnalyzerScope.INDICES, analyzer);
    }

    @Override
    public void close() throws IOException {
        List closeables = this.cache.values().stream().map(AnalyzerProvider::get).collect(Collectors.toList());
        closeables.add(this.current.get());
        IOUtils.close(closeables);
    }

    static class PreBuiltAnalyzersDelegateCache
    implements PreBuiltCacheFactory.PreBuiltCache<AnalyzerProvider<?>> {
        private final String name;
        private final PreBuiltAnalyzers preBuiltAnalyzer;

        private PreBuiltAnalyzersDelegateCache(String name, PreBuiltAnalyzers preBuiltAnalyzer) {
            this.name = name;
            this.preBuiltAnalyzer = preBuiltAnalyzer;
        }

        @Override
        public AnalyzerProvider<?> get(Version version) {
            return new PreBuiltAnalyzerProvider(this.name, AnalyzerScope.INDICES, this.preBuiltAnalyzer.getAnalyzer(version));
        }

        @Override
        public void put(Version version, AnalyzerProvider<?> analyzerProvider) {
        }

        @Override
        public Collection<AnalyzerProvider<?>> values() {
            return this.preBuiltAnalyzer.getCache().values().stream().map(analyzer -> new PreBuiltAnalyzerProvider(this.name, AnalyzerScope.INDICES, (Analyzer)analyzer)).collect(Collectors.toList());
        }
    }
}

