/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="dynamicRouter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DynamicRouterDefinition<Type extends ProcessorDefinition<Type>>
extends NoOutputExpressionNode {
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String uriDelimiter;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;
    @XmlAttribute
    private Integer cacheSize;

    public DynamicRouterDefinition() {
    }

    public DynamicRouterDefinition(Expression expression) {
        super(expression);
    }

    public String toString() {
        return "DynamicRouter[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "dynamicRouter";
    }

    @Override
    public String getLabel() {
        return "dynamicRouter[" + this.getExpression() + "]";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = this.getExpression().createExpression(routeContext);
        String delimiter = this.getUriDelimiter() != null ? this.getUriDelimiter() : DEFAULT_DELIMITER;
        DynamicRouter dynamicRouter = new DynamicRouter(routeContext.getCamelContext(), expression, delimiter);
        if (this.getIgnoreInvalidEndpoints() != null) {
            dynamicRouter.setIgnoreInvalidEndpoints(this.getIgnoreInvalidEndpoints());
        }
        if (this.getCacheSize() != null) {
            dynamicRouter.setCacheSize(this.getCacheSize());
        }
        ErrorHandlerFactory builder = routeContext.getRoute().getErrorHandlerBuilder();
        AsyncProcessor errorHandler = (AsyncProcessor)builder.createErrorHandler(routeContext, dynamicRouter.newRoutingSlipProcessorForErrorHandler());
        dynamicRouter.setErrorHandler(errorHandler);
        return dynamicRouter;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Type end() {
        return (Type)super.end();
    }

    public DynamicRouterDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }

    public DynamicRouterDefinition<Type> uriDelimiter(String uriDelimiter) {
        this.setUriDelimiter(uriDelimiter);
        return this;
    }

    public DynamicRouterDefinition<Type> cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }
}

