/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.controlbus.ControlBusEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class ControlBusProducer
extends DefaultAsyncProducer {
    private static final Expression ROUTE_ID_EXPRESSION = ExpressionBuilder.routeIdExpression();
    private final CamelLogger logger;

    public ControlBusProducer(Endpoint endpoint, CamelLogger logger) {
        super(endpoint);
        this.logger = logger;
    }

    @Override
    public ControlBusEndpoint getEndpoint() {
        return (ControlBusEndpoint)super.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.getEndpoint().getLanguage() != null) {
            try {
                this.processByLanguage(exchange, this.getEndpoint().getLanguage());
            }
            catch (Exception e) {
                exchange.setException(e);
            }
        } else if (this.getEndpoint().getAction() != null) {
            try {
                this.processByAction(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
        }
        callback.done(true);
        return true;
    }

    protected void processByLanguage(Exchange exchange, Language language) throws Exception {
        LanguageTask task = new LanguageTask(exchange, language);
        if (this.getEndpoint().isAsync()) {
            this.getEndpoint().getComponent().getExecutorService().submit(task);
        } else {
            task.run();
        }
    }

    protected void processByAction(Exchange exchange) throws Exception {
        ActionTask task = new ActionTask(exchange);
        if (this.getEndpoint().isAsync()) {
            this.getEndpoint().getComponent().getExecutorService().submit(task);
        } else {
            task.run();
        }
    }

    private final class ActionTask
    implements Runnable {
        private final Exchange exchange;

        private ActionTask(Exchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void run() {
            String action = ControlBusProducer.this.getEndpoint().getAction();
            String id = ControlBusProducer.this.getEndpoint().getRouteId();
            if (ObjectHelper.equal("current", id)) {
                id = ROUTE_ID_EXPRESSION.evaluate(this.exchange, String.class);
            }
            Object result = null;
            String task = action + " route " + id;
            try {
                if ("start".equals(action)) {
                    ControlBusProducer.this.log.debug("Starting route: {}", (Object)id);
                    ControlBusProducer.this.getEndpoint().getCamelContext().startRoute(id);
                } else if ("stop".equals(action)) {
                    ControlBusProducer.this.log.debug("Stopping route: {}", (Object)id);
                    ControlBusProducer.this.getEndpoint().getCamelContext().stopRoute(id);
                } else if ("suspend".equals(action)) {
                    ControlBusProducer.this.log.debug("Suspending route: {}", (Object)id);
                    ControlBusProducer.this.getEndpoint().getCamelContext().suspendRoute(id);
                } else if ("resume".equals(action)) {
                    ControlBusProducer.this.log.debug("Resuming route: {}", (Object)id);
                    ControlBusProducer.this.getEndpoint().getCamelContext().resumeRoute(id);
                } else if ("restart".equals(action)) {
                    ControlBusProducer.this.log.debug("Restarting route: {}", (Object)id);
                    ControlBusProducer.this.getEndpoint().getCamelContext().stopRoute(id);
                    int delay = ControlBusProducer.this.getEndpoint().getRestartDelay();
                    if (delay > 0) {
                        try {
                            ControlBusProducer.this.log.debug("Sleeping {} ms before starting route: {}", (Object)delay, (Object)id);
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ControlBusProducer.this.getEndpoint().getCamelContext().startRoute(id);
                } else if ("status".equals(action)) {
                    ControlBusProducer.this.log.debug("Route status: {}", (Object)id);
                    ServiceStatus status = ControlBusProducer.this.getEndpoint().getCamelContext().getRouteStatus(id);
                    if (status != null) {
                        result = status.name();
                    }
                } else if ("stats".equals(action)) {
                    ControlBusProducer.this.log.debug("Route stats: {}", (Object)id);
                    String name = ControlBusProducer.this.getEndpoint().getCamelContext().getManagementName();
                    if (name == null) {
                        result = "JMX is disabled, cannot get stats";
                    } else {
                        String operation;
                        ObjectName on;
                        if (id == null) {
                            CamelContext camelContext = ControlBusProducer.this.getEndpoint().getCamelContext();
                            on = ControlBusProducer.this.getEndpoint().getCamelContext().getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(camelContext);
                            operation = "dumpRoutesStatsAsXml";
                        } else {
                            Route route = ControlBusProducer.this.getEndpoint().getCamelContext().getRoute(id);
                            on = ControlBusProducer.this.getEndpoint().getCamelContext().getManagementStrategy().getManagementNamingStrategy().getObjectNameForRoute(route);
                            operation = "dumpRouteStatsAsXml";
                        }
                        if (on != null) {
                            MBeanServer server = ControlBusProducer.this.getEndpoint().getCamelContext().getManagementStrategy().getManagementAgent().getMBeanServer();
                            result = server.invoke(on, operation, new Object[]{true, true}, new String[]{"boolean", "boolean"});
                        } else {
                            result = "Cannot lookup route with id " + id;
                        }
                    }
                }
                if (result != null && !ControlBusProducer.this.getEndpoint().isAsync()) {
                    this.exchange.getIn().setBody(result);
                }
                ControlBusProducer.this.logger.log("ControlBus task done [" + task + "] with result -> " + (result != null ? result : "void"));
            }
            catch (Exception e) {
                ControlBusProducer.this.logger.log("Error executing ControlBus task [" + task + "]. This exception will be ignored.", e);
            }
        }
    }

    private final class LanguageTask
    implements Runnable {
        private final Exchange exchange;
        private final Language language;

        private LanguageTask(Exchange exchange, Language language) {
            this.exchange = exchange;
            this.language = language;
        }

        @Override
        public void run() {
            String task = null;
            Object result = null;
            try {
                Exchange dummy = ExchangeHelper.createCopy(this.exchange, true);
                task = dummy.getIn().getMandatoryBody(String.class);
                if (task != null) {
                    Expression exp = this.language.createExpression(task);
                    result = exp.evaluate(dummy, Object.class);
                }
                if (result != null && !ControlBusProducer.this.getEndpoint().isAsync()) {
                    this.exchange.getIn().setBody(result);
                }
                if (task != null) {
                    ControlBusProducer.this.logger.log("ControlBus task done [" + task + "] with result -> " + (result != null ? result : "void"));
                }
            }
            catch (Exception e) {
                ControlBusProducer.this.logger.log("Error executing ControlBus task [" + task + "]. This exception will be ignored.", e);
            }
        }
    }
}

