/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.lib.converter.Converter;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class Annotation {
    private static final Converter CONVERTER = new Converter();
    private final Descriptors.TypeRef name;
    private Map<String, Object> elements;
    private final ElementType member;
    private final RetentionPolicy policy;

    public Annotation(Descriptors.TypeRef name, Map<String, Object> elements, ElementType member, RetentionPolicy policy) {
        this.name = Objects.requireNonNull(name);
        this.elements = elements;
        this.member = Objects.requireNonNull(member);
        this.policy = Objects.requireNonNull(policy);
    }

    @Deprecated
    public Annotation(Descriptors.TypeRef name, Map<String, Object> elements, java.lang.annotation.ElementType member, RetentionPolicy policy) {
        this(name, elements, ElementType.valueOf(member.name()), policy);
    }

    public Descriptors.TypeRef getName() {
        return this.name;
    }

    public ElementType elementType() {
        return this.member;
    }

    @Deprecated
    public java.lang.annotation.ElementType getElementType() {
        return java.lang.annotation.ElementType.valueOf(this.elementType().name());
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.policy;
    }

    public String toString() {
        Iterator<Map.Entry<String, Object>> i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(':').append((Object)this.member).append(':').append((Object)this.policy).append(':').append('{');
        if (this.elements != null && (i = this.elements.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> e = i.next();
            while (true) {
                sb.append(e.getKey()).append('=');
                Object v = e.getValue();
                if (v instanceof Object[]) {
                    sb.append(Arrays.toString((Object[])v));
                } else {
                    sb.append(v);
                }
                if (!i.hasNext()) break;
                sb.append(',').append(' ');
                e = i.next();
            }
        }
        return sb.append('}').toString();
    }

    public <T> T get(String string) {
        if (this.elements == null) {
            return null;
        }
        return (T)this.elements.get(string);
    }

    public <T> Stream<T> stream(String key, Class<? extends T> type) {
        T v = this.get(key);
        if (v == null) {
            return Stream.empty();
        }
        if (v.getClass().isArray()) {
            return Arrays.stream((Object[])v).map(type::cast);
        }
        return Stream.of(v).map(type::cast);
    }

    public void put(String string, Object v) {
        if (this.elements == null) {
            this.elements = new LinkedHashMap<String, Object>();
        }
        this.elements.put(string, v);
    }

    public boolean containsKey(String key) {
        if (this.elements == null) {
            return false;
        }
        return this.elements.containsKey(key);
    }

    public Set<String> keySet() {
        if (this.elements == null) {
            return Collections.emptySet();
        }
        return this.elements.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.elements == null) {
            return Collections.emptySet();
        }
        return this.elements.entrySet();
    }

    public <T extends java.lang.annotation.Annotation> T getAnnotation() throws Exception {
        return this.getAnnotation(this.getClass().getClassLoader());
    }

    public <T extends java.lang.annotation.Annotation> T getAnnotation(ClassLoader cl) throws Exception {
        String cname = this.name.getFQN();
        try {
            Class<?> c = cl.loadClass(cname);
            return (T)this.getAnnotation(c);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public <T extends java.lang.annotation.Annotation> T getAnnotation(Class<T> c) throws Exception {
        if (this.elements == null) {
            this.elements = new LinkedHashMap<String, Object>();
        }
        return (T)((java.lang.annotation.Annotation)CONVERTER.convert(c, this.elements));
    }

    public void merge(Annotation annotation) {
        this.merge(annotation.elements);
    }

    public void addDefaults(Clazz c) throws Exception {
        this.merge(c.getDefaults());
    }

    private void merge(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.elements == null) {
            this.elements = new LinkedHashMap<String, Object>(map);
        } else {
            map.forEach(this.elements::putIfAbsent);
        }
    }

    static {
        CONVERTER.hook(null, (t, o) -> {
            if (o instanceof Annotation && t instanceof Class && ((Class)t).isAnnotation()) {
                Annotation a = (Annotation)o;
                Class c = (Class)t;
                return a.getAnnotation(c);
            }
            return null;
        });
    }

    public static enum ElementType {
        TYPE,
        FIELD,
        METHOD,
        PARAMETER,
        CONSTRUCTOR,
        LOCAL_VARIABLE,
        ANNOTATION_TYPE,
        PACKAGE,
        TYPE_PARAMETER,
        TYPE_USE,
        MODULE;

    }
}

