/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.similarity.LegacyBM25Similarity;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.NonNegativeScoresSimilarity;
import org.elasticsearch.index.similarity.ScriptedSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProviders;
import org.elasticsearch.script.ScriptService;

public final class SimilarityService
extends AbstractIndexComponent {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(SimilarityService.class));
    public static final String DEFAULT_SIMILARITY = "BM25";
    private static final String CLASSIC_SIMILARITY = "classic";
    private static final Map<String, Function<Version, Supplier<Similarity>>> DEFAULTS;
    public static final Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> BUILT_IN;
    private final Similarity defaultSimilarity;
    private final Map<String, Supplier<Similarity>> similarities;

    public SimilarityService(IndexSettings indexSettings, ScriptService scriptService, Map<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarities) {
        super(indexSettings);
        HashMap<String, Supplier<Similarity>> providers = new HashMap<String, Supplier<Similarity>>(similarities.size());
        Map<String, Settings> similaritySettings = this.indexSettings.getSettings().getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            if (BUILT_IN.containsKey(name)) {
                throw new IllegalArgumentException("Cannot redefine built-in Similarity [" + name + "]");
            }
            Settings providerSettings = entry.getValue();
            String typeName = providerSettings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!(similarities.containsKey(typeName) || BUILT_IN.containsKey(typeName))) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            TriFunction<Settings, Version, ScriptService, Similarity> defaultFactory = BUILT_IN.get(typeName);
            TriFunction<Settings, Version, ScriptService, Similarity> factory = similarities.getOrDefault(typeName, defaultFactory);
            Similarity similarity = factory.apply(providerSettings, indexSettings.getIndexVersionCreated(), scriptService);
            SimilarityService.validateSimilarity(indexSettings.getIndexVersionCreated(), similarity);
            if (!BUILT_IN.containsKey(typeName) || "scripted".equals(typeName)) {
                similarity = new NonNegativeScoresSimilarity(similarity);
            }
            Similarity similarityF = similarity;
            providers.put(name, () -> similarityF);
        }
        for (Map.Entry<String, Object> entry : DEFAULTS.entrySet()) {
            providers.put(entry.getKey(), (Supplier)((Function)entry.getValue()).apply(indexSettings.getIndexVersionCreated()));
        }
        this.similarities = providers;
        Similarity similarity = this.defaultSimilarity = providers.get("default") != null ? (Similarity)((Supplier)providers.get("default")).get() : (Similarity)((Supplier)providers.get(DEFAULT_SIMILARITY)).get();
        if (providers.get("base") != null) {
            deprecationLogger.deprecated("The [base] similarity is ignored since query normalization and coords have been removed", new Object[0]);
        }
    }

    public Similarity similarity(MapperService mapperService) {
        return mapperService != null ? new PerFieldSimilarity(this.defaultSimilarity, mapperService) : this.defaultSimilarity;
    }

    public SimilarityProvider getSimilarity(String name) {
        Supplier<Similarity> sim = this.similarities.get(name);
        if (sim == null) {
            return null;
        }
        return new SimilarityProvider(name, sim.get());
    }

    Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    static void validateSimilarity(Version indexCreatedVersion, Similarity similarity) {
        SimilarityService.validateScoresArePositive(indexCreatedVersion, similarity);
        SimilarityService.validateScoresDoNotDecreaseWithFreq(indexCreatedVersion, similarity);
        SimilarityService.validateScoresDoNotIncreaseWithNorm(indexCreatedVersion, similarity);
    }

    private static void validateScoresArePositive(Version indexCreatedVersion, Similarity similarity) {
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef((CharSequence)"some_value"), 100L, 130L);
        Similarity.SimScorer scorer = similarity.scorer(2.0f, collectionStats, new TermStatistics[]{termStats});
        FieldInvertState state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", IndexOptions.DOCS_AND_FREQS, 20, 20, 0, 50, 10, 3);
        long norm = similarity.computeNorm(state);
        for (int freq = 1; freq <= 10; ++freq) {
            float score = scorer.score((float)freq, norm);
            if (!(score < 0.0f)) continue;
            SimilarityService.fail(indexCreatedVersion, "Similarities should not return negative scores:\n" + scorer.explain(Explanation.match((Number)freq, (String)"term freq", (Explanation[])new Explanation[0]), norm));
            break;
        }
    }

    private static void validateScoresDoNotDecreaseWithFreq(Version indexCreatedVersion, Similarity similarity) {
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef((CharSequence)"some_value"), 100L, 130L);
        Similarity.SimScorer scorer = similarity.scorer(2.0f, collectionStats, new TermStatistics[]{termStats});
        FieldInvertState state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", IndexOptions.DOCS_AND_FREQS, 20, 20, 0, 50, 10, 3);
        long norm = similarity.computeNorm(state);
        float previousScore = 0.0f;
        for (int freq = 1; freq <= 10; ++freq) {
            float score = scorer.score((float)freq, norm);
            if (score < previousScore) {
                SimilarityService.fail(indexCreatedVersion, "Similarity scores should not decrease when term frequency increases:\n" + scorer.explain(Explanation.match((Number)(freq - 1), (String)"term freq", (Explanation[])new Explanation[0]), norm) + "\n" + scorer.explain(Explanation.match((Number)freq, (String)"term freq", (Explanation[])new Explanation[0]), norm));
                break;
            }
            previousScore = score;
        }
    }

    private static void validateScoresDoNotIncreaseWithNorm(Version indexCreatedVersion, Similarity similarity) {
        FieldInvertState state;
        long norm;
        CollectionStatistics collectionStats = new CollectionStatistics("some_field", 1200L, 1100L, 3000L, 2000L);
        TermStatistics termStats = new TermStatistics(new BytesRef((CharSequence)"some_value"), 100L, 130L);
        Similarity.SimScorer scorer = similarity.scorer(2.0f, collectionStats, new TermStatistics[]{termStats});
        long previousNorm = 0L;
        float previousScore = Float.MAX_VALUE;
        for (int length = 1; length <= 10 && Long.compareUnsigned(previousNorm, norm = similarity.computeNorm(state = new FieldInvertState(indexCreatedVersion.luceneVersion.major, "some_field", IndexOptions.DOCS_AND_FREQS, length, length, 0, 50, 10, 3))) <= 0; ++length) {
            float score = scorer.score(1.0f, norm);
            if (score > previousScore) {
                SimilarityService.fail(indexCreatedVersion, "Similarity scores should not increase when norm increases:\n" + scorer.explain(Explanation.match((Number)1, (String)"term freq", (Explanation[])new Explanation[0]), norm - 1L) + "\n" + scorer.explain(Explanation.match((Number)1, (String)"term freq", (Explanation[])new Explanation[0]), norm));
                break;
            }
            previousScore = score;
            previousNorm = norm;
        }
    }

    private static void fail(Version indexCreatedVersion, String message) {
        if (indexCreatedVersion.onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException(message);
        }
        if (indexCreatedVersion.onOrAfter(Version.V_6_5_0)) {
            deprecationLogger.deprecated(message, new Object[0]);
        }
    }

    private static /* synthetic */ Similarity lambda$static$5(Similarity similarity) {
        return similarity;
    }

    static {
        HashMap<String, Function<Version, Supplier>> defaults = new HashMap<String, Function<Version, Supplier>>();
        defaults.put(CLASSIC_SIMILARITY, version -> {
            if (version.onOrAfter(Version.V_7_0_0)) {
                return () -> {
                    throw new IllegalArgumentException("The [classic] similarity may not be used anymore. Please use the [BM25] similarity or build a custom [scripted] similarity instead.");
                };
            }
            ClassicSimilarity similarity = SimilarityProviders.createClassicSimilarity(Settings.EMPTY, version);
            return () -> {
                deprecationLogger.deprecated("The [classic] similarity is now deprecated in favour of BM25, which is generally accepted as a better alternative. Use the [BM25] similarity or build a custom [scripted] similarity instead.", new Object[0]);
                return similarity;
            };
        });
        defaults.put(DEFAULT_SIMILARITY, version -> {
            LegacyBM25Similarity similarity = SimilarityProviders.createBM25Similarity(Settings.EMPTY, version);
            return () -> similarity;
        });
        defaults.put("boolean", version -> {
            BooleanSimilarity similarity = new BooleanSimilarity();
            return () -> SimilarityService.lambda$static$5((Similarity)similarity);
        });
        HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>> builtIn = new HashMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>();
        builtIn.put(CLASSIC_SIMILARITY, (settings, version, script) -> {
            if (version.onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("The [classic] similarity may not be used anymore. Please use the [BM25] similarity or build a custom [scripted] similarity instead.");
            }
            deprecationLogger.deprecated("The [classic] similarity is now deprecated in favour of BM25, which is generally accepted as a better alternative. Use the [BM25] similarity or build a custom [scripted] similarity instead.", new Object[0]);
            return SimilarityProviders.createClassicSimilarity(settings, version);
        });
        builtIn.put(DEFAULT_SIMILARITY, (settings, version, scriptService) -> SimilarityProviders.createBM25Similarity(settings, version));
        builtIn.put("boolean", (settings, version, scriptService) -> SimilarityProviders.createBooleanSimilarity(settings, version));
        builtIn.put("DFR", (settings, version, scriptService) -> SimilarityProviders.createDfrSimilarity(settings, version));
        builtIn.put("IB", (settings, version, scriptService) -> SimilarityProviders.createIBSimilarity(settings, version));
        builtIn.put("LMDirichlet", (settings, version, scriptService) -> SimilarityProviders.createLMDirichletSimilarity(settings, version));
        builtIn.put("LMJelinekMercer", (settings, version, scriptService) -> SimilarityProviders.createLMJelinekMercerSimilarity(settings, version));
        builtIn.put("DFI", (settings, version, scriptService) -> SimilarityProviders.createDfiSimilarity(settings, version));
        builtIn.put("scripted", new ScriptedSimilarityProvider());
        DEFAULTS = Collections.unmodifiableMap(defaults);
        BUILT_IN = Collections.unmodifiableMap(builtIn);
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, MapperService mapperService) {
            this.defaultSimilarity = defaultSimilarity;
            this.mapperService = mapperService;
        }

        public Similarity get(String name) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            return fieldType != null && fieldType.similarity() != null ? fieldType.similarity().get() : this.defaultSimilarity;
        }
    }
}

