/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.metrics.commands;

import java.util.ArrayList;
import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.Row;
import org.apache.karaf.shell.table.ShellTable;
import org.apache.unomi.metrics.commands.MetricsCommandSupport;

@Command(scope="metrics", name="caller-status", description="This command will list all the caller configurations, or change the caller status of a specific metric")
public class CallerStatusCommand
extends MetricsCommandSupport {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Argument(index=0, name="metricName", description="The identifier for the metric", required=false, multiValued=false)
    String metricName;
    @Argument(index=1, name="status", description="The new status for the metric's caller tracing", required=false, multiValued=false)
    Boolean metricStatus;

    protected Object doExecute() throws Exception {
        if (this.metricName != null && this.metricStatus != null) {
            this.metricsService.setCallerActivated(this.metricName, this.metricStatus);
            System.out.println("Metric callers " + this.metricName + " set to " + this.metricStatus);
            return null;
        }
        Map<String, Boolean> callersStatus = this.metricsService.getCallersStatus();
        ShellTable shellTable = new ShellTable();
        shellTable.column("Metric");
        shellTable.column("Activated");
        for (Map.Entry<String, Boolean> callerStatusEntry : callersStatus.entrySet()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(callerStatusEntry.getKey());
            rowData.add(callerStatusEntry.getValue() != false ? "x" : "");
            Row row = shellTable.addRow();
            row.addContent(new Object[]{rowData});
        }
        shellTable.print(System.out, !this.noFormat);
        return null;
    }
}

