/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.features.FeaturesService;
import org.apache.unomi.api.ServerInfo;
import org.apache.unomi.lifecycle.BundleWatcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWatcherImpl
implements SynchronousBundleListener,
ServiceListener,
BundleWatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)BundleWatcherImpl.class.getName());
    private static final String CDP_GRAPHQL_FEATURE = "cdp-graphql-feature";
    private long startupTime;
    private Map<String, Boolean> requiredBundles = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> requiredBundlesFromFeatures = new ConcurrentHashMap<String, Boolean>();
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;
    private FeaturesService featuresService;
    private String requiredServices;
    private Set<Filter> requiredServicesFilters = new LinkedHashSet<Filter>();
    private long matchedRequiredServicesCount = 0L;
    private BundleContext bundleContext;
    private boolean startupMessageAlreadyDisplayed = false;
    private boolean shutdownMessageAlreadyDisplayed = false;
    private Integer checkStartupStateRefreshInterval = 60;
    private Set<String> featuresToInstall = ConcurrentHashMap.newKeySet();
    private boolean installingFeatureStarted = false;
    private List<ServerInfo> serverInfos = new ArrayList<ServerInfo>();

    public void setRequiredBundles(Map<String, Boolean> requiredBundles) {
        this.requiredBundles = new ConcurrentHashMap<String, Boolean>(requiredBundles);
    }

    public void setCheckStartupStateRefreshInterval(Integer checkStartupStateRefreshInterval) {
        this.checkStartupStateRefreshInterval = checkStartupStateRefreshInterval;
    }

    public void setRequiredServices(String requiredServices) {
        this.requiredServices = requiredServices;
        String[] requiredServiceArray = requiredServices.split(",");
        this.requiredServicesFilters.clear();
        for (String requiredService : requiredServiceArray) {
            try {
                this.requiredServicesFilters.add(this.bundleContext.createFilter(requiredService.trim()));
            }
            catch (InvalidSyntaxException e) {
                logger.error("Error creating require service filter {}", (Object)requiredService.trim(), (Object)e);
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.prepareGraphQLFeatureToInstall();
        this.checkExistingBundles();
        this.bundleContext.addBundleListener((BundleListener)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.startupTime = System.currentTimeMillis();
        System.out.println("Initializing Unomi...");
        logger.info("Bundle watcher initialized.");
    }

    @Override
    public List<ServerInfo> getServerInfos() {
        return this.serverInfos;
    }

    private boolean allBundleStarted() {
        return this.getInactiveBundles(this.requiredBundles).isEmpty();
    }

    @Override
    public boolean allAdditionalBundleStarted() {
        return this.getInactiveBundles(this.requiredBundlesFromFeatures).isEmpty();
    }

    private void displayLogsForInactiveBundles(Map<String, Boolean> bundles) {
        this.getInactiveBundles(bundles).forEach(inactiveBundle -> logger.warn("The bundle {} is in not active, some errors could happen when using the application", inactiveBundle));
    }

    private List<String> getInactiveBundles(Map<String, Boolean> bundles) {
        return bundles.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void destroy() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext.removeBundleListener((BundleListener)this);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        logger.info("Bundle watcher shutdown.");
    }

    public void checkExistingBundles() {
        this.serverInfos.clear();
        this.serverInfos.add(this.getBundleServerInfo(this.bundleContext.getBundle()));
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ServerInfo serverInfo;
            this.checkInBundlesList(bundle, this.requiredBundles);
            this.checkInBundlesList(bundle, this.requiredBundlesFromFeatures);
            if (bundle.getSymbolicName().equals(this.bundleContext.getBundle().getSymbolicName()) || (serverInfo = this.getBundleServerInfo(bundle)) == null) continue;
            this.serverInfos.add(serverInfo);
        }
        this.checkStartupComplete();
    }

    private void checkInBundlesList(Bundle bundle, Map<String, Boolean> bundles) {
        if (bundle.getSymbolicName().startsWith("org.apache.unomi") && bundles.containsKey(bundle.getSymbolicName())) {
            if (bundle.getState() == 32) {
                bundles.put(bundle.getSymbolicName(), true);
            } else {
                bundles.put(bundle.getSymbolicName(), false);
            }
        }
    }

    private void managedBundleEvent(Bundle bundle, Map<String, Boolean> bundles, Boolean start) {
        if (bundle.getSymbolicName().startsWith("org.apache.unomi") && bundles.containsKey(bundle.getSymbolicName())) {
            logger.info("Bundle {} was {}.", (Object)bundle.getSymbolicName(), (Object)(start != false ? "started" : "stopped"));
            bundles.put(bundle.getSymbolicName(), start);
            if (start.booleanValue()) {
                this.checkStartupComplete();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                break;
            }
            case 2: {
                this.managedBundleEvent(event.getBundle(), this.requiredBundles, true);
                this.managedBundleEvent(event.getBundle(), this.requiredBundlesFromFeatures, true);
                break;
            }
            case 256: {
                break;
            }
            case 4: {
                this.managedBundleEvent(event.getBundle(), this.requiredBundles, false);
                this.managedBundleEvent(event.getBundle(), this.requiredBundlesFromFeatures, false);
                break;
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        if (serviceReference == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.addStartedService(serviceReference);
                this.checkStartupComplete();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.removeStartedService(serviceReference);
            }
        }
    }

    private void addStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            ++this.matchedRequiredServicesCount;
        }
    }

    private void removeStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            --this.matchedRequiredServicesCount;
            if (!this.shutdownMessageAlreadyDisplayed) {
                System.out.println("Apache Unomi shutting down...");
                logger.info("Apache Unomi no longer available, as required service {} is shutdown !", (Object)serviceReference);
                this.shutdownMessageAlreadyDisplayed = true;
            }
            this.startupMessageAlreadyDisplayed = false;
        }
    }

    private void displayLogsForInactiveServices() {
        this.requiredServicesFilters.forEach(requiredServicesFilter -> {
            ServiceReference[] serviceReference = new ServiceReference[]{};
            String filterToString = requiredServicesFilter.toString();
            try {
                serviceReference = this.bundleContext.getServiceReferences((String)null, filterToString);
            }
            catch (InvalidSyntaxException e) {
                logger.error("Failed to get the service reference for {}", (Object)filterToString, (Object)e);
            }
            if (serviceReference == null) {
                logger.warn("No service found for the filter {}, some errors could happen when using the application", (Object)filterToString);
            }
        });
    }

    private void prepareGraphQLFeatureToInstall() {
        if (Boolean.parseBoolean(this.bundleContext.getProperty("org.apache.unomi.graphql.feature.activated"))) {
            this.featuresToInstall.add(CDP_GRAPHQL_FEATURE);
            this.requiredBundlesFromFeatures.put("org.apache.unomi.cdp-graphql-api-impl", false);
            this.requiredBundlesFromFeatures.put("org.apache.unomi.graphql-playground", false);
        }
    }

    public boolean shouldInstallAdditionalFeatures() {
        return !this.featuresToInstall.isEmpty();
    }

    private void installFeatures() {
        ArrayList installedFeatures = new ArrayList();
        this.featuresToInstall.forEach(value -> {
            try {
                long featureStartupTime = System.currentTimeMillis();
                if (!this.featuresService.isInstalled(this.featuresService.getFeature(value))) {
                    System.out.println("Installing feature " + value);
                    this.featuresService.installFeature(value, EnumSet.of(FeaturesService.Option.NoAutoRefreshManagedBundles, FeaturesService.Option.NoAutoRefreshUnmanagedBundles, FeaturesService.Option.NoAutoRefreshBundles));
                    logger.info("Feature {} successfully installed in {} ms", value, (Object)(System.currentTimeMillis() - featureStartupTime));
                }
                installedFeatures.add(value);
            }
            catch (Exception e) {
                logger.error("Error when installing {} feature", value, (Object)e);
            }
        });
        installedFeatures.forEach(value -> this.featuresToInstall.remove(value));
    }

    private TimerTask getBundleCheckTask() {
        return new TimerTask(){

            @Override
            public void run() {
                BundleWatcherImpl.this.displayLogsForInactiveBundles(BundleWatcherImpl.this.requiredBundles);
                BundleWatcherImpl.this.displayLogsForInactiveServices();
                BundleWatcherImpl.this.checkStartupComplete();
            }
        };
    }

    private TimerTask getAdditionalBundleCheckTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (BundleWatcherImpl.this.shouldInstallAdditionalFeatures() && !BundleWatcherImpl.this.installingFeatureStarted) {
                    BundleWatcherImpl.this.installingFeatureStarted = true;
                    BundleWatcherImpl.this.installFeatures();
                }
                BundleWatcherImpl.this.displayLogsForInactiveBundles(BundleWatcherImpl.this.requiredBundlesFromFeatures);
                BundleWatcherImpl.this.checkStartupComplete();
            }
        };
    }

    private void startScheduler(TimerTask timerTask) {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(timerTask, this.checkStartupStateRefreshInterval.intValue(), this.checkStartupStateRefreshInterval.intValue(), TimeUnit.SECONDS);
        }
    }

    private void destroyScheduler() {
        this.scheduledFuture.cancel(true);
        this.scheduledFuture = null;
    }

    private void checkStartupComplete() {
        if (!this.isStartupComplete()) {
            this.startScheduler(this.getBundleCheckTask());
            return;
        }
        if (this.scheduledFuture != null) {
            this.destroyScheduler();
        }
        if (!this.allAdditionalBundleStarted()) {
            this.startScheduler(this.getAdditionalBundleCheckTask());
            return;
        }
        if (this.scheduledFuture != null) {
            this.destroyScheduler();
        }
        if (!this.startupMessageAlreadyDisplayed) {
            long totalStartupTime = System.currentTimeMillis() - this.startupTime;
            List logoLines = this.serverInfos.get(this.serverInfos.size() - 1).getLogoLines();
            if (logoLines != null && !logoLines.isEmpty()) {
                logoLines.forEach(System.out::println);
            }
            System.out.println("--------------------------------------------------------------------------------------------");
            this.serverInfos.forEach(serverInfo -> {
                String versionMessage = MessageFormat.format(" {0} {1} ({2,date,yyyy-MM-dd HH:mm:ssZ} // {3} // {4} // {5}) ", StringUtils.rightPad((String)serverInfo.getServerIdentifier(), (int)12, (String)" "), serverInfo.getServerVersion(), serverInfo.getServerBuildDate(), serverInfo.getServerTimestamp(), serverInfo.getServerScmBranch(), serverInfo.getServerBuildNumber());
                System.out.println(versionMessage);
                logger.info(versionMessage);
            });
            System.out.println("--------------------------------------------------------------------------------------------");
            System.out.println("Server successfully started " + this.requiredBundles.size() + " bundles and " + this.requiredServicesFilters.size() + " required services in " + totalStartupTime + " ms");
            logger.info("Server successfully started {} bundles and {} required services in {} ms", new Object[]{this.requiredBundles.size(), this.requiredServicesFilters.size(), totalStartupTime});
            this.startupMessageAlreadyDisplayed = true;
            this.shutdownMessageAlreadyDisplayed = false;
        }
    }

    @Override
    public boolean isStartupComplete() {
        return this.allBundleStarted() && this.matchedRequiredServicesCount == (long)this.requiredServicesFilters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadLogo(Bundle bundle) {
        URL logoURL = bundle.getResource("unomi-logo.txt");
        if (logoURL != null) {
            ArrayList<String> logoLines = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(logoURL.openStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    logoLines.add(line);
                }
                ArrayList<String> arrayList = logoLines;
                return arrayList;
            }
            catch (IOException e) {
                logger.error("Error loading logo lines", (Throwable)e);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public ServerInfo getBundleServerInfo(Bundle bundle) {
        String serverIdentifier = "n/a";
        if (bundle.getHeaders().get("Implementation-ServerIdentifier") == null) {
            return null;
        }
        serverIdentifier = (String)bundle.getHeaders().get("Implementation-ServerIdentifier");
        List<String> logoLines = this.loadLogo(bundle);
        String buildNumber = "n/a";
        if (bundle.getHeaders().get("Implementation-Build") != null) {
            buildNumber = (String)bundle.getHeaders().get("Implementation-Build");
        }
        String timestamp = "n/a";
        Date buildDate = null;
        if (bundle.getHeaders().get("Implementation-TimeStamp") != null) {
            timestamp = (String)bundle.getHeaders().get("Implementation-TimeStamp");
            try {
                buildDate = new Date(Long.parseLong(timestamp));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String scmBranch = "n/a";
        if (bundle.getHeaders().get("Implementation-ScmBranch") != null) {
            scmBranch = (String)bundle.getHeaders().get("Implementation-ScmBranch");
        }
        if (bundle.getHeaders().get("Implementation-UnomiEventTypes") != null) {
            // empty if block
        }
        if (bundle.getHeaders().get("Implementation-UnomiCapabilities") != null) {
            // empty if block
        }
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setServerIdentifier(serverIdentifier);
        serverInfo.setServerVersion(bundle.getVersion().toString());
        serverInfo.setServerBuildNumber(buildNumber);
        serverInfo.setServerBuildDate(buildDate);
        serverInfo.setServerTimestamp(timestamp);
        serverInfo.setServerScmBranch(scmBranch);
        if (logoLines != null) {
            serverInfo.setLogoLines(logoLines);
        }
        return serverInfo;
    }
}

